﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_UserManager_UserEditNewUser : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        //清除缓存
        Response.Expires = 0;
        Response.AddHeader("pragma", "on-cache");
        Response.AddHeader("Cache-Control", "no-cache, must-revalidate");
        if (!IsPostBack)
        {
            ProvinceBind();
            MemberGroupBind();
            BindUser();
        }
    }
    protected void btnSave_Click(object sender, EventArgs e)
    {
        if (Request["UserName"] != null)
        {
                MembershipUser user = Membership.GetUser(Request["UserName"].ToString());
                ProfileCommon p = Profile.GetProfile(user.UserName);
                p.NickName = txtNickName.Text;
                user.Email = txtEmail.Text;
                p.MemberGroup = int.Parse(ddlMemberGroup.SelectedValue);
                p.Rating = int.Parse(ddlRating.SelectedValue);
                p.QQ = txtQQ.Text;
                p.Birthday = dropYear.SelectedValue + "-" + dropMonth.SelectedValue + "-" + dropDay.SelectedValue;
                p.Address = dropProvince.SelectedValue + "," + dropCity.SelectedValue + "," + dropArea.SelectedValue;
                p.Sex = rdbSex.SelectedValue;
                p.Score = int.Parse(txtScore.Text);
                p.IsLoked = bool.Parse(rdbLocked.SelectedValue);
                p.PostCount = int.Parse(txtPostCount.Text);
                Membership.UpdateUser(user);
                p.Save();
                Response.Write("<script>alert('更新成功！');</script>");
        }
    }
    public void BindUser()
    {
        if (Request["UserName"] != null)
        {
            MembershipUser user = Membership.GetUser(Request["UserName"].ToString());
            ProfileCommon p = Profile.GetProfile(user.UserName);
            txtUserName.Text = p.UserName;
            txtNickName.Text = p.NickName;
            ddlMemberGroup.SelectedValue = p.MemberGroup.ToString();
            ddlRating.SelectedValue = p.Rating.ToString();
            txtEmail.Text = user.Email;
            txtQQ.Text = p.QQ;
            string[] s = p.Birthday.Split('-');
            dropYear.Text = s[0].ToString();
            dropMonth.Text = s[1].ToString();
            dropDay.Text = s[2].ToString();
            string[] a = p.Address.Split(',');
            CityBind(Convert.ToInt32(a[0]));
            AreaBind(Convert.ToInt32(a[1]));
            dropProvince.SelectedValue = a[0].ToString();
            dropCity.SelectedValue = a[1].ToString();
            dropArea.SelectedValue = a[2].ToString();
            rdbSex.SelectedValue = p.Sex;
            txtScore.Text = p.Score.ToString();
            rdbLocked.SelectedValue = p.IsLoked.ToString();
            txtPostCount.Text = p.PostCount.ToString();
        }
    }
    public void MemberGroupBind()
    {
        common.DropDownListBind(ddlMemberGroup, "MemberGroupName", "MemberGroupId", SqlHelper.connectionString,CommandType.StoredProcedure, "Tengfei_SelectAllMemberGroup");
    }
    public void AreaBind(int cityId)
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = cityId;
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId", parm);
    }
    public void CityBind(int provinceId)
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = provinceId;
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId", parm);
    }
    public void ProvinceBind()
    {
        common.DropDownListBind(dropProvince, "province", "provinceID", SqlHelper.connectionString,CommandType.StoredProcedure, "Tengfei_SelectProvince");
    }
    protected void dropProvince_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@ProvinceId", SqlDbType.Int);
        parm.Value = int.Parse(dropProvince.SelectedValue);
        common.DropDownListBind(dropCity, "city", "cityID", SqlHelper.connectionString,CommandType.StoredProcedure, "Tengfei_SelectCityByProvinceId", parm);
    }
    protected void dropCity_SelectedIndexChanged(object sender, EventArgs e)
    {
        SqlParameter parm = new SqlParameter("@CityId", SqlDbType.Int);
        parm.Value = int.Parse(dropCity.SelectedValue);
        common.DropDownListBind(dropArea, "area", "areaID", SqlHelper.connectionString,CommandType.StoredProcedure, "Tengfei_SelectAreaByCityId", parm);
    }
}
