﻿using System;
using System.Data;
using System.Configuration;
using System.Collections.Generic;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Data.SqlClient;
using DBUtility;

public partial class Controls_UserMemberGroup : System.Web.UI.UserControl
{
    IBLL.IMemberGroup iMemberGroup = BLLFactory.BusinessLogic.CreateMemberGroup();
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    getMemberGroup();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
        }
    }

    //根据分页查询数据绑定DataView();
    public void getMemberGroup()
    {
        Pager.RecordCount = Convert.ToInt32(SqlHelper.ExecuteScalar(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_GetMemberGroupCount", null));
        Model.PagerParameter pagers = new Model.PagerParameter(Pager.StartRecordIndex, Pager.EndRecordIndex, false);
        IList<Model.MemberGroup> memberGroup = iMemberGroup.GetAllMemberGroup(pagers);
        gvMemberGroup.DataSource = memberGroup;
        gvMemberGroup.DataBind();
        Pager.CustomInfoHTML = "记录总数：<font color=\"blue\"><b>" + Pager.RecordCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  总页数：<font color=\"blue\"><b>" + Pager.PageCount.ToString() + "</b></font>";
        Pager.CustomInfoHTML += "  当前页：<font color=\"red\"><b>" + Pager.CurrentPageIndex.ToString() + "</b></font>";
    }

    //分页
    protected void Pager_PageChanging(object src, Wuqi.Webdiyer.PageChangingEventArgs e)
    {
        Pager.CurrentPageIndex = e.NewPageIndex;
        getMemberGroup();
    }

    protected void lkbDelete_Command(object sender, CommandEventArgs e)
    {
        int memberGroupId = Convert.ToInt32(e.CommandArgument);
        SqlParameter parm = new SqlParameter("@MemberGroupId", SqlDbType.Int);
        parm.Value = memberGroupId;
        int i = SqlHelper.ExecuteNonQuery(SqlHelper.connectionString, CommandType.StoredProcedure, "Tengfei_DeleteMemberGroup", parm);
        getMemberGroup();
    }
    protected void gvMemberGroup_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
}
