﻿using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;


public partial class Controls_UserNewUser : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (Request["id"] != null)
        {
            ViewState["id"] = Request["id"].ToString();
        }
        if (!IsPostBack)
        {
            if (Session["UserName"] != null)
            {
                ProfileCommon p = Profile.GetProfile(Session["UserName"].ToString());
                ViewState["role"] = common.GetAuthorityName(p.Rating);
                if (ViewState["role"].ToString() == "系统管理员")
                {
                    Bind();
                }
                else
                {
                    Response.Redirect("/TengfeiWeb/BookManager/Sorry.aspx");
                }
            }
            else
            {
                Response.Redirect("/TengfeiWeb/Clientele/SessionOut.aspx");
            }
            
        }
    }
    public void Bind()
    {
        if (Request["id"] == null)
        {
            gvNewUser.DataSource = GetAllUser();
            gvNewUser.DataBind();
        }
        else
        {
            gvNewUser.DataSource = GetUserById(Convert.ToInt32(ViewState["id"]));
            gvNewUser.DataBind();
        }
    }
    public DataTable GetAllUser()
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("UserName",Type.GetType("System.String"));
        dt.Columns.Add("NickName", Type.GetType("System.String"));
        dt.Columns.Add("IsLoked", Type.GetType("System.String"));
        dt.Columns.Add("MemberGroup",Type.GetType("System.Int32"));
        dt.Columns.Add("Rating", Type.GetType("System.Int32"));
        dt.Columns.Add("QQ", Type.GetType("System.String"));
        dt.Columns.Add("LoginCount",Type.GetType("System.Int32"));
        dt.Columns.Add("LastLoginDate",Type.GetType("System.DateTime"));
        
        MembershipUserCollection mu = Membership.GetAllUsers();
        foreach (MembershipUser user in mu)
        {
            DataRow dr = dt.NewRow();
            ProfileCommon p = Profile.GetProfile(user.UserName);
            dr[0] = p.UserName;  //用户帐号
            dr[1] = p.NickName;  //用户昵称
            dr[2] = IsLoked(p.IsLoked);//是否锁定
            dr[3] = p.MemberGroup;//会员组
            dr[4] = p.Rating;     //等级
            dr[5] = p.QQ;         //QQ
            dr[6] = p.LoginCount; //登陆次数
            dr[7] = user.LastLoginDate;//上次登陆时间
            dt.Rows.Add(dr);      //将行添加到表中
        }
        dt.AcceptChanges();   //保存数据
        return dt;            //返回DataTable对象 
    }
    public DataTable GetUserById(int id)
    {
        DataTable dt = new DataTable();
        dt.Columns.Add("UserName", Type.GetType("System.String"));
        dt.Columns.Add("NickName", Type.GetType("System.String"));
        dt.Columns.Add("IsLoked", Type.GetType("System.String"));
        dt.Columns.Add("MemberGroup", Type.GetType("System.Int32"));
        dt.Columns.Add("Rating", Type.GetType("System.Int32"));
        dt.Columns.Add("QQ", Type.GetType("System.String"));
        dt.Columns.Add("LoginCount", Type.GetType("System.Int32"));
        dt.Columns.Add("LastLoginDate", Type.GetType("System.DateTime"));

        MembershipUserCollection mu = Membership.GetAllUsers();
        foreach (MembershipUser user in mu)
        {
            
           
            ProfileCommon p = Profile.GetProfile(user.UserName);
            if (p.MemberGroup == id)
            {
                DataRow dr = dt.NewRow();
                dr[0] = p.UserName;  //用户帐号
                dr[1] = p.NickName;  //用户昵称
                dr[2] = IsLoked(p.IsLoked);//是否锁定
                dr[3] = p.MemberGroup;//会员组
                dr[4] = p.Rating;     //等级
                dr[5] = p.QQ;         //QQ
                dr[6] = p.LoginCount; //登陆次数
                dr[7] = user.LastLoginDate;//上次登陆时间
                dt.Rows.Add(dr);      //将行添加到表中
            }
        }
        dt.AcceptChanges();   //保存数据
        return dt;            //返回DataTable对象
    }
    //返回String类型判断是否被锁定
    public string IsLoked(bool i)
    {
        string isLoked = "";
        if (i == true)
            isLoked = "已锁定";
        else
            isLoked = "正常";
        return isLoked;
    }
    public string GetMemberGroupName(int memberGroupId)
    {
        return common.GetMemberGroupName(memberGroupId);
    }
    public string GetRatingName(int ratingId)
    {
        return common.GetAuthorityName(ratingId);
    }
    protected void lkbDelete_Command(object sender, CommandEventArgs e)
    {
        string userName = e.CommandArgument.ToString();
        Membership.DeleteUser(userName);
        Bind();  
    }
    protected void lkbLocked_Command(object sender, CommandEventArgs e)
    {
        string userName = e.CommandArgument.ToString();
        ProfileCommon p = Profile.GetProfile(userName);
        p.IsLoked = true;
        p.Save();
        Bind();
    }
    protected void lkbLockOut_Command(object sender, CommandEventArgs e)
    {
        string userName = e.CommandArgument.ToString();
        ProfileCommon p = Profile.GetProfile(userName);
        p.IsLoked = false;
        p.Save();
        Bind();
    }
    protected void gvNewUser_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        gvNewUser.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void gvNewUser_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        e.Row.Cells[0].Attributes.Add("style", "text-align:left");
        if (e.Row.RowType == DataControlRowType.DataRow)
        {
            //鼠标放在上面变色
            e.Row.Attributes.Add("onmouseover", "c=this.style.backgroundColor;this.style.backgroundColor='#E1E1E1';this.style.cursor='hand';");
            //鼠标离开变回原色
            e.Row.Attributes.Add("onmouseout", "this.style.backgroundColor=c");
        }
    }
    protected void lkbUpdatePassword_Command(object sender, CommandEventArgs e)
    {
        Response.Write("<script language=javascript>window.open('UpdatePassWord.aspx?UserName=" + e.CommandArgument.ToString() + "','newwindow', 'height=200, width=355, top=200, left=350, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no,status=no') </script>");
    }
    protected void lkbEdit_Command(object sender, CommandEventArgs e)
    {
        Response.Write("<script language=javascript>window.open('EditNewUser.aspx?UserName=" + e.CommandArgument.ToString() + "','newwindow', 'height=500, width=500, top=150, left=350, toolbar=no, menubar=no, scrollbars=no, resizable=no,location=no,status=no') </script>");
    }
}
