<%
'截字符串，汉字一个算两个字符，英文算一个字符
Function GetSubStr(Str, StrLen, bShowPoint)
    If Str = "" Or IsNull(Str) Then
       GetSubStr = ""
       Exit Function
    End If
	
    Dim L, T, C, I, StrTemp
    Str = Replace(Replace(Replace(Replace(Str, "&nbsp;", " "), "&quot;", Chr(34)), "&gt;", ">"), "&lt;", "<")
    L = Len(Str)
    T = 0
    StrTemp = Str
    StrLen = NRF_CLng(StrLen)
    For I = 1 To L
        C = Abs(AscW(Mid(Str, I, 1)))
        If C > 255 Then
           T = T + 2
        Else
           T = T + 1
        End If
        If T >= StrLen Then
           StrTemp = Left(Str, I)
           Exit For
        End If
    Next
    Str = Replace(Replace(Replace(Replace(Str, " ", "&nbsp;"), Chr(34), "&quot;"), ">", "&gt;"), "<", "&lt;")
    StrTemp = Replace(Replace(Replace(Replace(StrTemp, " ", "&nbsp;"), Chr(34), "&quot;"), ">", "&gt;"), "<", "&lt;")
    If StrTemp <> Str And bShowPoint = True Then
       StrTemp = StrTemp & "…"
    End If
	
    GetSubStr = StrTemp
End Function


'求字符串长度。汉字算两个字符，英文算一个字符。
Function GetStrLen(Str)
    On Error Resume Next
    Dim WINNT_CHINESE
    WINNT_CHINESE = (Len("中国") = 2)
    If WINNT_CHINESE Then
        Dim I, L, T, C
        L = Len(Str)
        T = L
        For I = 1 To L
            C = Asc(Mid(Str, I, 1))
            If C < 0 Then C = C + 65536
            If C > 255 Then
               T = T + 1
            End If
        Next
        GetStrLen = T
    Else
        GetStrLen = Len(Str)
    End If
    If Err.Number <> 0 Then Err.Clear
End Function


'高亮显示关键字
Function HighLightShow(StrChar, StrKey)
    If StrChar = "" Or IsNull(StrChar) Then
       HighLightShow = ""
       Exit Function
    End If 
		  
    Dim TempChar
	If StrKey <> "" and Not IsNull(StrKey) Then
	   Dim ArrKey, I 
       ArrKey = Split(StrKey, "|")'用|隔开的多关键字 
       For I = 0 To UBound(ArrKey) 
           RegEx.Pattern = "(" & ArrKey(I) & ")" 
           TempChar = RegEx.Replace(StrChar, "<span style=""background: #FF0;"">$1</span>" )  
       Next
	Else
	   TempChar = StrChar
	End If
		 
    HighLightShow = TempChar  
End Function 

'过滤html元素
Function NoHtml(fString)
    If Trim(fString) = "" Or IsNull(fString) Then
       NoHtml = ""
	   Exit Function
    End If

    RegEx.Pattern = "(\<.[^\<]*\>)"
    fString = RegEx.Replace(fString, " ")
    RegEx.Pattern = "(\<\/[^\<]*\>)"
    fString = RegEx.Replace(fString, " ")
    fString = Replace(fString, "'", "")
    fString = Replace(fString, Chr(10), "") '换行符
	fString = Replace(fString, Chr(13), "") '回车符
	fString = Replace(fString, Chr(32), "") '空格
	fString = Replace(fString, Chr(34), "") '双引号
	fString = Replace(fString, vbCrLf, "")
	
    NoHtml = fString
End Function


'将html 标记替换成 能在IE显示的HTML
Function NRF_HtmlEncode(fString)
    If Trim(fString) = "" Or IsNull(fString) Then
       NRF_HtmlEncode = ""
       Exit Function
    End If
    
	fString = Replace(fString, ">", "&gt;")
	fString = Replace(fString, "<", "&lt;")
	fString = Replace(fString, Chr(32), "&nbsp;")
	fString = Replace(fString, Chr(9), "&nbsp;")
	fString = Replace(fString, Chr(34), "&quot;")
	fString = Replace(fString, Chr(39), "&#39;")
	fString = Replace(fString, Chr(13), "")
	fString = Replace(fString, Chr(10) & Chr(10), "</p><p>")
	fString = Replace(fString, Chr(10), "<br>")

    NRF_HtmlEncode = fString
End Function


'还原Html标记,配合NRF_HtmlEncode 使用
Function NRF_HtmlDecode(fString)
	If Trim(fString) = "" Or IsNull(fString) Then
       NRF_HtmlDecode = ""
       Exit Function
    End If
		 
	fString = Replace(fString, "&gt;", ">")
	fString = Replace(fString, "&lt;", "<")
	fString = Replace(fString, "&nbsp;", "　")
	fString = Replace(fString, "&quot;", Chr(34))
	fString = Replace(fString, "&#39;", Chr(39))
	fString = Replace(fString, "</p><p> ", Chr(10) & Chr(10))
	fString = Replace(fString, "<br> ", Chr(10))

	NRF_HtmlDecode = fString
End Function


'容错替换
Function NRF_Replace(Expression, StrFind, ReplaceWith)
    If IsNull(Expression) Or IsNull(StrFind) Then
       NRF_Replace = Expression
    ElseIf IsNull(ReplaceWith) Then
       NRF_Replace = Replace(Expression, StrFind, "")
    Else
       NRF_Replace = Replace(Expression, StrFind, ReplaceWith)
    End If
End Function


'替换字符，大小写不敏感
Function Replace_CaseInsensitive(Expression, StrFind, ReplaceWith)
	RegEx.Pattern = StrFind
    Replace_CaseInsensitive = RegEx.Replace(Expression, ReplaceWith)
End Function


'过滤非法的SQL字符
Function ReplaceBadChar(StrChar)
    If Trim(StrChar) = "" Or IsNull(StrChar) Then
       ReplaceBadChar = ""
       Exit Function
    End If
         
	Dim StrBadChar, ArrBadChar, TempChar, I
    StrBadChar = "+,',%,^,&,?,(,),<,>,[,],{,},/,\,;,:," & Chr(34) & "," & Chr(0) & ",--"
    ArrBadChar = Split(StrBadChar, ",")
    TempChar = StrChar
    For I = 0 To UBound(ArrBadChar)
        TempChar = Replace(TempChar, ArrBadChar(I), "")
    Next 
    TempChar = Replace(TempChar, "@@", "@")
	
	ReplaceBadChar = TempChar
End Function


'过滤Url中非法的SQL字符
Function ReplaceUrlBadChar(StrChar)
    If Trim(StrChar) = "" Or IsNull(StrChar) Then
       ReplaceUrlBadChar = ""
       Exit Function
    End If
		 
    Dim StrBadChar, ArrBadChar, TempChar, I
    StrBadChar = "+,',(,),<,>,[,],{,},\,;," & Chr(34) & "," & Chr(0) & ",--"
    ArrBadChar = Split(StrBadChar, ",")
    TempChar = StrChar
    For I = 0 To UBound(ArrBadChar)
        TempChar = Replace(TempChar, ArrBadChar(I), "")
    Next
    TempChar = Replace(TempChar, "@@", "@")
		 
    ReplaceUrlBadChar = TempChar
End Function


'过滤数组空字符
Function FilterArrNull(ArrString, CompartString)
    If IsNull(ArrString) = "" Or IsNull(CompartString) = "" Then
       FilterArrNull = ArrString
       Exit Function
    End If
	
	Dim ArrContent, ArrTemp, I
    If InStr(ArrString, CompartString) = 0 Then
       FilterArrNull = ArrString
       Exit Function
    Else
       ArrContent = Split(ArrString, CompartString)
       For I = 0 To UBound(ArrContent)
           If Trim(ArrContent(I)) <> "" Then
              If ArrTemp = "" Then
                 ArrTemp = Trim(ArrContent(I))
              Else
                 ArrTemp = ArrTemp & CompartString & Trim(ArrContent(I))
              End If
           End If
       Next
    End If
		 
    FilterArrNull = ArrTemp
End Function


'过滤非法JS字符
Function FilterJS(StrInput)
    If Trim(StrInput) = "" Or IsNull(StrInput) Then
       FilterJS = ""
       Exit Function
    End If
	
    '替换掉HTML字符实体(Character Entities)名字和分号之间的空白字符，比如：&auml    ;替换成&auml;
    RegEx.Pattern = "(&#*\w+)[\x00-\x20]+;"
    StrInput = RegEx.Replace(StrInput, "$1;")

    '将无分号结束符的数字编码实体规范成带分号的标准形式
    RegEx.Pattern = "(&#x*[0-9A-F]+);*"
    StrInput = RegEx.Replace(StrInput, "$1;")

    '将&nbsp; &lt; &gt; &amp; &quot;字符实体中的 & 替换成 &amp; 以便在进行HtmlDecode时保留这些字符实体
    'RegEx.Pattern = "&(amp|lt|gt|nbsp|quot);"
    'StrInput = RegEx.Replace(StrInput, "&amp;$1;")

    '将HTML字符实体进行解码，以消除编码字符对后续过滤的影响
    'StrInput = HtmlDecode(StrInput);

    '将ASCII码表中前32个字符中的非打印字符替换成空字符串，保留 9、10、13、32，它们分别代表 制表符、换行符、回车符和空格。
    RegEx.Pattern = "[\x00-\x08\x0b-\x0c\x0e-\x19]"
    StrInput = RegEx.Replace(StrInput, "")  
       
    OldHtmlString = ""
    Do While OldHtmlString <> StrInput
        OldHtmlString = StrInput
        RegEx.Pattern = "(<[^>]+src[\x00-\x20]*=[\x00-\x20]*[^>]*?)&#([^>]*>)"  '过虑掉 src 里的 &#
        StrInput = RegEx.Replace(StrInput, "$1&amp;#$2")
        RegEx.Pattern = "(<[^>]+style[\x00-\x20]*=[\x00-\x20]*[^>]*?)&#([^>]*>)"  '过虑掉style 里的 &#
        StrInput = RegEx.Replace(StrInput, "$1&amp;#$2")
        RegEx.Pattern = "(<[^>]+style[\x00-\x20]*=[\x00-\x20]*[^>]*?)\\([^>]*>)"   '替换掉style中的 "\" 
        StrInput = RegEx.Replace(StrInput, "$1/$2")  
    Loop
    
	'替换以on和xmlns开头的属性，动易系统的几个JS需要保留
    RegEx.Pattern = "on(load\s*=\s*""*'*resizepic\(this\)'*""*)"
    StrInput = RegEx.Replace(StrInput, "off$1")
    
	RegEx.Pattern = "on(mousewheel\s*=\s*""*'*return\s*bbimg\(this\)'*""*)"
    StrInput = RegEx.Replace(StrInput, "off$1")

    RegEx.Pattern = "(<[^>]+[\x00-\x20""'/])(on|xmlns)([^>]*)>"
    StrInput = RegEx.Replace(StrInput, "$1pe$3>")

    RegEx.Pattern = "off(load\s*=\s*""*'*resizepic\(this\)'*""*)"
    StrInput = RegEx.Replace(StrInput, "on$1")
	
    RegEx.Pattern = "off(mousewheel\s*=\s*""*'*return\s*bbimg\(this\)'*""*)"
    StrInput = RegEx.Replace(StrInput, "on$1")
    
    '替换javascript
    RegEx.Pattern = "([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`'""]*)[\x00-\x20]*j[\x00-\x20]*a[\x00-\x20]*v[\x00-\x20]*a[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:"
    StrInput = RegEx.Replace(StrInput, "$1=$2nojavascript...")

    '替换vbscript
    RegEx.Pattern = "([a-z]*)[\x00-\x20]*=[\x00-\x20]*([`'""]*)[\x00-\x20]*v[\x00-\x20]*b[\x00-\x20]*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:"
    StrInput = RegEx.Replace(StrInput, "$1=$2novbscript...")

    '替换style中的注释部分，比如：<div style="xss:expres/*comment*/sion(alert(x))">
    RegEx.Pattern = "(<[^>]+style[\x00-\x20]*=[\x00-\x20]*[^>]*?)/\*[^>]*\*/([^>]*>)"
    StrInput = RegEx.Replace(StrInput, "$1$2")
	
    '替换expression
    RegEx.Pattern = "(<[^>]+)style[\x00-\x20]*=[\x00-\x20]*([`'""]*).*[eｅＥ][xｘＸ][pｐＰ][rｒＲ][eｅＥ][sｓＳ][sｓＳ][iｉＩ][oｏＯ][nｎＮ][\x00-\x20]*[\(\（][^>]*>"
    StrInput = RegEx.Replace(StrInput, "$1>")

    '替换behaviour
    RegEx.Pattern = "(<[^>]+)style[\x00-\x20]*=[\x00-\x20]*([`'""]*).*behaviour[^>]*>>"
    StrInput = RegEx.Replace(StrInput, "$1>")
	
    '替换behavior
    RegEx.Pattern = "(<[^>]+)style[\x00-\x20]*=[\x00-\x20]*([`'""]*).*behavior[^>]*>>"
    StrInput = RegEx.Replace(StrInput, "$1>")

    '替换script
    RegEx.Pattern = "(<[^>]+)style[\x00-\x20]*=[\x00-\x20]*([`'""]*).*s[\x00-\x20]*c[\x00-\x20]*r[\x00-\x20]*i[\x00-\x20]*p[\x00-\x20]*t[\x00-\x20]*:*[^>]*>"
    StrInput = RegEx.Replace(StrInput, "$1>")

    '替换namespaced elements不需要
    RegEx.Pattern = "</*\w+:\w[^>]*>"
    StrInput = RegEx.Replace(StrInput, "　")

    Dim OldHtmlString
    OldHtmlString = ""
    Do While OldHtmlString <> StrInput
        OldHtmlString = StrInput
        '实行严格过滤
        RegEx.Pattern = "</*(applet|meta|xml|blink|link|style|script|embed|object|iframe|frame|frameset|ilayer|layer|bgsound|title|base)[^>]*>?"
        StrInput = RegEx.Replace(StrInput, "　")
        '过滤掉SHTML的Include包含文件漏洞
        RegEx.Pattern = "<!--\s*#include[^>]*>"
        StrInput = RegEx.Replace(StrInput, "noshtml")
        'If FilterLevel > 0 Then
        '   '实行严格过滤
        '   RegEx.Pattern = "</*(embed|object)[^>]*>"
        '   StrInput = RegEx.Replace(StrInput, "")
        'End If
    Loop
		 
    FilterJS = StrInput
End Function


'检查一个数组中所有元素是否包含指定字符串
Function FoundInArr(StrArr, StrToFind, StrSplit)
    Dim ArrTemp, I
    FoundInArr = False
         
	If InStr(StrArr, StrSplit) > 0 Then
       ArrTemp = Split(StrArr, StrSplit)
       For I = 0 To UBound(ArrTemp)
           If LCase(Trim(ArrTemp(I))) = LCase(Trim(StrToFind)) Then
              FoundInArr = True
              Exit For
           End If
       Next
    Else
       If LCase(Trim(StrArr)) = LCase(Trim(StrToFind)) Then
          FoundInArr = True
       End If
    End If
End Function


'检查是否包含非法的SQL字符
Function CheckBadChar(StrChar)
    If Trim(StrChar) = "" Or IsNull(StrChar) Then
       CheckBadChar = False
       Exit Function
    End If
		 
    Dim StrBadChar, ArrBadChar, I
    StrBadChar = "@@,+,',%,^,&,?,(,),<,>,[,],{,},/,\,;,:," & Chr(34) & ",--"
    ArrBadChar = Split(StrBadChar, ",")
    For I = 0 To UBound(ArrBadChar)
        If InStr(StrChar, ArrBadChar(I)) > 0 Then
           CheckBadChar = False
           Exit Function
        End If
    Next
		 
    CheckBadChar = True
End Function


'检查传过来的ＩＤ是否是合法ＩＤ或者ＩＤ串
Function IsValidID(CheckID)
    If CheckID = "" Or IsNull(CheckID) Then
       IsValidID = False
       Exit Function
    End If
		 
    Dim FixID, I
	FixID = Replace(CheckID, "|", "")
    FixID = Replace(FixID, ",", "")
    FixID = Replace(FixID, "-", "")
    FixID = Trim(Replace(FixID, " ", ""))
    If FixID = "" Or IsNull(FixID) Then
       IsValidID = False
    Else
       For I = 1 To Len(FixID) Step 100
           If Not IsNumeric(Mid(FixID, I, 100)) Then
              IsValidID = False
              Exit Function
           End If
       Next
       IsValidID = True
    End If
End Function


'检查字符是否在有效范围内
Function IsValidStr(ByVal Str)
    Dim I, C
    For I = 1 To Len(Str)
        C = LCase(Mid(Str, I, 1))
        If InStr("abcdefghijklmnopqrstuvwxyz1234567890-", C) <= 0 Then
           IsValidStr = False
           Exit Function
        End If
    Next
    If IsNumeric(Left(Str, 1)) Then
       IsValidStr = False
    Else
       IsValidStr = True
    End If
End Function


'网址检测
Function IsValidUrl(StrUrl)
	RegEx.Pattern = "^http://[_a-zA-Z0-9-]+(.[_a-zA-Z0-9-]+)*$"
    IsValidUrl = RegEx.Test(StrUrl)
End Function


'域名检测
Function IsValidDomain(StrUrl)
	RegEx.Pattern = "^([A-Za-z0-9-]+\.)([A-Za-z0-9-]+\.)(com)|(net)|(org)|(mobi)|(ac)|(la)|(io)|(gov\.cn)|(ac\.cn)|(bj\.cn)|(sh\.cn)|(tj\.cn)|(cq\.cn)|(sx\.cn)|(nm\.cn)|(ln\.cn)|(jl\.cn)|(hl\.cn)|(js\.cn)|(zj\.cn)|(ah\.cn)|(fj\.cn)|(hn\.cn)|(jx\.cn)|(sd\.cn)|(ha\.cn)|(hb\.cn)|(gd\.cn)|(gx\.cn)|(hi\.cn)|(sc\.cn)|(gz\.cn)|(yn\.cn)|(xz\.cn)|(sn\.cn)|(gs\.cn)|(qh\.cn)|(nx\.cn)|(xj\.cn)|(tw\.cn)|(hk\.cn)|(mo)|(mo\.cn)|(tw\.cn)|(com\.tw)|(idv\.tw)|(org\.tw)|(hk)|(com\.hk)|(travel)|(info)|(cc)|(com\.cn)|(net\.cn)|(org\.cn)|(name)|(biz)|(tv)|(cn)|(tw)|(sh)|(us)|(uk)|(li)|(it)|(kr)|(com\.kr)|(int)$"
    IsValidDomain = RegEx.Test(StrUrl)
End Function


'检查Email地址的合法性
Function IsValidEmail(StrEmail)
    RegEx.Pattern = "^\w+((-\w+)|(\.\w+))*\@[A-Za-z0-9]+((\.|-)[A-Za-z0-9]+)*\.[A-Za-z0-9]+$"
    IsValidEmail = RegEx.Test(StrEmail)
End Function


'检查IP地址的合法性
Function IsValidIP(IPStr)
    RegEx.Pattern = "^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$"
    IsValidIP = RegEx.Test(IPStr)
End Function


'将IP地址转为数字
Function EncodeIP(Sip)
    Dim StrIP
    StrIP = Split(Sip, ".")
    If UBound(StrIP) < 3 Then
       EncodeIP = 0
       Exit Function
    End If
    If IsNumeric(StrIP(0)) = False Or IsNumeric(StrIP(1)) = False Or IsNumeric(StrIP(2)) = False Or IsNumeric(StrIP(3)) = False Then
       EncodeIP = 0
    Else
       EncodeIP = CLng(StrIP(0)) * 256 * 256 * 256 + CLng(StrIP(1)) * 256 * 256 + CLng(StrIP(2)) * 256 + CLng(StrIP(3)) - 1
    End If
End Function


'将数字转为IP地址
Function DecodeIP(Sip)
    Dim S1, S21, S2, S31, S3, S4
    Sip = Sip + 1
    S1 = Int(Sip / 256 / 256 / 256)
    S21 = S1 * 256 * 256 * 256
    S2 = Int((Sip - S21) / 256 / 256)
    S31 = s2 * 256 * 256 + S21
    S3 = Int((Sip - S31) / 256)
    S4 = Sip - S3 * 256 - S31
		 
    DecodeIP = CStr(S1) + "." + CStr(S2) + "." + CStr(S3) + "." + CStr(S4)
End Function


'得到多少位数的随机函数
Function GetRanNum(RandLen,ShowType)
    'On Error Resume Next
    RandLen = CInt(RandLen)
    ShowType = CInt(ShowType)
	'If Err Then Err.Clear : GetRanNum = "GetRanNum参数错误！" : Exit Function
		 
	Dim RandChar,RandCharArr,RandStr,I
	Select Case ShowType
	       Case 1 : RandChar = "0,1,2,3,4,5,6,7,8,9"
	       Case 2 : RandChar = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z"
	       Case 3 : RandChar = "0,1,2,3,4,5,6,7,8,9,A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z"
	End Select
	RandCharArr = Split(RandChar,",")
	
    Randomize
	For I = 1 To RandLen
	    Select Case ShowType
	           Case 1 : RandStr = RandStr & RandCharArr(Int((10 * Rnd)))
	           Case 2 : RandStr = RandStr & RandCharArr(Int((26 * Rnd)))
		       Case 3 : RandStr = RandStr & RandCharArr(Int((36 * Rnd)))
		End Select
	Next
	
	GetRanNum = RandStr
End Function


'向地址中加入 ? 或 &
Function JoinChar(StrUrl)
    If StrUrl = "" Or IsNull(StrUrl) Then
       JoinChar = ""
	   Exit Function
    End If
         
	If InStr(StrUrl, "?") < Len(StrUrl) Then
       If InStr(StrUrl, "?") > 1 Then
          If InStr(StrUrl, "&") < Len(StrUrl) Then
             JoinChar = StrUrl & "&"
          Else
             JoinChar = StrUrl
          End If
       Else
          JoinChar = StrUrl & "?"
       End If
    Else
      JoinChar = StrUrl
    End If
End Function


'分页函数
Function ShowPage(StrFileName, TotalNumber, MaxPerPage, CurrentPage, ShowTotal, ShowMaxPerPage, ShowAllPages, StrUnit)
    Dim TotalPage, StrTemp, StrUrl, I

    If TotalNumber = 0 Or MaxPerPage = 0 Or IsNull(MaxPerPage) Then
       ShowPage = "" : Exit Function
    End If
    If TotalNumber Mod MaxPerPage = 0 Then
       TotalPage = TotalNumber \ MaxPerPage
    Else
       TotalPage = TotalNumber \ MaxPerPage + 1
    End If
    If CurrentPage > TotalPage Then CurrentPage = TotalPage
    
    If ShowTotal = True Then
       StrTemp = StrTemp & "共 <strong style=""color: #087ACF;"">" & TotalNumber & "</strong> " & StrUnit & "&nbsp;"
    End If
    If ShowMaxPerPage = True Then
       StrUrl = JoinChar(StrFileName) & "MaxPerPage=" & MaxPerPage & "&"
    Else
       StrUrl = JoinChar(StrFileName)
    End If
	
    If CurrentPage = 1 Then
       StrTemp = StrTemp & "首页 上一页&nbsp;"
    Else
       StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=1"">首页</a>&nbsp;"
       StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & (CurrentPage - 1) & """>上一页</a>&nbsp;"
    End If

    If ShowAllPages = True Then
       Dim JmaxPages
       If (CurrentPage - 4) <= 0 Or TotalPage < 9 Then
          JmaxPages = 1
          Do While (JmaxPages < 9)
             If JmaxPages = CurrentPage Then
                StrTemp = StrTemp & "<strong style=""color: #FF0000;"">" & JmaxPages & "</strong> "
             Else
                If StrUrl <> "" Then
                   StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & JmaxPages & """>" & JmaxPages & "</a> "
                End If
             End If
             If JmaxPages = TotalPage Then Exit Do
             JmaxPages = JmaxPages + 1
          Loop
       ElseIf (CurrentPage + 4) >= TotalPage Then
          JmaxPages = TotalPage - 7
          Do While (JmaxPages <= TotalPage)
             If JmaxPages = CurrentPage Then
                StrTemp = StrTemp & "<strong style=""color: #FF0000;"">" & JmaxPages & "</strong> "
             Else
                If StrUrl <> "" Then
                   StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & JmaxPages & """>" & JmaxPages & "</a> "
                End If
             End If
             JmaxPages = JmaxPages + 1
          Loop
       Else
          JmaxPages = CurrentPage - 4
          Do While (JmaxPages < CurrentPage + 4)
             If JmaxPages = CurrentPage Then
                StrTemp = StrTemp & "<strong style=""color: #FF0000;"">" & JmaxPages & "</strong> "
             Else
                If StrUrl <> "" Then
                   StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & JmaxPages & """>" & JmaxPages & "</a> "
                End If
             End If
             JmaxPages = JmaxPages + 1
          Loop
       End If
    End If

    If CurrentPage >= TotalPage Then
       StrTemp = StrTemp & "下一页 尾页"
    Else
       StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & (CurrentPage + 1) & """>下一页</a>&nbsp;"
       StrTemp = StrTemp & "<a href=""" & StrUrl & "Page=" & TotalPage & """>尾页</a>"
    End If
    StrTemp = StrTemp & "&nbsp;页次：<strong style=""color: #FF0000;"">" & CurrentPage & "/" & TotalPage & "</strong> 页"
    If ShowMaxPerPage = True Then
       StrTemp = StrTemp & "&nbsp;<input type=""text"" name=""MaxPerPage"" size=""1"" maxlength=""5"" value=""" & MaxPerPage & """ onKeyPress=""if (event.keyCode==13) window.location='" & JoinChar(StrFileName) & "Page=" & CurrentPage & "&MaxPerPage=" & "'+this.value;"">" & StrUnit & "/页"
    'Else
    '   StrTemp = StrTemp & "&nbsp;<strong style=""color: #087ACF;"">" & MaxPerPage & "</strong> " & StrUnit & "/页"
    End If
    If ShowAllPages = True Then
       If TotalPage > 20 Then
          StrTemp = StrTemp & "&nbsp;转到第<input type=""text"" name=""Page"" size=""1"" maxlength=""5"" value=""" & CurrentPage & """ onKeyPress=""if (event.keyCode==13) window.location='" & StrUrl & "Page=" & "'+this.value;"">页"
       Else
          StrTemp = StrTemp & "&nbsp;转到：<select name=""Page"" size=""1"" onchange=""javascript:window.location='" & StrUrl & "Page=" & "'+this.options[this.selectedIndex].value;"">"
          For I = 1 To TotalPage
              StrTemp = StrTemp & "<option value=""" & I & """"
              If NRF_CLng(CurrentPage) = NRF_CLng(I) Then StrTemp = StrTemp & " selected "
              StrTemp = StrTemp & ">第" & I & "页</option>"
          Next
          StrTemp = StrTemp & "</select>"
       End If
    End If
         
	ShowPage = StrTemp
End Function


'时间格式转换
Function DateToStr(DateTime, ShowType)
    Dim DateMonth, DateDay, DateHour, DateMinute, DateWeek, DateSecond
    Dim FullWeekDay, ShortWeekDay, FullMonth, ShortMonth, TimeZone1, TimeZone2
    TimeZone1 = "+0800"
    TimeZone2 = "+08:00"
    FullWeekDay = Array("Sunday", "Monday", "Tuesday", "Wednesday", "Thursday", "Friday", "Saturday")
    ShortWeekDay = Array("Sun", "Mon", "Tue", "Wed", "Thu", "Fri", "Sat")
    FullMonth = Array("January", "February", "March", "April", "May", "June", "July", "August", "September", "October", "November", "December")
    ShortMonth = Array("Jan", "Feb", "Mar", "Apr", "May", "Jun", "Jul", "Aug", "Sep", "Oct", "Nov", "Dec")

    DateMonth = Month(DateTime)
    DateDay = Day(DateTime)
    DateHour = Hour(DateTime)
    DateMinute = Minute(DateTime)
    DateWeek = Weekday(DateTime)
    DateSecond = Second(DateTime)
    If Len(DateMonth) < 2 Then DateMonth = "0" & DateMonth
    If Len(DateDay) < 2 Then DateDay = "0" & DateDay
    If Len(DateMinute) < 2 Then DateMinute = "0" & DateMinute
    Select Case UCase(ShowType)
		   Case "M/D"
		        DateToStr = DateMonth & "/" & DateDay
           Case "Y/M/D"
                DateToStr = Right(Year(DateTime), 2) & "/" & DateMonth & "/" & DateDay
		   Case "M-D"
		        DateToStr = DateMonth & "-" & DateDay
           Case "Y-M-D"
                DateToStr = Year(DateTime) & "-" & DateMonth & "-" & DateDay
           Case "Y-M-D H:I A"
                Dim DateAMPM
                If DateHour > 12 Then
                   DateHour = DateHour - 12
                   DateAMPM = "PM"
                Else
                   DateHour = DateHour
                   DateAMPM = "AM"
                End If
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                DateToStr = Year(DateTime) & "-" & DateMonth & "-" & DateDay & " " & DateHour & ":" & DateMinute & " " & DateAMPM
           Case "Y-M-D H:I:S"
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                If Len(DateSecond) < 2 Then DateSecond = "0" & DateSecond
                DateToStr = Year(DateTime) & "-" & DateMonth & "-" & DateDay & " " & DateHour & ":" & DateMinute & ":" & DateSecond
           Case "Y-M-DTH:I:S"
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                If Len(DateSecond) < 2 Then DateSecond = "0" & DateSecond
                DateToStr = Year(DateTime) & "-" & DateMonth & "-" & DateDay & "T" & DateHour & ":" & DateMinute & ":" & DateSecond & TimeZone2
           Case "YMDHIS"
                DateSecond = Second(DateTime)
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                If Len(DateSecond) < 2 Then DateSecond = "0" & DateSecond
                DateToStr = Year(DateTime) & DateMonth & DateDay & DateHour & DateMinute & DateSecond
           Case "YMD"
                DateToStr = Right(Year(DateTime), 4) & DateMonth & DateDay
           Case "YM"
                DateToStr = Right(Year(DateTime), 2) & DateMonth
           Case "D"
                DateToStr = DateDay
           Case "MDY"
                Dim DayEnd
                Select Case DateDay
                       Case 1
                            DayEnd = "st"
                       Case 2
                            DayEnd = "nd"
                       Case 3
                            DayEnd = "rd"
                       Case Else
                            DayEnd = "th"
                End Select
                DateToStr = FullMonth(DateMonth - 1) & " " & DateDay & DayEnd & " " & Right(Year(DateTime), 4)
           Case "W,D M Y H:I:S"
                DateSecond = Second(DateTime)
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                If Len(DateSecond) < 2 Then DateSecond = "0" & DateSecond
                DateToStr = ShortWeekDay(DateWeek -1) & "," & DateDay & " " & Left(FullMonth(DateMonth -1), 3) & " " & Right(Year(DateTime), 4) & " " & DateHour & ":" & DateMinute & ":" & DateSecond & " " & TimeZone1
           Case Else
                If Len(DateHour) < 2 Then DateHour = "0" & DateHour
                DateToStr = Year(DateTime) & "-" & DateMonth & "-" & DateDay & " " & DateHour & ":" & DateMinute
    End Select
End Function


'数据类型转换
Function NRF_CLng(Str)
    If IsNumeric(Str) Then
       NRF_CLng = Fix(CDbl(Str))
    Else
       NRF_CLng = 0
    End If
End Function


Function NRF_CDbl(Str)
    If IsNumeric(Str) Then
       NRF_CDbl = CDbl(Str)
    Else
       NRF_CDbl = 0
    End If
End Function


Function NRF_CBool(Str)
    If Str = True Or LCase(Trim(Str)) = "true" Or LCase(Trim(Str)) = "yes" Or Trim(Str) = "1" Then
       NRF_CBool = True
    Else
       NRF_CBool = False
    End If
End Function


Function NRF_CDate(Str)
    If IsDate(Str) Then
       NRF_CDate = CDate(Str)
    Else
       NRF_CDate = Now()
    End If
End Function


Function OpenWin(OpenType)
	Select Case OpenType
	   	Case 1 : OpenWin = "_blank"
		Case Else : OpenWin = "_self"
	End Select
End Function


'表单元素
Function IsOptionChecked(Compare1, Compare2)
    If Compare1 = Compare2 Then
       IsOptionChecked = " checked"
    Else
       IsOptionChecked = ""
    End If
End Function


Function IsOptionSelected(Compare1, Compare2)
    If Compare1 = Compare2 Then
       IsOptionSelected = " selected"
    Else
       IsOptionSelected = ""
    End If
End Function


Function IsDisplay(Compare1, Compare2)
    If Compare1 = Compare2 Then
       IsDisplay = ""
    Else
       IsDisplay = "none"
    End If
End Function


'防止外部提交
Function IsSelfRefer()
  	Dim Http_Referer, Server_Name
	Http_Referer = CStr(Request.ServerVariables("HTTP_REFERER"))
	Server_Name = CStr(Request.ServerVariables("SERVER_NAME"))
	If Mid(Http_Referer, 8, Len(Server_Name)) = Server_Name Then
	   IsSelfRefer = True
	Else
	   IsSelfRefer = False
	End If
End Function


'IP过滤
Function IPFilter(IP)
    IPFilter = False
	
    Dim SIp, SplitIP
    For Each SIp In FilterIP
        SIp = Replace(SIp, "*", "\d*")
        SplitIP = Split(SIp, ".")
        Dim StrMatchs, StrIP
        RegEx.Pattern = "(" & SplitIP(0) & "|)." & "(" & SplitIP(1) & "|)." & "(" & SplitIP(2) & "|)." & "(" & SplitIP(3) & "|)"
        Set StrMatchs = RegEx.Execute(IP)
        StrIP = StrMatchs(0).SubMatches(0) & "." & StrMatchs(0).SubMatches(1)& "." & StrMatchs(0).SubMatches(2)& "." & StrMatchs(0).SubMatches(3)
        If StrIP = IP Then
           IPFilter = True
           Exit Function
        End If
        Set StrMatchs = Nothing
    Next
End Function


'取得最大值
Function GetNewID(SheetName, FieldName)
    Dim Mrs : Set Mrs = Conn.Execute("Select Max(" & FieldName & ") From " & SheetName & "")
    If IsNull(Mrs(0)) Then
       GetNewID = 1
    Else
       GetNewID = Mrs(0) + 1
    End If
    Set Mrs = Nothing
End Function


'创建文件夹
Function CreateMultiFolder(StrPath)
    If StrPath = "" Or IsNull(StrPath) Then
	   CreateMultiFolder = ""
	   Exit Function
    End If
	 
	StrPath = Replace(StrPath, "\", "/")
    If Right(StrPath, 1) <> "/" Then StrPath = StrPath & "/"
	StrPath = Replace(StrPath,"//","/")
		 
	Dim ObjFSO,I,ArrPath,TempPath
	Set ObjFSO = Server.CreateObject("Scripting.FileSystemObject")
	If InStr(StrPath,"/") <> 0 Then
	   ArrPath = Split(StrPath,"/")
       For I = 0 To UBound(ArrPath) - 1
           TempPath = Replace(TempPath & ArrPath(I) & "/","//","/")
	       If ObjFSO.FolderExists(Server.MapPath(TempPath)) = False Then
	          ObjFSO.CreateFolder Server.MapPath(TempPath)
		   End If
       Next
	Else
	   If ObjFSO.FolderExists(Server.MapPath(StrPath)) = False Then
	      ObjFSO.CreateFolder Server.MapPath(StrPath)
       End If
	End If	
	Set objFSO = Nothing
End Function


'读取文件
Function ReadFile(FilePath, CodeType)
    On Error Resume Next
    Dim ObjStream, StrHtml
    Set ObjStream = Server.CreateObject("ADODB.Stream")
	Select Case CodeType
	       Case 1 : ObjStream.Charset = "UTF-8"
		   Case 2 : ObjStream.Charset = "GB2312"
		   Case Else : ObjStream.Charset = "Big5"
	End Select
	ObjStream.Type = 2
    ObjStream.Mode = 3
    ObjStream.Open()
    ObjStream.Position = ObjStream.Size
    ObjStream.LoadFromFile Server.MapPath(FilePath)
	StrHtml = ObjStream.ReadText
    ObjStream.Close
	Set ObjStream = Nothing
    If Err <> 0 Then
       StrHtml = "Error:" & Err.Number & "," & Err.Description
       Err.Clear
    End If
	
    ReadFile = StrHtml    
End Function


'保存文件
Function WriteFile(StrBody, FilePath, CodeType)
    On Error Resume Next
    Dim ObjStream, StrHtml
    Set ObjStream = Server.CreateObject("ADODB.Stream")
	Select Case CodeType
	       Case 1 : ObjStream.Charset = "UTF-8"
		   Case 2 : ObjStream.Charset = "GB2312"
		   Case Else : ObjStream.Charset = "BIG5"
	End Select
	ObjStream.Type = 2
	ObjStream.Mode = 3
    ObjStream.Open()
    ObjStream.Position = ObjStream.Size
    ObjStream.WriteText = StrBody
	ObjStream.SaveToFile Server.MapPath(FilePath), 2
	ObjStream.Flush
	ObjStream.Close
	Set ObjStream = Nothing
    If Err <> 0 Then
       StrHtml = "Error:" & Err.Number & "," & Err.Description
       Err.Clear
    End If 
	
	WriteFile = StrHtml
End Function


'删除文件
Function DelFile(FilePath)
    Dim ObjFSO
	Set ObjFSO = Server.CreateObject("Scripting.FileSystemObject")
    If ObjFSO.FileExists(Server.MapPath(FilePath)) Then
	   ObjFSO.DeleteFile Server.MapPath(FilePath), True
	End If
		 
	Set ObjFSO = Nothing         
End Function


'下载文件
Function DownFile(FilePath)
    'On Error Resume Next
	Dim ObjFSO, ObjF, intFilelength
	FilePath = Server.MapPath(FilePath)
    Set ObjFSO = Server.CreateObject("Scripting.FileSystemObject")
	If Not ObjFSO.FileExists(FilePath) Then
	   Response.Write("Error:" & FilePath & " DoesNot Exist!")
	   Response.End
	   Exit Function
	Else
	   Set ObjF = ObjFSO.GetFile(FilePath)
	   intFileLength = ObjF.Size
	
	   Dim ObjStream
	   Set ObjStream = Server.CreateObject("ADODB.Stream")
	   ObjStream.Type = 1
	   ObjStream.Open()
	   ObjStream.LoadFromFile(FilePath)
	   If Err Then
	      Response.Write("Error: " & Err.Description & "," & Err.Description)
	      Response.End
	   End If
	   Response.AddHeader "Content-Disposition", "attachment; filename=" & ObjF.Name
	   Response.AddHeader "Content-Length", intFileLength
	   Response.CharSet = "UTF-8"
	   Response.ContentType = "application/octet-stream"
	   Response.BinaryWrite ObjStream.Read
	   Response.Flush
	   Set ObjF = Nothing
	   ObjStream.Close
	   Set ObjStream = Nothing	
	End If
	Set ObjFSO = Nothing
End Function


'判断文件是否存在
Function CheckFile(FilePath)
    CheckFile = True
	
	Dim ObjFSO
	Set ObjFSO = Server.CreateObject("Scripting.FileSystemObject")
    If Not ObjFSO.FileExists(Server.MapPath(FilePath)) Then
	   CheckFile = False
	   Exit Function
	End If
	Set ObjFSO = Nothing         
End Function


'函数名：XmlText
'作  用：从语言包中读取指定节点的值
'参  数：iBigNode ---- 大节点
'       iSmallNode ---- 小节点
'       DefChar ---- 默认值
'返回值：语言包中指定节点的值
Function XmlText(iBigNode, iSmallNode, DefChar)
    Dim RootNode, SubNode
    If IsNull(iBigNode) Or IsNull(iSmallNode) Then
        XmlText = DefChar
    Else
        Set RootNode = XMLDoc.getElementsByTagName(iBigNode)
        If RootNode.Length = 0 Then
            XmlText = DefChar
        Else
            Set SubNode = RootNode(0).getElementsByTagName(iSmallNode)
            If SubNode.Length = 0 Then
                XmlText = DefChar
            Else
                XmlText = SubNode(0).text
            End If
        End If
        Set RootNode = Nothing
    End If
End Function


'检查组件是否已经安装
Function IsObjInstalled(StrClassString)
    On Error Resume Next
    IsObjInstalled = False
	
    Dim TestObj
    Set TestObj = Server.CreateObject(StrClassString)
    If Err = 0 Then IsObjInstalled = True
    Set xTestObj = Nothing
End Function


'显示成功提示信息
Sub WriteSuccessMsg(sSuccessMsg, sComeUrl)
    Dim StrSuccess
	StrSuccess = StrSuccess & "<dl id=""MsgBox"">" & vbCrLf
	StrSuccess = StrSuccess & " <dt><strong>&nbsp;恭喜您，操作成功！</strong></dt>" & vbCrLf
	StrSuccess = StrSuccess & "	<dd>" & sSuccessMsg & "</dd>" & vbCrLf
	StrSuccess = StrSuccess & "<dd style=""background: #EAF3FA; line-height: 25px; padding: 0px;"">" & vbCrLf
    If sComeUrl <> "" Then
       StrSuccess = StrSuccess & "&nbsp;<a href=""" & sComeUrl & """>&lt;&lt;返回上一页</a>" & vbCrLf
    Else
       StrSuccess = StrSuccess & "<a href=""javascript:window.close();"">【关闭】</a>" & vbCrLf
    End If
	StrSuccess = StrSuccess & "</dd>" & vbCrLf
    StrSuccess = StrSuccess & "</dl>" & vbCrLf
	
    Response.Write StrSuccess
End Sub


'显示错误提示信息
Sub WriteErrMsg(sErrMsg, sComeUrl)
    Dim StrErr
	StrErr = StrErr & "<dl id=""MsgBox"">" & vbCrLf
	StrErr = StrErr & "<dt><strong>&nbsp;操作失败的原因：</strong></dt>" & vbCrLf
	StrErr = StrErr & "<dd>" & sErrMsg & "</dd>" & vbCrLf
	StrErr = StrErr & "<dd style=""background: #EAF3FA; line-height: 25px; padding: 0px;"">" & vbCrLf
    If sComeUrl <> "" Then
       StrErr = StrErr & "&nbsp;<a href=""javascript:history.go(-1)"">&lt;&lt;返回上一页</a>" & vbCrLf
    Else
       StrErr = StrErr & "<a href=""javascript:window.close();"">【关闭】</a>" & vbCrLf
    End If
	StrErr = StrErr & "</dd>" & vbCrLf
    StrErr = StrErr & "</dl>" & vbCrLf
	
    Response.Write StrErr
End Sub
%>