﻿<%
'==================================================
'函数名：GetHttpPage
'作  用：获取网页源码
'参  数：HttpUrl ------要获取源码的网页地址
'      ：Coding  ------编码， 1 GB 2 UTF
'==================================================
Function GetHttpPage(HttpUrl, Coding)
	On Error Resume Next
    If IsNull(HttpUrl) = True Or Len(HttpUrl) < 18 Or HttpUrl = "" Then
    	GetHttpPage = ""
        Exit Function
    End If
         
	Dim XMLHttp, StrHtml
    Set XMLHttp = Server.CreateObject("MSXML2.XMLHttp")
    XMLHttp.Open "GET", HttpUrl, False
    XMLHttp.Send
    If XMLHttp.Readystate <> 4 Then
        GetHttpPage = ""
        Exit Function
    End If
    If Coding = 1 Then
    	StrHtml = BytesToBstr(XMLHttp.ResponseBody, "UTF-8")
    ElseIf Coding = 2 Then
        StrHtml = BytesToBstr(XMLHttp.ResponseBody, "GB2312")
    Else
        StrHtml = BytesToBstr(XMLHttp.ResponseBody, "Big5")
    End If
    Set XMLHttp = Nothing
	If Err.Number <> 0 Then
		Err.Clear
    End If
	 
	GetHttpPage = StrHtml
End Function


'==================================================
'函数名：PostHttpPage
'作  用：登录
'==================================================
Function PostHttpPage(RefererUrl, PostUrl, PostData, Coding)
	On Error Resume Next
    Dim XMLHttp
    Dim RetStr
    Set XMLHttp = Server.CreateObject("MSXML2.XMLHttp")
    XMLHttp.Open "POST", PostUrl, False
    XMLHttp.setRequestHeader "Content-Length", Len(PostData)
    XMLHttp.setRequestHeader "Content-Type", "application/x-www-form-urlencoded"
    XMLHttp.setRequestHeader "Referer", RefererUrl
    XMLHttp.Send PostData
    If Err Then
    	Set XMLHttp = Nothing
    	PostHttpPage = "$False$"
    	Exit Function
    End If
    If Coding = 1 Then
    	PostHttpPage = BytesToBstr(XMLHttp.ResponseBody, "UTF-8")
    ElseIf Coding = 2 Then
        PostHttpPage = BytesToBstr(XMLHttp.ResponseBody, "Big5")
    Else
        PostHttpPage = BytesToBstr(XMLHttp.ResponseBody, "GB2312")
    End If
    Set XMLHttp = Nothing
End Function


'==================================================
'函数名：BytesToBstr
'作  用：将获取的源码转换为中文
'参  数：Body ------要转换的变量
'参  数：Cset ------要转换的类型
'==================================================
Function BytesToBstr(Body, Cset)
	Dim ObjStream
    Set ObjStream = Server.CreateObject("ADODB.Stream")
    ObjStream.Type = 1
    ObjStream.Mode = 3
    ObjStream.Open
    ObjStream.Write Body
    ObjStream.Position = 0
    ObjStream.Type = 2
    ObjStream.Charset = Cset
    BytesToBstr = ObjStream.ReadText
    ObjStream.Close
    Set ObjStream = Nothing
End Function


'==================================================
'函数名：GetBody
'作  用：截取字符串
'参  数：ConStr ------将要截取的字符串
'参  数：StartStr ------开始字符串
'参  数：OverStr ------结束字符串
'参  数：IncluL ------是否包含StartStr
'参  数：IncluR ------是否包含OverStr
'==================================================
Function GetBody(ConStr, StartStr, OverStr, IncluL, IncluR)
	If ConStr = "" Or IsNull(ConStr) = True Or StartStr = "" Or IsNull(StartStr) = True Or OverStr = "" Or IsNull(OverStr) = True Then
    	GetBody = ""
        Exit Function
    End If
		 
    Dim Start, Over
    Start = InStrB(1, ConStr, StartStr, vbBinaryCompare)

    If Start <= 0 Then
    	Start = InStrB(1, ConStr, Replace(StartStr, vbCrLf, Chr(10)), vbBinaryCompare)
        If Start <= 0 Then
        	Start = InStrB(1, ConStr, Replace(StartStr, vbCrLf, Chr(13)), vbBinaryCompare)
            If Start <= 0 Then
            	GetBody = ""
                Exit Function
            Else
                If IncluL = False Then
                	Start = Start + LenB(StartStr)
                End If
            End If
        Else
            If IncluL = False Then
            	Start = Start + LenB(StartStr)
            End If
        End If
    Else
        If IncluL = False Then
            Start = Start + LenB(StartStr)
        End If
    End If

    Over = InStrB(Start, ConStr, OverStr, vbBinaryCompare)
    If Over <= 0 Or Over <= Start Then
    	Over = InStrB(Start, ConStr, Replace(OverStr, vbCrLf, Chr(10)), vbBinaryCompare)
        If Over <= 0 Or Over <= Start Then
        	Over = InStrB(Start, ConStr, Replace(OverStr, vbCrLf, Chr(13)), vbBinaryCompare)
            If Over <= 0 Or Over <= Start Then
            	GetBody = ""
                Exit Function
            Else
                If IncluR = True Then
                	Over = Over + LenB(OverStr)
                End If
            End If
        Else
            If IncluR = True Then
         	   Over = Over + LenB(OverStr)
            End If
        End If
    Else
        If IncluR = True Then
     	   Over = Over + LenB(OverStr)
        End If
    End If

    GetBody = MidB(ConStr, Start, Over - Start)
End Function


Function ReplaceRemoteUrl(StrContent)
    If IsObjInstalled("Microsoft.XMLHttp") = False Then
       ReplaceRemoteUrl = StrContent
       Exit Function
    End If
	
	Dim SaveFilePath, StrFileName, StrFileExt, NewFileName
	SaveFilePath = InstallDir & UpLoadDir & "/" & DateToStr(Now(), "YM") & "/"
	
    Dim RegEx, RemoteFile, RemoteFiles
    Set RegEx = New RegExp
    RegEx.IgnoreCase = True
    RegEx.Global = True
    RegEx.MultiLine = True
	RegEx.Pattern = "((http|https|ftp|rtsp|mms):(\/\/|\\\\){1}([\w\-]+[.]){1,}(net|com|cn|org|cc|tv|[0-9]{1,3})(\S*\/)((\S)+[.]{1}(bmp|gif|jpg|jpeg|jpe|png)))"
    Set RemoteFiles = RegEx.Execute(StrContent)
    For Each RemoteFile In RemoteFiles
		StrFileName = Mid(RemoteFile, InstrRev(RemoteFile, "/") + 1)
		StrFileExt = LCase(Mid(StrFileName, InstrRev(StrFileName, ".") + 1))
		
		Dim RanNum
		Randomize
		RanNum = Int(900 * Rnd) + 100
		NewFileName = DateToStr(Now(), "YMDHIS") & RanNum & "." & StrFileExt
		
		CreateMultiFolder SaveFilePath
		SaveRemoteFile RemoteFile, SaveFilePath & NewFileName
		
		StrContent = Replace(StrContent, RemoteFile, SaveFilePath & NewFileName)
		
		'If EnableWaterMark = True Then
		'   Call AddWaterMark(SaveFilePath & StrFileName)
		'End If
	Next
		
	ReplaceRemoteUrl = StrContent
End Function


'==================================================
'函数名：SaveRemoteFile
'作  用：保存远程的文件到本地
'参  数：LocalFileName ------ 本地文件名
'        RemoteFileUrl ------ 远程文件URL
'返回值：True ----- 保存成功
'       False ----- 保存失败
'==================================================
Function SaveRemoteFile(RemoteFileUrl, LocalFileName)
	On Error Resume Next
    Dim Ads, Retrieval, GetRemoteData
    Set Retrieval = Server.CreateObject("Microsoft.XMLHttp")
    With Retrieval
    	.Open "Get", RemoteFileUrl, False, "", ""
        .Send
        GetRemoteData = .ResponseBody
    End With
    If Err.Number <> 0 Then
    	Err.Clear
        Response.Write "<br />" & RemoteFileUrl & " Get Failed！"
        SaveRemoteFile = False
        Exit Function
    End If
    Set Retrieval = Nothing
    Set Ads = Server.CreateObject("Adodb.Stream")
    With Ads
    	.Type = 1
        .Open
        .Write GetRemoteData
        .SaveToFile Server.MapPath(LocalFileName), 2
        .Cancel
        .Close
    End With
    Set Ads = Nothing
    If Err.Number <> 0 Then
    	Err.Clear
        Response.Write "<br />" & LocalFileName & " Save Failed！"
        SaveRemoteFile = False
    Else
        SaveRemoteFile = True
    End If
End Function
%>