
/*----------------extend--------------------------------*/
(function () {

    function extend(destination, source) {
        for (var property in source)
            destination[property] = source[property];
        return destination;
    }

    extend(Object, {
        extend: extend
    });
})();
Object.extend(String, (function () {
    function format(exp) {
        var v = Array.prototype.slice.call(arguments, 1);

        return exp.replace(/{\d}/g, function (holder) {
            var index = holder.charAt(1);
            return v[index];
        });

    }
    return {
        format: format
    }
})());

/*--------------hao----------------------------*/
window.Hao = window.Hao || {};
Hao.DataLoader = function () {
    function createXHR() {
        if (typeof XMLHttpRequest != "undefined") {
            createXHR = function () { return new XMLHttpRequest(); }
        }
        else {
            createXHR = function () { return new ActiveXObject('Msxml2.XMLHTTP'); }
        }
        return createXHR();
    }
    function serialize(serealizeForm) {
        if (!serealizeForm) {
            return null;
        }
        var elems = serealizeForm.getElementsByTagName('*')
        result = [],
             formatString = '{0}={1}';
        for (var i = 0; i < elems.length; i++) {
            if (!elems[i].name) { continue; }
            switch (elems[i].type) {
                case 'textarea':
                case 'text':
                case 'hidden':
                    result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].value)));
                    break;
                case 'checkbox':
                case 'radio':
                    if (elems[i].checked) {
                        result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].value)));
                    }
                    break;
                case 'select':
                    result.push(String.format(formatString, elems[i].name, encodeURIComponent(elems[i].options[elems[i].selectedIndex].value)));
                    break;
                default:
                    break;
            }

        }
        return result.join('&');
    }
    return {
        load: function (arg) {
            var xhr = createXHR(),
                    requestURL = arg.requestURL,
                    callBack = arg.callBack,
                    errorCallBack = arg.errorCallBack,
                    isGet = arg.isGet === undefined ? true : arg.isGet,
                    parameter = arg.parameter,
                    isText = arg.isText === undefined ? true : arg.isText,
                    isAsyn = arg.isAsyn === undefined ? true : arg.isAsyn,
                    postForm = arg.postForm,
                    postValue=arg.postValue,
                    serverTime;
                 
            if (isGet) {
                xhr.open('get', requestURL, isAsyn);
                xhr.send(null);
            }
            else {
                xhr.open('post', requestURL, isAsyn);
                xhr.setRequestHeader('Content-Type', 'application/x-www-form-urlencoded');
                xhr.send(postForm?serialize(postForm):postValue);
            }

            if (!isAsyn) {
                if (xhr.status >= 200 && xhr.status < 300 || xhr.status == 304) {
                    serverTime = new Date(xhr.getResponseHeader('Date'));
                    if (isText) {
                        return { data: xhr.responseText, time: serverTime };
                    }
                    else {
                        return { data: xhr.responseXML, time: serverTime };
                    }
                }
                else {
                    return { data: null, status: xhr.status };
                }
            }

            xhr.onreadystatechange = function () {
            
                if (xhr.readyState == 4) {
                  
                   // serverTime = new Date(xhr.getResponseHeader('Date'));
                    if (xhr.status >= 200 && xhr.status < 300 || xhr.status == 304) {
                        if (isText) {
                            //callBack({ data: xhr.responseText, time: serverTime });
							callBack({ data: xhr.responseText});
                        }
                        else {
                            //callBack({ data: xhr.responseXML, time: serverTime });
							callBack({ data: xhr.responseXML});
                        }
                    }
                    else if (errorCallBack) {
                  
                        errorCallBack(xhr.status)
                    }
                }
            };
        }
    };
};
/* help: no*/
Hao.ScriptLoader = function (arg) {
    arg = arg || {};
    var doc = document, script = null, isIE = /\w/.test('\u0130'), head = doc.getElementsByTagName("head")[0], onSuccess = arg.onSuccess, onError = arg.onError, onRequest = arg.onRequest;
    function setScript(script) {
        script.type = "text/javascript";
        script.onload = script.onreadystatechange = function () {
            if (script.readyState && script.readyState == "loading") {
                return;
            }
            if (onSuccess && typeof onSuccess === 'function') {
                onSuccess();
            }

        };
        if (onError && typeof onError === 'function') {
            script.onerror = function () {
                onError();
            }
        }
    }
    return {
        request: function (url) {
            var newScript = null;
            if (script === null) {
                script = doc.createElement('script');
                setScript(script);
                script.src = url;

                head.appendChild(script);

            }
            else if (isIE) {
                script.src = url;
            }
            else {
                newScript = doc.createElement('script');
                setScript(newScript);
                newScript.src = url;
                head.replaceChild(newScript, script);
                script = newScript;
            }
            if (onRequest && typeof onRequest === 'function') {
                onRequest();
            }
        }
    };
};
/*---------from yuji--------------------*/


/*classNamesд 'class1 class2'ʽҪע˳дȷд˵ؽliveġ*/
function getElementsByClassName(className, content, isLive) {
   
    content = content || document;
    var resultTempt = [], result = [];
    if (content.getElementsByClassName) {
        resultTempt = content.getElementsByClassName(className);
    }
    else {
        className = className.replace(/^\s+/, '').replace(/\s+$/, '');
        className = " " + className + " ";
        var tempt = content.getElementsByTagName('*');
     
        for (var i = 0; i < tempt.length; i++) {
            temptClassName = " " + tempt[i].className + " ";
            if (temptClassName.indexOf(className) > -1) {
                resultTempt.push(tempt[i]);
            }
        }
    }
    if (!isLive) {
        for (var j = 0; j < resultTempt.length; j++) {
            result.push(resultTempt[j]);
        }
    } else {
       result = resultTempt;
   }

    if (result.length == 0) {
        return null;
    }
    else {
        return result;
    }
}


