
$ = function(d){return document.getElementById(d);}

function setText(ele,text){
	if(typeof(ele.innerText)!='undefined')
		ele.innerText = text;
	else if(typeof(ele.textContent)!='undefined')
		ele.textContent = text;
}

function getText(ele){
	if(typeof(ele.innerText)!='undefined')
		return ele.innerText;
	else if(typeof(ele.textContent)!='undefined')
		return ele.textContent;
}


function truncateText(text,len){
	if(text.length>len){
		return text.substr(0,len)+'...';
	}else{
		return text;
	}
}

String.prototype.trim = function(){
	return this.replace(/^\s+/, '').replace(/\s+$/, '');
};

function doUpdate(kind,data){
	var sportArea = $(kind+'Area');
	if(!data||!sportArea){
		return;
	}

	var uls = sportArea.getElementsByTagName('ul');
	for(var i=1;i<uls.length;++i){
		var lis = uls[i].getElementsByTagName('li');
		if(lis){
			var link = lis[0].getElementsByTagName('a')[0];
			if(link){
				var dataname;
				var name = dataname= getText(link).trim();
				if(name=='͸'){
					name='͸Ͷע';
				}
				link.target='_blank';
				link.href = 'http://www.soso.com/q?ie=utf-8&cid=u01.tool.2&w='+encodeURIComponent(dataname);
			}
		}else{
			continue;
		}

		var data_index = null;
		for(var j=0;j<data.length;++j){
			if(data[j].name==name){
				data_index = j;
				break;
			}
		}

		if(data_index==null){
			continue;
		}

		var plusPos =  data[data_index].opendata.indexOf('+');
		var red='';
		var blue='';
		if(plusPos==-1){
			red = data[data_index].opendata.replace(/\;/g,' ');
		}else{
			red = data[data_index].opendata.substr(0,plusPos).replace(/\;/g,' ');
			blue = data[data_index].opendata.substr(plusPos+1).replace(/\;/g,' ');
		}
		setText(lis[1].getElementsByTagName('span')[0],red.trim());
		setText(lis[1].getElementsByTagName('span')[1],blue.trim());

		setText(lis[2],data[data_index].issue);
		setText(lis[3],data[data_index].opentime);

		link = lis[5].getElementsByTagName('a')[0];
		if(link){
			link.target='_blank';
			link.href = 'http://www.soso.com/q?ie=utf-8&cid=u01.tool.2&w='+encodeURIComponent(dataname+' ͼ');
		}
	}
}

function updateLottery(data){
	for(var i=0;i<data.length;++i){
		doUpdate(data[i].name,data[i].data);
	}
}

function getCaipiaoData(){
	var script = document.createElement('script');
	script.src = "http://sou.qq.com/script/level2/caipiaoData.js?v="+parseInt(Math.random()*100000);
	document.getElementsByTagName('head')[0].appendChild(script);
}

getCaipiaoData();

