<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_album.asp
'= CREATED TIME : 2006-5-1
'= LAST MODIFIED: 2006-5-1
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : ûᴦ߼
'= Change Log:
'==================================================================='
%>

<%
'== /
Const CONST_ALBUM_UP_STATUS = 0
Const CONST_ALBUM_PASTE_STATUS = 10

''===================================================================
'= Function    : GetAlbumsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡ¼
'==================================================================='
Function GetAlbumsLogic(strWhere)
	GBL_objPubDB.Clear()
	If Instr(strWhere,"ORDER BY") > 0 Then
		GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_OWNER_ID=USER_ID " & strWhere 
	Else
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,ALBUM_STATUS,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_OWNER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_ID DESC"
	End If
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumsLogic = False
		Exit Function
	End If
	GetAlbumsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumReviewsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ѯ
'= Return      : boolean
'= Description : ȡۼ¼
'==================================================================='
Function GetAlbumReviewsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_REALNAME,ALBUM_REVIEW_ID,ALBUM_REVIEW_OWNER_ID,ALBUM_REVIEW_PHOTO_ID,ALBUM_REVIEW_CONTENT,ALBUM_REVIEW_ADD_TIME FROM CLASS_USER,CLASS_ALBUM_REVIEW WHERE ALBUM_REVIEW_OWNER_ID=USER_ID " & strWhere & " ORDER BY ALBUM_REVIEW_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumReviewsLogic = False
		Exit Function
	End If
	GetAlbumReviewsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId : ID
'= Return      : boolean
'= Description : ȡ
'==================================================================='
Function GetAlbumLogic(intAlbumId)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_REALNAME,ALBUM_STATUS,ALBUM_TITLE,ALBUM_ID,ALBUM_IMG_FILE,ALBUM_HITS,ALBUM_TYPE,ALBUM_REVIEW_NUM,ALBUM_ADD_TIME FROM CLASS_USER,CLASS_ALBUM WHERE ALBUM_OWNER_ID=USER_ID AND ALBUM_ID=" & intAlbumId
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetAlbumLogic = False
		Exit Function
	End If
	GetAlbumLogic = True
End Function

''===================================================================
'= Function    : RemoveAlbumsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ɾ
'= Return      : boolean
'= Description : ɾ
'==================================================================='
Function RemoveAlbumsLogic(strWhere)
	Dim strSql

	'== ɾƬ
	strSql = " AND ALBUM_REVIEW_PHOTO_ID IN (SELECT ALBUM_ID FROM CLASS_ALBUM WHERE 1=1 " & strWhere & ")"
	If Not RemoveAlbumReviewsLogic(strSql,0) Then
		RemoveAlbumsLogic = False
		Exit Function
	End If
	
	'== ɾͼƬļ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField  "ALBUM_IMG_FILE",""
	GBL_objPubDB.Where = " ALBUM_STATUS=" & CONST_ALBUM_UP_STATUS & " " & strWhere
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveAlbumsLogic = False
		Exit Function
	End If
	While Not GBL_objPubDB.objPubRS.Eof
		Call fsoDeleteFile(GBL_strHomeURL & GBL_strImgAlbum & GBL_objPubDB.objPubRS("ALBUM_IMG_FILE"))
		Response.Write GBL_strHomeURL & GBL_strImgAlbum & GBL_objPubDB.objPubRS("ALBUM_IMG_FILE")
		GBL_objPubDB.objPubRS.MoveNext
	Wend

	'== ɾ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumsLogic = False
		Exit Function
	End If

	RemoveAlbumsLogic = True
End Function
''===================================================================
'= Function    : StatisticsAlbumReviewNums()
'= Time		   : Created At 2006-5-7
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ͳ
'==================================================================='
Function StatisticsAlbumReviewNums(strWhere)
	Dim intNum,arrTmp,i,strIds

	'== ȡɾ漰Ƭ
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT ALBUM_REVIEW_PHOTO_ID,COUNT(ALBUM_REVIEW_ID) FROM CLASS_ALBUM_REVIEW,CLASS_ALBUM WHERE ALBUM_ID=ALBUM_REVIEW_PHOTO_ID AND 1=1 " & strWhere & "  GROUP BY ALBUM_REVIEW_PHOTO_ID" 
	If Not GBL_objPubDB.SQLRSExecute() Then
		StatisticsAlbumReviewNums = False
		Exit Function
	End If
	intNum = GBL_objPubDB.intRsNum

	If intNum > 0 Then
		arrTmp = GBL_objPubDB.objPubRS.GetRows(-1)
		'== Ƭ
		For i = 0 To intNum - 1
			GBL_objPubDB.Clear()
			GBL_objPubDB.AllSQL = "UPDATE CLASS_ALBUM SET ALBUM_REVIEW_NUM=" & arrTmp(1,i) & " WHERE ALBUM_ID=" & arrTmp(0,i)
			If Not GBL_objPubDB.SQLExecute() Then
				StatisticsAlbumReviewNums = False
				Exit Function
			End If
		Next
	End If

	If IsArray(arrTmp) Then Erase arrTmp

	StatisticsAlbumReviewNums = True
End Function

''===================================================================
'= Function    : RemoveAlbumReviewsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Input	   : intAlbumId : Ҵ0,ԸƬͳ,Ϊ0ͳ
'= Return      : boolean
'= Description : ɾ
'==================================================================='
Function RemoveAlbumReviewsLogic(strWhere,intAlbumId)
	'== ɾ¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_REVIEW"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere
	If Not GBL_objPubDB.SQLExecute() Then
		RemoveAlbumReviewsLogic = False
		Exit Function
	End If

	'== 
	If IsNumeric(intAlbumId) And intAlbumId > 0 Then
		If Not StatisticsAlbumReviewNums(" AND ALBUM_ID=" &intAlbumId) Then
			RemoveAlbumReviewsLogic = False
			Exit Function
		End If
	ElseIf intAlbumId = "" Then
		If Not StatisticsAlbumReviewNums("") Then
			RemoveAlbumReviewsLogic = False
			Exit Function
		End If
	End If

	RemoveAlbumReviewsLogic = True
End Function

''===================================================================
'= Function    : GetAlbumImgLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strImg : ͼƬļ¼
'= Input	   : strStatus : ͼƬļ״̬(0--ļ 10--ļ)
'= Return      : ͼƬļַ
'= Description : ȡͼƬļַ
'==================================================================='
Function GetAlbumImgLogic(strImg,strStatus)
	If strStatus = 10 Then
		GetAlbumImgLogic = strImg
	Else
		GetAlbumImgLogic = GBL_strHomeURL & GBL_strImgAlbum & strImg 
	End If
End Function

''===================================================================
'= Function    : UpLoadAlbumFileLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strFormName : ļύ
'= Input	   : strPicName : ͼƬļ
'= Input	   : objDataForm : 
'= Return      : boolean
'= Description : ϴͼƬļ
'==================================================================='
Function UpLoadAlbumFileLogic(strFormName,ByRef strPicName,ByRef objFormData)
	Dim claUpLoad,objFileUp,iCount,strUpFilePath,intFileMaxSize,strFileType,intNameSet
	Dim intTypeFlag,strAddInfo
	'== ļ
	strFileType = GBL_strAlbumFileType

	'== ļ
	intFileMaxSize = GBL_intAlbumMaxSize * 1000 

	'== ļ·
	strUpFilePath = GBL_strHomeUrl & GBL_strImgAlbum

	'== ļʽ
	intNameSet = 1

	Set claUpLoad = New classFileUpLoad
	iCount = 0
	strAddInfo = "NULL"

	For Each strFormName In claUpLoad.objFile '== гϴ˵ļ
		Set objFileUp = claUpLoad.file(strFormName)  '== һļ
		If objFileUp.FileSize > 0 Then   '== the file is not null
			If objFileUp.FileSize < intFileMaxSize Then 
				If strFileType <> "" Then	'== check the file type
					If Instr(strFileType,GetExtendName(objFileUp.FileName)) And CheckFileType(objFileUp.FileType) Then
						intTypeFlag = 1    
					 Else
						intTypeFlag = 0	
						strAddInfo = "֧ϴļͣ" & GetExtendName(objFileUp.FileName)
						Call GBL_objException.catchErr(E_USER_PUB,strAddInfo)
						UpLoadAlbumFileLogic = False
						Exit Function
					End If
				Else
					intTypeFlag = 1	
				End If

				If intTypeFlag = 1 Then 
					strPicName = MakeFileName(Now())
					If intNameSet = 1 Then
						strPicName = strPicName & iCount & "." & GetExtendName(objFileUp.FileName)
					ElseIf intNameSet = 2 Then
						strPicName = objFileUp.FileName
					ElseIf intNameSet = 3 Then
						strPicName = strPicName & iCount & objFileUp.FileName
					End If
					objFileUp.SaveAs Server.Mappath(strUpFilePath & strPicName) 
					iCount = iCount + 1

					'== Get other form data
					objFormData.Item("PicTitle") = Trim(claUpload.form("iptPicTitle"))
					'strPicIntro = Trim(claUpload.form("txtPicIntro"))
					objFormData.Item("PicType") = Trim(claUpload.form("selPicType"))

				End If
			Else
				strAddInfo = "ļСƣϴ " & intFileMaxSize/1000	& "Kֽڵļ"
				Call GBL_objException.catchErr(E_USER_PUB,strAddInfo)
				UpLoadAlbumFileLogic = False
				Exit Function
			End If
		End If
		Set objFileUp = Nothing
	Next

	Set claUpLoad = Nothing 

	If iCount < 0 Then 
		Call GBL_objException.catchErr(E_USER_PUB,"ϴļʧ")
		UpLoadAlbumFileLogic = False
		Exit Function
	End If

	UpLoadAlbumFileLogic = True
End Function

''===================================================================
'= Function    : SaveAlbumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Input	   : objDataForm : 
'= Input	   : strPicName : ͼƬļ
'= Return      : boolean
'= Description : ϴͼƬ¼
'==================================================================='
Function SaveAlbumLogic(intUserId,objDataForm,strPicName)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "ALBUM_IMG_FILE",strPicName
	GBL_objPubDB.AddField "ALBUM_TITLE",objDataForm.Item("PicTitle")
	GBL_objPubDB.AddField "ALBUM_TYPE",objDataForm.Item("PicType")
	GBL_objPubDB.AddField "ALBUM_COLLECTIONID",1
	GBL_objPubDB.AddField "ALBUM_OWNER_ID",intUserId
	GBL_objPubDB.AddField "ALBUM_ADD_TIME",NOW()
	GBL_objPubDB.AddField "ALBUM_STATUS",CONST_ALBUM_UP_STATUS
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumLogic = False
		Exit Function
	End If
	SaveAlbumLogic = True
End Function

''===================================================================
'= Function    : SavePasteAlbumLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId : ûID
'= Input	   : objDataForm : 
'= Input	   : strPicName : ͼƬļ
'= Return      : boolean
'= Description : ճͼƬ¼
'==================================================================='
Function SavePasteAlbumLogic(intUserId,objDataForm)
	
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "ALBUM_IMG_FILE",objDataForm.Item("PicUrl")
	GBL_objPubDB.AddField "ALBUM_TITLE",objDataForm.Item("PicTitle")
	GBL_objPubDB.AddField "ALBUM_TYPE",objDataForm.Item("PicType")
	GBL_objPubDB.AddField "ALBUM_COLLECTIONID",1
	GBL_objPubDB.AddField "ALBUM_OWNER_ID",intUserId
	GBL_objPubDB.AddField "ALBUM_ADD_TIME",NOW()
	GBL_objPubDB.AddField "ALBUM_STATUS",CONST_ALBUM_PASTE_STATUS
	If Not GBL_objPubDB.SQLExecute() Then
		SavePasteAlbumLogic = False
		Exit Function
	End If
	SavePasteAlbumLogic = True
End Function

''===================================================================
'= Function    : GetAlbumFileUrlLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strDBRecord 
'= Input	   : intStatus 
'= Return      : boolean
'= Description : ȡͼƬļַ
'==================================================================='
Function GetAlbumFileUrlLogic(strDBRecord,intStatus)
	If intStatus = CONST_ALBUM_PASTE_STATUS Then
		GetAlbumFileUrlLogic = strDBRecord
	Else
		GetAlbumFileUrlLogic = GBL_strHomeUrl & GBL_strImgAlbum & strDBRecord
	End If
End Function

''===================================================================
'= Function    : GetLastNextAlbumIdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId 
'= Output	   : intLastId 
'= Output	   : intNextId 
'= Return      : boolean
'= Description : ȡһһID
'==================================================================='
Function GetLastNextAlbumIdLogic(intAlbumId,ByRef intLastId,intNextId)
	intLastId = GetNextRS("ALBUM_ID","CLASS_ALBUM","ALBUM_ID>" & intAlbumId,"ALBUM_ID ASC")
	intNextId = GetNextRS("ALBUM_ID","CLASS_ALBUM","ALBUM_ID<" & intAlbumId,"ALBUM_ID DESC")
End Function

''===================================================================
'= Function    : SaveAlbumReviewLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intUserId 
'= Input	   : intAlbumId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : Ƭ
'==================================================================='
Function SaveAlbumReviewLogic(intUserId,intAlbumId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM_REVIEW"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "ALBUM_REVIEW_PHOTO_ID",intAlbumId
	GBL_objPubDB.AddField "ALBUM_REVIEW_CONTENT",objFormData.Item("Content")
	GBL_objPubDB.AddField "ALBUM_REVIEW_OWNER_ID",intUserId
	GBL_objPubDB.AddField "ALBUM_REVIEW_ADD_TIME",Now()
	GBL_objPubDB.AddField "ALBUM_REVIEW_LAST_TIME",Now()
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumReviewLogic = False
		Exit Function
	End If

	'== set this photo's review number
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_ALBUM"
	GBL_objPubDB.SQLType = "UPDATE"
	GBL_objPubDB.Where = "ALBUM_ID=" & intAlbumId
	GBL_objPubDB.AddSet "ALBUM_REVIEW_NUM=ALBUM_REVIEW_NUM+1"
	If Not GBL_objPubDB.SQLExecute() Then
		SaveAlbumReviewLogic = False
		Exit Function
	End If
	
	SaveAlbumReviewLogic = True
End Function

''===================================================================
'= Function    : GetMyReviewLogic()
'= Time		   : Created At 2006-6-24
'= Input	   : intUserId 
'= Return      : 
'= Description : ȡû۵
'==================================================================='
Function GetMyReviewLogic(intUserId)
	Dim strSql
	strSql = "SELECT ALBUM_ID,ALBUM_TITLE,ALBUM_TYPE,ALBUM_HITS,ALBUM_OWNER_ID,USER_REALNAME,ALBUM_IMG_FILE,ALBUM_ADD_TIME,ALBUM_REVIEW_NUM,ALBUM_STATUS FROM CLASS_ALBUM,CLASS_USER WHERE USER_ID=ALBUM_OWNER_ID AND ALBUM_ID IN (SELECT ALBUM_ID FROM CLASS_ALBUM,CLASS_ALBUM_REVIEW WHERE  ALBUM_REVIEW_OWNER_ID=" & intUserId & " AND ALBUM_REVIEW_PHOTO_ID=ALBUM_ID  ) ORDER BY ALBUM_ID DESC"

	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSql = strSql
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMyReviewLogic = False
		Exit Function
	End If
	
	GetMyReviewLogic = True

End Function



%>