<%
''===================================================================
'= ASP FILENAME	: /inc/logic/logic_meet.asp
'= CREATED TIME : 2006-5-1
'= LAST MODIFIED: 2006-5-1
'= VERSION INFO : CCASP Framework Ver 2.0.1 ALL RIGHTS RESERVED BY www.cclinux.com
'= DESCRIPTION  : ۻᴦ߼
'= Change Log:
'==================================================================='
%>

<%
'== meet over/run
Const CONST_MEET_OVER = 1
Const CONST_MEET_RUN = 0
Const CONST_MEET_LOGO = "meet_logo.gif"

''===================================================================
'= Function    : GetMeetsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : 
'= Return      : boolean
'= Description : ȡۻ¼
'==================================================================='
Function GetMeetsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ID, USER_ACCOUNT,USER_REALNAME,MEET_ID,MEET_TIME,MEET_ADD_TIME,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_USER,CLASS_MEET WHERE MEET_OWNER_ID=USER_ID " & strWhere & " ORDER BY MEET_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetsLogic = False
		Exit Function
	End If
	GetMeetsLogic = True
End Function

''===================================================================
'= Function    : GetMeetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡۻ¼
'==================================================================='
Function GetMeetLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_ID,USER_REALNAME,MEET_SPOT,MEET_AREA,MEET_SPEND,MEET_PEOPLE_NUM,MEET_CONTACT,MEET_INTRO,MEET_OTHER,MEET_SUM,MEET_ID,MEET_TIME,MEET_ADD_TIME,MEET_TYPE,MEET_STATUS,MEET_BBS_NUM,MEET_TITLE FROM CLASS_USER,CLASS_MEET WHERE MEET_OWNER_ID=USER_ID " & strWhere & " ORDER BY MEET_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetLogic = False
		Exit Function
	End If
	GetMeetLogic = True
End Function

''===================================================================
'= Function    : GetMeetBBSsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ȡۻԼ¼
'==================================================================='
Function GetMeetBBSsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,USER_ID,MEET_BBS_ID,MEET_BBS_TIME,MEET_BBS_TITLE,MEET_BBS_CONTENT,MEET_BBS_MEET_ID FROM CLASS_USER,CLASS_MEET_BBS WHERE MEET_BBS_OWNER_ID=USER_ID " & strWhere & " ORDER BY MEET_BBS_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetBBSsLogic = False
		Exit Function
	End If
	GetMeetBBSsLogic = True
End Function

''===================================================================
'= Function    : GetMeetJoinsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : ۻID
'= Return      : boolean
'= Description : ȡۻᱨ¼
'==================================================================='
Function GetMeetJoinsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.AllSQL = "SELECT USER_ACCOUNT,USER_REALNAME,MEET_JOIN_STATUS,MEET_JOIN_OWNER,USER_ID,MEET_JOIN_ID,MEET_JOIN_TIME,MEET_JOIN_CONTACT FROM CLASS_USER,CLASS_MEET_JOIN WHERE MEET_JOIN_OWNER_ID=USER_ID " & strWhere & " ORDER BY MEET_JOIN_ID DESC"
	If Not GBL_objPubDB.SQLRSExecute() Then
		GetMeetJoinsLogic = False
		Exit Function
	End If
	GetMeetJoinsLogic = True
End Function

''===================================================================
'= Function    : RemoveMeetsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  ɾۻ
'==================================================================='
Function RemoveMeetsLogic(strWhere)
	Dim strSql
	strSql = " AND MEET_JOIN_MEET_ID IN (SELECT MEET_ID FROM CLASS_MEET WHERE 1=1 " & strWhere & ")"
	'== ɾ
	If Not RemoveMeetJoinsLogic(strSql) Then
		RemoveMeetsLogic = False
		Exit Function
	End If

	'== ɾ
	strSql = " AND MEET_BBS_MEET_ID IN (SELECT MEET_ID FROM CLASS_MEET WHERE 1=1 " & strWhere & ")"
	If Not RemoveMeetBBSsLogic(strSql) Then
		RemoveMeetsLogic = False
		Exit Function
	End If

	'== ɾ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetsLogic = False
		Exit Function
	End If
	RemoveMeetsLogic = True
End Function

''===================================================================
'= Function    : RemoveMeetBBSsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description :  ɾۻ
'==================================================================='
Function RemoveMeetBBSsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_BBS"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetBBSsLogic = False
		Exit Function
	End If
	RemoveMeetBBSsLogic = True
End Function

''===================================================================
'= Function    : RemoveMeetJoinsLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : strWhere : 
'= Return      : boolean
'= Description : ɾۻᱨ
'==================================================================='
Function RemoveMeetJoinsLogic(strWhere)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where = " 1=1 " & strWhere 
	If Not GBL_objPubDB.SQLRSExecute() Then
		RemoveMeetJoinsLogic = False
		Exit Function
	End If
	RemoveMeetJoinsLogic = True
End Function

''===================================================================
'= Function    : SaveMeetLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intMeetId : ۻID
'= Return      : boolean
'= Description : ۻϢ
'==================================================================='
Function SaveMeetLogic(intMeetId,intUserId,objFormData)
	Dim strTitle,strStatus,strType,strArea,strSpot,strSpend,strTime,strPeopleNum,strContact,strSum,strContent,strOther

	strTitle = objFormData.Item("Title")
	If intMeetId <> "" Then
		strStatus = objFormData.Item("Status")
	Else
		strStatus = CONST_MEET_RUN
	End If
	strType = objFormData.Item("Type")
	strArea = objFormData.Item("Area")
	strSpot = objFormData.Item("Spot")
	strSpend = objFormData.Item("Spend")
	strTime = objFormData.Item("Time")
	strPeopleNum = objFormData.Item("PeopleNum")
	strContact = objFormData.Item("Contact")
	strSum = objFormData.Item("Sum")
	strContent = objFormData.Item("Content")
	strOther = objFormData.Item("Other")

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	If intMeetId <> "" Then
		GBL_objPubDB.SQLType = "UPDATE"
	Else
		GBL_objPubDB.SQLType = "INSERT"
		GBL_objPubDB.AddField "MEET_OWNER_ID",intUserId
		GBL_objPubDB.AddField "MEET_LOGO",CONST_MEET_LOGO
		GBL_objPubDB.AddField "MEET_ADD_TIME",Now()
	End If

	GBL_objPubDB.AddField "MEET_TITLE",strTitle
	GBL_objPubDB.AddField "MEET_INTRO",strContent
	GBL_objPubDB.AddField "MEET_OTHER",strOther
	GBL_objPubDB.AddField "MEET_SUM",strSum
	GBL_objPubDB.AddField "MEET_TIME",strTime
	GBL_objPubDB.AddField "MEET_SPOT",strSpot
	GBL_objPubDB.AddField "MEET_AREA",strArea
	GBL_objPubDB.AddField "MEET_SPEND",strSpend
	GBL_objPubDB.AddField "MEET_CONTACT",strContact
	GBL_objPubDB.AddField "MEET_PEOPLE_NUM",strPeopleNum
	GBL_objPubDB.AddField "MEET_TYPE",strType
	GBL_objPubDB.AddField "MEET_STATUS",strStatus
	GBL_objPubDB.AddField "MEET_LAST_TIME",Now()
	If intMeetId <> "" Then
		GBL_objPubDB.Where = " MEET_ID=" & intMeetId
	End If
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetLogic = False
		Exit Function
	End If
	SaveMeetLogic = True
End Function

''===================================================================
'= Function    : GetMeetStatusLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intStatus : ۻ״̬
'= Return      : ۻ״̬ĺ
'= Description : ȡþۻ״̬
'==================================================================='
Function GetMeetStatusLogic(intStatus)
	If Cint(intStatus) = CONST_MEET_RUN Then
		GetMeetStatusLogic = "ټ"
	Else
		GetMeetStatusLogic = "ѽ"
	End If
End Function

''===================================================================
'= Function    : GetLastNextMeetIdLogic()
'= Time		   : Created At 2006-5-5
'= Input	   : intAlbumId 
'= Output	   : intLastId 
'= Output	   : intNextId 
'= Return      : boolean
'= Description : ȡһһID
'==================================================================='
Function GetLastNextMeetIdLogic(intAlbumId,ByRef intLastId,intNextId)
	intLastId = GetNextRS("MEET_ID","CLASS_MEET","MEET_ID>" & intAlbumId,"MEET_ID ASC")
	intNextId = GetNextRS("MEET_ID","CLASS_MEET","MEET_ID<" & intAlbumId,"MEET_ID DESC")
End Function

''===================================================================
'= Function    : SaveMeetJoinLogic()
'= Time		   : Created At 2006-5-7
'= Input	   : intUserId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : ûۻᱨ
'==================================================================='
Function SaveMeetJoinLogic(intUserId,intMeetId,objFormData)
	'== ֹͣľۻ᲻ܱ
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET"
	GBL_objPubDB.SQLType = "SELECT"
	GBL_objPubDB.AddField "MEET_STATUS",""
	GBL_objPubDB.Where =  " MEET_ID=" & intMeetId & " AND MEET_STATUS=" & CONST_MEET_OVER
	If Not GBL_objPubDB.SQLRSExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If
	If GBL_objPubDB.intRSNum > 0 Then
		Call GBL_objException.catchErr(E_USER_PUB,"ֹͣľۻ᲻ܱ")
	End If

	'==ɾϵı¼
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "DELETE"
	GBL_objPubDB.Where =  "MEET_JOIN_OWNER_ID=" & intUserId & " AND MEET_JOIN_STATUS=0 AND MEET_JOIN_MEET_ID=" & intMeetId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If

	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_JOIN"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "MEET_JOIN_OWNER",objFormData.Item("User")
	GBL_objPubDB.AddField "MEET_JOIN_CONTACT",objFormData.Item("Tel")
	GBL_objPubDB.AddField "MEET_JOIN_OWNER_ID",intUserId
	GBL_objPubDB.AddField "MEET_JOIN_STATUS",0
	GBL_objPubDB.AddField "MEET_JOIN_MEET_ID",intMeetId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetJoinLogic = False
		Exit Function
	End If
	SaveMeetJoinLogic = True
End Function

''===================================================================
'= Function    : SaveMeetBBSLogic()
'= Time		   : Created At 2006-5-7
'= Input	   : intUserId 
'= Input	   : intMeetId 
'= Input	   : objFormData 
'= Return      : boolean
'= Description : ۻ
'==================================================================='
Function SaveMeetBBSLogic(intUserId,intMeetId,objFormData)
	GBL_objPubDB.Clear()
	GBL_objPubDB.TableName = "CLASS_MEET_BBS"
	GBL_objPubDB.SQLType = "INSERT"
	GBL_objPubDB.AddField "MEET_BBS_OWNER_ID",intUserId
	GBL_objPubDB.AddField "MEET_BBS_CONTENT",objFormData.Item("Content")
	GBL_objPubDB.AddField "MEET_BBS_MEET_ID",intMeetId
	If Not GBL_objPubDB.SQLExecute() Then
		SaveMeetBBSLogic = False
		Exit Function
	End If
	SaveMeetBBSLogic = True
End Function
%>