<?php
/**
 * shopNR本地电商系统，轻电商
 * ============================================================================
 * * 版权所有 青岛微动一百网络科技有限公司，并保留所有权利。
 * 交流论坛: http://bbs.weidong100.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和
 * 使用；不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 软件著作权：2015SR193850
 * 购买授权：0532-88032825
*/
class IndexComputer extends Action
{
    public function _initialize()
    {
        
        header("Content-Type:text/html; charset=utf-8");
        $this->get_user();
        //获取用户信息
        click();
    }
    //首页
    public function index()
    {
        //获取幻灯片
        $Slide = M('Slide');
        $slide = $Slide->where(array('is_mobile' => ISWAP))->order('s_order desc')->select();
        $this->assign('slide', $slide);
        //分类商品
        $Goods = D('Goods');
        $Cate = M('Cate');
        //获取推荐分类的相对二级分类
        $cate1 = $Cate->where(array('is_recommend' => 1))->order('c_order desc')->select();
        foreach ($cate1 as $key => $value) {
            //获取下级全部分类
            $cate2 = $Cate->where(array('parentid' => $value['cid']))->order('c_order desc')->select();
            $str = '';
            //全部二级分类的CID
            foreach ($cate2 as $v) {
                $str .= $v['cid'] . ',';
            }
            $map['state'] = array('eq', 1);
            $map['is_recommend'] = array('eq', 1);
            $map['cid'] = array('in', $str);
            $recommend_list = $Goods->relation(true)->where($map)->order('g_order desc')->limit(index_recommend)->select();
            $recommend_list = goodsListHandle($recommend_list);
            $list[$value["name"]]['cid'] = $value["cid"];
            $list[$value["name"]]['cate2_list'] = $cate2;
            //获取推荐分类的相对二级分类
            $list[$value["name"]]['goods_list'] = $recommend_list;
            //获取相对二级分类的推荐商品
            $list[$value["name"]]['flag'] = $key;
        }
        //获取销售排列
        $index_sales = $Goods->relation(true)->where(array('state' => 1, 'is_hots' => 1))->order('base_num desc')->limit(index_sales)->select();
        $index_sales = goodsListHandle($index_sales);
        //获取新品推荐
        $index_news = $Goods->relation(true)->where(array('state' => 1, 'is_new' => 1))->order('g_order desc')->limit(index_news)->select();
        $index_news = goodsListHandle($index_news);
        //获取促销列表
        $index_promote = $Goods->where('is_promote = 1 AND state = 1 AND start_time < date_format( now(),"%Y-%m-%d %H:%i:%s") AND end_time > date_format( now(),"%Y-%m-%d %H:%i:%s") ')->relation(true)->order('base_num desc')->limit(index_promote)->select();
        $index_promote = goodsListHandle($index_promote);
        $this->assign('goodslist', $list);
        $this->assign('promote', $index_promote);
        $this->assign('sales', $index_sales);
        $this->assign('news', $index_news);
        $this->assign_ur_here('首页', array(array('title' => '首页', 'url' => U('Index/index'))));
        $this->display();
    }
    //全部商品分类
    public function allCate()
    {
        //firstload已经加载
        $this->assign_ur_here('商品分类', array(array('title' => '全部商品分类', 'url' => U('Index/allCate'))));
        $this->display();
    }
    //商品详情
    public function goods()
    {
        $Goods = M('Goods');
        $goods = $Goods->where(array('gid' => I('get.gid'),'state'=>1))->find();
        /*检查是否存在该商品*/
        if (!$goods) {
            $this->error('未知商品ID');
        }
        
        $properties = get_goods_properties(I('get.gid'));  // 获得商品的规格和属性
        //dump($properties);
        
        /*获取该商品的分类信息*/
        $Cate = M('Cate');
        $nowcate = $Cate->where(array('cid' => $goods['cid']))->field('name,cid')->find();
        /*检查该商品是否促销*/
        if (strtotime($goods['end_time']) >= time() && $goods['is_promote'] == 1) {
            $goods['original_price'] = $goods['price'];
            $goods['price'] = $goods['promote_price'];
        } else {
            updategoodpromote($goods['gid']);
            $goods['is_promote'] = 0;
        }
        
        /*$Attribute = M('Attribute');
        $Goods_attr = M('Goods_attr');
        $attr_list = $Attribute->where(array('cat_id' => $goods['goods_type']))->order('sort_order desc')->select();
        foreach ($attr_list as $key => $attr) {
            $attr['attr_list'] = $Goods_attr->where(array('attr_id' => $attr['attr_id'], 'goods_id' => $goods['gid']))->select();
            if ($attr['attr_list']) {
                $goods['goods_attr'][$key]['attr_name'] = $attr['attr_name'];
                $goods['goods_attr'][$key]['attr_id'] = $attr['attr_id'];
                $goods['goods_attr'][$key]['attr_list'] = $attr['attr_list'];
            }
        }*/
        $goods['goods_attr'] = $properties['spe'];
        $goods['goods_attr_json'] = json_encode($goods['goods_attr']);
        //dump($goods['goods_attr']);
        
        //获取这个商品的所有库存
        $Products = M('Products');
        $products = $Products->where(['goods_id'=>I('get.gid')])->select();
        foreach($products as $k => $v){
            $v['goods_sn'] = $v['goods_id'].'|'.$v['goods_attr'];
            $productsList[$v['goods_attr']] = $v;
            //$products_linshi[$v['goods_sn']] = $v;
        }
        $productsList = $productsList ? : '';
        //dump($productsList);
        $this->assign('productsList',json_encode($productsList));
        //dump($productsList);
        //dump($goods);
        /*foreach($goods['goods_attr'] as $k => $v){
            $flag = 1;
            foreach($v['attr_list'] as $kk => $vv){
                foreach($products_linshi as $kkk => $vvv){
                    if(strpos($kkk ,'|'.$vv['goods_attr_id']) !== false){
                        $goods['goods_attr'][$k]['attr_list'][$kk]['productsList'][] = $vvv;
                        if($flag == 1){
                            $goods['goods_attr'][$k]['attr_list'][$kk]['is_check'] = 1;
                            $flag = 0;
                        }
                    }
                }
            }
        }*/
        //dump($goods);
        //判断是否收藏
        $User_collect = M('User_collect');
        $user_collect = $User_collect->where(array('gid' => $goods['gid'], 'uid' => session('uid')))->find();
        if ($user_collect) {
            $goods['collect'] = $user_collect['id'];
        } else {
            $goods['collect'] = '0';
        }
        $this->assign('goods', $goods);
        //商品相册
        $Goods_gallery = M('Goods_gallery');
        $galleryList = $Goods_gallery->where(array('goods_id' => $_GET['gid']))->select();
        $this->assign('galleryList', $galleryList);
        /*获取销售排列*/
        $index_sales = $Goods->where(array('state' => 1, 'is_hots' => 1))->order('base_num desc')->limit(index_sales)->select();
        $index_sales = goodsListHandle($index_sales);
        $this->assign('sales', $index_sales);
        /*获取销售排列结束*/
        //获取售后服务
        $Message = M('Message');
        $shouhou = $Message->where(array('id' => 40))->find();
        $this->assign('shouhou', $shouhou);
        //获取评论数量
        $Comment = M('Comment');
        $countmap['gid'] = I('get.gid');
        $countmap['is_show'] = array('eq', 0);
        $countmap['goods_star'] = array('in', '4,5');
        $count[1] = $Comment->where($countmap)->count();
        //获取好评数量
        $countmap['goods_star'] = array('in', '2,3');
        $count[2] = $Comment->where($countmap)->count();
        //获取中评数量
        $countmap['goods_star'] = array('eq', '1');
        $count[3] = $Comment->where($countmap)->count();
        //获取差评数量
        $this->assign('count', $count);
        $this->assign_ur_here($goods['name'], array(array('title' => $nowcate['name'], 'url' => U('Index/goodslist', array('cid' => $nowcate['cid']))), array('title' => $goods['name'], 'url' => U('Index/goods', array('gid' => $goods['gid'])))));
        $this->display();
    }
    //商品列表
    public function goodslist()
    {
        //把同等级的分类查询出来
        $Cate = M('Cate');
        $cat = $Cate->where(array('cid' => I('get.cid')))->field('name,parentid,filter_attr')->find();
        !$cat && $this->error('未知分类ID');
        $cate = $Cate->where(array('parentid' => $cat['parentid']))->order('c_order desc')->select();
        $Goods = D('Goods');
        //获取自己及所有子分类
        $cid_list = get_category( $_GET['cid'],$Cate );
        $cid_list=rtrim($cid_list,',');
        $map['cid'] = array('in', $cid_list);
        $catename = $cat['name'];
        $this->assign('cid', $_GET['cid']);
        if ($_GET['order'] && $_GET['sort']) {
            $order = $_GET['sort'] . ' ' . $_GET['order'];
        } else {
            $order = 'g_order desc';
        }
        if ($_GET['order'] == 'asc') {
            $this->assign('order', 'desc');
        } else {
            $this->assign('order', 'asc');
        }
        $map['state'] = array('eq', 1);
        
        //搜索条件处理
        $price_max = isset($_REQUEST['price_max']) && intval($_REQUEST['price_max']) > 0 ? intval($_REQUEST['price_max']) : 0;
        $price_min = isset($_REQUEST['price_min']) && intval($_REQUEST['price_min']) > 0 ? intval($_REQUEST['price_min']) : 0;
        $filter_attr_str = isset($_REQUEST['filter_attr']) ? htmlspecialchars(trim($_REQUEST['filter_attr'])) : '0';
        $filter_attr_str = urldecode($filter_attr_str);
        $filter_attr = empty($filter_attr_str) ? '' : explode('.', trim($filter_attr_str));
        
        /* 属性筛选 */
        $ext = '';
        if ($cat['filter_attr'] > 0) {
            //===>需要筛选的属性，是人工在后台添加的，存放在ecs_category 表的中 filter_attr字段里面，格式如：185,189,120,190
            //===>RETURN:Array ( [0] => 185 [1] => 189 [2] => 173 [3] => 178 )
            $cat_filter_attr = explode(',', $cat['filter_attr']);       //提取出此分类的筛选属性
            
            //===> 然后，对每一个属性（此属性是主属性，下面还有子属性），循环进行操作
            //===> ①获取该属性的属性名
            //===> ②获取该属性的所有子属性（子属性必须是有被商品在使用的，不然，不要将其显示出来）
            //===> 意义：因为该属性涉及到搜索参数，如果该属性下本身没有商品，那么就没有显示出来的意义了。
            //===> RETURN: Array ( [0] => Array ( [attr_id] => 185 [goods_id] => 167 [attr_value] => 灰色 ) [1] => Array ( [attr_id] => 185 [goods_id] => 198 [attr_value] => 白色 ) [2] => Array ( [attr_id] => 185 [goods_id] => 197 [attr_value] => 金色 ) [3] => Array ( [attr_id] => 185 [goods_id] => 163 [attr_value] => 黑色 ) ) 
            $all_attr_list = array();
            $Attribute = M('Attribute');
            $attribute_list = $Attribute->where(array('attr_id'=>array('in',$cat['filter_attr'])))->select();
            $Goods_attr = D('GoodsAttrGoodsView');
            foreach($attribute_list as $k => $v){
                $attribute_list[$k]['attr_values'] = $Goods_attr->where(array('attr_id'=>$v['attr_id']))->group('attr_value')->select();
                if(!$attribute_list[$k]['attr_values']){
                    unset($attribute_list[$k]);
                }
            }
            $attribute_list = array_values($attribute_list);
            foreach($attribute_list as $k => $v){
                $attribute_list_1[$v['attr_id']] = $v; 
            }
            foreach ($cat_filter_attr as $key => $value) { 
                $temp_name = $attribute_list_1[$value]['attr_name'];
                if($temp_name) {
                    //获取该属性名（主属性）
                    $all_attr_list[$key]['filter_attr_name'] = $temp_name;  
                    $attr_list = $attribute_list_1[$value]['attr_values'];
                    //如果后台指定该分类下，用于搜索的属性的组数，是跟地址栏中filter_attr=0.0.0.0  中0的个数是一样的，而且顺序都是一样的
                    //第一个0，表示第一组属性中，它选择了哪一个子属性，以此类推
                    //获取当前url中已选择属性的值，并保留在数组中
                    //!这里要作循环，是因为避免属性为0或者空时，导致出错，因为直接把$filter_attr 赋值给 $temp_arrt_url_arr会出错。
                    //RETURN:Array ( [0] => 163 [1] => 216 [2] => 160 [3] => 186 ) 
                    $temp_arrt_url_arr = array();
                    for ($i = 0; $i < count($cat_filter_attr); $i++) {     
                        $temp_arrt_url_arr[$i] = !empty($filter_attr[$i]) ? $filter_attr[$i] : 0;  
                    }
                    //这里是该属性下，选择全部时的数组形式
                    //哪一个属性的值为0，即说明用户选择的是该属性的全部选项
                    //为“全部”生成url
                    //DATA:Array ( [0] => 0 [1] => 216 [2] => 160 [3] => 186 ) 
                    $temp_arrt_url_arr[$key] = 0;    //“全部”的信息生成 
                    $temp_arrt_url = implode('.', $temp_arrt_url_arr);
                    $all_attr_list[$key]['attr_list'][0]['attr_value'] = '全部';
                    $all_attr_list[$key]['attr_list'][0]['url'] = build_uri('cate', array('cid'=>$_GET['cid'], 'bid'=>$brand, 'price_min'=>$price_min, 'price_max'=>$price_max, 'filter_attr'=>$temp_arrt_url), $cat['name']);
                    $all_attr_list[$key]['attr_list'][0]['selected'] = empty($filter_attr[$key]) ? 1 : 0;
                    //循环计算子属性的相关数组：属性值，属性是否选择，属性的url
                    //判断当前子属性，是否被选中状态
                    foreach ($attr_list as $k => $v) {
                        $temp_key = $k + 1;
                        $temp_arrt_url_arr[$key] = $v['goods_attr_id'];       
                        //为url中代表当前筛选属性的位置变量赋值,并生成以‘.’分隔的筛选属性字符串
                        $temp_arrt_url = implode('.', $temp_arrt_url_arr);
                        $all_attr_list[$key]['attr_list'][$temp_key]['attr_value'] = $v['attr_value'];
                        $all_attr_list[$key]['attr_list'][$temp_key]['url'] = build_uri('cate', array('cid'=>$_GET['cid'], 'bid'=>$brand, 'price_min'=>$price_min, 'price_max'=>$price_max, 'filter_attr'=>$temp_arrt_url,'order'=>$_GET['order'],'sort'=>$_GET['sort']), $cat['name']);
                        if(!empty($filter_attr[$key]) AND $filter_attr[$key] == $v['goods_attr_id']){ //处理已被选择的子属性
                            $all_attr_list[$key]['attr_list'][$temp_key]['selected'] = 1;
                        }else{
                            $all_attr_list[$key]['attr_list'][$temp_key]['selected'] = 0;
                        }
                    }
                }
            }
            //为模板注入变量
            $this->assign('filter_attr_list',$all_attr_list);
            /* 扩展商品查询条件 */
            if (!empty($filter_attr)) {
                //把满足筛选条件的gid查出来
                //先根据goods_attr_id 找出 attr_id 然后找到attr_id和attr_value一样的gid
                $gid_list = array();
                $flag = 0;
                foreach($filter_attr as $k => $v){
                    if (is_numeric($v) && $v !=0 && isset($cat_filter_attr[$k])) {
                        $goods_attr = $Goods_attr->where(array('goods_attr_id'=>array('eq',$v)))->find();
                        if($goods_attr){
                            $flag++;
                            $gid = $Goods_attr->where(array('attr_id'=>array('eq',$goods_attr['attr_id']),'attr_value'=>array('eq',$goods_attr['attr_value'])))->getField('goods_id',true);
                            $gid_list = $flag > 1 ? array_intersect($gid_list,$gid) : $gid;
                        }
                    }
                }
                $gid_list = array_unique($gid_list);
                if($gid_list){
                    $map['gid'] = array('in',$gid_list);
                }else{
                    $flag > 0 && $map['gid'] = array('eq',0);
                }
            }
        } 
        import('ORG.Util.Page');
        $count = $Goods->relation(true)->where($map)->count();
        $Page = new Page($count, 12);
        $Page->setConfig('header', '个商品');
        $show = $Page->show();
        $list = $Goods->relation(true)->where($map)->order($order)->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $list = goodsListHandle($list);
        $this->assign('page', $show);
        $this->assign('cate', $cate);
        $this->assign('goodslist', $list);
        $this->assign_ur_here($catename, array(array('title' => $catename, 'url' => U('Index/goodslist', array('cid' => $_GET['cid'])))));
        $this->display();
    }
    //专题
    public function subject()
    {
        $Subject = M('Subject');
        import('ORG.Util.Page');
        $count = $Subject->where("end_time >= DATE_FORMAT(NOW(),'%Y-%m-%d') and sub_id=" . I('get.sub_id'))->count();
        $Page = new Page($count, 12);
        $Page->setConfig('header', '个商品');
        $show = $Page->show();
        $re = $Subject->where("end_time >= DATE_FORMAT(NOW(),'%Y-%m-%d') and sub_id=" . I('get.sub_id'))->find();
        if (!$re) {
            $this->error('专题不存在!');
        }
        $arr = explode(',', rtrim($re['data'], ','));
        $Goods = D('Goods');
        $list = $Goods->relation(true)->where(array('gid' => array('in',$arr)))->select();
        $list = goodsListHandle($list);
        $this->assign('re', $re);
        $this->assign('page', $show);
        $this->assign('list', $list);
        $this->assign_ur_here($re['title'], array(array('title' => '专题详情', 'url' => U('Index/subject'))));
        $this->display();
    }
    //专题列表
    public function subjectList()
    {
        $Subject = M('Subject');
        import('ORG.Util.Page');
        $count = $Subject->where("end_time >= DATE_FORMAT(NOW(),'%Y-%m-%d')")->count();
        $Page = new Page($count, 12);
        $Page->setConfig('header', '个专题');
        $show = $Page->show();
        $list = $Subject->where("end_time >= DATE_FORMAT(NOW(),'%Y-%m-%d')")->order('sort desc')->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $this->assign('page', $show);
        $this->assign('list', $list);
        $this->assign_ur_here('专题活动', array(array('title' => '专题活动', 'url' => U('Index/subjectList'))));
        $this->display();
    }
    //获取商品的评价
    public function getGoodsCommentList()
    {
        $Comment = D('CommentGoodsUserView');
        if (!empty($_GET['type'])) {
            if ($_GET['type'] == 1) {
                $map['goods_star'] = array('in', '4,5');
            } elseif ($_GET['type'] == 2) {
                $map['goods_star'] = array('in', '2,3');
            } elseif ($_GET['type'] == 3) {
                $map['goods_star'] = array('eq', 1);
            }
        }
        $map['is_show'] = array('eq', 0);
        $map['gid'] = array('eq', $_GET['gid']);
        import('@.ORG.Util.Page');
        // 导入分页类
        $count = $Comment->where($map)->count();
        $Page = new Page($count, 8);
        $Page->setConfig('header', '个评价');
        $show = $Page->show_post($_GET['gid']);
        $list = $Comment->order('time desc')->where($map)->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $data['list'] = $list;
        $data['page'] = $show;
        echo json_encode($data);
    }
    //搜索商品
    public function searchgoods()
    {
        $Goods = D('Goods');
        $where['name']  = array('like','%'.I('get.goodsname').'%');
        $where['goods_keyword']  = array('like','%'.I('get.goodsname').'%');
        $where['_logic'] = 'or';
        $map['_complex'] = $where;
        $map['state']  = 1;
        import('ORG.Util.Page');
        $count = $Goods->relation(true)->where($map)->count();
        $Page = new Page($count, 12);
        $Page->setConfig('header','个结果');
        $show = $Page->show();
        $list = $Goods->relation(true)->where($map)->order('g_order desc')->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $list = goodsListHandle($list);
        $this->assign('goodslist', $list);
        $this->assign('page', $show);
        // 赋值数据集
        $this->assign('goodsname', $_GET['goodsname']);
        // 赋值数据集
        $this->assign_ur_here('搜索包含&nbsp;"' . $_GET['goodsname'] . '"&nbsp;相关的商品', array(array('title' => '搜索包含&nbsp;"' . $_GET['goodsname'] . '"&nbsp;相关的商品', 'url' => U('Index/index'))));
        $this->display('searchgoods');
    }
    //店内资讯列表
    public function mlist()
    {
        $Message_cate = M('Message_cate');
        $cate = $Message_cate->order('c_order desc')->select();
        $this->assign('cate', $cate);
        // 赋值数据集
        $Message = M('Message');
        if ($_GET['cid']) {
            $map['cid'] = array('eq', $_GET['cid']);
            $catename = $Message_cate->where(array('cid' => I('get.cid')))->getField('name');
        } else {
            $map['cid'] = array('neq', '');
            $catename = '店内资讯';
        }
        import('ORG.Util.Page');
        $count = $Message->where($map)->count();
        $Page = new Page($count, 10);
        $Page->setConfig('header', '篇文章');
        $show = $Page->show();
        $list = $Message->where($map)->order('time desc')->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $this->assign('list', $list);
        $this->assign('page', $show);
        $this->assign('catename', $catename);
        $this->assign_ur_here($catename, array(array('title' => $catename, 'url' => U('Index/mlist'))));
        $this->display();
    }
    //店内资讯
    public function message()
    {
        $Message_cate = M('Message_cate');
        $cate = $Message_cate->order('c_order desc')->select();
        $this->assign('cate', $cate);
        // 赋值数据集
        $Message = M('Message');
        $m = $Message->find($_GET['id']);
        $mcate = $Message_cate->find($m['cid']);
        $this->assign('m', $m);
        $this->assign_ur_here($m['title'], array(array('title' => $mcate['name'], 'url' => U('Index/mlist', array('cid' => $m['cid']))), array('title' => $m['title'], 'url' => U('Index/message', array('id' => $m['id'])))));
        $this->display();
    }
    //店铺地图
    public function map()
    {
        $map = explode(",", C('site_map'));
        $this->assign('site_longitude', $map[0]);
        $this->assign('site_latitude', $map[1]);
        //获取配送区域
        $Area = M('Area');
        $area = $Area->order('a_order desc')->select();
        $this->assign('area', $area);
        $this->assign_ur_here("店铺地图", array(array('title' => "店铺地图", 'url' => U('Index/map'))));
        $this->display();
    }
    //购物车界面
    public function cart()
    {
        //判断一下用户是否登录  是否允许游客购物
        $uid = session('uid');
        if (C('is_ghost') == 0 && empty($uid)) {
            $gourl = U('Index/login');
        } else {
            $gourl = U('Index/checkout');
        }
        $this->assign('gourl', $gourl);
        $this->assign_ur_here("我的购物车", array(array('title' => "我的购物车", 'url' => U('Index/cart'))));
        $this->display();
    }
    //审核订单信息
    public function checkout()
    {
        //获取默认地址
        $User_address = D('UserAreaView');
        $default_address = $User_address->where(array('uid' => $_SESSION['uid'], 'is_default' => '1'))->find();
        $this->assign('default_address', $default_address);
        //获取配送区域
        $Area = M('Area');
        $area = $Area->order('a_order desc')->select();
        $this->assign('area', $area);
        
        $Region=M('Region');
	    $provinceList=$Region->where(array('region_type'=>1))->select();
	    $this->assign('provinceList',$provinceList);
        
        $this->assign_ur_here("核对订单信息", array(array('title' => "核对订单信息", 'url' => U('Index/checkout'))));
        $this->display();
    }
    //获取城市
    public function getCity(){
        
        if(I('get.pid')){
            $Region=M('Region');
	        $cityList=$Region->where(array('parent_id'=>I('get.pid')))->select();
        }else{
            $cityList='';
        }
		echo json_encode($cityList);  //jsonp请求
    }
    
    //获取县区
    public function getCounty(){
        if(I('get.pid')){
            $Region=M('Region');
	        $countyList=$Region->where(array('parent_id'=>I('get.pid')))->select();
        }else{
            $countyList='';
        }
		echo json_encode($countyList);  //jsonp请求
    }
    //点击修改时获取地址列表
    public function get_address()
    {
        $User_address = D('UserAreaView');
        $list = $User_address->where(array('uid' => $_SESSION['uid']))->order('is_default desc,address_id desc')->select();
        echo json_encode($list);
    }
    //支付界面
    public function pay_online()
    {
        if (!session('uid')) {
            $this->error('请先登录!', U('Index/login'));
        }
        is_exceed_pay_time(session('uid'));
        if (I('get.order_no')) {
            $Orders = M('Orders');
            $my_order = $Orders->where(array('order_no' => $_GET['order_no'], 'uid' => session('uid')))->find();
            if (empty($my_order)) {
                $this->error('该订单不存在！', 'index.php');
            } elseif ($my_order['pay_state'] == 1) {
                $this->error('该订单已经支付过！', 'index.php');
            } elseif ($my_order['state'] == -1) {
                $this->error('无效订单！', 'index.php');
            } else {
                //查询出支付方式
                $Payway = M('Pay_way');
                $paywayList = $Payway->order('sort desc')->where(array('pc_shop_is_close' => '0'))->select();
                $this->assign('paywayList', $paywayList);
                $this->assign('my_order', $my_order);
                $this->assign_ur_here("订单支付", array(array('title' => "订单支付", 'url' => U('Index/pay_online'))));
                $this->assign('type', 1);
            }
            //查询出订单的商品
            $Ordergoods = D('OrderGoodsView');
            $ordergoodsList['data'] = $Ordergoods->where(array('order_no' => I('get.order_no')))->select();
            foreach ($ordergoodsList['data'] as $k => $v) {
                $ordergoodsList['total']['money'] += $v['num'] * $v['price'];
            }
            $ordergoodsList['total']['money'] = $ordergoodsList['total']['money'] + $my_order['shipping_fee'] - $my_order['discount'];
            $this->assign('ordergoodsList', $ordergoodsList);
        } else {
            if (I('get.money')) {
                //充值
                $money = round(I('get.money'), 2);
                if ($money <= 0) {
                    $this->error('参数错误!');
                }
                //查询出支付方式
                $Payway = M('Pay_way');
                $paywayList = $Payway->order('sort desc')->where(array('pc_recharge_is_close' => '0'))->select();
                $this->assign('paywayList', $paywayList);
                $this->assign_ur_here("订单支付", array(array('title' => "订单支付", 'url' => U('Index/pay_online'))));
                $this->assign('type', 2);
            } else {
                $this->error('参数错误!');
            }
        }
        $this->display();
    }
    //订单支付方式提交处理
    public function start_pay()
    {
        if (I('post.order_no')) {
            $Orders = M('Orders');
            $_POST['pay_cash'] = $Orders->where(array('order_no' => I('post.order_no')))->getField('pay_cash');
        }
        if ($_POST['pay_mark'] == 'Alipay') {
            //post提交
            echo '<form style="display:none;" id="form" name="form1" method="post" action="' . C('site_url') . '/index.php?m=Alipay&a=doalipay&payid=' . I('post.paytype') . '&type=' . I('post.type') . '"><input name="pay_cash" type="text" value=' . I('post.pay_cash') . ' /><input name="order_no" type="text" value=' . I('post.order_no') . ' /></form><script type="text/javascript">function load_submit(){document.form1.submit()}load_submit();</script>;';
        } else {
            if ($_POST['pay_mark'] == 'unionpay') {
                //post提交
                echo '<form style="display:none;" id="form" name="form1" method="post" action="' . C('site_url') . '/index.php?m=Unionpay&a=dounionpay&payid=' . I('post.paytype') . '&type=' . I('post.type') . '"><input name="pay_cash" type="text" value=' . I('post.pay_cash') . ' /><input name="order_no" type="text" value=' . I('post.order_no') . ' /></form><script type="text/javascript">function load_submit(){document.form1.submit()}load_submit();</script>;';
            } else {
                if ($_POST['pay_mark'] == 'balance') {
                    $User = M('User');
                    $user = $User->where(array('uid' => session('uid')))->find();
                    if ($user['pay_password'] != md5(md5($_POST['yue_password']))) {
                        //$this->error('支付密码错误');
                        out_info(500, '支付密码错误');
                    }
                    //判断订单
                    $Orders = M('Orders');
                    $orders = $Orders->where(array('order_no' => I('post.order_no'), 'uid' => session('uid')))->find();
                    if (!$orders) {
                        //$this->error('订单有误');
                        out_info(500, '订单有误');
                    }
                    if ($orders['pay_state'] == '1' || $orders['pay_method'] != 0) {
                        //$this->error('订单已经支付过!');
                        out_info(500, '订单已经支付过!');
                    }
                    if ($user['user_money'] < $_POST['pay_cash']) {
                        //$this->error('余额不足!');
                        out_info(300, '余额不足!');
                    }
                    //判断支付方式是不是余额支付
                    $Pay_way = M('Pay_way');
                    $pay_way = $Pay_way->where(array('id' => I('post.paytype')))->find();
                    if (!$pay_way || $pay_way['pay_mark'] != 'balance') {
                        //$this->error('支付方式异常!');
                        out_info(500, '支付方式异常!');
                    }
                    //扣除资金并且写入更改订单状态并且写入资金日志
                    $User->startTrans();
                    //$re = $User->where(array('uid' => session('uid')))->setDec('user_money', $_POST['pay_cash']);
                    $data = array('state'=>0,'pay_state' => '1', 'pay_method' => I('post.paytype'), 'pay_name' => '余额支付', 'pay_time' => NOW_TIME);
                    $re1 = $Orders->where(array('order_no' => I('post.order_no')))->setField($data);
                    //写入资金记录表
                    $re2 = edit_user_account(session('uid'), 0, '使用余额支付为订单' . $orders['order_no'] . '支付' . $_POST['pay_cash'] . '元', -$_POST['pay_cash'], 0, 0, 1);
                    add_order_log($orders['oid'], '使用余额支付了订单' . $orders['order_no']);
                    //$re2=rechargeFun(session('uid'),2,I('post.paytype'),-$orders['pay_cash'],$orders['pay_cash'],0,0,'会员'.$user['tel'].'使用余额支付为订单'.$orders['order_no'].'进行了支付','','');
                    if ($re1 !== false and $re2 !== false) {
                        $User->commit();
                        //add_order_log($order['oid'],'使用余额支付了订单'.$order['order_no']);
                        //发送短信
                        //send_order_msg($orders);
                        //minus_goods_num($orders['order_no']);
                        order_msg($orders,$_POST['pay_cash'],2);
                        out_info(200, '支付成功');
                    } else {
                        $User->rollback();
                        out_info(500, '支付失败!');
                    }
                } else {
                    if ($_POST['pay_mark'] == 'cod') {
                        //判断订单
                        $Order = M('Order');
                        $order = $Order->where(array('order_no' => I('post.order_no'), 'uid' => session('uid')))->find();
                        if (!$order) {
                            $this->error('订单有误');
                        }
                        if ($order['pay_state'] == '1' || $order['pay_method'] != 0) {
                            $this->error('订单已经支付过!');
                        }
                        $data = array('pay_method' => I('post.paytype'));
                        $re = $Order->where(array('order_no' => I('post.order_no')))->setField($data);
                        if ($re) {
                            $this->success('交易成功!', U('User/order'));
                        }
                    }
                }
            }
        }
    }
    //提交订单
    public function order()
    {
        /**
        *  获取用户的购物车中的商品，数据结构
        *  $mycart['data'][$k]        商品表
           $mycart['total']['num']    总数 
           $mycart['total']['money']  总价
           $mycart['total']['use_integral_t']   总使用积分
           $mycart['total']['give_integral_t']  总赠送积分
        */
        $mycartgoods = R('Putcart/getcart');
        $order_no = date('YmdHis') . $_SESSION['uid'];
        //生成订单号
        //开始处理提交过来的订单商品
        $Ordergoods = M('Ordergoods');
        $Goods = M('Goods');
        foreach ($mycartgoods['data'] as $key => $v) {
            $v['order_no'] = $order_no;
            //开始减去商品库存
            $result = updategoodnum($v['goods_sn'], -$v['num']);
            if ($result['re'] == '004') {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error($v['name'] . '的库存不足，请减少购买数量！', U('Index/cart'));
                exit;
            } elseif ($result['re'] == '002') {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error('更新商品库存失败，请稍后再试！');
                exit;
            }
            unset($v['id']);
            if (!$Ordergoods->add($v)) {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error('订单中的商品写入失败！');
                exit;
            }
        }
        $Order = M('Orders');
        $_POST = I('post.');
        //过滤传值
        if (!empty($order_no)) {
            $User_address = D('UserAreaView');
            $default_address = $User_address->where(array('uid' => $_SESSION['uid'], 'address_id' => $_POST['default_address_id']))->find();
            if (!$default_address) {
                $this->error('参数错误!');
            }
            /*//获取选择地区的运费和名称
            		$Area = M('Area');
                    $area = $Area->where('area_id='.$default_address['area_id'])->find();*/
            //判断一下是否使用了积分
            if ($_POST['is_use_integral'] == 1) {
                //计算应付总额 = 订单总额 - 可用积分*兑换比例 + 运费
                if ($_SESSION['uid']) {
                    $User = M('User');
                    $myIntegralNum = $User->where(array('uid' => session('uid')))->getField('integral_num');
                } else {
                    $myIntegralNum = 0;
                }
                //可用积分换算到现金的金额
                if ($myIntegralNum > $mycartgoods['total']['use_integral_t']) {
                    $integralCash = $mycartgoods['total']['use_integral_t'] * C('integral_scale');
                    $use_inter = $mycartgoods['total']['use_integral_t'];
                } else {
                    $integralCash = $myIntegralNum * C('integral_scale');
                    $use_inter = $myIntegralNum;
                }
            } else {
                $integralCash = 0;
                $use_inter = 0;
            }
            if ($mycartgoods['total']['money'] >= $default_address['max_amount']) {
                $default_address['shipping_fee'] = 0;
            }
            $pay_cash = $mycartgoods['total']['money'] - $integralCash + $default_address['shipping_fee'];
            $data = array('order_no' => $order_no, 'name' => $default_address['consignee'], 'tel' => $default_address['tel'], 'area_id' => $default_address['area_id'], 'remarks' => $_POST['remarks'], 'time' => time(), 'totalAmount' => $mycartgoods['total']['money'], 'uid' => $_SESSION['uid'], 'state' => 0, 'pay_state' => 0, 'pay_method' => 0, 'give_integral' => $mycartgoods['total']['give_integral_t'], 'use_inter' => $use_inter, 'discount' => $integralCash, 'pay_cash' => $pay_cash, 'shipping_fee' => $default_address['shipping_fee']);
            if ($default_address['area_id'] == '1') {
                $data['address'] = $default_address['province_name'] . $default_address['city_name'] . $default_address['county_name'] . $default_address['address'];
            } else {
                $data['address'] = $default_address['aname'] . $default_address['address'];
            }
            $oid = $Order->add($data);
            if ($oid) {
                //扣除消费积分
                if ($use_inter != 0) {
                    edit_user_account($_SESSION["uid"], 0, '订单' . $order_no . '购物消费', 0, 0, -$use_inter, 1);
                }
                //清空购物车
                if ($this->is_login()) {
                    $goodscartsql = M('cart');
                    $goodscartsql->where(array('uid' => $_SESSION['uid']))->delete();
                    $_SESSION['mycart'] = '';
                } else {
                    $_SESSION['mycart'] = '';
                }
                //判断一下，是否在线支付
                $this->success('订单提交成功，请开始支付', U('Index/pay_online', array('order_no' => $data['order_no'])));
            } else {
                $this->error('提交失败');
            }
        } else {
            $this->error('提交失败');
        }
    }
    
    //获取订单支付情况
    public function get_order()
    {
        $Order = M('Orders');
        $pay_state = $Order->where(array('order_no' => I('post.order_no')))->getField('pay_state');
        echo json_encode($pay_state);
        //jsonp请求
    }
    //会员登录
    public function login()
    {
        $this->is_login2();
        if ($_POST) {
            $User = M('User');
            if (!$User->where(array('tel' => I('post.tel')))->find()) {
                $this->error('账号不存在！');
            } else {
                $u = $User->where(array('tel' => I('post.tel'), 'password' => md5(md5($_POST['password']))))->find();
                if ($u['uid']) {
                    //清空购物车
                    $goodscartsql = M('cart');
                    $goodscartsql->where(array('uid' => $u['uid']))->delete();
                    //清空购物车结束
                    session('uid', $u['uid']);
                    //自动确认收货
                    auto_receipt();
                    //未付款订单设置为无效
                    is_exceed_pay_time(session('uid'));
				    if($_POST['Remember']==1){
                        cookie('Remember',1,3600*24*7);
                        $re=setLoginToken();
                    }else{
                        cookie('Remember',1,-1);
                        cookie('login_token',null);
                    }
                    $this->success('欢迎光临，登陆成功',U('Index/index'));
                } else {
                    $this->error('密码错误！');
                }
            }
            exit;
        }
        if(cookie('login_token')){
    		$re=checkLoginToken();
    		if($re){
    		    $User=M('User');
    		    $u = $User->where(array('uid'=>$re))->find();
    			if($u['uid']){
                    //清空购物车
                    $goodcartsql = M('cart');
                    $goodcartsql->where(array('uid'=>$u['uid']))->delete();
                    //清空购物车结束
                    session('uid',$u['uid']);  
                    //自动确认收货
                    auto_receipt();
                    is_exceed_pay_time(session('uid'));
    			    $this->success('欢迎光临，登陆成功',U('Index/index'));
    			    exit;
    			}
    		}
		}
        $this->assign_ur_here("会员登录", array(array('title' => "会员登录", 'url' => U('Index/login'))));
        $this->display();
    }
    //会员注册
    public function register()
    {
        $this->is_login2();
        $User = M('User');
        if ($_POST) {
            if (I('post.tel') == '' || I('post.password') == '') {
                $this->error('参数错误!');
            }
            $_POST['regtime'] = time();
            $_POST['password'] = md5(md5($_POST['password']));
            $_POST['pay_password'] = $_POST['password']; 
            if ($User->where(array('tel' => I('post.tel')))->getField('uid')) {
                $this->error('该手机号已经被注册！');
            } else {
                $_POST = I('post.');
                if ($User->add($_POST)) {
                    $uid = $User->where(array('tel' => I('post.tel'), 'password' => $_POST['password']))->getField('uid');
                    session('uid', $uid);
                    $this->success('注册成功！', U('Index/index'));
                } else {
                    $this->error('注册失败！');
                }
            }
            exit;
        }
        if(cookie('login_token')){
    		$re=checkLoginToken();
    		if($re){
    		    $User=M('User');
    		    $u = $User->where(array('uid'=>$re))->find();
    			if($u['uid']){
                    //清空购物车
                    $goodcartsql = M('cart');
                    $goodcartsql->where(array('uid'=>$u['uid']))->delete();
                    //清空购物车结束
                    session('uid',$u['uid']);  
                    //自动确认收货
                    auto_receipt();
                    is_exceed_pay_time(session('uid'));
    			    $this->success('欢迎光临，登陆成功',U('Index/index'));
    			    exit;
    			}
    		}
		}
        $this->assign_ur_here("会员注册", array(array('title' => "会员注册", 'url' => U('Index/register'))));
        $this->display();
    }
    //找回密码
    public function find_pwd()
    {
        $this->is_login2();
        $User = M('User');
        if ($_POST) {
            if (session('find_pwd_tel') != I('post.tel')) {
                $this->error('密码修改失败！');
            }
            if ($User->where(array('tel' => I('post.tel')))->getField('uid')) {
                $_POST['password'] = md5(md5($_POST['password']));
                if ($User->where(array('tel' => I('post.tel')))->setField('password', $_POST['password'])) {
                    $this->success('密码修改成功，立即登录！', U('Index/login'));
                } else {
                    $this->error('密码修改失败！');
                }
            } else {
                $this->error('该手机号未被绑定会员！');
            }
            exit;
        }
        $this->assign_ur_here("找回密码", array(array('title' => "找回密码", 'url' => U('Index/find_pwd'))));
        $this->display();
    }
    //会员退出
    public function logout()
    {
        //清空购物车
        $goodscartsql = M('cart');
        $goodscartsql->where(array('uid' => $_SESSION['uid']))->delete();
        //清空购物车结束
        cookie('login_token',null);
        session(null);
        $this->success('退出成功！', U('Index/index'));
    }
    //发送短信
    public function sendmsg()
    {
        session('find_pwd_tel', null);
        session('find_pwd_tel', I('post.phone'));
        //验证码判断
        if (session('authcode') != md5($_POST['verifyimg'])) {
            $result = "4";
            //图片验证码不正确
            echo json_encode($result);
            return;
        }
        //更新一下
        $sms_code = $this->sms_code();
        //生成验证码
        session('authcode', $sms_code);
        //开始发送短信
        $User = M('User');
        if ($_POST['type'] == 'register') {
            //会员注册发送验证码
            if ($User->where(array('tel' => I('post.phone')))->getField('uid')) {
                $result = "0";
                //该手机号已经注册
            } else {
                if (cookie('send_time')) {
                    $result = "-1";
                    //操作过于频繁
                } else {
                    $sms_code = $this->sms_code();
                    //生成验证码
                    $content = "您的验证码是：" . $sms_code . "";
                    $send_result = send_message($_POST['phone'], $content);
                    //发送验证码
                    cookie('send_time', '1', 120);
                    $result = "1";
                    //发送成功
                }
            }
        } elseif ($_POST['type'] == 'forgot') {
            //会员找回密码发送验证码
            if ($User->where(array('tel' => I('post.phone')))->getField('uid')) {
                if (cookie('send_time')) {
                    $result = "-1";
                    //操作过于频繁
                } else {
                    $sms_code = $this->sms_code();
                    //生成验证码
                    $content = "您的验证码是：" . $sms_code . "";
                    $send_result = send_message($_POST['phone'], $content);
                    //发送验证码
                    cookie('send_time', '1', 120);
                    $result = "1";
                    //发送成功
                }
            } else {
                $result = "2";
                //不存在该用户
            }
        } else {
            //非法操作
            $result = "3";
            //系统错误
        }
        echo json_encode($result);
        //jsonp请求
    }
    //验证验证码
    public function verify_code()
    {
        $sms_code = session('sms_code');
        if ($_POST['verify'] == $sms_code && !empty($sms_code)) {
            $result = "1";
            //验证成功
        } else {
            $result = "0";
            //验证失败
        }
        echo json_encode($result);
        //jsonp请求
    }
    /**本模块所有私有函数
     **/
    //生成验证码
    protected function sms_code()
    {
        $sms_code = rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9) . rand(0, 9);
        session(array('sms_code' => 'sms_code', 'expire' => 600));
        session('sms_code', $sms_code);
        return $sms_code;
    }
    //判断用户是否登录
    protected function is_login2()
    {
        $uid = session('uid');
        if (!empty($uid)) {
            header("location:" . U('User/index'));
        }
    }
    //获取面包屑标题
    protected function assign_ur_here($title, $bread)
    {
        //$bread  是一个数组   array   $bread = array('title'=>'ThinkPHP','url'=>'ThinkPHP@gmail.com');
        $breadcrumb = "<a href=" . U('Index/index') . ">首页</a>";
        foreach ($bread as $key => $v) {
            $breadcrumb .= "><a href='" . $v['url'] . "'>" . $v['title'] . "</a>";
        }
        $this->assign('breadcrumb', $breadcrumb);
        $this->assign('seo_title', $title);
    }
    //获取用户信息
    protected function get_user()
    {
        $uid = session('uid');
        $User = M('User');
        $u = $User->where(array('uid' => session('uid')))->find();
        $this->assign('user', $u);
    }
    //判断是否登录
    protected function is_login()
    {
        $uid = session('uid');
        if (empty($uid)) {
            return false;
        }
        return true;
    }
    /**
     * 图片验证码
     */
    public function verifycode()
    {
        import('ORG.Util.Image');
        Image::buildImageVerify(5, 1, 'png', '100', '30', 'authcode');
    }
    public function search()
    {
        $this->display();
    }
    public function searchList()
    {
        $this->display();
    }
    public function getCart()
    {
        $mycartgoods = R('Putcart/getcart');
        echo json_encode($mycartgoods);
    }
    //空操作处理，所有空操作都指向空模块
    public function _empty()
    {
        $this->redirect('Empty/index');
    }
    //下载
    public function downLoad()
    {
        $this->assign_ur_here('APP移动端下载', array(array('title' => 'APP移动端下载', 'url' => U('Index/downLoad'))));
        $this->display();
    }
    
    
    public function token(){
        import ( "ORG.Util.ThinkWechat" );
		$weixin = new ThinkWechat ();
		$weixin->getAcessToken1();
    }
    
    //在等待打印的订单里面取出第一条
    function waitPrintOrder(){
        $Wait = M('Orders_wait_print');
        $wait = $Wait->where(['is_print'=>2])->find();
        !$wait && out_info(500,'暂无订单');
        $data['oid'] = $wait['oid'];
        out_info(200,'成功',$data);
    }
    //获取订单详情以供打印
    function orderIframe(){
        //获取订单及商品
        $Orders = M('Orders');
        $orders = $Orders->where(['oid'=>I('get.oid')])->find();
        $Ordergoods = M('Ordergoods');
        $ordergoods =  $Ordergoods->where(['order_no'=>$orders['order_no']])->select();
        $this->assign('orders',$orders);
        $this->assign('ordergoods',$ordergoods);
        //设为已经打印
        $Wait = M('Orders_wait_print');
        $re = $Wait->where(['oid'=>I('get.oid')])->setField('is_print',1);
        $this->display();
    }
    function jsOrderPrint(){
        //获取订单及商品
        $Orders = M('Orders');
        $orders = $Orders->where(['oid'=>I('get.oid')])->find();
        $Ordergoods = M('Ordergoods');
        $ordergoods =  $Ordergoods->where(['order_no'=>$orders['order_no']])->select();
        $this->assign('orders',$orders);
        $this->assign('ordergoods',$ordergoods);
        //设为已经打印
        $Wait = M('Orders_wait_print');
        $re = $Wait->where(['oid'=>I('get.oid')])->setField('is_print',1);
        $this->display();
    }
    
}
?>