<?php
class WxpayComputer extends Action
{
    //在类初始化方法中，引入相关类库
    public function _initialize()
    {
        if (I('get.payid')) {
            //获得payid
            $Pay_way = M('Pay_way');
            $payway = $Pay_way->where(array('id' => I('get.payid')))->find();
            if (!$payway) {
                $this->error('参数错误!');
            }
            $payway['key'] = unserialize($payway['key']);
            define("APPID", $payway['key'][0]);
            define("APPSECRET", $payway['key'][1]);
            define("MCHID", $payway['key'][2]);
            define("KEY", $payway['key'][3]);
        }
        header("Content-type:text/html;charset=utf-8");
        vendor('WxPayPubHelper.SDKRuntimeException');
        define("JS_API_CALL_URL", C('site_url') . U('Wxpay/wap_dowxpay'));
        define('SSLCERT_PATH', C('site_url') . '/Framework/Extend/Vendor/WxPayPubHelper/cacert/apiclient_cert.pem');
        define('SSLKEY_PATH', C('site_url') . '/Framework/Extend/Vendor/WxPayPubHelper/cacert/apiclient_key.pem');
        define('NOTIFY_URL', C('site_url') . '/index.php/Wxpay/notifyurl/payid/' . I('get.payid'));
        define('CURL_TIMEOUT', 30);
        vendor('WxPayPubHelper.WxPayPubHelper');
    }
    public function dowxpay()
    {
        //使用统一支付接口
        $unifiedOrder = new UnifiedOrder_pub();
        $fee = $_POST['pay_cash'] * 100;
        //echo "'".$_POST['mas_id']."'";
        //设置统一支付接口参数
        //设置必填参数
        //appid已填,商户无需重复填写
        //mch_id已填,商户无需重复填写
        //noncestr已填,商户无需重复填写
        //spbill_create_ip已填,商户无需重复填写
        //sign已填,商户无需重复填写
        if (I('get.type') == 1) {
            $unifiedOrder->setParameter("body", "订单付款");
            //商品描述
            //自定义订单号，此处仅作举例
            $out_trade_no = $_POST['order_no'];
            //订单支付重新从数据库读取付款金额
            $Orders = M('Orders');
            $fee = $Orders->where(array('order_no' => $_POST['order_no']))->getField('pay_cash') * 100;
        } else {
            $out_trade_no = date("YmdHis") . session('uid');
            $unifiedOrder->setParameter("body", "充值付款");
            //商品描述
            $unifiedOrder->setParameter("attach", session('uid'));
            //附加数据
        }
        $unifiedOrder->setParameter("out_trade_no", "{$out_trade_no}");
        //商户订单号
        $unifiedOrder->setParameter("total_fee", $fee);
        //总金额
        $unifiedOrder->setParameter("notify_url", NOTIFY_URL);
        //通知地址
        $unifiedOrder->setParameter("trade_type", "NATIVE");
        //交易类型
        //非必填参数，商户可根据实际情况选填
        //$unifiedOrder->setParameter("sub_mch_id","XXXX");//子商户号
        //$unifiedOrder->setParameter("device_info","XXXX");//设备号
        //$unifiedOrder->setParameter("attach","'".$_POST['mas_id']."'");//附加数据
        //$unifiedOrder->setParameter("time_start","XXXX");//交易起始时间
        //$unifiedOrder->setParameter("time_expire","XXXX");//交易结束时间
        //$unifiedOrder->setParameter("goods_tag","XXXX");//商品标记
        //$unifiedOrder->setParameter("openid","XXXX");//用户标识
        //$unifiedOrder->setParameter("product_id","XXXX");//商品ID
        //获取统一支付接口结果
        $unifiedOrderResult = $unifiedOrder->getResult();
        //print_r($unifiedOrderResult);
        //商户根据实际情况设置相应的处理流程
        if ($unifiedOrderResult["return_code"] == "FAIL") {
            //商户自行增加处理流程
            echo "通信出错：" . $unifiedOrderResult['return_msg'] . "<br>";
        } elseif ($unifiedOrderResult["result_code"] == "FAIL") {
            //商户自行增加处理流程
            echo "错误代码：" . $unifiedOrderResult['err_code'] . "<br>";
            echo "错误代码描述：" . $unifiedOrderResult['err_code_des'] . "<br>";
        } elseif ($unifiedOrderResult["code_url"] != NULL) {
            //从统一支付接口获取到code_url
            $code_url = $unifiedOrderResult["code_url"];
            //商户自行增加处理流程
            //......
        }
        $this->assign('code_url', $code_url);
        $this->assign('out_trade_no', $out_trade_no);
        $this->assign('payid', I('get.payid'));
        $this->assign('type', I('get.type'));
        $this->display();
    }
    /******************************
    	服务器异步通知页面方法
    	其实这里就是将notify_url.php文件中的代码复制过来进行处理
    	
    	*******************************/
    public function notifyurl()
    {
        //使用通用通知接口
        $notify = new Notify_pub();
        //存储微信的回调
        $xml = $GLOBALS['HTTP_RAW_POST_DATA'];
        $notify->saveData($xml);
        //验证签名，并回应微信。
        //对后台通知交互时，如果微信收到商户的应答不是成功或超时，微信认为通知失败，
        //微信会通过一定的策略（如30分钟共8次）定期重新发起通知，
        //尽可能提高通知的成功率，但微信不保证通知最终能成功。
        if ($notify->checkSign() == FALSE) {
            $notify->setReturnParameter("return_code", "FAIL");
            //返回状态码
            $notify->setReturnParameter("return_msg", "签名失败");
            //返回信息
        } else {
            $notify->setReturnParameter("return_code", "SUCCESS");
            //设置返回码
        }
        $returnXml = $notify->returnXml();
        echo $returnXml;
        //==商户根据实际情况设置相应的处理流程，此处仅作举例=======
        //$log_name="notify_url.log";//log文件路径
        //$this->log_result($log_name,"【接收到的notify通知】:\n".$xml."\n");
        if ($notify->checkSign() == TRUE) {
            if ($notify->data["return_code"] == "FAIL") {
                //此处应该更新一下订单状态，商户自行增删操作
                //$this->log_result($log_name,"【通信出错】:\n".$xml."\n");
            } elseif ($notify->data["result_code"] == "FAIL") {
                //此处应该更新一下订单状态，商户自行增删操作
                //$this->log_result($log_name,"【业务出错】:\n".$xml."\n");
            } else {
                //此处应该更新一下订单状态，商户自行增删操作
                //买家支付成功，开始修改订单的支付方式和付款状态
                //$this->log_result($log_name,$out_trade_no."【支付成功0000】:\n".$xml."\n");
                if ($notify->data["attach"]) {
                    $re = edit_user_account($notify->data["attach"], 0, '使用微信充值' . $notify->data["total_fee"] / 100 . '元',$notify->data["total_fee"] / 100, 0, 0, 0, I('get.payid'), $notify->data["transaction_id"]);
                    if ($re) {
                        echo "success";
                    }
                } else {
                    $pay_cash = M('Orders')->where(array('order_no'=>$notify->data["out_trade_no"]))->getField('pay_cash');
                    if($notify->data["total_fee"]/100 != $pay_cash){
                        exit;
                    }
                    $re = payCallHandle($notify->data["out_trade_no"],I('get.payid'),$notify->data["total_fee"]/100,$notify->data["transaction_id"]);
                }
            }
        }
    }
    //查询订单的支付状态
    public function order_query()
    {
        //退款的订单号
        if (!isset($_GET["out_trade_no"])) {
            $out_trade_no = " ";
        } else {
            $out_trade_no = $_GET["out_trade_no"];
            //使用订单查询接口
            $orderQuery = new OrderQuery_pub();
            $orderQuery->setParameter("out_trade_no", "{$out_trade_no}");
            //商户订单号
            //获取订单查询结果
            $orderQueryResult = $orderQuery->getResult();
            //商户根据实际情况设置相应的处理流程,此处仅作举例
            if ($orderQueryResult["return_code"] == "FAIL") {
                echo json_encode($orderQueryResult["return_code"]);
            } elseif ($orderQueryResult["result_code"] == "FAIL") {
                echo json_encode($orderQueryResult["result_code"]);
            } else {
                echo json_encode($orderQueryResult['trade_state']);
            }
        }
    }
    //空操作处理，所有空操作都指向空模块
    public function _empty()
    {
        $this->redirect('Empty/index');
    }
    //获取面包屑标题
    protected function assign_ur_here($title, $bread)
    {
        //$bread  是一个数组   array   $bread = array('title'=>'ThinkPHP','url'=>'ThinkPHP@gmail.com');
        $breadcrumb = "<a href=" . U('Index/index') . ">首页</a>";
        foreach ($bread as $key => $v) {
            $breadcrumb .= "><a href='" . $v['url'] . "'>" . $v['title'] . "</a>";
        }
        $this->assign('breadcrumb', $breadcrumb);
        $this->assign('seo_title', $title);
    }
}
?>