<?php
class PutcartMobile extends Action
{
    /*
      错误代码
      001    成功
      002    传参错误
      003    购物车中不存在该商品
      004    库存不够
      005    购买数量超过限购数量
      
      参数
      goods_sn      商品货号
      gid           商品ID
      num           数量
      goods_attr     属性
    */
    public function _initialize()
    {
        header("Content-Type:text/html; charset=utf-8");
    }
    /*
      添加商品
      param int $gid 商品主键
      string $goods_sn 商品货号
      float $goods_attr 商品属性
      int   $num 购物数量
    */
    public function addcart()
    {
        if (!(is_int(intval($_POST['gid'])) && $_POST['gid'] > 0 && is_int(intval($_POST['num'])) && $_POST['num'] > 0 && !empty($_POST['goods_sn']))) {
            $datas['data'] = '传参错误';
            $datas['re'] = '002';
            echo json_encode($datas);
            exit;
        }
        //获取当前商品的库存
        $goods_number = getgoodnum($_POST['goods_sn']);
        if ($this->is_login()) {
            $goodscartsql = M('cart');
            //如果session中有数据，把数据导入数据库
            $this->s2s($goodscartsql);
            // 判断session中的购物车数据↑
            // 插入数据库-购物车中
            $where = array('uid' => $_SESSION['uid'], 'goods_sn' => $_POST['goods_sn']);
            $data = array('goods_sn' => $_POST['goods_sn'], 'gid' => $_POST['gid'], 'num' => $_POST['num'], 'goods_attr' => $_POST['goods_attr'], 'uid' => $_SESSION['uid']);
            $cartgoodsnum = $goodscartsql->where($where)->getField('num');
            //获取购物车中商品数量
            if (!$cartgoodsnum) {
                //判断一下，加入购物车的数量是否在库存范围内
                $this->is_enough($_POST['goods_sn'], $goods_number, $_POST['num']);
                //如果购物车里面没有，新增
                $goodscartsql->add($data);
            } else {
                //如果购物车里面有，增加
                //判断一下，加入购物车的数量是否在库存范围内
                $this->is_enough($_POST['goods_sn'], $goods_number, $_POST['num'] + $cartgoodsnum);
                $goodscartsql->where($where)->setInc('num', $_POST['num']);
            }
            $mycart['data'] = $goodscartsql->where(array('uid' => $_SESSION['uid']))->select();
        } else {
            $_POST['num'] = $_SESSION['mycart']['data'][$_POST['goods_sn']]['num'] + $_POST['num'];
            //判断一下，加入购物车的数量是否在库存范围内
            $this->is_enough($_POST['goods_sn'], $goods_number, $_POST['num']);
            $_SESSION['mycart']['data'][$_POST['goods_sn']] = array('goods_sn' => $_POST['goods_sn'], 'gid' => $_POST['gid'], 'num' => $_POST['num'], 'goods_attr' => $_POST['goods_attr']);
            $mycart['data'] = $_SESSION['mycart']['data'];
        }
        $datas['data'] = $this->getcartdata($mycart);
        $datas['re'] = '001';
        echo json_encode($datas);
    }
    /*
      把缓存里面的商品，转移到数据库
      $goodcartsql    实例化后的  M('cart')
    */
    protected function s2s($goodscartsql)
    {
        // 判断session中的购物车数据
        if (!empty($_SESSION['mycart']['data'])) {
            foreach ($_SESSION['mycart']['data'] as $k => $v) {
                if ($v > 0) {
                    $where = array('uid' => $_SESSION['uid'], 'goods_sn' => $k);
                    $data = array('goods_sn' => $v['goods_sn'], 'gid' => $v['gid'], 'num' => $v['num'], 'goods_attr' => $v['goods_attr'], 'uid' => $_SESSION['uid']);
                    $goodscartsql->add($data);
                }
            }
            $_SESSION['mycart'] = null;
        }
    }
    /*
      更新购物车中的数量
      string $goods_sn 商品货号
      int   $num 购物数量
    */
    public function update()
    {
        if (!(is_int(intval($_POST['num'])) && $_POST['num'] > 0 && !empty($_POST['goods_sn']))) {
            $datas['data'] = '传参错误';
            $datas['re'] = '002';
            echo json_encode($datas);
            exit;
        }
        //获取当前商品的库存
        $goods_number = getgoodnum($_POST['goods_sn']);
        if ($this->is_login()) {
            $goodscartsql = M('cart');
            $this->s2s($goodscartsql);
            $cartgoodsnum = $goodscartsql->where(array('uid' => $_SESSION['uid'], 'goods_sn' => $_POST['goods_sn']))->getField('num');
            //获取购物车中商品数量
            if (!$cartgoodsnum) {
                // 没有找到购物车的物品
                $datas['data'] = '没有找到购物车的物品';
                $datas['re'] = '003';
                echo json_encode($datas);
                exit;
            } else {
                //判断一下，加入购物车的数量是否在库存范围内
                $this->is_enough($_POST['goods_sn'], $goods_number, $_POST['num']);
                $re = $goodscartsql->where(array('uid' => $_SESSION['uid'], 'goods_sn' => $_POST['goods_sn']))->setField('num', $_POST['num']);
                if ($re !== false) {
                    $datas['data'] = $this->getcart();
                    $datas['re'] = '001';
                    //echo $datas;
                    echo json_encode($datas);
                    exit;
                } else {
                    $datas['data'] = '没有找到购物车的物品';
                    $datas['re'] = '003';
                    echo json_encode($datas);
                    exit;
                }
            }
        } else {
            if (empty($_SESSION['mycart']['data'][$_POST['goods_sn']])) {
                $datas['data'] = '没有找到购物车的物品';
                $datas['re'] = '003';
                echo json_encode($datas);
                exit;
            } else {
                //判断一下，加入购物车的数量是否在库存范围内
                $this->is_enough($_POST['goods_sn'], $goods_number, $_POST['num']);
                $_SESSION['mycart']['data'][$_POST['goods_sn']]['num'] = $_POST['num'];
            }
            $datas['data'] = $this->getcart();
            $datas['re'] = '001';
            echo json_encode($datas);
            exit;
        }
    }
    /*
      读取购物车里面的商品详细信息
      string $mycart 购物车里面的商品
    */
    public function getcartdata($mycart)
    {
        if ($mycart['data']) {
            $goodssql = M('goods');
            $attrsql = D('GoodsAttrAttrView');
            $Products = M('Products');
            
            //先循环一遍$mycart['data'] ,把所有的属性都找出来,再通过属性把所有有价格的属性的价格都找出来,分别循环重组数组
            $attr_arr = [];//存属性的数组
            foreach($mycart['data'] as $k => $v){
                if(strpos($v['goods_sn'] ,'_') !== false){
                    //说明是含属性商品
                    //把$v['goods_sn']拆成数组
                    $attr_linshi = explode('_', $v['goods_sn']);
                    foreach($attr_linshi as $kk => $vv){
                        if($kk == 0){
                            continue;
                        }
                        !$attr_arr[$vv] && $attr_arr[$vv] = $vv;
                    }
                }
            }
            $goodsAttrAttr = $attrsql->where(array('goods_attr_id'=>array('in',$attr_arr)))->getField('goods_attr_id,attr_price,attr_show_type');
            $attr_arr_end = [];//最终处理得到的数组
            foreach($attr_arr as $k => $v){
                $attr_arr_end[$k] = $goodsAttrAttr[$k]['attr_show_type'] == 1 ? $goodsAttrAttr[$k]['attr_price'] : 0;
            }
            //dump($attr_arr_end);
            
            foreach ($mycart['data'] as $k => $v) {
                $where = array('gid' => $v['gid']);
                $gdata = $goodssql->where($where)->find();
                if (!$gdata) {
                    unset($mycart['data'][$k]);
                    continue;
                }
                //如果该商品存在限时抢购，切换价格
                if (strtotime($gdata['end_time']) >= time() && strtotime($gdata['start_time']) <= time() && $gdata['is_promote'] == 1) {
                    $gdata['price'] = $gdata['promote_price'];
                }
                //$attr_price = $attrsql->where(array('goods_id' => $attr[0], 'goods_attr_id' => $attr[1]))->getField('attr_price');
                $attr_price = 0;
                if(strpos($v['goods_sn'] ,'_') !== false){
                    //$v['goods_sn'] = str_replace($v['gid']."_", "",$v['goods_sn']);
                    //$v['goods_sn'] = str_replace("_", "|",$v['goods_sn']);
                    
                    $param1 = explode('_', $v['goods_sn']);
                    unset($param1[0]);
        
                    $v['goods_sn'] = implode('|',$param1);
                    
                    //判断是否有库存
                    
                    $products = $Products->where(['goods_attr'=>$v['goods_sn']])->find();
                    if(!$products or $products['product_number'] <= 0){
                        unset($mycart['data'][$k]);
                        continue;
                    }
                    
                    $attr = explode('|', $v['goods_sn']);
                    //dump($attr);
                    foreach ($attr as $kk => $vv) {
                        //dump($vv);
   
                        $attr_price += $attr_arr_end[$vv];
                        
                    }
                }
                
                $mycart['data'][$k]['img'] = $gdata['img'];
                $mycart['data'][$k]['name'] = $gdata['name'];
                $mycart['data'][$k]['price'] = $gdata['price'] + $attr_price;
                $mycart['data'][$k]['total'] = ($gdata['price'] + $attr_price) * $v['num'];
                $mycart['data'][$k]['give_integral'] = $gdata['give_integral'];
                $mycart['data'][$k]['use_integral'] = $gdata['use_integral'];
                $mycart['total']['num'] = $mycart['total']['num'] + $mycart['data'][$k]['num'];
                $mycart['total']['money'] = $mycart['total']['money'] + $mycart['data'][$k]['total'];
                $mycart['total']['use_integral_t'] = $mycart['total']['use_integral_t'] + $gdata['use_integral'] * $v['num'];
                $mycart['total']['give_integral_t'] = $mycart['total']['give_integral_t'] + $gdata['give_integral'] * $v['num'];
            }
        } else {
            $mycart['data'] = '';
        }
        return $mycart;
    }
    /*
      读取购物信息
    */
    public function getcart()
    {
        if ($this->is_login()) {
            $goodscartsql = M('cart');
            $this->s2s($goodscartsql);
            $mycart['data'] = $goodscartsql->where(array('uid' => $_SESSION['uid']))->select();
        } else {
            $mycart['data'] = $_SESSION['mycart']['data'];
        }
        return $this->getcartdata($mycart);
    }
    /*
      读取购物信息
    */
    public function getcartinfor()
    {
        $datas['data'] = $this->getcart();
        $datas['re'] = '001';
        echo json_encode($datas);
    }
    /*
      清空购物车
    */
    public function emptycart()
    {
        if ($this->is_login()) {
            $goodscartsql = M('cart');
            $goodscartsql->where(array('uid' => $_SESSION['uid']))->delete();
            $_SESSION['mycart'] = '';
        } else {
            $_SESSION['mycart'] = '';
        }
        $datas['data'] = $this->getcart();
        $datas['re'] = '001';
        echo json_encode($datas);
    }
    /*
      删除购物车的某个物品
      string $goods_sn 商品货号
    */
    public function deletecart()
    {
        if (empty($_POST['goods_sn'])) {
            $datas['data'] = '传参错误';
            $datas['re'] = '002';
            echo json_encode($datas);
            exit;
        }
        if ($this->is_login()) {
            $goodscartsql = M('cart');
            $this->s2s($goodscartsql);
            if (!$goodscartsql->where(array('goods_sn' => $_POST['goods_sn'], 'uid' => $_SESSION['uid']))->find()) {
                $datas['data'] = '没有找到购物车的物品';
                $datas['re'] = '003';
                echo json_encode($datas);
                exit;
            } else {
                $dew = $goodscartsql->where(array('goods_sn' => $_POST['goods_sn'], 'uid' => $_SESSION['uid']))->delete();
                $datas['data'] = $this->getcart();
                $datas['re'] = '001';
                echo json_encode($datas);
                exit;
            }
        } else {
            if (empty($_SESSION['mycart']['data'][$_POST['goods_sn']])) {
                $datas['data'] = '没有找到购物车的物品';
                $datas['re'] = '003';
                echo json_encode($datas);
                exit;
            } else {
                unset($_SESSION['mycart']['data'][$_POST['goods_sn']]);
            }
            $datas['data'] = $this->getcart();
            $datas['re'] = '001';
            echo json_encode($datas);
            exit;
        }
    }
    /*
      获取购物车的某个物品的数量
      string $goods_sn 商品货号
    */
    public function getcartgoodnum($goods_sn)
    {
        $num = 0;
        $goodscartsql = M('cart');
        if ($this->is_login()) {
            $where = array('uid' => $_SESSION['uid'], 'goods_sn' => $goods_sn);
            $num = $goodscartsql->where($where)->getField('num');
            //获取购物车中商品数量
        } else {
            $num = $_SESSION['mycart']['data'][$goods_sn]['num'];
        }
        return $num;
    }
    /* 判断一下，加入购物车的商品是否是限时抢购，如果是，判断是否购买数量超过限度
     *  string $goods_sn    商品ID
     *  string $num         购买数量
     *  string $cartnum         购物车里面的数量
     */
    protected function is_enough_promote($goods_sn, $num)
    {
        //如果goods_sn包含_，说明是含属性商品
        $param = array();
        $param = explode('_', $goods_sn);
        //先判断一下是否是促销
        $goodssql = M('goods');
        $gdata = $goodssql->where(array('gid' => $param[0]))->find();
        if (strtotime($gdata['end_time']) >= time() && $gdata['is_promote'] == 1 && $gdata['promote_num'] > 0) {
            $cartnum = 0;
            $goodscartsql = M('cart');
            if ($this->is_login()) {
                if ($goodscartsql->where(array('uid' => $_SESSION['uid'], 'goods_sn' => $goods_sn))->find()) {
                    $cartnum = $num;
                } else {
                    $where = array('uid' => $_SESSION['uid'], 'gid' => $gdata['gid']);
                    $cartnum = $goodscartsql->where($where)->sum('num');
                    //获取购物车中商品数量
                    $cartnum += $num;
                }
            } else {
                foreach ($_SESSION['mycart']['data'] as $key => $v) {
                    if ($v['gid'] == $gdata['gid']) {
                        if ($goods_sn == $key) {
                            $cartnum += $num;
                        } else {
                            $cartnum += $v['num'];
                        }
                    }
                }
                if (empty($_SESSION['mycart']['data'][$goods_sn])) {
                    $cartnum += $num;
                }
            }
            if ($gdata['promote_num'] < $cartnum) {
                $datas['data'] = '购买数量超过限购数量！';
                $datas['re'] = '005';
                echo json_encode($datas);
                exit;
            }
        }
    }
    /* 判断一下，加入购物车的数量是否在库存范围内
     *  string $goods_sn    商品货号
     *  string $good_number 商品库存
     *  string $num         购买数量
     */
    protected function is_enough($goods_sn, $goods_number, $num)
    {
        if ($goods_number < $num) {
            $datas['data'] = '库存不足';
            $datas['re'] = '004';
            echo json_encode($datas);
            exit;
        }
        $this->is_enough_promote($goods_sn, $num);
    }
    // 判断是否登录
    function is_login()
    {
        if (empty($_SESSION['uid'])) {
            return false;
        }
        return true;
    }
    // 空操作处理，所有空操作都指向空模块
    function _empty()
    {
        exit;
        $this->redirect('Empty/index');
    }
}
?>