<?php
class CommonAction extends Action{
    public function _initialize(){
        header("Content-type: text/html; charset=utf-8");
        if(!isset($_SESSION[C('USER_AUTH_KEY')])){
            $this->redirect('Login/index');
        }
        //RBAC认证
        //无需认证模块
        $notAuth=in_array(MODULE_NAME,explode(',',C('NOT_AUTH_MODULE'))) || in_array(ACTION_NAME,explode(',',C('NOT_AUTH_ACTION')));
        if(C('USER_AUTH_ON') && !$notAuth){
            import('ORG.Util.RBAC');
            $accessList = RBAC::getAccessList($_SESSION[C('USER_AUTH_KEY')]);
            if(!RBAC::AccessDecision()){
                $this->error('您没有访问权限!');
            }
        }
        if(session(C('ADMIN_AUTH_KEY'))){
            $nav=D('Node')->where(array('level'=>2))->order('sort desc')->relation(true)->select();
            foreach($nav as $k=>$v){
                foreach($v['node'] as $kk=>$vv){
                    if($vv['is_nav']=='0'){
                        unset($nav[$k]['node'][$kk]);
                    }
                }
                if(empty($nav[$k]['node'])){
                    unset($nav[$k]);
                }
                if($nav[$k]['node']){
                    $nav[$k]['node'] = array_values($nav[$k]['node']);
                }
            }
        }else{
            //取出所有权限节点
            $nav=D('Node')->where(array('level'=>2))->order('sort desc')->relation(true)->select();
            //取出当前登录用户所有模块权限(英文名称)和操作权限的id
            $module='';
            $node_id='';
            $accessList=$_SESSION['_ACCESS_LIST'];
            foreach($accessList as $k=>$v){
                foreach($v as $kk=>$vv){
                    $module=$module.','.$kk;
                    foreach($vv as $kkk=>$vvv){
                        $node_id=$node_id.','.$vvv;
                    }
                }
            }
            //去除没有权限的节点
            foreach($nav as $k=>$v){
                if(!in_array(strtoupper($v['name']),explode(',',$module))){
                    unset($nav[$k]);
                }else{
                    //模块存在,比较里面的操作
                    foreach($v['node'] as $kk=>$vv){
                        if(!in_array($vv['id'],explode(',',$node_id)) || $vv['is_nav']=='0'){
                            unset($nav[$k]['node'][$kk]);
                        }
                    }
                    if(empty($nav[$k]['node'])){
                        unset($nav[$k]);
                    }
                }
                if($nav[$k]['node']){
                    $nav[$k]['node'] = array_values($nav[$k]['node']);
                }
            }
        }
        
        if(session(C('USER_AUTH_KEY')) and ACTION_NAME!='logout'){
            if(MODULE_NAME!='Index'){
                //判断是不是导航
                $Node=M('Node');
                $is_nav=$Node->where(array('name'=>ACTION_NAME,'level'=>3))->getField('is_nav');
            }else{
                $is_nav=1;
            }
            if($is_nav){
                $login_url=array();
                $login_url[C('USER_AUTH_KEY')]=session(C('USER_AUTH_KEY'));
                $login_url['url']='http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI'];
                cookie('login_url',$login_url,0);  
            }
        }
        
        
        //取出所有的控制器
        $controllList = M('Node')->where(['level'=>2])->getField('id,name');
        foreach($nav as $k => $v){
            foreach($v['node'] as $kk => $vv){
                $nav[$k]['node'][$kk]['module_name'] = $controllList[$vv['pid']];
                if(MODULE_NAME.'/'.ACTION_NAME == $nav[$k]['node'][$kk]['module_name'].'/'.$vv['name']){
                    $nav[$k]['is_active'] = 1;
                    $nav[$k]['node'][$kk]['is_active'] = 1;
                }
            }
        }
        $this->assign('nav',$nav);
    }
}

?>