<?php
class GoodsAction extends CommonAction {
  
	public function cate(){
	    $Cate = M('Cate'); 
		//先获取一级分类
		$catelist = $Cate->order('c_order desc')->select();
		$catelist = cate_merge($catelist);
		$this->assign('catelist',$catelist);// 赋值数据集
		$this->display();
    }
    
    //新增分类
    public function addCate(){
        $Cate = M('Cate'); 
        if(IS_POST){
            import('ORG.Net.UploadFile');
			$upload = new UploadFile();// 实例化上传类
			$upload->maxSize  = 3145728 ;// 设置附件上传大小
			$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
			$upload->savePath =  'Public/Uploads/CateIcon/';// 设置附件上传目录
			if(!$upload->upload()) {// 上传错误提示错误信息
			}else{// 上传成功 获取上传文件信息
			    $info =  $upload->getUploadFileInfo();
			    $Cate->photo = $info[0]['savename']; // 保存上传的照片根据需要自行组装
		    	$_POST['icon'] = $info[0]['savename'];
			}
            $_POST['filter_attr']  = !empty($_POST['filter_attr'])  ? implode(',', array_unique(array_diff($_POST['filter_attr'],array(0)))) : 0;
            if(strpos($_POST['name'], '#')!==false)
            {
                $namearr=explode('#',$_POST['name']);
                foreach($namearr as $key=>$value)
                {
                    $_POST['name']=$value;
                    $re=$Cate->add($_POST);
                    if(!$re)
                    {
                        $this->error('新增失败'.$Cate->getLastSql());
                    }
                }
            }else{
                $re=$Cate->add($_POST);
            }
            if($re){
                setScache('Cate','','c_order desc');
			    $this->success('新增成功',U('Index/gb'));
			}else{
			    $this->error('新增失败');
			}
        }else{
            //先获取一级分类
    		$catelist = $Cate->order('c_order desc')->select();
    		$catelist = cate_merge($catelist);
    		$this->assign('catelist',$catelist);// 赋值数据集
    		
    		//获取商品类型goods_type表
    		$Goods_type = M('Goods_type');
    		$goods_type_list = $Goods_type->order('c_order desc')->select();
    		$this->assign('goods_type_list',json_encode($goods_type_list));
    		
    		//获取分类信息
    		$data1=111;
    		$this->assign('data1',$data1);
            $this->display();
        }
    }
    
    //编辑分类
    public function editCate(){
        $Cate = M('Cate'); 
        if(IS_POST){
            import('ORG.Net.UploadFile');
			$upload = new UploadFile();// 实例化上传类
			$upload->maxSize  = 3145728 ;// 设置附件上传大小
			$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
			$upload->savePath =  'Public/Uploads/CateIcon/';// 设置附件上传目录
			if(!$upload->upload()) {// 上传错误提示错误信息
			    unset($_POST['icon']);
			}else{// 上传成功 获取上传文件信息
			    $info =  $upload->getUploadFileInfo();
			    $Cate->photo = $info[0]['savename']; // 保存上传的照片根据需要自行组装
    			$_POST['icon'] = $info[0]['savename'];
    			if($_POST['old_icon']){
    	            unlink("Public/Uploads/CateIcon/".$_POST['old_icon']);
    			}
			}
            $_POST['filter_attr']  = !empty($_POST['filter_attr'])  ? implode(',', array_unique(array_diff($_POST['filter_attr'],array(0)))) : 0;
            if($Cate->save($_POST)!==false){
                setScache('Cate','','c_order desc');
			    $this->success('编辑成功',U('Index/gb'));
			}else{
			    $this->error('编辑失败');
			}
        }else{
            //先获取一级分类
    		$catelist = $Cate->order('c_order desc')->select();
    		$catelist = cate_merge($catelist);
    		$this->assign('catelist',$catelist);// 赋值数据集
    		//获取分类信息
    		$data=$Cate->where(array('cid'=>I('get.cid')))->find();
    		//判断是否有filter_attr
    		if($data['filter_attr']){
    		    $Attribute = M('Attribute');
    		    $Goods_type = M('Goods_type');
    		    $attr_list_array = explode(',',$data['filter_attr']);
    		    foreach($attr_list_array as $k=>$v){
    		        $data1[$k]['attribute']=$Attribute->where(array('attr_id'=>$v))->find();
    		        $data1[$k]['goods_type']=$Goods_type->where(array('cat_id'=>$data1[$k]['attribute']['cat_id']))->find();
    		        $data1[$k]['attribute_list']=$Attribute->where(array('cat_id'=>$data1[$k]['attribute']['cat_id']))->select();
    		    }
    		}else{
    		    $data1=111;
    		}
    		$this->assign('data',$data);
    		$this->assign('data1',json_encode($data1));
    		//获取商品类型goods_type表
    		$Goods_type = M('Goods_type');
    		$goods_type_list = $Goods_type->order('c_order desc')->select();
    		$this->assign('goods_type_list',json_encode($goods_type_list));
    		
            $this->display('addCate');
        }
    }
    
    //删除分类
    public function delCate(){
        $Cate=M('Cate');
        if($Cate->where(array('parentid'=>I('get.cid')))->find()){
		     $this->error('本分类含有下级，不能删除！');
		}
		$Goods = M('Goods'); 
	    if($Goods->where(array('cid'=>I('get.cid')))->find()){
		     $this->error('本分类含有商品，不能删除！');
		}else{
		    if($Cate->where(array('cid'=>I('get.cid')))->delete()){
		        unlink("Public/Uploads/CateIcon/".$cateInfo['icon']);
		        setScache('Cate','','c_order desc');
			    $this->success('删除成功');
			}else{
			    $this->error('删除失败');
			} 
		} 	
    }
    
    //商品列表
	public function goodslist(){
	    session('now_url','http://'.$_SERVER['HTTP_HOST'].$_SERVER['REQUEST_URI']);
        $catelist = $this->get_cate();
		if($_GET['type']=='sales'){
		   $order = 'base_num desc';
		}else{
		   $order = 'gid desc';
		}
		if($_GET['keyword']){
		   $map['name']  = array('like','%'.$_GET['keyword'].'%');
		   $this->assign('keyword',$_GET['keyword']);
		}
		if($_GET['cid']){
		   $map['cid']  = array('eq',$_GET['cid']);
		   $this->assign('cid',$_GET['cid']);
		}
		if($_GET['barcode']){
		   $map['barcode']  = array('eq',$_GET['barcode']);
		   $this->assign('barcode',$_GET['barcode']);
		}
	    $Goods = D('Goods');
		$ordergoods = M('ordergoods');
		import('ORG.Util.Page');// 导入分页类
		$count      = $Goods->where($map)->count();// 查询满足要求的总记录数
		$Page       = new Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个商品');
		$show       = $Page->show();// 分页显示输出
		$list = $Goods->where($map)->relation(true)->order($order)->limit($Page->firstRow.','.$Page->listRows)->select();
		$Attr = D('GoodsAttrAttributeView');
		foreach($list as $k=>$v){
			  if(strtotime($v['end_time']) >= time() && $v['is_promote']==1 ){
			     $list[$k]['is_promote'] = 1;
			  }else{
			     $list[$k]['is_promote'] = 0;
			  }
			  //关联价格的属性数量
			  //$list[$k]['price_attr_num'] = (int) $Attr->where(array('goods_id'=>$v['gid'],'attr_show_type'=>1))->count();
			  //只要有属性,那么就可以显示库存
			  $list[$k]['price_attr_num'] = (int) $Attr->where(array('goods_id'=>$v['gid']))->count();
			  $list[$k]['img'] = getImgUrl(C('GOODS_IMG_URL'),$v['img']);
			  $list[$k]['goods_number_warning'] = $v['goods_number_warning'] ? : C('inventory_warning');
		}
		
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->assign('catename',$catename);
		$this->assign('catelist',$catelist);
		$this->display();
	}
	//商品库存处理
	public function productsList(){
	    $gid = I('get.gid');
	    $map['goods_id'] = $gid;
	    $Goods = M('Goods');
	    $goods = $Goods->where(['gid'=>$gid])->find();
	    $this->assign('goods',$goods);
	    $Products = M('Products');
	    import('ORG.Util.Page');// 导入分页类
		$count      = $Products->where($map)->count();// 查询满足要求的总记录数
		$Page       = new Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个货品');
		$show       = $Page->show();// 分页显示输出
		$list = $Products->where($map)->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('list',$list);
		$this->assign('page',$show);
		//把它所有的属性列出来,比如颜色,配件,系统
		$attribute = get_goods_specifications_list($gid);
		
		foreach ($attribute as $attribute_value)
        {
            //转换成数组
            $_attribute[$attribute_value['attr_id']]['attr_values'][] = $attribute_value['attr_value'];
            $_attribute[$attribute_value['attr_id']]['attr_id'] = $attribute_value['attr_id'];
            $_attribute[$attribute_value['attr_id']]['attr_name'] = $attribute_value['attr_name'];
        }
        $attribute_count = count($_attribute);
        
        $this->assign('attribute_count',          $attribute_count);
        $this->assign('attribute_count_3',        ($attribute_count + 3));
        $this->assign('attribute',                $_attribute);
        $this->assign('product_sn',               $goods['goods_sn'] . '_');
        $this->assign('product_number',           1);
    
        /* 取商品的货品 */
        $product = product_list($gid, '');
        $this->assign('product_list', $product['product']);
        $this->assign('product_null', empty($product['product']) ? 0 : 1);
        $this->assign('goods_id',     $goods_id);
        $this->assign('filter',       $product['filter']);
        $this->assign('full_page',    1);
		$this->display();
	} 
	//快速编辑商品库存数量
	public function edit_product_number(){
	    if(IS_POST){
	        $Products = M('Products');
	        $products = $Products->where(['product_id'=>I('post.product_id')])->find();
	        $re = $Products->where(['product_id'=>I('post.product_id')])->setField('product_number',$_POST['val']);
	        if($re){
	            //修改货品数量
	            $Goods = M('Goods');
	            $Goods->where(['gid'=>$products['goods_id']])->setInc('goods_number',$_POST['val'] - $products['product_number']);
	        }
	        $re !== false ? out_info(200,'修改成功') : out_info(500,'修改失败');
	    }
	}
	//快速编辑商品货号
	public function edit_product_sn(){
	    if(IS_POST){
	        $Products = M('Products');
	        $re = $Products->where(['product_id'=>I('post.product_id')])->setField('product_sn',$_POST['val']);
	        $re !== false ? out_info(200,'修改成功') : out_info(500,'修改失败');
	    }   
	}
	
	//货品处理
	public function productsHandle(){

        $product['goods_id']        = intval($_POST['goods_id']);
        $product['attr']            = $_POST['attr'];
        $product['product_sn']      = $_POST['product_sn'];
        $product['product_number']  = $_POST['product_number'];
    
        /* 是否存在商品id */
        if (empty($product['goods_id']))
        {
            $this->error('商品信息错误');
        }
    
        /* 判断是否为初次添加 */
        $insert = true;
        if (product_number_count($product['goods_id']) > 0)
        {
            $insert = false;
        }
    
        /* 取出商品信息 */
        $Goods = M('Goods');
        $goods = $Goods->where(['gid'=>$product['goods_id']])->find();
        if (empty($goods))
        {
            $this->error('商品信息错误');
        }
        /*  */
        foreach($product['product_sn'] as $key => $value)
        {
            
            //过滤
            $product['product_number'][$key] = empty($product['product_number'][$key]) ? 0 : trim($product['product_number'][$key]); //库存
    
            //获取规格在商品属性表中的id
            foreach($product['attr'] as $attr_key => $attr_value)
            {
                /* 检测：如果当前所添加的货品规格存在空值或0 */
                if (empty($attr_value[$key]))
                {
                    continue 2;
                }
    
                $is_spec_list[$attr_key] = 'true';
    
                $value_price_list[$attr_key] = $attr_value[$key] . chr(9) . ''; //$key，当前
    
                $id_list[$attr_key] = $attr_key;
            }
            $goods_attr_id = handle_goods_attr($product['goods_id'], $id_list, $is_spec_list, $value_price_list);
            
            /* 是否为重复规格的货品 */
            $goods_attr = sort_goods_attr_id_array($goods_attr_id);
            
            $goods_attr = implode('|', $goods_attr['sort']);
            if (check_goods_attr_exist($goods_attr, $product['goods_id']))
            {
                continue;
                //sys_msg($_LANG['sys']['wrong'] . $_LANG['exist_same_goods_attr'], 1, array(), false);
            }
            //货品号不为空
            if (!empty($value))
            {
                /* 检测：货品货号是否在商品表和货品表中重复 */
                if (check_goods_sn_exist($value))
                {
                    continue;
                    //sys_msg($_LANG['sys']['wrong'] . $_LANG['exist_same_goods_sn'], 1, array(), false);
                }
                if (check_product_sn_exist($value))
                {
                    continue;
                    //sys_msg($_LANG['sys']['wrong'] . $_LANG['exist_same_product_sn'], 1, array(), false);
                }
            }
    
            /* 插入货品表 */
            $data = [
                'goods_id' => $product['goods_id'],
                'goods_attr' => $goods_attr,
                'product_sn' => $value,
                'product_number' => $product['product_number'][$key],
            ];
            
            $re = M('products')->add($data);
            
            if (!$re)
            {
                continue;
                //sys_msg($_LANG['sys']['wrong'] . $_LANG['cannot_add_products'], 1, array(), false);
            }
    
            //货品号为空 自动补货品号
            if (empty($value))
            {
                $sql = "UPDATE " . table('products') . "
                        SET product_sn = '" . $goods['goods_sn'] . "g_p" . $re . "'
                        WHERE product_id = '" . $re . "'";
                M('products')->query($sql);
            }
    
            /* 修改商品表库存 */
            $product_count = product_number_count($product['goods_id']);
            update_goods($product['goods_id'], 'goods_number', $product_count);
            
        }
        
        $this->success('操作成功');
	}
	
	//删除货品
	public function delProducts(){
	    /* 是否存在商品id */
        if (empty($_GET['id']))
        {
            out_info(500,'参数错误');
        }
        else
        {
            $product_id = intval($_GET['id']);
        }
    
        /* 货品库存 */
        $Products = M('Products');
        $product = $Products->where(['product_id'=>$product_id])->find();
    
        /* 删除货品 */
        $del = $Products->where(['product_id'=>$product_id])->delete();
        if ($del)
        {
            /* 修改商品库存 */
            
            $Goods = M('Goods');
            $goods =$Goods->where(['gid'=>$product['goods_id']])->find();
            update_goods($product['goods_id'], 'goods_number', $goods['goods_number'] - $products['product_number']);
            
            out_info(200,'删除成功');
        }else{
            out_info(500,'删除失败');
        }
	}
	
	
	
	//新增商品
	public function addgoods(){
        $Goods = D('Goods');
		//编辑商品，获取商品详情操作
		if($_GET['gid']){
	       $goods = $Goods->relation(true)->where(array('gid'=>I('get.gid')))->find();
	       $this->assign('g',$goods);
		}
		//新增或者编辑，提交数据的操作
		if($_POST){
		    if($_POST['gid']){
		        $re=$Goods->where(array('gid'=>$_POST['gid']))->find();
		        if(!$re){
		            $this->error('参数错误!');
		        }
		        $old_img=$re['img'];
		    }
		    if(!$_POST['cid'])
		    {
		        $this->error("请选择分类");
		    }
			$Goods = M('Goods');
			if($_POST['barcode'] && $Goods->where(array('barcode'=>$_POST['barcode']))->find())
			{
			    $this->error('条形码已存在');
			}
			$gallery_files = $_FILES['img_url'];
			unset($_FILES['img_url']);
			//替换远程图片
			$_POST['infor'] = $this->download_url_image($_POST['infor']);
			
			import('ORG.Net.UploadFile');
			$upload = new UploadFile();// 实例化上传类
			$upload->maxSize  = 3145728 ;// 设置附件上传大小
			$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
			$upload->savePath =  'Public/Uploads/Goods/';// 设置附件上传目录
			if(!$upload->upload()) {// 上传错误提示错误信息
			}else{// 上传成功 获取上传文件信息
			    $info =  $upload->getUploadFileInfo();
			}
			if(!empty($info)){
    			$Goods->photo = $info[0]['savename']; // 保存上传的照片根据需要自行组装
    			$_POST['img'] = $info[0]['savename'];
			}
			$_POST['infor'] =stripslashes($_POST['infor']);
			$_POST['goods_sn'] = uniqid();
			
			$_FILES['img_url'] = $gallery_files;
			
			$goods_id = $Goods->add($_POST,$options=array(),$replace=true);
			if($goods_id and $old_img and !empty($info)){
			    unlink("Public/Uploads/Goods/".$old_img);
			}
			$Goods_attr = M('Goods_attr');
			/* 处理属性 引用ecshop的属性操作方法*/
			if ((isset($_POST['attr_id_list']) && isset($_POST['attr_value_list'])) || (empty($_POST['attr_id_list']) && empty($_POST['attr_value_list'])))
			{
				// 取得原有的属性值
				$goods_attr_list = array();
				$attr_list = $Goods_attr->where(array('goods_id'=>$goods_id))->select();

				foreach ($attr_list as $key => $row){
					$goods_attr_list[$row['attr_id']][$row['attr_value']] = array('sign' => 'delete', 'goods_attr_id' => $row['goods_attr_id']);
				}
				// 循环现有的，根据原有的做相应处理
				if(isset($_POST['attr_id_list']))
				{
					foreach ($_POST['attr_id_list'] as $key => $attr_id)
					{
						$attr_value = $_POST['attr_value_list'][$key];
						$attr_price = $_POST['attr_price_list'][$key];
						$attr_num = $_POST['attr_num_list'][$key];
						if (!empty($attr_value))
						{
							if (isset($goods_attr_list[$attr_id][$attr_value]))
							{
								// 如果原来有，标记为更新
								$goods_attr_list[$attr_id][$attr_value]['sign'] = 'update';
								$goods_attr_list[$attr_id][$attr_value]['attr_price'] = $attr_price;
								$goods_attr_list[$attr_id][$attr_value]['attr_num'] = $attr_num;
							}
							else
							{
								// 如果原来没有，标记为新增
								$goods_attr_list[$attr_id][$attr_value]['sign'] = 'insert';
								$goods_attr_list[$attr_id][$attr_value]['attr_price'] = $attr_price;
								$goods_attr_list[$attr_id][$attr_value]['attr_num'] = $attr_num;
							}
						}
					}
				}
				/* 插入、更新、删除数据 */
				foreach ($goods_attr_list as $attr_id => $attr_value_list)
				{
					foreach ($attr_value_list as $attr_value => $info)
					{
						$date = array();
						if ($info['sign'] == 'insert')
						{
							$date['goods_id'] = $goods_id;
							$date['attr_id'] = $attr_id;
							$date['attr_value'] = $attr_value;
							$date['attr_price'] = $info['attr_price'];
							$date['attr_num'] = $info['attr_num'];
							$Goods_attr->add($date);
						}
						elseif ($info['sign'] == 'update')
						{
							$date['attr_value'] = $attr_value;
							$date['attr_price'] = $info['attr_price'];
							$date['attr_num'] = $info['attr_num'];
							$Goods_attr->where(array('goods_attr_id'=>$info['goods_attr_id']))->save($date);
						}
						else
						{
							$Goods_attr->where(array('goods_attr_id'=>$info['goods_attr_id']))->delete();
						}
					}
				}
			}
	        /*属性处理结束*/
			if($goods_id){
			    $Goods_gallery = M('Goods_gallery');
			    //上传相册
                foreach($_FILES['img_url']['name'] as $k => $v){
                    if($v != ''){
                        //上传本张
                        
                        $file = [
                            'name' => $_FILES['img_url']['name'][$k],
                            'type' => $_FILES['img_url']['type'][$k],
                            'tmp_name' => $_FILES['img_url']['tmp_name'][$k],
                            'error' => $_FILES['img_url']['error'][$k],
                            'size' => $_FILES['img_url']['size'][$k],
                        ];
                        $upload_info = upload_one('Public/Uploads/Goodgallery/',$file);
                        if($upload_info){
                            //写入数据库
                            $gallery_data = [
                                'goods_id' => $goods_id,
                                'img_url' => $upload_info[0]['savename'],
                            ];
                            $Goods_gallery->add($gallery_data);
                        }else{
                            $is_have_fail = 1;
                        }
                    }
                }
                $msg = $is_have_fail ? '编辑成功，但部分图片上传失败' : '编辑成功';
			    
			    
			  $this->success($msg,session('now_url'));
			}else{
			  $this->error('编辑失败');
			} 	
			exit;
		}
        //获取全部商品分类列表
		$catelist = $this->get_cate();
		$this->assign('catelist',$catelist);
		//获取商品类型列表
		$goods_type = M('goods_type');
		$goods_type_list = $goods_type->where(array('enabled'=>1))->order('c_order desc')->select();
		$this->assign('goods_type_list', $goods_type_list); 
		$this->assign('integral_scale',C('integral_scale'));// 赋值数据集
		
		//获取供应商列表
		$Supplier = M('Supplier');
		$supplierList = $Supplier->select();
		$this->assign('supplierList',$supplierList);
		
		$this->display();
	}
	
	//编辑商品
	public function editgoods(){
        $Goods = D('Goods');
		//编辑商品，获取商品详情操作
		if($_GET['gid']){
	       $goods = $Goods->relation(true)->where(array('gid'=>I('get.gid')))->find();
	       $goods['img'] = getImgUrl(C('GOODS_IMG_URL'),$goods['img']);
	       $this->assign('g',$goods);
		}
		//新增或者编辑，提交数据的操作
		if($_POST){
		    
		    if($_POST['gid']){
		        $re=$Goods->where(array('gid'=>$_POST['gid']))->find();
		        if(!$re){
		            $this->error('参数错误!');
		        }
		        $old_img=$re['img'];
		    }
		    if(!$_POST['cid'])
		    {
		        $this->error("请选择分类");
		    }
		    if(!$_POST['barcode'])
		    {
		        $this->error("请输入条形码");
		    }
			$Goods = M('Goods');
			$where1['barcode']=array('eq',$_POST['barcode']);
			$where1['gid']=array('neq',$_POST['gid']);
			if($_POST['barcode'] && $Goods->where($where1)->find())
			{
			    $this->error('条形码已存在');
			}
			/*//商品库存数量不能小于货品表商品总数量
			$Products = M('Products');
			$all_num = $Products->where(['goods_id'=>I('post.gid')])->sum(product_number);
			if($_POST['goods_number'] < $all_num){
			    $this->error('商品库存不能小于货品商品总数量');
			}*/
			
			$gallery_files = $_FILES['img_url'];
			unset($_FILES['img_url']);
			//替换远程图片
			$_POST['infor'] = $this->download_url_image($_POST['infor']);
			
			import('ORG.Net.UploadFile');
			$upload = new UploadFile();// 实例化上传类
			$upload->maxSize  = 3145728 ;// 设置附件上传大小
			$upload->allowExts  = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
			$upload->savePath =  'Public/Uploads/Goods/';// 设置附件上传目录
			if(!$upload->upload()) {// 上传错误提示错误信息
			}else{// 上传成功 获取上传文件信息
			$info =  $upload->getUploadFileInfo();
			}
			
			unset($_POST['img']);
			
			if(!empty($info)){
			$Goods->photo = $info[0]['savename']; // 保存上传的照片根据需要自行组装
			$_POST['img'] = $info[0]['savename'];
			}
			$_POST['infor'] =stripslashes($_POST['infor']);
			
			$res = $Goods->save($_POST);
			
			$_FILES['img_url'] = $gallery_files;
			
			if($res !== false){
			    $goods_id = I('post.gid');
    			if($old_img and !empty($info)){
    			    unlink("Public/Uploads/Goods/".$old_img);
    			}
    			$Goods_attr = M('Goods_attr');
    			/* 处理属性 引用ecshop的属性操作方法*/
    			if ((isset($_POST['attr_id_list']) && isset($_POST['attr_value_list'])) || (empty($_POST['attr_id_list']) && empty($_POST['attr_value_list'])))
    			{
    				// 取得原有的属性值
    				$goods_attr_list = array();
    				$attr_list = $Goods_attr->where(array('goods_id'=>$goods_id))->select();
    
    				foreach ($attr_list as $key => $row){
    					$goods_attr_list[$row['attr_id']][$row['attr_value']] = array('sign' => 'delete', 'goods_attr_id' => $row['goods_attr_id']);
    				}
    				// 循环现有的，根据原有的做相应处理
    				if(isset($_POST['attr_id_list']))
    				{
    					foreach ($_POST['attr_id_list'] as $key => $attr_id)
    					{
    						$attr_value = $_POST['attr_value_list'][$key];
    						$attr_price = $_POST['attr_price_list'][$key];
    						$attr_num = $_POST['attr_num_list'][$key];
    						if (!empty($attr_value))
    						{
    							if (isset($goods_attr_list[$attr_id][$attr_value]))
    							{
    								// 如果原来有，标记为更新
    								$goods_attr_list[$attr_id][$attr_value]['sign'] = 'update';
    								$goods_attr_list[$attr_id][$attr_value]['attr_price'] = $attr_price;
    								$goods_attr_list[$attr_id][$attr_value]['attr_num'] = $attr_num;
    							}
    							else
    							{
    								// 如果原来没有，标记为新增
    								$goods_attr_list[$attr_id][$attr_value]['sign'] = 'insert';
    								$goods_attr_list[$attr_id][$attr_value]['attr_price'] = $attr_price;
    								$goods_attr_list[$attr_id][$attr_value]['attr_num'] = $attr_num;
    							}
    						}
    					}
    				}
    				/* 插入、更新、删除数据 */
    				foreach ($goods_attr_list as $attr_id => $attr_value_list)
    				{
    					foreach ($attr_value_list as $attr_value => $info)
    					{
    						$date = array();
    						if ($info['sign'] == 'insert')
    						{
    							$date['goods_id'] = $goods_id;
    							$date['attr_id'] = $attr_id;
    							$date['attr_value'] = $attr_value;
    							$date['attr_price'] = $info['attr_price'] ? : 0;
    							$date['attr_num'] = $info['attr_num'] ? : 0;
    							$Goods_attr->add($date);
    						}
    						elseif ($info['sign'] == 'update')
    						{
    							$date['attr_value'] = $attr_value;
    							$date['attr_price'] = $info['attr_price'] ? : 0;
    							$date['attr_num'] = $info['attr_num'] ? : 0;
    							$Goods_attr->where(array('goods_attr_id'=>$info['goods_attr_id']))->save($date);
    						}
    						else
    						{
    							$Goods_attr->where(array('goods_attr_id'=>$info['goods_attr_id']))->delete();
    						}
    					}
    				}
    			}
    			
                //相册处理
                $del_img_list = $_POST['del_img_list'];
                $Goods_gallery = M('Goods_gallery');
                if($del_img_list != ''){
                    //变成数组
                    $del_img_list = explode(',',$del_img_list);
                    //去重
                    $del_img_list = array_unique($del_img_list);
                    //查出来
                    $where_del['img_id'] = ['in',$del_img_list];
                    $del_img_list = $Goods_gallery->where($where_del)->getField('img_url',true);
                    //删除记录并且删除对应图片
                    $del = $Goods_gallery->where($where_del)->delete();
                    if($del){
                        foreach($del_img_list as $k => $v){
                            unlink('Public/Uploads/Goodgallery/'.$v);
                        }
                    }
                }
                //上传相册
                foreach($_FILES['img_url']['name'] as $k => $v){
                    if($v != ''){
                        //上传本张
                        
                        $file = [
                            'name' => $_FILES['img_url']['name'][$k],
                            'type' => $_FILES['img_url']['type'][$k],
                            'tmp_name' => $_FILES['img_url']['tmp_name'][$k],
                            'error' => $_FILES['img_url']['error'][$k],
                            'size' => $_FILES['img_url']['size'][$k],
                        ];
                        $upload_info = upload_one('Public/Uploads/Goodgallery/',$file);
                        if($upload_info){
                            //写入数据库
                            $gallery_data = [
                                'goods_id' => $goods_id,
                                'img_url' => $upload_info[0]['savename'],
                            ];
                            $Goods_gallery->add($gallery_data);
                        }else{
                            $is_have_fail = 1;
                        }
                    }
                }
                $msg = $is_have_fail ? '编辑成功，但部分图片上传失败' : '编辑成功';
    			
			}
	        /*属性处理结束*/
			if($goods_id){
			  $this->success($msg,session('now_url'));
			}else{
			  $this->error('编辑失败');
			} 	
			exit;
		}
        //获取全部商品分类列表
		$catelist = $this->get_cate();
		$this->assign('catelist',$catelist);
		//获取商品类型列表
		$goods_type = M('goods_type');
		$goods_type_list = $goods_type->where(array('enabled'=>1))->order('c_order desc')->select();
		$this->assign('goods_type_list', $goods_type_list); 
		$this->assign('integral_scale',C('integral_scale'));// 赋值数据集
		
		//获取相册照片
		$Goods_gallery = M('Goods_gallery');
		$galleryList = $Goods_gallery->where(['goods_id'=>I('get.gid')])->select();
		foreach($galleryList as $k => $v){
		    $galleryList[$k]['img_url'] = getImgUrl(C('GALLERY_IMG_URL'),$v['img_url']);
		}
		$this->assign('galleryList',$galleryList);
		
		//获取供应商列表
		$Supplier = M('Supplier');
		$supplierList = $Supplier->select();
		$this->assign('supplierList',$supplierList);
		
		$this->display('addgoods');
	}
	//开始获取内容里面的全部图片，如果存在外链，就自动保存到本地
	public function download_url_image($infor){
        $imgs=$this->getImgSrcFromStr($infor);
        $path='Public/Uploads/Goods/';
        foreach($imgs as $key => $v){
            if(stristr($v,"://")){
                //开始判断图片是否是外地地址
                $save_filename = $this->onlyName();
                //获取外链的图片后缀
                $img_type = substr($v, strrpos($v, '.')+1);
                $new_img_url = $path.$save_filename.".".$img_type;
                if($this->download_image($v, $new_img_url)) {
                    //下载成功 对img的url进行重新命名
                    $imgs[$key] = '/'.$new_img_url;
                    //替换原文中的外部链接，替换为本地链接
                    $url_change= '';
                    $url_change=array($v=>$imgs[$key]);
                    $infor=strtr($infor,$url_change);
                }
            }
            
        }
        return $infor;
	}
	
	//删除商品
	public function delgoods(){
	    if($_GET['gid']){
			$Goods = M('Goods');
	 		$img = $Goods->where(array('gid'=>I('get.gid')))->getField('img');
	        //删除该商品的属性
	        $goods_attr = M('goods_attr');
			$Goods->startTrans(); 
	        $re2=$goods_attr->where(array('goods_id'=>I('get.gid')))->find();
	        if($re2){
	            $re1=$goods_attr->where(array('goods_id'=>I('get.gid')))->delete();
	        }else{
	            $re1=true;
	        }
	        $re=$Goods->where(array('gid'=>I('get.gid')))->delete();
	        
	        $Goods_gallery = M('Goods_gallery');
	        $re2 = $Goods_gallery->where(array('goods_id'=>I('get.gid')))->getField('img_url',true);
		    $re3 = $Goods_gallery->where(array('goods_id'=>I('get.gid')))->delete();
	        
			if($re and $re1 and $re3 !== false){
			    $Goods->commit();
			    unlink("Public/Uploads/Goods/".$img);
			    
			    foreach($re2 as $k => $v){
                    unlink("Public/Uploads/Goodgallery/".$v);
                }
			    
			    $this->success('删除成功');
			}else{
		        $Goods->rollback();
			    $this->error('删除失败');
			}
		}
	}
	public function delallgoods(){
		$Goods = M('Goods');
		$Goods_attr = M('Goods_attr');
		$imgList = $Goods->where(array('gid'=>array('in',$_POST['checkBoxList'])))->getField('img',true);
		$Goods->startTrans();
		$re = $Goods_attr->where(array('goods_id'=>array('in',$_POST['checkBoxList'])))->delete();
		$re1 = $Goods->where(array('gid'=>array('in',$_POST['checkBoxList'])))->delete();
		
		//删除相册
		$Goods_gallery = M('Goods_gallery');
		$re2 = $Goods_gallery->where(array('goods_id'=>array('in',$_POST['checkBoxList'])))->getField('img_url',true);
		$re3 = $Goods_gallery->where(array('goods_id'=>array('in',$_POST['checkBoxList'])))->delete();
		
		if($re!==false and $re1!==false and $re3 !== false){
            $Goods->commit();
            foreach($imgList as $k => $v){
                unlink("Public/Uploads/Goods/".$v);
            }
            foreach($re2 as $k => $v){
                unlink("Public/Uploads/Goodgallery/".$v);
            }
            
            
            $this->success('删除成功');
        }else{
            $Goods->rollback();
            $this->error('删除失败');
        }
	}
	// ajax修改价格
	public function edit_price() {
		if(IS_POST) {
			$name     = filter_string($_POST['name']);
			$price    = filter_float($_POST['price']);
			$name_arr = explode('_', $name);
			$goods_id = count($name_arr) == 3 ? $name_arr[1] : 0;
			$ret      = '修改商品价格失败！';
			if($goods_id > 0) {
				$goodsModel = D('Goods');
				$r = $goodsModel->where("gid={$goods_id}")->setField('price', $price);
				if($r) {
					$ret = 'succ';
				}
			} else {
				$ret = '商品价格必须大于0！';
			}
			echo $ret;
		}
	}
	// ajax修改库存
	public function edit_goods_number() {
		if(IS_POST) {
		    $name     = filter_string($_POST['name']);
			$number    = filter_float($_POST['goods_number']);
			$name_arr = explode('_', $name);
			$goods_id = count($name_arr) == 4 ? $name_arr[1] : 0;
			$ret      = '修改商品库存失败！';
			if($goods_id > 0) {
				$goodsModel = D('Goods');
				$r = $goodsModel->where("gid={$goods_id}")->setField('goods_number', $number);
				if($r) {
					$ret = 'succ';
				}
			} else {
				$ret = '库存必须大于等于0！';
			}
			echo $ret;
		}
	}
	// ajax修改商品名称
	public function edit_goodsname() {
		if(IS_POST) {
			$name     = filter_string($_POST['name']);
			$goodsname    = filter_string($_POST['goodsname']);
			$name_arr = explode('_', $name);
			$goods_id = count($name_arr) == 3 ? $name_arr[1] : 0;
			$ret      = '修改商品名称失败！';
			if($goods_id > 0) {
				$goodsModel = D('Goods');
				$r = $goodsModel->where("gid={$goods_id}")->setField('name', $goodsname);
				if($r) {
					$ret = 'succ';
				}
			} else {
				$ret = '出错了！';
			}
			echo $ret;
		}
	}
	
	//商品相册
	public function gallery(){
	    $goodsid=I('get.gid',0,'int');
	    $Goodssql=D('Goods');
	    $where['gid']=$goodsid;
	    $gdaata=$Goodssql->where($where)->find();
	    if(!$gdaata){
	        $this->error('不存在的商品!');
	    }
	    $Goods_gallerySql=M('Goods_gallery');
	    $gg_data= $Goods_gallerySql->where(array('goods_id'=>$goodsid))->select();
	    
	    
	    $this->assign('list',$gg_data);
	    
	    $this->assign('goodsdata',$gdaata);
	    $this->display();
	}
	//商品相册新增
	function addGallery(){
	    $Goods_gallerySql = M('Goods_gallery');
	    if($_POST){
	        $goodsid = I('post.goodsid',0,'int');
	        $data=array(
	            'goods_id'=>$goodsid,
	            'sort'=>I('post.sort',0,'int'),
	            'info'=>I('post.info',0,'string'),
            );  
	        if($_FILES){
            	import('ORG.Net.UploadFile');
    			$upload = new UploadFile();// 实例化上传类
    			$upload->maxSize  = 3145728 ;// 设置附件上传大小
    			$upload->allowExts= array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
    			$upload->savePath =  'Public/Uploads/Goodgallery/';// 设置附件上传目录
    			$info =  $upload->uploadOne($_FILES['imgurl']);
    			$info ? $data['img_url'] = $info[0]['savename'] : $this->error('图片上传失败');
	        }
            $re=$Goods_gallerySql->add($data);
            $re ? $this->success('成功!',U('Goods/gallery',array('gid'=>$goodsid))) : $this->error('失败!');
	    }else{
    	    $img_id=I('get.img_id');
    	    $Goods_gallerydata=$Goods_gallerySql->where(array('img_id'=>$img_id))->find();
    	    $this->assign('Goods_gallerydata',$Goods_gallerydata);
            $this->display();
	    }
	}
	//商品相册编辑
	function editGallery(){
	    $Goods_gallerySql = M('Goods_gallery');
	    if($_POST){
            $goodsid = I('post.goodsid',0,'int');
            $img_id = I('post.img_id',0,'int');
            !$img_id && $this->error('参数错误'); 
            $gallerydata = $Goods_gallerySql->where(array('img_id'=>$img_id))->find();
            !$gallerydata && $this->error('没有该图片!');
            $goodsid = $gallerydata['goods_id'];
	        $data=array(
	            'goods_id'=>$goodsid,
	            'sort'=>I('post.sort',0,'int'),
	            'info'=>I('post.info',0,'string'),
            );  
	        if($_FILES){
            	import('ORG.Net.UploadFile');
    			$upload = new UploadFile();// 实例化上传类
    			$upload->maxSize  = 3145728 ;// 设置附件上传大小
    			$upload->allowExts= array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
    			$upload->savePath =  'Public/Uploads/Goodgallery/';// 设置附件上传目录
    			$info =  $upload->uploadOne($_FILES['imgurl']);
    			$info ? $data['img_url'] = $info[0]['savename'] : $this->error('图片上传失败');
    			unlink('Public/Uploads/Goodgallery/'.$gallerydata['img_url']);
	        }
            $re = $Goods_gallerySql->where(array('img_id'=>$img_id))->save($data);    
            $re ? $this->success('成功!',U('Goods/gallery',array('gid'=>$goodsid))) : $this->error('失败!');
	    }else{
            $img_id = I('get.img_id');
            $Goods_gallerydata = $Goods_gallerySql->where(array('img_id'=>$img_id))->find();
            $this->assign('Goods_gallerydata',$Goods_gallerydata);
            $this->display('addGallery');
	    }
	}
	function gallerydel(){
	    $Goods_gallerySql = D('Goods_gallery');
	    $img_id = I('get.img_id');
	    $img = $Goods_gallerySql->where(array('img_id'=>$img_id))->getField('img_url');
	    $re = $Goods_gallerySql->where(array('img_id'=>$img_id))->delete();
	    if($re){
	        unlink('Public/Uploads/Goodgallery/'.$img);
	        $this->success('成功!');
	    }else{
	        $this->error('失败!');
	    }
	}
	
	
	public function changegoods(){
	    $Goods = M('Goods');
		$data = $Goods->where(array('gid'=>I('post.gid')))->setField($_POST['field'],$_POST['state']);
        echo json_encode($data);  //jsonp请求
    }
	
	protected function get_cate(){
	    $Cate = M('Cate');
		$catelist = $Cate->order('c_order desc')->select();
		$catelist = cate_merge($catelist);
		return $catelist;
    }
    
    //获取商品类型下的全部属性
    public function get_attr(){
        $goods_id   = empty($_GET['gid']) ? 0 : intval($_GET['gid']);
        $goods_type = empty($_GET['cat_id']) ? 0 : intval($_GET['cat_id']);
        $content    = $this->build_attr_html($goods_type, $goods_id);
        echo json_encode($content);  //jsonp请求
    }
    /**
     * 取得通用属性和某分类的属性，以及某商品的属性值
     * @param   int     $cat_id     分类编号
     * @param   int     $goods_id   商品编号
     * @return  array   规格与属性列表
     */
    public function get_attr_list($cat_id, $goods_id = 0)
    {
        if (empty($cat_id))
        {
            return array();
        }
    
        // 查询属性值及商品的属性值
        $sql = "SELECT a.attr_id, a.attr_name, a.attr_input_type, a.attr_values,a.attr_index,a.attr_type,a.attr_show_type, v.attr_value, v.attr_price, v.attr_num ".
                "FROM " .table('attribute'). " AS a ".
                "LEFT JOIN " .table('goods_attr'). " AS v ".
                "ON v.attr_id = a.attr_id AND v.goods_id = '$goods_id' ".
                "WHERE a.cat_id = " . intval($cat_id) ." OR a.cat_id = 0 ".
                "ORDER BY a.sort_order, a.attr_id, v.attr_price, v.goods_attr_id";
    
        $Model = new Model();
        $row = $Model->query($sql);
        return $row;
    }
    
    /**
     * 根据属性数组创建属性的表单
     *
     * @access  public
     * @param   int     $cat_id     分类编号
     * @param   int     $goods_id   商品编号
     * @return  string
     */
    public function build_attr_html($cat_id, $goods_id = 0)
    {
        $attr = $this->get_attr_list($cat_id, $goods_id);
        $html = '<table width="100%" id="attrTable">';
        $spec = 0;
        
        foreach ($attr as $key => $val)
        {
            
            $html .= "<tr><td class='label'>";
            if ($val['attr_type'] == 1 )
            {
                $html .= ($spec != $val['attr_id']) ?
                    "<a href='javascript:;' onclick='addSpec(this)'>[+]</a>" :
                    "<a href='javascript:;' onclick='removeSpec(this)'>[-]</a>";
                $spec = $val['attr_id'];
            }
    
            $html .= "$val[attr_name]</td><td><input type='hidden' name='attr_id_list[]' value='$val[attr_id]' />";
    
            if ($val['attr_input_type'] == 0)
            {
                $html .= '<input name="attr_value_list[]" type="text" value="' .htmlspecialchars($val['attr_value']). '" size="40" /> ';
            }
            elseif ($val['attr_input_type'] == 2)
            {
                $html .= '<textarea name="attr_value_list[]" rows="3" cols="40">' .htmlspecialchars($val['attr_value']). '</textarea>';
            }
            else
            {
                $html .= '<select name="attr_value_list[]">';
                $html .= '<option value="">请选择...</option>';
    
                $attr_values = explode("\n", $val['attr_values']);
    
                foreach ($attr_values AS $opt)
                {
                    $opt    = trim(htmlspecialchars($opt));
    
                    $html   .= ($val['attr_value'] != $opt) ?
                        '<option value="' . $opt . '">' . $opt . '</option>' :
                        '<option value="' . $opt . '" selected="selected">' . $opt . '</option>';
                }
                $html .= '</select> ';
            }
            if ($val['attr_show_type'] == 1 )
            {
                $html .= '<span>属性价格</span><input type="text" name="attr_price_list[]" value="' . $val['attr_price'] . '" size="5" maxlength="10" />';
            }else{
                $html .= '<span>属性价格</span><input type="hidden" name="attr_price_list[]" value="0" />';
            }
            //$html .= '<span>属性$this</span><input type="text" name="attr_num_list[]" value="' . $val['attr_num'] . '" size="5" maxlength="10" />';
            $html .= '</td></tr>';
        }
    
        $html .= '</table>';
    
        return $html;
    }
    
    public function get_attr_shaixuan(){
        $Attribute = M('Attribute');
        $list = $Attribute->where(array('cat_id'=>I('get.cat_id')))->select();
        echo json_encode($list);
    }
    
    /*抓取商品上架*/
    public function grab()
    {
        $new_url=$_POST['url'];
        $requesturl="http://grab.weidong100.com/index.php?m=Index&a=index&url=".urlencode($new_url)."&domain_name=".C('site_url')."&code=".C('grabCode');
        
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $requesturl);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data=curl_exec($ch);
        // 关闭cURL资源，并且释放系统资源
        curl_close($ch);
        $data=json_decode($data,true);

        if($data['code']==111)
	    {
	        if($data['data']['type']=='taobao')
	        {
	            //相册图片下载
                $content=str_replace('data-src','src',$data['data'][0]['content']);
                $content=str_replace('_50x50','_400x400',$content);
                $imgs=$this->getImgSrcFromStr($content);
                foreach($imgs as $key=>$value){
                    if($key==0)
                    {
                        $path='Public/Uploads/Goods/';
                    }else{
                        $path='Public/Uploads/Goodgallery/';
                    }
                    $img_url='https:'.$value;
                    $save_filename = $this->onlyName();//重命名
                    $img_type = substr(strrchr($img_url, '.'), 1);//获取图片后缀
                    $new_img_url = $path.$save_filename.".".$img_type;//重组图片本地地址
                    if($this->download_image($img_url, $new_img_url)) {
                        $data['data'][0]['imgs'][$key]=$save_filename.".".$img_type;
                    }
                }
	        }elseif($data['data']['type']=='jingdong')
	        {
	            //相册图片下载
                $imgs=$this->getImgSrcFromStrData($data['data'][0]['content']);
                foreach($imgs as $key=>$value){
                    if($key==0)
                    {
                        $path='Public/Uploads/Goods/';
                    }else{
                        $path='Public/Uploads/Goodgallery/';
                    }
                    $img_url='https://img14.360buyimg.com/n1/'.$value;
                    $save_filename = $this->onlyName();//重命名
                    $img_type = substr(strrchr($img_url, '.'), 1);//获取图片后缀
                    $new_img_url = $path.$save_filename.".".$img_type;//重组图片本地地址
                    if($this->download_image($img_url, $new_img_url)) {
                        $data['data'][0]['imgs'][$key]=$save_filename.".".$img_type;
                    }
                }
                
                //替换详情图片
                $imgs_info=$this->getImgSrcFromStr($data['data'][0]['info']);
                foreach($imgs_info as $k=>$v){
                    $img_url_info='https:'.$v;
                    $save_filename_info = $this->onlyName();//重命名
                    $img_type_info = substr(strrchr($img_url_info, '.'), 1);//获取图片后缀
                    $new_img_url_info = $path.$save_filename_info.".".$img_type_info;//重组图片本地地址
                    if($this->download_image($img_url_info, $new_img_url_info)) {
                        $data['data'][0]['info']=strtr($data['data'][0]['info'],array($v=>$new_img_url_info));
                    }
                }
	        }elseif($data['data']['type']=='suning')
	        {
	            //相册图片下载
                $imgs=$this->getImgSrcFromStrSrc($data['data'][0]['content']);
                foreach($imgs as $key=>$value){
                    if($key==0)
                    {
                        $path='Public/Uploads/Goods/';
                    }else{
                        $path='Public/Uploads/Goodgallery/';
                    }
                    $img_url='https:'.$value;
                    $save_filename = $this->onlyName();//重命名
                    $img_type = substr($img_url, strripos($img_url,'.'),(strripos($img_url,'?')-strripos($img_url,'.')));//获取图片后缀
                    $new_img_url = $path.$save_filename.$img_type;//重组图片本地地址
                    if($this->download_image($img_url, $new_img_url)) {
                        $data['data'][0]['imgs'][$key]=$save_filename.$img_type;
                    }
                }
                
                //详情图片替换
                $data['data'][0]['info']=strtr($data['data'][0]['info'],array('src2'=>'src'));
                $imgs_info=$this->getImgSrcFromStr($data['data'][0]['info']);
                foreach($imgs_info as $k=>$v){
                    $img_url_info='https:'.$v;
                    $save_filename_info = $this->onlyName();//重命名
                    $img_type_info = substr(strrchr($img_url_info, '.'), 1);//获取图片后缀
                    $new_img_url_info = $path.$save_filename_info.".".$img_type_info;//重组图片本地地址
                    if($this->download_image($img_url_info, $new_img_url_info)) {
                        $data['data'][0]['info']=strtr($data['data'][0]['info'],array($v=>$new_img_url_info));
                    }
                }
	        }elseif($data['data']['type']=='tianmao')
	        {
	            //图片下载 
                $content=$data['data'][0]['content'];
                $content=str_replace('jpg_60x60q90','jpg_430x430q90',$content);
                $imgs=$this->getImgSrcFromStr($content);
                foreach($imgs as $key=>$value){
                    if($key==0)
                    {
                        $path='Public/Uploads/Goods/';
                    }else{
                        $path='Public/Uploads/Goodgallery/';
                    }
                    $img_url='https:'.$value;
                    $save_filename = $this->onlyName();//重命名
                    $img_type = substr(strrchr($img_url, '.'), 1);//获取图片后缀
                    $new_img_url = $path.$save_filename.".".$img_type;//重组图片本地地址
                    if($this->download_image($img_url, $new_img_url)) {
                        $data['data'][0]['imgs'][$key]=$save_filename.".".$img_type;
                    }
                }
	        }
	        
	        $Goods=M('Goods');
	        $Goods_gallery=M('Goods_gallery');
	        $Goods->startTrans();
	        $goods['name']=$data['data'][0]['name'];
	        $goods['ginfo']=$data['data'][0]['ginfo'];
	        $goods['price']=$data['data'][0]['price'];
	        $goods['infor']=$data['data'][0]['info'];
	        $goods['state']=0;
	        $goods['img']=$data['data'][0]['imgs'][0];
	        $re=$Goods->add($goods);
	        if($re)
	        {
	            foreach($data['data'][0]['imgs'] as $kk=>$vv)
	            {
	                if($kk!=0)
	                {
	                    $Goods_gallery->add(array('goods_id'=>$re,'img_url'=>$vv));
	                }
	            }
	            $Goods->commit();
	            $this->ajaxReturn(array('code'=>111,'message'=>'添加成功','data'=>$re),'JSON');
	        }else{
	            $Goods->rollback();
	            $this->ajaxReturn(array('code'=>999,'message'=>'系统错误'),'JSON');
	        }
	    }else{
	        $this->ajaxReturn(array('code'=>999,'message'=>$data['message']),'JSON');
	    }
    }
    
    
    /*扫码添加商品*/
    public function barcode()
    {
        $this->display();
    }
    
    
    /*扫码上架商品*/
    public function barcodeGoods()
    {
        $re=$this->grabBarcodeGoods($_POST['code']);
        $this->ajaxReturn($re,'JSON');
    }
    
    private function grabBarcodeGoods($barcode,$price,$num)
    {
        
        $requesturl="http://grab.weidong100.com/index.php?m=Barcode&a=index&barcode=".$barcode."&domain_name=".C('site_url')."&code=".C('grabCode');
        $ch = curl_init();
        // 设置URL和相应的选项
        curl_setopt($ch, CURLOPT_URL, $requesturl);
        curl_setopt($ch, CURLOPT_HEADER, 0);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        $data=curl_exec($ch);
        curl_close($ch);// 关闭cURL资源，并且释放系统资源
        $data=json_decode($data,true);
    
        //处理返回的商品信息，图片本地化替换
        if($data['code']==111)
	    {
            // 商品相册图片下载 
            $path='Public/Uploads/Goodgallery/';
            foreach($data['data']['goods_gallery'] as $key=>$value){
                $save_filename = $this->onlyName();//重命名
                $img_type = substr(strrchr($value['img_url'], '.'), 1);//获取图片后缀
                $new_img_url = $path.$save_filename.".".$img_type;//重组图片本地地址
                if($this->download_image($value['img_url'], $new_img_url)) {
                    $data['data']['goods_gallery'][$key]['img_url']=$save_filename.".".$img_type;
                }
            }
	        //商品图片下载
	        $path1='Public/Uploads/Goods/';
	        $save_filename1 = $this->onlyName();//重命名
            $img_type1 = substr(strrchr($data['data']['img'], '.'), 1);//获取图片后缀
            $new_img_url1 = $path1.$save_filename1.".".$img_type1;//重组图片本地地址
            if($this->download_image($data['data']['img'], $new_img_url1)) {
                $data['data']['img']=$save_filename1.".".$img_type1;
            }
	        //数据重组写入数据库
	        $Goods=M('Goods');
	        $Goods_gallery=M('Goods_gallery');
	        if($Goods->where(array('barcode'=>$barcode))->find())
	        {
	            $result=array('code'=>999,'message'=>'该条形码商品已存在');
                return $result;
	        }
	        $Goods->startTrans();
	        $goods['name']=$data['data']['goods_name'];
	        $goods['ginfo']=$data['data']['ginfo'];
	        $goods['infor']=$data['data']['info'];
	        $goods['img']=$data['data']['img'];
	        $goods['barcode']=$barcode;
	        $goods['state']=0;
	        if($price)
	        {
	            $goods['price']=$price;
	        }else{
	            $goods['price']=$data['data']['price'];
	        }
	        if($num)
	        {
	            $goods['goods_number']=$num;
	        }
	        $re=$Goods->add($goods);
	        if($re)
	        {
	            //处理商品相册
	            foreach($data['data']['goods_gallery'] as $kk=>$vv)
	            {
                    $Goods_gallery->add(array('goods_id'=>$re,'img_url'=>$vv['img_url']));
	            }
	            $Goods->commit();
	            
	            $result=array('code'=>111,'message'=>'添加成功','data'=>$re);
                return $result;
	        }else{
	            $Goods->rollback();
	            $result=array('code'=>999,'message'=>'系统错误');
                return $result;
	        }
	    }else{
	        
	        $result=array('code'=>999,'message'=>$data['message']);
            return $result;
	    }
    }
    
    //获取文章里面的全部图片
    function getImgSrcFromStr($str){
        preg_match_all('/<img[^>]*src\s*=\s*([\'"]?)([^\'" >]*)\1/isu', $str, $src);
        return $src[2];
    }
    function getImgSrcFromStrData($str){
        preg_match_all('/<img[^>]*data-url\s*=\s*([\'"]?)([^\'" >]*)\1/isu', $str, $src);
        return $src[2];
    }
    function getImgSrcFromStrSrc($str){
        preg_match_all('/<img[^>]*src-large\s*=\s*([\'"]?)([^\'" >]*)\1/isu', $str, $src);
        return $src[2];
    }
    
    /**
     * 远程下载图片的方法
     */
    private function download_image($url, $save_filename) {
        
        if(($content = file_get_contents($url)) != false) {

            if(file_put_contents($save_filename, $content)) {
                
                return true;
            } else {

                return false;
            }
        } else {
            return false;
        }
    }
    //生成唯一的文件名
    private function onlyName() {
        //返回微秒数加随机前缀
        $name = uniqid(rand(1, 1000));
        //返回唯一字符串
        return md5($name);
    }
    
    //供应商列表
    public function supplierList(){
        $Supplier = M('Supplier');
        import('ORG.Util.Page');// 导入分页类
		$count      = $Supplier->count();// 查询满足要求的总记录数
		$Page       = new Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个供货商');
		$show       = $Page->show();// 分页显示输出
		$list = $Supplier->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
    }
    //新增供应商
    public function addSupplier(){
        if(IS_POST){
            $Supplier = M('Supplier');
            $_POST['supplier_name'] == '' && $this->error('供货商名称不能为空');
            $_POST['supplier_tel'] == '' && $this->error('供货商联系方式不能为空');
            $re = $Supplier->add($_POST);
            if($re){
                $this->success('新增成功',U('Index/gb'));
            }else{
                $this->error('新增失败');
            }
        }else{
            $this->display();
        }
    }
    //编辑供应商
    public function editSupplier(){
        $Supplier = M('Supplier');
        if(IS_POST){
            $_POST['supplier_name'] == '' && $this->error('供货商名称不能为空');
            $_POST['supplier_tel'] == '' && $this->error('供货商联系方式不能为空');
            $re = $Supplier->save($_POST);
            if($re !== false){
                $this->success('编辑成功',U('Index/gb'));
            }else{
                $this->error('编辑失败');
            }
        }else{
            $re = $Supplier->where(['id'=>I('get.id')])->find();
            $this->assign('re',$re);
            $this->display('addSupplier');
        }
    }
    //删除供应商,删除goods表的关联数据
    public function delSupplier(){
        //把和其关联的商品供货商设置为0
        $Goods = M('Goods');
        $re = $Goods->where(['supplier'=>I('get.id')])->setField('supplier',0);
        if($re !== false){
            //删除供货商
            $Supplier = M('Supplier');
            $re1 = $Supplier->where(['id'=>I('get.id')])->delete();
            if($re1 !== false){
                $this->success('删除成功');
            }else{
                $this->error('删除失败');
            }
        }else{
            $this->error('删除失败');
        }
    }
    //取消某商品的供应
    public function delSupplierGoods(){
        $Goods = M('Goods');
        $re = $Goods->where(['gid'=>I('get.gid')])->setField('supplier',0);
        if($re !== false){
            $this->success('操作成功');
        }else{
            $this->error('操作失败');
        }
    }
    //供货商品列表
    public function supplierGoodsList(){
        $Goods = D('Goods');
        $map['supplier'] = I('get.id');
		import('ORG.Util.Page');// 导入分页类
		$count      = $Goods->where($map)->count();// 查询满足要求的总记录数
		$Page       = new Page($count,10);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个商品');
		$show       = $Page->show();// 分页显示输出
		$list = $Goods->where($map)->relation(true)->order('gid desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		$Attr = D('GoodsAttrAttributeView');
		foreach($list as $k=>$v){
			  if(strtotime($v['end_time']) >= time() && $v['is_promote']==1 ){
			     $list[$k]['is_promote'] = 1;
			  }else{
			     $list[$k]['is_promote'] = 0;
			  }
			  //关联价格的属性数量
			  //$list[$k]['price_attr_num'] = (int) $Attr->where(array('goods_id'=>$v['gid'],'attr_show_type'=>1))->count();
			  //只要有属性,那么就可以显示库存
			  $list[$k]['price_attr_num'] = (int) $Attr->where(array('goods_id'=>$v['gid']))->count();
			  $list[$k]['img'] = getImgUrl(C('GOODS_IMG_URL'),$v['img']);
		}
		
		$this->assign('list',$list);
		$this->assign('page',$show);
		$this->display();
    }
    
    public function importExcel()
    {
        if(IS_POST)
        {
            if (! empty ( $_FILES ['file'] ['name'] ))
            {
                $tmp_file = $_FILES ['file'] ['tmp_name'];
                $file_types = explode ( ".", $_FILES ['file'] ['name'] );
                $file_type = $file_types [count ( $file_types ) - 1];
                /*判别是不是.xls文件，判别是不是excel文件*/
                if (strtolower ( $file_type ) != "xls")              
                {
                    $this->error ( '不是Excel文件，重新上传' );
                }
                import('ORG.Net.UploadFile');
                $config=array(
                    'allowExts'=>array('xlsx','xls'),
                    'savePath'=>'./Data/Excel/',
                );
                $upload = new UploadFile($config);
                if (!$upload->upload()) {
                    $this->error($upload->getErrorMsg());
                } else {
                    $info = $upload->getUploadFileInfo();
                }
            }
            import('ORG.Util.PHPExcel');// 导入表格驱动
            $file_name=$info[0]['savepath'].$info[0]['savename'];
            $objReader = PHPExcel_IOFactory::createReader('Excel5');
            $objPHPExcel = $objReader->load($file_name,$encode='utf-8');
            $sheet = $objPHPExcel->getSheet(0);
            $highestRow = $sheet->getHighestRow(); // 取得总行数
            $highestColumn = $sheet->getHighestColumn(); // 取得总列数
            for($i=2;$i<=$highestRow;$i++)
            {   
                $data['barcode'] = $objPHPExcel->getActiveSheet()->getCell("A".$i)->getValue();  
                $data['price'] = $objPHPExcel->getActiveSheet()->getCell("B".$i)->getValue();  
                $data['num'] = $objPHPExcel->getActiveSheet()->getCell("C".$i)->getValue();
                $re=$this->grabBarcodeGoods($data['barcode'],$data['price'],$data['num']);
                if($re['code']==999)
                {
                    $this->error($re['message']);
                }
            } 
            if($re['code']==111){
                $this->success("导入成功",U('Index/gb'));
                exit;
            }
        }else{
            $this->display();
        }
    }

}