<?php
/**
 * shopNR本地电商系统，轻电商
 * ============================================================================
 * * 版权所有 青岛微动一百网络科技有限公司，并保留所有权利。
 * 交流论坛: http://bbs.weidong100.com
 * ----------------------------------------------------------------------------
 * 这不是一个自由软件！您只能在不用于商业目的的前提下对程序代码进行修改和
 * 使用；不允许对程序代码以任何形式任何目的的再发布。
 * ============================================================================
 * 软件著作权：2015SR193850
 * 购买授权：0532-88032825
*/
class OrderAction extends CommonAction {
    //订单订单列表
	public function index(){
	    $Area = M('Area'); 
	    $area = $Area->order('a_order desc')->select();
		if($_GET['area_id']){
		   $map['area_id']  = array('eq',$_GET['area_id']);
		   $area_name = $Area->where(array('area_id'=>I('get.area_id')))->getField('name');
		}else{
		   $area_name = '全部地区';
		}
	    if($_GET['tel']){
		   $map['tel']  = array('like','%'.$_GET['tel'].'%');
		}
		if($_GET['order_no']){
		   $map['order_no']  = array('like','%'.$_GET['order_no'].'%');
		}
	    $Orders = M('Orders');
		import('ORG.Util.Page');// 导入分页类
		$count      = $Orders->where($map)->count();// 查询满足要求的总记录数
		$Page       = new Page($count,20);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个订单');
		$show       = $Page->show();// 分页显示输出
		$list = $Orders->where($map)->order('time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		foreach($list as $key => $v){
		   $list[$key]['is_today'] = 0;
		   if($v['time']>strtotime('today')){
		      $list[$key]['is_today'] = 1;
		   } 
		}
		$sounds=C('sound');
		$this->assign('sounds',$sounds);// 赋值数据集
		$this->assign('list',$list);// 赋值数据集
		$this->assign('page',$show);// 赋值分页输出
		$this->assign('area',$area); 
		$this->assign('area_name',$area_name); 
		
		$this->assign('hand_print',C('hand_print'));
		
		$this->display();
	}
	
	//获取订单详情
	public function orderInfo(){
		//获取订单列表
		$Order = M('Orders');
		$Ordergoods = D('OrderGoodsView');
		$order = $Order->where(array('order_no'=>I('get.order_no')))->find();
		if(empty($order)){
		    echo '订单不存在！';
			exit;
		}
		$order['order_goods'] = $Ordergoods->where(array('order_no'=>I('get.order_no')))->select();
		$this->assign('order',$order);
     	$this->display();
    }
	
	//获取订单的日志
	public function orderLog(){

	    if($_POST){
	        //记录订单操作日志
			add_order_log($_POST['oid'],$_POST['change_log']);
			$this->success('新增成功',U('Index/gb'));
	    }else{
	        $Order_log = M('order_log');
    		$data = $Order_log->where(array('oid'=>I('get.oid')))->order('id desc')->select();
    		$this->assign('log',$data);
    		$this->assign('oid',$_GET['oid']);
         	$this->display();
	    }
	    
    }
	
	//申请退款订单订单列表  refund_state 默认0   申请退款1   成功退款2   拒绝退款3
	public function refundOrderList(){
	    $refund_state = $_GET['refund_state'];
	    if(empty($refund_state) || $refund_state==1){
		   $map['refund_state']  = array('eq',1);
		   $_GET['refund_state']= 1;
		}elseif($refund_state==2){
		   $map['refund_state']  = array('eq',2);
		}else{
		   $map['refund_state']  = array('eq',3);
		}
	    if($_GET['tel']){
		   $map['tel']  = array('like','%'.$_GET['tel'].'%');
		}
		if($_GET['order_no']){
		   $map['order_no']  = array('like','%'.$_GET['order_no'].'%');
		}
	    $Order = M('Orders');
		import('ORG.Util.Page');// 导入分页类
		$count      = $Order->where($map)->count();// 查询满足要求的总记录数
		$Page       = new Page($count,20);// 实例化分页类 传入总记录数和每页显示的记录数
		$Page->setConfig('header','个申请记录');
		$show       = $Page->show();// 分页显示输出
		$list = $Order->where($map)->order('time desc')->limit($Page->firstRow.','.$Page->listRows)->select();
		$this->assign('list',$list);// 赋值数据集
		$this->assign('page',$show);// 赋值分页输出
		
		$this->display();
	}
	//获取退款相关详情
	public function refundInfo(){
		//获取订单列表
		$Order = M('Orders');
		$order = $Order->where(array('oid'=>I('get.oid')))->find();
		if(empty($order)){
		    echo '订单不存在！';
			exit;
		}
		$this->assign('order',$order);
		//获取这个订单的支付方式
		$Pay_way = M('Pay_way');
		$pay_way = $Pay_way->where(array('id'=>$order['pay_method']))->find();
		if($pay_way['pay_mark'] != 'balance'){
		    $balance = $Pay_way->where(array('pay_mark'=>'balance'))->find();
		    $this->assign('balance',$balance);
		}
		$this->assign('pay_way',$pay_way);
     	$this->display();
    }
	//订单退款
    public function orderRefund(){
        //开始判断是否允许退款  refund_state  2允许  3拒绝
        $Order = M('Orders');
        //先判断一下，该订单，是否已经被处理
        $order_data = $Order->where(array('oid'=>I('post.oid')))->find();
        !$order_data && $this->error('订单不存在！');
        $order_data['refund_state'] != 1 && $this->error('该订单的退款状态不能更改！');
        if($_POST['refund_state']==3){
		    if($_POST['oid']){
			    if($Order->where(array('oid'=>I('post.oid')))->save($_POST)){
    			    add_order_log(I('post.oid'),'拒绝了订单'.$order_data['order_no'].'的退款申请');
    			    $this->success('处理成功',U('Index/gb'));
    			}else{
    			    $this->error('处理失败');
    			} 
    		}
        }elseif($_POST['refund_state']==2){
            //判断管理员提交的订单金额和退款金额是否合理
            $_POST["refund_fee"]<=0 && $this->error('退款金额必须是正数！');
            $order_data["pay_cash"]<$_POST["refund_fee"] && $this->error('退款金额，不能超过付款总金额！');
            //获得退款方式
            $Pay_way = M('Pay_way');
            $refund_way = $Pay_way->where(array('id'=>I('post.refund_way')))->find();
            !$refund_way && $this->error('退款方式异常！');
            //开启事务,先把订单状态改变,然后去返还资金
            $Order->startTrans();
            unset($_POST['oid']);
            //由于支付宝的特殊性,所以支付宝不进行修改订单操作,等回调才进行
            if($refund_way['pay_mark'] != 'Alipay'){
                $re = $Order->where(array('order_no'=>$order_data['order_no']))->setField($_POST);
            }else{
                $re = $Order->where(array('order_no'=>$order_data['order_no']))->setField(array('refund_reply'=>I('post.refund_reply')));
            }
            if($re !== false){
                if($refund_way['pay_mark'] == 'balance'){
                    //余额支付
                    $re = edit_user_account($order_data['uid'],0,'订单'.$order_data['order_no'].'退款'.$_POST['refund_fee'].'元到余额',$_POST['refund_fee'],0,0,2,0,$order_data['order_no']);
                    if($re){
                        add_order_log(I('post.oid'),'订单'.$order_data['order_no'].'退款'.$_POST['refund_fee'].'元到余额');
                        $Order->commit();
                        $this->success('操作成功',U('Index/gb'));
                    }else{
                        $Order->rollback();
                        $this->error('操作失败');
                    }
                }else{
                    //原路返回
                    if($refund_way['pay_mark'] == 'Wxpay'){
                        $re_wx = $this->refund_wx($refund_way,$order_data,$_POST['refund_fee']*100);
                        if($re_wx['code'] == 500){
                            $Order->rollback();
                            $this->error($re_wx['message']);
                        }
                        add_order_log(I('post.oid'),'订单'.$order_data['order_no'].'退款'.$_POST['refund_fee'].'元到'.$refund_way['pay_name']);
                        $Order->commit();
                        $this->success('操作成功',U('Index/gb'));
                    }elseif($refund_way['pay_mark'] == 'Alipay'){
                        $re_alipay = $this->refund_alipay($refund_way,$order_data,$_POST['refund_fee']);
                        if($re_alipay['code'] == 500){
                            $Order->rollback();
                            $this->error($re_alipay['message']);
                        }
                        $Order->commit();
                        $this->success('操作成功',U('Index/gb'));
                    }else{
                        $Order->rollback();
                        $this->error('待开发中');
                    }
                }
            }else{
                $Order->rollback();
                $this->error('操作失败');
            }
        }

    }
    
    //微信退款
    private function refund_wx($payway,$order_data,$refund_fee){
        //开始退款处理
        header("Content-type:text/html;charset=utf-8");
        vendor('WxPayPubHelper.SDKRuntimeException'); 
        $payway['key'] = unserialize($payway['key']);
        define("APPID", $payway['key'][0]);
        define("APPSECRET", $payway['key'][1]);
        define("MCHID", $payway['key'][2]);
        define("KEY", $payway['key'][3]);
		define("JS_API_CALL_URL", C('site_url').U('Wxpay/wap_dowxpay'));
		define('SSLCERT_PATH','Framework/Extend/Vendor/WxPayPubHelper/cacert/apiclient_cert.pem');
		define('SSLKEY_PATH','Framework/Extend/Vendor/WxPayPubHelper/cacert/apiclient_key.pem');
		define('NOTIFY_URL',C('site_url').'/index.php/home/Wxpay/notifyurl');
		define('CURL_TIMEOUT',30);
		vendor('WxPayPubHelper.WxPayPubHelper'); 
        //输入需退款的订单号
	    $out_trade_no = $order_data['order_no'];
		//商户退款单号，商户自定义，此处仅作举例
		$out_refund_no = "$out_trade_no"."$time_stamp";
		//总金额需与订单号out_trade_no对应，demo中的所有订单的总金额为1分
		$total_fee = $order_data["pay_cash"]*100;
		
		//使用退款接口
		$refund = new Refund_pub();
		//设置必填参数
		//appid已填,商户无需重复填写
		//mch_id已填,商户无需重复填写
		//noncestr已填,商户无需重复填写
		//sign已填,商户无需重复填写
		$refund->setParameter("out_trade_no","$out_trade_no");//商户订单号
		$refund->setParameter("out_refund_no","$out_refund_no");//商户退款单号
		$refund->setParameter("total_fee","$total_fee");//总金额
		$refund->setParameter("refund_fee","$refund_fee");//退款金额
		$refund->setParameter("op_user_id",MCHID);//操作员
		//非必填参数，商户可根据实际情况选填
		//$refund->setParameter("sub_mch_id","XXXX");//子商户号 
		//$refund->setParameter("device_info","XXXX");//设备号 
		//$refund->setParameter("transaction_id","XXXX");//微信订单号
		
		//调用结果
		$refundResult = $refund->getResult();
		
		//商户根据实际情况设置相应的处理流程,此处仅作举例
		if ($refundResult["return_code"] == "FAIL") {
			$data['code'] = 500;
			$data['message'] = "通信出错：".$refundResult['return_msg'];
			return $data;
		}
		$data['code'] = 200;
    	return $data;
    }
    //支付宝退款
    private function refund_alipay($payway,$order_data,$refund_fee){
        $payway['key'] = unserialize($payway['key']);
        define("alipay_partner", $payway['key'][0]);
        define("alipay_key", $payway['key'][1]);
        define("alipay_seller_email", $payway['key'][2]);
        
        /**************************请求参数**************************/
        vendor('Alipay.Corefunction');
        vendor('Alipay.Md5function');
        vendor('Alipay.Notify');
        vendor('Alipay.Submit');
        //服务器异步通知页面路径
        $notify_url = C('site_url') . '/index.php/Alipay/refund_notifyurl/payid/' . $payway['id'];
        //需http://格式的完整路径，不允许加?id=123这类自定义参数

        //退款批次号,这里格式必须date('Ymd')加其他,被坑好几分钟
        $batch_no = date('Ymdmis').$order_data['order_no'];
        //必填，每进行一次即时到账批量退款，都需要提供一个批次号，必须保证唯一性

        //退款请求时间
        $refund_date = date('Y-m-d H:i:s');
        //必填，格式为：yyyy-MM-dd hh:mm:ss

        //退款总笔数
        $batch_num = 1;
        //必填，即参数detail_data的值中，“#”字符出现的数量加1，最大支持1000笔（即“#”字符出现的最大数量999个）

        //单笔数据集
        $detail_data = $order_data['trade_no'].'^'.$refund_fee.'^'.'退款';
        //必填，格式详见“4.3 单笔数据集参数说明”
        
        $alipay_config = array('partner' => alipay_partner, 'key' => alipay_key,  'sign_type' => strtoupper('MD5'), 'input_charset' => 'utf-8', 'cacert' => 'Framework/Extend/Vendor/Alipay/cacert.pem', 'transport' => 'http');
        /************************************************************/
        
        //构造要请求的参数数组，无需改动
        $parameter = array(
        		"service" => "refund_fastpay_by_platform_nopwd",
        		"partner" => trim($alipay_config['partner']),
        		"notify_url"	=> $notify_url,
        		"batch_no"	=> $batch_no,
        		"refund_date"	=> $refund_date,
        		"batch_num"	=> $batch_num,
        		"detail_data"	=> $detail_data,
        		"_input_charset"	=> trim(strtolower($alipay_config['input_charset']))
        );
        
        //建立请求
        $alipaySubmit = new AlipaySubmit($alipay_config);
        $html_text = $alipaySubmit->buildRequestHttp($parameter);
        //解析XML
        //注意：该功能PHP5环境及以上支持，需开通curl、SSL等PHP配置环境。建议本地调试时使用PHP开发软件
        $doc = new DOMDocument();
        $doc->loadXML($html_text);
        
        //请在这里加上商户的业务逻辑程序代码
        
        //——请根据您的业务逻辑来编写程序（以下代码仅作参考）——
        
        //获取支付宝的通知返回参数，可参考技术文档中页面跳转同步通知参数列表
        
        //解析XML
        if( ! empty($doc->getElementsByTagName( "alipay" )->item(0)->nodeValue) ) {
        	$alipay = $doc->getElementsByTagName( "alipay" )->item(0)->nodeValue;
        	if(dataReplace($alipay) == 'T'){
        	    $data['code'] = 200;
        	}else{
        	    $data['code'] = 500;
        	    $data['message'] = $alipay;
        	}
        }else{
            $data['code'] = 500;
    	    $data['message'] = '出错了';
        }
        return $data;
        //——请根据您的业务逻辑来编写程序（以上代码仅作参考）——

        
        
        
    }
	//获取订单的状态   确认状态   支付状态  支付方式
	public function get_order_state(){
	    $Order = M('Orders');
		$data = $Order->where(array('oid'=>I('get.oid')))->find();
        echo json_encode($data);  //jsonp请求
    }
    
    //获取订单的状态   确认状态   支付状态  支付方式
	public function editOrder(){
	    $Order = M('Orders');
		$data = $Order->where(array('oid'=>I('get.oid')))->find();
		if(empty($data)){
		    echo '订单不存在！';
			exit;
		}
		//快递公司
		$Delivery=M('Delivery');
		$deliveryList=$Delivery->where(array('is_open'=>'0'))->order('is_open,dsort desc,did desc')->select();
		$this->assign('deliveryList',$deliveryList);
		
		//获取支付方式种类
		$Pay_way=M('Pay_way');
		$paywayList=$Pay_way->order('sort desc')->select();
		$data['paywayList']=$paywayList;
		$data = dataReplace($data);
        $this->assign('data',$data);
     	$this->display();
    }
    
	//修改订单状态
	public function edit_order_state(){
	
		$Order = M('Orders');
		if($_POST['oid']){
		    
		    if($_POST['state']==3){
		        $order=$Order->where(array('oid'=>I('post.oid')))->find();
		        $re=edit_order_state(I('post.oid'),$order['uid']);
		    }else{
		        $re=true;
		    }
		    if($re){
		    
    			//记录订单操作日志
    			add_order_log($_POST['oid'],$_POST['change_log']);
    			
    			//判断哪家快递,并且更新该快递的dtype
    			if($_POST['delivery']){
    			    $Delivery = M('Delivery');
    			    $_POST['delivery_type'] = $Delivery->where(['dname'=>$_POST['delivery']])->getField('dtype');
    			}
    			
    			
    			if($Order->where(array('oid'=>I('post.oid')))->save($_POST)){
    			  $this->success('编辑成功',U('Index/gb'));
    			}else{
    			  $this->error('编辑失败');
    			} 
		    }else{
		        $this->error('确认收货失败');
		    }
		}
    }
	//删除订单
	public function delorder(){
	    $Order = M('Orders');
		$where['state']  = array('in','1,2,3');
        $where['refund_state']  = array('eq',1);
        $where['_logic'] = 'or';
        $map['_complex'] = $where;
        $map['order_no']  = array('eq',I('get.order_no'));
        $re = $Order->where($map)->delete();
        if(!$re){
            $this->error('订单交易流程未结束');
        }
        $Ordergoods = M('Ordergoods');
		$re1 = $Ordergoods->where(array('order_no'=>I('get.order_no')))->delete();
		$this->success('删除成功');
	}
	public function delallorder(){
	    $Order = M('Orders');
		$where['state']  = array('in','1,2,3');
        $where['refund_state']  = array('eq',1);
        $where['_logic'] = 'or';
        $map['_complex'] = $where;
        $map['order_no']  = array('in',$_POST['checkBoxList']);
		$num = (int) $Order->where($map)->count();
		$num > 0 && $this->error('存在交易流程未结束的订单');
		//应该出不了问题,就不写事务了,直接默认删除成功
		$Ordergoods = M('Ordergoods');
		$re = $Order->where(array('order_no'=>array('in',$_POST['checkBoxList'])))->delete();
		$re1 = $Ordergoods->where(array('order_no'=>array('in',$_POST['checkBoxList'])))->delete();
		$this->success('删除成功');
	}
	//打印微信对账单
	public function download_bill(){
	    header("Content-type:text/html;charset=utf-8");
		//获取店铺微信支付数据
        vendor('WxPayPubHelper.SDKRuntimeException'); 
		define("APPID", C('WX_APPID'));
		define("MCHID", C('WX_MCHID'));
		define("KEY", C('WX_KEY'));
		define("APPSECRET", C('WX_APPSECRET'));
		vendor('WxPayPubHelper.WxPayPubHelper'); 
	    //对账单日期
	    $bill_date = date("Ymd",strtotime("-1 day"));//$_POST["bill_date"];
		//使用对账单接口
		$downloadBill = new DownloadBill_pub();
		//设置对账单接口参数
		//设置必填参数
		//appid已填,商户无需重复填写
		//mch_id已填,商户无需重复填写
		//noncestr已填,商户无需重复填写
		//sign已填,商户无需重复填写
		$downloadBill->setParameter("bill_date","$bill_date");//对账单日期 
		$downloadBill->setParameter("bill_type","ALL");//账单类型 
		//非必填参数，商户可根据实际情况选填
		//$downloadBill->setParameter("device_info","XXXX");//设备号  
		//对账单接口结果
		$downloadBillResult = $downloadBill->getResult();
		echo $downloadBillResult['return_code'];
		if ($downloadBillResult['return_code'] == "FAIL") {
			echo "通信出错：".$downloadBillResult['return_msg'];
		}else{
			 print_r('<pre>');
			 echo "【对账单详情】"."</br>";
			 print_r($downloadBill->response);
			 print_r('</pre>');
		}
    	
	}
	//选中下载
	public function alldown(){
		$Order = M('Orders');
		$Ordergoods = M('Ordergoods');
		$order_list_info = $Order->where(array('order_no'=>array('in',$_POST['checkBoxList'])))->order('time desc')->select();
		$order_goods_list = $Ordergoods->where(array('order_no'=>array('in',$_POST['checkBoxList'])))->select();
		foreach($order_list_info as $k=>$v){
		    $order_list[$k]['order']['order_info'] = $v;
		    foreach($order_goods_list as $kk=>$vv){
		        $v['order_no'] == $vv['order_no'] && $order_list[$k]['order']['order_goods'][] = $vv;
		    }
		}
		$time = date('Y-m-d');
    	$this->exele($order_list,$time.'日订单统计表');
    }
	//生成excel表格 
    protected function exele($order_list,$filename){

    	import('ORG.Util.PHPExcel');// 导入表格驱动
    	$data=array();
    	foreach ($order_list as $key => $value) {
    		$data[$key]['order_no']   =$value['order']['order_info']['order_no'];
    		$data[$key]['time']       =date('Y-m-d H:i:s',$value['order']['order_info']['time']);
			$data[$key]['best_time']  =$value['order']['order_info']['best_time'];
			$data[$key]['name']       =$value['order']['order_info']['name'];
			$data[$key]['tel']        =$value['order']['order_info']['tel'];
			$data[$key]['address']    =$value['order']['order_info']['address'];
			$data[$key]['remarks']    =$value['order']['order_info']['remarks'];
			$data[$key]['totalAmount']=$value['order']['order_info']['totalAmount'];
			$data[$key]['use_inter']  =$value['order']['order_info']['use_inter'];
			$data[$key]['pay_cash']   =$value['order']['order_info']['pay_cash'];
			$data[$key]['give_integral']=$value['order']['order_info']['give_integral'];
			$data[$key]['shipping_fee']=$value['order']['order_info']['shipping_fee'];
			//转换付费状态
			$pay_state = $value['order']['order_info']['pay_state'];
			if($pay_state==0){
			   $data[$key]['pay_state']   =  '未支付';
			}else{
			   $data[$key]['pay_state']   =  '已支付';
			}
			//转换付费方式
			$pay_method = $value['order']['order_info']['pay_method'];
			if($pay_state==0){
			   $data[$key]['pay_method']   =  '货到付款';
			}elseif($pay_state==1){
			   $data[$key]['pay_method']   =  '线上未支付';
			}elseif($pay_state==2){
			   $data[$key]['pay_method']   =  '支付宝支付';
			}elseif($pay_state==3){
			   $data[$key]['pay_method']   =  '微信支付';
			}elseif($pay_state==4){
			   $data[$key]['pay_method']   =  '食币支付';
			}
			//转换订单详情
			$order_goods  =  $value['order']['order_goods'];
			$str  =  '';
			foreach ($order_goods as $k => $goods) {
			   $str.="【商品名字】：".$goods['name']."【属性】：".$goods['goods_attr']."【价格】：".$goods['price']."【数量】：".$goods['num']."\r\n";
			}
			$data[$key]['order_goods']  = $str;
			
			
			
			$order_count[]=$value['order']['order_info']['order_no'];            //订单总数
			$totalAmount_count[]=$value['order']['order_info']['totalAmount'];   //商品订单总额
			$pay_cash_count[]=$value['order']['order_info']['pay_cash'];          //实际订单总数
			$use_inter_count[]=$value['order']['order_info']['use_inter'];      //使用食币总数
			$give_integral_count[]=$value['order']['order_info']['give_integral'];      //赠送食币总数
			$shipping_fee_count[]=$value['order']['order_info']['shipping_fee'];      //运费总数
    	}
    	$order_count=count($order_count);
		$totalAmount_count=array_sum($totalAmount_count);
		$pay_cash_count=array_sum($pay_cash_count);
		$use_inter_count=array_sum($use_inter_count);
		$give_integral_count=array_sum($give_integral_count);
		$shipping_fee_count=array_sum($shipping_fee_count);

    	$objPHPExcel=new PHPExcel();
        $objPHPExcel->getProperties()->setCreator('http://bbs.weidong100.com')
        ->setLastModifiedBy('http://bbs.weidong100.com')
        ->setTitle('Office 2007 XLSX Document')
        ->setSubject('Office 2007 XLSX Document')
        ->setDescription('Office 2007 XLSX Document.')
        ->setKeywords('http://www.weidong100.com')
        ->setCategory('Result file');
        //设置第一行，订单金额计算
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A1','订单总数')
        ->setCellValue('B1','商品订单总额')
        ->setCellValue('C1','实际现金收入总额')
        ->setCellValue('D1','使用积分总额')
        ->setCellValue('E1','运费收入总额')
        ->setCellValue('F1','赠送积分总额');
		//设置第二行，订单金额数值
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A2',$order_count)
        ->setCellValue('B2',$totalAmount_count)
        ->setCellValue('C2',$pay_cash_count)
        ->setCellValue('D2',$use_inter_count)
        ->setCellValue('E2',$shipping_fee_count)
        ->setCellValue('F2',$give_integral_count);
		//设置第一行
        $objPHPExcel->setActiveSheetIndex(0)
        ->setCellValue('A3','订单号')
        ->setCellValue('B3','下单日期')
        ->setCellValue('C3','配送时间')
        ->setCellValue('D3','收货人')
        ->setCellValue('E3','电话')
        ->setCellValue('F3','地址')
		->setCellValue('G3','备注')
		->setCellValue('H3','订单金额')
		->setCellValue('I3','使用积分')
		->setCellValue('J3','现金收入')
		->setCellValue('K3','赠送积分')
		->setCellValue('L3','运费')
		->setCellValue('M3','付款状态')
		->setCellValue('N3','支付方式')
		->setCellValue('O3','订单详情');
        //设置订单数据
        $i=4;
        foreach($data as $k=>$v){
            $objPHPExcel->setActiveSheetIndex(0)
			->setCellValue('A'.$i,$v['order_no'])
			->setCellValue('B'.$i,$v['time'])
			->setCellValue('C'.$i,$v['best_time'])
			->setCellValue('D'.$i,$v['name'])
			->setCellValue('E'.$i,$v['tel'])
			->setCellValue('F'.$i,$v['address'])
			->setCellValue('G'.$i,$v['remarks'])
			->setCellValue('H'.$i,$v['totalAmount'])
			->setCellValue('I'.$i,$v['use_inter'])
			->setCellValue('J'.$i,$v['pay_cash'])
			->setCellValue('K'.$i,$v['give_integral'])
			->setCellValue('L'.$i,$v['shipping_fee'])
			->setCellValue('M'.$i,$v['pay_state'])
			->setCellValue('N'.$i,$v['pay_method'])
			->setCellValue('O'.$i,$v['order_goods']);
            $i++;
        }
 		//生成xls文件
         header('Content-Type: application/vnd.ms-excel');
         header('Content-Disposition: attachment;filename="'.$filename.'.xls"');
         header('Cache-Control: max-age=0');
         $objWriter = PHPExcel_IOFactory::createWriter($objPHPExcel, 'Excel5');
         $objWriter->save('php://output');
         $this->success('导出成功');
    }
	//打印选中的订单
	public function print_order(){
	    $order_nos = $_POST['checkBoxList'];
	    $order_nos = explode(',',rtrim($order_nos,','));
	    print_order($order_nos,1);
	    
	}
	//发送短信通知  $oid订单编号  $change_log变更信息
    protected function send_sms($oid,$change_log){
        //获取订单信息
		$Order = M('Orders'); 
		$data = $Order->where(array('oid'=>$oid))->field('name,order_no,tel')->find();
		//开始发送短信
		$sms_touser = "尊敬的会员：".$data['name'] ."，你好！您的订单：".$data['order_no'] ."，订单状态已更新：".$change_log;
	    $send_result = send_message($data['tel'], $sms_touser);//发会员			

    }
    //选用户
    public function designateUser(){
        session('order_uid',null);
        if($_GET['tel']){
            $map['tel']  = array('eq',$_GET['tel']);
            $User = M('User');
            $list = $User->where($map)->select();
            $this->assign('list',$list);// 赋值数据集
        }
        $this->display();
    }
    
    //设置订单uid
    public function setOrderUid(){
        session('order_uid',I('get.uid'));
        echo json_encode(1);
    }
    
    //选好订单的商品
    public function designateOrder(){
        if(!session('order_uid')){
            redirect(U('Order/designateUser'));
        }
        $this->display();
    }
    
    
    //选商品列表
    public function designateGoods(){
        //把同等级的分类查询出来
        $Cate=M('Cate');
        if($_GET['cid']){
           $this->assign('cid',$_GET['cid']);
           //获取自己及所有子分类
            $cid_list = get_category( $_GET['cid'],$Cate );
            $cid_list = trim($cid_list,',');
            $map['cid'] = array('in', $cid_list);
        }
        
        if($_GET['keyword']){
           $map['name']  = array('like','%'.$_GET['keyword'].'%');
           $this->assign('keyword',$_GET['keyword']);
        }
        $cat = $Cate->where(array('cid' => I('get.cid')))->field('name,parentid,filter_attr')->find();
        $cate = $Cate->where(array('parentid' => $cat['parentid']))->order('c_order desc')->select();
        $Goods = D('Goods');
        
        $catename = $cat['name'];
        if ($_GET['order'] && $_GET['sort']) {
            $order = $_GET['sort'] . ' ' . $_GET['order'];
        } else {
            $order = 'g_order desc';
        }
        if ($_GET['order'] == 'asc') {
            $this->assign('order', 'desc');
        } else {
            $this->assign('order', 'asc');
        }
        $map['state'] = array('eq', 1);
        
        import('ORG.Util.Page');
        $count = $Goods->relation(true)->where($map)->count();
        //dump($Goods->getLastSql());
        $Page = new Page($count, 12);
        $Page->setConfig('header', '个商品');
        $show = $Page->show();
        $list = $Goods->relation(true)->where($map)->order($order)->limit($Page->firstRow . ',' . $Page->listRows)->select();
        $Products = M('Products');
        foreach($list as $k => $v){
            $productsList = [];
            $list[$k]['properties'] = get_goods_properties($v['gid']);  // 获得商品的规格和属性
            $list[$k]['goods_attr1'] = $list[$k]['properties']['spe'];
            $list[$k]['goods_attr_json'] = json_encode($list[$k]['goods_attr1']);
            //获取这个商品的所有库存
            $products = $Products->where(['goods_id'=>$v['gid']])->select();
            foreach($products as $kk => $vv){
                $vv['goods_sn'] = $vv['goods_id'].'|'.$vv['goods_attr'];
                $productsList[$vv['goods_attr']] = $vv;
            }
            $productsList = $productsList ? : "";
            $list[$k]['productsList'] = $productsList;
        }
        $list = goodsListHandle($list);
        //dump($list);
        $this->assign('page', $show);
        $this->assign('cate', $cate);
        $this->assign('list', $list);
        $this->assign('list_json',json_encode($list));
        
        $Cate = M('Cate');
	    $catelist = $Cate->order('c_order desc')->select();
		$catelist = cate_merge($catelist);
	    $this->assign('catelist',$catelist);
        
        $this->display();
    }
    
    public function getCart()
    {
        $mycartgoods = R('Putcart/getcart');
        echo json_encode($mycartgoods);
    }
    
    
    //选地址
    public function designateCheckout(){
        //加载购物车数据
	    $mycartgoods = R('Putcart/getcart');
        $this->assign('Putcartdata', json_encode($mycartgoods));  
        
        $setfile='Conf/site.php'; 
        $site = require $setfile;
        $this->assign('site',$site);
        
        
        //获取默认地址
        $User_address = D('UserAreaView');
        $default_address = $User_address->where(array('uid' => $_SESSION['order_uid'], 'is_default' => '1'))->find();
        $this->assign('default_address', $default_address);
	    //获取配送区域
        $Area = M('Area');
        $area = $Area->order('a_order desc')->select();
        $this->assign('area', $area);
        
        $Region=M('Region');
	    $provinceList=$Region->where(array('region_type'=>1))->select();
	    $this->assign('provinceList',$provinceList);
	    
	    //获取会员信息
	    $User=M('User');
	    $user=$User->where(array('uid'=>session('order_uid')))->find();
	    $this->assign('user',$user);
		$this->display();
    }
    
    //点击修改时获取地址列表
    public function get_address()
    {
        $User_address = D('UserAreaView');
        $list = $User_address->where(array('uid' => $_SESSION['order_uid']))->order('is_default desc,address_id desc')->select();
        echo json_encode($list);
    }
    
    //编辑地址的时候获取默认值
	public function getAddress(){
	    $User_address=M('User_address');
	    $where=array(
	        'address_id'=>$_POST['address_id'],
	        'uid'=>$_SESSION['order_uid']
	        );
        $result=$User_address->where($where)->find();
        if($result){
            $Region=M('Region');
            $result['province']=$Region->where(array('region_id'=>$result['province_id']))->find();
            $result['city']=$Region->where(array('region_id'=>$result['city_id']))->find();
            $result['county']=$Region->where(array('region_id'=>$result['county_id']))->find();
            $Site=M('Site');
            $result['site']=$Site->where(array('id'=>$result['site_id']))->find();
            $result['state']="1";
        }else{
            $result['state']="0";
        }
        echo json_encode($result);
	}
    
    
    //新增编辑收货地址
    public function add_address(){
        $User_address = M('User_address');
        $data['consignee'] = I('post.consignee');
        $data['area_id'] = I('post.area_id');
        if ($data['area_id'] == '1') {
            $data['province_id'] = I('post.province_id');
            $data['city_id'] = I('post.city_id');
            $data['county_id'] = I('post.county_id');
        }else{
            $data['province_id'] = 0;
            $data['city_id'] = 0;
            $data['county_id'] = 0;
        }
        $data['address'] = I('post.address');
        $data['tel'] = I('post.tel');
        if (empty($_POST['address_id'])) {
            //新增
            $is_have = $User_address->where(array('uid' => $_SESSION['order_uid']))->find();
            if (!$is_have) {
                $data['is_default'] = '1';
            }
            $data['uid'] = $_SESSION['order_uid'];
            $re = $User_address->add($data);
            if ($re) {
                if($_POST['area_id'] == 1){
                    //获取省市县
                    $Region = M('Region');
                    $result['province_name']=$Region->where(array('region_id'=>$data['province_id']))->getField('region_name');
                    $result['city_name']=$Region->where(array('region_id'=>$data['city_id']))->getField('region_name');
                    $result['county_name']=$Region->where(array('region_id'=>$data['county_id']))->getField('region_name');
                }
                $result['state'] = "1";
                $result['address_id'] = $re;
                $result['is_default'] = $data['is_default'];
            } else {
                $result['state'] = "0";
            }
        } else {
            //编辑
            $data['address_id'] = I('post.address_id');
            $uid = $User_address->where(array('address_id' => $data['address_id']))->find();
            if (!$uid) {
                $result['state'] = "0";
                echo json_encode($result);
                exit;
            }
            if ($uid['uid'] != $_SESSION['order_uid']) {
                $result['state'] = "0";
                echo json_encode($result);
                exit;
            }
            $re = $User_address->save($data);
            if ($re!==false) {
                if($_POST['area_id'] == 1){
                    //获取省市县
                    $Region = M('Region');
                    $result['province_name']=$Region->where(array('region_id'=>$data['province_id']))->getField('region_name');
                    $result['city_name']=$Region->where(array('region_id'=>$data['city_id']))->getField('region_name');
                    $result['county_name']=$Region->where(array('region_id'=>$data['county_id']))->getField('region_name');
                }
                $result['state'] = "2";
            } else {
                $result['state'] = "0";
            }
        }
        echo json_encode($result);
	}
	
	//提交订单
    public function order()
    {
        /**
        *  获取用户的购物车中的商品，数据结构
        *  $mycart['data'][$k]        商品表
           $mycart['total']['num']    总数 
           $mycart['total']['money']  总价
           $mycart['total']['use_integral_t']   总使用积分
           $mycart['total']['give_integral_t']  总赠送积分
        */
        $mycartgoods = R('Putcart/getcart');
        $order_no = date('YmdHis') . $_SESSION['order_uid'];
        //生成订单号
        //开始处理提交过来的订单商品
        $Ordergoods = M('Ordergoods');
        $Goods = M('Goods');
        foreach ($mycartgoods['data'] as $key => $v) {
            $v['order_no'] = $order_no;
            //开始减去商品库存
            $result = updategoodnum($v['goods_sn'], -$v['num']);
            if ($result['re'] == '004') {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error($v['name'] . '的库存不足，请减少购买数量！', U('Index/cart'));
                exit;
            } elseif ($result['re'] == '002') {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error('更新商品库存失败，请稍后再试！');
                exit;
            }
            unset($v['id']);
            if (!$Ordergoods->add($v)) {
                $Ordergoods->where(array('order_no' => $order_no))->delete();
                $this->error('订单中的商品写入失败！');
                exit;
            }
        }
        $Order = M('Orders');
        $_POST = I('post.');
        //过滤传值
        if (!empty($order_no)) {
            $User_address = D('UserAreaView');
            $default_address = $User_address->where(array('uid' => $_SESSION['order_uid'], 'address_id' => $_POST['default_address_id']))->find();
            if (!$default_address) {
                $this->error('参数错误!');
            }
            /*//获取选择地区的运费和名称
            		$Area = M('Area');
                    $area = $Area->where('area_id='.$default_address['area_id'])->find();*/
            //判断一下是否使用了积分
            if ($_POST['is_use_integral'] == 1) {
                //计算应付总额 = 订单总额 - 可用积分*兑换比例 + 运费
                if ($_SESSION['order_uid']) {
                    $User = M('User');
                    $myIntegralNum = $User->where(array('uid' => session('order_uid')))->getField('integral_num');
                } else {
                    $myIntegralNum = 0;
                }
                //可用积分换算到现金的金额
                if ($myIntegralNum > $mycartgoods['total']['use_integral_t']) {
                    $integralCash = $mycartgoods['total']['use_integral_t'] * C('integral_scale');
                    $use_inter = $mycartgoods['total']['use_integral_t'];
                } else {
                    $integralCash = $myIntegralNum * C('integral_scale');
                    $use_inter = $myIntegralNum;
                }
            } else {
                $integralCash = 0;
                $use_inter = 0;
            }
            if ($mycartgoods['total']['money'] >= $default_address['max_amount']) {
                $default_address['shipping_fee'] = 0;
            }
            $pay_cash = $mycartgoods['total']['money'] - $integralCash + $default_address['shipping_fee'];
            $data = array('order_no' => $order_no, 'name' => $default_address['consignee'], 'tel' => $default_address['tel'], 'area_id' => $default_address['area_id'], 'remarks' => $_POST['remarks'], 'time' => time(), 'totalAmount' => $mycartgoods['total']['money'], 'uid' => $_SESSION['order_uid'], 'state' => 0, 'pay_state' => 0, 'pay_method' => 0, 'give_integral' => $mycartgoods['total']['give_integral_t'], 'use_inter' => $use_inter, 'discount' => $integralCash, 'pay_cash' => $pay_cash, 'shipping_fee' => $default_address['shipping_fee']);
            if ($default_address['area_id'] == '1') {
                $data['address'] = $default_address['province_name'] . $default_address['city_name'] . $default_address['county_name'] . $default_address['address'];
            } else {
                $data['address'] = $default_address['aname'] . $default_address['address'];
            }
            $oid = $Order->add($data);
            if ($oid) {
                //扣除消费积分
                if ($use_inter != 0) {
                    edit_user_account($_SESSION["order_uid"], 0, '订单' . $order_no . '购物消费', 0, 0, -$use_inter, 1);
                }
                //清空购物车
                
                $goodscartsql = M('cart');
                $goodscartsql->where(array('uid' => $_SESSION['order_uid']))->delete();
                $_SESSION['mycart'] = '';
                
                //判断一下，是否在线支付
                $this->success('订单提交成功', U('Order/index'));
            } else {
                $this->error('提交失败');
            }
        } else {
            $this->error('提交失败');
        }
    }
}