<?php

class StatisticsAction extends CommonAction {
    
    //订单统计
	public function orderStatistics(){
        $Order = M('Orders');
		//什么都没有或者带有月份,就是统计月的折线图,如果带有年的话就是统计年的柱状图
		if($_GET['type'] == 'year'){
            //统计某年的柱状图
            //判断是否传递过来年,如果没有,那么默认就是当前年
            $this_year = date("Y");
            $y = I('get.year') ? : $this_year;
            //年初的时间戳
            $start = strtotime($y.'-01-01');
            //统计结束的时间戳
            $end = $y + 1;
            $end = strtotime($end.'-01-01');
            $where['time'] = [['gt',$start],['elt',$end]];
            //根据time分组查询
            $order_num = $Order->field("count(1) as order_num,FROM_UNIXTIME(time,'%Y-%m') as stime")->where($where)->group('stime')->select();
            //重组数据
            foreach($order_num as $k => $v){
                $count1[$v['stime']] = $v;
                $count1[$v['stime']]['month'] = explode('-',$v['stime'])[1];
            }
            //有的月份可能没有订单,所以就补齐
            for($i = $start;$i < $end;){
                $current_month = date("Y-m",$i);
                $count[$current_month] = $count1[$current_month] ? : ['order_num' => '0','stime' => $current_month,'month' => explode('-',$current_month)[1]];
                $next_month_day = $this->getNextMonthDays($current_month)[0];
                $next_month_arr = explode('-',$next_month_day);
                $next_month = $next_month_arr[0].'-'.$next_month_arr[1];
                $i = strtotime($next_month);
            }
            $this->assign('title',$y.'年订单月统计');
		}else{
            //统计某月的折线图
            //判断是否传递过来年月,如果没有,那么默认就是当前年月
            $this_month = date("Y-m");
            $ym = I('get.month') ? I('get.year').'-'.I('get.month') : $this_month;
            //月初的时间戳
            $start = strtotime($ym);
            //统计结束的时间戳
            //$end = $ym == $this_month ? date('Y-m-d',strtotime('+1 day')) : $this->getNextMonthDays($ym)[0];
            $end = $this->getNextMonthDays($ym)[0];
            $end = strtotime($end);
            $where['time'] = [['gt',$start],['elt',$end]];
            //根据time分组查询
            $order_num = $Order->field("count(1) as order_num,FROM_UNIXTIME(time,'%Y-%m-%d') as stime")->where($where)->group('stime')->select();
            //重组数据
            foreach($order_num as $k => $v){
                $count1[$v['stime']] = $v;
                $count1[$v['stime']]['day'] = explode('-',$v['stime'])[2];
            }
            //有的天数可能没有订单,所以就补齐
            for($i = $start;$i < $end;$i += 86400){
                $current_day = date("Y-m-d",$i);
                $count[$current_day] = $count1[$current_day] ? : ['order_num' => '0','stime' => $current_day,'day' => explode('-',$current_day)[2]];
            }
            //展示月
            for($i = 1;$i <= 12;$i++){
                $month_list[$i] = $i;
            }
            $this->assign('month_list',$month_list);
            $current_month = I('get.month') ? : date("m");
            $this->assign('current_month',$current_month);
            $this->assign('title',$ym.'月订单日统计');
		}
		//展示年
		$site_statistics_year = C('site_statistics_year');
        $year_explode = explode('#',$site_statistics_year);
        $start_year = $year_explode[0];
        $year_num = $year_explode[1];
        for($i = 0;$i <= $year_num;$i++){
            $year_list[$i] = $start_year + $i;
        }
        $this->assign('year_list',$year_list);
		$current_year = I('get.year') ? : date("Y");
        $this->assign('current_year',$current_year);
        $this->assign('count',$count);
        //模板展示
        if($_GET['type'] == 'year'){
            $this->display('orderStatisticsYear');
		}else{
		    $this->display();
		}
	}
	//会员统计
	public function userStatistics(){
        $Order = M('User');
		//什么都没有或者带有月份,就是统计月的折线图,如果带有年的话就是统计年的柱状图
		if($_GET['type'] == 'year'){
            //统计某年的柱状图
            //判断是否传递过来年,如果没有,那么默认就是当前年
            $this_year = date("Y");
            $y = I('get.year') ? : $this_year;
            //年初的时间戳
            $start = strtotime($y.'-01-01');
            //统计结束的时间戳
            $end = $y + 1;
            $end = strtotime($end.'-01-01');
            $where['time'] = [['gt',$start],['elt',$end]];
            //根据time分组查询
            $order_num = $Order->field("count(1) as order_num,FROM_UNIXTIME(regtime,'%Y-%m') as stime")->where($where)->group('stime')->select();
            //重组数据
            foreach($order_num as $k => $v){
                $count1[$v['stime']] = $v;
                $count1[$v['stime']]['month'] = explode('-',$v['stime'])[1];
            }
            //有的月份可能没有订单,所以就补齐
            for($i = $start;$i < $end;){
                $current_month = date("Y-m",$i);
                $count[$current_month] = $count1[$current_month] ? : ['order_num' => '0','stime' => $current_month,'month' => explode('-',$current_month)[1]];
                $next_month_day = $this->getNextMonthDays($current_month)[0];
                $next_month_arr = explode('-',$next_month_day);
                $next_month = $next_month_arr[0].'-'.$next_month_arr[1];
                $i = strtotime($next_month);
            }
            $this->assign('title',$y.'年新增会员月统计');
		}else{
            //统计某月的折线图
            //判断是否传递过来年月,如果没有,那么默认就是当前年月
            $this_month = date("Y-m");
            $ym = I('get.month') ? I('get.year').'-'.I('get.month') : $this_month;
            //月初的时间戳
            $start = strtotime($ym);
            //统计结束的时间戳
            //$end = $ym == $this_month ? date('Y-m-d',strtotime('+1 day')) : $this->getNextMonthDays($ym)[0];
            $end = $this->getNextMonthDays($ym)[0];
            $end = strtotime($end);
            $where['time'] = [['gt',$start],['elt',$end]];
            //根据time分组查询
            $order_num = $Order->field("count(1) as order_num,FROM_UNIXTIME(regtime,'%Y-%m-%d') as stime")->where($where)->group('stime')->select();
            //重组数据
            foreach($order_num as $k => $v){
                $count1[$v['stime']] = $v;
                $count1[$v['stime']]['day'] = explode('-',$v['stime'])[2];
            }
            //有的天数可能没有订单,所以就补齐
            for($i = $start;$i < $end;$i += 86400){
                $current_day = date("Y-m-d",$i);
                $count[$current_day] = $count1[$current_day] ? : ['order_num' => '0','stime' => $current_day,'day' => explode('-',$current_day)[2]];
            }
            //展示月
            for($i = 1;$i <= 12;$i++){
                $month_list[$i] = $i;
            }
            $this->assign('month_list',$month_list);
            $current_month = I('get.month') ? : date("m");
            $this->assign('current_month',$current_month);
            $this->assign('title',$ym.'月新增会员日统计');
		}
		//展示年
		$site_statistics_year = C('site_statistics_year');
        $year_explode = explode('#',$site_statistics_year);
        $start_year = $year_explode[0];
        $year_num = $year_explode[1];
        for($i = 0;$i <= $year_num;$i++){
            $year_list[$i] = $start_year + $i;
        }
        $this->assign('year_list',$year_list);
		$current_year = I('get.year') ? : date("Y");
        $this->assign('current_year',$current_year);
        $this->assign('count',$count);
        //模板展示
        if($_GET['type'] == 'year'){
            $this->display('userStatisticsYear');
		}else{
		    $this->display();
		}
	}
	//商品销售统计
	public function goodsStatistics(){
        //开始时间结束时间,默认n天,默认排名前n,可以选择商品分类,及关键词等
        //获取时间where条件
        if($_GET['start_time'] == '' && $_GET['end_time'] == '' || strtotime($_GET['end_time']) < strtotime($_GET['start_time']) && $_GET['start_time'] == ''){
            $_GET['start_time'] = date("Y-m-d H:i",strtotime("-1 week"));
            $_GET['end_time'] = date("Y-m-d H:i");
            $where['time'] = [['gt',strtotime($_GET['start_time'])],['elt',NOW_TIME]];
        }else{
            if($_GET['end_time'] == '' && $_GET['start_time'] != ''){
                $where['time'] = array('EGT',strtotime($_GET['start_time']));
            }else{
                if($_GET['end_time'] != '' && $_GET['start_time'] == ''){
                    $where['time'] = array('ELT',strtotime($_GET['end_time']));
                }else{
                    if($_GET['start_time'] != '' && $_GET['end_time'] != ''){
                        $where['time'] = array('between', array(strtotime($_GET['start_time']), strtotime($_GET['end_time'])));
                    }
                }
            }
        }
        //获取这一时间范围内商品的订单数据
        $where['pay_state'] = 1;
        $Order = M('Orders');
        $ordernoList = $Order->where($where)->getField('order_no',true);
        //获取该订单的商品
        $Ordergoods = M('Ordergoods');
        $map['order_no'] = ['in',$ordernoList];
        $gidList = $Ordergoods->where($map)->getField('gid',true);
        //gid去重
        $gidList = array_unique($gidList);
        //根据where条件去掉多余的商品
        $where1['gid'] = ['in',$gidList];
        if($_GET['cid']){
            $where1['cid'] = I('get.cid');
        }
        if($_GET['keyword']){
            $where1['name']  = array('like','%'.$_GET['keyword'].'%');
		}
		if($_GET['barcode']){
            $where1['barcode']  = array('eq',$_GET['barcode']);
		}
		$limit = I('get.limit') ? : 30;
		$this->assign('goods_limit',$limit);
		$Goods = M('Goods');
		$gidList = $Goods->where($where1)->getField('gid',true);
        $where2['gid'] = ['in',$gidList];
        $where2['order_no'] = $map['order_no'];
        $gid_num = $Ordergoods->field("sum(num) as gid_num,gid,name")->where($where2)->order('gid_num desc')->group('gid')->limit($limit)->select();
        $this->assign('gid_num',$gid_num);
		$Cate = M('Cate');
		$catelist = $Cate->order('c_order desc')->select();
		$catelist = cate_merge($catelist);
		$this->assign('catelist',$catelist);
		$this->display();
	}
	//商品销售统计
	public function areaStatistics(){
        //开始时间结束时间,默认n天,默认排名前n,可以选择商品分类,及关键词等
        //获取时间where条件
        if($_GET['start_time'] == '' && $_GET['end_time'] == '' || strtotime($_GET['end_time']) < strtotime($_GET['start_time']) && $_GET['start_time'] == ''){
            $_GET['start_time'] = date("Y-m-d H:i",strtotime("-1 week"));
            $_GET['end_time'] = date("Y-m-d H:i");
            $where['time'] = [['gt',strtotime($_GET['start_time'])],['elt',NOW_TIME]];
        }else{
            if($_GET['end_time'] == '' && $_GET['start_time'] != ''){
                $where['time'] = array('EGT',strtotime($_GET['start_time']));
            }else{
                if($_GET['end_time'] != '' && $_GET['start_time'] == ''){
                    $where['time'] = array('ELT',strtotime($_GET['end_time']));
                }else{
                    if($_GET['start_time'] != '' && $_GET['end_time'] != ''){
                        $where['time'] = array('between', array(strtotime($_GET['start_time']), strtotime($_GET['end_time'])));
                    }
                }
            }
        }
        //获取这一时间范围内商品的订单数据
        $where['pay_state'] = 1;
        $Order = M('Orders');
        $order_num = $Order->field('count(1) as order_num,area_id')->where($where)->group('area_id')->select();
        $Area = M('Area');
        $areaList = $Area->getField('area_id,name');
        foreach($order_num as $k => $v){
            $order_num[$k]['area_name'] = $areaList[$v['area_id']] ? : '未知区域';
        }
        $this->assign('order_num',$order_num);
		$this->display();
	}
	//获取下个月的第一天和最后一天
	function getNextMonthDays($date){
        $timestamp=strtotime($date);
        $arr=getdate($timestamp);
        if($arr['mon'] == 12){
            $year=$arr['year'] + 1;
            $month=$arr['mon'] - 11;
            $firstday=$year.'-0'.$month.'-01';
            $lastday=date('Y-m-d',strtotime("$firstday +1 month -1 day"));
        }else{
            $firstday=date('Y-m-01',strtotime(date('Y',$timestamp).'-'.(date('m',$timestamp)+1).'-01'));
            $lastday=date('Y-m-d',strtotime("$firstday +1 month -1 day"));
        }
        return array($firstday,$lastday);
    }
	
	
}