<?php
	//JS中读取U方法的地址
	
	function js_urldecode($url){
	   if(C('URL_MODEL') == 0) { // 普通模式URL转换
		   $url  =  $url;
		}else{ 
		   $url  =  urldecode($url);
		}
		return $url;
	}
	//短信发送
	function send_message($tel,$content){
		import('ORG.Util.qybsms.qybsms');
		$sendObj = new qybsms(C("sms_account"),C("sms_password"));
        $resultObj = $sendObj ->sendMessage($tel,$content.C('sms_sign'));
	}
    /**
     * 更改用户积分
     * @param String    $uid              用户识别码
     * @param String    $acid             活动id
     * @param String    $infor            变更原因
     * @param String    $recharge_num     金钱变更数量
     * @param String    $give_num         赠送金钱数量
     * @param String    $integral_num     赠送积分数量
     * @param Int       $type             变更类型
     * @return boolean              成功返回true失败false
     */
    function edit_user_account($uid,$acid,$infor,$recharge_num,$give_num,$integral_num,$type,$pay_id=0,$out_trade_no=''){
        $User_recharge=M('User_recharge');
        //判断该外部订单号是否已经存在
        if($out_trade_no){
    	    if($User_recharge->where(array('out_trade_no'=>$out_trade_no,'pay_id'=>$pay_id))->count()){
    	        return 1;
    	    }
        }
        $re=rechargeFun($uid,$acid,$infor,$recharge_num,$give_num,$integral_num,$type,$pay_id,$out_trade_no);
		if(!$re){
			//失败返回false
			return false;
		}
        $User = M('User');
        $allmoney = $recharge_num+$give_num;
        //积分数据
        $User->where(array('uid'=>$uid))->setInc('integral_num',$integral_num);
        $User->where(array('uid'=>$uid))->setInc('user_money',$allmoney);
        //发送短信通知
		if(C('is_sms_money')==1){
			if($integral_num>0){
				$mes1='积分增加'.$integral_num.'点,';
			}elseif($integral_num<0){
				$mes1='积分减少'.abs($integral_num).'点,';
			}else{
				$mes1='';
			}
			if($allmoney>0){
				$mes2='余额增加'.$allmoney.'元。';
			}elseif($allmoney<0){
				$mes2='余额减少'.abs($allmoney).'元。';
			}else{
				$mes2='';
			}
			$mes="您的账户发生调整：".$mes1.$mes2;
	    	$tel=$User->where(array('uid'=>$uid))->getField('tel');
            send_message($tel,$mes);
		}
        return true;
    }
    
    //用户资金变更处理
    function rechargeFun($uid,$acid,$infor,$recharge_num,$give_num,$integral_num,$type,$pay_id=0,$out_trade_no=''){
	    $User_recharge=M('User_recharge');
	    $data['uid']=$uid;
	    $data['acid']=$acid;
	    $data['pay_id']=$pay_id;
	    $data['infor']=$infor;
	    $data['recharge_num']=$recharge_num;
	    $data['give_num']=$give_num;
	    $data['integral_num']=$integral_num;
	    $data['type']=$type;
	    $data['out_trade_no']=$out_trade_no;
	    $data['time']=NOW_TIME;
	    $re=$User_recharge->add($data);
	    if($re){
	        return 1;
	    }else{
	        return 0;
	    }
	}
    
    
    
    
    //打印选中的订单  $order_nos是传递过来的订单号数组
	function print_order($order_nos,$super){
	    if(!is_array($order_nos)){
	        $order_nos1[0] = $order_nos;
	        $order_nos = $order_nos1;
	    }
	    $super == 1 && C('is_auto_print',$super);
        if (C('is_auto_print') == 1) {
    		$mKey         = C('print_mKey'); 
    		$machine_code = C('print_machine_code'); 
    		
    		$Order = M('Orders');
    		$Ordergoods = M('Ordergoods');
    		foreach($order_nos as $key=>$order_no){
    		    if($order_no){
    			    $order_info = $Order->where(array('order_no'=>$order_no))->find();
    				$order_goods = $Ordergoods->where(array('order_no'=>$order_no))->select();
                    $str= "                                ";
    				$str.= "@@2            订单小票\r\n";
    				$str.= "订 单 号：".$order_info['order_no']."\r\n";
    				$str.= "顾客姓名：".$order_info['name']."\r\n";
    				$str.= "顾客电话：".$order_info['tel']."\r\n";
    				$str.= "送餐地址：".$order_info['address']."\r\n";
    				$str.= "下单时间：".date('Y-m-d H:i:s',$order_info['time'])."\r\n";
    				//$str.= "预定时间：".$order_info['best_time']."\r\n";
    				$str.= "********************************\r\n";
    				$str.= "商品名  属性  单价  数量  小计\r\n";
    				foreach ($order_goods as $k => $goods) {
    				   $str.=$goods['name']."\r\n    ".$goods['goods_attr']."  ".$goods['price']."  *".$goods['num']."  ".$goods['num']*$goods['price']."\r\n";
    				}
    				$str.= "********************************\r\n";
    				$str.= "商品总额：".$order_info['totalAmount']."\r\n";
    				$str.= "运费总额：".$order_info['shipping_fee']."\r\n";
    				$str.= "使用积分：".$order_info['use_inter']."\r\n";
    				$str.= "备注：".$order_info['remarks']."\r\n";
    				$str.= "                                ";
    				$str.= "@@2实收总额：".$order_info['pay_cash']."\r\n";
    				
    							
    				$msg          = $str; //打印内容
    				//开始生成打印签名
    				$ti = time();
    				$params = array(
    						'partner'=>'2085',
    						'machine_code'=>$machine_code,
    						'time'=>$ti
    				);
    				$sign = generateSign($params,'d57f423c3b61aed73817fd986672fa32ad025b2b',$mKey);
    				$sign1=strtoupper(md5('d57f423c3b61aed73817fd986672fa32ad025b2bmachine_code'.$machine_code.'partner'.$params['partner'].$mKey));
    				$post_data = array ("partner" => $params['partner'],"sign" => $sign1,"machine_code"=>$params['machine_code']);
    				$ch="open.10ss.net:8888/getstatus.php";
    				$p1 = '';
    				foreach ($post_data as $k => $v) {
    					$p1 .= $k.'='.$v.'&';
    				}
    				$data1 = rtrim($p1, '&');
                    $result1 = liansuo_post($ch,$data1);
                    //dump($result1);
                    //exit;
                    if($result1=='0'){
                        //离线
                        //echo json_encode($result1);
                        //exit;
                    }else if($result1=='2'){
                        //缺纸
                        //echo json_encode($result1);
                        //exit;
                    }
    				$params['sign'] = $sign;
    				$params['content'] = $msg;
    				$url = 'open.10ss.net:8888';//接口端点
    				$p = '';
    				foreach ($params as $k => $v) {
    					$p .= $k.'='.$v.'&';
    				}
    				$data = rtrim($p, '&');
    				$result = liansuo_post($url,$data);
    				//dump($result);
    				$arr = array('order');
    	            if(!in_array(ACTION_NAME,$arr)){
    			    	//echo json_encode($result);
    	            }
    			}
    		}
        }
	}
	
	
	
	
	/*打印机使用模拟访问*/
	function liansuo_post($url,$data){ // 模拟提交数据函数  
		$curl = curl_init(); // 启动一个CURL会话      
		curl_setopt($curl, CURLOPT_URL, $url); // 要访问的地址                  
		curl_setopt($curl, CURLOPT_SSL_VERIFYPEER, 0); // 对认证证书来源的检测    
		curl_setopt($curl, CURLOPT_SSL_VERIFYHOST, 1); // 从证书中检查SSL加密算法是否存在      
		curl_setopt($curl, CURLOPT_USERAGENT, $_SERVER['HTTP_USER_AGENT']); // 模拟用户使用的浏览
		curl_setopt($curl, CURLOPT_HTTPHEADER, array('Expect:')); //解决数据包大不能提交     
		curl_setopt($curl, CURLOPT_FOLLOWLOCATION, 1); // 使用自动跳转      
		curl_setopt($curl, CURLOPT_AUTOREFERER, 1); // 自动设置Referer      
		curl_setopt($curl, CURLOPT_POST, 1); // 发送一个常规的Post请求      
		curl_setopt($curl, CURLOPT_POSTFIELDS, $data); // Post提交的数据包      
		curl_setopt($curl, CURLOPT_COOKIEFILE, $GLOBALS['cookie_file']); // 读取上面所储存的Cookie信息      
		curl_setopt($curl, CURLOPT_TIMEOUT, 30); // 设置超时限制防止死循     
		curl_setopt($curl, CURLOPT_HEADER, 0); // 显示返回的Header区域内容      
		curl_setopt($curl, CURLOPT_RETURNTRANSFER, 1); // 获取的信息以文件流的形式返回 
			   
		$tmpInfo = curl_exec($curl); // 执行操作 
		//dump($tmpInfo);
                //exit;
		if (curl_errno($curl)) {      
		   return 'fail';      
		}else{
		   curl_close($curl); // 关键CURL会话
		   if($tmpInfo=='status:0'){
		       return '0';
		   }else if($tmpInfo=='status:2'){
		       return '2';
		   }else{
	        return 'success'; // 返回数据   
		   }
		}      
		 
	}    
	/*打印机使用加密*/
	function generateSign($params, $apiKey, $msign)
	{
		//所有请求参数按照字母先后顺序排
		ksort($params);
		//定义字符串开始所包括的字符串
		$stringToBeSigned = $apiKey;
		//把所有参数名和参数值串在一起
		foreach ($params as $k => $v)
		{
			$stringToBeSigned .= urldecode($k.$v);
		}
		unset($k, $v);
		//定义字符串结尾所包括的字符串
		$stringToBeSigned .= $msign;
		//使用MD5进行加密，再转化成大写
		return strtoupper(md5($stringToBeSigned));
	}
	//递归重组分类信息为多维数组
	function cate_merge($cate, $access = null ,$parentid = 0){
	    $arr = array();
	    foreach($cate as $v){
	        if(is_array($access)){
	            $v['access'] = in_array($v['cid'],$access)?1:0;
	        }
	        if($v['parentid'] == $parentid){
	            $v['child'] = cate_merge($cate,$access,$v['cid']);
	            $arr[] = $v;
	        }
	    }
	    return $arr;
	}
	//自动收货
	function auto_receipt(){
	    $receipt_day = C('receipt_day');
	    $Order = M('Orders');
	    //获取所有待收货订单id
	    $orderList=$Order->where('DATEDIFF(CURDATE(),FROM_UNIXTIME(`time`, "%Y-%m-%d"))>='.$receipt_day.' and state=2')->getField('oid,uid');
	    foreach($orderList as $k=>$v){
	        edit_order_state($k,$v);
	    }
	}
	
	/** 
    * 确认收货
    * @param int $oid 订单id 
    * @param int $uid 会员id 
    * @return int  1代表成功,0代表失败
    */
	function edit_order_state($oid,$uid){
	    $Order = M('Orders');
        if ($Order->where(array('uid' => $uid, 'oid' => $oid))->setField('state', 3)) {
            add_order_log($oid,'订单'.$order['order_no'].'确认收货了');
            //增加商品销量
            addsalenum($oid);
            return 1;
        } else {
            return 0;
        }
    }
	
	//增加商品销量
	function addsalenum($oid)
    {
        $Order = M('ordergoods');
        $Goods = M('Goods');
        $Ordergoods = $Order->field('gid,num')->where(array('oid' => $oid))->select();
        foreach ($Ordergoods as $key => $value) {
            $Goods->where(array('gid' => $value['gid']))->setInc('base_num', $value['num']);
        }
    }
	
	//获取完整的数据库表名
	function table($name){
	    return C('DB_PREFIX').$name;
	}
		
	// 打印log
	function  log_result($file,$word) 
	{
	    $fp = fopen($file,"a");
	    flock($fp, LOCK_EX) ;
	    fwrite($fp,"执行日期：".strftime("%Y-%m-%d-%H：%M：%S",time())."\n".$word."\n\n");
	    flock($fp, LOCK_UN);
	    fclose($fp);
	}
	
	//model里面返回数据
	function out_info_model($code,$message,$data){
	    return array('code'=>$code,'message'=>$message,'data'=>$data);
	}
	
	//没有付款的并且不是货到付款的订单取消订单
    function is_exceed_pay_time($uid){
        //获取是否设置了付款时限
        /*if(!C('site_pay_time')) return;
        $uid && $where['uid'] = array('eq',$uid);
        $where['time'] = array('elt',time()-C('site_pay_time')*60);
        $where['pay_state'] = array('eq',0);
        $where['state'] = array('neq',-1);
        $Orders = M('Orders');
        $id_list = $Orders->where($where)->getField('oid',true);
        $Ordergoods = M('Ordergoods');
        $Goods = M('Goods');
        $Goods_attr = M('Goods_attr');
        foreach($id_list as $k => $v){
            backInventory($v,$Orders,$Ordergoods,$Goods,$Goods_attr);
        }*/
    }
    //订单库存退回
    function backInventory($oid,$Orders,$Ordergoods,$Goods,$Goods_attr){
        $order = $Orders->where(array('oid'=>$oid))->find();
        $Orders->where(array('oid'=>$oid))->setField('state','-1');
        $ordergoods = $Ordergoods->where(array('order_no'=>$order['order_no']))->select();
        foreach($ordergoods as $k => $v){
            //返回库存
            updategoodnum($v['goods_sn'],$v['num']);
        }
    }
    /*
      修改商品的库存
      string $goods_sn 商品货号
      int    $num      商品数量
    */
    function updategoodnum($goods_sn,$num)
    {
        //如果goods_sn包含_，说明是含属性商品
        $param = array();
        $param = explode('_', $goods_sn);
        if($num < 0){
            //获取当前商品的库存
            $goods_number = getgoodnum($goods_sn);
            if ($goods_number < abs($num)) {
                $datas['data'] = '库存不足';
                $datas['re'] = '004';
                return $datas;
                exit;
            }
        }
        if(strpos($goods_sn ,'_') !== false){
            
            //包含属性,更改属性库存
            $Products = M('Products');
            //$goods_sn = str_replace($param[0]."_", "",$goods_sn);
            $goods_sn = preg_replace('/'.$param[0]."_".'/', "",$goods_sn,1);
            $goods_sn = str_replace("_", "|",$goods_sn);
            //out_info(209,$goods_sn);
            //更改属性库存
            if($Products->where(['goods_attr'=>$goods_sn])->setInc('product_number',$num)){
                $datas['data'] = '操作成功';
                $datas['re'] = '001';
                return $datas;
            }else{
                $datas['data'] = '操作失败';
                $datas['re'] = '002';
                return $datas;
            }
        }else{
            //不含属性,更改商品库存
            $Goods = M('Goods');
            if ($Goods->where(array('gid'=>$param[0]))->setInc('goods_number',$num)) {
                $datas['data'] = '操作成功';
                $datas['re'] = '001';
                return $datas;
            } else {
                $datas['data'] = '操作失败';
                $datas['re'] = '002';
                return $datas;
            }
        }
    }
    //接口信息输出
    function out_info($code,$tips,$data=""){
        $datas['code'] = $code;
        $datas['message'] = $tips;
        $datas['data'] = $data;
	    echo json_encode($datas,JSON_UNESCAPED_SLASHES | JSON_UNESCAPED_UNICODE);
	    exit;
    }
    
    //插入订单日志
	function add_order_log($oid,$content){
	    $Order_log = M('Order_log');
	    if(session('admin_id')){
	        $Admin = M('Admin_user');
	        $data['admin_id'] = session('admin_id');
	        $data['admin_name'] = $Admin->where(array('admin_id'=>session('admin_id')))->getField('admin_name');
	        $data['type'] = 2;
	    }else{
	        $data['admin_id'] = 0;
	        $data['admin_name'] = '系统记录';
	        $data['type'] = 1;
	    }

	    $data['oid'] = $oid;
	    $data['content'] = $content;
	    $data['add_time'] = NOW_TIME;
	    $Order_log->add($data);
	}
    
    //发送订单短信通知
	function send_order_msg($order){
	    if($order){
    	    //检查一下是否开启短信发送
    		if(C('is_sms_order') == 1){
    			$time = date("Y-m-d日H:i:s");
    			$tel=C('get_tel');
    			$sms_touser = "尊敬的会员：".$order['name'] ."，你好！您的订单：".$order['order_no'] ."，店小二已经收到，会尽快给您配送，请保持电话通畅！";
    			$send_result = send_message($order['tel'], $sms_touser);//发会员			
    		}
	    }
	}
	
	//在线支付回调写入写出充值记录
    function online_pay($order,$total_fee){
        $out_trade_no=date("YmdHis").$order['uid'];
        rechargeFun($order['uid'],0,'为订单'.$order['order_no'].'支付而产生的充值记录',$total_fee,0,0,0,$order['pay_method'],$out_trade_no);
        rechargeFun($order['uid'],0,'为订单'.$order['order_no'].'支付而产生的消费记录',-$total_fee,0,0,1,0,$out_trade_no);
    }
	
	function goodsListHandle($list){
	    if(!$list){
	        return $list;
	    }
	    foreach($list as $k=>$v){
            if(strtotime($v['end_time']) >= time()  && $v['is_promote']==1 ){
                $list[$k]['is_promote'] = 1;
                $list[$k]['price'] = $v['promote_price'];
            }elseif(strtotime($v['end_time']) < time() && $v['is_promote']==1){
                updategoodpromote($v['gid']);
            }else{
                $list[$k]['is_promote'] = 0;
            }
            if($v['goods_attr']){
                $list[$k]['goods_attr'] = 1;
            }else{
                $list[$k]['goods_attr'] = 0;
            }
	    }
	    return $list;
	}
	//设置登陆令牌
    function setLoginToken(){
        if(!session('uid')){
            return 0;
        }
        $User=M('User');
        $user=$User->where(array('uid'=>session('uid')))->find();
        if(!$user){
            return 0;
        }
        //如果token不存在则生成一个token
        if(!$user['login_token']){
            $login_token=md5($user['tel'].$user['password']);
            $re=$User->where(array('uid'=>session('uid')))->save(array('login_token'=>$login_token));
            if($re){
                cookie('login_token',$login_token,3600*24*7);
                return 1;
            }
        }else{
            cookie('login_token',$user['login_token'],3600*24*7);
            return 1;
        }
    }
    
    //删除登陆令牌和cookie
    function delLoginToken($uid){
        $User=M('User');
        $user=$User->where(array('uid'=>$uid))->find();
        if(!$user){
            return 0;
        }
        if($user['login_token']){
            $re=$User->where(array('uid'=>$uid))->save(array('login_token'=>''));
            if($re){
                cookie('login_token',null);
                return 1;
            }
        }else{
            cookie('login_token',null);
            return 1;
        }
    }
    
    //比较登陆令牌和cookie是否相同
    function checkLoginToken(){
        //去数据库寻找是否有相同的logintoken
        $User=M('User');
        $user=$User->where(array('login_token'=>cookie('login_token')))->find();
        if($user){
            return $user['uid'];
        }else{
            return 0;
        }
    }
    
    //把数据表存入缓存
	//$name 数据库表名首字母大写 $where where条件array数组 $order order排序字符串 $time 缓存时间,默认为0永不过期,$group array(1,2,3)
	function setScache($name,$where,$order,$group,$group_name,$time=0,$MD='M'){
	    $Model=$MD($name);
	    if($group){//如果传入了group,则代表在县区下面还要继续划分数组
	        foreach($group as $k=>$v){
	            $list[$v]=$Model->where($where)->where(array($group_name=>$v))->order($order)->select();
	        }
	    }else{
	        $list=$Model->where($where)->order($order)->select();
	    }
	    S($name,$list,$time);
	}
	
	//得到缓存
	//$name 数据库表名首字母大写 $where where条件array数组 $order order排序字符串 $time 缓存时间,默认为0永不过期
	function getScache($name,$where,$order,$group,$group_name,$time=0,$MD='M'){
	    $Scache=S($name);
	    if(empty($Scache)){
            setScache($name,$where,$order,$group,$group_name,$time,$MD);
            $Scache=S($name);
        }
        return $Scache;
	}
	
	//支付回调处理
    function payCallHandle($order_no,$payid,$total_fee,$trade_no=''){
        $Order = M('Orders');
		//判断订单是否已经支付过
		$order=$Order->where(array('order_no'=>$order_no))->find();
		if($order['pay_state']==1){
		    echo "success";
		    exit;
		}
		$Pay_way=M('Pay_way');
		$pay_way=$Pay_way->where(array('id'=>$payid))->find();
		$data = array('state'=>0,'pay_state'=>'1','pay_method'=>$payid,'pay_name'=>$pay_way['pay_name'],'pay_time'=>NOW_TIME,'trade_no'=>$trade_no);
        $re=$Order->where(array('order_no'=>$order_no))->setField($data);	
        $order=$Order->where(array('order_no'=>$order_no))->find();
        add_order_log($order['oid'],'使用'.$pay_way['pay_name'].'支付了订单'.$order_no);
        //发送各类消息
        order_msg($order,$total_fee);
        if($re){
            echo "success";
            exit;
        }
        return $re;
    }
    //给商家发送订单短信通知
	function send_order_msg_to_shop($order){
	    if($order){
    	    //检查一下是否开启短信发送
    		if(C('is_sms_order') == 1){
    		    $time = date("Y-m-d日H:i:s");
                $get_tel = C('get_tel');
                //拆分多手机号
                $tel = explode(',', $get_tel);
                foreach ($tel as $key => $v) {
                    $sms_toshoper = "新订单通知！会员：" . $order['name'] . "，单号：" . $order['order_no'] . "，总额：" . $order['totalAmount'] . "元，时间：" . $time . "，请尽快处理！";
                    $send_result = send_message($v, $sms_toshoper);
                    //发商家
                }
    		}
	    }
	}
	//发送订单的各种通知
    function order_msg($order,$total_fee,$type=1){
        //发送短信
        send_order_msg($order);
        if($type == 1){
            //在线支付回调写入写出充值记录
            online_pay($order,$total_fee);
        }
        //给商家发送短信通知
        send_order_msg_to_shop($order);
        //打印小票
        print_order($order['order_no']);
    }
    //文本特殊字符替换处理,传入字符串或者数组均可
    function dataReplace($array){
        //假设以后需要更多的替换,自行添加,在最外层的config.php里面
        $data_replace = C('DATA_REPLACE');
        if(!is_array($array)){
            $array = tihuan($array,$data_replace);
        }else{
            foreach($array as $k => $v){
                if(is_array($v)){
                    $array[$k] = dataReplace($v);
                }else{
                    $array[$k] = tihuan($v,$data_replace);
                }
            }
        }
        return $array;
    }
    //替换操作
    function tihuan($v,$data_replace){
        $v = str_replace(array("\t","\n","\r"),array("","",""),$v);
        $length = strlen($v);
        $v1 = '';
        for($i = 0;$i < $length;$i++){
		    $v1 .= isset($data_replace[$v[$i]]) ? $data_replace[$v[$i]] : $v[$i];
        }
        return $v1;
    }
    
    function get_category( $category_id,$Cate ){
        $category_ids = $category_id.",";
        $child_category = $Cate ->where(array('parentid'=>$category_id))->select();
        foreach( $child_category as $key => $val )
            $category_ids .= get_category( $val["cid"],$Cate );
        return $category_ids;
    }
    
    /**
 * 重写 URL 地址
 *
 * @access  public
 * @param   string  $app        执行程序
 * @param   array   $params     参数数组
 * @param   string  $append     附加字串
 * @param   integer $page       页数
 * @param   string  $keywords   搜索关键词字符串
 * @return  void
 */
function build_uri($app, $params, $append = '', $page = 0, $keywords = '', $size = 0)
{
    static $rewrite = NULL;

    if ($rewrite === NULL)
    {
        $rewrite = intval($GLOBALS['_CFG']['rewrite']);
    }

    $args = array('cid'   => 0,
                  'gid'   => 0,
                  'bid'   => 0,
                  'acid'  => 0,
                  'aid'   => 0,
                  'sid'   => 0,
                  'gbid'  => 0,
                  'auid'  => 0,
                  'sort'  => '',
                  'order' => '',
                );

    extract(array_merge($args, $params));

    $uri = '';
    switch ($app)
    {
        case 'cate':
            if (empty($cid))
            {
                return false;
            }
            else
            {
                if ($rewrite)
                {
                    $uri = 'category-' . $cid;
                    if (isset($bid))
                    {
                        $uri .= '-b' . $bid;
                    }
                    if (isset($price_min))
                    {
                        $uri .= '-min'.$price_min;
                    }
                    if (isset($price_max))
                    {
                        $uri .= '-max'.$price_max;
                    }
                    if (isset($filter_attr))
                    {
                        $uri .= '-attr' . $filter_attr;
                    }
                    if (!empty($page))
                    {
                        $uri .= '-' . $page;
                    }
                    if (!empty($sort))
                    {
                        $uri .= '-' . $sort;
                    }
                    if (!empty($order))
                    {
                        $uri .= '-' . $order;
                    }
                }
                else
                {
                    $uri = U('Index/goodslist',array('cid'=>$cid));
                    if (!empty($bid))
                    {
                        $uri .= '&amp;brand=' . $bid;
                    }
                    if (isset($price_min))
                    {
                        $uri .= '&amp;price_min=' . $price_min;
                    }
                    if (isset($price_max))
                    {
                        $uri .= '&amp;price_max=' . $price_max;
                    }
                    if (!empty($filter_attr))
                    {
                        $uri .='&amp;filter_attr=' . $filter_attr;
                    }

                    if (!empty($page))
                    {
                        $uri .= '&amp;p' . $page;
                    }
                    if (!empty($sort))
                    {
                        $uri .= '&amp;sort=' . $sort;
                    }
                    if (!empty($order))
                    {
                        $uri .= '&amp;order=' . $order;
                    }
                }
            }

            break;
        default:
            return false;
            break;
    }

    if ($rewrite)
    {
        if ($rewrite == 2 && !empty($append))
        {
            $uri .= '-' . urlencode(preg_replace('/[\.|\/|\?|&|\+|\\\|\'|"|,]+/', '', $append));
        }

        $uri .= '.html';
    }
    if (($rewrite == 2) && (strpos(strtolower(EC_CHARSET), 'utf') !== 0))
    {
        $uri = urlencode($uri);
    }
    return $uri;
}
// +----------------------------------------------------------------------
    // | 用户输入过滤函数 [ 开始 ]
    // +----------------------------------------------------------------------

	/**
	 * 过滤字符串
	 * @param string $value 须要过滤的字符串
	 * @param bool $trim 是否过滤掉首尾空格
	 * @return string
	 */
	function filter_string($value, $trim = false) {
		if($trim == true) {
			return trim(filter_var($value, FILTER_SANITIZE_STRING));
		} else {
			return filter_var($value, FILTER_SANITIZE_STRING);
		}
	}

	/**
	 * 过滤用户输入的浮点数
	 * @param $value
	 * @return float|double|false
	 */
	function filter_float($value) {
		return filter_var($value, FILTER_SANITIZE_NUMBER_FLOAT, FILTER_FLAG_ALLOW_FRACTION);
	}

	/**
	 * 过滤用户输入的整数
	 * @param $value
	 * @return int
	 */
	function filter_int($value) {
		return intval(filter_var($value, FILTER_SANITIZE_NUMBER_INT));
	}

	/**
	 * 过滤用户输入的email地址
	 * @param $value
	 * @return mixed
	 */
	function filter_email($value) {
		return filter_var($value, FILTER_SANITIZE_EMAIL);
	}

	// +----------------------------------------------------------------------
    // | 用户输入过滤函数 [ 结束 ]
    // +----------------------------------------------------------------------
    //功能很少的敏感标点符号替换
	function sensitiveReplace($words){
	    if($words==''){
	        return $words;
	    }
	    $words=str_replace('\\',"、",$words);
        $words=preg_replace('/"([^"]*)"/', '“${1}”', $words);
        $words=preg_replace("/'([^']*)'/", '‘${1}’', $words);
        $words=str_replace("'","‘",$words);
        $words=str_replace('"',"“",$words);
        return $words;
	}
	
	/**
 * 获得商品已添加的规格列表
 *
 * @access      public
 * @params      integer         $goods_id
 * @return      array
 */
function get_goods_specifications_list($goods_id)
{
    if (empty($goods_id))
    {
        return array();  //$goods_id不能为空
    }

    $sql = "SELECT g.goods_attr_id, g.attr_value, g.attr_id, a.attr_name
            FROM " . table('goods_attr') . " AS g
                LEFT JOIN " . table('attribute') . " AS a
                    ON a.attr_id = g.attr_id
            WHERE goods_id = '$goods_id'
            AND a.attr_type = 1
            ORDER BY g.attr_id ASC";
    $results = M('goods_attr')->query($sql);
    return $results;
}

/**
 * 获得商品的货品列表
 *
 * @access  public
 * @params  integer $goods_id
 * @params  string  $conditions
 * @return  array
 */
function product_list($goods_id, $conditions = '')
{
    
        $filter['goods_id']         = $goods_id;
        /* 记录总数 */
        $sql = "SELECT COUNT(*) as count FROM " .table('products'). " AS p WHERE goods_id = $goods_id ";
        $filter['record_count'] = M('products')->query($sql)[0]['count'];

        $sql = "SELECT product_id, goods_id, goods_attr, product_sn, product_number
                FROM " . table('products') . " AS g
                WHERE goods_id = " . $goods_id;
                
    $row = M('products')->query($sql);
    
    

    /* 处理规格属性 */
    $goods_attr = product_goods_attr_list($goods_id);
    
    foreach ($row as $key => $value)
    {
        $_goods_attr_array = explode('|', $value['goods_attr']);
        if (is_array($_goods_attr_array))
        {
            $_temp = '';
            foreach ($_goods_attr_array as $_goods_attr_value)
            {
                 $_temp[] = $goods_attr[$_goods_attr_value];
            }
            $row[$key]['goods_attr'] = $_temp;
        }
    }

    return array('product' => $row, 'filter' => $filter, 'record_count' => $filter['record_count']);
}

/**
 * 获得商品的规格属性值列表
 *
 * @access      public
 * @params      integer         $goods_id
 * @return      array
 */
function product_goods_attr_list($goods_id)
{
    if (empty($goods_id))
    {
        return array();  //$goods_id不能为空
    }

    $sql = "SELECT goods_attr_id, attr_value FROM " . table('goods_attr') . " WHERE goods_id = '$goods_id'";
    $results = M('goods_attr')->query($sql);

    $return_arr = array();
    foreach ($results as $value)
    {
        $return_arr[$value['goods_attr_id']] = $value['attr_value'];
    }

    return $return_arr;
}

/**
 * 获得商品的货品总库存
 *
 * @access      public
 * @params      integer     $goods_id       商品id
 * @params      string      $conditions     sql条件，AND语句开头
 * @return      string number
 */
function product_number_count($goods_id, $conditions = '')
{
    if (empty($goods_id))
    {
        return -1;  //$goods_id不能为空
    }

    $sql = "SELECT SUM(product_number) as sum
            FROM " . table('products') . "
            WHERE goods_id = '$goods_id'
            " . $conditions;
    $nums = M('products')->query($sql)[0]['sum'];
    $nums = empty($nums) ? 0 : $nums;

    return $nums;
}

/**
 * 插入或更新商品属性
 *
 * @param   int     $goods_id           商品编号
 * @param   array   $id_list            属性编号数组
 * @param   array   $is_spec_list       是否规格数组 'true' | 'false'
 * @param   array   $value_price_list   属性值数组
 * @return  array                       返回受到影响的goods_attr_id数组
 */
function handle_goods_attr($goods_id, $id_list, $is_spec_list, $value_price_list)
{
    $goods_attr_id = array();

    /* 循环处理每个属性 */
    foreach ($id_list AS $key => $id)
    {
        $is_spec = $is_spec_list[$key];
        if ($is_spec == 'false')
        {
            $value = $value_price_list[$key];
            $price = '';
        }
        else
        {
            $value_list = array();
            $price_list = array();
            if ($value_price_list[$key])
            {
                $vp_list = explode(chr(13), $value_price_list[$key]);
                foreach ($vp_list AS $v_p)
                {
                    $arr = explode(chr(9), $v_p);
                    $value_list[] = $arr[0];
                    $price_list[] = $arr[1];
                }
            }
            $value = join(chr(13), $value_list);
            $price = join(chr(13), $price_list);
        }

        // 插入或更新记录
        $sql = "SELECT goods_attr_id FROM " . table('goods_attr') . " WHERE goods_id = '$goods_id' AND attr_id = '$id' AND attr_value = '$value' LIMIT 0, 1";
        $result_id = M('goods_attr')->query($sql)[0]['goods_attr_id'];
        if (!empty($result_id))
        {
            $sql = "UPDATE " . table('goods_attr') . "
                    SET attr_value = '$value'
                    WHERE goods_id = '$goods_id'
                    AND attr_id = '$id'
                    AND goods_attr_id = '$result_id'";

            $goods_attr_id[$id] = $result_id;
            M('goods_attr')->query($sql);
        }
        else
        {
            $sql = "INSERT INTO " . table('goods_attr') . " (goods_id, attr_id, attr_value, attr_price) " .
                    "VALUES ('$goods_id', '$id', '$value', '$price')";
            $data = [
                'goods_id' => $goods_id,
                'attr_id' => $id,
                'attr_value' => $value,
                'attr_price' => $price,
            ];
            $re = M('goods_attr')->add($data);
            $goods_attr_id[$id] = $re;
        }
    }

    return $goods_attr_id;
}

/**
 * 将 goods_attr_id 的序列按照 attr_id 重新排序
 *
 * 注意：非规格属性的id会被排除
 *
 * @access      public
 * @param       array       $goods_attr_id_array        一维数组
 * @param       string      $sort                       序号：asc|desc，默认为：asc
 *
 * @return      string
 */
function sort_goods_attr_id_array($goods_attr_id_array, $sort = 'asc')
{
    if (empty($goods_attr_id_array))
    {
        return $goods_attr_id_array;
    }

    //重新排序
    $sql = "SELECT a.attr_type, v.attr_value, v.goods_attr_id
            FROM " .table('attribute'). " AS a
            LEFT JOIN " .table('goods_attr'). " AS v
                ON v.attr_id = a.attr_id
                AND a.attr_type = 1
            WHERE v.goods_attr_id " . db_create_in($goods_attr_id_array) . "
            ORDER BY a.attr_id $sort";
    $row = M('attribute')->query($sql);

    $return_arr = array();
    foreach ($row as $value)
    {
        $return_arr['sort'][]   = $value['goods_attr_id'];

        $return_arr['row'][$value['goods_attr_id']]    = $value;
    }

    return $return_arr;
}

/**
 * 创建像这样的查询: "IN('a','b')";
 *
 * @access   public
 * @param    mix      $item_list      列表数组或字符串
 * @param    string   $field_name     字段名称
 *
 * @return   void
 */
function db_create_in($item_list, $field_name = '')
{
    if (empty($item_list))
    {
        return $field_name . " IN ('') ";
    }
    else
    {
        if (!is_array($item_list))
        {
            $item_list = explode(',', $item_list);
        }
        $item_list = array_unique($item_list);
        $item_list_tmp = '';
        foreach ($item_list AS $item)
        {
            if ($item !== '')
            {
                $item_list_tmp .= $item_list_tmp ? ",'$item'" : "'$item'";
            }
        }
        if (empty($item_list_tmp))
        {
            return $field_name . " IN ('') ";
        }
        else
        {
            return $field_name . ' IN (' . $item_list_tmp . ') ';
        }
    }
}

/**
 * 商品的货品规格是否存在
 *
 * @param   string     $goods_attr        商品的货品规格
 * @param   string     $goods_id          商品id
 * @param   int        $product_id        商品的货品id；默认值为：0，没有货品id
 * @return  bool                          true，重复；false，不重复
 */
function check_goods_attr_exist($goods_attr, $goods_id, $product_id = 0)
{
    $goods_id = intval($goods_id);
    if (strlen($goods_attr) == 0 || empty($goods_id))
    {
        return true;    //重复
    }

    if (empty($product_id))
    {
        $sql = "SELECT product_id FROM " . table('products') ."
                WHERE goods_attr = '$goods_attr'
                AND goods_id = '$goods_id'";
    }
    else
    {
        $sql = "SELECT product_id FROM " . table('products') ."
                WHERE goods_attr = '$goods_attr'
                AND goods_id = '$goods_id'
                AND product_id <> '$product_id'";
    }

    $res = M('products')->query($sql)[0]['product_id'];

    if (empty($res))
    {
        return false;    //不重复
    }
    else
    {
        return true;    //重复
    }
}

/**
 * 商品货号是否重复
 *
 * @param   string     $goods_sn        商品货号；请在传入本参数前对本参数进行SQl脚本过滤
 * @param   int        $goods_id        商品id；默认值为：0，没有商品id
 * @return  bool                        true，重复；false，不重复
 */
function check_goods_sn_exist($goods_sn, $goods_id = 0)
{
    $goods_sn = trim($goods_sn);
    $goods_id = intval($goods_id);
    if (strlen($goods_sn) == 0)
    {
        return true;    //重复
    }
    
    $where['goods_sn'] = $goods_sn;
    
    if (empty($goods_id))
    {
        
    }
    else
    {
        $where['gid'] = array('neq',$goods_id);
    }

    $res = M('Goods')->where($where)->find();

    if (empty($res))
    {
        return false;    //不重复
    }
    else
    {
        return true;    //重复
    }

}

/**
 * 商品的货品货号是否重复
 *
 * @param   string     $product_sn        商品的货品货号；请在传入本参数前对本参数进行SQl脚本过滤
 * @param   int        $product_id        商品的货品id；默认值为：0，没有货品id
 * @return  bool                          true，重复；false，不重复
 */
function check_product_sn_exist($product_sn, $product_id = 0)
{
    $product_sn = trim($product_sn);
    $product_id = intval($product_id);
    if (strlen($product_sn) == 0)
    {
        return true;    //重复
    }
    $where['goods_sn'] = $product_sn;
    $re = M('Goods')->where($where)->find();
    if($re)
    {
        return true;    //重复
    }

    $where1['product_sn'] = $product_sn;

    if (empty($product_id))
    {
        
    }
    else
    {
        $where1['product_id'] = array('neq',$product_id);
    }

    $res = M('products')->where($where1)->find();

    if (empty($res))
    {
        return false;    //不重复
    }
    else
    {
        return true;    //重复
    }
}

/**
 * 修改商品某字段值
 * @param   string  $goods_id   商品编号，可以为多个，用 ',' 隔开
 * @param   string  $field      字段名
 * @param   string  $value      字段值
 * @return  bool
 */
function update_goods($goods_id, $field, $value)
{
    if ($goods_id)
    {
        $sql = "UPDATE " . table('goods') .
                " SET $field = '$value' " .
                "WHERE gid " . db_create_in($goods_id);
        return M('Goods')->query($sql);
    }
    else
    {
        return false;
    }
}

/**
 * 获得商品的属性和规格
 *
 * @access  public
 * @param   integer $goods_id
 * @return  array
 */
function get_goods_properties($goods_id)
{
    /* 对属性进行重新排序和分组 */
    $sql = "SELECT attr_group ".
            "FROM " . table('goods_type') . " AS gt, " . table('goods') . " AS g ".
            "WHERE g.gid='$goods_id' AND gt.cat_id=g.goods_type";
    $grp = M('goods_type')->query($sql)[0]['attr_group'];

    if (!empty($grp))
    {
        $groups = explode("\n", strtr($grp, "\r", ''));
    }

    /* 获得商品的规格 */
    $sql = "SELECT a.attr_show_type,a.attr_id, a.attr_name, a.attr_group, a.is_linked, a.attr_type, ".
                "g.goods_attr_id, g.attr_value, g.attr_price " .
            'FROM ' . table('goods_attr') . ' AS g ' .
            'LEFT JOIN ' . table('attribute') . ' AS a ON a.attr_id = g.attr_id ' .
            "WHERE g.goods_id = '$goods_id' " .
            'ORDER BY /*a.sort_order, g.attr_price, */g.goods_attr_id';//目前只能根据attr_id排序,否则会出现bug
    $res = M('goods_attr')->query($sql);
    
    $arr['pro'] = array();     // 属性
    $arr['spe'] = array();     // 规格
    $arr['lnk'] = array();     // 关联的属性
    
    foreach ($res AS $row)
    {
        $row['attr_value'] = str_replace("\n", '<br />', $row['attr_value']);

        /*if ($row['attr_type'] == 0)
        {
            $group = (isset($groups[$row['attr_group']])) ? $groups[$row['attr_group']] : $GLOBALS['_LANG']['goods_attr'];

            $arr['pro'][$group][$row['attr_id']]['name']  = $row['attr_name'];
            $arr['pro'][$group][$row['attr_id']]['value'] = $row['attr_value'];
        }
        else
        {
            $arr['spe'][$row['attr_id']]['attr_type'] = $row['attr_type'];
            $arr['spe'][$row['attr_id']]['name']     = $row['attr_name'];
            $arr['spe'][$row['attr_id']]['values'][] = array(
                                                        'label'        => $row['attr_value'],
                                                        'price'        => $row['attr_price'],
                                                        'format_price' =>abs($row['attr_price']),
                                                        'id'           => $row['goods_attr_id']);
        }*/
        
        $arr['spe'][$row['attr_id']]['attr_type'] = $row['attr_type'];
        $arr['spe'][$row['attr_id']]['attr_name'] = $row['attr_name'];
        $attr_price = $row['attr_show_type'] == 1 ? $row['attr_price'] : '0.00';
        $arr['spe'][$row['attr_id']]['attr_list'][] = array(
                                                    'attr_value'        => $row['attr_value'],
                                                    'attr_price'        => $attr_price,
                                                    'format_price' => abs($attr_price),
                                                    'goods_attr_id'           => $row['goods_attr_id'],
                                                    'attr_id' => $row['attr_id'],
                                                    );

        if ($row['is_linked'] == 1)
        {
            /* 如果该属性需要关联，先保存下来 */
            $arr['lnk'][$row['attr_id']]['name']  = $row['attr_name'];
            $arr['lnk'][$row['attr_id']]['value'] = $row['attr_value'];
        }
    }

    return $arr;
}

    //单张上传
    function upload_one($path,$file,$size = 3145728){
        import('ORG.Net.UploadFile');
		$upload = new UploadFile();// 实例化上传类
		$upload->maxSize  = $size;// 设置附件上传大小
		$upload->allowExts = array('jpg', 'gif', 'png', 'jpeg');// 设置附件上传类型
		$upload->savePath =  $path;// 设置附件上传目录
		return $upload->uploadOne($file);
    }
	//获取图片完整路径
    function getImgUrl($path,$img,$default = 'default_photo.jpg'){
        $site_url = C('site_url').'/';//网站地址
        $filename = $path.$img;//文件路径
        if($img && file_exists($filename)){
            //先img是真并且文件存在,那么直接返回
            return $site_url.$filename;
        }else{
            //否则,看看是否有默认图片
            $filename = $path.$default;
            if(file_exists($filename)){
                //默认图片存在,返回默认图片
                return $site_url.$filename;
            }else{
                //否则返回headimg下面的默认图片
                return $site_url.C('GALLERY_IMG_URL').$default;
            }
        }
    }
    //数字替换成对应的文字
    function replace_arr($type,$num){
        return C('replace_arr')[$type][$num];
    }
?>