set charset utf8;
CREATE TABLE `gg_area` (
  `area_id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `shipping_fee` decimal(10,2) NOT NULL,
  `min_amount` decimal(10,2) NOT NULL,
  `max_amount` decimal(10,2) NOT NULL COMMENT '免运费',
  `is_open` int(11) NOT NULL,
  `a_order` int(11) NOT NULL,
  PRIMARY KEY (`area_id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
insert into `gg_area`(`area_id`,`name`,`shipping_fee`,`min_amount`,`max_amount`,`is_open`,`a_order`) values('1','科技大学','0.00','0.00','0.00','0','0');
insert into `gg_area`(`area_id`,`name`,`shipping_fee`,`min_amount`,`max_amount`,`is_open`,`a_order`) values('2','石油大学','6.00','20.00','30.00','0','0');
insert into `gg_area`(`area_id`,`name`,`shipping_fee`,`min_amount`,`max_amount`,`is_open`,`a_order`) values('3','金榜嘉园','2.00','15.00','20.00','0','0');
insert into `gg_area`(`area_id`,`name`,`shipping_fee`,`min_amount`,`max_amount`,`is_open`,`a_order`) values('4','山海花园','15.00','15.00','20.00','0','0');
CREATE TABLE `gg_attribute` (
  `attr_id` int(11) NOT NULL AUTO_INCREMENT,
  `cid` int(11) NOT NULL,
  `attr_name` varchar(64) CHARACTER SET utf8 NOT NULL,
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`attr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1;
insert into `gg_attribute`(`attr_id`,`cid`,`attr_name`,`sort_order`) values('1','24','份量','0');
CREATE TABLE `gg_cart` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_sn` varchar(64) CHARACTER SET utf8 NOT NULL,
  `gid` int(11) NOT NULL,
  `goods_attr` varchar(64) CHARACTER SET utf8 NOT NULL,
  `num` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
CREATE TABLE `gg_cate` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `parentid` int(11) NOT NULL COMMENT '上级ID',
  `is_recommend` int(11) NOT NULL COMMENT '是否推荐',
  `c_order` int(11) NOT NULL,
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('24','瓜果','29','1','1');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('21','饼干糕点','27','1','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('22','饮料饮品','28','1','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('23','生鲜食品','29','1','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('34','进口牛奶乳品','26','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('26','进口食品','0','0','10');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('27','零食保健','0','0','9');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('28','酒水饮料','0','0','8');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('29','粮油生鲜','0','0','7');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('30','纸品清洁','0','0','6');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('31','家纺','0','0','5');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('32','生活日用','0','0','4');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('33','厨房用具','0','0','3');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('35','进口酒水','26','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('36','进口休闲食品','26','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('37','进口生鲜','26','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('38','进口方便速食','26','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('39','休闲食品','27','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('40','蜜饯/果脯','27','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('41','营养保健','27','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('42','糖果','27','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('43','传统滋补','27','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('44','酒水','28','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('45','牛奶乳品','28','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('46','茗茶','28','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('47','冲调饮品','28','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('48','粮油米面','29','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('49','干货','29','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('50','方便速食','29','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('51','厨房调料','29','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('52','纸品湿巾','30','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('53','衣物洗护','30','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('54','清洁工具','30','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('55','清洁用品','30','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('56','床品套件','31','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('57','毛巾/浴巾/浴袍','31','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('58','收纳用品','32','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('59','晴雨用具','32','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('60','净化除味','32','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('61','日常防护','32','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('62','厨具锅具','33','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('63','厨房刀具','33','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('64','厨房小工具','33','0','0');
insert into `gg_cate`(`cid`,`name`,`parentid`,`is_recommend`,`c_order`) values('65','保鲜盒','33','0','0');
CREATE TABLE `gg_click` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `yesterday` int(11) NOT NULL,
  `today` int(11) NOT NULL,
  `allclick` int(11) NOT NULL,
  `time` date NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8;
insert into `gg_click`(`id`,`yesterday`,`today`,`allclick`,`time`) values('1','1','3','52878','2016-01-25');
CREATE TABLE `gg_comment` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `order_id` varchar(64) NOT NULL,
  `uid` int(11) NOT NULL,
  `good_id` int(11) NOT NULL,
  `good_star` int(11) NOT NULL,
  `serve_star` varchar(64) NOT NULL,
  `content` varchar(64) NOT NULL,
  `time` datetime NOT NULL,
  `is_show` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `id` (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=261 DEFAULT CHARSET=utf8;
CREATE TABLE `gg_good` (
  `gid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `img` varchar(64) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `good_number` int(11) NOT NULL,
  `infor` mediumtext NOT NULL,
  `cid` int(11) NOT NULL,
  `g_order` int(11) NOT NULL,
  `state` int(11) NOT NULL DEFAULT '1',
  `base_num` int(11) NOT NULL,
  `give_integral` int(11) NOT NULL,
  `use_integral` int(11) NOT NULL COMMENT '可用积分数',
  `is_recommend` tinyint(1) NOT NULL,
  `is_new` int(11) NOT NULL,
  `is_promote` int(11) NOT NULL,
  `promote_price` decimal(10,2) NOT NULL,
  `promote_num` int(11) NOT NULL COMMENT '促销限购数量',
  `start_time` datetime NOT NULL,
  `end_time` datetime NOT NULL,
  `unit` varchar(64) NOT NULL,
  PRIMARY KEY (`gid`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8;
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('7','百草味 蔓越莓曲奇100gx2袋休闲零食品 黄油饼干 糕点点心','5590bb2dc07bd.jpg','0.01','0','','21','0','1','9','5','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('8','【三只松鼠_大聚惠特供】超值爆款组合1303g','5590bc20df722.jpg','0.01','9999','','21','0','1','11','10','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('9','达利园 蛋糕蛋香味 600g','5590bc603f824.jpg','0.01','0','','21','0','1','2','0','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('10','可口可乐 日本进口零食品 COCACOLA罐装可乐350ml 碳酸饮料','5590bcaf91687.jpg','0.01','0','','22','0','1','1','0','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('11','可口可乐 碳酸饮料 汽水 2.5L','5590bce7bc39f.jpg','0.01','0','','22','0','1','0','0','0','1','1','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('12','北冰洋 橙汁汽水 330mlx12','5590bd2e31edb.jpg','0.01','0','','22','0','1','0','0','0','1','1','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('13','锐峰 安岳一级柠檬果1个约90-120g柠檬之都安岳特产 现摘新鲜柠檬果1个 8个包邮','5590bdbc4f366.jpg','0.01','0','','24','0','1','1','0','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('14','【优果网】新西兰佳沛猕猴桃金果 12个装 中果 sungold黄肉黄心进口奇异果','5590bdfd44b35.jpg','0.01','0','','24','0','1','9','0','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('15','伯乐庄园 山东烟台栖霞苹果水果新鲜红富士甜脆6斤装','5590be3a4ea58.jpg','1.00','97','','24','0','1','73','5','10','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('16','顺意生 中国有机绿色食品专营 新鲜蔬菜 基地现采 绿色大白菜4斤起拍','5590be94e7b22.jpg','0.01','0','','23','0','1','0','0','0','1','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('17','绿色无公害生态精品新鲜蔬菜小白菜价鲜嫩 无农药 六一儿童健康食品','5590becf75d1e.jpg','0.01','0','','23','0','1','0','0','0','1','1','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('18','中国有机绿色食品专营 新鲜蔬菜 白菜花500g','5590bf06dcd83.jpg','0.01','0','','23','0','1','0','0','0','1','1','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','5597b9235ebab.jpg','10.00','9','','24','0','1','131','10','0','1','1','0','2.00','2','2015-10-28 16:40:00','2015-11-01 01:25:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('25','楼兰蜜语 薄皮核桃500g','5597b99151d42.jpg','50.00','0','','21','0','1','66','20','0','1','1','0','23.00','0','2015-07-23 14:15:00','2015-07-23 17:05:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('26','蒙牛 利乐包 纯牛奶 1L 原味','5597ba4ba8a4e.jpg','2.50','2','','22','0','1','265','10','0','1','1','0','1.00','0','2015-07-23 14:00:00','2015-07-23 14:05:00','');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','5597bb553becf.jpg','10.00','9999','','23','0','1','25','10','10','1','1','0','1.00','0','2015-10-27 12:00:00','2015-10-30 14:20:00','个');
insert into `gg_good`(`gid`,`name`,`img`,`price`,`good_number`,`infor`,`cid`,`g_order`,`state`,`base_num`,`give_integral`,`use_integral`,`is_recommend`,`is_new`,`is_promote`,`promote_price`,`promote_num`,`start_time`,`end_time`,`unit`) values('28','2222','5645c6a8b1d16.doc','0.00','0','','0','0','1','0','0','0','2','0','0','0.00','0','0000-00-00 00:00:00','0000-00-00 00:00:00','');
CREATE TABLE `gg_goods_attr` (
  `goods_attr_id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_id` int(11) NOT NULL,
  `attr_id` int(11) NOT NULL,
  `attr_value` varchar(64) CHARACTER SET utf8 NOT NULL,
  `attr_price` decimal(10,2) NOT NULL,
  `attr_num` int(11) NOT NULL COMMENT '库存',
  `sort_order` int(11) NOT NULL,
  PRIMARY KEY (`goods_attr_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1;
insert into `gg_goods_attr`(`goods_attr_id`,`goods_id`,`attr_id`,`attr_value`,`attr_price`,`attr_num`,`sort_order`) values('1','24','1','1斤','1.00','9','0');
insert into `gg_goods_attr`(`goods_attr_id`,`goods_id`,`attr_id`,`attr_value`,`attr_price`,`attr_num`,`sort_order`) values('2','24','1','2斤','2.00','13','0');
insert into `gg_goods_attr`(`goods_attr_id`,`goods_id`,`attr_id`,`attr_value`,`attr_price`,`attr_num`,`sort_order`) values('3','24','1','3斤','3.00','14','0');
CREATE TABLE `gg_message` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(100) NOT NULL,
  `content` mediumtext NOT NULL,
  `time` int(11) NOT NULL,
  `is_activity` int(11) NOT NULL,
  `integral_num` int(11) NOT NULL,
  `end_time` date NOT NULL,
  `cid` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
insert into `gg_message`(`id`,`title`,`content`,`time`,`is_activity`,`integral_num`,`end_time`,`cid`) values('5','网站订购流程','<p>网站订购流程</p>','1435033006','0','0','0000-00-00','2');
insert into `gg_message`(`id`,`title`,`content`,`time`,`is_activity`,`integral_num`,`end_time`,`cid`) values('6','会员政策','<p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" strong=\\\"\\\">产品购买：</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">2、由于生鲜产品的特殊性，会有一些重量误差。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">&nbsp;</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" strong=\\\"\\\">客户签收注意事项：</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">2、鉴于生鲜商品的特殊性，可能会导致实际重量有所偏差，我们尽可能让偏差在正常范围内，请您谅解。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">4、由于生鲜类商品属于特殊的商品，在生鲜类产品的称量过程及运送过程中可能会出现一些问题，并由此导致实际重量和您所称重量会有所偏差，这属正 常情况，请您谅解。但偏差严重超出合理范围的时候，您可联系客服并提供您的意见。注：由于某些生鲜类产品不适合精细称量，可能在称量过程中与您的订单重量 会有少许出入，我们尽量将其控制在±5％之内。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\"><strong style=\\\"\\\\\\\" p=\\\"\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\">1.蔬菜属于不可二次利用商品，为了保证蔬菜的新鲜度，青年菜君不受理非质量问题的退货。（非质量问题原因包括：蔬菜品种喜好问题、无人取菜而要求退货等。）</strong></p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">3、如因客户个人原因造成质量或其他严重问题的商品，概不受理退货。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\"><strong style=\\\"\\\\\\\" p=\\\"\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\">1、本商品供应商为才俊青年（北京）科技有限公司，所有蔬菜均严格执行GB/T5009.199-2003中的标准，对每一批回场原料按此标准进行检验，对检验不合格的原料不予以使用。</strong></p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">3、供应商对每批回场的蔬菜原料均进行留样处理，留样时间为72小时；确保产品的可追溯性。另外在发货前有专门部门进行严格质检，确保无任何质量问题和数量问题，给予发货。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\"><strong style=\\\"\\\\\\\" p=\\\"\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\">1、为确保商品新鲜及准确送达，青年菜君自建冷链物流系统，暂时不提供送货上门的服务，请您在下单时选择您可接受范围内的自提点，并且在您选定的时间范围内进行自提，逾期不候。</strong></p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">3、如遇无人签收情况，您将接获电话通知，请客户自行到自提进行自提。自预定取菜之日起两天内，如您仍未取菜，则视为自动放弃取菜。过期菜品由青年菜君进行回收，逾期未自提的则视为用户已签收该订单，不再另行补配。</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\"><strong style=\\\"\\\\\\\" p=\\\"\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\">1、青年菜君提供预先付费的“网上支付”的支付方式。目前仅支持支付宝支付，更多支付方式还在开发中。</strong></p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">&nbsp;</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" strong=\\\"\\\">投诉建议：</p><p style=\\\"\\\\\\\" margin-top:=\\\"\\\" margin-bottom:=\\\"\\\" padding:=\\\"\\\" color:=\\\"\\\" font-family:=\\\"\\\" microsoft=\\\"\\\" font-size:=\\\"\\\" line-height:=\\\"\\\" white-space:=\\\"\\\" background-color:=\\\"\\\" p=\\\"\\\">&lt;strong style=&quot;\\\\&quot;box-sizing:&quot;&gt;服务热线： 400-882-1551</p><p><br/></p>','1435033033','0','0','0000-00-00','2');
insert into `gg_message`(`id`,`title`,`content`,`time`,`is_activity`,`integral_num`,`end_time`,`cid`) values('7','标题','<p>内容</p>','1436256400','1','23','2015-07-09','1');
insert into `gg_message`(`id`,`title`,`content`,`time`,`is_activity`,`integral_num`,`end_time`,`cid`) values('9','活动测试','<p>这是活动描述</p>','1436263061','1','12','2015-07-10','1');
CREATE TABLE `gg_message_cate` (
  `cid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `c_order` int(11) NOT NULL,
  PRIMARY KEY (`cid`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8;
insert into `gg_message_cate`(`cid`,`name`,`c_order`) values('1','活动','5');
insert into `gg_message_cate`(`cid`,`name`,`c_order`) values('2','操作指南','4');
insert into `gg_message_cate`(`cid`,`name`,`c_order`) values('3','支付说明','3');
insert into `gg_message_cate`(`cid`,`name`,`c_order`) values('4','配送取货','2');
insert into `gg_message_cate`(`cid`,`name`,`c_order`) values('5','关于我们','1');
CREATE TABLE `gg_nav` (
  `id` mediumint(8) NOT NULL AUTO_INCREMENT COMMENT '导航配置自增id',
  `name` varchar(255) NOT NULL COMMENT '导航显示标题',
  `ifshow` tinyint(1) NOT NULL COMMENT '是否显示',
  `vieworder` tinyint(1) NOT NULL COMMENT '页面显示顺序，数字越大越靠后',
  `opennew` tinyint(1) NOT NULL COMMENT '导航链接页面是否在新窗口打开，1，是；其他，否',
  `url` varchar(255) NOT NULL COMMENT '链接的页面地址',
  `type` int(1) NOT NULL COMMENT '处于导航栏的位置，3为顶部；2为中间；1为底部',
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `ifshow` (`ifshow`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC COMMENT='上中下3个导航栏的显示配置';
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('5','店内资讯','1','5','0','index.php?m=Index&a=mlist','2');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('6','门店地图','1','4','0','index.php?m=Index&a=map','2');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('7','转账窗口','1','3','0','index.php?m=Index&a=pay','2');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('11','选购中心','1','0','1','index.php','3');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('8','联系我们','1','5','0','index.php?m=Index&a=message&id=6','1');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('9','关于我们','1','4','0','index.php?m=Index&a=message&id=6','1');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('10','平台招商','1','3','0','index.php?m=Index&a=message&id=6','1');
insert into `gg_nav`(`id`,`name`,`ifshow`,`vieworder`,`opennew`,`url`,`type`) values('14','买家晒单','1','0','0','index.php?m=Index&a=comment_list','2');
CREATE TABLE `gg_order` (
  `oid` int(11) NOT NULL AUTO_INCREMENT,
  `order_no` varchar(64) NOT NULL,
  `name` varchar(64) NOT NULL,
  `tel` varchar(64) NOT NULL,
  `address` varchar(100) NOT NULL,
  `area_id` int(11) NOT NULL COMMENT '地区ID',
  `remarks` varchar(255) NOT NULL,
  `time` int(11) NOT NULL,
  `best_time` varchar(64) NOT NULL COMMENT '最佳配送时间',
  `totalAmount` decimal(10,2) NOT NULL,
  `uid` int(11) NOT NULL,
  `state` int(11) NOT NULL COMMENT '0未确认 1确认 2配送中 3已收货',
  `pay_state` int(11) NOT NULL COMMENT '0未付款  1付款',
  `pay_method` int(11) NOT NULL COMMENT ' 0货到付款  1线上支付   2支付宝   3微信支付',
  `give_integral` int(11) NOT NULL,
  `use_inter` int(11) NOT NULL,
  `discount` decimal(10,2) NOT NULL COMMENT '积分抵现金的优惠折扣',
  `pay_cash` decimal(10,2) NOT NULL,
  `shipping_fee` decimal(10,2) NOT NULL COMMENT '运费',
  `change_log` mediumtext NOT NULL COMMENT '订单日志',
  PRIMARY KEY (`oid`),
  UNIQUE KEY `order_no` (`order_no`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=utf8;
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('1','1441251296152','陈晨','18765927429','山海花园2-1232','0','','1441251296','','0.02','1','0','0','0','0','0','0.00','0.02','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('2','201510260125241','陈晨','18765927429','山海花园2-1232','1','','1445837124','','2.00','1','0','0','1','0','20','0.00','1.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('3','201510260157001','陈晨','18765927429','山海花园2-1232','4','','1445839020','','9.04','1','0','0','1','0','0','0.00','24.04','15.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('4','201510260256091','陈晨','18765927429','山海花园2-1232','4','','1445842569','','6.03','1','0','0','0','30','0','0.00','21.03','15.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('6','201510260418151','陈晨','18765927429','山海花园2-1232','1','','1445847495','','3.01','1','0','0','1','70','20','1.00','2.01','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('7','201510280443481','陈晨','18765927429','山海花园2-1232','1','','1446021828','','4.00','1','0','0','1','40','40','2.00','2.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('8','201510280444301','陈晨','18765927429','山海花园2-1232','1','','1446021870','','2.00','1','0','0','1','20','20','1.00','1.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('9','201510280452421','陈晨','18765927429','山海花园2-1232','1','','1446022363','','1.00','1','0','0','1','10','10','0.00','1.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('10','201510280453101','陈晨','18765927429','山海花园2-1232','1','','1446022390','','1.00','1','0','0','1','10','10','0.50','0.50','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('11','201510310528211','陈晨','18765927429','山海花园2-1232','1','','1446283701','','6.00','1','0','0','1','20','0','0.00','6.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('12','201510310537081','陈晨','18765927429','山海花园2-1232','1','','1446284228','','1.00','1','0','0','1','5','10','0.00','1.00','0.00','');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('13','201510310537311','陈晨','18765927429','山海花园2-1232','1','','1446284251','','1.00','1','2','1','2','5','10','0.50','0.50','0.00','2016-01-25 11:08:38操作：121212');
insert into `gg_order`(`oid`,`order_no`,`name`,`tel`,`address`,`area_id`,`remarks`,`time`,`best_time`,`totalAmount`,`uid`,`state`,`pay_state`,`pay_method`,`give_integral`,`use_inter`,`discount`,`pay_cash`,`shipping_fee`,`change_log`) values('14','201510310540311','陈晨','18765927429','山海花园2-1232','1','','1446284431','','1.00','1','2','1','1','5','10','0.50','0.50','0.00','3232111|2016-01-25 11:07:39操作：3232111|2016-01-25 11:08:21操作：11111');
CREATE TABLE `gg_ordergood` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `goods_sn` varchar(64) NOT NULL COMMENT '商品货号',
  `gid` int(11) NOT NULL,
  `name` varchar(64) NOT NULL,
  `price` decimal(10,2) NOT NULL,
  `num` int(11) NOT NULL,
  `goods_attr` varchar(64) NOT NULL COMMENT '商品属性值',
  `order_no` varchar(64) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=66 DEFAULT CHARSET=utf8;
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('1','','8','【三只松鼠_大聚惠特供】超值爆款组合1303g','0.01','2','','1441251296152');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('34','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','2','','201510260125241');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('35','24_1','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','1.01','1','1斤 ','201510260157001');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('36','24_2','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','2.01','1','2斤 ','201510260157001');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('37','24_3','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','3.01','2','3斤 ','201510260157001');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('44','24_1','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','1.01','1','1斤 ','201510260256091');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('45','24_2','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','2.01','1','2斤 ','201510260256091');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('46','24_3','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','3.01','1','3斤 ','201510260256091');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('55','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','4','','201510280443481');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('53','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','2','','201510260418151');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('52','24_1','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','1.01','1','1斤 ','201510260418151');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('56','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','2','','201510280444301');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('57','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','1','','201510280452421');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('58','27','27','楚礼 山林蛋30枚 农家散养绿壳土鸡蛋 礼盒装 新鲜有机营养包邮','1.00','1','','201510280453101');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('61','24_1','24','无锡无锡阳山水蜜桃8粒装 单果4-5两 部分地区无法送达 具体参照详情页','3.00','2','1斤 ','201510310528211');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('63','15','15','伯乐庄园 山东烟台栖霞苹果水果新鲜红富士甜脆6斤装','1.00','1','','201510310537081');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('64','15','15','伯乐庄园 山东烟台栖霞苹果水果新鲜红富士甜脆6斤装','1.00','1','','201510310537311');
insert into `gg_ordergood`(`id`,`goods_sn`,`gid`,`name`,`price`,`num`,`goods_attr`,`order_no`) values('65','15','15','伯乐庄园 山东烟台栖霞苹果水果新鲜红富士甜脆6斤装','1.00','1','','201510310540311');
CREATE TABLE `gg_pay` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `account` varchar(64) NOT NULL,
  `qr_code` varchar(64) NOT NULL,
  `infor` varchar(64) NOT NULL,
  `is_used` int(11) NOT NULL COMMENT '0  不使用  1使用',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
insert into `gg_pay`(`id`,`name`,`account`,`qr_code`,`infor`,`is_used`) values('1','微信支付','1107106767@qq.com','55921db38a8ce.png','使用微信扫一扫，给我转账','1');
insert into `gg_pay`(`id`,`name`,`account`,`qr_code`,`infor`,`is_used`) values('2','支付宝支付','1107106767@qq.com','55921daa4b56d.png','使用支付宝钱包给我转账','1');
CREATE TABLE `gg_recharge` (
  `id` int(11) NOT NULL,
  `value` decimal(10,2) NOT NULL COMMENT '充值金额',
  `reward` decimal(10,2) NOT NULL COMMENT '奖励金额'
) ENGINE=InnoDB DEFAULT CHARSET=latin1;
insert into `gg_recharge`(`id`,`value`,`reward`) values('0','100.00','10.00');
insert into `gg_recharge`(`id`,`value`,`reward`) values('0','300.00','30.00');
CREATE TABLE `gg_slide` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `imgurl` varchar(64) NOT NULL,
  `url` varchar(255) NOT NULL,
  `s_order` int(11) NOT NULL,
  `is_mobile` int(11) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=23 DEFAULT CHARSET=utf8;
insert into `gg_slide`(`id`,`title`,`imgurl`,`url`,`s_order`,`is_mobile`) values('21','活动2','5620aba728715.jpg','http://www.shopnr213.com/','2','0');
insert into `gg_slide`(`id`,`title`,`imgurl`,`url`,`s_order`,`is_mobile`) values('20','活动1','5620ab9a43d64.jpg','http://www.shopnr213.com/','3','1');
insert into `gg_slide`(`id`,`title`,`imgurl`,`url`,`s_order`,`is_mobile`) values('22','活动3','5620ad5f678ca.jpg','http://www.shopnr213.com/','1','0');
CREATE TABLE `gg_sms` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `title` varchar(64) NOT NULL,
  `content` varchar(64) NOT NULL,
  `time` datetime NOT NULL,
  `state` tinyint(1) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8;
CREATE TABLE `gg_user` (
  `uid` int(11) NOT NULL AUTO_INCREMENT,
  `name` varchar(64) NOT NULL,
  `tel` varchar(64) NOT NULL,
  `password` varchar(100) NOT NULL,
  `area_id` int(11) NOT NULL,
  `address` varchar(100) NOT NULL,
  `regtime` int(11) NOT NULL,
  `is_admin` int(11) NOT NULL,
  `integral_num` int(11) NOT NULL,
  `ucid` int(11) NOT NULL COMMENT 'UCID',
  `user_money` decimal(10,2) NOT NULL COMMENT '会员余额',
  `allintegral` int(11) NOT NULL COMMENT '总积分',
  `buy_num` int(11) NOT NULL COMMENT '购买次数，也就是下单数量',
  PRIMARY KEY (`uid`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8;
insert into `gg_user`(`uid`,`name`,`tel`,`password`,`area_id`,`address`,`regtime`,`is_admin`,`integral_num`,`ucid`,`user_money`,`allintegral`,`buy_num`) values('1','陈晨','18765927429','af1136061bf851f6d94d4da7ea2946c8','1','山海花园2-1232','1441250778','0','99949','0','0.00','0','0');
insert into `gg_user`(`uid`,`name`,`tel`,`password`,`area_id`,`address`,`regtime`,`is_admin`,`integral_num`,`ucid`,`user_money`,`allintegral`,`buy_num`) values('2','张三','18765927429','','0','山东科技大学','1453703243','0','12','0','10.00','0','0');
CREATE TABLE `gg_user_integral` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `acid` int(11) NOT NULL,
  `uid` int(11) NOT NULL,
  `infor` varchar(64) NOT NULL,
  `integral_num` int(11) NOT NULL,
  `time` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8;
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('1','0','1','购物消费','-20','2015-10-26 13:25:24');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('2','0','1','购物消费','-20','2015-10-26 16:18:15');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('3','0','1','购物消费','-40','2015-10-28 16:43:49');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('4','0','1','购物消费','-20','2015-10-28 16:44:30');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('5','0','1','购物消费','-10','2015-10-28 16:52:43');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('6','0','1','购物消费','-10','2015-10-28 16:53:10');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('7','0','1','购物消费','-10','2015-10-31 17:37:08');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('8','0','1','购物消费','-10','2015-10-31 17:37:31');
insert into `gg_user_integral`(`id`,`acid`,`uid`,`infor`,`integral_num`,`time`) values('9','0','1','购物消费','-10','2015-10-31 17:40:31');
CREATE TABLE `gg_user_recharge` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `uid` int(11) NOT NULL,
  `acid` int(11) NOT NULL COMMENT 'acid活动ID',
  `infor` varchar(64) NOT NULL,
  `recharge_num` double(10,2) NOT NULL COMMENT '用户变动金额',
  `give_num` decimal(10,2) NOT NULL COMMENT '赠送金额',
  `integral_num` int(11) NOT NULL COMMENT '积分数量',
  `type` int(11) NOT NULL COMMENT '0表示充值 1表示消费 2表示管理员修改 3表示微信关注奖励  4、表示下级购物奖励   5活动奖励    6、订单评论奖励',
  `time` int(11) NOT NULL,
  `out_trade_no` varchar(64) NOT NULL COMMENT '微信订单号  如果为空，表示管理员操作',
  `junior` int(11) NOT NULL COMMENT '下级等级junior   默认是0，表示不存在分销  1  2  3  ',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=5 DEFAULT CHARSET=utf8;
insert into `gg_user_recharge`(`id`,`uid`,`acid`,`infor`,`recharge_num`,`give_num`,`integral_num`,`type`,`time`,`out_trade_no`,`junior`) values('1','2','0','测试','0.00','0.00','12','2','1453705110','','0');
insert into `gg_user_recharge`(`id`,`uid`,`acid`,`infor`,`recharge_num`,`give_num`,`integral_num`,`type`,`time`,`out_trade_no`,`junior`) values('2','2','0','测试','0.00','0.00','12','2','1453705136','','0');
insert into `gg_user_recharge`(`id`,`uid`,`acid`,`infor`,`recharge_num`,`give_num`,`integral_num`,`type`,`time`,`out_trade_no`,`junior`) values('3','2','0','这是测试','10.00','0.00','0','2','1453705164','','0');
insert into `gg_user_recharge`(`id`,`uid`,`acid`,`infor`,`recharge_num`,`give_num`,`integral_num`,`type`,`time`,`out_trade_no`,`junior`) values('4','2','0','测试的','10.00','0.00','0','2','1453705235','','0');
