 <?php
//+----------------------------------------------------------------------
//|JuhePHP[NOZUONODIE]
//+----------------------------------------------------------------------
//|Copyright(c)2010-2015http://juhe.cnAllrightsreserved.
//+----------------------------------------------------------------------
//|Author:Juhedata<info@juhe.cn-->
//+----------------------------------------------------------------------
//----------------------------------
//聚合数据-快递查询API调用示例代码
//----------------------------------
class exp {
    private $appkey = false; //申请的快递查询APPKEY
    private $queryUrl = 'http://v.juhe.cn/exp/index';
    private $comUrl = 'http://v.juhe.cn/exp/com';
    public function __construct($appkey) {
        $this->appkey = $appkey;
    }
    /**
     *返回支持的快递公司公司列表
     *@returnarray
     */
    public function getComs() {
        $params = 'key=' . $this->appkey;
        $content = $this->juhecurl($this->comUrl, $params);
        return $this->_returnArray($content);
    }
    public function query($com, $no) {
        $params = array('key' => $this->appkey, 'com' => $com, 'no' => $no);
        $content = $this->juhecurl($this->queryUrl, $params, 1);
        return $this->_returnArray($content);
    }
    /**
     *将JSON内容转为数据，并返回
     *@paramstring$content[内容]
     *@returnarray
     */
    public function _returnArray($content) {
        return json_decode($content, true);
    }
    /**
     *请求接口返回内容
     *@paramstring$url[请求的URL地址]
     *@paramstring$params[请求的参数]
     *@paramint$ipost[是否采用POST形式]
     *@returnstring
     */
    public function juhecurl($url, $params = false, $ispost = 0) {
        $httpInfo = array();
        $ch = curl_init();
        curl_setopt($ch, CURLOPT_HTTP_VERSION, CURL_HTTP_VERSION_1_1);
        curl_setopt($ch, CURLOPT_USERAGENT, 'JuheData');
        curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, 60);
        curl_setopt($ch, CURLOPT_TIMEOUT, 60);
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, true);
        if ($ispost) {
            curl_setopt($ch, CURLOPT_POST, true);
            curl_setopt($ch, CURLOPT_POSTFIELDS, $params);
            curl_setopt($ch, CURLOPT_URL, $url);
        } else {
            if ($params) {
                curl_setopt($ch, CURLOPT_URL, $url . '?' . $params);
            } else {
                curl_setopt($ch, CURLOPT_URL, $url);
            }
        }
        $response = curl_exec($ch);
        if ($response === FALSE) {
            //echo"cURLError:".curl_error($ch);
            return false;
        }
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        $httpInfo = array_merge($httpInfo, curl_getinfo($ch));
        curl_close($ch);
        return $response;
    }
}
