﻿<%@ WebHandler Language="C#" Class="merge" %>

using System;
using System.Web;
using System.Web.Script.Serialization;
using System.Drawing;
using System.Drawing.Imaging;
using System.Net;

public class merge : IHttpHandler
{

    public void ProcessRequest(HttpContext context)
    {
        try
        {
            var js = new JavaScriptSerializer();
            var json = context.Request["data"];

            var log = log4net.LogManager.GetLogger(System.Reflection.MethodBase.GetCurrentMethod().DeclaringType);
            log.Debug(json);

            var data = js.Deserialize<ImageModel>(json);
            if (data != null)
            {
                using (var bitmp = new Bitmap(data.width, data.height))
                using (var g = Graphics.FromImage(bitmp))
                {
                    g.Clear(Color.White);
                    foreach (var item in data.Images)
                    {
                        switch (item.type)
                        {
                            case 0:
                                if (!System.IO.File.Exists(item.content))
                                {
                                    throw new Exception("指定文件" + item.content + "不存在");
                                }
                                using (var image = Image.FromFile(item.content))
                                {
                                    g.DrawImage(image, new Rectangle(item.x, item.y, item.width, item.height), new Rectangle(0, 0, image.Width, image.Height), GraphicsUnit.Pixel);
                                }
                                break;
                            case 1:
                                try
                                {
                                    using (var http = new WebClient())
                                    {
                                        http.Proxy = null;
                                        using (var stream = http.OpenRead(item.content))
                                        {
                                            using (var image = Image.FromStream(stream))
                                            {
                                                g.DrawImage(image, new Rectangle(item.x, item.y, item.width, item.height), new Rectangle(0, 0, image.Width, image.Height), GraphicsUnit.Pixel);
                                            }
                                        }
                                    }
                                }
                                catch
                                {
                                    throw new Exception("获取远程图片失败");
                                }
                                break;
                            case 2:
                                try
                                {
                                    g.DrawString(
                                        item.content,
                                        new Font("微软雅黑", item.fontsize, GraphicsUnit.Pixel),
                                        new SolidBrush(Color.FromArgb(
                                            int.Parse(item.fontcolor.Substring(0, 2), System.Globalization.NumberStyles.AllowHexSpecifier),
                                            int.Parse(item.fontcolor.Substring(2, 2), System.Globalization.NumberStyles.AllowHexSpecifier),
                                            int.Parse(item.fontcolor.Substring(4, 2), System.Globalization.NumberStyles.AllowHexSpecifier))),
                                        item.x,
                                        item.y);
                                }
                                catch
                                {
                                    throw new Exception("设置文本信息错误");
                                }
                                break;
                        }
                    }
                    //bitmp.Save(context.Response.OutputStream, ImageFormat.Png);
                    //context.Response.ContentType = "image/png";

                    //var downloadfilename = data.name;
                    //if (context.Request.UserAgent.ToLower().IndexOf("msie") > -1)
                    //{
                    //    downloadfilename = HttpUtility.UrlPathEncode(downloadfilename);
                    //}
                    //if (context.Request.UserAgent.ToLower().IndexOf("firefox") > -1)
                    //{
                    //    context.Response.AddHeader("Content-Disposition", "attachment;filename=\"" + downloadfilename + "\"");
                    //}
                    //else
                    //{
                    //    context.Response.AddHeader("Content-Disposition", "attachment;filename=" + downloadfilename);
                    //}

                    bitmp.Save(data.name, ImageFormat.Png);
                    context.Response.Write("true");
                }
            }
            else
            {
                context.Response.Write(json);
            }
        }
        catch (Exception ex)
        {
            context.Response.Write(ex.Message);
        }
    }

    public bool IsReusable { get { return false; } }

    public class ImageModel
    {
        public string name { get; set; }
        public int width { get; set; }
        public int height { get; set; }
        public ImageItemModel[] Images { get; set; }
    }

    public class ImageItemModel
    {
        public int width { get; set; }
        public int height { get; set; }
        public string content { get; set; }
        public int type { get; set; }
        public int x { get; set; }
        public int y { get; set; }
        public int fontsize { get; set; }
        public string fontcolor { get; set; }
    }
}