﻿<%
' 网钛文章管理系统(OTCMS)新浪微博登录API接口参考于: 一曲小诗（www.hcbus.com）的ASP版QQ登陆接口
Class API_weiboLogin
	Private API_weibo_ID,API_weibo_KEY,API_weibo_URL

	' 设置APP ID
	Public Function SetApiId(str)
		API_weibo_ID = str
	End Function

	' 设置APP KEY
	Public Function SetApiKey(str)
		API_weibo_KEY = str
	End Function

	' 设置返回路径
	Public Function SetApiUrl(str)
		API_weibo_URL = str
	End Function

	'生成数据数
	Public Function MakeRandNum()
		Randomize
		Dim width : width = 6 '随机数长度,默认6位
		width = 10 ^ (width - 1)
		MakeRandNum = Int((width*10 - width) * Rnd() + width)
	End Function
	
	'获取当前时间戳
	Public Function Timestamp()
		Timestamp = DateDiff("s", "1970-1-1 00:00:00", Now()) - 3600 * 8
	End Function
	
	'url编码，只替换默认的字符串
	Public Function UrlEncode(ByVal urlstr)
		urlstr = Replace(urlstr, "+", "%2B")
		urlstr = Replace(urlstr, " ", "+")
		urlstr = Replace(urlstr, "=", "%3D")
		urlstr = Replace(urlstr, "&", "%26")
		urlstr = Replace(urlstr, ":", "%3A")
		urlstr = Replace(urlstr, "/", "%2F")
		UrlEncode = urlstr
	End Function
	
	'生成签名
	Public Function MakeSign(method, url, params, secret)
		MakeSign = UrlEncode(OTCMS_b64_hmac_sha1(method & "&" & UrlEncode(url) & "&" & UrlEncode(params), API_weibo_KEY & "&" & secret))
	End Function
	
	
	'请求url,获取请求内容
	Public Function RequestUrl(url)
		Set XmlObj = Server.CreateObject("Microsoft.XMLHTTP")
		XmlObj.open "GET", url, false
		XmlObj.send
		RequestUrl = XmlObj.responseText
		Set XmlObj = nothing
	End Function
	
	'获取临时token,返回一个数组Array(oauth_token, oauth_token_secret),用于生成调用地址
	Public Function GetTempToken()
		Dim url, params, result
		Dim temp
		result = Array("", "", "")
		url = "http://api.t.sina.com.cn/oauth/request_token"
		params = "oauth_consumer_key=" & API_weibo_ID
		params = params & "&oauth_nonce=" & MakeRandNum()
		params = params & "&oauth_signature_method=HMAC-SHA1"
		params = params & "&oauth_timestamp=" & Timestamp()
		params = params & "&oauth_version=1.0"
		params = params & "&oauth_signature=" & MakeSign("GET", url, params, "")
		url = url & "?" & params
		temp = RequestUrl(url)
		temp = Split(temp, "&")
		If UBound(temp)<1 Then
			response.write("获取验证信息失败，请确保输入的APP ID和APP KEY是正确的。")
			response.End
		End If
		result(0) = Split(temp(0), "=")(1)	' oauth_token
		result(1) = Split(temp(1), "=")(1)	' oauth_token_secret
'		Session("weibo_oauth_token") = result(0)
		Session("weibo_oauth_token_secret") = result(1)
		GetTempToken = result
	End Function

	'生成登录地址
	Public Function CreateLoginUrl()
		Dim url, params, token
		token = GetTempToken()
		url = "http://api.t.sina.com.cn/oauth/authorize"
		params = "oauth_consumer_key=" & API_weibo_ID
		params = params & "&oauth_token=" & token(0)
		params = params & "&oauth_callback=" & UrlEncode(API_weibo_URL)
		CreateLoginUrl = url & "?" & params
	End Function
	
	'检测是否合法登录,如果合法，则返回用户信息
	Public Function CheckLogin()
		Dim oauth_token, openid, oauth_signature, oauth_vericode, timestamp
		oauth_token = Trim(Request.QueryString("oauth_token"))
		oauth_verifier = Trim(Request.QueryString("oauth_verifier"))

		If oauth_token<>"" And oauth_verifier<>"" Then
			CheckLogin = Array("", oauth_token, oauth_verifier)
		Else
			CheckLogin = False
		End If
	End Function
	
	'获取存取token,返回一个数组Array(openid, oauth_token, oauth_token_secret),用于生成调用地址,传入参数为合法登录后的用户信息
	Public Function GetAccessToken(token)
		Dim url, params, result
		Dim temp
		result = Array("", "", "")
		url = "http://api.t.sina.com.cn/oauth/access_token"
		params = "oauth_consumer_key=" & API_weibo_ID
		params = params & "&oauth_nonce=" & MakeRandNum()
		params = params & "&oauth_signature_method=HMAC-SHA1"
		params = params & "&oauth_timestamp=" & Timestamp()
		params = params & "&oauth_token=" & token(1)
		params = params & "&oauth_verifier=" & token(2)
		params = params & "&oauth_version=1.0"
		params = params & "&oauth_signature=" & MakeSign("GET", url, params, Session("weibo_oauth_token_secret"))
		url = url & "?" & params
		temp = RequestUrl(url)
		temp = Split(temp, "&")
			If UBound(temp)<2 Then
				response.write("反馈信息错误。")
				response.End
			End If
		result(0) = Split(temp(2), "=")(1)	' user_id
		result(1) = Split(temp(0), "=")(1)	' oauth_token
		result(2) = Split(temp(1), "=")(1)	' oauth_token_secret
		GetAccessToken = result
	End Function
	
	'获取用户信息,得到一个json格式的字符串
	Public Function GetUserInfo(token)
		Dim url, params, result
		url = "http://api.t.sina.com.cn/users/show/"& token(0) &".json"
		params = "oauth_consumer_key=" & API_QQ_ID
		params = params & "&oauth_nonce=" & MakeRandNum()
		params = params & "&oauth_signature_method=HMAC-SHA1"
		params = params & "&oauth_timestamp=" & Timestamp()
		params = params & "&oauth_token=" & token(1)
		params = params & "&oauth_version=1.0"
		params = params & "&openid=" & token(0)
		params = params & "&oauth_signature=" & MakeSign("GET", url, params, token(2))
		url = url & "?" & params
		GetUserInfo = RequestUrl(url)
	End Function
	
	'获取用户名字,从json字符串里截取用户名
	Public Function GetUserName(json)
		jsonStr = Split(json, """domain"":""")(1)
		GetUserName = Split(jsonStr, """")(0)
	End Function
	
	'获取用户名字,从json字符串里截取昵称
	Public Function GetNickName(json)
		jsonStr = Split(json, """screen_name"":""")(1)
		GetNickName = Split(jsonStr, """")(0)
	End Function
End Class
%>