<%
'-------------------------------------------
'名称：mkFolder
'作用：创建文件夹
'参数：folder，文件夹
'说明：只能生成一级目录
'-------------------------------------------
Function mkFolder(folder)
if isfolder(folder) = "true" then
response.write folder&" 文件夹已存在！"
exit Function
end if
set fso = server.CreateObject("scripting.filesystemobject") 
fso.createfolder(server.mappath(folder))
if err.number > 0 then
response.write "操作失败，文件夹未生成！"
exit Function
else
response.write "操作成功，文件夹 "&folder&" 已生成！"
end if
set fso = nothing
End Function
'-------------------------------------------
'名称：DelFolder
'作用：删除文件夹
'参数：folder，文件夹
'-------------------------------------------
Function DelFolder(folder)
if isfolder(folder) = "false" then
response.write folder&" 文件夹不存在！"
exit Function
end if
set fso = server.CreateObject("scripting.filesystemobject")
fso.deletefolder(server.mappath(folder)) 
if err.number > 0 then
response.write "操作失败，文件夹未删除！"
exit Function
else
response.write "操作成功，文件夹 "&folder&" 已删除！"
end if
set fso = nothing
End Function
'-------------------------------------------
'名称：isFolder(folder)
'作用：判断我文件夹是否存在
'参数：folder，文件夹
'-------------------------------------------
Function isFolder(folder)
set fso = server.CreateObject("scripting.filesystemobject") 
if fso.folderexists(server.mappath(folder)) then
isfolder = "true"
else
isfolder = "false"
end if
set fso = nothing
End Function
'-------------------------------------------
'名称：mkFile
'作用：创建文本文件
'参数：filename 文件名,filecontent 文件内容
'-------------------------------------------
Function mkFile(filename,filecontent)
  on error resume next
  if instr(filename,":") = 0 then filename = filename
  filename = Server.MapPath(filename)
  dim oStream
  Set oStream = CreateObject("ADODB.Stream")
  oStream.Type = 2 '设置为可读可写
  oStream.Mode = 3 '设置内容为文本
  oStream.Charset = "gb2312" '设置编码
  oStream.Open
  oStream.Position = oStream.Size
  oStream.WriteText filecontent
  oStream.SaveToFile filename, 2
  oStream.Close
  Set oStream = Nothing
  If Err.Number <> 0 Then Err.Clear
End Function
'-------------------------------------------
'名称：Readfile
'作用：读取文件内容
'参数：URL - 来源文件路径
'-------------------------------------------
Function Readfile(URL)
  filecontent = Server.MapPath(URL)
  set srmObj = server.CreateObject("adodb.stream")
  srmObj.type=1
  srmObj.mode=3
  srmObj.open
  srmObj.Position=0
  srmObj.LoadFromFile filecontent  
  srmObj.Position = 0
  srmObj.type=2
  srmObj.charset="gb2312"
  Readfile=srmObj.readtext()
End Function
'-------------------------------------------
'名称：isfile(tfile)
'参数：tfile，文件
'作用：判断我文件是否存在
'-------------------------------------------
Function isFile(tfile)
set fso = server.CreateObject("scripting.filesystemobject") 
if fso.fileexists(server.mappath(tfile)) then
isfile = "true"
else
isfile = "false"
end if
set fso = nothing
End Function
'-------------------------------------------
'名称：DelFile
'作用：删除文件
'参数：FileName - 文件名称
'-------------------------------------------
Function DelFile(FileName)
   Dim objFilesys
    FileName = Server.MapPath(FileName)
     On Error Resume Next
     Set objFilesys=server.createobject("scripting.filesystemobject")
     If objFilesys.FILEExists(FileName) then objFilesys.deleteFILE FileName
     If Err.Number<>0 Then
       Response.Write " 文件 "&FileName&" 无法被删除，可能文件正在被系统使用中!"
       Err.Clear
       Response.End
     End If
Set objFilesys=nothing
End Function
'-------------------------------------------
'名称：MoveFile
'作用：移动文件
'参数：FileName1 来源文件,FileName2 复制文件
'-------------------------------------------
Function MoveFile(FileName1,FileName2)
On Error Resume Next
Set fso = server.createobject("scripting.filesystemobject")
fso.MoveFile server.mappath(FileName1),server.mappath(FileName2) 
Set fso = nothing
End Function
'-------------------------------------------
'名称：DesFile
'作用：文件属性
'参数：FileName 文件
'-------------------------------------------
Function DesFile(FileName)
Set fso = server.createobject("scripting.filesystemobject")
Dim f, s
    If ReportFileStatus(FileName) = 1 then
    Set f = fso.GetFile(FileName)
       select Case InfoType
        Case 1 s = f.Datecreated '// 1 -----创建时间
        Case 2 s = f.DateLastAccessed '// 2 -----上次访问时间
        Case 3 s = f.DateLastModified '// 3 -----上次修改时间
        Case 4 s = f.Path '// 4 -----文件路径
        Case 5 s = f.Name '// 5 -----文件名称
        Case 6 s = f.Type '// 6 -----文件类型
        Case 7 s = f.Size '// 7 -----文件大小
        Case 8 s = f.ParentFolder '// 8 -----父目录
        Case 9 s = f.RootFolder '// 8 -----根目录
      End select
        ShowFileAccessInfo = s 
    ELse
        ShowFileAccessInfo = -1 
    End if
Set fso = nothing
End Function
'--------------------------------------------
Function getHTTPPage(url) 
   dim http 
   set http=Server.createobject("Microsoft.XMLHTTP") 
   Http.open "GET",url,false 
   Http.send() 
   if Http.readystate<>4 then
exit function 
   end if 
   getHTTPPage=bytesToBSTR(Http.responseBody,"gb2312")
   set http=nothing
   if err.number<>0 then err.Clear 
End function
'--------------------------------------------
Function BytesToBstr(body,Cset) 
   dim objstream
   set objstream = Server.CreateObject("adodb.stream")
   objstream.Type = 1
   objstream.Mode =3
   objstream.Open
   objstream.Write body
   objstream.Position = 0
   objstream.Type = 2
   objstream.Charset = Cset
   BytesToBstr = objstream.ReadText 
   objstream.Close
   set objstream = nothing
End Function
%>