<%
'######################################################################
'## ctrl.cache.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Mvc Cache-Ctrl Block
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2012/06/10 23:10
'## Description :   AspBox Mvc Cache-Ctrl Block(MVC֮Cacheģ)
'######################################################################

Class Cls_Ctrl_Cache

	Private	s_mark
	Private i_expires

	Private Sub Class_Initialize()
		s_mark = ""
		i_expires = 3600
	End Sub

	Private Sub Class_Terminate()

	End Sub

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Mark [= s]
	'@   :  --
	'@   :  /ȡ Cacheǰ׺
	'==DESC=====================================================================================
	'@  s(ѡ): String (ַ)
	'==DEMO=====================================================================================
	'@ Ctrl.Cache.Mark = "abxss_"
	'@ AB.C.PrintCn "Cacheǰ׺:" & Ctrl.Cache.Mark
	'@ *****************************************************************************************

	Public Property Let Mark(Byval s)
		s_mark = s
	End Property

	Public Property Get Mark()
		Mark = s_mark
	End Property

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Expires [= n]
	'@   :  --
	'@   :  /ȡ Cacheʱ()
	'==DESC=====================================================================================
	'@  n(ѡ): Integer () 
	'==DEMO=====================================================================================
	'@ Ctrl.Cache.Expires = 3600 'û3600
	'@ Ctrl.Cache.Set "ca_admin", "admin", ""
	'@ *****************************************************************************************

    Public Property Let [Expires](Byval n)
        i_expires = stdTime(DateAdd("s", n, Now)) '
    End Property

    Public Property Get Expires()
        [Expires] = i_expires
    End Property

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Find(key) дʽ Ctrl.Cache(key)
	'@   :  Anything (ֵ)
	'@   :  ȡֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ ab.c.print Ctrl.Cache("ca_admin")
	'@ *****************************************************************************************

    Public Default Property Get Find(Byval key)
        Find = [Get](key)
    End Property

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Get(key)
	'@   :  Anything (ֵ)
	'@   :  ȡCacheֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ ab.c.print Ctrl.Cache.Get("ca_admin")
	'@ *****************************************************************************************

	Public Function [Get](Byval key)
        Dim iExpire : iExpire = Application(Me.Mark & key & "_Expires")
        If IsNull(iExpire) Or IsEmpty(iExpire) Then
            [Get] = ""
        Else
            If IsDate(iExpire) And CDate(iExpire) > Now Then
                [Get] = Application(Me.Mark & key)
            Else
                Call Remove(Me.Mark & key)
                [Get] = ""
            End If
        End If
    End Function

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Set key, value, expire
	'@   :  ޷ֵ
	'@   :  Sessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'@  value: Anything (ֵ)
	'@  expire: Interger Or "" ()
	'==DEMO=====================================================================================
	'@ Ctrl.Cache.Set "ca_admin", "admin", "" 'ʱ伴ΪCtrl.Cache.Expiresֵ
	'@ Ctrl.Cache.Set "ca_admin", "admin", Now+1 'һ
	'@ Ctrl.Cache.Set "ca_admin", "admin", DateAdd("s", 3600, Now) '3600
	'@ *****************************************************************************************

	Public Sub [Set](Byval key, Byval value, Byval expire)
		On Error Resume Next
		Dim iexpire : iexpire = i_expires
        If Trim(expire&"")<>"" Then iexpire = expire
		iexpire = stdTime(Cdate(iexpire))
		If Err Or iexpire <= Now Then : Err.Clear : Exit Sub : End If
        Lock
		Application(Me.Mark & key) = Value
        Application(Me.Mark & key & "_Expires") = iexpire
        UnLock
		On Error Goto 0
    End Sub

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.UnLock
	'@   :  ޷ֵ
	'@   :  Lock the applaction
	'==DESC=====================================================================================
	'@  : 
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub Lock()
        Application.Lock()
    End Sub

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.UnLock
	'@   :  ޷ֵ
	'@   :  UnLock the applaction
	'==DESC=====================================================================================
	'@  : 
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub UnLock()
        Application.UnLock()
    End Sub

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Remove key
	'@   :  ޷ֵ
	'@   :  ɾĳSessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ Ctrl.Cache.Remove "ca_admin"
	'@ *****************************************************************************************

	Public Sub Remove(Byval key)
        Lock
        Application.Contents.Remove(Me.Mark & key)
        Application.Contents.Remove(Me.Mark & key & "_Expires")
        unLock
    End Sub

	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.RemoveAll
	'@   :  ޷ֵ
	'@   :  ɾCacheֵ
	'==DESC=====================================================================================
	'@ : 
	'==DEMO=====================================================================================
	'@ Ctrl.Cache.RemoveAll()
	'@ *****************************************************************************************

	Public Sub RemoveAll()
        Lock
        Application.Contents.RemoveAll()
        unLock
    End Sub

    '**********
	'@ *****************************************************************************************
	'@ :  Ctrl.Cache.Compare(key1, key2)
	'@   :  True/False ֵ
	'@   :  ȽCacheֵǷ
	'==DESC=====================================================================================
	'@  key1: String (ַ) Cache 1 ļֵ
	'@  key2: String (ַ) Cache 2 ļֵ
	'==DEMO=====================================================================================
	'@ AB.C.Print Ctrl.Cache.Compare("s_v1", "s_v2")
	'@ *****************************************************************************************

	Public Function [Compare](Byval key1, Byval key2)
        Dim Cache1
        Cache1 = Me.[Get](key1)
        Dim Cache2
        Cache2 = Me.[Get](key2)
        If TypeName(Cache1) <> TypeName(Cache2) Then
            Compare = False
        Else
            If TypeName(Cache1) = "Object" Then
                Compare = (Cache1 Is Cache2)
            Else
                If TypeName(Cache1) = "Variant()" Then
                    Compare = (Join(Cache1, "^") = Join(Cache2, "^"))
                Else
                    Compare = (Cache1 = Cache2)
                End If
            End If
        End If
    End Function

	Private Function stdTime(Byval t)
		Dim tm : tm = t : If IsNull(t) Or t="" Then tm = Now
		Dim p : p = "yyyy-mm-dd hh:nn:ss"
		Dim s : s = p & ""
		s = Replace(s,"yyyy",year(tm))
		s = Replace(s,"mm",right("0" & month(tm),2))
		s = Replace(s,"dd",right("0" & day(tm),2))
		s = Replace(s,"hh",right("0" & hour(tm),2))
		s = Replace(s,"nn",right("0" & minute(tm),2))
		s = Replace(s,"ss",right("0" & second(tm),2))
		stdTime = s
	End Function

End Class
%>