
/**
 * ȽǷͬ
 * @param {Object} fobj
 * @param {Object} sobj
 * @return (Boolean)
 */
var compare = function(fobj, sobj) {
	var ftype = typeof(fobj);
	var stype = typeof(sobj);
	if (ftype == stype) {
		if (ftype == "object") {
			if (fobj.constructor == Array && sobj.constructor == Array) {
				return compareArray(fobj, sobj)
			} else if (fobj.constructor != Array && sobj.constructor != Array) {
				return compareObject(fobj, sobj);
			}
			return false;
		}
		return fobj == sobj;
	}
	return false;
}

/**
 * ȽǷͬ
 * @param {Object} fobj
 * @param {Object} sobj
 * @return (Boolean)
 */
var compareObject = function(fobj, sobj) {
	for (var ele in fobj) {
		if (sobj[ele] == undefined) {
			return false;
		}
		if (!compare(fobj[ele], sobj[ele])) {
			return false;
		}
	}
	for (var ele in sobj) {
		if (fobj[ele] == undefined) {
			return false;
		}
		if (!compare(fobj[ele], sobj[ele])) {
			return false;
		}
	}
	return true;
}

/**
 * ԱǷͬ
 * @param {Object} farr
 * @param {Object} sarr
 * @return (Boolean)
 */
var compareArray = function(farr, sarr) {
	if (farr.length != sarr.length) {
		return false;
	}
	for (var i = 0; i < farr.length; i++) {
		if (!compare(farr[i], sarr[i])) {
			return false;
		}
	}
	return true;
}

/**
 * С
 * @param {Object} obj
 * @author shenkong(shenkong@php.net)
 */
var count = function(obj) {
	var length = 0;
	if (typeof obj == 'object') {
		for (k in obj) {
			length++;
		}
	}
	return length;
}

/**
 * Ƿĳֵ
 *  haystack  needle ҵ򷵻 TRUE򷵻 FALSE
 * @param {Object} needle
 * @param {Object} haystack
 * @author shenkong(shenkong@php.net)
 */
var in_obj = function(needle, haystack) {
	for (key in haystack) {
		if (compare(needle, haystack[key])) {
			return true;
		}
	}
	return false;
}

/**
 * ļǷ
 * @param {Object} key
 * @param {Object} search
 * @author shenkong(shenkong@php.net)
 */
var obj_key_exists = function(key, search) {
	if (typeof key != 'number' && typeof key != 'string') {
		return false;
	}
	for (k in search) {
		if (k == key) {
			return true;
		}
	}
	return false;
}

/**
 *  input еֵ佨
 * @param {Object} input
 * @author shenkong(shenkong@php.net)
 */
var obj_values = function(input) {
	var o = [];
	for (key in input) {
		o.push(input[key]);
	}
	return o;
}

/**
 * еļ
 *  input еַֻļ
 * ָ˿ѡ search_value ֻظֵļ input емᱻء
 * @param {Object} input
 * @param {Object} search_value
 * @author shenkong(shenkong@php.net)
 */
var obj_keys = function(input, search_value) {
	if (typeof input != 'object') {
		return false;
	}
	var o = [];
	if (search_value == undefined) {
		for (key in input) {
			o.push(key);
		}
	} else {
		for (key in input) {
			if (compare(input[key], search_value)) {
				o.push(key);
			}
		}
	}
	return o;
}

/**
 * һ飬һֵΪһֵΪֵ
 * ĵԪͬΪʱ FALSE
 * keysֵзֵַķ FALSE
 * @param {Object} keys
 * @param {Object} values
 * @author shenkong(shenkong@php.net)
 */
var obj_combine = function(keys, values) {
	if (keys.length != values.length) {
		return false;
	}
	if (keys.length == 0) {
		return false;
	}
	if (typeof keys != 'object' || typeof values != 'object') {
		return false;
	}
	var o = {};
	for (var i = 0; i < keys.length; i++) {
		if (typeof keys[i] != 'number' && typeof keys[i] != 'string') {
			return false;
		}
		o[keys[i]] = values[i];
	}
	return o;
}

/**
 * ֵɹ򷵻Ӧļ
 *  haystack  needle ҵ·ؼ򷵻 FALSE
 *  needle  haystack гֲֹһΣ򷵻صһƥļ
 * ҪƥֵļӦ obj_keys() Ͽѡ search_value 档
 * @param {Object} needle
 * @param {Object} haystack
 * @author shenkong(shenkong@php.net)
 */
var obj_search = function(needle, haystack) {
	if (typeof haystack != 'object') {
		return false;
	}
	for (key in haystack) {
		if (compare(haystack[key], needle)) {
			return key;
		}
	}
	return false;
}

/**
 * ͳеֵֵĴ
 * һ󣬸ö input еֵΪֵ input гֵĴΪֵ
 * @param {Object} input
 * @author shenkong(shenkong@php.net)
 */
var obj_count_values = function(input) {
	var o = {};
	for (key in input) {
		if (o[input[key]] == undefined) {
			o[input[key]] = 1;
		} else {
			o[input[key]]++;
		}
	}
	return o;
}

/**
 * еļֵ
 * һת object trans еļֵ trans еֵ˼
 * ͬһֵ˶ΣһΪֵĶʧˡ
 * @param {Object} trans
 * @author shenkong(shenkong@php.net)
 */
var obj_flip = function(trans) {
	var o = {};
	for (key in trans) {
		o[trans[key]] = key;
	}
	return o;
}

/**
 * ضһԪ
 * @param {Object} obj
 * @author shenkong(shenkong@php.net)
 */
var end = function(obj) {
	for (key in obj) {
	}
	return obj[key];
}

/**
 * صõĵԪ
 * һ󣬸ö arr1 ееԪ callback ù֮ĵԪ
 * callback ܵĲĿӦúʹݸ obj_map() Ŀһ¡
 * @param {Object} callback
 * @author shenkong(shenkong@php.net)
 */
var obj_map = function(callback, arr1) {
	var o = [];

	if (callback == null) {
		callback = function() {
			var a = [];
			for (var i = 0; i < arguments.length; i++) {
				a.push(arguments[i]);
			}
			return a;
		}
	}

	for (var i = 1; i < arguments.length; i++) {
		arguments[i] = obj_values(arguments[i]);
	}
	var length = 0;
	for (var i = 1; i < arguments.length; i++) {
		if (arguments[i].length > length) {
			length = arguments[i].length;
		}
	}
	for (var i = 0; i < length; i++) {
		var cmd = [];

		for (var j = 1; j < arguments.length; j++) {
			cmd.push('arguments[' + j + '][' + i + ']');
		}
		cmd = 'o[' + i + '] = callback(' + cmd.join(',') + ')';
		eval(cmd);
	}
	return o;
}
