<%
'######################################################################
'## ab.a.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Array Extensive Class
'## Version     :   v1.0.2
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2013/02/06 12:56
'## Description :   AspBox(Array)ģ
'######################################################################

Class Cls_AB_A

	Private Sub Class_Initialize()
		'AB.Use "H"
	End Sub

	Private Sub Class_Terminate()

	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.A.Max(arr)
	'# @return: Integer / Double
	'# @dowhat: ȡԪֵ(ԪؾΪ)
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] ()
	'--DEMO------------------------------------------------------------------------------------
	'# ab.c.print AB.A.Max(array(1, 5.5, 3.2)) '=> 5.5
	'------------------------------------------------------------------------------------------

	Public Function Max(ByVal arr)
		Dim tmp
		tmp = Me.rSort(arr)
		Max = tmp(0)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.Min(arr)
	'# @return: Integer / Double
	'# @dowhat: ȡԪСֵ(ԪؾΪ)
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] ()
	'--DEMO------------------------------------------------------------------------------------
	'# ab.c.print AB.A.Min(array(1, 5.5, 3.2)) '=> 1
	'------------------------------------------------------------------------------------------

	Public Function Min(ByVal arr)
		Dim tmp
		tmp = Me.Sort(arr)
		Min = tmp(0)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.Sum(arr)
	'# @return: Integer / Double
	'# @dowhat: Ԫܺ
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] () Ϊֵؿֵ
	'--DEMO------------------------------------------------------------------------------------
	'# ab.trace AB.A.Sum(array(1, 2.5, 1.6)) '=> 5.1
	'------------------------------------------------------------------------------------------

	Public Function Sum(ByVal arr)
		Dim tmp, item
		If IsArray(arr) and Me.Len(arr) > 0 Then
			tmp = 0
			For Each item in arr
				tmp = tmp + item
			Next
		End If
		Sum = tmp
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.Avg(arr)
	'# @return: Integer / Double
	'# @dowhat: Ԫصƽ
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] () Ϊֵؿֵ
	'--DEMO------------------------------------------------------------------------------------
	'# ab.trace AB.A.Avg(array(1, 2.5, 1.6)) '=> 1.7
	'------------------------------------------------------------------------------------------

	Public Function Avg(ByVal arr)
		Dim tmp, n, item
		If IsArray(arr) and Me.Len(arr) > 0 Then
			tmp = 0 : n = 0
			For Each item in arr
				tmp = tmp + item
				n = n + 1
			Next
			If n > 0 Then tmp = tmp / n Else tmp = ""
		End If
		Avg = tmp
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.First(arr)
	'# @return: Anything (ֵ)
	'# @dowhat: ȡõһԪֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] () ֵ ֵ
	'--DEMO------------------------------------------------------------------------------------
	'# Dim o : Set o = AB.Dict 'ֵ
	'# ab.trace AB.A.First(array("abcd", o, 5)) '=> "abcd"
	'# Dim x : Set x = AB.A.First(array(o, "abcd", 5)) '=>  o
	'# ab.trace x
	'------------------------------------------------------------------------------------------

	Public Function First(ByVal arr)
		First = ""
		If IsArray(arr) and Me.Len(arr) > 0 Then
			If IsObject(arr(0)) Then : Set First = arr(0) : Else : First = arr(0) : End if
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.End(arr)
	'# @return: Anything (ֵ)
	'# @dowhat: ȡһԪֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] () ֵ ֵ
	'--DEMO------------------------------------------------------------------------------------
	'# Dim o : Set o = AB.Dict 'ֵ
	'# ab.trace AB.A.End(array("abcd", o, 5)) '=> 5
	'# Dim x : Set x = AB.A.End(array("abcd", 5, o)) '=>  o
	'# ab.trace x
	'------------------------------------------------------------------------------------------

	Public Function [End](ByVal arr)
		[End] = ""
		If IsArray(arr) and Me.Len(arr) > 0 Then
			Dim n : n = UBound(arr)
			If IsObject(arr(n)) Then : Set [End] = arr(n) : Else : [End] = arr(n) : End if
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.Clone(arr)
	'# @return: array
	'# @dowhat: ʵĿ¡()
	'# 			 arr п¡(̬,ʱԪ)
	'# 			﷨ arrNew = AB.A.Clone(arr)
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] (Դ)
	'--DEMO------------------------------------------------------------------------------------
	'# dim a1, a2
	'# a1 = array("a","b","c")
	'# a2 = array("x","y",3)
	'# a2 = ab.a.clone(a1)
	'# ab.trace(a2) '=> Array("a","b","c")
	'------------------------------------------------------------------------------------------

	Public Function Clone(ByVal arr)
		Dim i, a()
		If Me.Len(arr)<=0 Then : Clone = arr: Exit Function: End If
		For i = LBound(arr) To UBound(arr)
			Redim Preserve a(i)
			If IsObject(arr(i)) Then Set a(i) = arr(i) Else a(i) = arr(i)
		Next
		Clone = a
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.UnShift(arr, s)
	'# @return: array
	'# @dowhat: дǰѹԪ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'# @param s   [string] : ַԪ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.UnShift(array("a", "b", "c"), "d") '=> Array("d", "a", "b", "c")
	'-------------------------------------------------------------------------------------------

	Public Function UnShift(ByVal arr, ByVal s)
		Dim i, a()
		If Me.Len(arr)<=0 Then
			Redim Preserve a(0)
			If IsObject(s) Then Set a(0) = s Else a(0) = s
			UnShift = a
			Exit Function
		End If
		Redim Preserve a(LBound(arr)) : If IsObject(s) Then Set a(LBound(arr)) = s Else a(LBound(arr)) = s
		For i = LBound(arr) To UBound(arr)
			Redim Preserve a(i+1)
			If IsObject(arr(i)) Then Set a(i+1) = arr(i) Else a(i+1) = arr(i)
		Next
		UnShift = a
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Shift(arr, s)
	'# @return: array
	'# @dowhat: дǰɾԪ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'# @param s   [string] : ַԪ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Shift(array("a", "b", "c", "d")) '=> Array("b", "c", "d")
	'-------------------------------------------------------------------------------------------

	Public Function Shift(ByVal arr)
		Dim i, a()
		If Me.Len(arr)<=0 Then : Shift = Array(): Exit Function : End If
		For i = LBound(arr)+1 To UBound(arr)
			Redim Preserve a(i-1)
			If IsObject(arr(i)) Then Set a(i-1) = arr(i) Else a(i-1) = arr(i)
		Next
		Shift = a
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Push(arr, s)
	'# @return: array
	'# @dowhat: дӺѹԪ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'# @param s   [string] : ַԪ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Push(array("a", "b", "c"), "d") '=> Array("a", "b", "c", "d")
	'-------------------------------------------------------------------------------------------

	Public Function Push(ByVal arr, ByVal s)
		Dim i, a : a = Me.Clone(arr)
		If Me.Len(arr)<=0 Then
			Redim Preserve a(0)
			If IsObject(s) Then Set a(0) = s Else a(0) = s
			Push = a
			Exit Function
		End If
		Redim Preserve a(UBound(arr)+1)
		If IsObject(s) Then Set a(UBound(arr)+1) = s Else a(UBound(arr)+1) = s
		Push = a
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Pop(arr)
	'# @return: array
	'# @dowhat: дӺɾԪ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Pop(array("a", "b", "c", "d")) '=> Array("a", "b", "c")
	'-------------------------------------------------------------------------------------------

	Public Function Pop(ByVal arr)
		Dim i, a()
		If Me.Len(arr)<=1 Then : Pop = Array(): Exit Function : End If
		For i = LBound(arr) To UBound(arr)-1
			Redim Preserve a(i)
			If IsObject(arr(i)) Then Set a(i) = arr(i) Else a(i) = arr(i)
		Next
		Pop = a
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Strip(str)
	'# @return: array
	'# @dowhat: ȥַұߺߵ(,),(,)ָɵ
	'# 			ȥ(1,2,3,)(,1,2,3)ұߺߵ(,),(,)ָɵ
	'--DESC-------------------------------------------------------------------------------------
	'# @param str   [string] : ַ str as a string such as "1,2,3,"
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Strip("a,b,c,d,") '=> Array("a", "b", "c", "d")
	'-------------------------------------------------------------------------------------------

	Public Function Strip(ByVal Str)
		AB.Use "H" : If IsArray(Str) Then Str = Me.ToString(Str)
		If Left(Str, 1) = "," Then Str = Right(Str, AB.H.Len(Str) -1)
		If Right(Str, 1) = "," Then Str = Left(Str, AB.H.Len(Str) -1)
		Str = Me.ToArray(Str)
		Strip = Str
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Walk(arr, f)
	'# @return: array
	'# @dowhat: Ԫִк󷵻
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 	[array] : ()
	'# @param f 	[string | mix-array] : (ַ  )
	'# 				fַΪҪִеĺ
	'# 				f飬һԪΪҪִеĺڶԪΪִкĵڶϲ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Walk(array("ab", "cde", "fghi"), "len") '=> Array(2, 3, 4)
	'# ab.trace ab.a.Walk(array("ab", "cde", "fghi"), array("len")) '=> Array(2, 3, 4)
	'# Function foo(a, b, c) : foo = a + b + c : End Function
	'# ab.trace ab.a.Walk(array(1, 2, 3), array("foo", array(2, 3)) ) '=> Array(6, 7, 8)
	'-------------------------------------------------------------------------------------------

	Public Function Walk(ByVal arr, ByVal f)
		On Error Resume Next
		Dim callback, e, tmp, i, j, estr, fstr, a() : e = "" : tmp = "" : fstr = "" : i = 0 : AB.Use "H"
		If IsArray(f) Then
			If UBound(f)>-1 Then If VarType(f(0)) = vbString Then callback = f(0)
			If UBound(f)>0 Then
				If Not IsArray(f(1)) Then fstr = ", f(1)"
				If IsArray(f(1)) Then
					For i = 0 To UBound(f(1))
						fstr = fstr & ", f(1)("& i &")"
					Next
				End If
			End If
		End If
		If VarType(f) = vbString Then callback = f
		If Lcase(Trim(callback))="len" Then callback = "AB.H.Len"
		If Lcase(Trim(callback))="cstr" Then callback = "AB.H.Cstr"
		If IsNull(callback) Or Trim(callback)="" Then : Walk = arr : Exit Function : End If
		If Me.Len(arr)=-1 Then '
			estr = "tmp=" & callback & "(arr " & fstr & ")"
			Execute(estr)
			Walk = tmp
		ElseIf Me.Len(arr)=0 Then '̬(Ԫ)
			Walk = arr
		Else '(Ԫطǿ)
			i = LBound(arr)
			For Each e in arr
				estr = "tmp=" & callback & "(e " & fstr & ")"
				Execute(estr)
				Redim Preserve a(i)
				a(i) = tmp
				i = i + 1
			Next
			Walk = a
		End If
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Sub(arr, start, over) ȡԪ(Χ)
	'# @return: array
	'# @dowhat: (Χ:ӿʼ start   over)һнȡһԪ(һ)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 		[Array]   : array
	'# @param start 	[Integer] : start index
	'# @param over	 	[Integer] : over index
	'# 					 over ֵΪ-1ʱ, ʾȡԪطΧӿʼ index ʼֱ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Sub(array("a","b","c","d"), 0, 0) '=> Array("a")
	'# ab.trace ab.a.Sub(array("a","b","c","d"), 1, 2) '=> Array("b", "c")
	'# ab.trace ab.a.Sub(array("a","b","c","d"), -1, 2) '=> Array("a","b","c")
	'# ab.trace ab.a.Sub(array("a","b","c","d"), 0, -1) '=> Array("a", "b", "c", "d")
	'-------------------------------------------------------------------------------------------

	Public Function [Sub](ByVal arr, ByVal start, ByVal over)
		On Error Resume Next
		If Me.Len(arr)<=0 Then : [Sub] = Array(): Exit Function : End If
		Dim i, k, tmp, a()
		If AB.C.isInt(start) Then
			Dim n:n=CLng(start) : Dim z:z=CLng(over) : Dim m:m=UBound(arr) : Dim p:p=LBound(arr)
			If z>m Or z=-1 Then z=m
			If n<0 Then n=0
			For i=n To z
				Redim Preserve a(k)
				If i<=m Then
					If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
				End If
				k = k+1
			Next
			tmp = a
			If k=0 Then tmp = Array()
		Else
			tmp = Array()
		End If
		[Sub] = tmp
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Slice(arr, start, length) ȡԪ(ʼȽȡ)
	'# @return: array
	'# @dowhat: (ָΧ)һнȡһԪ(һ)
	'# 			start>=0ʱ,Ϊȡ(ֵΪstartʼȡ)
	'# 			strat<0ʱ,ֵ[鳤m-(-strat)]ʼȡ
	'# 			length>0ʱ,ֵstartʼȡstart+lengthȡ
	'# 			length=0ʱ,ֵstartʼȡȡ
	'# 			length<0ʱ,ֵstartʼȡstart-(-length)ȡ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 		[Array]   : array
	'# @param start 	[Integer] : start index
	'# @param length 	[Integer] : length
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Slice(array("a","b","c","d"), 1, 2) '=> Array("b", "c")
	'# ab.trace ab.a.Slice(array("a","b","c","d"), 2, 5) '=> Array("c", "d")
	'# ab.trace ab.a.Slice(array("a","b","c","d"), 0, 2) '=> Array("a", "b")
	'# ab.trace ab.a.Slice(array("a","b","c","d"), 0, 0) '=> Array("a", "b", "c", "d")
	'# ab.trace ab.a.Slice(array("a","b","c","d","e"), 3, -2) '=> Array("d", "c", "b")
	'-------------------------------------------------------------------------------------------

	Public Function Slice(ByVal arr, ByVal start, ByVal length)
		On Error Resume Next
		If Me.Len(arr)<=0 Then : Slice = Array(): Exit Function : End If
		Dim i, k, tmp, a(), over
		If AB.C.isInt(start) Then
			Dim n:n=CLng(start) : Dim l:l=CLng(length) : Dim m:m=UBound(arr) : over = m : Dim p:p=LBound(arr)
			If n<0 Then n=m-Abs(n)
			If n<0 Then n=0
			If n>=0 Then
				If m<n Then: Slice = Array(): Exit Function : End If
				k=0 : over = m
				If l>=0 Then
					If l=0 Or n+l-1>=m Then
						over = m
					Else
						over = n+l-1
					End If
					For i=n To over
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
				Else
					over = n+l
					If over<p Then over=p
					For i=n To over Step -1
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
				End If
				tmp = a
				If k=0 Then tmp = Array()
			End If
		Else
			tmp = Array()
		End If
		Slice = tmp
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Splice(arr, start, length) ƳԪ
	'# @return: array
	'# @dowhat: (ָΧ)һƳһԪ(һ)
	'# 			start>=0ʱ,Ϊ(ֵΪstartʼ)ɾ󷵻ص
	'# 			start<0ʱ,ֵ[鳤m-(-start)]ʼɾ󷵻ص
	'# 			length>0ʱ,ֵstartʼstart+lengthȡص
	'# 			length=0ʱ,ֵstartʼɾ󷵻ص
	'# 			length<0ʱ,ֵstartʼstart-(-length)ɾ󷵻ص
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 		[Array]   : array
	'# @param start 	[Integer] : start index
	'# @param length 	[Integer] : length
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Splice(array("a","b","c","d"), 1, 2) '=> Array("a", "d")
	'# ab.trace ab.a.Splice(array("a","b","c","d"), 2, 5) '=> Array("a", "b")
	'# ab.trace ab.a.Splice(array("a","b","c","d"), 0, 2) '=> Array("c", "d")
	'# ab.trace ab.a.Splice(array("a","b","c","d"), 0, 0) '=> Array()
	'# ab.trace ab.a.Splice(array("a","b","c","d","e"), 3, -1) '=> Array("a", "b", "e")
	'-------------------------------------------------------------------------------------------

	Public Function Splice(ByVal arr, ByVal start, ByVal length)
		On Error Resume Next
		If Me.Len(arr)<=0 Then : Splice = Array(): Exit Function : End If
		Dim i, k, tmp, a(), over
		If AB.C.isInt(start) Then
			Dim n:n=CLng(start) : Dim l:l=CLng(length) : Dim m:m=UBound(arr) : over = m : Dim p:p=LBound(arr)
			If n<0 Then n=m-Abs(n)
			If n<0 Then n=0
			If n>=0 Then
				If m<n Then: Splice = arr: Exit Function : End If
				k=0 : over = m
				If l>=0 Then
					If l=0 Or n+l-1>=m Then
						over = m
					Else
						over = n+l-1
					End If
					For i=p To m
						If i<n Or i>over Then
							Redim Preserve a(k)
							If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
							k = k+1
						End If
					Next
				Else
					over = n+l
					If over<p Then over=p
					For i=p To m
						If (i<over) or (i>n) Then
							Redim Preserve a(k)
							If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
							k = k+1
						End If
					Next
				End If
				tmp = a
				If k=0 Then tmp = Array()
			End If
		Else
			tmp = arr
		End If
		Splice = tmp
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.SpliceX(arr, start, length, elem) 滻Ԫ
	'# @return: array
	'# @dowhat: (ָΧ)һнһԪ(һ)Ԫش沢
	'# 			start>=0ʱ,Ϊ(ֵΪstartʼ)ɾ󷵻ص
	'# 			start<0ʱ,ֵ[鳤m-(-start)]ʼɾ󷵻ص
	'# 			length>0ʱ,ֵstartʼstart+lengthȡص
	'# 			length=0ʱ,ֵstartʼɾ󷵻ص
	'# 			length<0ʱ,ֵstartʼstart-(-length)ɾ󷵻ص
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 		[Array]   : array
	'# @param start 	[Integer] : start index
	'# @param length 	[Integer] : length
	'# @param elem	 	[Array | Object|String|Other.. | Null] : Ԫ
	'# 					 elem Ϊ Array ʱ, ʾԪ
	'# 					 elem Ϊ Object|String|Other.. ʱ, ʾ䵥Ԫ
	'# 					 elem Ϊ null ʱ, Ԫ, Ч AB.A.Splice(arr, start, length) 
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.SpliceX(array("a","b","c","d"), 1, 2, array("x","y")) '=> Array("a", "x", "y", "d")
	'# ab.trace ab.a.SpliceX(array("a","b","c","d"), 2, 5, array("x","y")) '=> Array("a", "b", "x", "y")
	'# ab.trace ab.a.SpliceX(array("a","b","c","d"), 0, 2, array("x","y")) '=> Array("x", "y", "c", "d")
	'# ab.trace ab.a.SpliceX(array("a","b","c","d"), 0, 0, array("x","y")) '=> Array("x", "y")
	'# ab.trace ab.a.SpliceX(array("a","b","c","d","e"), 3, -1, array("x","y")) '=> Array("a", "b", "x", "y", "e")
	'# ab.trace ab.a.SpliceX(array("a","b","c","d","e"), -1, 0, "x") '=> Array("a","b","c","d","x")
	'# ab.trace ab.a.Concat(array("a","b","c","d","e"), array("x","y")) '=> Array("a","b","c","d","e","x","y")
	'# ab.trace ab.a.Fill(array("a","b","c","d","e"), 1, "x") '=> Array("a","x","b","c","d","e")
	'# 'ab.trace ab.a.Fill(array("a","b","c","d","e"), 1, Array("x","y")) '=> Array("a","x","y","b","c","d","e")
	'-------------------------------------------------------------------------------------------

	Public Function SpliceX(ByVal arr, ByVal start, ByVal length, ByVal elem)
		On Error Resume Next
		If Me.Len(arr)<=0 Then : Splice = Array(): Exit Function : End If
		Dim i, k, tmp, a(), over, e
		If AB.C.isInt(start) Then
			Dim n:n=CLng(start) : Dim l:l=CLng(length) : Dim m:m=UBound(arr) : over = m : Dim p:p=LBound(arr)
			If n<0 Then n=m-Abs(n)
			If n<0 Then n=0
			If n>=0 Then
				If m<n Then: Splice = arr: Exit Function : End If
				k=0 : over = m
				If l>=0 Then
					If l=0 Or n+l-1>=m Then
						over = m
					Else
						over = n+l-1
					End If
					For i=p To n-1
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
					If IsArray(elem) Then
						For Each e In elem
							Redim Preserve a(k)
							If IsObject(e) Then Set a(k) = e Else a(k) = e
							k = k+1
						Next
					ElseIf IsNull(elem) Then
						'do nothing.
					Else
						If IsObject(elem) Then Set a(k) = elem Else a(k) = elem
						k = k+1
					End If
					For i=over+1 To m
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
				Else
					over = n+l
					If over<p Then over=p
					For i=p To over-1
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
					If IsArray(elem) Then
						For Each e In elem
							Redim Preserve a(k)
							If IsObject(e) Then Set a(k) = e Else a(k) = e
							k = k+1
						Next
					ElseIf IsNull(elem) Then
						'do nothing.
					Else
						If IsObject(elem) Then Set a(k) = elem Else a(k) = elem
						k = k+1
					End If
					For i=n+1 To m
						Redim Preserve a(k)
						If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
						k = k+1
					Next
				End If
				tmp = a
				If k=0 Then tmp = Array()
			End If
		Else
			tmp = arr
		End If
		SpliceX = tmp
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Fill(arr, index, elem)
	'# @return: array
	'# @dowhat: Ԫص飨飩
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr 		[Array]   : ()
	'# @param index 	[Integer] : () as index to insert into an array
	'# @param elem	 	[Array | Object|String|Other.. | Null] : Ԫ
	'# 					 elem Ϊ Array ʱ, ʾԪ
	'# 					 elem Ϊ Object|String|Other.. ʱ, ʾ䵥Ԫ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Fill(array("a", "b", "c"), 1, "d") '=> Array("a", "d", "b", "c")
	'# ab.trace ab.a.Fill(array("a", "b", "c"), 5, "d") '=> Array("a", "b", "c", "", "", "d")
	'# ab.trace ab.a.Fill(array("a", "b", "c"), -2, "d") '=> Array("d", "", "a", "b", "c")
	'-------------------------------------------------------------------------------------------

	Public Function Fill(ByVal arr, ByVal index, ByVal elem)
		If Not IsArray(arr) Then : Fill = arr: Exit Function : End If
		If Me.Len(arr)<=0 Then : arr = Array()
		Dim i, k, tmp, a() : k = 0
		If LBound(arr) <= index and UBound(arr) >= index Then
			For i = LBound(arr) To UBound(arr)
				If i < index Then
					Redim Preserve a(k)
					If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
				ElseIf i = index Then
					Redim Preserve a(k)
					If IsObject(elem) Then Set a(k) = elem Else a(k) = elem
					Redim Preserve a(k+1)
					If IsObject(arr(i)) Then Set a(k+1) = arr(i) Else a(k+1) = arr(i)
				Else
					Redim Preserve a(k+1)
					If IsObject(arr(i)) Then Set a(k+1) = arr(i) Else a(k+1) = arr(i)
				End If
				k = k+1
			Next
		ElseIf UBound(arr) < index Then
			For i = LBound(arr) To UBound(arr)
				Redim Preserve a(k)
				If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
				k = k+1
			Next
			For i = UBound(arr)+1 To index
				If i <> index Then
					Redim Preserve a(k)
					a(k) = ""
				Else
					Redim Preserve a(k)
					a(k) = elem
				End If
				k = k+1
			Next
		ElseIf LBound(arr) > index Then
			For i = index To LBound(arr)-1
				If i = index Then
					Redim Preserve a(k)
					If IsObject(elem) Then Set a(k) = elem Else a(k) = elem
				Else
					Redim Preserve a(k)
					a(k) = ""
				End If
				k = k+1
			Next
			For i = LBound(arr) To UBound(arr)
				Redim Preserve a(k)
				If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
				k = k+1
			Next
		End If
		tmp = a
		Fill = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Concat(arr1,arr2)
	'# @return: array
	'# @dowhat: ϲһ()
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr1 [array] : ()
	'# @param arr2 [array] : ()
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Concat(array("a","b","c"), array("c","d")) '=> Array("a","b","c","c","d")
	'# ab.trace ab.a.Concat(array("a","","","b"), array("d","","e")) '=> Array("a","","","b","d","","e")
	'-------------------------------------------------------------------------------------------

	Public Function Concat(ByVal arr1, ByVal arr2)
		Dim tmp, e, i, k, a()
		For Each e in arr1
			Redim Preserve a(k)
			If IsObject(e) Then Set a(k) = e Else a(k) = e
			k = k+1
		Next
		For Each e in arr2
			Redim Preserve a(k)
			If IsObject(e) Then Set a(k) = e Else a(k) = e
			k = k+1
		Next
		tmp = a
		Concat = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Merge(arr1,arr2)
	'# @return: array
	'# @dowhat: ϲһҽ沿(ͬԪز)ֻһ()
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr1 [array] : ()
	'# @param arr2 [array] : ()
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Merge(array("a","b","c"), array("c","d")) '=> Array("a","b","c","d")
	'# ab.trace ab.a.Merge(array("a","","","b"), array("d","","e")) '=> Array("a","","","b","d","e")
	'-------------------------------------------------------------------------------------------

	Public Function Merge(ByVal arr1, ByVal arr2)
		Dim tmp, e, i, k, a()
		For Each e in arr1
			Redim Preserve a(k)
			If IsObject(e) Then Set a(k) = e Else a(k) = e
			k = k+1
		Next
		For Each e in arr2
			If Not Me.InArray(e,a) Then
				Redim Preserve a(k)
				If IsObject(e) Then Set a(k) = e Else a(k) = e
				k = k+1
			End If
		Next
		tmp = a
		Merge = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Clean(arr)
	'# @return: array
	'# @dowhat: ƳԪ()
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : ()
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Clean(array("a", "", "", "b")) '=> Array("a", "b")
	'-------------------------------------------------------------------------------------------

	Public Function Clean(ByVal arr)
		Dim tmp, e, i, k, a()
		For Each e in arr
			''If Not (IsNull(e) Or e="") Then
			If Not AB.C.IsNul(e) Then
				Redim Preserve a(k)
				If IsObject(e) Then Set a(k) = e Else a(k) = e
				k = k+1
			End If
		Next
		tmp = a
		Clean = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Unique(arr)
	'# @return: array
	'# @dowhat: Ƴظ()Ԫ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : ()
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Unique(array("a", "b", "c", "b")) '=> Array("a", "b", "c")
	'-------------------------------------------------------------------------------------------

	Public Function Unique(ByVal arr)
		Dim tmp, e, i, k, a()
		For Each e in arr
			If Not Me.InArray(e,a) Then
				Redim Preserve a(k)
				If IsObject(e) Then Set a(k) = e Else a(k) = e
				k = k+1
			End If
		Next
		tmp = a
		Unique = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Reverse(arr)
	'# @return: array
	'# @dowhat: Ԫط
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : ()
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Reverse(array("a", "b", "c", "d")) '=> Array("d", "c", "b", "a")
	'-------------------------------------------------------------------------------------------

	Public Function Reverse(ByVal arr)
		If Me.Len(arr)<=0 Then : Reverse = Array(): Exit Function : End If
		Dim i, k, tmp, a()
		For i=UBound(arr) To LBound(arr) Step -1
			Redim Preserve a(k)
			If IsObject(arr(i)) Then Set a(k) = arr(i) Else a(k) = arr(i)
			k = k+1
		Next
		tmp = a
		Reverse = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Range(low, high, step)
	'# @return: array
	'# @dowhat: һָΧԪ, ֵĬΪ 1
	'# 			д low  high ĵԪǱ;
	'# 			 low > highн high  low
	'# 			 low > highн high  low
	'--DESC-------------------------------------------------------------------------------------
	'# @param low [integer] : () lowʼ
	'# @param high [integer] : () high
	'# @param step [integer] : (  ֵ) ΪԪ֮Ĳֵstep ӦΪֵδָ(ֵΪ)ĬΪ 1
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.range(2, 5, 1) '=> Array(2, 3, 4, 5)
	'# ab.trace ab.a.range(1, 6, 2) '=> Array(1, 3, 5)
	'# ab.trace ab.a.range(6, 1, 2) '=> Array(6, 4, 2)
	'# ab.trace ab.a.range(6, 1, -2) '=> Array(6, 4, 2) 'ֵΪ-2 ʵϿΪֵ2
	'# ab.trace ab.a.range("a", "e", 1) '=> Array("a", "b", "c", "d", "e")
	'# ab.trace ab.a.range("F", "A", 2) '=> Array("F","D","B") ABCDEFGFA,Ϊ2
	'-------------------------------------------------------------------------------------------

	Public Function Range(ByVal low, ByVal high, ByVal [step])
		If IsNull([step]) Or Trim([step])="" Or [step] = 0 Then [step] = 1
		[step] = CInt([step])
		Dim tmp, i, k, a(), start, over, steps : k = 0 : steps = [step]
		If AB.C.IsInt(low) and AB.C.IsInt(high) Then '0-9
			If low <= high Then
				start = low : over = high : steps = Abs(steps)
			Else
				start = low : over = high : steps = -(Abs(steps))
			End If
		Else 'A-Z  a-z
			If (Asc(low)>=65 Or Asc(low)<=90) and (Asc(high)>=65 Or Asc(high)<=90) Or _
				(Asc(low)>=97 Or Asc(low)<=122) and (Asc(high)>=97 Or Asc(high)<=122) Then
				If Asc(low) < Asc(high) Then
					start = Asc(low) : over = Asc(high) : steps = Abs(steps)
				Else
					start = Asc(low) : over = Asc(high) : steps = -(Abs(steps))
				End If
				For i = start To over Step steps
					Redim Preserve a(k)
					a(k) = Chr(i)
					k = k + 1
				Next
				Range = a
				Exit Function
			End If
		End If
		For i = start To over Step steps
			Redim Preserve a(k)
			a(k) = i
			k = k + 1
		Next
		tmp = a
		Range = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Rand(arr, num)
	'# @return: array
	'# @dowhat: µ飬ɶά
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] 	: ()
	'# @param arr [integer] : () as specifies how many entries you want to pick
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Rand(array("a", "b", "c"), 5) '=> Array("a", "a", "c", "a", "c")
	'-------------------------------------------------------------------------------------------

	Public Function Rand(ByVal arr, ByVal num)
		If Me.Len(arr)<=0 Then : Rand = Array(): Exit Function : End If
		Dim tmpi, tmp, i, a()
		For i = 0 To num -1
			Randomize
			tmpi = Int((UBound(arr) + 1) * Rnd)
			Redim Preserve a(i)
			If IsObject(arr(tmpi)) Then Set a(i) = arr(tmpi) Else a(i) = arr(tmpi)
		Next
		tmp = a
		Rand = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Sort(arr)
	'# @return: array
	'# @dowhat: ˳(С) (ԪؾΪ)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Sort(array(2, 1, 3)) '=> Array(1, 2, 3)
	'-------------------------------------------------------------------------------------------

	Public Function Sort(ByVal arr)
		Dim tmp, i, j
		ReDim tmpA(UBound(arr))
		For i = 0 To UBound(tmpA)
			tmpA(i) = CDbl(arr(i))
		Next
		For i = 0 To UBound(tmpA)
			For j = i + 1 To UBound(tmpA)
				If tmpA(i) > tmpA(j) Then
					tmp = tmpA(i)
					tmpA(i) = tmpA(j)
					tmpA(j) = tmp
				End If
			Next
		Next
		Sort = tmpA
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.rSort(arr)
	'# @return: array
	'# @dowhat: (ӴС) (ԪؾΪ)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.rSort(array(2, 1, 3)) '=> Array(3, 2, 1)
	'-------------------------------------------------------------------------------------------

	Public Function rSort(ByVal arr)
		Dim tmp, i, j
		ReDim tmpA(UBound(arr))
		For i = 0 To UBound(tmpA)
			tmpA(i) = CDbl(arr(i))
		Next
		For i = 0 To UBound(tmpA)
			For j = i + 1 To UBound(tmpA)
				If tmpA(i) < tmpA(j) Then
					tmp = tmpA(i)
					tmpA(i) = tmpA(j)
					tmpA(j) = tmp
				End If
			Next
		Next
		rSort = tmpA
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Shuffle(arr)
	'# @return: array
	'# @dowhat: 
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Shuffle(array(2, 1, 3)) '=> Array(1, 3, 2)
	'-------------------------------------------------------------------------------------------

	Public Function Shuffle(ByVal arr)
		Dim m, n, i
		'i = Search(arr,Rand(arr,1))
		'arr = Splice(arr,i,i+1)
		Randomize
		For i = 0 to UBound(arr)
			m = Int(Rnd()*i)
			n = arr(m)
			If IsObject(arr(i)) Then Set arr(m) = arr(i) Else arr(m) = arr(i)
			If IsObject(n) Then Set arr(i) = n Else arr(i) = n
		Next
		Shuffle = arr
	End Function

	'---------------------------------------------------------------------
	'# AB.A.Split(sText,sSplit)
	'# @return: integer
	'# @dowhat: ַָΪ,˷ԭSplitĲ
	'# 			ַָsSplitֵΪʱÿַɵ
	'--DESC---------------------------------------------------------------
	'# @param sText [string] : ԭַ
	'# @param sSplit [string / Integer] : ַָ
	'--DEMO---------------------------------------------------------------
	'# AB.Trace AB.A.Split("a,b,c",",") 'أArray("a","b","c")
	'# AB.Trace AB.A.Split("abcd","") 'أArray("a","b","c","d")
	'# AB.Trace AB.A.Split("abcdefg",3) 'أArray("abc","def","g")
	'# AB.Trace AB.A.Split("abcd",0) 'أArray("a","b","c","d")
	'#--------------------------------------------------------------------

	Function Split(Byval sText, Byval sSplit)
		On Error Resume Next
		Split = AB.C.Split(sText,sSplit)
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.toArr(sText,sSplit)
	'# @return: integer
	'# @dowhat: ַָΪ,˷ԭSplitĲ
	'# 			ַָsSplitֵΪʱÿַɵ
	'# @author: Lajox; version: 1.0.0 (2012-04-21)
	'--DESC-------------------------------------------------------------------------------------
	'# @param sText [string] : ԭַ
	'# @param sSplit [string] : ַָ
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.Trace AB.A.toArr("a,b,c",",") 'أArray("a","b","c")
	'# AB.Trace AB.A.toArr("abcd","") 'أArray("a","b","c","d")
	'--------------------------------------------------------------------------------------------

	Function toArr(Byval sText, Byval sSplit)
		Dim temp
		temp = Me.Split(sText,sSplit)
		toArr = temp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.toStr(a, s)
	'# @return: string
	'# @dowhat: תΪַ
	'# 			ԪذĳָƴӳַɴJoin
	'--DESC-------------------------------------------------------------------------------------
	'# @param a [array] : 
	'# @param s [string] : ָ
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.C.Print AB.A.toStr(Array("a","b","c"), "|") 'أa|b|c
	'--------------------------------------------------------------------------------------------

	Public Function toStr(Byval a, Byval s)
		Dim str,i
		If Not IsArray(a) Then Exit Function
		'For i=0 To Ubound(a)
			'If i=0 Then
				'str = str & a(i)
			'Else
				'str = str & s & a(i)
			'End If
		'Next
		If IsArray(a) Then str = Join(a, s) Else str = a
		toStr = str
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.ToString(a)
	'# @return: string
	'# @dowhat: Ԫذָ(,)ƴӳַ
	'--DESC-------------------------------------------------------------------------------------
	'# @param a : [array] 
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.C.Print AB.A.ToString(Array("a","b","c")) 'أa,b,c
	'--------------------------------------------------------------------------------------------

	Public Function ToString(ByVal arr)
		If IsArray(arr) Then
			Dim tmp
			tmp = Join(arr, ",")
			ToString = tmp
		Else
			ToString = arr
		End If
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.ToArray(s)
	'# @return: array
	'# @dowhat: ַת, ַĳָ(,)ָΪ
	'--DESC-------------------------------------------------------------------------------------
	'# @param s [string] : ַ sΪʱ,ϱ-1Ķ̬
	'--DEMO-------------------------------------------------------------------------------------
	'# Dim s : s = "a,b,c"
	'# Dim a : a = AB.A.ToArray(s)
	'# If UBound(a)>-1 Then ab.trace(a)
	'--------------------------------------------------------------------------------------------

	Public Function ToArray(ByVal s)
		Dim str : str = s
		If IsNull(str) Then str = ""
		Dim a : a = Me.Split(str, ",")
		Dim i, k, b(), c
		If Not IsNull(str) and str<>"" Then
			k = 0
			For i=0 To Ubound(a)
				Redim Preserve b(k)
				b(k) = Trim(a(i))
				k = k + 1
			Next
			c = b
		Else
			c = a
		End If
		ToArray = c
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.InArray(s, arr)
	'# @return: boolean
	'# @dowhat: жһֵǷ飬򷵻False
	'--DESC-------------------------------------------------------------------------------------
	'# @param s   [string] : ĳֵ
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.C.Print AB.A.InArray("2", Array("1","2","3")) 'True
	'-------------------------------------------------------------------------------------------

	Public Function InArray(Byval s, Byval arr)
		If Not IsArray(arr) Then InArray = False : Exit Function
		' Dim I
		' InArray = False
		' For I = LBound(arr) To UBound(arr)
			' If Not IsObject(arr(I)) and Not IsObject(s) Then
				' If arr(I) = s Then
					' InArray = True
					' Exit For
				' End If
			' ElseIf IsObject(arr(I)) and IsObject(s) Then
				' If TypeName(arr(I)) = TypeName(s) and VarType(arr(I)) = VarType(s) Then
					' InArray = True
					' Exit For
				' End If
			' End If
		' Next
		Dim x
		InArray = False
		For Each x In arr
			If Not IsObject(x) and Not IsObject(s) Then
				If x = s Then
					InArray = True
					Exit For
				End If
			ElseIf IsObject(x) and IsObject(s) Then
				If TypeName(x) = TypeName(s) and VarType(x) = VarType(s) Then
					InArray = True
					Exit For
				End If
			End If
		Next
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Count(arr, s)
	'# @return: integer
	'# @dowhat: (һά)ﺬжٸĳֵ
	'# @author: Lajox; version: 1.0.0 (2012-04-21)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'# @param s   [string] : ĳֵ
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.C.Print AB.A.Count(Array("a","b","b","c"),"b") '2
	'-------------------------------------------------------------------------------------------

	Function Count(arr, s)
		On Error Resume Next
		If Not IsArray(arr) Then:Count=0: Exit Function: End If '鷵0
		Dim I,iCount:iCount=0
		'AB.Use "H":If AB.H.Len(s) > 0 Then iCount=(AB.H.Len(Join(arr,""))-AB.H.Len(Replace(Join(arr,""),s,"")))/AB.H.Len(s)
		For I=LBound(arr) To UBound(arr)
			If Not IsObject(arr(I)) and Not IsObject(s) Then
				If s = arr(I) Then iCount=iCount+1
			ElseIf IsObject(arr(I)) and IsObject(s) Then
				If TypeName(arr(I)) = TypeName(s) and VarType(arr(I)) = VarType(s) Then
					iCount=iCount+1
				End If
			End If
		Next
		Count = iCount
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Search(arr, value)
	'# @return: integer
	'# @dowhat: ѯԪǷڲظֵӦ
	'# 			ѯԪأ򷵻-1, 򷵻ظֵӦ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr     [array] 	 : ()
	'# @param value   [anything] : Anything (ֵ) Searching value
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.c.print ab.a.Search(array("a", "b", "c"), "b") '=> 1
	'-------------------------------------------------------------------------------------------

	Public Function Search(ByVal arr, ByVal Value)
		If Me.Len(arr)<=0 Then : Search = -1: Exit Function : End If
		Dim i
		For i = 0 To UBound(arr)
			If Not IsObject(arr(i)) and Not IsObject(Value) Then
				If arr(i) = Value Then
					Search = i
					Exit Function
				End If
			ElseIf IsObject(arr(i)) and IsObject(Value) Then
				If TypeName(arr(i)) = TypeName(Value) and VarType(arr(i)) = VarType(Value) Then
					Search = i
					Exit Function
				End If
			End If
		Next
		Search = -1
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Index(arr, s)
	'# @return: integer
	'# @dowhat: ַԪ(һά)е(Index)
	'# 			Ϊ򷵻ֵ(-1), ҲԪҲֵ(-1)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'# @param s   [string] : ַԪ
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.c.print ab.a.Index(array("ab","cd","efg"),"cd") '1
	'-------------------------------------------------------------------------------------------

	Public Function Index(Byval arr, Byval s)
		On Error Resume Next
		If Not IsArray(arr) Then:Index=-1: Exit Function: End If
		Dim i,temp:temp = -1
		For I=LBound(arr) To UBound(arr)
			If Not IsObject(arr(I)) and Not IsObject(s) Then
				If s = arr(I) Then
					temp = I
					Exit For
				End If
			ElseIf IsObject(arr(I)) and IsObject(s) Then
				If TypeName(arr(I)) = TypeName(s) and VarType(arr(I)) = VarType(s) Then
					temp = I
					Exit For
				End If
			End If
		Next
		Index = temp
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Len(arr)
	'# @return: integer
	'# @dowhat: (һά)鳤(Ԫظ)
	'# 			(һά)鳤ȴС, 鷵ֵ(-1), ̬鷵ֵ(0)
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# dim a,b(),i
	'# a = array() : ab.c.printcn ab.a.len(a) '0
	'# a = array("a","b") : ab.c.printcn ab.a.len(a) '2
	'# a = split("", ",") : ab.c.printcn ab.a.len(a) '0
	'# ab.c.printcn ab.a.len(b) '0
	'# redim preserve b(3) : b(3) = "x" : ab.c.printcn ab.a.len(b) '4
	'# redim preserve b(0) : b(0) = "t" : ab.c.printcn ab.a.len(b) '1
	'# a = array("a","b","c")
	'# if ab.a.len(a)>0 then
	'#   for i=0 to ab.a.len(a)-1
	'# 	   ab.c.print "<br>" & a(i)
	'#   next
	'# end if
	'-------------------------------------------------------------------------------------------

	Public Function [Len](Byval arr)
		On Error Resume Next
		If Not IsArray(arr) Then:[Len]=-1:End If
		Dim temp:temp=Ubound(arr)
		If Err Or temp<0 Then:[Len]=0:Err.Clear:Exit Function:End If
		Dim i,iCount:iCount=0
		For i=Lbound(arr) To Ubound(arr)
			iCount = iCount + 1
		Next
		[Len] = iCount
		On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Size(arr)
	'# @return: integer
	'# @dowhat: ά, 鷵ֵ(-1), ̬鷵ֵ(0)
	'# 			δʼĶ̬顢SplitָصϱUboundֵ-1, 򷵻: 0
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr [array] : 
	'--DEMO-------------------------------------------------------------------------------------
	'# dim a(2,3) : ab.c.printcn ab.a.size(a) '2
	'# dim b : b = split("", ",") : ab.c.printcn ab.a.size(b) '0
	'# dim c(2,2)
	'# c(0,0) = "0-0" : c(0,1) = "0-1" : c(0,2) = "0-2"
	'# c(1,0) = "1-0" : c(1,1) = "1-1" : c(1,2) = "1-2"
	'# c(2,0) = "2-0" : c(2,1) = "2-1" : c(2,2) = "2-2"
	'# dim d(2) : d(0) = "0" : d(1) = "1" : d(2) = "2"
	'# dim e(4,5,8)
	'# ab.c.printcn ab.a.size(c) & "-" & ab.a.size(d) & "-" & ab.a.size(e) '2-1-3
	'# ab.trace c
	'-------------------------------------------------------------------------------------------

	Public Function Size(Byval arr)
		On Error Resume Next
		If Not IsArray(arr) Then:Size=-1:Exit Function:End If
		Dim temp:temp=Ubound(arr)
		If Err Or temp<0 Then:Size=0:Err.Clear:Exit Function:End If
		Dim m : m = 0 'ά(ֵΪ 0 )
		'If m = 0 Then m = 30
		Dim n,i,k:k=0
		Err.Clear
		If m <= 0 Then 'ѭ
			Dim tm
			Do While Err.Number = 0
				k = k + 1
				tm = Ubound(arr,k)
			Loop
			If Err Then k = k - 1 : Err.Clear
			Size = k
		ElseIf m > 0 Then 'ά޶
			For i=1 To m
				Dim tn : tn = Ubound(arr,i)
				If Err then
					Err.Clear
					Exit For
				Else
					k = k + 1
				End if
			Next
			Size = k
		End If
		On Error GoTo 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.A.Chunk(arr, size)
	'# @return: Integer / Double
	'# @dowhat: һ(һά)ָɶ飬ÿĵԪĿ size 
	'# 			һĵԪĿܻټ
	'--DESC------------------------------------------------------------------------------------
	'# @param arr: [array] () ԭ
	'# @param size: [integer] () ÿĵԪĿ(һ size >= 1)  size <=0 ֵԭ
	'--DEMO------------------------------------------------------------------------------------
	'# Dim a : a = AB.A.Chunk(array(1,2,3,4,5,6,7), 3)
	'# AB.Trace a 'Array(array(1,2,3), array(4,5,6), array(7))
	'# If AB.A.Len(a)>0 Then AB.Trace a(0) ' Array(1,2,3)
	'# If AB.A.Len(a)>1 Then AB.Trace a(1) ' Array(4,5,6)
	'# If AB.A.Len(a)>2 Then AB.Trace a(2) ' Array(7)
	'# Dim i, j
	'# For i = 0 To Ubound(a)
	'# 	AB.C.PrintCn "a(" & i & ") =>"
	'# 	For j = 0 To Ubound(a(i))
	'# 		AB.C.PrintCn a(i)(j)
	'# 	Next
	'# Next
	'------------------------------------------------------------------------------------------

	Public Function Chunk(ByVal arr, Byval size)
		Dim tmp : tmp = Array()
		If IsArray(arr) and Me.Len(arr) > 0 Then
			size = CInt(size) : If CInt(size) <= 0 Then : Chunk = arr : Exit Function : End If
			Dim i, j, k, n, l : k = 0 : l = Me.Len(arr)
			If (Me.Len(arr) Mod size) = 0 Then
				n = l \ size
			Else
				n = l \ size + 1
			End If
			For i = 0 To n-1
				Redim Preserve tmp(i)
				tmp(i) = Array()
				For j = 0 To size-1
					If k < l Then tmp(i) = Me.Push(tmp(i), arr((i)*size + (j+1) - 1))
					k = k + 1
				Next
			Next
		End If
		Chunk = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Diff(arr1,arr2)
	'# @return: array
	'# @dowhat: һ飬array1еǲarray2еֵ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr1 [array] : (1)
	'# @param arr2 [array] : (2)
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Diff(array("a","b","c"), array("a","d","c")) '=> Array("b")
	'# ab.trace ab.a.Diff(array("a","e","e","f"), array("x","e","y")) '=> Array("a","f")
	'-------------------------------------------------------------------------------------------

	Public Function Diff(ByVal arr1, ByVal arr2)
		If Not IsArray(arr1) Or Not IsArray(arr2) Then : Diff = Array() : Exit Function : End If
		Dim tmp, e, i, k, a() : k = 0
		For Each e in arr1
			If Not Me.InArray(e, arr2) Then
				Redim Preserve a(k)
				If IsObject(e) Then Set a(k) = e Else a(k) = e
				k = k + 1
			End If
		Next
		tmp = a
		Diff = tmp
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.A.Same(arr1,arr2)
	'# @return: array
	'# @dowhat: һ飬˼array1array2еֵ
	'--DESC-------------------------------------------------------------------------------------
	'# @param arr1 [array] : (1)
	'# @param arr2 [array] : (2)
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.trace ab.a.Same(array("a","b","c"), array("a","d","c")) '=> Array("a","c")
	'# ab.trace ab.a.Same(array("a","e","e","f","z"), array("x","e","y","z")) '=> Array("e","z")
	'-------------------------------------------------------------------------------------------

	Public Function Same(ByVal arr1, ByVal arr2)
		If Not IsArray(arr1) Or Not IsArray(arr2) Then : Diff = Array() : Exit Function : End If
		Dim tmp, e, i, k, a() : k = 0
		For Each e in arr1
			If Me.InArray(e, arr2) And Not Me.InArray(e, a) Then
				Redim Preserve a(k)
				If IsObject(e) Then Set a(k) = e Else a(k) = e
				k = k + 1
			End If
		Next
		tmp = a
		Same = tmp
	End Function

	'@ *****************************************************************************************
	'@ :  AB.A.CheckArray(a1, a2, p)
	'@   :  True/False
	'@   :  Ƚ(һά),p=0Ƚϱ±Ƿһ,p=1ȽǷȫ
	'==DESC=====================================================================================
	'@  a1 : [Array]
	'@  a2 : [Array]
	'@  p : 0 Or 1
	'==DEMO=====================================================================================
	'@ AB.C.PrintCn AB.A.CheckArray(Array(1,2,3), Array(1,2,4), 0) '=> True
	'@ AB.C.PrintCn AB.A.CheckArray(Array(1,2,3), Array(1,2,4), 1) '=> False
	'@ AB.C.PrintCn AB.A.CheckArray("a", "a", 0) '=> False
	'@ *****************************************************************************************

	Public Function CheckArray(Byval a1, Byval a2, Byval p)
		On Error Resume Next
		Dim Result:Result = True
		IF IsArray(a1) And IsArray(a2) Then
			IF UBound(a1)<>UBound(a2) Or LBound(a1)<>LBound(a2) Then
				Result = False
			Else
				If p=1 Then
					Dim I
					For I=LBound(a1) To UBound(a1)
						If Not IsObject(a1(I)) and Not IsObject(a2(I)) Then
							If VarType(a1(I))<>VarType(a2(I)) Or a1(I)<>a2(I) Then
								Result = False
								Exit For
							End If
						ElseIf IsObject(a1(I)) and IsObject(a2(I)) Then
							If TypeName(a1(I)) <> TypeName(a2(I)) Or VarType(a1(I)) <> VarType(a2(I)) Then
								Result = False
								Exit For
							End If
						End If
					Next
				ElseIf p=0 Then
					Result = True
				End If
			End IF
		Else
			Result = False
		End IF
		CheckArray = Result
		On Error GoTo 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.A.SetArray(Arr, By, str) ʽƥ
	'@   :  [Array]
	'@   :  Arrָض(һά)Ԫظֵָƥ䣬oStrֵʣ
	'@			ArrԪظBy,ĲҪ
	'==DESC=====================================================================================
	'@  Arr :	[Array]  
	'@  By  :	[Array  Integer]  ָض(һά)  ֵָ
	'@  str :	[String / Integer]  ַ
	'==DEMO=====================================================================================
	'@ AB.Trace AB.A.SetArray(Array("a","b"), Array("e","f","g"), "c") 	'=> Array("a","b","c")
	'@ AB.Trace AB.A.SetArray(Array("a","b"), Array("e"), "c") 			'=> Array("a")
	'@ AB.Trace AB.A.SetArray(Array("a","b"), 1, "c") 					'=> Array("a")
	'@ *****************************************************************************************

	Public Function SetArray(Byval Arr,Byval By,Byval str)
		IF Err Then Err.Clear
		On Error Resume Next
		IF IsNull(str) Or Trim(str)="" Then str=""
		Dim temp,A(),I
		Dim ai : ai = 0 : IF IsArray(By) Then ai = UBound(By) Else ai = CLng(By)-1
		IF IsArray(Arr) Then 'arrByarr
			IF ai<=UBound(Arr) Then 'arrByarrʱӦƥ滻
				For I=0 To ai
					Redim Preserve A(I)
					A(I) = Arr(I)
				Next
			Else 'arrByarrʱǰ沿ֶӦƥ䣬arrByarrĲԸֵoStrԪ
				For I=0 To UBound(Arr)
					Redim Preserve A(I)
					If IsObject(Arr(I)) Then Set A(I) = Arr(I) Else A(I) = Arr(I)
				Next
				For I=UBound(Arr)+1 To ai
					Redim Preserve A(I)
					If IsObject(str) Then Set A(I) = str Else A(I) = str
				Next
			End IF
			temp = A
		Else
			temp = Arr
		End IF
		SetArray = temp
		On Error GoTo 0
	End Function

End Class
%>