<%
'######################################################################
'## ab.c.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Core Fucntion [AspBox Common Class]
'## Version     :   v1.0.2.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2013/03/10 20:54
'## Description :   AspBox Common Function
'######################################################################

Class Cls_AB_C

	Private o_fso, o_regex
	Private o_rwt, i_rule
	Private s_charset, s_dict, s_url, s_rwtS, s_rwtU, s_rq

	Private Sub Class_Initialize()
		s_dict 	= AB.DictName
		s_charset = AB.CharSet
		Set o_regex = New Regexp
		Set o_rwt = Server.CreateObject(s_dict)
		o_regex.Global = True
		o_regex.IgnoreCase = True
		i_rule = 1
		s_rq = Request.QueryString()
	End Sub

	Private Sub Class_Terminate()
		Set o_regex = Nothing
		Set o_rwt	= Nothing
		If isObject(o_fso) Then Set o_fso = Nothing
	End Sub

	'====

	Public Sub Print(ByVal s) 'c#
		Response.Write s
	End Sub
	Public Sub Echo(ByVal s): Response.Write s: End Sub 'PHP
	Public Sub W(ByVal s): Response.Write s: End Sub

	Public Sub Put(ByVal s) 'ֹ
		Response.Write s
		AB.Exit()
		Set AB = Nothing
		Response.End()
	End Sub
	Public Sub WE(ByVal s): Put s: End Sub

	Public Sub Die(ByVal s) 'PHP׳쳣
		Response.Clear
		Response.Write s
		Response.End()
	End Sub

	Public Sub PrintLn(ByVal s)
		Response.Write(s & VbCrLf)
	End Sub
	Public Sub Wn(ByVal s): Response.Write(s & VbCrLf): End Sub

	Public Sub PrintCn(ByVal s)
		Response.Write("<br /"&">" & s & VbCrLf)
	End Sub
	Public Sub WR(ByVal s): Response.Write("<br /"&">" & s & VbCrLf): End Sub

	Public Sub PrintFn(ByVal s)
		Response.Write s
		Response.Flush()
	End Sub
	Public Sub WF(ByVal s): Response.Write s: Response.Flush(): End Sub

	Public Sub Clear
		Response.Clear()
	End Sub
	Public Sub CC: Response.Clear(): End Sub

	Public Sub Flush
		Response.Flush()
	End Sub

	Public Sub PrintBin(ByVal s) '
		Response.BinaryWrite s
	End Sub
	Public Sub WBin(ByVal s): Response.BinaryWrite s: End Sub
	Public Sub WB(ByVal s): Response.BinaryWrite s: End Sub

	Public Sub WNH(ByVal s)
		PrintCn HtmlEncode(s)
	End Sub

	Public Sub WS(ByVal s)
		AB.Use "Json"
		Response.Write AB.Json.toJson(s)
	End Sub

	Public Sub WSN(ByVal s)
		AB.Use "Json"
		Response.Write("<br /"&">" & AB.Json.toJson(s) & VbCrLf)
	End Sub

	Public Sub [End]
		AB.Exit()
		Response.End()
	End Sub

	'----------------------------------------------------------------------------------------------

	'@ *****************************************************************************************
	'@ :  AB.C.Dim(s)
	'@   :  AB.C.Var(s)  AB.C.Reg(s)
	'@   :  ޷ֵ
	'@   :  (ע)ASPȫֱ, ˷Էֹض
	'==DESC=====================================================================================
	'@  s : String (ַ) ַ
	'==DEMO=====================================================================================
	'@ AB.C.Dim("rs") 'ȫֱrs ;൱䣺Dim rs
	'@ AB.C.Dim "conn" 'ȫֱconn ;൱䣺Dim conn
	'@ AB.C.Dim "a, b, c" '֮ö(,)a, b, c ;൱䣺Dim a, b, c
	'@ *****************************************************************************************

	Public Function [Dim](Byval s)
		On Error Resume Next
		ExecuteGlobal "Dim " & s
		On Error Goto 0
	End Function

	Public Function Var(Byval s)
		[Dim] s
	End Function

	Public Function Reg(Byval s)
		[Dim] s
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IsDim(s)
	'@   :  ֵ
	'@   :  Ƿѱ
	'==DESC=====================================================================================
	'@  s : String (ַ) ַ
	'==DEMO=====================================================================================
	'@ Dim a : a = "var:a"
	'@ AB.C.PrintCn "a ǷѶ壺"& AB.C.IsDim("a") 'True
	'@ AB.C.PrintCn "b ǷѶ壺"& AB.C.IsDim("b") 'False
	'@ *****************************************************************************************

	Public Function IsDim(ByVal s)
		On Error Resume Next
		Dim tmp, p : p = Eval("VarType("& s &")")
		Select Case p
			Case vbEmpty,0,Empty : tmp = False 'δʼ
			Case Else : tmp = True
		End Select
		IsDim = tmp
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Exec Str
	'@   :  ޷ֵ
	'@   :  ִASPű(Executeд)
	'==DESC=====================================================================================
	'@  Str : ִеASPű
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function Exec(Byval s) 'ִASPű
		Dim tStr : tStr = s
		IF IsNul(tStr) Then : tStr = "" : Exit Function : End IF
		On Error Resume Next
		Execute tStr
		On Error Goto 0
	End Function

	'@ ********************************************************************************
	'@ AB.C.New(objName) [](ض),ʧ򷵻Nothing
	'@ : (ܴ)
	'@ author: Lajox; version: 1.1.0 (2012-01-31);
	'==DESC============================================================================
	'@ [arg] objName : //
	'==DEMO============================================================================
	'@ Dim o1, o2, o3, o4, o5, o6, o7
	'@ Set o1 = AB.C.New(AB) 'ͬ Set o1 = AB
	'@ Set o2 = AB.C.New("AB") 'ͬ Set o2 = AB
	'@ Set o3 = AB.C.New("Cls_AB") 'ͬ Set o3 = New Cls_AB
	'@ Set o4 = AB.C.New("Scripting.Dictionary") 'ͬ Set o4 = Server.CreateObject("Scripting.Dictionary")
	'@ Set o5 = AB.C.New("Cls_AB_E") 'ͬ Set o5 = New Cls_AB_E
	'@ Set o6 = AB.C.New("AB.E") 'ͬ Set o6 = AB.E
	'@ Set o7 = AB.C.New("abcd1445") 'Ϊabcd1445ȲǶֲж󴴽ʧܣֵNothing
	'@ AB.Trace Array(TypeName(o1), TypeName(o2), TypeName(o3), TypeName(o4), TypeName(o5), TypeName(o6), TypeName(o7))
	'@ ********************************************************************************

	Public Function [New](ByVal objName)
		On Error Resume Next
		If IsObject(objName) Then
			Set [New] = objName
		Else
			If VarType(objName) = 8 Then 'vbString
				Execute "If IsObject(" & objName & ") Then : Set [New] = " & objName & " : Else : " &_
				"If IsInstall(""" & objName & """) Then : Set [New] = Server.CreateObject(""" & objName & """) : Else : Set [New] = New " & objName & " : End If" &_
				" : End If"
				Execute "If Err<>0 Then : Err.Clear : " &_
				"If IsInstall(""" & objName & """) Then : Set [New] = Server.CreateObject(""" & objName & """) : Else : Set [New] = New " & objName & " : End If" &_
				" : End If"
				Execute "If Err<>0 Then : Err.Clear : Set [New] = New " & objName & " : End If"
				Execute "If Err<>0 Then : Set [New] = Nothing : Err.Clear : End If"
			Else
				Set [New] = Nothing
			End If
		End If
		If Err Then : Set [New] = Nothing : Err.Clear : End If
		On Error Goto 0
	End Function

	'@ ********************************************************************************
	'@ AB.C.Free(o) ٶ,ͷڴ
	'@ : ٶ(Զ),ͷڴ
	'@ author: Lajox; version: 1.1.0 (2012-12-13);
	'==DESC============================================================================
	'@  o ˵:
	'@ 1.[o]Ϊ(Object)
	'@   ٵһ AB.C.Free(obj)
	'@ 2.[o]Ϊַ(String)
	'@   ٵһ AB.C.Free("obj")
	'@   ٶÿ֮ӢĶ(,) AB.C.Free("objA,objB")
	'@ 3.[o]Ϊ(Array)
	'@   ٵһAB.C.Free(Array("obj"))
	'@   ٶAB.C.Free(Array("objA", "objB", "objC"))  AB.C.Free(Array("objA, objB, objC"))
	'==DEMO============================================================================
	'@ ʾ:
	'@ dim o_a, o_b, o_c
	'@ set o_a = AB.Dict
	'@ set o_b = new Cls_AB_C
	'@ set o_c = new Cls_AB_Error
	'@ ab.c.print "======ͷ֮ǰ======"
	'@ ab.trace o_a : ab.trace o_b : ab.trace o_c
	'@ '_ͷŲ:
	'@ 'ab.c.free o_a : ab.c.free o_b : ab.c.free o_c
	'@ ab.c.free "o_a, o_b, o_c"
	'@ 'ab.c.free Array("o_a", "o_b", "o_c")
	'@ 'ab.c.free Array("o_a, o_b, o_c")
	'@ '_
	'@ ab.c.print "======ͷ֮======"
	'@ ab.trace o_a : ab.trace o_b : ab.trace o_c
	'@ ********************************************************************************

	Public Function Free(ByRef o)
		On Error Resume Next
		IF IsNull(o) Or IsEmpty(o) Then Exit Function
		Dim i,j,arr,str
		IF VarType(o)=8 Then 'ַ
			AB.Free(o)
		ElseIF IsObject(o) Then
			str = LCase(TypeName(o))
			If str="connection" Then : If o.State=1 Then o.Close() : End If
			If str="recordset" Then : If o.State=1 Then o.Close() : End If
			If str="dictionary" Then 'ֵ
				If AB_Has(o) Then
					For Each j In o : Set o(j) = Nothing : Next : o.RemoveAll
				End If
			End If
			Set o = Nothing
		ElseIf IsArray(o) Then
			If UBound(o)=-1 Then Exit Function
			For Each i In o
				If VarType(i)=8 Or IsObject(i) Then
					Free(i)
				End If
			Next
		End IF
		On Error Goto 0
	End Function

	'@ ********************************************************************************
	'@ AB.C.Close(obj) رնٶ,ͷԴ
	'@ : Set䴴򿪵ָעͷԴ
	'@ author: Lajox; version: 1.0.1 (2012-06-09);
	'==Args============================================================================
	'@ obj : ҪرյĶ # [Object]
	'==DEMO============================================================================
	'@ 
	'@ ********************************************************************************

	Public Sub Close(ByRef o)
		On Error Resume Next
		If IsObject(o) Then 'Object
			o.Close() : Set o = Nothing
		ElseIF VarType(o) = 8 Then 'String
			Dim temp : temp = Eval("LCase(TypeName(o))")
			If temp = "connection" Then : Execute("If o.State = 1 Then o.Close()") : End If
			If temp = "recordset" Then : Execute("If o.State = 1 Then o.Close()") : End If
			Execute("Set "& o &" = Nothing")
		End If
		On Error Goto 0
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.C.Clone(o)
	'# @syntax: str2 = AB.C.Clone(str1)  Set obj2 = AB.C.Clone(obj1)
	'# @return: [Dictionary Object] (ֵ)
	'# @dowhat: ڿ¡(ƿ)һֵ,,..
	'--DESC------------------------------------------------------------------------------------
	'# @param o: [Any] (ֵ: String/Array/Dictionary/..)
	'--DEMO------------------------------------------------------------------------------------
	'# Dim a1,a2,a3,a4
	'# Dim o1,o2,o3,o4
	'# a1 = "ַ" : o1 = AB.C.Clone(a1) '¡ַ
	'# a2 = Array("a","b","c") : o2 = AB.C.Clone(a2) '¡
	'# Set a3 = AB.Dict : Set o3 = AB.C.Clone(a3) '¡ֵ
	'# Set a4 = AB.db.GRS("select 1 from table") : Set o4 = AB.C.Clone(a4) '¡rs
	'# AB.Trace Array(a1,a2,a3,a4)
	'# AB.Trace Array(o1,o2,o3,o4)
	'------------------------------------------------------------------------------------------

	Public Function Clone(ByVal o)
		On Error Resume Next
		Dim tmp
		If IsObject(o) Then
			If TypeName(o)="Dictionary" Then
				Set tmp = CloneDict(o)
			ElseIf TypeName(o)="Recordset" Then
				Set tmp = o.Clone
			ElseIf TypeName(o)="Connection" Then
				' Set tmp = Server.CreateObject("ADODB.Connection")
				' If o.State = 1 Then
					' tmp.Open o.ConnectionString
					' If Err Then tmp.Close
				' End If
				Set tmp = o
			Else
				Set tmp = o
			End If
		ElseIf IsArray(o) Then
			AB.Use "A"
			tmp = AB.A.Clone(o)
		Else
			tmp = o
		End If
		If IsObject(tmp) Then Set Clone = tmp Else Clone = tmp
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.CallFunc FuncName, Param
	'@   :  зֵ
	'@   :  (ִ)Զ庯
	'==DESC=====================================================================================
	'@  FuncName :  [String]
	'@  Param : ִкĲ [Array | String | Null | ..] ʱʾΪ
	'==DEMO=====================================================================================
	'@ Function foo(a,b,c) : foo = a + b - c : End Function
	'@ Function Jack() : Jack = Array("a",2) : End Function
	'@ AB.C.PrintCn foo(1,3,2) '2
	'@ AB.C.PrintCn AB.C.CallFunc("foo", Array(1,3,2)) '2
	'@ AB.Trace Jack() 'ֵArray("a",2)
	'@ AB.Trace AB.C.CallFunc("Jack", Null) 'ֵArray("a",2)
	'@ *****************************************************************************************

	Public Function CallFunc(ByVal s, ByVal p)
		On Error Resume Next
		If Err Then Err.Clear
		Dim sFunc, param : sFunc = s : param = p
		Dim i, temp, Result
		If IsArray(param) Then
			For i = 0 To UBound(param)
				If i = 0 Then
					temp = "param("& i &")"
				Else
					temp = temp & ", param("& i &")"
				End If
			Next
			Execute("Result = "& sFunc &"("& temp &")")
			Execute("If Err Then : Err.Clear: Result = "& sFunc &"(param) : End If")
		Else
			Execute("Result = "& sFunc &"(param)")
			If Err Then : Execute("Result = "& sFunc &"()") : End If
		End If
		CallFunc = Result
		On Error Goto 0
	End Function

	'---------------------------------------------------------------------
	'# AB.C.Count(sSource,sFind)
	'# @return: integer
	'# @dowhat: (ַ)()(ֵ)ﺬжٸĳֵ
	'# @author: Lajox; version: 1.0.0 (2012-04-21 17:24)
	'--DESC---------------------------------------------------------------
	'# @param sSource [String/Array/Dictionary/..] : ԭַ//ֵȵ
	'# @param sFind   [string] : Ҫֵ/
	'--DEMO---------------------------------------------------------------
	'# AB.C.PrintCn AB.C.Count("abcddabcd","d") '3
	'# AB.C.PrintCn AB.C.Count(Array("a","b","c","b"),"b") '2
	'# AB.C.PrintCn AB.C.Count(AB.Dict,"fso") '1 (ֵǷмfso)
	'#--------------------------------------------------------------------

	Function Count(Byval sSource, Byval sFind)
		Dim iCount : iCount = 0
		Dim i, j, o, k
		If isObject(sSource) Then Set o = sSource Else o = sSource
		If isObject(sFind) Then Set k = sFind Else k = sFind
		Select Case VarType(o)
			Case vbEmpty, vbNull
				iCount = 0
			Case vbBoolean, vbInteger, vbLong, vbSingle, vbDouble, vbCurrency, vbDate, vbByte
				If k = o Then iCount = 1 Else iCount = 0
			Case vbObject
				Select Case TypeName(o)
					Case "Nothing","Empty"
						iCount = 0
					Case "Recordset"
						If o.State = 0 Then
							iCount = 0
						Else
							If IsNul(o) Then
								iCount = 0
							Else
								For j = 0 To o.Fields.Count-1
									If k = o.Fields(j).value Then iCount = iCount+1
								Next
								'If o.Eof Then iCount = 0
							End If
						End If
					Case "Dictionary"
						If o.Count = 0 Then
							iCount = 0
						Else
							If o.Exists(k) Then
								For Each i In o
									'If k = o(i) Then iCount = iCount+1
									If k = i Then iCount = iCount+1
								Next
							Else
								iCount = 0
							End If
						End If
					Case "Cls_AB_List"
						If o.Size = 0 Then
							iCount = 0
						Else
							For i = 0 To o.End
								If k = o(i) Then iCount = iCount+1
							Next
						End If
					Case Else
						If TypeName(o) = TypeName(k) Then
							iCount = 1
						Else
							iCount = 0
						End If
				End Select
			Case vbString
				If Len(o)>0 and Len(k)>0 Then iCount=(Len(o)-Len(Replace(o,k,"")))/Len(k)
				If k = o Then iCount = 1
			Case vbArray,8194,8204,8209
				AB.Use "A" : iCount = AB.A.Count(o, k)
			Case Else
				iCount = 0
		End Select
		Count = iCount
	End Function

	'---------------------------------------------------------------------
	'# AB.C.vOr(s)
	'# @return: Boolean (ֵ)
	'# @dowhat: дOr
	'#  ﷨If  Then ɼдΪIf AB.C.vOr() Then
	'#  ﷨If 1 Or 2 Or 3 Then ɼдΪIf AB.C.vOr(Array(1,2,3)) Then
	'--DESC---------------------------------------------------------------
	'# @param s [Boolean/Array] : ж(Boolean)  һжϵ(Array)
	'--DEMO---------------------------------------------------------------
	'# Dim var : var = 2.3
	'# 'If var=1 Or var="c" Or var<2.5 Then AB.C.Print var
	'# 'If AB.C.vOr(var=1 Or var="c" Or var<2.5) Then AB.C.Print var
	'# 'If AB.C.vOr(Array(var=1 Or var="c" Or var<2.5)) Then AB.C.Print var
	'# If AB.C.vOr(Array(var=1, var="c", var<2.5)) Then AB.C.Print var
	'#--------------------------------------------------------------------

	Function vOr(Byval s)
		On Error Resume Next
		Dim bool : bool = False
		If Err Then Err.Clear
		If IsArray(s) Then
			Dim i
			For Each i In s
				bool = bool Or vOr(i)
			Next
		Else
			bool = CBool(s)
			If Err.Number<>0 Then bool = s
		End If
		vOr = bool
		On Error Goto 0
	End Function

	'---------------------------------------------------------------------
	'# AB.C.vAnd(s)
	'# @return: Boolean (ֵ)
	'# @dowhat: дOr
	'#  ﷨If  Then ɼдΪIf AB.C.vAnd() Then
	'#  ﷨If 1 and 2 and 3 Then ɼдΪIf AB.C.vAnd(Array(1,2,3)) Then
	'--DESC---------------------------------------------------------------
	'# @param s [Boolean/Array] : ж(Boolean)  һжϵ(Array)
	'--DEMO---------------------------------------------------------------
	'# Dim var : var = 1.2
	'# 'If var>1 And var<2.5 Then AB.C.Print var
	'# 'If AB.C.vAnd(var>1 And var<2.5) Then AB.C.Print var
	'# If AB.C.vAnd(Array(var>1, var<2.5)) Then AB.C.Print var
	'#--------------------------------------------------------------------

	Function vAnd(Byval s)
		On Error Resume Next
		Dim bool : bool = True
		If Err Then Err.Clear
		If IsArray(s) Then
			Dim i
			For Each i In s
				bool = bool And vAnd(i)
			Next
		Else
			bool = CBool(s)
			If Err.Number<>0 Then bool = s
		End If
		vAnd = bool
		On Error Goto 0
	End Function

	'@ ********************************************************************************
	'@ AB.C.IsNum(s) жǷΪʽ(ֹ)
	'@   :  Boolean (ֵ)
	'@   :  жĳַǷΪʽ
	'==DESC============================================================================
	'@ [arg] s : ַ
	'@ -----------------------
	'@ IsNumericܴBug,ֵɲ֣ͨ
	'@ # ѧʽ硰2e7͡2d7
	'@ # ʮ硰&H0A
	'@ # ˽硰&6
	'@ # ǰõĻҽʽ硰12.44
	'@ # Բŵ֣硰(34)
	'@ # ʽָ֣硰+2.1͡-2.1
	'@ # жŵַ硰12,25
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.IsNum("2011") '=> True
	'@ AB.C.PrintCn AB.C.IsNum("100.01") '=> False
	'@ ********************************************************************************

	Function IsNum(Byval s)
		On Error Resume Next
		'Rem IsNumericܴBug,!
		'IF Not IsNull(s) and Trim(s)<>"" Then:IsNum=IsNumeric(s):Else:IsNum=False:End IF
		Dim p : p = 0
		If p = 0 Then '(Чʸ)
			IsNum = RegTest(s, "^\d+$")
		Else
			Dim I,oStr:oStr=CStr(s)
			Dim b:b=True
			If IsNull(s) Or Trim(s)="" Then
				b = False
			Else
				For I=1 To Len(oStr)
					If Mid(oStr,I,1)>"9" or Mid(oStr,I,1)<"0" Then:b=False:Exit For:End If
				Next
			End If
			IsNum = b
		End If
		On Error Goto 0
	End Function

	'@ ********************************************************************************
	'@ AB.C.IsInt(s) жַǷ
	'@   :  Boolean (ֵ)
	'@   :  жϱǷ
	'==DESC============================================================================
	'@ [arg] s : ı
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.IsInt(2011) '=> True
	'@ AB.C.PrintCn AB.C.IsInt("2011") '=> False
	'@ ********************************************************************************

	Function IsInt(Byval s)
		Dim stype: stype = Lcase(TypeName(s))
		IF stype="integer" Or stype="long" Or stype="double" Or stype="single" Then
			IsInt = True
		Else
			IsInt = False
		End IF
	End Function

	'@ ********************************************************************************
	'@ AB.C.isStr(s) жǷΪַ
	'@   :  Boolean
	'@   :  жϱǷΪַ
	'==DESC============================================================================
	'@ [arg] s : ı
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.isStr("abcd") '=> True
	'@ ********************************************************************************

	Function isStr(Byval s)
		isStr = False
		If VarType(s) = vbString Then isStr = True
	End Function

	'@ ********************************************************************************
	'@ AB.C.IsBool(s) жǷΪֵ
	'@   :  Boolean
	'@   :  жϱǷΪֵ
	'==DESC============================================================================
	'@ [arg] s : ı
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.IsBool(False) '=> True
	'@ AB.C.PrintCn AB.C.IsBool(1 = 2) '=> True
	'@ AB.C.PrintCn AB.C.IsBool(0) '=> False
	'@ ********************************************************************************

	Function IsBool(Byval s)
		IsBool = False
		If VarType(s) = vbBoolean Then IsBool = True
	End Function

	'@ ********************************************************************************
	'@ AB.C.isDict(o) жǷΪ Dictionary ֵ
	'@   :  Boolean (ֵ)
	'@   :  жַǷΪ Dictionary ֵ
	'==DESC============================================================================
	'@ [arg] o : ַ
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.isDict(AB.Dict) '=> True
	'@ ********************************************************************************

	Function isDict(Byval o)
		isDict = False
		If IsObject(o) and TypeName(o) = "Dictionary" Then isDict = True
	End Function

	'@ ********************************************************************************
	'@ AB.C.CheckDict(dict1, dict2)
	'@   :  Boolean (ֵ)
	'@   :  жֵǷȣ dict1  dict2 ֵ򷵻 False
	'@ 			ע⣺ڸӵͿû취жô׼ȷ. ˷ο
	'==DESC============================================================================
	'@ [arg] dict1 : ֵ1
	'@ [arg] dict2 : ֵ2
	'==DEMO============================================================================
	'@ AB.C.PrintCn AB.C.CheckDict(AB.Dict, AB.DT) '=> True
	'@ Dim obj1, obj2
	'@ Set obj1 = AB.C.New(AB.dictName) 'ͬ Server.CreateObject("Scripting.Dictionary")
	'@ Set obj2 = AB.C.New(AB.dictName)
	'@ obj1("a") = "x" : obj1("b") = "y"
	'@ obj2("o") = "k"
	'@ AB.C.PrintCn AB.C.CheckDict(obj1, obj2) '=> False
	'@ ********************************************************************************

	Function CheckDict(Byval dict1, Byval dict2)
		On Error Resume Next
		If isDict(dict1) and isDict(dict2) Then
			If dict1.Count <> dict1.Count Then : CheckDict = False : Exit Function : End If
			Dim i,j
			For Each i In dict1
				If IsObject(dict1(i)) And IsObject(dict2(i)) Then
					If TypeName(dict1(i)) <> TypeName(dict2(i)) Then CheckDict = False : Exit Function : End If
					Select Case TypeName(dict1(i))
						Case "Recordset"
							If dict1(i).State <> dict2(i).State Then CheckDict = False : Exit Function : End If
							Dim e1, e2 : e1 = False : e2 = False
							If dict1(i).Bof And dict2(i).Eof Then e1 = True
							If dict1(i).Bof And dict2(i).Eof Then e2 = True
							If e1 <> e2 Then CheckDict = False : Exit Function : End If
							If dict1(i).Fields.Count <> dict2(i).Fields.Count Then CheckDict = False : Exit Function : End If
							dict1(i).MoveFirst : dict2(i).MoveFirst
							While Not dict1(i).Eof
								For j = 0 To dict1(i).Fields.Count-1
									If dict1(i).Fields(j).Name <> dict2(i).Fields(j).Name Then CheckDict = False : Exit Function : End If
									If dict1(i).Fields(j).value <> dict2(i).Fields(j).value Then CheckDict = False : Exit Function : End If
								Next
								dict1(i).MoveNext : dict2(i).MoveNext
							Wend
						Case "Dictionary"
							If dict1(i).Count <> dict2(i).Count Then CheckDict = False : Exit Function : End If
							If Not CheckDict(dict1(i), dict2(i)) Then
								CheckDict = False : Exit Function
							End If
						Case "Nothing","Empty"
							'
						Case Else 'һӵݲô
							'
					End Select
				ElseIf Not IsObject(dict1(i)) And IsObject(dict2(i)) Then
					CheckDict = False : Exit Function
				ElseIf IsObject(dict1(i)) And Not IsObject(dict2(i)) Then
					CheckDict = False : Exit Function
				Else
					If dict1(i) <> dict2(i) Then
						CheckDict = False : Exit Function
					End If
				End If
			Next
			CheckDict = True
		Else
			CheckDict = False
		End If
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.C.Dict()
	'# @syntax: Set d = AB.C.Dict()
	'# @return: [Dictionary Object] (ֵ)
	'# @dowhat: ֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param d: [variant] ()
	'--DEMO------------------------------------------------------------------------------------
	'# dim d
	'# Set d = AB.C.Dict()
	'# d.add "a", "ֵa"
	'# d.add "b", "ֵb"
	'# AB.Trace d
	'------------------------------------------------------------------------------------------

	Public Function Dict() 'ֵ
		Dim d : Set d = Server.CreateObject(s_dict) : d.CompareMode = 1
		Set Dict = d
		Set d = Nothing
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.C.SetDict()
	'# @syntax: AB.C.SetDict dict, key, value
	'# @return: [Dictionary Object] (ֵ)
	'# @dowhat: ֵֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param dict: [Dictionary Object] (ֵ)
	'# @param key: [String] (ַ)
	'# @param value: [Any] (ֵ)
	'--DEMO------------------------------------------------------------------------------------
	'# dim dict
	'# Set dict = AB.C.Dict()
	'# dict("a") = "ֵa"
	'# dict("b") = "ֵb"
	'# AB.C.SetDict dict, "a", "ֵa"
	'# AB.C.SetDict dict, "c", "ֵc"
	'# AB.Trace dict
	'------------------------------------------------------------------------------------------

	Public Sub SetDict(ByRef o, ByVal s, ByVal v)
		If isDict(o) Then
			If o.Exists(s) Then
				If IsObject(v) Then Set o(s) = v Else o(s) = v
			Else
				o.Add s, v
			End If
		End If
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.C.CloneDict(o)
	'# @syntax: Set dict2 = AB.C.CloneDict(dict1)
	'# @return: [Dictionary Object] (ֵ)
	'# @dowhat: ¡ֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param dict1: [Any] (ֵ)
	'# @param dict2: [Dictionary Object] (ֵ)
	'--DEMO------------------------------------------------------------------------------------
	'# dim dict1 : Set dict1 = AB.C.Dict()
	'# dict1("a") = "ֵa"
	'# dict1("b") = "ֵb"
	'# dim dict2 : Set dict2 = AB.C.CloneDict(dict1)
	'# AB.Trace dict2
	'------------------------------------------------------------------------------------------

	Public Function CloneDict(ByVal o)
		On Error Resume Next
		Dim item, d
		Set d = Server.CreateObject(s_dict) : d.CompareMode = 1
		If isDict(o) Then
			For Each item In o
				If d.Exists(item) Then
					If IsObject(o(item)) Then Set d(item) = o(item) Else d(item) = o(item)
				Else
					d.Add item, o(item)
				End If
			Next
		End If
		Set CloneDict = d
		Set d = Nothing
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.C.ClearDict(o)
	'# @syntax: Set dict = AB.C.ClearDict(dict)  AB.C.SetDict dict
	'# @return: [Dictionary Object] (ֵ)
	'# @dowhat: ֵ()
	'--DESC------------------------------------------------------------------------------------
	'# @param dict: [Dictionary Object] (ֵ)
	'--DEMO------------------------------------------------------------------------------------
	'# dim dict
	'# Set dict = AB.C.Dict()
	'# dict("a") = "ֵa"
	'# dict("b") = "ֵb"
	'# 'Set dict = AB.C.ClearDict(dict)
	'# AB.C.ClearDict dict
	'# AB.Trace dict
	'------------------------------------------------------------------------------------------

	Public Function ClearDict(ByRef o)
		If isDict(o) Then
			o.RemoveAll()
			Set ClearDict = o
		End If
	End Function

	'@ ********************************************************************************
	'@ AB.C.isInstr() Ƿĳַ
	'@ : ضĳЩؼмǷĳؼ
	'@ author: Lajox; version: 1.0.0 (2011-08-22);
	'==DESC============================================================================
	'@ ˵:
	'@ t: ضĳЩؼ,(,)
	'@ s: ĳؼ
	'==DEMO============================================================================
	'@ ʾ:
	'@ AB.C.isInstr("hello,world,perfect", "world")
	'@ AB.C.isInstr("'ab','cd','efg'", "'cd'")
	'@ ********************************************************************************

	Public Function isInstr(Byval t, Byval s)
		Dim rt : rt = False
		Dim ta : ta = Replace(t & "", "|", ",")
		Dim I
		For I=0 To Ubound(Split(ta,","))
			IF Trim(s) = Split(ta,",")(I) Then:rt = True:Exit For:End IF
		Next
		isInstr = rt
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IIF condition, ifTrue, ifFalse
	'@   :  Anything (ֵ)
	'@ 			conditionʽΪ򷵻ifTrueֵΪ򷵻ifFalseֵ
	'@   :  ô˷ʱжϵ1еıʽǷΪ棬
	'@ 			Ϊ򷵻ص2ıʽеֵ
	'@ 			Ϊ򷵻ص3ıʽеֵ
	'@ 			If...Then...Else...End Ifһּд汾JavaScriptе a ? b : c ʽ
	'==DESC=====================================================================================
	'@ condition : Expression (ʽ)
	'@  һ͵ıʽ
	'@ 	1ֵַʽ True  False
	'@ 	    condition  Null condition Ϊ False
	'@ 	2 TypeOf objectname Is objecttype ıʽ
	'@ 	   objectname κζã objecttype κЧĶ͡
	'@ 	    objectname  objecttype ָһֶͣʽΪ TrueΪ False
	'@ ifTrue : Anything (ֵ)  condition Ϊ True ʱҪصֵ
	'@ ifFalse : Anything (ֵ)  condition Ϊ False ʱҪصֵ
	'==DEMO=====================================================================================
	'@ Result = AB.C.IIF(Instr("type","p")>0, "blue", "red")
	'@  Instr("type","p")ֵ0,ResultֵΪ"blue"֮Ϊ"red"
	'@ *****************************************************************************************

	Public Function IIF(ByVal Cn, ByVal T, ByVal F)
		If Cn Then
			IIF = T
		Else
			IIF = F
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IsNul object
	'@   :  object Ϊ򷵻True򷵻False
	'@   :  ô˷еıһֵ
	'@ 			objectΪNullֵֵ(Empty)(True)
	'@ 			objectΪַûаκݣ(True)
	'@ 			objectΪҴ˶ĿǰΪNothingEmpty(True)
	'@ 			objectΪûаκԪأ(True)
	'@ 			ؼ(False)
	'==DESC=====================================================================================
	'@  object : Array ()  Object (ASP)  String (ַ) ı
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function isNul(ByVal s)
		On Error Resume Next:IF Err.Number<>0 Then Err.Clear
		isNul = False
		Select Case VarType(s)
			Case vbEmpty, vbNull
				isNul = True : Exit Function
			Case vbString
				If s="" Then isNul = True : Exit Function
			Case vbObject
				Select Case TypeName(s)
					Case "Nothing","Empty"
						isNul = True : Exit Function
					Case "Recordset"
						If s.State = 0 Then isNul = True : Exit Function
						If s.Bof And s.Eof Then isNul = True : Exit Function
					Case "Dictionary"
						If s.Count = 0 Then isNul = True : Exit Function
				End Select
			Case vbArray,8194,8204,8209
				If Ubound(s)=-1 Then isNul = True : Exit Function
		End Select
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.TrimNul object
	'@   :  object Ϊջֻո򷵻True򷵻False
	'@   :  ô˷еıһֵ
	'@ 			objectΪNullֵֵ(Empty)(True)
	'@ 			objectΪַûаκݻֻпո(True)
	'@ 			objectΪҴ˶ĿǰΪNothingEmpty(True)
	'@ 			objectΪûаκԪأ(True)
	'@ 			objectΪֻһԪҸԪ:ûаκݻֻпո(True)
	'@ 			ؼ(False)
	'==DESC=====================================================================================
	'@  object : Array ()  Object (ASP)  String (ַ) ı
	'==DEMO=====================================================================================
	'@ AB.C.PrintCn TrimNul(" ") ' True
	'@ AB.C.PrintCn TrimNul(Null) ' True
	'@ AB.C.PrintCn TrimNul(array(" ")) ' True
	'@ AB.C.PrintCn TrimNul(array("", "")) ' False
	'@ *****************************************************************************************

	Public Function TrimNul(ByVal s)
		On Error Resume Next:IF Err.Number<>0 Then Err.Clear
		TrimNul = False
		Select Case VarType(s)
			Case vbEmpty, vbNull
				TrimNul = True : Exit Function
			Case vbString
				If Trim(s)="" Then TrimNul = True : Exit Function
			Case vbObject
				Select Case TypeName(s)
					Case "Nothing","Empty"
						TrimNul = True : Exit Function
					Case "Recordset"
						If s.State = 0 Then TrimNul = True : Exit Function
						If s.Bof And s.Eof Then TrimNul = True : Exit Function
					Case "Dictionary"
						If s.Count = 0 Then TrimNul = True : Exit Function
				End Select
			Case vbArray,8194,8204,8209
				If Ubound(s)=-1 Then TrimNul = True : Exit Function
				If Ubound(s)=0 Then
					If IsObject(s(0)) Or IsArray(s(0)) Then
						TrimNul = False
					ElseIf VarType(s(0))=vbEmpty Or VarType(s(0))=vbNull Then
						TrimNul = True
					ElseIf VarType(s(0))=vbString Then
						If Trim(s(0))="" Then TrimNul = True : Exit Function
					End If
				End If
		End Select
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Has object
	'@   :  Ϊ򷵻 True Ϊշ False
	'@   :  жϱǷΪգַ֧顢¼Dictionaryȶ
	'@ 			˷AB.C.IsNulǡ෴ԼǷΪգ
	'@ 			ַ顢¼Dictionaryȶ
	'==DESC=====================================================================================
	'@ [arg] object : Array ()  Recordset (¼)  String (ַ) # ı
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function Has(ByVal s)
		On Error Resume Next:Err.Clear
		Has = Not isNul(s)
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IfThen condition, ifTrue
	'@   :  "" (ַ)  Anything (ֵ)
	'@   :  ˷ΪAB.C.IIFʡ԰
	'@ 			ڷconditionΪʱķֵΪʱ򷵻ؿַ
	'==DESC=====================================================================================
	'@ [arg] condition : Expression (ʽ) жϵıʽ
	'@ [arg] ifTrue : Anything (ֵ) ʽķֵ
	'==DEMO=====================================================================================
	'@ AB.C.IfThen(72>=60,"") ͬ AB.C.IIF(72>=60,"","")
	'@ *****************************************************************************************

	Public Function IfThen(ByVal Cn, ByVal T)
		IfThen = IIF(Cn,T,"")
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IfHas ResultA, ResultB
	'@   :  ResultA  ResultB
	'@   :  ˷ΪAB.C.IIFʡ԰
	'@ 			ResultAΪʱؽResultAResultAΪʱؽResultB
	'==DESC=====================================================================================
	'@ ResultA : ResultAΪʱؽResultA
	'@ ResultB : ResultAΪʱؽResultB
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function IfHas(ByVal v1, ByVal v2)
		IfHas = IIF(Has(v1), v1, v2)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.isFile filePath
	'@   :  ֵ(True/False)
	'@   :  жļǷ
	'==DESC=====================================================================================
	'@ filePath: ·Ҳ·
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function isFile(ByVal p)
		isFile = False
		If TypeName(o_fso)<>"FileSystemObject" Then Set o_fso = Server.CreateObject(AB.fsoName)
		If Mid(p,2,1)<>":" Then p = Server.MapPath(p)
		If o_fso.FileExists(p) Then isFile = True
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.isFolder folderPath
	'@   :  ֵ(True/False)
	'@   :  жļǷ
	'==DESC=====================================================================================
	'@ folderPath: ·Ҳ·
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function isFolder(ByVal p)
		isFolder = False
		If TypeName(o_fso)<>"FileSystemObject" Then Set o_fso = Server.CreateObject(AB.fsoName)
		If Mid(p,2,1)<>":" Then p = Server.MapPath(p)
		If o_fso.FolderExists(p) Then isFolder = True
	End Function

	'---------------------------------------------------------------------
	'# AB.C.Split(sText,sSplit)
	'# @return: Array ()
	'# @dowhat: ַָΪ,˷ԭSplitĲ
	'# 			ַָsSplitֵΪʱÿַɵ
	'# @author: Lajox; version: 1.0.0 (2012-04-21)
	'--DESC---------------------------------------------------------------
	'# @param sText [string] : ԭַ
	'# @param sSplit [string] : ַָ
	'--DEMO---------------------------------------------------------------
	'# AB.Trace AB.C.Split("a,b,c",",") 'أArray("a","b","c")
	'# AB.Trace AB.C.Split("abcd","") 'أArray("a","b","c","d")
	'#--------------------------------------------------------------------

	Public Function Split(Byval sText, Byval sSplit)
		On Error Resume Next
		AB.Use "H"
		Split = AB.H.Split(sText,sSplit)
		On Error Goto 0
	End Function

	'---------------------------------------------------------------------
	'# AB.C.RegSplit(sText, expSplit, p)
	'# @return: Array ()
	'# @dowhat: ַзָ 
	'--DESC---------------------------------------------------------------
	'# @param sText [string] : ԭַ
	'# @param expSplit [string] : ִ
	'# @param p [int] : ؽ:
	'# 					 p=0 ʱ;  ڵԪص 
	'# 					 p=1 ʱ;  ڵԪص 
	'--DEMO---------------------------------------------------------------
	'# AB.Trace AB.C.RegSplit("abc<>def=cgg==hi", "[\<>=]+", 0) ' Array("abc", "def", "cgg", "hi")
	'# AB.Trace AB.C.RegSplit("abc<>def=cgg==hi", "[\<>=]+", 1) ' Array("abc", "<>", "def", "=", "cgg", "==", "hi")
	'#--------------------------------------------------------------------

	Public Function RegSplit(ByVal sText, ByVal expSplit, ByVal p)
		On Error Resume Next
		Dim Match, str : str = sText
		Dim sp : sp = "#@ljx:split@#"
		If IsNull(p) Or Trim(p)="" Then p = 0
		If p = 1 Then
			Dim d : Set d = Server.CreateObject(s_dict) : d.CompareMode = 1
			Dim i : i = 0
			If IsDict(d) Then
				For Each Match in RegMatch(str,expSplit)
					d.add i, Match.value
					i = i + 1
				Next
				str = RegReplace(str, expSplit, sp)
				Dim b : b = Split(str, sp)
				Dim a, elem, j, k : j = 0 : k = 0 : a = Array()
				If IsArray(b) Then
					AB.Use "A"
					If AB.A.Len(b)=-1 Then
						'a = Array()
					ElseIf AB.A.Len(b)=0 Then
						a = AB.A.Push(a, b(0))
					Else
						AB.Use "A"
						For j=0 To UBound(b)
							If (j Mod 2) = 1 Then
								If d.Exists(k) Then
									a = AB.A.Push(a, d.Item(k))
									k = k + 1
								End If
								a = AB.A.Push(a, b(j))
							Else
								If j>0 Then
									If d.Exists(k) Then
										a = AB.A.Push(a, d.Item(k))
										k = k + 1
									End If
								End If
								a = AB.A.Push(a, b(j))
							End If
						Next
					End If
				End If
				Set d = Nothing
				RegSplit = a
			End If
		Else
			str = RegReplace(str, expSplit, sp)
			RegSplit = Split(str, sp)
		End If
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RP(Str, FindStr, RepStr)
	'@   :  [String]
	'@   :  ͨ滻(Replace)
	'  a.  FindStr  RepStr Ϊ飬ô ͨ滻, ͬ Replace(Str,FindStr,RepStr)
	'  b.  FindStr  RepStr Ϊ飬ô str_replace()  Str ߵӳ滻
	'  c.  RepStr ĸ FindStr ĸ滻ʹÿַС
	'  d.  FindStr һ RepStr һַô FindStr ÿԪص滻ʼʹַ
	'==DESC=====================================================================================
	'@ : Str ַ, FindStr ַ, RepStr Ҫ滻ַ
	'@ --ϵͳԴĳReplace(Str,FindStr,RepStr,1,-1,1)
	'@ --ڢܸ: ָӵڼַʼַ
	'@ --ڢݸ: 1ʾֻеһγʱ滻,
	'               -1ʾָÿһӴҪ滻
	'@ --ڢ޸: 1ַָıȽϲִСд
	'==DEMO=====================================================================================
	'@ AB.C.PrintCn AB.C.RP("abcd", "bc", "-") '=> "a-d"
	'@ AB.C.PrintCn AB.C.RP("abcd", array("b","c"), array("x","y")) '=> "axyd"
	'@ AB.C.PrintCn AB.C.RP("abcd", array("b","c"), array("x","y","z")) '=> "axyd"
	'@ AB.C.PrintCn AB.C.RP("abcd", array("b","c"), "-") '=> "a--d"
	'@ *****************************************************************************************

	Public Function RP(Byval Str, Byval FindStr, Byval RepStr)
		On Error Resume Next
		IF IsNull(Str) Or Str="" Then RP="":Exit Function
		If IsArray(FindStr) Then
			Dim i, x, y, m : i = 0 : m = Ubound(FindStr)
			If Err Then : Err.Clear : RP = Str : Exit Function : End If
			If m > 0 Then
				If IsArray(RepStr) Then
					Dim n : n = Ubound(RepStr)
					If Err Then : Err.Clear : RP = Str : Exit Function : End If
					If m >= n Then
						For i = 0 To n
							Str = Replace(Str, FindStr(i), RepStr(i))
						Next
						For i=n+1 To m
							Str = Replace(Str, FindStr(i), "")
						Next
					Else
						For i = 0 To m
							Str = Replace(Str, FindStr(i), RepStr(i))
						Next
					End If
				Else
					For i = 0 To m
						Str = Replace(Str, FindStr(i), RepStr)
					Next
				End If
				RP = Str
			End If
		Else
			If IsArray(RepStr) Then : RP = Str : Exit Function : End If
			'RP = Replace(Str,FindStr,RepStr,1,-1,1)
			RP = Replace(Str,FindStr,RepStr)
		End If
		If Err Then : Err.Clear : RP = Str : End If
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Include filePath
	'@   :  ޷ֵ
	'@   :  ˶̬ļ
	'==DESC=====================================================================================
	'@ filePathҪļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'@ ˷ʵASP˵Ķ̬ȫ滻ASP<!--#include ... -->ļķ
	'@ ҿԸж̬ԤκҳϢ
	'@ ˷ص㣺
	'@   1 - ֶ֧̬ASPHtmlTxtһıļ·;·ɣһԶִеASP䣨< % % >ڵĴ룩
	'@   2 - ֧޼ASPԭʼԤļ<!--#include ... -->Ҳ#includeе#include֧޼#includeҲԶ
	'@   3 - ԶʶASPԭʼԤļ<!--#include ... -->е·;·
	'@   4 - Զ˱ASPļԴгֵ@LANGUAGE@CODEPAGEOption ExplicitȻASPݡ
	'@ Ҫ벻ͬڵǰļĵ AB.CharSet ΪӦı͡
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub Include(ByVal filePath)
		On Error Resume Next
		AB.Pub.Include filePath
		On Error Goto 0
	End Sub

	Public Sub xInclude(ByVal filePath)
		On Error Resume Next
		IF Err.Number<>0 Then Err.Clear
		ExecuteGlobal AB.Pub.GetIncCode(IncRead(filePath),0)
		On Error Goto 0
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.GetInclude filePath
	'@   :  ˰ļеĽ
	'@   :  õ˰ļĽ
	'==DESC=====================================================================================
	'@ filePathҪļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'@ ˷ AB.C.Include ƣͬĵط : AB.C.IncludeHTMLʱֱ
	'@ ˷ὫļHTMLݷΪһַ
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function getInclude(ByVal filePath)
		On Error Resume Next
		ExecuteGlobal AB.Pub.GetIncCode(IncRead(filePath),1)
		getInclude = Abx_s_html
		If Err.Number<>0 Then
			AB.setError "(File Not Found: """ & filePath & """)", 1
		End If
		On Error Goto 0
	End Function

	Public Function IncRead(ByVal filePath)
		On Error Resume Next
		IncRead = AB.Pub.IncRead(filePath)
		On Error Goto 0
	End Function

	'@ ******************************************************************
	'@ :  AB.C.CLeft(s, m)
	'@   :  ĳֵַָ߲ # [String]
	'@   :  ȡĳַָ߲
	'==Param==============================================================
	'@ s :   ԭַ # [String]
	'@ m :   ָ # [String]
	'==DEMO==============================================================
	'@ AB.C.PrintCn AB.C.CLeft("hello:kitty_here", ":") 'ֵ: hello
	'@ AB.C.PrintCn AB.C.CLeft("hello:kitty_here", "_") 'ֵ: hello:kitty
	'@ ******************************************************************

	Public Function CLeft(ByVal s, ByVal m)
		CLeft = AB.Pub.LR(s,m,0)
	End Function

	'@ ******************************************************************
	'@ :  AB.C.CRight(s, m)
	'@   :  ĳָұֵַ߲ # [String]
	'@   :  ȡĳַָұ߲
	'==Param==============================================================
	'@ s :   ԭַ # [String]
	'@ m :   ָ # [String]
	'==DEMO==============================================================
	'@ AB.C.PrintCn AB.C.CRight("hello:kitty_here", ":") 'ֵ: kitty_here
	'@ AB.C.PrintCn AB.C.CRight("hello:kitty_here", "_") 'ֵ: here
	'@ ******************************************************************

	Public Function CRight(ByVal s, ByVal m)
		CRight = AB.Pub.LR(s,m,1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RegMatch string, rule
	'@   :  Set result = AB.C.RegMatch(string, rule)
	'@   :  Object (ASP), 񵽵ƥMatches
	'@   :  ʹô˷Զַев񣬷һMatchesϣ
	'@ 			ѭ˼ϣȻSubMatches϶ƥMatchв
	'==DESC=====================================================================================
	'@ string String (ַ) ַ
	'@ rule String (ַ) ʽ
	'@ result Variable () ֵصͽһMatches
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function RegMatch(ByVal s, ByVal rule)
		o_regex.Pattern = rule
		Set RegMatch = o_regex.Execute(s)
		o_regex.Pattern = ""
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RegReplace string, rule, result
	'@   :  滻ַ
	'@   :  Ѳstringеƥruleʽַ滻Ϊresultеֵ
	'==DESC=====================================================================================
	'@ string:  String (ַ) 滻ַ
	'@ rule:  	String (ַ) 滻ʽ
	'@ result:  String (ַ) Ҫ滻ΪĽ
	'==DEMO=====================================================================================
	'@ AB.C.RegReplace("Ǹʾabcd","a(bc)?d", "***")
	'@ ֵ: Ǹʾ***
	'@ *****************************************************************************************

	Public Function RegReplace(ByVal s, ByVal rule, Byval Result)
		RegReplace = AB.Pub.ReplaceX(s,rule,Result,0)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RegReplaceM string, rule, result
	'@   :  滻ַ
	'@   :  Ѳstringеƥruleʽַ滻Ϊresultеֵ
	'==DESC=====================================================================================
	'@ ˷ͬ AB.C.RegReplace һ£ΨһʽMultiline()Ϊ档
	'@ ڶģʽ£ʽÿһƥ^ʼ$ǡ
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function RegReplaceM(ByVal s, ByVal rule, Byval Result)
		RegReplaceM = AB.Pub.ReplaceX(s,rule,Result,1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RegTest string, rule
	'@   :  ֵ(TrueFalse)
	'@   :  ַǷʽ
	'==DESC=====================================================================================
	'@ [arg] string : Ҫַ
	'@ [arg] rule : ʽ
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function RegTest(ByVal s, ByVal p)
		If isNul(s) Then RegTest = False : Exit Function
		o_regex.Pattern = p
		RegTest = o_regex.Test(CStr(s))
		o_regex.Pattern = ""
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Test string, rule
	'@   :  Boolean (ֵ)
	'@   :  ָĹ֤stringĺϷ
	'@ 			֤ͨ򷵻(True)Ϸ򷵻ؼ(False)
	'==DESC=====================================================================================
	'@ string String (ַ) ַ֤
	'@ rule String (ַ) ʽҲַ
	'@   "date" - ֤ǷΪϷڸʽ
	'@   "idcard" - ֤ǷΪϷ֤
	'@   "english" - ֤ǷֻӢĸ
	'@   "chinese" - ֤Ƿַֻ
	'@   "int-en" - ֤ǷֻӢĺַ
	'@   "int-en-ch" - ֤ǷֻӢļַ
	'@   "username" - ֤ǷǺϷû4-20λֻǴСдĸּ»ĸͷ
	'@   "email" - ֤ǷǺϷE-mailַ
	'@   "int" - ֤ǷΪ
	'@   "number" - ֤ǷΪ
	'@   "double" - ֤ǷΪ˫
	'@   "price" - ֤ǷΪ۸ʽ
	'@   "zip" - ֤ǷΪϷʱ
	'@   "qq" - ֤ǷΪϷQQ
	'@   "phone" - ֤ǷΪϷĵ绰
	'@   "mobile" - ֤ǷΪϷֻ
	'@   "url" - ֤ǷΪϷURLַ
	'@   "ip" - ֤ǷΪϷIPַ
	'==DEMO=====================================================================================
	'@ AB.C.Test("2008-2-30 12:00","date")	'ֵ: True
	'@ AB.C.Test("M20","^\w[1-4][0-9]")	'ֵ: True
	'@ *****************************************************************************************

	Public Function [Test](ByVal s, ByVal p)
		Dim Pa
		Select Case Lcase(p)
			Case "date"			[Test] = isDate(s) : Exit Function
			'Case "idcard" 		Pa = "^\d{15}(\d{2}[A-Za-z0-9])?$"	'֤
			Case "idcard"		[Test] = isIDCard(s) : Exit Function '֤
			'Case "number"		Pa = "^\d+$" '
			Case "number"		[Test] = IsNum(s) : Exit Function
			Case "english"		Pa = "^[A-Za-z]+$" 'Ӣĸ
			Case "chinese"		Pa = "^[\u4e00-\u9fa5]+$" '
			Case "int-en"		Pa = "^[A-Za-z0-9]" 'Ӣĺ
			Case "int-en-ch" 	Pa = "^[A-Za-z0-9-\u2E80-\u9FA5]" 'Ӣļ
			Case "username"		Pa = "^[a-zA-Z]\w{2,19}$"
			'Case "email"		Pa = "^\w+([-+\.]\w+)*@\w+([-.]\w+)*\.\w+([-.]\w+)*$" '
			Case "email"		Pa = "^\w+([-+\.]\w+)*@(([\da-zA-Z][\da-zA-Z-]{0,61})?[\da-zA-Z]\.)+([a-zA-Z]{2,4}(?:\.[a-zA-Z]{2})?)$"
			Case "int"			Pa = "^[-\+]?\d+$" '
			Case "double"		Pa = "^[-\+]?\d+(\.\d+)?$" '
			Case "price"		Pa = "^\d+(\.\d+)?$"
			Case "zip"			Pa = "^\d{6}$" 'ʱ
			Case "qq"			Pa = "^[1-9]\d{4,9}$"
			'Case "phone"		Pa = "^((\(\d{3}\))|(\d{3}\-))?(\(0\d{2,3}\)|0\d{2,3}-)?[1-9]\d{6,7}$" 'Phone
			Case "phone"		Pa = "^((\(\+?\d{2,3}\))|(\+?\d{2,3}\-))?(\(0?\d{2,3}\)|0?\d{2,3}-)?[1-9]\d{4,7}(\-\d{1,4})?$"
			Case "mobile"		Pa = "^(\+?\d{2,3})?0?1(3\d|47|5\d|8[056789])\d{8}$" 'Mobile
			'Case "url"			Pa = "^(http|https|ftp):(\/\/|\\\\)(([\w\/\\\+\-~`@:%])+\.)+([\w\/\\\.\=\?\+\-~`@\':!%#]|(&amp;)|&)+" 'URLַ
			Case "url"			Pa = "^(?:(https|http|ftp|rtsp|mms)://(?:([\w!~\*'\(\).&=\+\$%-]+)(?::([\w!~\*'\(\).&=\+\$%-]+))?@)?)?((?:(?:(?:25[0-5]|2[0-4]\d|(?:1\d|[1-9])?\d)\.){3}(?:25[0-5]|2[0-4]\d|(?:1\d|[1-9])?\d))|(?:(?:(?:[\da-zA-Z][\da-zA-Z-]{0,61})?[\da-zA-Z]\.)+(?:[a-zA-Z]{2,4}(?:\.[a-zA-Z]{2})?)|localhost))(?::(\d{1,5}))?([#\?/].*)?$" 'URLַ
			Case "domain"		Pa = "^(([\da-zA-Z][\da-zA-Z-]{0,61})?[\da-zA-Z]\.)+([a-zA-Z]{2,4}(?:\.[a-zA-Z]{2})?)$"
			'Case "ip"			Pa = "^(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])\.(\d{1,2}|1\d\d|2[0-4]\d|25[0-5])$"	'IP
			Case "ip"			Pa = "^((25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)\.){3}(25[0-5]|2[0-4]\d|(1\d|[1-9])?\d)$"
			Case "key"			Pa = "^(([a-z]*|[a-z]*|\d*|[-_\~!@#\$%\^&\*\.\(\)\[\]\{\}<>\?\\\/\''\""]*)|.{0,5})$|\s"	'еַ
			Case "imgurl"		Pa = "^((http|https|ftp):(\/\/|\\\\)(([\w\/\\\+\-~`@:%])+\.)+([\w\/\\\.\=\?\+\-~`@\':!%#]|(&amp;)|&)+|\/([\w\/\\\.\=\?\+\-~`@\':!%#]|(&amp;)|&)+)\.(jpeg|jpg|gif|png|bmp)$"	'ͼƬַ
			Case "time" 		Pa = "^(?=\d)(?:(?!(?:1582(?:\.|-|\/)10(?:\.|-|\/)(?:0?[5-9]|1[0-4]))|(?:1752(?:\.|-|\/)0?9(?:\.|-|\/)(?:0?[3-9]|1[0-3])))(?=(?:(?!000[04]|(?:(?:1[^0-6]|[2468][^048]|[3579][^26])00))(?:(?:\d\d)(?:[02468][048]|[13579][26]))\d0?2\d29)|(?:\d{4}\d(?!(?:0?[2469]|11)\d31)(?!0?2(?:\.|-|\/)(?:29|30))))(\d{4})([-\/.])(0?\d|1[012])\2((?!00)[012]?\d|3[01])(?:$|(?=\x20\d)\x20))?((?:(?:0?[1-9]|1[012])(?::[0-5]\d){0,2}(?:\x20[aapp][mm]))|(?:[01]\d|2[0-3])(?::[0-5]\d){1,2})?$"	'ʱ
			Case "safe" 		Pa = "^[a-zA-Z0-9\_\-]+$"	'֡Сĸ»ߡ
			Case Else Pa = p
		End Select
		[Test] = RegTest(CStr(s),Pa)
	End Function

	'@ *************************************************************************************************
	'@ :  AB.C.Str string, array
	'@   :  Ϻַ
	'@   :  Խһӱֱַͨ۵ķʽ֡
	'@ 			stringа{1}{2}ռλ滻ΪarrayӦԪصֵ
	'@ 			һµַ
	'==DESC=============================================================================================
	'@ string  	: String (ַ) ռλַ
	'@ array	: Array () ռλʵֵ{1}Ӧĵ1ԪأԴ
	'==DEMO=============================================================================================
	'@ AB.C.Str("<{4}><a href=""/{2}.html"">{3}.{1}</a></{4}>",Array("һ","user/liyi","Miss","div"))
	'@ ֵ: <div><a href="/user/liyi.html">Miss.һ</a></div>
	'@ *************************************************************************************************

	Public Function Str(ByVal s, ByVal v)
		Str = FormatString(s, v, 1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.JS string
	'@   :  һ<script>ǩjavascript
	'@   :  һα׼javascriptƬϣ
	'==DESC=====================================================================================
	'@ string : String (ַ) javascript
	'==DEMO=====================================================================================
	'@ AB.C.JS "alert('ɾɹ');"
	'@ ֵ: AB.C.Print("<script type=""text/javascript"">alert('ɾɹ');</script>")
	'@ *****************************************************************************************

	Public Sub Js(ByVal s)
		Print JsCode(s)
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.JsCode String
	'@   :  һ<script>ǩjavascript
	'@   :  һα׼javascriptƬϣ
	'==DESC=====================================================================================
	'@ String :   javascript # [String]
	'==DEMO=====================================================================================
	'@ AB.C.JsCode("alert('hit me!');")
	'@ : <script type="text/javascript">alert('hit me!');</script>
	'@ *****************************************************************************************

	Public Function JsCode(ByVal s)
		JsCode = Str("<{1} type=""text/java{1}"">{2}{3}{4}{2}</{1}>{2}", Array("sc"&"ript",vbCrLf,vbTab,s))
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Alert string
	'@   :   javascript Ϣصһҳ
	'@   :  һjavascriptϢ򲢷ǰһҳ(history.back)
	'==DESC=====================================================================================
	'@ String :   ҪĵϢ # [String]
	'==DEMO=====================================================================================
	'@ AB.C.Alert "Ϣ"
	'@ : <script type="text/javascript">alert('Ϣ');history.go(-1);</script>
	'@ *****************************************************************************************

	Public Sub Alert(ByVal s)
		Print JsCode(Str("alert('{1}');history.go(-1);",JsEncode(s)))
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.MsgBox string
	'@   :  AB.C.JsAlert string
	'@   :   javascript Ϣ
	'@   :  һjavascriptϢ
	'==DESC=====================================================================================
	'@ String :   ҪĵϢ # [String]
	'==DEMO=====================================================================================
	'@ AB.C.MsgBox "Ϣ"
	'@ : <script type="text/javascript">alert('Ϣ');</script>
	'@ *****************************************************************************************

	Public Sub JsAlert(ByVal s)
		Print JsCode(Str("alert('{1}');",JsEncode(s)))
	End Sub
	Public Sub MsgBox(ByVal s)
		Print JsCode(Str("alert('{1}');",JsEncode(s)))
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.AlertUrl string, url
	'@   :  ޷ֵ
	'@   :  һjavascriptϢ򲢷ǰһҳ(history.back)
	'==DESC=====================================================================================
	'@ String	: ҪʾϢ # [String]
	'@ Url 		: ȷϢҪתҳַ # [String]
	'==DEMO=====================================================================================
	'@ AB.C.AlertUrl "Ϣ", "../info/add.asp"
	'@ : <script type="text/javascript">alert('Ϣ');location.href='../info/add.asp';</script>
	'@ *****************************************************************************************

	Public Sub AlertUrl(ByVal s, ByVal u)
		Print JsCode(Str("alert('{1}');location.href='{2}';",Array(JsEncode(s),u)))
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.ConfirmUrl string, okUrl, cancelUrl
	'@   :  ޷ֵ
	'@   :   javascript ȷϢ򲢸ѡתURL
	'==DESC=====================================================================================
	'@ string 		: String (ַ) : ҪʾѯϢ
	'@ okUrl 		: String (ַ) : ûѡȷϡҪתַ
	'@ cancelUrl 	: String (ַ) : ûѡȡҪתַ
	'==DEMO=====================================================================================
	'@ AB.C.ConfirmUrl "ӳɹҪ", "add.asp", "list.asp"
	'@ *****************************************************************************************

	Public Sub ConfirmUrl(ByVal s, ByVal t, ByVal f)
		Print JsCode(Str("location.href=confirm('{1}')?'{2}':'{3}';",Array(JsEncode(s),t,f)))
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.JsEncode String
	'@   :  תַ
	'@   :  һַеַתΪȫJavaScriptַ
	'==DESC=====================================================================================
	'@ String : תַ # [String]
	'==DEMO=====================================================================================
	'@ AB.C.JSEncode("The Path is : '\test\path'")
	'@ ֵ: The Path is : \'\\test\\path\'
	'@ *****************************************************************************************

	Public Function JsEncode(ByVal s)
		If isNul(s) Then JsEncode = "" : Exit Function
		Dim arr1, arr2, i, j, c, p, t
		arr1 = Array(&h27,&h22,&h5C,&h2F,&h08,&h0C,&h0A,&h0D,&h09)
		arr2 = Array(&h27,&h22,&h5C,&h2F,&h62,&h66,&h6E,&h72,&h749)
		For i = 1 To Len(s)
			p = True
			c = Mid(s, i, 1)
			For j = 0 To Ubound(arr1)
				If c = Chr(arr1(j)) Then
					t = t & "\" & Chr(arr2(j))
					p = False
					Exit For
				End If
			Next
			If p Then
				Dim a
				a = AscW(c)
				If a > 31 And a < 127 Then
					t = t & c
				ElseIf a > -1 Or a < 65535 Then
					t = t & "\u" & String(4 - Len(Hex(a)), "0") & Hex(a)
				End If
			End If
		Next
		JsEncode = t
	End Function

	'@ ******************************************************************
	'@ :  AB.C.ASCII String
	'@   :  String : "&"ͷַ
	'@   :  ַתΪ "&" ͷHTMLʵ
	'==DESC==============================================================
	'@ String : ԭַ # [String]
	'==DEMO==============================================================
	'@ AB.C.ASCII("I Like") 'ֵ: &#73;&#32;&#76;&#105;&#107;&#101;
	'@ ******************************************************************

	Public Function ASCII(s)
		If isNul(s) Then ASCII = "" : Exit Function
		Dim tmp,i,t
		For i = 1 To len(s)
			t = AscW(Mid(s,i,1))
			If t<0 Then t = t + 65536
			tmp = tmp & "&#" & t & ";"
		Next
		ASCII = tmp
	End Function

	'@ ******************************************************************
	'@ :  AB.C.RR url
	'@   :  ޷ֵ
	'@   :  URLת(Response.Redirectд)
	'==DESC==============================================================
	'@ url : תĵַ # [String]
	'==DEMO==============================================================
	'@ AB.C.RR "http://www.baidu.com/" ͬ Response.Redirect "http://www.baidu.com/"
	'@ ******************************************************************

	Public Sub RR(ByVal u)
		Response.Redirect(u)
	End Sub

	'@ ******************************************************************
	'@ :  AB.C.AddHeader HeaderName, HeaderText
	'@   :  ޷ֵ
	'@   :  һHTMLͷ(header)
	'==DESC==============================================================
	'@ HeaderName : ͷ # [String]
	'@ HeaderText : ͷʼֵ # [String]
	'==DEMO==============================================================
	'@ ļأָĬ:
	'@ AB.C.AddHeader "Content-Type", "application/x-msdownload"
	'@ AB.C.AddHeader "Content-Disposition", "attachment;filename=ļ.rar"
	'@ ˢҳ:
	'@ AB.C.AddHeader "refresh","3;url=http://www.baidu.com"
	'@ ******************************************************************

	Public Function AddHeader(s, p)
	    Response.AddHeader s, p
	End Function

	'@ ******************************************************************
	'@ :  AB.C.Redirect strURL, strT, strTip
	'@   :  ޷ֵ
	'@   :  ͨͷʵת
	'==DESC==============================================================
	'@ strURL : Ҫתĵַ # [String]
	'@ strT : תʱ # [String]
	'@ strTip : תʾ # [String]
	'==DEMO==============================================================
	'@ AB.C.Redirect "/index.asp",3,"ɹ"
	'@ AB.C.Redirect "http://www.baidu.com",0,""
	'@ ******************************************************************

	Public Function Redirect(strURL,strT,strTip)
		On Error Resume Next
		Dim T:IF CLng(strT)>0 Then T=CLng(strT)
		IF T>0 Then:T=CLng(T):Else:T=0:End IF
		Response.AddHeader "REFRESH",""&T&";url=" & strURL
		Pesponse.Clear
		IF Not IsNull(strTip) and strTip<>"" Then
			Print "<span style=""font-size:12px;"">"&strTip&"ת...</span>"
			Print "<span style=""font-size:12px;color:#888;"">&nbsp;"&T&"ûת<a href="""& strURL &""" style=""color:#0000ff;text-decoration:underline;""></a></span>"
		End IF
		Response.End()
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.NoCache()
	'@   :  ޷ֵ
	'@   :  ǿҳ治ĻС
	'@ 			´ηʴҳʱٴδӷȡǴ
	'==DESC=====================================================================================
	'@ ޲
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub NoCache()
		Response.Buffer = True
		Response.Expires = 0
		Response.ExpiresAbsolute = Now() - 1
		Response.CacheControl = "no-cache"
		Response.AddHeader "Expires",Date()
		Response.AddHeader "Pragma","no-cache"
		'Response.AddHeader "Cache-Control","no-cache,private, post-check=0, pre-check=0, max-age=0"
		Response.AddHeader "Cache-Control","private, no-cache, must-revalidate"
	End Sub

	'@ ******************************************************************
	'@ :  AB.C.CutStr string, charNumber[:separator]
	'@   :  ߽ȡַָ
	'@			ԶķŴδʾ # [String]
	'@   :  ȡַָĲ֣
	'@			ұʡԵĲָķţȱʡΪʡԺš
	'@			˫ַֽģ2ַ
	'==Param==============================================================
	'@ s 		: 	ȡַ # [String]
	'@ strLen 		: 	Ҫ( separator )
	'==DEMO==============================================================
	'@ AB.C.CutStr("This is a test ַ", 10) 'ֵ: This is 
	'@ AB.C.CutStr("This is a test ַ", "10:~~") 'ֵ: This is ~~
	'@ AB.C.CutStr("This is a test ַ", "17:") 'ֵ: This is a test 
	'@ ******************************************************************

	Function CutStr(ByVal s, ByVal strLen)
		If isNul(s) Then CutStr = "" : Exit Function
		Dim slen : slen = strLen
		If isNul(slen) or slen = "0" Then CutStr = s : Exit Function
		Dim lg,t,i,j,d,f,n
		s = Replace(s,vbCrLf,"")
		s = Replace(s,vbTab,"")
		lg = len(s) : t = 0 : d = ChrW(8230) : f = Abx_Param(slen)
		If Instr(slen,":")>0 Then
			d = IfHas(f(1),"")
		End If
		slen = Int(f(0)) : f = "" : n = 0
		For j = 1 To Len(d)
			n = IIF(Abs(Ascw(Mid(d,j,1)))>255, n+2, n+1)
		Next
		slen = slen - n
		For i = 1 to lg
			t = IIF(Abs(Ascw(Mid(s,i,1)))>255, t+2, t+1)
			If t >= slen Then
				f = Left(s,i) & d
				Exit For
			Else
				f = s
			End If
		Next
		CutStr = f
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.HtmlFormat String
	'@   :  ʽַ
	'@   :  ַеĻзͿո滻Ϊʾıǩ
	'@ 			HTMLǩ
	'==DESC=====================================================================================
	'@ String :   ʽHTMLı # [String]
	'==DEMO=====================================================================================
	'@ AB.C.HtmlFormat("һ<b></b>"&vbCrLf&"  <font color=""red"">ı</font>")
	'@ ֵ: һ<b></b>õ<br />&nbsp;&nbsp;<font color="red">ı</font>
	'@ *****************************************************************************************

	Function HtmlFormat(ByVal s)
		If Has(s) Then
			Dim m,Match : Set m = RegMatch(s, "<([^>]+)>")
			For Each Match In m
				 s = Replace(s, Match.SubMatches(0), regReplace(Match.SubMatches(0), "\s+", Chr(0)))
			Next
			Set m = Nothing
			s = Replace(s, Chr(32), "&nbsp;")
			s = Replace(s, Chr(9), "&nbsp;&nbsp; &nbsp;")
			s = Replace(s, Chr(0), " ")
			s = regReplace(s, "(<[^>]+>)\s+", "$1")
			s = Replace(s, vbCrLf, "<br />")
		End If
		HtmlFormat = s
	End Function

	'@ ******************************************************************
	'@ :  AB.C.HtmlEncode String
	'@   :  תhtmlַ
	'@   :  HTML뺯,еַԷĶHTMLʽʾ
	'==DESC==============================================================
	'@ String :   תַ # [String]
	'==DEMO==============================================================
	'@ AB.C.HtmlEncode("һ<b></b>֡" & vbCrLf & "лл")
	'@ ֵ: һ&lt;b&gt;&lt;/b&gt;֡<br />лл
	'@ ******************************************************************

	Function HtmlEncode(ByVal s)
		If Has(s) Then
			s = Replace(s, Chr(38), "&#38;")
			s = Replace(s, "<", "&lt;")
			s = Replace(s, ">", "&gt;")
			s = Replace(s, Chr(39), "&#39;")
			s = Replace(s, Chr(32), "&nbsp;")
			s = Replace(s, Chr(34), "&quot;")
			s = Replace(s, Chr(9), "&nbsp;&nbsp; &nbsp;")
			s = Replace(s, vbCrLf, "<br />")
		End If
		HtmlEncode = s
	End Function

	'@ ******************************************************************
	'@ :  AB.C.HtmlDecode String
	'@   :  ʶhtml
	'@   :  HTML뺯,ַеַתΪʶhtml
	'==DESC==============================================================
	'@ String :   תַ # [String]
	'==DEMO==============================================================
	'@ AB.C.HtmlDecode("һ&lt;em&gt;&lt;/em&gt;֡<br />лл")
	'@ ֵ: һ<em></em>֡<br />лл
	'@ ******************************************************************

	Function HtmlDecode(ByVal s)
		If Has(s) Then
			s = regReplace(s, "<br\s*/?\s*>", vbCrLf)
			s = Replace(s, "&nbsp;&nbsp; &nbsp;", Chr(9))
			s = Replace(s, "&quot;", Chr(34))
			s = Replace(s, "&nbsp;", Chr(32))
			s = Replace(s, "&#39;", Chr(39))
			s = Replace(s, "&apos;", Chr(39))
			s = Replace(s, "&gt;", ">")
			s = Replace(s, "&lt;", "<")
			s = Replace(s, "&amp;", Chr(38))
			s = Replace(s, "&#38;", Chr(38))
		End If
		HtmlDecode = s
	End Function

	'@ ******************************************************************
	'@ :  AB.C.HtmlFilter String
	'@   :  ַ
	'@   :  ˲ַеHTMLǩشı
	'==DESC==============================================================
	'@ String :   ˵ַ # [String]
	'==DEMO==============================================================
	'@
	'@ ******************************************************************

	Function HtmlFilter(ByVal s)
		If Has(s) Then
			If isNul(s) Then HtmlFilter = "" : Exit Function
			s = regReplace(s,"<[^>]+>","")
			s = Replace(s, ">", "&gt;")
			s = Replace(s, "<", "&lt;")
		End If
		HtmlFilter = s
	End Function

	'@ ******************************************************************
	'@ :  AB.C.RegEncode String
	'@   :  ַʽ
	'@   :  ַʽĳַת
	'==DESC==============================================================
	'@ String :   ַ # [String]
	'==DEMO==============================================================
	'@
	'@ ******************************************************************

	Public Function RegEncode(ByVal s)
		Dim re,i
		re = Split("\,$,(,),*,+,.,[,?,^,{,|,:,<",",")
		For i = 0 To Ubound(re)
			s = Replace(s,re(i),"\"&re(i))
		Next
		RegEncode = s
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.SetCookie cooName[>keyName], cooValue, cooConfig
	'@   :  ޷ֵ
	'@   :  һCookiesֵ
	'@ 			˷һCookiesֵһCookiesϵֵָĴޡ·򼰰ȫѡ
	'==PARAMSafe=====================================================================================
	'@ cooName String (ַ)
	'@   CookiesCookiesϵ
	'@ keyName(ѡ) String (ַ)
	'@   Cookiesйؼֵ
	'@ cooValue "" (ַ)  String (ַ)
	'@   Cookiesֵ˲ΪգcooConfigֵָ
	'@ cooConfig Array ()  Boolean (ֵ)  Datetime (ʱ)  Integer ()  String (ַ)
	'@   CookiesĴޡ·򼰰ȫãöѡֵ
	'@   ֵʱֵ - CookiesĴޣ
	'@     ʱֵʾCookiesָʱʧЧ
	'@     ʾCookiesԴʱ䳤(ԷΪλ)
	'@     Ϊ0ʾCookiesرʱʧЧ
	'@   ַ - CookiesЧ
	'@   ·ַ - CookiesЧ·
	'@   ֵ - Cookiesİȫԡ
	'@    - ͬʱ4Cookiesѡ
	'==DEMO=====================================================================================
	'@ 'һ30ӺʧЧCookies
	'@ AB.C.SetCookie "MyServerIP", "192.168.0.1", 30
	'@ 'һ20099910ʧЧCookies
	'@ AB.C.SetCookie "MyServerIP", "192.168.0.1", "2009-9-9 10:00"
	'@ 'һambox.cnЧCookies
	'@ AB.C.SetCookie "UserId", "3568", "ambox.it"
	'@
	'@ Ȼöѡǲѡ
	'@ AB.C.SetCookie "AboxInfo", "", Array("/bbs",False)
	'@ AB.C.SetCookie "AboxInfo>userName", "lajox", Array("ambox.it","2009-2-28 23:59:59",True)
	'@ AB.C.SetCookie "AboxInfo>userLevel", 0, ""
	'@ '÷ͬĴͳCookiesʽ
	'@ Response.Cookies("AboxInfo").Path = "/bbs"
	'@ Response.Cookies("AboxInfo").Secure = False
	'@ Response.Cookies("AboxInfo")("userName") = "lajox"
	'@ Response.Cookies("AboxInfo").Expires = "2009-2-28 23:59:59"
	'@ Response.Cookies("AboxInfo").Domain = "ambox.it"
	'@ Response.Cookies("AboxInfo").Secure = True
	'@ Response.Cookies("AboxInfo")("userLevel") = 0
	'@ *****************************************************************************************

	Public Sub SetCookie(ByVal cooName, ByVal cooValue, ByVal cooCfg)
		Dim n,i,cExp,cDomain,cPath,cSecure
		If isArray(cooCfg) Then
			For i = 0 To Ubound(cooCfg)
				If isDate(cooCfg(i)) Then
					cExp = cDate(cooCfg(i))
				ElseIf RegTest(cooCfg(i),"int") Then
					If cooCfg(i)<>0 Then cExp = Now()+Int(cooCfg(i))/60/24
				ElseIf RegTest(cooCfg(i),"domain") or RegTest(cooCfg(i),"ip") Then
					cDomain = cooCfg(i)
				ElseIf Instr(cooCfg(i),"/")>0 Then
					cPath = cooCfg(i)
				ElseIf cooCfg(i)="True" or cooCfg(i)="False" Then
					cSecure = cooCfg(i)
				End If
			Next
		Else
			IF Not IsNull(cooCfg) and Trim(cooCfg)<>"" Then
				If isDate(cooCfg) Then
					cExp = cDate(cooCfg)
				ElseIf RegTest(cooCfg,"int") Then
					If cooCfg<>0 Then cExp = Now()+Int(cooCfg)/60/24
				ElseIf RegTest(cooCfg,"domain") or RegTest(cooCfg,"ip") Then
					cDomain = cooCfg
				ElseIf Instr(cooCfg,"/")>0 Then
					cPath = cooCfg
				ElseIf cooCfg = "True" or cooCfg = "False" Then
					cSecure = cooCfg
				End If
			End IF
		End If
		If Has(cooValue) Then
			If AB.CookieEncode Then
				AB.E.Use("Aes") : cooValue = AB.E.Aes.E(cooValue)
			End If
		End If
		If Instr(cooName,">")>0 Then
			n = CRight(cooName,">")
			cooName = CLeft(cooName,">")
			Response.Cookies(cooName)(n) = cooValue
		Else
			Response.Cookies(cooName) = cooValue
		End If
		If Has(cExp) Then Response.Cookies(cooName).Expires = cExp
		If Has(cDomain) Then Response.Cookies(cooName).Domain = cDomain
		If Has(cPath) Then Response.Cookies(cooName).Path = cPath
		If Has(cSecure) Then Response.Cookies(cooName).Secure = cSecure
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.Cookie name[>subName][:type[separator]][:default]
	'@   :  зָ򷵻飻ûзָ򷵻ؾַ
	'@   :  ȫȡһCookiesֵ
	'==PARAM=====================================================================================
	'@ name String (ַ)
	'@   ҪȡĲʡ൱ԭʼRequest.Cookies
	'@ subName(ѡ) String (ַ)
	'@   粻ʡԴ˲൱ȡRequest.Cookies(name)(subName)ֵ
	'@ type(ѡ) String (ַ)
	'@   ַ
	'@    "s"  - ʾnameַ͵ֵԶеĵ(')Ϊ˫('')
	'@    "n"  - ʾnameֵ͵ֵ֤ǷΪֵ
	'@    "d"  - ʾname͵ֵ֤ǷΪ
	'@    "na" - ʾnameֵ͵ֵname֤֣ᵯalert򲢷ǰҳ
	'@    "da" - ʾname͵ֵname֤ڣᵯalert򲢷ǰҳ
	'@    "ne" - ʾnameֵ͵ֵname֤֣׳ûϢ
	'@   "de" - ʾname͵ֵname֤ڣ׳ûϢ
	'@ separator(ѡ) String (ַ)
	'@   ɴַ()У粻ʡ name еֵһ
	'@ default(ѡ) String (ַ)
	'@    name Ϊջ type 鲻ֵ/Ҫ򸳸Ĭֵֵ
	'@
	'@ ˷ԷһİȫRequest.CookiesֵCookiesеĳһֵ
	'@ ƴSQLַע⡣
	'@ 뵽õδԭʼֵκβͿˡ
	'@  AB.CookieEncode Cookiesܣֻø÷ܻȡCookiesݡ
	'==DEMO=====================================================================================
	'@ Dim UserName, SitePath
	'@ UserName = AB.C.Cookie("UserName")    'ͬ Request.Cookies("UserName")
	'@ SitePath = AB.C.Cookie("MySite>Path") 'ͬ Request.Cookies("Mysite")("Path")
	'@ 'ͬʱ÷Ҳʹ AB.C.Get  AB.C.Post Ĳʽ磺
	'@ AB.C.Print AB.C.Cookie("MySite>MasterId:n:1")
	'@ *****************************************************************************************

	Public Function Cookie(ByVal s)
		Dim p,t,coo
		If Instr(s,">") > 0 Then
			p = CLeft(s,">")
			s = CRight(s,">")
		End If
		If Instr(s,":")>0 Then
			t = CRight(s,":")
			s = CLeft(s,":")
		End If
		If Has(p) And Has(s) Then
			If Response.Cookies(p).HasKeys Then
				coo = Request.Cookies(p)(s)
			End If
		ElseIf Has(s) Then
			coo = Request.Cookies(s)
		Else
			Cookie = "" : Exit Function
		End If
		If isNul(coo) Then Cookie = "": Exit Function
		If  AB.CookieEncode Then
			AB.E.Use("Aes") : coo = AB.E.Aes.D(coo)
		End If
		Cookie = Safe(coo,t)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Safe(name,type[separator][:default])
	'@   :  зָ򷵻飻ûзָ򷵻ؾַ
	'@ 			ֵݲͬ type ֵвͬĴ
	'@   :  ȫֵ
	'==Param====================================================================================
	'@
	'==DEMO=====================================================================================
	'@ AB.C.Safe("ַ'˵","s")
	'@ : ַ''˵
	'@ *****************************************************************************************

	Public Function Safe(ByVal s, ByVal t)
		Dim spl,d,l,li,i,tmp,arr() : l = False
		If Instr(t,":")>0 Then
			d = CRight(t,":") : t = CLeft(t,":")
		End If
		If Instr(",sa,da,na,se,de,ne,", "," & Left(LCase(t),2) & ",")>0 Then
			If Len(t)>2 Then
				spl = Mid(t,3) : t = LCase(Left(t,2)) : l = True
			End If
		ElseIf Instr("sdn", Left(LCase(t),1))>0 Then
			If Len(t)>1 Then
				spl = Mid(t,2) : t = LCase(Left(t,1)) : l = True
			End If
		ElseIf Has(t) Then
			spl = t : t = "" : l = True
		End If
		li = Split(s,spl)
		If l Then Redim arr(Ubound(li))
		For i = 0 To Ubound(li)
			If i<>0 Then tmp = tmp & spl
			Select Case t
				Case "s","sa","se"
					If isNul(li(i)) Then li(i) = d
					tmp = tmp & Replace(li(i),"'","''")
					If l Then arr(i) = Replace(li(i),"'","''")
				Case "d","da","de"
					If t = "da" Then
						If Not isDate(li(i)) And Has(li(i)) Then Alert("ȷֵ")
					ElseIf t = "de" Then
						If Not isDate(li(i)) And Has(li(i)) Then [Error].Throw("ȷֵ")
					End If
					tmp = IIF(isDate(li(i)), tmp & li(i), tmp & d)
					If l Then arr(i) = IIF(isDate(li(i)), li(i), d)
				Case "n","na","ne"
					If t = "na" Then
						If Not isNumeric(li(i)) And Has(li(i)) Then Alert("ȷֵ")
					ElseIf t = "ne" Then
						If Not isNumeric(li(i)) And Has(li(i)) Then [Error].Throw("ȷֵ")
					End If
					tmp = IIF(isNumeric(li(i)), tmp & li(i), tmp & d)
					If l Then arr(i) = IIF(isNumeric(li(i)), li(i), d)
				Case Else
					tmp = IIF(isNul(li(i)), tmp & d, tmp & li(i))
					If l Then arr(i) = IIF(isNul(li(i)), d, li(i))
			End Select
			If l Then
				If isNul(arr(i)) Then arr(i) = Empty
			End If
		Next
		If isNul(tmp) Then tmp = Empty
		Safe = IIF(l,arr,tmp)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RemoveCookie cookieName[:keyName]
	'@   :  ޷ֵ
	'@   :  ɾһCookiesֵ
	'==PARAM=====================================================================================
	'@ cookieName String (ַ)
	'@   ҪɾCookiesCookiesϵ
	'@ keyName(ѡ) String (ַ)
	'@   ҪɾCookiesйؼ
	'@ ɾһָƵCookiesֵ
	'@ keyNameΪcookieNameһϣֻɾCookiesӦĹؼֵ
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub RemoveCookie(ByVal s)
		Dim p,t
		If Instr(s,">") > 0 Then
			p = CLeft(s,">")
			s = CRight(s,">")
		End If
		If Has(p) And Has(s) Then
			If Response.Cookies(p).HasKeys Then
				Response.Cookies(p)(s) = Empty
			End If
		ElseIf Has(s) Then
			Response.Cookies(s) = Empty
			Response.Cookies(s).Expires = Now()
		End If
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.SetApp appName, appData
	'@   :  void
	'@   :  ɾһCookiesֵ
	'==PARAM=====================================================================================
	'@ appName String (ַ)
	'@   
	'@ appData Anything (ֵ)
	'@   
	'@ ô˷һ¼ֵ
	'@ ((Application)һûɷʵȫֱеûͬSession)
	'==DEMO=====================================================================================
	'@ Dim rs
	'@ Set rs = AB.db.GetRecord("Users:Count(UID)","Online = 1","")
	'@ AB.C.SetApp "OnlineCount", rs(0)
	'@ AB.db.C(rs)
	'@ *****************************************************************************************

	Public Sub SetApp(ByVal AppName,ByRef AppData)
		Application.Lock
		If IsObject(AppData) Then
			Set Application(AppName) = AppData
		Else
			Application(AppName) = AppData
		End If
		Application.UnLock
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.GetApp appName
	'@   :  Object (ASP) ĿֵκοԴ뻺ͣ
	'@   :  ȡһAppֵ
	'==PARAM=====================================================================================
	'@ appName : String (ַ) Ŀ
	'@ ˷һָƵĻ(Application)Ŀֵ
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function GetApp(ByVal AppName)
		If isNul(AppName) Then GetApp = Empty : Exit Function
		If IsObject(Application(AppName)) Then
			Set GetApp = Application(AppName)
		Else
			GetApp = Application(AppName)
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RemoveApp appName
	'@   :  void
	'@   :  ɾһAppֵ
	'==PARAM=====================================================================================
	'@ appName : String (ַ) ҪɾApplication
	'@ ˷ɾһָƵĻ¼
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub RemoveApp(ByVal AppName)
		Application.Lock
		Application(AppName) = Empty
		Application.UnLock
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.RemoveAppAll
	'@   :  void
	'@   :  ɾAppֵ
	'==PARAM=====================================================================================
	'@ none
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Sub RemoveAppAll()
        Application.Lock
        Application.Contents.RemoveAll()
        Application.UnLock
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.Rand(s,p)
	'@   :  ȡ
	'@   :  ڻȡ
	'==PARAM=====================================================================================
	'@ s : pΪ(p>s)ʱ, sʾС, pʾs ~ p֮䶯
	'@ p : pΪַʱʾԶݣsʾλ
	'==DEMO=====================================================================================
	'@ AB.C.Print AB.C.Rand(8,"") '8λַ
	'@ AB.C.Print AB.C.Rand(8,"0123456789") '8λ
	'@ AB.C.Print AB.C.Rand(1,99) '1~99֮
	'@ *****************************************************************************************

	Public Function Rand(ByVal s, ByVal p)
		If IsNum(s) and IsNum(p) Then
			Dim min,max : min = s : max = p
			Randomize(Timer) : Rand = Int((max - min + 1) * Rnd + min)
		Else
			Dim length,allowStr : length = s : allowStr = p
			If isNul(allowStr) Then allowStr = "0123456789abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ"
			Dim i
			For i = 1 To length
				Randomize(Timer) : Rand = Rand & Mid(allowStr, Int(Len(allowStr) * Rnd + 1), 1)
			Next
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RandStr charNumber[:range] | min-max | string[:range]
	'@   :  ʽַ
	'@   :  ַеĻзͿո滻Ϊʾıǩ
	'@ 			HTMLǩ
	'==DESC=====================================================================================
	'@ charNumber : Integer () Ҫɵַĳ
	'@ range(ѡ) : String (ַ) ҪɵַַΧ
	'@ min : Integer () Сֵmaxʹ
	'@ max : Integer () ֵminʹ
	'@ string : String (ַ) ҪַǶַǶַ֣
	'@  - "<n>"ʾַҪַλ
	'@  - "<min-max>"ʾַҪֵֵСֵ
	'==DEMO=====================================================================================
	'@ AB.C.RandStr(12) 12λַ
	'@ AB.C.RandStr("100000-999999") 6λ
	'@ AB.C.RandStr("8:0123456789abcdefghijklmnopqrstuvwxyz~!@#$%^&*_-+=") ַ8λ
	'@ AB.C.RandStr("Random Color \: #<6>:0123456789ABCDEF") ַһ16ɫ
	'@ AB.C.RandStr("{<8>-<4>-<4>-<4>-<12>}:0123456789ABCDEF") һCLSID(ID)
	'@ AB.C.RandStr("CN-\<86\>-<6>-<10000-99999>") һԶİ̶벿ֵ
	'@ AB.C.RandStr("No.<1-2999>") һ3000ڵı
	'@ *****************************************************************************************

	Function RandStr(ByVal cfg)
		Dim a, p, l, t, reg, m, mi, ma
		cfg = Replace(Replace(Replace(cfg,"\<",Chr(0)),"\>",Chr(1)),"\:",Chr(2))
		a = ""
		If Test(cfg, "(<\d+>|<\d+-\d+>)") Then
			t = cfg
			p = Abx_Param(cfg)
			If Not isNul(p(1)) Then
				a = p(1) : t = p(0) : p = ""
			End If
			Set reg = RegMatch(cfg, "(<\d+>|<\d+-\d+>)")
			For Each m In reg
				p = m.SubMatches(0)
				l = Mid(p,2,Len(p)-2)
				If Test(l,"^\d+$") Then
					t = Replace(t,p,Rand(l,a),1,1)
				Else
					mi = CLeft(l,"-")
					ma = CRight(l,"-")
					t =  Replace(t,p,Rand(mi, ma),1,1)
				End If
			Next
			Set reg = Nothing
		ElseIf Test(cfg,"^\d+-\d+$") Then
			mi = CLeft(cfg,"-")
			ma = CRight(cfg,"-")
			t = Rand(mi, ma)
		ElseIf Test(cfg, "^(\d+)|(\d+:.)$") Then
			l = cfg : p = Abx_Param(cfg)
			If Not isNul(p(1)) Then
				a = p(1) : l = p(0) : p = ""
			End If
			t = Rand(l, a)
		Else
			t = cfg
		End If
		RandStr = Replace(Replace(Replace(t,Chr(0),"<"),Chr(1),">"),Chr(2),":")
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.ServerVar(s)
	'@   :  AB.C.RqSv(s)
	'@   :  Request.ServerVariables(s)ļд
	'@   :  ȡ(ȡRequest.ServerVariablesϢ)
	'==PARAM=====================================================================================
	'@ s : String (ַ) 
	'==DEMO=====================================================================================
	'@ AB.C.ServerVar("URL") ͬ Request.ServerVariables("URL")
	'@ *****************************************************************************************

	'Request.ServerVariables()ļд
	Public Function ServerVar(ByVal s)
		ServerVar = Request.ServerVariables(s)
	End Function
	Public Function RqSv(ByVal s)
		RqSv = Request.ServerVariables(s)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Referer
	'@   :   Request.ServerVariables("HTTP_REFERER")ļд
	'@   :  ȡĸҳӹURL
	'==PARAM=====================================================================================
	'@ ޲
	'==DEMO=====================================================================================
	'@ AB.C.Referer => Request.ServerVariables("HTTP_REFER")
	'@ *****************************************************************************************

	Public Function Referer()
		Referer = Request.ServerVariables("HTTP_REFERER")
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.IsInstall objectName
	'@   :  Boolean (ֵ)
	'@   :  ǷѾװĳ
	'==DESC=====================================================================================
	'@ objectName : String (ַ) Ĺַ
	'==DEMO=====================================================================================
	'@ Dim msg
	'@ If AB.C.IsInstall("JMail.Message") Then
	'@     set msg = Server.CreateOBject("JMail.Message")
	'@ Else
	'@     AB.C.Print "δװJmail"
	'@ End If
	'@ *****************************************************************************************

	Function isInstall(Byval s)
		On Error Resume Next : Err.Clear()
		isInstall = False
		Dim obj : Set obj = Server.CreateObject(s)
		If Err.Number = 0 Then isInstall = True
		Set obj = Nothing : Err.Clear()
		On Error Goto 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.DateTime date, format|otherDate
	'@   :  ʽʱ
	'@   :  ˷԰һڻʱʽΪָĸʽ
	'@ 			format ִСд÷оСдĸֱظʾüλʾ
	'@ 			yyyyʾ2008mmʾ01
	'@ 			ԶĸʽַҪַҪǰϡ\ת塣
	'@ 			ڶҲһʱΪַ
	'@ 			˷ʱĲΪ ĳĳʱ֮ǰ  ĳĳʱ֮ 
	'@ 			磺24ǰ38Ӻ󡱡
	'@ 			ΪַʱʱĻ׼ʱΪʱҳ2ֱʾʱ䡣
	'==DESC=====================================================================================
	'@ date Datetime (ʱ) Ҫʽʱ
	'@ format String (ַ)
	'@ 		0-4֣ϵͳںʱʽͬvbScriptFormatDateTime
	'@ 		Ҳһַʱڸʽַ(¾ΪСд)
	'@ 		y - 
	'@ 		m - 
	'@ 		mmm - (Ӣ3λд)
	'@ 		mmmm - (Ӣ)
	'@ 		d - 
	'@ 		h - ʱ
	'@ 		i - 
	'@ 		s - 
	'@ 		w - ()
	'@ 		ww - (Ӣ)
	'@ 		www - (Ӣ3λд)
	'@ otherDate "" (ַ)  Datetime (ʱ)
	'@ 		ʽΪǰ򡰶ú󡱵Ļ׼ʱ
	'@ 		Ϊַ׼ʱΪڣNow()
	'@ 		ʱ2ֱʾΪʱǡ֮ǰ֮
	'==DEMO=====================================================================================
	'@ AB.C.DateTime(Cdate("2008-9-1 06:00:01"),"yymmddhʱiss w, \hello")
	'@ ֵ: 0809016ʱ001 , hello
	'@ "ϴ" & AB.C.DateTime(Cdate("2008-9-1 06:00:01"),Now())
	'@ ڵʱ2008-12-10, 򷵻ֵ: ϴ3ǰ
	'@ *****************************************************************************************

	Public Function DateTime(ByVal iTime, ByVal iFormat)
		If isNul(iTime) Then DateTime = "" : Exit Function
		If Not IsDate(iTime) Then DateTime = "Date Error" : Exit Function
		If Instr(",0,1,2,3,4,",","&iFormat&",")>0 Then DateTime = FormatDateTime(iTime,iFormat) : Exit Function
		Dim diffs,diffd,diffw,diffm,diffy,dire,before,pastTime
		Dim iYear, iMonth, iDay, iHour, iMinute, iSecond,iWeek,tWeek
		Dim iiYear, iiMonth, iiDay, iiHour, iiMinute, iiSecond,iiWeek
		Dim iiiWeek, iiiMonth, iiiiMonth
		Dim SpecialText, SpecialTextRe,i,t
		iYear = right(Year(iTime),2) : iMonth = Month(iTime) : iDay = Day(iTime)
		iHour = Hour(iTime) : iMinute = Minute(iTime) : iSecond = Second(iTime)
		iiYear = Year(iTime) : iiMonth = right("0"&Month(iTime),2)
		iiDay = right("0"&Day(iTime),2) : iiHour = right("0"&Hour(iTime),2)
		iiMinute = right("0"&Minute(iTime),2) : iiSecond = right("0"&Second(iTime),2)
		tWeek = Weekday(iTime)-1 : iWeek = Array("","һ","","","","","")
		If isDate(iFormat) or isNul(iFormat) Then
			If isNul(iFormat) Then : iFormat = Now() : pastTime = true : End If
			dire = "" : If DateDiff("s",iFormat,iTime)<0 Then : dire = "ǰ" : before = True : End If
			diffs = Abs(DateDiff("s",iFormat,iTime))
			diffd = Abs(DateDiff("d",iFormat,iTime))
			diffw = Abs(DateDiff("ww",iFormat,iTime))
			diffm = Abs(DateDiff("m",iFormat,iTime))
			diffy = Abs(DateDiff("yyyy",iFormat,iTime))
			If diffs < 60 Then DateTime = "ո" : Exit Function
			If diffs < 1800 Then DateTime = Int(diffs\60) & "" & dire : Exit Function
			If diffs < 2400 Then DateTime = "Сʱ"  & dire : Exit Function
			If diffs < 3600 Then DateTime = Int(diffs\60) & "" & dire : Exit Function
			If diffs < 259200 Then
				If diffd = 3 Then DateTime = "3" & dire & " " & iiHour & ":" & iiMinute : Exit Function
				If diffd = 2 Then DateTime = IIF(before,"ǰ "," ") & iiHour & ":" & iiMinute : Exit Function
				If diffd = 1 Then DateTime = IIF(before," "," ") & iiHour & ":" & iiMinute : Exit Function
				DateTime = Int(diffs\3600) & "Сʱ" & dire : Exit Function
			End If
			If diffd < 7 Then DateTime = diffd & "" & dire & " " & iiHour & ":" & iiMinute : Exit Function
			If diffd < 14 Then
				If diffw = 1 Then DateTime = IIF(before,"","") & iWeek(tWeek) & " " & iiHour & ":" & iiMinute : Exit Function
				If Not pastTime Then DateTime = diffd & "" & dire : Exit Function
			End If
			If Not pastTime Then
				If diffd < 31 Then
					If diffm = 2 Then DateTime = "2" & dire : Exit Function
					If diffm = 1 Then DateTime = IIF(before,"ϸ","¸") & iDay & "" : Exit Function
					DateTime = diffw & "" & dire : Exit Function
				End If
				If diffm < 36 Then
					If diffy = 3 Then DateTime = "3" & dire : Exit Function
					If diffy = 2 Then DateTime = IIF(before,"ǰ","") & iMonth & "" : Exit Function
					If diffy = 1 Then DateTime = IIF(before,"ȥ","") & iMonth & "" : Exit Function
					DateTime = diffm & "" & dire : Exit Function
				End If
				DateTime = diffy & "" & dire : Exit Function
			Else
				iFormat = "yyyy-mm-dd hh:ii"
			End If
		End If
		iiWeek = Array("Sunday","Monday","Tuesday","Wednesday","Thursday","Friday","Saturday")
		iiiWeek = Array("Sun","Mon","Tue","Wed","Thu","Fri","Sat")
		iiiMonth = Array("Jan","Feb","Mar","Apr","May","Jun","Jul","Aug","Sep","Oct","Nov","Dec")
		iiiiMonth = Array("January","February","March","April","May","June","July","August","September","October","November","December")
		SpecialText = Array("y","m","d","h","i","s","w")
		SpecialTextRe = Array(Chr(0),Chr(1),Chr(2),Chr(3),Chr(4),Chr(5),Chr(6))
		For i = 0 To 6 : iFormat = Replace(iFormat,"\"&SpecialText(i), SpecialTextRe(i)) : Next
		t = Replace(iFormat,"yyyy", iiYear) : t = Replace(t, "yyy", iiYear)
		t = Replace(t, "yy", iYear) : t = Replace(t, "y", iiYear)
		t = Replace(t, "mmmm", Replace(iiiiMonth(iMonth-1),"m",Chr(1))) : t = Replace(t, "mmm", iiiMonth(iMonth-1))
		t = Replace(t, "mm", iiMonth) : t = Replace(t, "m", iMonth)
		t = Replace(t, "dd", iiDay) : t = Replace(t, "d", iDay)
		t = Replace(t, "hh", iiHour) : t = Replace(t, "h", iHour)
		t = Replace(t, "ii", iiMinute) : t = Replace(t, "i", iMinute)
		t = Replace(t, "ss", iiSecond) : t = Replace(t, "s", iSecond)
		t = Replace(t, "www", iiiWeek(tWeek)) : t = Replace(t, "ww", iiWeek(tWeek))
		t = Replace(t, "w", iWeek(tWeek))
		For i = 0 To 6 : t = Replace(t, SpecialTextRe(i),SpecialText(i)) : Next
		DateTime = t
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Format stirng, obj
	'@   :  ַ滻ַ
	'@   :  ԰ѸִмĶַռλʽֵ滻ַУ
	'@ 			ܹܷڸַڱƴӡ
	'@ 			ͬʱռλжҪ滻ֵһЩ򵥵ĸʽ
	'@ 			 AB.C.Str ͬǣ˷ַռλ±0ʼ
	'==DESC=====================================================================================
	'@ stirng : String (ַ)
	'@   ռλַռλ{}ŰӲĲͬռλмֻơ
	'@   ռλ֣Ŵ0ʼʾһԪء
	'@   ַбͰ { ַҪ \{ ת塣
	'@ obj : Array ()  Object (ASP)  Recordset (¼)  String (ַ)
	'@  ڸʽռλԴͣ
	'@    ַ - ֻ滻 {0} ռλ
	'@     - 滻ռλе {} ΪӦԪأ
	'@    ¼(Recordset) - 滻ռλе {}  {} Ϊ¼Ӧֵ
	'@    ֵ(Dictinary) - 滻ռλе {} ΪֵжӦֵ
	'@    Match - 滻 {0} Ϊƥ䱾Ȼ {1} ʼ滻ռλеΪӦӼ(SubMatches)ֵ
	'@    SubMatches - 滻ռλе {} ΪжӦֵ
	'@    AspBox List - 滻ռλе {}  {Hash} ΪжӦֵ
	'==DEMO=====================================================================================
	'@ 'ַ
	'@   AB.C.Print AB.C.Format("This is a {0}.", "Text")
	'@ 'This is a Text
	'@
	'@ '
	'@   AB.C.Print AB.C.Format("name:{0}/sex:{1}/age:{2}", Array("Ertan", "Male", 38))
	'@ 'name:Ertan/sex:Male/age:38
	'@
	'@ 'ʽ¼ֵ
	'@ Dim rs
	'@ Set rs = AB.db.GR("Users:ID,Name,QQ,Mail","","")
	'@ While Not rs.EOF
	'@   'ʽ¼ʱռλֺ
	'@   AB.C.Print AB.C.Format("{0} / {1} / {qq} / {mail}",rs)
	'@   ' 10 / AlexFu / 8000121 / alex@alexfu.com
	'@   rs.MoveNext
	'@ Wend
	'@ AB.db.C(rs)
	'@
	'@ 'ʽDictionaryֵ
	'@ Dim d
	'@ Set d = CreateObject(AB.DictName)
	'@ d.Add "a","Athens"
	'@ d.Add "b","Belgrade"
	'@ d.Add "c","Cairo"
	'@ 'ʽֵʱֻ
	'@   AB.C.Print AB.C.Format("{a}/{c}",d)
	'@ ' Athens/Cairo
	'@ Set d = Nothing
	'@
	'@ 'ʽList
	'@ Dim list
	'@ Set list = AB.List.New
	'@ list.Hash = "name:Scott pwd:tiger age:39 job:CFO"
	'@ 'ʽlistʱ֣Hash
	'@   AB.C.Print AB.C.Format("{0} / {pwd} / {2} / {job}", list)
	'@ ' Scott / tiger / 39 / CFO
	'@ Set list = Nothing
	'@
	'@ 'ʽMatch
	'@ Dim s,m,match
	'@ s = "<em>Scott/Tiger</em><em>Smith/Cat</em>"
	'@ Set m = AB.C.RegMatch(s, "<em>(\w+)/(\w+)</em>")
	'@ For Each match In m
	'@   AB.C.Print AB.C.Format("{0} | {1}", match.SubMatches)
	'@   ' Scott | Tiger
	'@ Next
	'@ For Each match In m
	'@ 'ֱmatchΪ1ԪΪmatchֵ
	'@   AB.C.Print AB.C.Format("{0} &gt; {1} | {2}", match)
	'@   ' <em>Scott/Tiger</em> &gt; Scott | Tiger
	'@ Next
	'@ Set m = Nothing
	'@
	'@ 'ռλʹòʽ
	'@ Dim a
	'@ a = Array(.3453,2372291.876,-34.28,Now,"I'm Lajox")
	'@ 'Nʾʽ֣﷨Ϊ "N[,%(][]"Ϊѡ:
	'@ '("," - ǧλָ"%" - תΪٷֱȣ"(" - Ű - Сλ)
	'@   AB.C.Print AB.C.Format("{0:N} / {0:N3} / {0:N%2} / {1:N,} / {2:N(1}",a)
	'@ '0.3453 / 0.345 / 34.53% / 2,372,291.88 / (34.3)
	'@
	'@ 'Dʾʽڣ÷AB.C.DateTimeһ
	'@ 'UʾתΪдĸLʾתΪСдĸ
	'@   AB.C.Print AB.C.Format("{3:Dy-mm-dd} / {4:U} / {4:L}",a)
	'@ '2010-08-18/I'M Lajox/i'm lajox
	'@
	'@ 'EʾʹASPʽ%sֵеλãAB.Cķʡ AB.C. ǰ׺
	'@   AB.C.Print AB.C.Format("{4:ECLeft(%s,"" "")} / {3:EDateTime(%s,""w"")}",a)
	'@ 'I'm / 
	'@ *****************************************************************************************

	Public Function Format(ByVal s, ByVal v)
		Format = FormatString(s, v, 0)
	End Function

	'@ ******************************************************************
	'@ :  AB.C.GetUrl type|[:]hash
	'@   :  ҳUrlֵ # [String]
	'@   :  ȡǰļĵַ
	'==Param==============================================================
	'@ type "" (ַ)  Integer ()
	'@   ΪַʱرҳԵַҳHash
	'@   Ϊ0ʱرҳԵַҲҳHash
	'@   Ϊ1ʱرҳԵַҳHash
	'@   Ϊ2ʱرҳĿ¼Եַ
	'@ :(ѡ) String (ַ)
	'@   ַеðţʡԴ˲ʱڷصURIַй˵ǰļ
	'@ hash String (ַ)
 	'@   ,()Hashǰ-()ʱʾURIй˵˲ʾֻЩHash
	'@ ô˷رҳҳĵַ÷һݸòĲͬԷضֲͬĽ
	'@ ַбֻòƵHashֵUrlַ
	'@ Ҳô-ŵַбشЩƵHashֵ֮HashUrlַ
	'@ ӽ˵˷ĵ:
	'@ 籾ҳʵʵַΪ: http://www.ambox.cn:8080/news/index.asp?type=public&feed=on&page=23
	'@                          ؽ
	'@   AB.C.GetUrl("")             urlȫ
	'@   AB.C.GetUrl(-1)             http://www.ambox.cn:8080
	'@   AB.C.GetUrl(0)              /news/index.asp
	'@   AB.C.GetUrl(1)              /news/index.asp?type=public&feed=on&page=23
	'@   AB.C.GetUrl(2)              /news/
	'@   AB.C.GetUrl(3)              http://www.ambox.cn:8080/news/index.asp
	'@   AB.C.GetUrl(4)              index.asp?type=public&feed=on&page=23
	'@   AB.C.GetUrl(5)              index.asp
	'@   AB.C.GetUrl(6)              ?type=public&feed=on&page=23
	'@   AB.C.GetUrl("page")         /news/index.asp?page=23
	'@   AB.C.GetUrl("-page")        /news/index.asp?type=public&feed=on
	'@   AB.C.GetUrl(":")            /news/?type=public&feed=on&page=23
	'@   AB.C.GetUrl(":-feed,-page") /news/?type=public
	'==DEMO==============================================================
	'@ : ַ/product/edit/index.asp?action=save&page=3
	'@ AB.C.RR(AB.C.GetUrl(":-action")) ת /product/edit/?page=3
	'@ ******************************************************************

	Public Function GetUrl(ByVal param)
		Dim script_name,url,dir,self
		Dim out,qitem,qtemp,i,hasQS,qstring
		param = param & ""
		script_name = ServerVar("SCRIPT_NAME")
		url = script_name
		dir  = Left(script_name,InstrRev(script_name,"/"))
		self  = Mid(script_name, InstrRev(script_name,"/")+1, Len(script_name))
		Dim ustart,uport,host
		If ServerVar("HTTPS")="on" Then
			ustart = "https://"
			uport = IIF(Int(ServerVar("SERVER_PORT"))=443,"",":"&ServerVar("SERVER_PORT"))
		Else
			ustart = "http://"
			uport = IIF(Int(ServerVar("SERVER_PORT"))=80,"",":"&ServerVar("SERVER_PORT"))
		End If
		host = ustart & ServerVar("SERVER_NAME") & uport
		If isNul(param) or param = "-1" Then
			If isNul(param) Then
				url = host & script_name
			Else
				GetUrl = host : Exit Function
			End If
			If Has(s_rq) Then url = url & "?" & s_rq
			GetUrl = url : Exit Function
		End If
		If param = "0" Then : GetUrl = url : Exit Function
		If param = "2" Then : GetUrl = dir : Exit Function
		If param = "3" Then : GetUrl = host & script_name : Exit Function
		If param = "4" Then : GetUrl = self & IIF(Has(s_rq), "?"&s_rq, "") : Exit Function
		If param = "5" Then : GetUrl = self : Exit Function
		If param = "6" Then : GetUrl = IIF(Has(s_rq), "?"&s_rq, "") : Exit Function
		If InStr(param,":")>0 Then
			url = dir
			out = Mid(param,2)
			hasQS = IIF(isNul(out),0,1)
		Else
			out = param : hasQS = 1
		End If
		If Has(s_rq) Then
			If param="1" Or hasQS = 0 Then
				url = url & "?" & s_rq
			Else
				qtemp = "" : i = 0 : out = ","&out&","
				qstring = IIF(InStr(out,"-")>0,"Not InStr(out,"",-""&qitem&"","")>0","InStr(out,"",""&qitem&"","")>0")
				For Each qitem In Request.QueryString()
					If Eval(qstring) Then
						If i<>0 Then qtemp = qtemp & "&"
						qtemp = qtemp & qitem & "=" & Request.QueryString(qitem)
						i = i + 1
					End If
				Next
				If Has(qtemp) Then url = url & "?" & qtemp
			End If
		End If
		GetUrl = url
	End Function

	'@ ******************************************************************
	'@ :  AB.C.GetUrlWith [page:|:]type, newParam
	'@   :  ҳUrlֵ # [String]
	'@   :  ȡǰҳURLַ²
	'==Param==============================================================
	'@ page(ѡ) String (ַ)
	'@   Ҫתҳַ
	'@ :(ѡ) String (ַ)
	'@   ַеðţʡԴ˲ʱڷصURIַй˵ǰļ
	'@ type "" (ַ)  Integer ()
	'@   ΪַʱرҳԵַҳHash
	'@   Ϊ0ʱرҳԵַҲҳHash
	'@   Ϊ1ʱرҳԵַҳHash
	'@   Ϊ2ʱرҳĿ¼Եַ
	'@ newParam String (ַ)
	'@   UrlHashַĸʽ(a=1&b=2&c=no)
	'@
	'@ رҳҳĵַԭַµUrltype ÷ͬAB.C.GetUrlĲ÷ȫһ
	'@ ʡ page ᷵ page ָҳַµURL

	'@ 籾ҳʵʵַΪ: http://www.ambox.com/public/news/index.asp?type=public&feed=on&page=23
	'@  AB.C.Print AB.C.GetUrlWith("-feed,-page","page=4&feed=off")
	'@  ' /public/news/index.asp?type=public&page=4&feed=off
	'@  AB.C.Print AB.C.GetUrlWith("/public/list.asp:-feed,-page","page=4&feed=off")
	'@  ' /public/list.asp?type=public&page=4&feed=off
	'==DEMO==============================================================
	'@ : ַ/product/edit/index.asp?action=save&page=3
	'@ AB.C.RR(AB.C.GetUrlWith("list.asp:-action","info=ɹ"))
	'@ ת/product/edit/list.asp?page=3&info=ɹ
	'@ ******************************************************************

	Public Function GetUrlWith(ByVal p, ByVal v)
		Dim u,s,n
		s = IIF(p=-1,GetUrl(-1)&"/","")
		s = IIF(isNul(p),GetUrl(""),GetUrl(0))
		If Instr(p,":")>0 Then
			If Has(CLeft(p,":")) Then
				n = Cleft(p,":") : p = CRight(p,":")
			End If
		End If
		u = GetUrl(p)
		If Left(p,1)=":" Then s = Left(u,InstrRev(u,"/"))
		u = u & IfThen(Has(v),IIF(isNul(Mid(u,len(s)+1)),"?","&") & v)
		If Has(n) Then
			If Instr(u,"?")>0 Then
				u = n & Mid(u,Instr(u,"?"))
			Else
				u = n
			End If
		End If
		GetUrlWith = u
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.GetIp()
	'@   :  IPַ
	'@   :  ȡIPַ޷ȡ򷵻0.0.0.0
	'==DESC=====================================================================================
	'@ 
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function GetIP()
		Dim addr, x, y
		x = ServerVar("HTTP_X_FORWARDED_FOR")
		y = ServerVar("REMOTE_ADDR")
		addr = IIF(isNul(x) or LCase(x)="unknown",y,x)
		If InStr(addr,".")=0 Then addr = "0.0.0.0"
		GetIP = addr
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.RewriteRule rule, url
	'@   :  ޷ֵ
	'@   :  ñ׼ģʽAspBoxURLα̬
	'@ 			﷨URLдISAPI RewriteĹ
	'@ 			 url е $1/$2  rule еı顣
	'==DESC=====================================================================================
	'@ rule : String (ַ) дʽдԸ·ʼ
	'@ url : String (ַ) Ϣurlַ / ͷ
	'==DEMO=====================================================================================
	'@ 'д
	'@ AB.C.RewriteRule "/list/index\.asp\?(\w+)(-(\d+))?\.html", "/list/?type=$1&page=$3"
	'@ AB.C.Print "type: " & AB.C.Get("type:s")
	'@ AB.C.Print "page: " & AB.C.Get("page:n")
	'@
	'@ URLַ磺 http://www.test.com/list/?photo-3.html
	'@ Чͬڣ http://www.test.com/list/?type=photo&page=3
	'@ Ҳǣ type: photo page: 3
	'@ *****************************************************************************************

	Public Sub RewriteRule(ByVal s, ByVal u)
		If (Left(s,3)<>"^\/" And Left(s,2)<>"\/" And Left(s,2)<>"^/" And Left(s,1)<>"/") Or Left(u,1)<>"/" Then Exit Sub
		o_rwt.Add ("rule" & i_rule), Array(s,u)
		i_rule = i_rule + 1
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.Rewrite urlpage, rule, urlparam
	'@   :  ޷ֵ
	'@   :  ø߼ģʽEasyASPURLα̬
	'@ 			רURLдASPƣAspBoxα̬ǻ url ģ
	'@ 			רעдα̬д
	'@ 			rule  urlparam ǵURLӦϵٰӵ·Ϣ
	'==DESC=====================================================================================
	'@ urlpage : "" (ַ)  String (ַ)
	'@ ļ· | Ķļ·ÿļ / ͷ˲գʾǰļ
	'@ rule : String (ַ) дʽܰ·Ϣ
	'@ urlparam : String (ַ) urlϣַ
	'==DEMO=====================================================================================
	'@ д
	'@ AB.C.Rewrite "/list/index.asp", "(\w+)(-(\d+))?\.html", "type=$1&page=$3"
	'@ õǰҳ棬Խ1գ磺
	'@ AB.C.Rewrite "", "(\w+)(-(\d+))?\.html", "type=$1&page=$3"
	'@ AB.C.Print "type: " & AB.C.Get("type:s")
	'@ AB.C.Print "page: " & AB.C.Get("page:n")
	'@
	'@ URLַ磺 http://www.test.com/list/?photo-3.html
	'@ Чͬڣ http://www.test.com/list/?type=photo&page=3
	'@ Ҳǣ type: photo page: 3
	'@ *****************************************************************************************

	Public Sub Rewrite(ByVal p, ByVal s, Byval u)
		Dim rp,arr,i,rs,ru
		If Left(s,1) = "^" Then s = Mid(s,2)
		If Right(s,1) = "$" Then s = Left(s,Len(s)-1)
		If isNul(p) Then p = GetUrl(0)
		arr = Split(p,"|")
		For i = 0 To Ubound(arr)
			rp = RegEncode(arr(i))
			rs = "^" & rp & "\?" & s & "$"
			ru = arr(i) & "?" & u
			RewriteRule rs, ru
			rp = ""
		Next
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.isRewrite()
	'@   :  ǰurlַΪѾЧαַ̬ True򷵻 False
	'@   :  ˷صǰʵĵַǷѾЧUrlдĵַ
	'==DESC=====================================================================================
	'@ ޲
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Function isRewrite()
		Dim rule,i
		isRewrite = False
		If i_rule = 1 Then Exit Function
		If Has(o_rwt) Then
			s_url = GetUrl(1)
			For Each i In o_rwt
				rule = o_rwt(i)(0)
				If Test(s_url,rule) Then
					isRewrite = True
					s_rwtS = rule
					s_rwtU = CRight(o_rwt(i)(1),"?")
					Exit For
				End If
			Next
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Get name[:type[separator]][:default]
	'@   :  зָ򷵻飻ûзָ򷵻ؾַ
	'@ 			ֵݲͬ type ֵвͬĴ
	'@   :  ȫȡQueryStringֵ֧α̬ҳĻȡ
	'==DESC=====================================================================================
	'@ name String (ַ)
	'@     ҪȡĲʡ൱ԭʼRequest.QueryString
	'@ type(ѡ) String (ַ)
	'@   ַ
	'@    "s"  - ʾnameַ͵ֵԶеĵ(')Ϊ˫('')
	'@    "n"  - ʾnameֵ͵ֵ֤ǷΪֵ
	'@    "d"  - ʾname͵ֵ֤ǷΪ
	'@    "na" - ʾnameֵ͵ֵname֤֣ᵯalert򲢷ǰҳ
	'@    "da" - ʾname͵ֵname֤ڣᵯalert򲢷ǰҳ
	'@    "ne" - ʾnameֵ͵ֵname֤֣׳ûϢ
	'@    "de" - ʾname͵ֵname֤ڣ׳ûϢ
	'@ separator(ѡ) String (ַ)
	'@   nameɴַ()У粻ʡnameеֵһ
	'@ default(ѡ) String (ַ)
	'@   nameΪջtype鲻ֵ/Ҫ򸳸Ĭֵֵ
	'@
	'@ ˷ԷһİȫRequest.QueryStringֵƴSQLַע⡣
	'@ 뵽õδԭʼֵκβͿˡ
	'==DEMO=====================================================================================
	'@ AB.C.Get("username") ͬ Request.QueryString("username")
	'@ URL: /get.asp?name=Icecream's&birth=1983-9-23&fav=1,a,6,11
	'@ AB.C.Get("name") ' Icecream's
	'@ AB.C.Get("name:s") ' Icecream''s
	'@ AB.C.Get("birth:d") ' 1983-9-23
	'@ AB.C.Get("usertype:n:1")' 1ΪòڣﷵĬֵ1
	'@ AB.C.Get("fav:n,:0") ' Array(1,0,6,11), a֣Ĭֵ0
	'@ *****************************************************************************************

	Public Function [Get](Byval s)
		Dim tmp, i, arrQs, t
		If Instr(s,":")>0 Then
			t = CRight(s,":") : s = CLeft(s,":")
		End If
		If isRewrite Then
			arrQs = Split(s_rwtU,"&")
			For i = 0 To Ubound(arrQs)
				If s = CLeft(arrQs(i),"=") Then
					tmp = RegReplace(s_url,s_rwtS,CRight(arrQs(i),"="))
					Exit For
				End If
			Next
		Else
			tmp = Request.QueryString(s)
		End If
		[Get] = Safe(tmp,t)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Post name[:type[separator]][:default]
	'@   :  зָ򷵻飻ûзָ򷵻ؾַ
	'@ 			ֵݲͬ type ֵвͬĴ
	'@   :  ȫֵ
	'==Param====================================================================================
	'@ name String (ַ)
	'@   ҪȡĲʡ൱ԭʼRequest.Form
	'@ type(ѡ) String (ַ)
	'@   ַ
	'@    "s"  - ʾnameַ͵ֵԶеĵ(')Ϊ˫('')
	'@    "n"  - ʾnameֵ͵ֵ֤ǷΪֵ
	'@    "d"  - ʾname͵ֵ֤ǷΪ
	'@    "na" - ʾnameֵ͵ֵname֤֣ᵯalert򲢷ǰҳ
	'@    "da" - ʾname͵ֵname֤ڣᵯalert򲢷ǰҳ
	'@    "ne" - ʾnameֵ͵ֵname֤֣׳ûϢ
	'@    "de" - ʾname͵ֵname֤ڣ׳ûϢ
	'@ separator(ѡ) String (ַ)
	'@   nameɴַ()У粻ʡnameеֵһ
	'@ default(ѡ) String (ַ)
	'@   nameΪջtype鲻ֵ/Ҫ򸳸Ĭֵֵ
	'@
	'@ ô˷ԷһİȫRequest.Formֵ
	'@ ƴSQLַע⡣
	'@ 뵽õδԭʼֵκβͿˡ
	'==DEMO=====================================================================================
	'@ ͳ: Request.Form("username")
	'@ ǿ: AB.C.Post("username")
	'@ 'ınamevalueIcecream's
	'@ AB.C.Post("name")    ' Icecream's
	'@ AB.C.Post("name:s")  ' Icecream''s
	'@ 'ıbirthvalue1983-9-23
	'@ AB.C.Post("birth:d") ' 1983-9-23
	'@ 'ıusertypevalueǿգ
	'@ AB.C.Post("usertype:n:1")  ' 1ΪòڣﷵĬֵ1
	'@ 'иѡfavѡеĸѡvalueֱ1,4,6,11
	'@ AB.C.Post("fav:n, ") ' Array(1,4,6,11)
	'@ *****************************************************************************************

	Function Post(ByVal s)
		Dim t,tmp : tmp = ""
		If Instr(s,":")>0 Then
			t = CRight(s,":") : s = CLeft(s,":")
		End If
		Dim FormType
		If Has(Request.ServerVariables("HTTP_CONTENT_TYPE")) Then
			FormType = Split(Request.ServerVariables("HTTP_CONTENT_TYPE"), ";")(0)
		Else
			FormType = "notupload"
		End If
		If LCase(FormType) = "multipart/form-data" Then
			If Lcase(TypeName(upload)) = "cls_ab_upload" Then
				If upload.Form.Count>0 Then tmp = upload.Form(s)
			End If
		Else
			tmp = Request.Form(s)
		End If
		Post = Safe(tmp,t)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.CheckForm string, rule, require, emptyErrMsg|[emptyErrMsg:]ruleErrMsg
	'@   :  зָ򷵻飻ûзָ򷵻ؾַ
	'@ 			ֵݲͬ type ֵвͬĴ
	'@   :  ˼򵥱֤
	'==DESC=====================================================================================
	'@ string String (ַ)
	'@   ַ֤
	'@ rule "" (ַ)  String (ַ)
	'@   ֤򣬿ʽҲַ(ַ֤ǷΪգ˲)
	'@    "date" - ֤ǷΪϷڸʽ
	'@    "idcard" - ֤ǷΪϷ֤
	'@    "english" - ֤ǷֻӢĸ
	'@    "chinese" - ֤Ƿַֻ
	'@    "username" - ֤ǷǺϷû4-20λֻǴСдĸּ»ĸͷ
	'@    "email" - ֤ǷǺϷE-mailַ
	'@    "int" - ֤ǷΪ
	'@    "number" - ֤ǷΪ
	'@    "double" - ֤ǷΪ˫
	'@    "price" - ֤ǷΪ۸ʽ
	'@    "zip" - ֤ǷΪϷʱ
	'@    "qq" - ֤ǷΪϷQQ
	'@    "phone" - ֤ǷΪϷĵ绰
	'@    "mobile" - ֤ǷΪϷֻ
	'@    "url" - ֤ǷΪϷURLַ
	'@    "ip" - ֤ǷΪϷIPַ
	'@   Ҫͬʱ֤򣬿á||Ÿ
	'@ require Integer ()
	'@   ǷΪգ0ΪΪգ1ΪΪ
	'@ emptyErrMsg String (ַ)
	'@   òΪյ֤ΪյʾϢϢаð(:)Ҫȼ"\"ת塣
	'@   ruleErrMsgʱ˲ʡԡ
	'@ ruleErrMsg String (ַ)
	'@   ַ֤ϹʾϢ
	'==DEMO=====================================================================================
	'@ Dim UserName, UserPass, UserIdCard, UserEmail
	'@ UserName = AB.C.CheckForm(AB.C.Post("uname:s"),"username",1,"ԱΪգ:ЧĻԱ")
	'@ UserPass = AB.C.CheckForm(AB.C.Post("upass:s"),"",1,"벻Ϊգ")
	'@ UserIdCard = AB.C.CheckForm(AB.C.Post("uidcard:s"),"idcard",0,"ȷ֤룡")
	'@ UserEmail = AB.C.CheckForm(AB.C.Post("uemail:s"),"email",1,"䲻Ϊգ:ַЧ")
	'@ *****************************************************************************************

	Function CheckForm(ByVal s, ByVal Rule, ByVal Require, ByVal ErrMsg)
		Dim tmpMsg, Msg, i
		tmpMsg = Replace(ErrMsg,"\:",chr(0))
		Msg = IIF(Instr(tmpMsg,":")>0,Split(tmpMsg,":"),Array("ĿΪ",tmpMsg))
		If Require = 1 And isNul(s) Then
			If Instr(tmpMsg,":")>0 Then
				Alert Replace(Msg(0),chr(0),":") : Exit Function
			Else
				Alert Replace(tmpMsg,chr(0),":") : Exit Function
			End If
		End If
		If Not (Require = 0 And isNul(s)) Then
			If Left(Rule,1)=":" Then
				Dim pass,arrRule
				pass = False
				arrRule = Split(Mid(Rule,2),"||")
				For i = 0 To Ubound(arrRule)
					If Test(s,arrRule(i)) Then pass = True : Exit For
				Next
				If Not pass Then Alert(Replace(Msg(1),chr(0),":")) : Exit Function
			Else
				If Not Test(s,Rule) Then Alert(Replace(Msg(1),chr(0),":")) : Exit Function
			End If
		End If
		CheckForm = s
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.CheckDataFrom()
	'@   :  վύ(True)򷵻ؼ(False)
	'@   :  ǷվڱύؼĽ
	'==Desc====================================================================================
	'@ 
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Function CheckDataFrom()
		Dim v1, v2
		CheckDataFrom = False
		v1 = Lcase(Cstr(ServerVar("HTTP_REFERER")))
		v2 = Lcase(Cstr(ServerVar("SERVER_NAME")))
		v1 = Mid(v1,Instr(v1,"://")+3,len(v2))
		If v1 = v2 Then
			CheckDataFrom = True
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.CheckDataFromA()
	'@   :  ޲,޷ֵ
	'@   :  ˷Ƿվڱύ
	'@ 			ͬ AB.C.CheckDataFrom 
	'@ 			վύᵯϢֹվⲿύݣǰһҳ
	'==Desc====================================================================================
	'@ 
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Sub CheckDataFromA()
		If Not CheckDataFrom Then Alert "ֹվⲿύݣ"
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.C.ToNumber number, decimal
	'@   :  ֵ
	'@   :  ѲnumberеֵתΪָСλֵ
	'==DESC=====================================================================================
	'@ number : Float () ֵ
	'@ decimal : Integer () Сλ
	'==DEMO=====================================================================================
	'@ AB.C.toNumber(123.3144,2) ֵ: 123.31
	'@ *****************************************************************************************

	Public Function toNumber(ByVal n, ByVal d)
		toNumber = FormatNumber(n,d,-1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.ToPrice number
	'@   :  лҷŵֵ
	'@   :  ѲnumberеֵתΪлҷŵֵ
	'@ 			ֻҷȡڷѡ
	'==DESC=====================================================================================
	'@ number : Numeric (ֵ) лҷŵֵ
	'==DEMO=====================================================================================
	'@ AB.C.toPrice(123.3144) ֵ: 123.31
	'@ *****************************************************************************************

	Public Function toPrice(ByVal n)
		toPrice = FormatCurrency(n,2,-1,0,-1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.ToPercent number
	'@   :  İٷֱֵ
	'@   :  ѲnumberеֵתΪλСİٷֱʽ
	'==DESC=====================================================================================
	'@ number : Float () ֵ
	'==DEMO=====================================================================================
	'@ AB.C.toPercent(0.123144)  ֵ: 12.31%
	'@ *****************************************************************************************

	Public Function toPercent(ByVal n)
		toPercent = FormatPercent(n,2,-1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.GetImg String
	'@   :  ȡ<img>ǩSRCԲΪ
	'@   :  ȡַк<img>ǩSRCԴΪ
	'==DESC=====================================================================================
	'@ String : Ҫַ
	'==DEMO=====================================================================================
	'@ AB.C.Print AB.C.GetImg("abc<img src='http://www.baidu.com/search/img/logo.gif'>defg")(0)
	'@ : http://www.baidu.com/search/img/logo.gif
	'@ *****************************************************************************************

	Public Function GetImg(ByVal s)
		GetImg = GetImg__(s,0)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.GetImgTag String
	'@   :  ȡ<img>ǩ
	'@   :  ȡַƥ<img>ǩΪ
	'==DESC=====================================================================================
	'@ String : Ҫַ
	'==DEMO=====================================================================================
	'@ AB.C.Print AB.C.GetImgTag("abc<img src='http://www.baidu.com/search/img/logo.gif'>defg")(0)
	'@ : <img src='http://www.baidu.com/search/img/logo.gif'>
	'@ *****************************************************************************************

	Public Function GetImgTag(ByVal s)
		GetImgTag = GetImg__(s,1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.Fill String, Len, FillStr
	'@   :  ַﵽ趨ȣĻԭַ
	'@   :  StringַȲLenֵ趨FillStrֵʹܳȴﵽLenֵFillStrΪÿո
	'==DESC=====================================================================================
	'@ String : ԭַ
	'@ Len : Ƚַ
	'@ FillStr : ַΪʾÿո(nbsp;)
	'==DEMO=====================================================================================
	'@ NONE
	'@ *****************************************************************************************

	Function Fill(ByVal s, ByVal l, ByVal f)
		Dim le,i,tmp
		le = len(s)
		If AB.C.isNul(f) Then f = "&nbsp;"
		If le < l Then
			For i = 1 To l-le
				tmp = tmp & f
			Next
		End If
		Fill = s & tmp
	End Function

	'@ *****************************************************************************************
	'@ :  AB.C.GetScriptTime startTimer
	'@   :  űִеĺ
	'@   :  һָʱ俪ʼʱֹýűִʱ䣬ȷ
	'==DESC=====================================================================================
	'@ startTimer : Timer (ʱ) űʼʱ
	'==DEMO=====================================================================================
	'@ Dim start : start = Timer()
	'@ 'ҪʱĴ
	'@ AB.C.Print "űʱ"& AB.C.GetScriptTime(start) &""
	'@ *****************************************************************************************

	Public Function GetScriptTime(t)
		If IsNull(t) Or t&"" = "" Or t&"" = "0" Then t = Abx_Timer
		'GetScriptTime = FormatNumber((Timer()-t)*1000,3)
		GetScriptTime = FormatNumber((Timer()-t)*1000, 2, -1)
	End Function

	' ============== ¸ ===================

		Function ReplaceUrl(ByVal p, ByVal s)
			Dim arrQs,tmp
			If isRewrite Then
				arrQs = Split(s_rwtU,"&")
				For i = 0 To Ubound(arrQs)
					If p = CLeft(arrQs(i),"=") Then
						tmp = CRight(arrQs(i),"=")
						Exit For
					End If
				Next
				If Left(tmp,1) = "$" Then
					ReplaceUrl = ReplacePart(s_url, s_rwtS, tmp, s)
				End If
			Else
				ReplaceUrl = GetUrlWith("-" & p, p & "=" & s)
			End If
		End Function

		Private Function replacePart(ByVal txt, ByVal rule, ByVal part, ByVal replacement)
			If Not Test(txt, rule) Then
				replacePart = "[not match]"
				Exit Function
			End If
			Dim Match,i,j,ma,pos,uleft,ul
			i = Int(Mid(part,2))-1
			Set Match = RegMatch(txt,rule)(0)
			For j = 0 To Match.SubMatches.Count-1
				ma = Match.SubMatches(j)
				pos = Instr(txt,ma)
				If pos > 0 Then
					ul = Left(txt,pos-1)
					txt = Mid(txt,Len(ul)+1)
					If i = j Then
						replacePart = uleft & ul & Replace(txt,ma,replacement,pos-len(ul),1,0)
						Exit For
					End If
					uleft = uleft & ul & ma
					txt = Mid(txt, Len(ma)+1)
				End If
			Next
			Set Match = Nothing
		End Function

		Private Function FormatString(ByVal s, ByRef v, ByVal t)
			Dim i,n,k
			s = Replace(s,"\\",Chr(0))
			s = Replace(s,"\{",Chr(1))
			Select Case VarType(v)
				Case 8192,8194,8204,8209
					For i = 0 To Ubound(v)
						s = FormatReplace(s,i+t,v(i))
					Next
				Case 9
					Select Case TypeName(v)
						Case "Recordset"
							For i = 0 To v.Fields.Count - 1
								s = FormatReplace(s,i+t,v(i))
								s = FormatReplace(s,v.Fields.Item(i+t).Name,v(i))
							Next
						Case "Dictionary"
							For Each k In v
								s = FormatReplace(s,k,v(k))
							Next
						Case "Cls_AB_List"
							For i = 0 To v.End
								s = FormatReplace(s,i+t,v(i))
								s = FormatReplace(s,v.IndexHash(i),v(i))
							Next
						Case "ISubMatches", "SubMatches"
							For i = 0 To v.Count - 1
								s = FormatReplace(s,i+t,v(i))
							Next
					End Select
				Case 8
					Select Case TypeName(v)
						Case "IMatch2", "Match"
							s = FormatReplace(s,t,v.Value)
							For i = 0 To v.SubMatches.Count - 1
								s = FormatReplace(s,i+t+1,v.SubMatches(i))
							Next
						Case Else
							s = FormatReplace(s,t,v)
					End Select
				Case Else
					s = FormatReplace(s,t,v)
			End Select
			s = Replace(s,Chr(1),"{")
			FormatString = Replace(s,Chr(0),"\")
		End Function

		Private Function FormatReplace(ByVal s, ByVal t, ByVal v)
			Dim tmp,rule,ru,kind,matches,match
			v = IfHas(v,"")
			rule = "\{" & t & "(:((N[,\(%]?(\d+)?)|(D[^\}]+)|(E[^\}]+)|U|L))\}"
			If Test(s,rule) Then
				Set matches = RegMatch(s,rule)
				For Each match In matches
					kind = RegReplace(match.Value, rule, "$2")
					ru = "{"&t&":"&kind&"}"
					Select Case Left(kind,1)
						Case "N"
							If isNumeric(v) Then
								Dim style,group,parens,percent,deci
								style = RegReplace(kind,"N([,\(%])?(\d+)?","$1")
								If style = "," Then group = -1
								If style = "(" Then parens = -1
								If style = "%" Then percent = -1
								deci = RegReplace(kind,"N([,\(%])?(\d+)?","$2")
								If isNul(style) And isNul(deci) Then
									s = Replace(s, ru, IIF(Instr(Cstr(v),".")>0 And v<1,"0" & v,v),1,-1,1)
								Else
									deci = IfHas(deci,-1)
									If percent Then
										s = Replace(s, ru, FormatNumber(v*100,deci,-1) & "%",1,-1,1)
									Else
										s = Replace(s, ru, FormatNumber(v,deci,-1,parens,group),1,-1,1)
									End If
								End If
							End If
						Case "D"
							If isDate(v) Then
								s = Replace(s, ru, DateTime(v,Mid(kind,2)),1,-1,1)
							End If
						Case "U"
							s = Replace(s, ru, UCase(v),1,-1,1)
						Case "L"
							s = Replace(s, ru, LCase(v),1,-1,1)
						Case "E"
							tmp = Replace(Mid(kind,2),"%s", "v")
							tmp = Eval(tmp)
							s = Replace(s, ru, tmp,1,-1,1)
					End Select
				Next
			Else
				s = Replace(s,"{" & t & "}",v,1,-1,1)
			End If
			FormatReplace = s
		End Function

		Private Function isIDCard(ByVal s)
			Dim Ai, BirthDay, arrVerifyCode, Wi, i, AiPlusWi, modValue, strVerifyCode
			isIDCard = False
			If Len(s) <> 15 And Len(s) <> 18 Then Exit Function
			Ai = IIF(Len(s) = 18,Mid(s, 1, 17),Left(s, 6) & "19" & Mid(s, 7, 9))
			If Not IsNumeric(Ai) Then Exit Function
			If Not Test(Left(Ai,6),"^(1[1-5]|2[1-3]|3[1-7]|4[1-6]|5[0-4]|6[1-5]|8[12]|91)\d{2}[01238]\d{1}$") Then Exit Function
			BirthDay = Mid(Ai, 7, 4) & "-" & Mid(Ai, 11, 2) & "-" & Mid(Ai, 13, 2)
			If IsDate(BirthDay) Then
				If cDate(BirthDay) > Date() Or cDate(BirthDay) < cDate("1870-1-1") Then  Exit Function
			Else
				Exit Function
			End If
			arrVerifyCode = Split("1,0,x,9,8,7,6,5,4,3,2", ",")
			Wi = Split("7,9,10,5,8,4,2,1,6,3,7,9,10,5,8,4,2", ",")
			For i = 0 To 16
				AiPlusWi = AiPlusWi + CInt(Mid(Ai, i + 1, 1)) * Wi(i)
			Next
			modValue = AiPlusWi Mod 11
			strVerifyCode = arrVerifyCode(modValue)
			Ai = Ai & strVerifyCode
			If Len(s) = 18 And LCase(s) <> Ai Then Exit Function
			isIDCard = True
		End Function

		Private Function GetImg__(ByVal s, ByVal t)
			Dim a(), img, Matches, m, i : i = 0
			ReDim a(-1)
			img = "<img([^>]+?)(/?)>"
			If Has(s) And Test(s, img) Then
				s = Replace(s, vbCrLf, " ")
				s = Replace(s, vbTab, " ")
				Set Matches = AB.C.RegMatch(s, "(<img\s[^>]*src\s*=\s*([""|']?))([^""'>]+)(\2[^>]*>)")
				For Each m In Matches
					ReDim Preserve a(i)
					a(i) = AB.C.IIF(t=0,m.SubMatches(2),m.value)
					i = i + 1
				Next
			End If
			GetImg__ = a
		End Function

		Private Function Abx_Param(ByVal s)
			Dim arr(1),t : t = Instr(s,":")
			If t > 0 Then
				arr(0) = Left(s,t-1) : arr(1) = Mid(s,t+1)
			Else
				arr(0) = s : arr(1) = ""
			End If
			Abx_Param = arr
		End Function

End Class
%>