<%
'######################################################################
'## ab.cache.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Cache Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2013/02/05 10:56
'## Description :   Save and Get Cache With AspBox
'######################################################################

Class Cls_AB_Cache

	Public Items, CountEnabled, Expires, FileType
	Private s_path, b_fsoOn

	Private Sub Class_Initialize
		Set Items = Server.CreateObject(AB.dictName)
		s_path = Server.MapPath("/_cache") & "\"
		CountEnabled = True
		Expires = 5
		FileType = ".cache"
		AB.Error(91) = "ǰ浽ڴ滺"
		AB.Error(92) = "ݻļ"
		AB.Error(93) = "ǰݲ浽ļ"
		If TypeName(AB.Fso) = "Cls_AB_Fso" Then
			b_fsoOn = True
		Else
			AB.Use "Fso"
			b_fsoOn = False
		End If
	End Sub

	Private Sub Class_Terminate
		If Not b_fsoOn Then
			'Set AB.Fso = New Cls_AB_obj
			Set AB.Fso = Nothing
		End If
		Set Items = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.New 
	'# @syntax: Set myCacheObj = AB.Cache.New
	'# @return: Object (ASP)
	'# @dowhat: , һ AspBox_cache 
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# Ӵһ˻·
	'# Dim myCacheObj : Set myCacheObj = AB.Cache.New 	'
	'# myCacheObj.SavePath = "../pageCache/" 			'û·
	'------------------------------------------------------------------------------------------

	Public Function [New]()
		Set [New] = New Cls_AB_Cache
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Expires 
	'# @syntax: AB.Cache.Expires[ = time]
	'# @return: Datetime (ʱ)  Numeric (ֵ)
	'# 			Numeric(ֵ)ʾĴڣλΪӣDatetime(ʱ)ʾľʱ䡣
	'# @dowhat: ûʱ䣬Կɶд
	'# 			ͨ˷ûʱ䣬timeΪ0ʱʾڣĬΪ5ӡ
	'# 			÷Դ˴ıReadyĻЧ
	'# 			ҲԵΪĳùʱ䣬ʾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: time(ѡ) Datetime (ʱ)  Numeric (ֵ)
	'# Ĺʱ䣬ʹ÷ʾڣҲʹþʱù̶Ĺʱ䣬
	'# timeΪ0ʱʾڡ
	'--DEMO------------------------------------------------------------------------------------
	'# 'Ч
	'# AB.Cache.Expires = 60*24*14
	'# '"maya"20121222չ
	'# AB.Cache("maya").Expires = "2012-12-22"
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Cache.FileType 
	'# @syntax: AB.Cache.FileType[ = fileType]
	'# @return: String (ַ) ѯʱļĺ׺
	'# @dowhat: ڲѯļ汣Ϊļʱĺ׺ĬֵΪ.cacheҲԶԾ建ú׺
	'--DESC------------------------------------------------------------------------------------
	'# @param: fileType(ѡ) String (ַ) ļ׺ʽ".׺"
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache.FileType = ".tmp"
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test1").Save
	'# 'test1汣Ϊļ档ļĿ¼н.tmp׺ļ
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Count (ֻ)
	'# @syntax: count = AB.Cache.Count
	'# @return: Integer () صǰлAB.Cache.CountEnabled ΪFalseʱֵΪ-1
	'# @dowhat: ѯǰлֻ
	'# 			ֻڻԣAB.Cache.CountEnabled Ϊ True ʱͳƱĻ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Cache"
	'#
	'# 'ļ
	'# AB.Cache("test1")="1"
	'# AB.Cache("test1").Save
	'# AB.Cache("test2")="2"
	'# AB.Cache("test2").Save
	'#
	'# 'ѯ
	'# AB.C.PrintCn AB.Cache.Count '1
	'#
	'# 'ͳƻ
	'# AB.Cache.CountEnabled = False
	'# AB.C.PrintCn AB.Cache.Count '-1
	'------------------------------------------------------------------------------------------

	Public Property Get Count
		Count = AB.C.IIF(CountEnabled,AB_Cache_Count,-1)
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Cache.SavePath 
	'# @syntax: AB.Cache.FileType[ = fielType]
	'# @return: String (ַ) ѯʱش洢ļĿ¼ľ·
	'# @dowhat: ļվϵĴ洢Ŀ¼Կɶд
	'# ļǻһ͡úͲѯļ洢Ŀ¼ôԣĬΪ"/_cache"
	'--DESC------------------------------------------------------------------------------------
	'# @param: path(ѡ) String (ַ)
	'# ѡļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# ĬΪվĿ¼µ_cacheĿ¼
	'--DEMO------------------------------------------------------------------------------------
	'# 'ļ洢Ŀ¼
	'# AB.Use "Cache"
	'# AB.cache.SavePath = "/myCache"
	'# 'ȡļ洢Ŀ¼
	'# Dim path: path = AB.cache.SavePath
	'# AB.C.Print path 'Ľ(վ·D:\Web\)ǣ D:\Web\myCache\
	'------------------------------------------------------------------------------------------

	Public Property Let SavePath(ByVal s)
		If Not Instr(s,":") = 2 Then s = Server.MapPath(s)
		If Right(s,1) <> "\" Then s = s & "\"
		s_path = s
	End Property

	Public Property Get SavePath()
		SavePath = s_path
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Item 
	'# @syntax: AB.Cache.Item(cacheName)[ = value]
	'# @alias:  AB.Cache(cacheName)[ = value]
	'# @return: Object (ASP)  Recordset (¼)  String (ַ)
	'# 			ļʱֵ/ΪString(ַ)ͻRecordset(¼)ʹڴ滺ʱοAB.C.SetApp
	'# @dowhat: 洢ȡػ
	'# ʹ2ַʽ滺棺
	'# 1.ļ棬ֵΪļĿǰ֧String(ַ)ͺRecordset(¼)൱Recordset.Save
	'# 洢Ϊ: AB.Cache("CacheName").Save  AB.Cache.SaveAll
	'# 2.ڴ滺棬汣浽ڴ棬οAB.C.SetAppڴ滺 Recordset ʱԶתΪ顣
	'# 洢Ϊ: AB.Cache("CacheName").SaveApp  AB.Cache.SaveAppAll
	'# ȡValue = AB.Cache("CacheName") ͬʱʹڴļ棬ȶȡڴеֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param: cacheName String (ַ)
	'# ƣͬʱҲڱļʱļܰ \*?"<>| ȷţ / ʾļʱĿ¼ṹ
	'# @param: value(ѡ) Object (ASP)  Recordset (¼)  String (ַ)
	'# ҪĻֵΪļ棬ֵַͼ¼
	'# Ϊڴ滺棬ַ¼DictionaryASP
	'--DEMO------------------------------------------------------------------------------------
	'# '###˵δ洢ȡ:
	'# AB.Cache.Expires = 60		'ûڵʱ䣬60ʾ60
	'# If AB.Cache("myCache").Ready Then	'Ч
	'# 	AB.C.Print AB.C.Cache("myCache") 	'
	'# Else
	'# 	AB.Cache("myCache") = "Ҫı"
	'# 	AB.Cache("myCache").Save 	'滺
	'# End If
	'#
	'# '###´뻺ĳ Recordset 󣬶ÿβѯݿ
	'# If AB.Cache("rs").Ready Then
	'# 	Set rs = AB.Cache("rs")	'ԭ¼
	'# Else
	'# 	Set rs = AB.DB.GR("table","","")
	'# 	AB.Cache("rs") = rs
	'# 	AB.Cache("rs").Save		'¼
	'# End If
	'# 'ƽʱһݰ
	'# Do While Not rs.Eof
	'# 	AB.C.Print rs(0)
	'# 	rs.Movenext
	'# Loop
	'------------------------------------------------------------------------------------------

	Public Property Let Item(ByVal p, ByVal v)
		If IsNull(p) Then p = ""
		If Not IsObject(Items(p)) Then
			Set Items(p) = New Cls_AB_Cache_Info
			Items(p).CountEnabled = CountEnabled
			Items(p).Expires = Expires
			Items(p).FileType = FileType
		End If
		Items(p).Name = p
		Items(p).Value = v
		Items(p).SavePath = s_path
	End Property

	Public Default Property Get Item(ByVal p)
		If Not IsObject(Items(p)) Then
			Set Items(p) = New Cls_AB_Cache_Info
			Items(p).Name = p
			Items(p).SavePath = s_path
			Items(p).CountEnabled = CountEnabled
			Items(p).Expires = Expires
			Items(p).FileType = FileType
		End If
		Set Item = Items(p)
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Get 
	'# @syntax: AB.Cache.Get(cacheName)
	'# @alias:  AB.Cache(cacheName).Value  AB.Cache.Item(cacheName).Value
	'# @return: Object (ASP)  Recordset (¼)  String (ַ)
	'# @dowhat: ȡ(ȶȡݻ)
	'# 			ͬʱΪ cacheName ݻ  Ϊ cacheName ļ棬ȶȡݻ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache.Save("test") 'ͬڣAB.Cache("test").Save
	'# AB.C.PrintCn AB.Cache.Get("test")
	'# AB.C.PrintCn AB.Cache("test").Value
	'------------------------------------------------------------------------------------------

	Public Function [Get](ByVal s)
		Dim temp,f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then temp = Items(f).Value
		End IF
		[Get] = temp
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Save 
	'# @syntax: AB.Cache.Save(cacheName)
	'# @alias:  AB.Cache(cacheName).Save  AB.Cache.Item(cacheName).Save
	'# @return: ޷ֵ
	'# @dowhat: ļ
	'# Ϊ cacheName ĻݱΪļ棬Ըָʽݣ籣¼
	'# ޷ʱ׳󣺡ǰݲ浽ļ桱
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache.Save("test") 'ͬڣAB.Cache("test").Save
	'# AB.C.Print AB.Cache("test")
	'# AB.Trace AB.Cache("test").Value
	'------------------------------------------------------------------------------------------

	Public Sub Save(ByVal s)
		Dim f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).Save
		End IF
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.SaveAll 
	'# @syntax: AB.Cache.SaveAll
	'# @return: ޷ֵ
	'# @dowhat: лݱΪļ
	'# ǰеĻݱΪļ棬ܹΪļͿַ(String)߼¼(Recordset)
	'# ļλý AB.Cache.SavePath Ժ cacheName е·Ϣͬɣչ AB.Cache.FileType Ծ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test2") = "2"
	'# AB.Cache.SaveAll	 'Ϊ test1  test2 Ļ
	'# AB.C.PrintCn AB.Cache("test1")
	'# AB.C.PrintCn AB.Cache("test2")
	'# AB.Trace Array(AB.Cache("test1").Value,AB.Cache("test2").Value)
	'------------------------------------------------------------------------------------------

	Public Sub SaveAll
		Dim f
		For Each f In Items
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).Save
		Next
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.SaveApp 
	'# @syntax: AB.Cache.SaveApp(cacheName)
	'# @alias:  AB.Cache(cacheName).SaveApp  AB.Cache.Item(cacheName).SaveApp
	'# @return: ޷ֵ
	'# @dowhat: ڴ滺
	'# Ϊ cacheName ĻݱΪڴ滺棬Ըָʽݣ¼ʱԶתΪά顣
	'# ޷ʱ׳󣺡ǰ浽ڴ滺桱
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache.SaveApp("test") 'ͬڣAB.Cache("test").SaveApp
	'# AB.C.Print AB.Cache("test")
	'# AB.Trace AB.Cache("test").Value
	'------------------------------------------------------------------------------------------

	Public Sub SaveApp(ByVal s)
		Dim f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).SaveApp
		End IF
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.SaveAppAll 
	'# @syntax: AB.Cache.SaveAppAll
	'# @return: ޷ֵ
	'# @dowhat: лݱΪڴ滺
	'# 			ǰеĻݱΪڴ滺棬Աֵ¼ʱԶתΪά
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test2") = "2"
	'# AB.Cache.SaveAppAll	 'Ϊ test1  test2 Ļ浽ڴ
	'# AB.C.PrintCn AB.Cache("test1")
	'# AB.C.PrintCn AB.Cache("test2")
	'# AB.Trace Array(AB.Cache("test1").Value,AB.Cache("test2").Value)
	'------------------------------------------------------------------------------------------

	Public Sub SaveAppAll
		Dim f
		For Each f In Items
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).SaveApp
		Next
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Remove 
	'# @syntax: AB.Cache.Remove(cacheName)
	'# @alias:  AB.Cache(cacheName).Remove  AB.Cache.Item(cacheName).Remove
	'# @return: ޷ֵ
	'# @dowhat: ɾļ
	'# Ϊ cacheName ļɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").Save
	'# AB.Cache.Remove("test") 'ͬڣAB.Cache("test").Remove
	'------------------------------------------------------------------------------------------

	Public Sub Remove(ByVal s)
		Dim f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).Remove
			'Items.Remove(f)
		End IF
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.RemoveAll 
	'# @syntax: AB.Cache.RemoveAll
	'# @return: ޷ֵ
	'# @dowhat: ļɾ
	'# 			ǰеı浽ļĻɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test2") = "2"
	'# AB.Cache.SaveAll	 'Ϊ test1  test2 Ļ浽ڴ
	'# AB.Cache.RemoveAll	 'Ϊ test1  test2 Ļļɾ
	'------------------------------------------------------------------------------------------

	Public Sub RemoveAll
		Dim f
		For Each f In Items
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).Remove
			'Items.Remove(f)
		Next
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.RemoveApp 
	'# @syntax: AB.Cache.RemoveApp(cacheName)
	'# @alias:  AB.Cache(cacheName).RemoveApp  AB.Cache.Item(cacheName).RemoveApp
	'# @return: ޷ֵ
	'# @dowhat: ɾݻ
	'# Ϊ cacheName ݻɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").SaveApp
	'# AB.Cache.RemoveApp("test") 'ͬڣAB.Cache("test").RemoveApp
	'------------------------------------------------------------------------------------------

	Public Sub RemoveApp(ByVal s)
		Dim f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).RemoveApp
			'Items.Remove(f)
		End IF
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.RemoveAppAll 
	'# @syntax: AB.Cache.RemoveAppAll
	'# @return: ޷ֵ
	'# @dowhat: ڴ滺ɾ
	'# 			ǰеı浽ڴĻɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test2") = "2"
	'# AB.Cache.SaveAppAll	 'Ϊ test1  test2 Ļ浽ڴ
	'# AB.Cache.RemoveAppAll	 'Ϊ test1  test2 Ļڴɾ
	'------------------------------------------------------------------------------------------

	Public Sub RemoveAppAll
		Dim f
		For Each f In Items
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then Items(f).RemoveApp
			'Items.Remove(f)
		Next
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Del 
	'# @syntax: AB.Cache.Del(cacheName)
	'# @alias:  AB.Cache(cacheName).Del  AB.Cache.Item(cacheName).Del
	'# @return: ޷ֵ
	'# @dowhat: ɾݻ
	'# Ϊ cacheName ݻɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = "1"
	'# AB.Cache("test").SaveApp 'Ϊݻ
	'# AB.Cache.Del("test") 'ͬڣAB.Cache("test").Del
	'# AB.Cache("test") = "2"
	'# AB.Cache("test").Save 'Ϊļ
	'# If AB.Cache("test").Ready Then
	'# 	AB.Trace AB.Cache("test")
	'# End If
	'------------------------------------------------------------------------------------------

	Public Sub Del(ByVal s)
		Dim f : f = s
		If Items.Exists(f) Then
			If Lcase(TypeName(Items(f))) = "cls_ab_cache_info" Then
				Items(f).Remove
				Items(f).RemoveApp
			End If
		End IF
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache.Clear 
	'# @syntax: AB.Cache.Clear
	'# @return: ޷ֵ
	'# @dowhat: лɾڴ滺ļ棩
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test1") = "1"
	'# AB.Cache("test2") = "2"
	'# AB.Cache.SaveAll	 	'Ϊ test1  test2 Ļ汣浽ļ
	'# AB.Cache("test3") = "3"
	'# AB.Cache("test4") = "4"
	'# AB.Cache.SaveAppAll	 'Ϊ test3  test4 Ļ汣浽ڴ
	'# AB.Cache.Clear	 'лɾ
	'------------------------------------------------------------------------------------------

	Public Sub [Clear]
		RemoveAll
		RemoveAppAll
		AB.C.RemoveApp "AB_Cache_Count"
	End Sub

End Class

Function AB_Cache_Count()
	AB_Cache_Count = 0
	Dim n : n = AB.C.GetApp("AB_Cache_Count")
	If IsArray(n) Then
		If Ubound(n) = 1 Then AB_Cache_Count = n(0)
	End If
End Function

Function AB_CacheCount_Change(ByVal a, ByVal t)
	Dim n : n = AB.C.GetApp("AB_Cache_Count")
	If isArray(n) Then
		If Ubound(n) = 1 Then
			If TypeName(n(1)) = "Dictionary" Then
				If t = 1 Then n(1)(a) = a
				If t = -1 Then
					If n(1).Exists(a) Then n(1).Remove(a)
				End If
				AB.C.SetApp "AB_Cache_Count", Array(n(1).Count,n(1))
			End If
		End If
	Else
		Dim dic : Set dic = Server.CreateObject(AB.dictName)
		If t = 1 Then dic(a) = a
		AB.C.SetApp "AB_Cache_Count", Array(AB.C.IIF(t=1,1,0),dic)
	End If
End Function

class Cls_AB_Cache_Info

	Public SavePath, [Name], CountEnabled, FileType
	Private i_exp, d_exp, o_value

	Private Sub Class_Initialize
		i_exp = 5
		d_exp = ""
	End Sub

	Private Sub Class_Terminate
		If IsObject(o_value) Then Set o_value = Nothing
	End Sub

	Public Property Let Expires(ByVal i)
		If isDate(i) Then
			d_exp = CDate(i)
		ElseIf isNumeric(i) Then
			If i>0 Then
				i_exp = i
			ElseIf i=0 Then
				i_exp = 60*24*365*99
			End If
		End If
	End Property

	Public Property Get Expires()
		Expires = AB.C.IfHas(d_exp, i_exp)
	End Property

	Public Property Let [Value](ByVal s)
		If IsObject(s) Then
			Select Case TypeName(s)
				Case "Recordset"
					Set o_value = s.Clone
				Case Else
					Set o_value = s
			End Select
		Else
			o_value = s
		End If
	End Property

	Public Default Property Get [Value]()
		On Error Resume Next
		Dim app : app = AB.C.GetApp(Me.Name)
		If IsArray(app) Then
			If UBound(app) = 1 Then
				If IsDate(app(0)) Then
					If IsObject(app(1)) Then
						Set [Value] = app(1)
						Exit Property
					Else
						[Value] = app(1)
						If AB.C.Has([Value]) Then Exit Property
					End If
				End If
			End If
		End If
		If AB.Fso.IsFile(FilePath) Then
			Dim rs
			set rs = Server.CreateObject("Adodb.Recordset")
			rs.Open FilePath
			If Err.Number <> 0 Then
				Err.Clear
				[Value] = AB.Fso.Read(FilePath)
			Else
				Set [Value] = rs
			End If
		Else
			AB.Error.Msg = "("""&AB.C.HtmlEncode(Me.Name)&""")" : AB.Error.Raise 92
		End If
		On Error Goto 0
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Cache(cacheName).SaveApp 
	'# @syntax: AB.Cache(cacheName).SaveApp
	'# @alias:  AB.Cache.Item(cacheName).SaveApp
	'# @return: ޷ֵ
	'# @dowhat: ڴ滺
	'# Ϊ cacheName ĻݱΪڴ滺棬Ըָʽݣ¼ʱԶתΪά顣
	'# ޷ʱ׳󣺡ǰ浽ڴ滺桱
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").SaveApp
	'------------------------------------------------------------------------------------------

	Public Sub SaveApp
		Dim appArr(1) : appArr(0) = Now()
		If IsObject(o_value) Then
			Select Case TypeName(o_value)
				Case "Dictionary"
					Set appArr(1) = o_value
				Case "Recordset"
					appArr(1) = o_value.GetRows(-1)
				Case Else
					AB.Error.Msg = "("""&AB.C.HtmlEncode(Me.Name)&" &gt; "&TypeName(o_value)&""")" : AB.Error.Raise 91
			End Select
		Else
			appArr(1) = o_value
		End If
		AB.C.SetApp Me.Name, appArr
		If CountEnabled Then AB_CacheCount_Change Me.Name, 1
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache(cacheName).Save 
	'# @syntax: AB.Cache(cacheName).Save
	'# @alias:  AB.Cache.Item(cacheName).Save
	'# @return: ޷ֵ
	'# @dowhat: ļ
	'# Ϊ cacheName ĻݱΪļ棬Ըָʽݣ籣¼
	'# ޷ʱ׳󣺡ǰݲ浽ļ桱
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").Save
	'------------------------------------------------------------------------------------------

	Public Sub Save
		Select Case TypeName(o_value)
			Case "Recordset"
				AB.Fso.CreateFile FilePath, "rs"
				AB.Fso.DelFile FilePath
				o_value.Save FilePath, adPersistXML
				If CountEnabled Then AB_CacheCount_Change Me.Name, 1
			Case "String"
				AB.Fso.CreateFile FilePath, o_value
				If CountEnabled Then AB_CacheCount_Change Me.Name, 1
			Case Else
				AB.Error.Msg = "("""&AB.C.HtmlEncode(Me.Name)&""")" : AB.Error.Raise 93
		End Select
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache(cacheName).Remove 
	'# @syntax: AB.Cache(cacheName).Remove
	'# @alias:  AB.Cache.Item(cacheName).Remove
	'# @return: ޷ֵ
	'# @dowhat: ɾļ
	'# Ϊ cacheName ļɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").Save
	'# AB.Cache("test").Remove
	'------------------------------------------------------------------------------------------

	Public Sub Remove
		If Not AB.C.Test(DelPath,"[*?]") Then
			If AB.Fso.IsExists(DelPath) Then AB.Fso.Del DelPath
			If CountEnabled Then AB_CacheCount_Change Me.Name, -1
		Else
			AB.Fso.DelFile left(DelPath,len(DelPath)-Len(FileType))
			AB.Fso.DelFolder left(DelPath,len(DelPath)-Len(FileType))
			If CountEnabled Then AB_CacheCount_Change Me.Name, -1
		End If
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache(cacheName).RemoveApp 
	'# @syntax: AB.Cache(cacheName).RemoveApp
	'# @alias:  AB.Cache.Item(cacheName).RemoveApp
	'# @return: ޷ֵ
	'# @dowhat: ɾݻ
	'# Ϊ cacheName ݻɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").SaveApp
	'# AB.Cache("test").RemoveApp
	'------------------------------------------------------------------------------------------

	Public Sub RemoveApp
		If AB.C.Has(Me.Name) Then AB.C.RemoveApp Me.Name
		If CountEnabled Then AB_CacheCount_Change Me.Name, -1
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Cache(cacheName).Del 
	'# @syntax: AB.Cache(cacheName).Del
	'# @alias:  AB.Cache.Item(cacheName).Del
	'# @return: ޷ֵ
	'# @dowhat: ɾĳ(ݻļ)
	'# Ϊ cacheName ݻļɾ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Cache("test") = ""
	'# AB.Cache("test").SaveApp
	'# AB.Cache("test").Del
	'------------------------------------------------------------------------------------------

	Public Sub Del
		Remove
		RemoveApp
	End Sub

	Public Property Get FilePath()
		FilePath = TransPath("[\\:""*?<>|\f\n\r\t\v\s]")
	End Property

	Private Function DelPath()
		DelPath = TransPath("[\\:""<>|\f\n\r\t\v\s]")
	End Function

	Private Function TransPath(ByVal fe)
		Dim s_p : s_p = ""
		Dim parr : parr = split(Me.Name,"/")
		Dim i
		for i = 0 to UBound(parr)
			If AB.C.Test(parr(i),fe) Then parr(i)=Server.URLEncode(parr(i))
			s_p = s_p & "_" & parr(i)
			If i < UBound(parr) Then
				s_p = s_p & "\"
			End If
		next
		If s_p="" Then s_p="_"
		TransPath = SavePath & s_p & FileType
	End Function

	Public Function Ready()
		Dim app : app = AB.C.GetApp(Me.Name)
		Ready = False
		If IsArray(app) Then
			If UBound(app) = 1 Then
				If IsDate(app(0)) Then
					Ready = isValid(app(0))
					If Ready Then Exit Function
				End If
			End If
		End If
		If AB.Fso.IsFile(FilePath) Then
			Ready = isValid(AB.Fso.GetAttr(FilePath,1))
		End If
	End Function

	Private Function isValid(ByVal t)
		If IsDate(t) Then
			If AB.C.Has(d_exp) Then
				isValid = (DateDiff("s",Now,d_exp) > 0)
			Else
				isValid = (DateDiff("s",t,Now) < i_exp*60)
			End If
		End If
	End Function

End Class
%>