<%
'######################################################################
'## ab.error.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Error Class
'## Version     :   v1.0.0.1
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2012/12/20 16:12
'## Description :   Deal with the AspBox Exception
'######################################################################

Class Cls_AB_Error

	Private b_debug, b_redirect
	Private i_errNum, i_delay
	Private s_errStr, s_title, s_url, s_css, s_style, s_msg
	Private i_errCode, s_errMsg
	Private o_err

	Private Sub Class_Initialize
		i_errNum    = ""
		i_delay     = 3000
		s_title     = "Error Occurred"
		b_debug     = AB.Debug
		b_redirect  = True
		s_url       = "javascript:history.go(-1)"
		s_css       = ""
		s_style 	= ""
		Set o_err   = Server.CreateObject(AB.dictName)
	End Sub

	Private Sub Class_Terminate
		Set o_err = Nothing
	End Sub

	'-------------------------------------------------------------------------
	' @ ǷÿߵԻд
	' @ AB.Error.Debug = True/False [Boolean]
	'-------------------------------------------------------------------------
	' # ǷÿߵԻǰ̳AB.DebugԵֵ
	' # رյԻڷʱϸϢ
	'-------------------------------------------------------------------------

	Public Property Get [Debug]
		[Debug] = b_debug
	End Property

	Public Property Let [Debug](ByVal b)
		b_debug = b
	End Property

	Public Default Property Get E(ByVal n)
		If o_err.Exists(n) Then
			E = o_err(n)
		Else
			E = "δ֪"
		End If
	End Property

	Public Property Let E(ByVal n, ByVal s)
		If AB.C.Has(n) And AB.C.Has(s) Then
			If n > "" Then
				o_err(n) = s
			End If
		End If
	End Property

	Public Property Get LastError
		LastError = i_errNum
	End Property

	Public Property Get Title
		Title = s_title
	End Property

	Public Property Let Title(ByVal s)
		s_title = s
	End Property

	Public Property Get Msg
		Msg = s_msg
	End Property

	Public Property Let Msg(ByVal s)
		s_msg = s
	End Property

	Public Property Get [Redirect]
		[Redirect] = b_redirect
	End Property

	Public Property Let [Redirect](ByVal b)
		b_redirect = b
	End Property

	Public Property Get Url
		Url = s_url
	End Property

	Public Property Let Url(ByVal s)
		s_url = s
	End Property

	Public Property Get Delay
		Delay = i_delay / 1000
	End Property

	Public Property Let Delay(ByVal i)
		i_delay = i * 1000
	End Property

	Public Property Get ClassName
		ClassName = s_css
	End Property

	Public Property Let ClassName(ByVal s)
		s_css = s
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Error.Style 
	'# @syntax: style = AB.Error.Style
	'# @return: String (ַ) ȡ Css Styleֵ
	'# @dowhat: úͻȡ(AspBox Error) Css Styleֵ. Կɶд
	'--DESC------------------------------------------------------------------------------------
	'# @param style : String (ַ) Css Styleֵ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Error.Style = "fieldset#abxError{margin:0 0 0 2%;position:relative;}fieldset#abxError{padding:0 15px 10px 15px;font-size:.8em;}fieldset#abxError{background:#FFF;width:96%;margin-top:8px;padding:10px;position:relative;}fieldset#abxError{padding:0 15px 10px 15px;margin:0 0 0 2%;position:relative;}fieldset#abxError p{font-size:1.2em;margin:0 0 10px 0;}fieldset#abxError legend{font-size:1em;color:#333333;background:#E7ECF0;font-weight:bold;padding:4px 15px 4px 10px;margin:4px 0 8px -12px;_margin-top:0px;border-width:1px;border-style:solid;border-color:#EDEDED #969696 #969696 #EDEDED;}"
	'# AB.Error(10001) = "ϵͳ"
	'# AB.Error.Msg = "ǸԶʾ"
	'# AB.Error.Raise 10001
	'------------------------------------------------------------------------------------------

	Public Property Get Style
		Style = s_style
	End Property

	Public Property Let Style(ByVal s)
		s_style = s
	End Property

	Public Sub Raise(ByVal n)
		If AB.C.IsNul(n) Then Exit Sub
		i_errNum = n
		On Error GoTo 0
		If b_debug Then
			AB.C.Put ShowMsg(o_err(n) & s_msg, 1)
		End If
		s_msg = ""
	End Sub

	Public Sub [Throw](ByVal msg)
		If Left(msg,1) = ":" Then
			If o_err.Exists(Mid(msg,2)) Then msg = o_err(Mid(msg,2))
		End If
		AB.C.Print ShowMsg(msg,0)
	End Sub

	Public Sub Show(ByVal code, ByVal msg)
		If b_debug Then
			AB.ShowErr code, msg
		End If
	End Sub

	Public Sub See()
		If b_debug Then
			AB.ShowErr "0x" & Hex(Err.Number), Err.Source & "<br />" & Err.Description
		End If
	End Sub

	Public Sub Defined()
		Dim key
		If AB.C.Has(o_err) Then
			For Each key In o_err
				AB.C.Print key & " : " & o_err(key) & "<br />" & VbCrLf
			Next
		End If
	End Sub

	'-- ׽ b --

	Public Sub ClearErr()
		i_errCode = 0
		s_errMsg = ""
		Err.Clear
	End Sub

	Public Sub SetErr(ByVal code, ByVal msg)
		i_errCode = code
		s_errMsg = msg
		Err.Clear
	End Sub

	Public Sub CatchErr()
		i_errCode = Err.Number
		s_errMsg = "<b>룺</b>0x" & Hex(Err.Number) & " <b>Դ</b>" & Err.Source & " <b></b>" & Err.Description & ""
		Err.Clear
	End Sub

	Public Function GetErr(ByVal p)
		Dim temp
		Select Case Lcase(p)
			Case "0", "code" : temp = i_errCode
			Case "1", "msg" : temp = s_errMsg
		End Select
		GetErr = temp
	End Function

	'-- ׽ e --

	Private Function ShowMsg(ByVal msg, ByVal t)
		Dim s,x,css,style
		style = AB.C.IfThen(AB.C.Has(s_style),"<style type=""text/css"">" & s_style & "</style>")
		css = AB.C.IfThen(AB.C.Has(s_css)," class=""" & s_css & """")
		If Trim(style) <> "" Then AB.C.Print style & "" & VbCrLf
		s = "<fieldset id=""abxError""" & css & ">" & vbCrLf
		s = s & "	<legend>" & s_title & "</legend>" & vbCrLf
		s = s & "	<p class=""msg"">" & msg & "</p>" & vbCrLf
		x = AB.C.IIF(s_url = "javascript:history.go(-1)", "", "")
		If t = 1 Then
			If Err.Number<>0 Then
				s = s & "	<ul class=""dev"">" & vbCrLf
				s = s & "		<li class=""info"">ϢԿߣ</li>" & vbCrLf
				s = s & "		<li>룺0x" & Hex(Err.Number) & "</li>" & vbCrLf
				s = s & "		<li>" & Err.Description & "</li>" & vbCrLf
				s = s & "		<li>Դ" & Err.Source & "</li>" & vbCrLf
				s = s & "	</ul>" & vbCrLf
			End If
		Else
			If b_redirect Then
				s = s & "	<p class=""back"">ҳ潫" & i_delay/1000 & "Ӻתûת<a href=""" & s_url & """>˴" & x & "</a></p>" & vbCrLf
				s_url = AB.C.IIF(Left(s_url,11) = "javascript:", Mid(s_url,12), "location.href='" & s_url & "';")
				s = s & "<script type='text/javascript'>setTimeout(function(){" & s_url & "}," & i_delay & ");</script>"
			Else
				s = s & "	<p class=""back""><a href=""" & s_url & """>˴" & x & "</a></p>" & vbCrLf
			End If
		End If
		s = s & "</fieldset>" & vbCrLf
		ShowMsg = s
	End Function

End Class
%>