<%
'######################################################################
'## ab.fso.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox FileSystemObject Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2012/03/14 2:25
'## Description :   AspBox Files System Operator
'######################################################################

Class Cls_AB_Fso
	Public oFso, IsVirtualHost
	Private Fso, o_imgwh
	Private b_force,b_overwrite
	Private s_fsoName,s_steamName,s_sizeformat,s_charset

	Private Sub Class_Initialize
		s_fsoName 	= AB.FsoName
		s_steamName	= AB.steamName
		s_charset	= AB.CharSet
		Set Fso 	= Server.CreateObject(s_fsoName)
		Set oFso 	= Fso
		Set o_imgwh = New ImgWHInfo
		IsVirtualHost = True '÷ǷȨʱɳ޸Ĵԣ
		b_force		= True
		b_overwrite	= True
		s_sizeformat= "K"
		AB.Error(52) = "дļ"
		AB.Error(53) = "ļд"
		AB.Error(54) = "ȡļбʧܣ"
		AB.Error(55) = "ʧܣļڣ"
		AB.Error(56) = "ʧܣ"
		AB.Error(57) = "ȡʧܣļڣ"
		AB.Error(58) = "ʧܣԴļڣ"
		AB.Error(59) = "ƶʧܣԴļڣ"
		AB.Error(60) = "ɾʧܣļڣ"
		AB.Error(61) = "ʧܣԴļڣ"
		AB.Error(62) = "ʧܣѴͬļ"
		AB.Error(63) = "ļļв"
	End Sub

	Private Sub Class_Terminate
		Set Fso 	= Nothing
		Set oFso 	= Nothing
		Set o_imgwh = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Fso.New 
	'# @syntax: Set f = AB.Fso.New
	'# @return: Object (ASP)
	'# @dowhat: FsoĶ, һ AspBox_Fso 
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# Dim f : Set f = AB.Fso.New 	'Fso
	'------------------------------------------------------------------------------------------

	Public Function [New]()
		Set [New] = New Cls_AB_Fso
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.FsoName 
	'# @syntax: AB.Fso.FsoName = string
	'# @return: ޷ֵ
	'# @dowhat: ÷FSOƣֻд
	'#  һ˵FSOΪScripting.FilesyStemObject
	'#  ϵFSO޸ƣô÷FSOơ
	'#  û޸ģɺԴԡ
	'#  ҪAspBoxķļز AB.C.Include 
	'#  P.S. Ϊǿȫԣͨ޸ע HKEY_CLASSES_ROOT\Scripting.FileSystemObject ļֵ޸FSOơ
	'--DESC------------------------------------------------------------------------------------
	'# @param string: String (ַ) FSOƣĬΪScripting.FilesyStemObject
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.Fso.FsoName = "Scripting.FilesyStemObject"
	'------------------------------------------------------------------------------------------

	Public Property Let fsoName(Byval str)
		s_fsoName = str
		Set Fso = Server.CreateObject(s_fsoName)
		Set oFso = Fso
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.SteamName 
	'# @syntax: AB.Fso.SteamName = string
	'# @return: ޷ֵ
	'# @dowhat: ÷ADODB.Streamƣֻд
	'--DESC------------------------------------------------------------------------------------
	'# @param string: String (ַ) ADODB.StreamƣĬΪADODB.Stream
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Property Let SteamName(Byval str)
		s_steamName = str
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.CharSet 
	'# @syntax: AB.Fso.CharSet = charset
	'# @return: ޷ֵ
	'# @dowhat: ÷˲ļļ룬ֻд
	'# 			FSOļļַ룬"UTF-8""GB2312"
	'# 			ĬΪ AB.CharSet ֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.Fso.CharSet = "GBK"
	'------------------------------------------------------------------------------------------

	Public Property Let CharSet(Byval str)
		s_charset = Ucase(str)
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Force 
	'# @syntax: AB.Fso.Force = boolean
	'# @return: ޷ֵ
	'# @dowhat: Ϊʱɾϵֻļ
	'--DESC------------------------------------------------------------------------------------
	'# @param boolean: Boolean (ֵ) ΪʾɾϵֻļΪɾĬΪ True
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.Fso.Force = False
	'------------------------------------------------------------------------------------------

	Public Property Let Force(Byval bool)
		b_force = bool
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.OverWrite 
	'# @syntax: AB.Fso.OverWrite = boolean
	'# @return: ޷ֵ
	'# @dowhat: ΪʱǷԭеͬļ
	'--DESC------------------------------------------------------------------------------------
	'# @param boolean: Boolean (ֵ) ΪʾļʱǷԭеͬļΪ򲻸ǡĬΪ True
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.Fso.OverWrite = False
	'------------------------------------------------------------------------------------------

	Public Property Let OverWrite(Byval bool)
		b_overwrite = bool
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.SizeFormat 
	'# @syntax: AB.Fso.SizeFormat = string
	'# @return: ޷ֵ
	'# @dowhat: ļСʾʽֻд
	'--DESC------------------------------------------------------------------------------------
	'# @param string: String (ַ) ѡֵУG,M,K,b,autoĬֵΪ K
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.Fso.SizeFormat = "M"
	'------------------------------------------------------------------------------------------

	Public Property Let SizeFormat(Byval str)
		s_sizeformat = str
	End Property

	Public Property Get ShowErr()
		ShowErr = s_err
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Fso.isExists(path) жļļǷ
	'# @return: Boolean (ֵ) ļļдڷ棨True򷵻ؼ٣False
	'# @dowhat: жļļǷ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'# ļļе··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# If AB.Fso.IsExists("/Test.html") Then
	'# 	AB.C.Print "Test.html"
	'# Else
	'# 	AB.C.Print "Test.html"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function isExists(ByVal path)
		isExists = False
		If isFile(path) or isFolder(path) Then isExists = True
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.IsFile(filePath) жļǷ
	'# @return: Boolean (ֵ) ļڷ棨True򷵻ؼ٣False
	'# @dowhat: жļǷ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ)
	'# ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# If AB.Fso.IsFile("/Test.html") Then
	'# 	AB.C.Print "Test.html"
	'# Else
	'# 	AB.C.Print "Test.html"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function isFile(ByVal filePath)
		filePath = absPath(filePath) : isFile = False
		If Fso.FileExists(filePath) Then isFile = True
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Read(filePath) ȡļ
	'# @return: String (ַ) ضȡļݣַ
	'# @dowhat: ô˷ɻȡָļݣظַ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ)
	'# Ҫȡļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim TempStr
	'# TempStr = AB.Fso.Read("/Test.html")
	'# AB.C.Print TempStr
	'------------------------------------------------------------------------------------------

	Public Function Read(ByVal filePath)
		Dim p, f, o_strm, tmpStr, s_char
		s_char = s_charset
		If Instr(filePath,">")>0 Then
			s_char = UCase(Trim(AB.C.CRight(filePath,">")))
			filePath = Trim(AB.C.CLeft(filePath,">"))
		End If
		p = absPath(filePath)
		If isFile(p) Then
			Set o_strm = Server.CreateObject(s_steamName)
			With o_strm
				.Type = 2
				.Mode = 3
				.Open
				.LoadFromFile p
				.Charset = s_char
				.Position = 2
				tmpStr = .ReadText
				.Close
			End With
			Set o_strm = Nothing
			If s_char = "UTF-8" Then
				Select Case AB.FileBOM
					Case "keep"
						'Do Nothing
					Case "remove"
						If AB.C.Test(tmpStr, "^\uFEFF") Then
							tmpStr = AB.C.RegReplace(tmpStr, "^\uFEFF", "")
						End If
					Case "add"
						If Not AB.C.Test(tmpStr, "^\uFEFF") Then
							tmpStr = Chrw(&hFEFF) & tmpStr
						End If
				End Select
			End If
		Else
			tmpStr = ""
			AB.Error.Msg = "(" & filePath & ")"
			AB.Error.Raise 2
		End If
		Read = tmpStr
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.ReadBin(filePath) Զʽȡļ
	'# @return: String (ַ) ضȡļݣʽ
	'# @dowhat: ô˷ɻȡָļĶʽݣظöʽ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ)
	'# Ҫȡļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim steam
	'# steam = AB.Fso.ReadBin("/aaa.jpg")
	'# 'Call AB.Fso.SaveAs("/bbb.jpg",steam) '()һļ
	'# Response.Clear
	'# Response.BinaryWrite steam '(ȡͼƬ)
	'# Response.End
	'------------------------------------------------------------------------------------------

	Public Function ReadBin(ByVal filePath)
		Dim p, f, o_strm, tmpStr, s_char
		s_char = s_charset
		If Instr(filePath,">")>0 Then
			s_char = UCase(Trim(AB.C.CRight(filePath,">")))
			filePath = Trim(AB.C.CLeft(filePath,">"))
		End If
		p = absPath(filePath)
		If isFile(p) Then
			Set o_strm = Server.CreateObject(s_steamName)
			With o_strm
				.Type = 1 'Զģʽ(adTypeBinary) 
				.Open
				.LoadFromFile p
				tmpStr = .Read
				.Close
			End With
			Set o_strm = Nothing
		Else
			tmpStr = ""
			AB.Error.Msg = "(" & filePath & ")"
			AB.Error.Raise 2
		End If
		ReadBin = tmpStr
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.SaveAs(filePath, fileContent) Զʽļݣ򴴽
	'# @return: Boolean (ֵ) ļɹ棨Trueʧ򷵻ؼ٣False
	'# @dowhat: ô˷ָļдݣļ򴴽
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ)
	'# Ҫȡļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param fileContent: [String] (ַ)
	'# дļ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim steam
	'# steam = AB.Fso.ReadBin("/aaa.jpg")
	'# If AB.Fso.SaveAs("/bbb.jpg",steam) Then
	'# 	AB.C.Print "ɹ"
	'# Else
	'# 	AB.C.Print "ʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function SaveAs(ByVal filePath, ByVal fileContent)
		On Error Resume Next
		Dim f,p,t, o_strm
		p = absPath(filePath)
		SaveAs = MD(Left(p,InstrRev(p,"\")-1))
		If SaveAs Then
			Set o_strm = Server.CreateObject(s_steamName)
			With o_strm
				.Type = 1 'Զģʽ(adTypeBinary) 
				.Open
				.Write fileContent
				.SaveToFile p,AB.C.IIF(b_overwrite,2,1)
				.Close()
			End With
			Set o_strm = Nothing
		End If
		If Err.Number<>0 Then
			SaveAs = False
			AB.Error.Msg = "(" & filePath & ")"
			AB.Error.Raise 52
		End If
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.CreateFile(filePath, fileContent) ڷ˴ļд
	'# @return: Boolean (ֵ) ļɹ棨Trueʧܷؼ٣False
	'# @dowhat: ÷ɽַдļڷ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ) ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param fileContent: [String] (ַ) ļݣַ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Content,Result
	'# Content = "ַ"
	'# Result = AB.Fso.CreateFile("/Test.txt",Content)
	'# If Result Then
	'#     AB.C.Print "ļɹ"
	'# Else
	'#     AB.C.Print "ļʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function CreateFile(ByVal filePath, ByVal fileContent)
		On Error Resume Next
		Dim f,p,t, s_char, o_strm
		s_char = s_charset
		If Instr(filePath,">")>0 Then
			s_char = UCase(Trim(AB.C.CRight(filePath,">")))
			filePath = Trim(AB.C.CLeft(filePath,">"))
		End If
		p = absPath(filePath)
		CreateFile = MD(Left(p,InstrRev(p,"\")-1))
		If CreateFile Then
			Set o_strm = Server.CreateObject(s_steamName)
			With o_strm
				.Type = 2
				.Open
				.Charset = s_char
				.Position = o_strm.Size
				.WriteText = fileContent
				.SaveToFile p,AB.C.IIF(b_overwrite,2,1)
				.Close
			End With
			Set o_strm = Nothing
		End If
		If Err.Number<>0 Then
			CreateFile = False
			AB.Error.Msg = "(" & filePath & ")"
			AB.Error.Raise 52
		End If
		On Error Goto 0
	End Function
	
	'------------------------------------------------------------------------------------------
	'# AB.Fso.UpdateFile(filePath, rule, result) ʽļ
	'# @return: Boolean (ֵ) ³ɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ָļfilePathеƥruleʽַ滻Ϊresultеֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ)
	'# Ҫµļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ) 
	'# @param rule: [String] (ַ) 滻ʽ 
	'# @param result: [String] (ַ) Ҫ滻ΪĽ 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'Test.txtеAspBoxABox滻ΪAspBox v1.0
	'# Result = AB.Fso.UpdateFile("/Test.txt","A(sp)?[Bb]ox","AspBox v1.0")
	'# If Result Then
	'# 	AB.C.Print "ļ³ɹ"
	'# Else
	'# 	AB.C.Print "ļʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function UpdateFile(ByVal filePath, ByVal rule, ByVal result)
		Dim tmpStr : filePath = absPath(filePath)
		tmpStr = AB.C.regReplace(Read(filePath),rule,result)
		UpdateFile = CreateFile(filePath,tmpStr)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.AppendFile(filePath, fileContent) ׷ļ
	'# @return: Boolean (ֵ) ׷ӳɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ԭļfilePathݵĩβ׷ӲfileContentݡ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: [String] (ַ) ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param fileContent: [String] (ַ) Ҫ׷ӵݣַ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Content,Result
	'# Content = "ַ"
	'# Result = AB.Fso.AppendFile("/Test.txt",Content)'"ַ"׷ӵļTest.txt
	'# If Result Then
	'# 	AB.C.Print "ļ׷ӳɹ"
	'# Else
	'# 	AB.C.Print "ļ׷ʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function AppendFile(ByVal filePath, ByVal fileContent)
		Dim tmpStr : filePath = absPath(filePath)
		tmpStr = Read(filePath) & fileContent
		AppendFile = CreateFile(filePath,tmpStr)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.IsFolder(folderPath) жϷϵļǷ
	'# @return: Boolean (ֵ) ļдڷ棨Trueڷؼ٣False
	'# @dowhat: ô˷жϷϵļǷ
	'--DESC------------------------------------------------------------------------------------
	'# @param folderPath: [String] (ַ)
	'# ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# If AB.Fso.IsFolder("/Test/") Then
	'# 	AB.C.Print "Testļд"
	'# Else
	'# 	AB.C.Print "Testļв"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function isFolder(ByVal folderPath)
		folderPath = absPath(folderPath) : isFolder = False
		If Fso.FolderExists(folderPath) Then isFolder = True
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.CreateFolder(folderPath) ڷϴļ
	'# @return: Boolean (ֵ) ļдɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ڷϴļУڵϼļлԶ
	'--DESC------------------------------------------------------------------------------------
	'# @param folderPath: [String] (ַ) ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# Result = AB.Fso.CreateFolder("/Test/1/2/3/")
	'# 'Result = AB.Fso.MD("/Test/1/2/3/") 'д
	'# If Result Then
	'# 	AB.C.Print "ļдɹ"
	'# Else
	'# 	AB.C.Print "ļдʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function CreateFolder(ByVal folderPath)
		On Error Resume Next
		Dim p,arrP,i : CreateFolder = True
		p = absPath(folderPath)
		arrP = Split(p,"\") : p = ""
		For i = 0 To Ubound(arrP)
			p = p & arrP(i) & "\"
			If IsVirtualHost Then
				If Instr(p, absPath("/") & "\")>0 Then
					If Not isFolder(p) And i>0 Then Fso.CreateFolder(p)
				End If
			Else
				If Not isFolder(p) And i>0 Then Fso.CreateFolder(p)
			End If
		Next
		If Err.Number<>0 Then
			CreateFolder = False
			AB.Error.Msg = "(" & folderPath & ")"
			AB.Error.Raise 53
		End If
		On Error Goto 0
	End Function

	Public Function MD(ByVal folderPath)
		MD = CreateFolder(folderPath)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Dir(folderPath) гָĿ¼еļļ
	'# @return: Array ()
	'# 			һļ/ļԵĶά
	'# 			ص԰ С ʱ ļԣļ޴ֵ 
	'# @dowhat: гָĿ¼еļļ
	'--DESC------------------------------------------------------------------------------------
	'# @param folderPath: [String] (ַ)
	'# ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim P,Flist,i : P = "/"
	'# Flist = AB.Fso.Dir(P)
	'# 'AB.Trace Flist
	'# For i = 0 To UBound(Flist,2)
	'# 	AB.C.PrintCn "·" & P & Flist(0,i) &_
	'# 	" С" & Flist(1,i) &_
	'# 	" £" & Flist(2,i) &_
	'# 	" ԣ" & Flist(3,i) &_
	'# 	" ͣ" & Flist(4,i)
	'# Next
	'------------------------------------------------------------------------------------------

	Public Function Dir(ByVal folderPath)
		Dir = List(folderPath,0)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.List(folderPath, fileType) гָĿ¼еļļ
	'# @return: Array ()
	'# 			һļ/ļԵĶά
	'# 			ص԰ С ʱ ļԣļ޴ֵ 
	'# @dowhat: гָĿ¼еļļ
	'--DESC------------------------------------------------------------------------------------
	'# @param folderPath: [String] (ַ)
	'# ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param fileType: [String] (ַ)
	'#  ͣѡֵУ
	'#   0  ""ͬʱгļкļ
	'#   1  "file"ֻгļ
	'#   2  "folder"ֻгļС
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim P,Flist,i : P = "/"
	'# Flist = AB.Fso.List(P,0) 'ͬʱгļкļҲдΪAB.Fso.List(P,"")
	'# 'Flist = AB.Fso.List(P,1) 'ֻгļҲдΪAB.Fso.List(P,"file")
	'# 'Flist = AB.Fso.List(P,2) 'ֻгļУҲдΪAB.Fso.List(P,"folder")
	'# For i = 0 To UBound(Flist,2)
	'# 	AB.C.Print "·" & P & Flist(0,i) &_
	'# 	" С" & Flist(1,i) &_
	'# 	" £" & Flist(2,i) &_
	'# 	" ԣ" & Flist(3,i) &_
	'# 	" ͣ" & Flist(4,i)
	'# Next
	'------------------------------------------------------------------------------------------

	Public Function List(ByVal folderPath, ByVal fileType)
		On Error Resume Next
		Dim f,fs,k,arr(),i,l
		folderPath = absPath(folderPath) : i = 0
		Select Case LCase(fileType)
			Case "0","" l = 0
			Case "1","file" l = 1
			Case "2","folder" l = 2
			Case Else l = 0
		End Select
		Set f = Fso.GetFolder(folderPath)
		If l = 0 Or l = 2 Then
			Set fs = f.SubFolders
			ReDim Preserve arr(4,fs.Count-1)
			For Each k In fs
				arr(0,i) = k.Name & "/"
				arr(1,i) = formatSize(k.Size,s_sizeformat)
				arr(2,i) = k.DateLastModified
				arr(3,i) = Attr2Str(k.Attributes)
				arr(4,i) = k.Type
				i = i + 1
			Next
		End If
		If l = 0 Or l = 1 Then
			Set fs = f.Files
			ReDim Preserve arr(4,fs.Count+i-1)
			For Each k In fs
				arr(0,i) = k.Name
				arr(1,i) = formatSize(k.Size,s_sizeformat)
				arr(2,i) = k.DateLastModified
				arr(3,i) = Attr2Str(k.Attributes)
				arr(4,i) = k.Type
				i = i + 1
			Next
		End If
		Set fs = Nothing
		Set f = Nothing
		List = arr
		If Err.Number<>0 Then
			AB.Error.Msg = "(" & folderPath & ")"
			AB.Error.Raise 54
		End If
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.NameOf(file) ȡļ
	'# @return: String (ַ) ȥ׺ļ
	'# @dowhat: ô˷ɵõļļȥ׺Ƿϲڵļ
	'--DESC------------------------------------------------------------------------------------
	'# @param file: [String] (ַ)
	'# ļļ···վ·(/ͷ)Ӳ̾·("̷:\"ͷ)Ƿϲڵļ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.C.PrintCn AB.Fso.NameOf("Test1.html") 'ؽTest1
	'# AB.C.PrintCn AB.Fso.NameOf("/abc/123/Test2.txt") 'ؽTest2
	'------------------------------------------------------------------------------------------

	Public Function NameOf(ByVal f)
		NameOf = GetNameOf(f, 0)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.ExtOf(file) ȡļչ׺
	'# @return: String (ַ) ļչ׺磺.html.asp.txt
	'# @dowhat: ø÷ɻȡļչ׺Ƿϲڵļ
	'--DESC------------------------------------------------------------------------------------
	'# @param file: [String] (ַ)
	'# ļļ···վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# Ƿϲڵļ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.C.PrintCn AB.Fso.ExtOf("Test1.html") 'ؽ.html
	'# AB.C.PrintCn AB.Fso.ExtOf("/abc/123/Test2.txt") 'ؽ.txt
	'------------------------------------------------------------------------------------------

	Public Function ExtOf(ByVal f)
		ExtOf = GetNameOf(f, 1)
	End Function

	Private Function GetNameOf(ByVal f, ByVal t)
		Dim re,na,ex
		If AB.C.isNul(f) Then GetNameOf = "" : Exit Function
		f = Replace(f,"\","/")
		If Right(f,1) = "/" Then
			re = Split(f,"/")
			GetNameOf = AB.C.IIF(t=0,re(Ubound(re)-1),"")
			Exit Function
		ElseIf Instr(f,"/")>0 Then
			re = Split(f,"/")(Ubound(Split(f,"/")))
		Else
			re = f
		End If
		If Instr(re,".")>0 Then
			na = Left(re,InstrRev(re,".")-1)
			ex = Mid(re,InstrRev(re,"."))
		Else
			na = re
			ex = ""
		End If
		If t = 0 Then
			GetNameOf = na
		ElseIf t = 1 Then
			GetNameOf = ex
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Attr(path, attrType) ļļ
	'# @return: Boolean (ֵ) óɹ棨Trueʧܷؼ٣False
	'# @dowhat: ļļ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ) ļļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param attrType: [String] (ַ) ӢĶš,ո ַǰļӺš+ʾӴԣš-ʾԡ
	'# õ£
	'#  R ֻļ
	'#  A 浵ļ
	'#  S ϵͳļ
	'#  H ļ
	'--DEMO------------------------------------------------------------------------------------
	'# ͬʱöԣӢĶš,ո ǰļӺš+ʾӴԣš-ʾԡ磺"+R,-H,-S,+A"
	'# õ£
	'#  R ֻļ
	'#  A 浵ļ
	'#  S ϵͳļ
	'#  H ļ
	'# ---------------
	'# AB.Use "Fso"
	'# Dim Result
	'#     Result = AB.Fso.Attr("/Test.txt","+R,-H")'Test.txtΪֻȥ
	'# If Result Then
	'#     AB.C.Print "óɹ"
	'# Else
	'#     AB.C.Print "ʧ"
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function Attr(ByVal path, ByVal attrType)
		On Error Resume Next
		Dim p,a,i,n,f,at : p = absPath(path) : n = 0 : Attr = True
		If not isExists(p) Then
			Attr = False
			AB.Error.Msg = "(" & path & ")"
			AB.Error.Raise 55
			Exit Function
		End If
		If isFile(p) Then
			Set f = Fso.GetFile(p)
		ElseIf isFolder(p) Then
			Set f = Fso.GetFolder(p)
		End If
		at = f.Attributes : a = UCase(attrType)
		If Instr(a,"+")>0 Or Instr(a,"-")>0 Then
			a = AB.C.IIF(Instr(a," ")>0,Split(a," "),Split(a,","))
			For i = 0 To Ubound(a)
				Select Case a(i)
					Case "+R" at = AB.C.IIF(at And 1,at,at+1)
					Case "-R" at = AB.C.IIF(at And 1,at-1,at)
					Case "+H" at = AB.C.IIF(at And 2,at,at+2)
					Case "-H" at = AB.C.IIF(at And 2,at-2,at)
					Case "+S" at = AB.C.IIF(at And 4,at,at+4)
					Case "-S" at = AB.C.IIF(at And 4,at-4,at)
					Case "+A" at = AB.C.IIF(at And 32,at,at+32)
					Case "-A" at = AB.C.IIF(at And 32,at-32,at)
				End Select
			Next
			f.Attributes = at
		Else
			For i = 1 To Len(a)
				Select Case Mid(a,i,1)
					Case "R" n = n + 1
					Case "H" n = n + 2
					Case "S" n = n + 4
				End Select
			Next
			f.Attributes = AB.C.IIF(at And 32,n+32,n)
		End If
		Set f = Nothing
		If Err.Number<>0 Then
			Attr = False
			AB.Error.Msg = "(" & path & ")"
			AB.Error.Raise 56
		End If
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.GetAttr(path, attrType) ȡļļ
	'# @return: String (ַ) رѯļļеֵ
	'# @dowhat: ô˷ԻȡļļеԣļС͡ԡڵ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'#  ļļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param attrType: [String] (ַ)
	'#  ҪȡõͣѡֵУ
	'#   0  name 
	'#   1  date  datemodified ޸
	'#   2  datecreated 
	'#   3  dateaccessed ϴη
	'#   4  size С
	'#   5  attr ļԣļ޴ֵ
	'#   6  type 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim P,i : P = "/Test/"
	'# AB.C.PrintCn AB.Fso.GetAttr(P,"date") 'Testļе޸
	'# P = "Test.html"
	'# For i = 0 To 6
	'# 	AB.C.PrintCn AB.Fso.GetAttr(P,i) 'ѭTest.htmlĸ
	'# Next
	'------------------------------------------------------------------------------------------

	Public Function getAttr(ByVal path, ByVal attrType)
		Dim f,s,p : p = absPath(path)
		If isFile(p) Then
			Set f = Fso.GetFile(p)
		ElseIf isFolder(p) Then
			Set f = Fso.GetFolder(p)
		Else
			getAttr = ""
			AB.Error.Msg = "(" & path & ")"
			AB.Error.Raise 57
			Exit Function
		End If
		Select Case LCase(attrType)
			Case "0","name" : s = f.Name
			Case "1","date", "datemodified" : s = f.DateLastModified
			Case "2","datecreated" : s = f.DateCreated
			Case "3","dateaccessed" : s = f.DateLastAccessed
			Case "4","size" : s = formatSize(f.Size,s_sizeformat)
			Case "5","attr" : s = Attr2Str(f.Attributes)
			Case "6","type" : s = f.Type
			Case Else s = ""
		End Select
		Set f = Nothing
		getAttr = s
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Size(path) ȡļļдС
	'# @return: Integer () ļļдС(ֽ)
	'# @dowhat: ȡļļдС, ļļвڷ -1
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'#  ļļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# AB.C.PrintCn AB.Fso.Size("/Test/") 'TestļдС
	'# AB.C.PrintCn AB.Fso.Size("/Test/aaa.jpg") '·/Test/aaa.jpgļС
	'# '_AB.Fso.FormatSizeļСиʽʾ, ѡֵУG,M,K,b,auto
	'# If AB.Fso.Size("/Test/aaa.jpg")>0 Then AB.C.PrintCn AB.Fso.FormatSize(AB.Fso.Size("/Test/aaa.jpg"), "K")
	'# '_ʹ·
	'# AB.Fso.SizeFormat = "M" 'ļСʾʽ, ѡֵУG,M,K,b,autoĬֵΪ K
	'# AB.C.PrintCn AB.Fso.getAttr("/Test/aaa.jpg","size")
	'------------------------------------------------------------------------------------------

	Public Function Size(ByVal path)
		Dim i_size,f,p : p = absPath(path) : i_size = 0
		If isFile(p) Then
			Set f = Fso.GetFile(p)
			i_size = f.Size
		ElseIf isFolder(p) Then
			Set f = Fso.GetFolder(p)
			i_size = f.Size
		Else
			i_size = -1
		End If
		Set f = Nothing
		Size = i_size
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.ImgWH(path) ȡͼƬȺ͸߶Ϣ
	'# @return: Array () ͼƬȺ͸߶Ԫ
	'# @dowhat: ȡͼƬȺ͸߶Ϣ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'#  ļļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim imgPath, wh, w, h
	'# imgPath = "/demo/test.jpg"
	'# wh = AB.Fso.ImgWH(imgPath)
	'# w = wh(0)
	'# h = wh(1)
	'# AB.C.Print ("<img src='"&imgPath&"' border=0><br>:"&w&";:"&h)
	'------------------------------------------------------------------------------------------

	Public Function ImgWH(ByVal path)
		On Error Resume Next
		Dim p : p = absPath(path)
		ImgWH = o_imgwh.ImgWH(p)
		On Error Goto 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.CopyFile(fromPath, toPath) ļ֧ͨ *  ? 
	'# @return: Boolean (ֵ) ļƳɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ɸƷϵĵļָļУ֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param fromPath: [String] (ַ) Դ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)֧֧ͨ *  ? 磺
	'#  "/Test/1.asp"  Testļµ1.asp
	'#  "/Test/*"  TestļµļļУ
	'#  "/Test/*.html"  Testļµк׺htmlļ
	'#  "/Test/??st.ca?he"  Testļƥļ˹ƥTest.cachelist.cabheȣ
	'# @param toPath: [String] (ַ) Ŀļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)ڵļнԶ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# '/Test/1/еļ/Test/2/
	'# Result = AB.Fso.CopyFile("/Test/1/*","/Test/2/")
	'# AB.C.Print "ļ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function CopyFile(ByVal fromPath, ByVal toPath)
		CopyFile = FOFO(fromPath,toPath,0,0)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.CopyFolder(fromPath, toPath) ļУ֧ͨ *  ? 
	'# @return: Boolean (ֵ) ļиƳɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ɸƷϵĵļУļмļеļָļУ֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param fromPath: [String] (ַ) ļԴ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)֧֧ͨ *  ? 磺
	'#  "/Test/1/"  Testļµ1ļ
	'#  "/Test/*"  TestļµļУļкļеļ
	'#  "/Test/T?/"  TestļƥļУ˹ƥ/Test/T1//Test/T2/ȣ
	'# @param toPath: [String] (ַ) Ŀļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)ڵļнԶ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# '/Test/1/еļе/Test/2/
	'# Result = AB.Fso.CopyFolder("/Test/1/*","/Test/2/")
	'# AB.C.Print "ļ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function CopyFolder(ByVal fromPath, ByVal toPath)
		CopyFolder = FOFO(fromPath,toPath,1,0)
	End Function

	Public Function Copy(ByVal fromPath, ByVal toPath)
		Dim ff,tf : ff = absPath(fromPath) : tf = absPath(toPath)
		If isFile(ff) Then
			Copy = CopyFile(fromPath,toPath)
		ElseIf isFolder(ff) Then
			Copy = CopyFolder(fromPath,toPath)
		Else
			Copy = False
			AB.Error.Msg = "(" & fromPath & ")"
			AB.Error.Raise 58
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.MoveFile(fromPath, toPath) ƶļ֧ͨ *  ? 
	'# @return: Boolean (ֵ) ļƶɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ƶУϵĵļָļУ֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param fromPath: [String] (ַ)
	'#  Դ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)֧ͨ *  ? 磺
	'#  "/Test/1.asp"  ƶTestļµ1.asp
	'#  "/Test/*"  ƶTestļµļļУ
	'#  "/Test/*.html"  ƶTestļµк׺htmlļ
	'#  "/Test/??st.ca?he"  ƶTestļƥļ˹ƥTest.cachelist.cabheȣ
	'# @param toPath: [String] (ַ)
	'# Ŀļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)ڵļнԶ 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ƶ/Test/1/еļ/Test/2/
	'# Result = AB.Fso.MoveFile("/Test/1/*","/Test/2/")
	'# AB.C.Print "ļƶ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function MoveFile(ByVal fromPath, ByVal toPath)
		MoveFile = FOFO(fromPath,toPath,0,1)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.MoveFolder(fromPath, toPath) ƶļУ֧ͨ *  ? 
	'# @return: Boolean (ֵ) ļƶɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ƶ()ϵĵļ(ļмļеļ)ָļ,֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param fromPath: [String] (ַ)
	'#  ļԴ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)֧ͨ *  ? 磺
	'#  "/Test/1/"  ƶTestļµ1ļ
	'#  "/Test/*"  ƶTestļµļУļкļеļ
	'#  "/Test/T?/"  ƶTestļƥļУ˹ƥ/Test/T1//Test/T2/ȣ
	'# @param toPath: [String] (ַ)
	'# Ŀļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)ڵļнԶ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ƶ/Test/1/еļе/Test/2/
	'# Result = AB.Fso.MoveFolder("/Test/1/*","/Test/2/")
	'# AB.C.Print "ļƶ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function MoveFolder(ByVal fromPath, ByVal toPath)
		MoveFolder = FOFO(fromPath,toPath,1,1)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Move(fromPath, toPath) ƶļļ
	'# @return: Boolean (ֵ) ļ/ļƶɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ƶϵĵļУļеļкļļָļУ÷֧ͨ 
	'# Ҫʹͨƶļ/ļʹ AB.Fso.MoveFolderļУ AB.Fso.MoveFileļ
	'--DESC------------------------------------------------------------------------------------
	'# @param fromPath: [String] (ַ)
	'# ļ/ļԴ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ) 
	'# @param toPath: [String] (ַ)
	'# Ŀļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ) 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ƶ/Test/1/11//Test/2/
	'# Result = AB.Fso.Move("/Test/1/11/","/Test/2/")
	'# AB.C.Print "ļƶ" & AB.C.IIF(Result,"ɹ","ʧ")
	'# '------
	'# 'ƶ/Test/1/еTest.html/Test/2/
	'# Result = AB.Fso.Move("/Test/1/Test.html","/Test/2/")
	'# AB.C.Print "ļƶ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function Move(ByVal fromPath, ByVal toPath)
		Dim ff,tf : ff = absPath(fromPath) : tf = absPath(toPath)
		If isFile(ff) Then
			Move = MoveFile(fromPath,toPath)
		ElseIf isFolder(ff) Then
			Move = MoveFolder(fromPath,toPath)
		Else
			Move = False
			AB.Error.Msg = "(" & fromPath & ")"
			AB.Error.Raise 59
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.DelFile(path) ɾļ֧ͨ *  ? 
	'# @return: Boolean (ֵ) ļɾɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ɾϵĵļ֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ) Ҫɾļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ))֧ͨ *  ? 磺
	'# "/Test/1.asp"  ɾTestļµ1.asp
	'# "/Test/*"  ɾTestļµļļУ
	'# "/Test/*.html"  ɾTestļµк׺htmlļ
	'# "/Test/??st.ca?he"  ɾTestļƥļ˹ƥTest.cachelist.cabheȣ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ɾTestļеļ
	'# Result = AB.Fso.DelFile("/Test/*")
	'# AB.C.Print "ļɾ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function DelFile(ByVal path)
		DelFile = FOFO(path,"",0,2)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.DelFolder(path) ɾļУ֧ͨ *  ? 
	'# @alias: AB.Fso.RD(path)
	'# @return: Boolean (ֵ) ļɾɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ɾϵĵļУļмļеļ֧ͨ *  ?
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'# Ҫɾļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)֧ͨ *  ? 磺
	'#  "/Test/Test1/"  ɾTestļµTest1ļ
	'#  "/Test/*"  ɾTestļµļУļкļеļ
	'#  "/Test/*est1/"  ɾTestļͨƥļУ˹ƥTabcest1list1ȣ
	'#  "/Test/?sp?/"  ɾTestļͨƥļУ˹ƥAspȣ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ɾTestļеļ
	'# Result = AB.Fso.DelFolder("/Test/*")
	'# AB.C.Print "ļɾ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function DelFolder(ByVal path)
		DelFolder = FOFO(path,"",1,2)
	End Function

	Public Function RD(ByVal path)
		RD = DelFolder(path)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Del(path) ɾļļУ֧ͨ
	'# @return: Boolean (ֵ) ļ/ļɾɹ棨Trueʧܷؼ٣False
	'# @dowhat: ɾļļ, ɾɹTrue, ʧܷFalse
	'# ô˷ɾϵĵļУļеļкļļָļУ÷֧ͨ
	'# Ҫʹͨɾļ/ļʹ AB.Fso.DelFolderļУ AB.Fso.DelFileļ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'# Ҫɾļ/ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'ɾTestļеTest1ļ
	'# Result = AB.Fso.Del("/Test/Test1/")
	'# AB.C.Print "ļɾ" & AB.C.IIF(Result,"ɹ","ʧ")
	'# '------------------------------
	'# 'ɾTestļеTest.html
	'# Result = AB.Fso.Del("/Test/Test.html")
	'# AB.C.Print "ļɾ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function Del(ByVal path)
		Dim p : p = absPath(path)
		If isFile(p) Then
			Del = DelFile(path)
		ElseIf isFolder(p) Then
			Del = DelFolder(path)
		Else
			Del = False
			AB.Error.Msg = "(" & path & ")"
			AB.Error.Raise 60
		End If
		Err.Clear()
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.Rename(path, newName) ļļ
	'# @alias: AB.Fso.Ren(path, newName)
	'# @return: String (ַ) ļ/ļɹ棨Trueʧܷؼ٣False
	'# @dowhat: ô˷ϵļļ
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'# Ҫļ/ļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'# @param newName: [String] (ַ)
	'# ļļļ׺
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Fso"
	'# Dim Result
	'# 'TestļΪAspBox
	'# Result = AB.Fso.Rename("/Test/","AspBox")
	'# AB.C.PrintCn "ļ" & AB.C.IIF(Result,"ɹ","ʧ")
	'# '-----
	'# 'Test.htmlΪAB.html
	'# Result = AB.Fso.Ren("/Test.html","AB.html")
	'# AB.C.PrintCn "ļ" & AB.C.IIF(Result,"ɹ","ʧ")
	'------------------------------------------------------------------------------------------

	Public Function Rename(ByVal path, ByVal newname)
		Dim p,n : p = absPath(path) : Rename = True
		n = Left(p,InstrRev(p,"\")) & newname
		If Not isExists(p) Then
			Rename = False
			AB.Error.Msg = "(" & path & ")"
			AB.Error.Raise 61
			Exit Function
		End If
		If isExists(n) Then
			Rename = False
			AB.Error.Msg = "(" & newname & ")"
			AB.Error.Raise 62
			Exit Function
		End If
		If isFolder(p) Then
			Fso.MoveFolder p,n
		ElseIf isFile(p) Then
			Copy p, n
			Del p
		End If
	End Function

	Public Function Ren(ByVal path, ByVal newname)
		Ren = Rename(path,newname)
	End Function

	Private Function absPath(ByVal p)
		Dim pt
		If AB.C.IsNul(p) Then absPath = "" : Exit Function
		If Mid(p,2,1)<>":" Then
			If isWildcards(p) Then
				p = Replace(p,"*","[.$.[a.b.s.t.a.r].#.]")
				p = Replace(p,"?","[.$.[a.b.q.u.e.s].#.]")
				p = Server.MapPath(p)
				p = Replace(p,"[.$.[a.b.q.u.e.s].#.]","?")
				p = Replace(p,"[.$.[a.b.s.t.a.r].#.]","*")
			Else
				p = Server.MapPath(p)
			End If
		Else
			If Left(LCase(Trim(p)),8) = "file:///" Then
				p = Trim(Replace(p,"file:///",""))
			End If
			p = Replace(p,"/","\")
		End If
		If Right(p,1) = "\" Then p = Left(p,Len(p)-1)
		absPath = p
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Fso.MapPath(path) ȡļļе·
	'# @return: String (ַ) ļļеӲ̾·("̷:\"ͷ)
	'# @dowhat: ȡļļе·, ˷Server.MapPath(path)
	'--DESC------------------------------------------------------------------------------------
	'# @param path: [String] (ַ)
	'# ļļе··Ҳվ·(/ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Function MapPath(p)
		MapPath = absPath(p)
	End Function

	Public Function formatSize(Byval fileSize, ByVal level)
		Dim s : s = Int(fileSize) : level = UCase(level)
		formatSize = AB.C.IIF(s/(1073741824)>0.01,FormatNumber(s/(1073741824),2,-1,0,-1),"0.01") & " GB"
		If s = 0 Then formatSize = "0 GB"
		If level = "G" Or (level="AUTO" And s>1073741824) Then Exit Function
		formatSize = AB.C.IIF(s/(1048576)>0.1,FormatNumber(s/(1048576),1,-1,0,-1),"0.1") & " MB"
		If s = 0 Then formatSize = "0 MB"
		If level = "M" Or (level="AUTO" And s>1048576) Then Exit Function
		formatSize = AB.C.IIF((s/1024)>1,Int(s/1024),1) & " KB"
		If s = 0 Then formatSize = "0 KB"
		If s = -1 Then formatSize = "-1 KB"
		If Level = "K" Or (level="AUTO" And s>1024) Then Exit Function
		If level = "B" or level = "AUTO" Then
			formatSize = s & " bytes"
		Else
			formatSize = s
		End If
	End Function

	Private Function isWildcards(ByVal path)
		isWildcards = False
		If Instr(path,"*")>0 Or Instr(path,"?")>0 Then isWildcards = True
	End Function

	Private Function FOFO(ByVal fromPath, ByVal toPath, ByVal FOF, ByVal MOC)
		On Error Resume Next
		FOFO = True
		Dim ff,tf,oc,of,oi,ot,os
		ff = absPath(fromPath) : tf = absPath(toPath)
		If FOF = 0 Then
			oc = isFile(ff) : of = "File" : oi = "ļ"
		ElseIf FOF = 1 Then
			oc = isFolder(ff) : of = "Folder" : oi = "ļ"
		End If
		If MOC = 0 Then
			ot = "Copy" : os = ""
		ElseIf MOC = 1 Then
			ot = "Move" : os = "ƶ"
		ElseIf MOC = 2 Then
			ot = "Delete" : os = "ɾ"
		End If
		If oc Then
			If MOC<>2 Then
				If FOF = 0 Then
					If Right(toPath,1)="/" or Right(toPath,1)="\" Then
						FOFO = MD(tf) : tf = tf & "\"
					Else
						FOFO = MD(Left(tf,InstrRev(tf,"\")-1))
					End If
				ElseIf FOF = 1 Then
					tf = tf & "\"
					FOFO = MD(tf)
				End If
				Execute("Fso."&ot&of&" ff,tf"&AB.C.IfThen(MOC=0,",b_overwrite"))
			Else
				Execute("Fso."&ot&of&" ff,b_force")
			End If
			If Err.Number<>0 Then
				FOFO = False
				AB.Error.Msg = "<br />" & os & oi & "ʧܣ" & "( "&frompath&" "&AB.C.IIF(MOC=2,"",os&" "&toPath)&" )"
				AB.Error.Raise 63
			End If
		ElseIf isWildcards(ff) Then
			If MOC<>2 Then
				FOFO = MD(tf)
				Execute("Fso."&ot&of&" ff,tf"&AB.C.IIF(MOC=0,",b_overwrite",""))
			Else
				Execute("Fso."&ot&of&" ff,b_force")
			End If
			If Err.Number<>0 Then
				FOFO = False
				AB.Error.Msg = "<br />" & os & oi & "ʧܣ" & "( "&frompath&" "&AB.C.IIF(MOC=2,"",os&" "&toPath)&" )"
				AB.Error.Raise 63
			End If
		Else
			FOFO = False
			AB.Error.Msg = "<br />" & os & oi & "ʧܣ" & AB.C.IIF(MOC=2,"","Դ")&oi&"( "&frompath&" )"
			AB.Error.Raise 63
		End If
		On Error Goto 0
	End Function

	Private Function Attr2Str(ByVal attrib)
		Dim a,s : a = Int(attrib)
		If a>=2048 Then a = a - 2048
		If a>=1024 Then a = a - 1024
		If a>=32 Then : s = "A" : a = a- 32 : End If
		If a>=16 Then a = a- 16
		If a>=8 Then a = a - 8
		If a>=4 Then : s = "S" & s : a = a- 4 : End If
		If a>=2 Then : s = "H" & s : a = a- 2 : End If
		If a>=1 Then : s = "R" & s : a = a- 1 : End If
		Attr2Str = s
	End Function

End Class

Class ImgWHInfo
	Private s_fsoName, s_steamName
	Private Sub Class_Initialize
		s_fsoName 	= AB.FsoName
		s_steamName	= AB.steamName
	End Sub
	Private Function Num2Str(ByVal Num,ByVal Base,ByVal Lens)
		Dim Ret
		Ret = ""
		While(Num>=Base)
			Ret = (Num Mod Base) & Ret
			Num = (Num - Num Mod Base)/Base
		Wend
		Num2Str = Right(String(Lens,"0") & Num & Ret,Lens)
	End Function
	Private Function Str2Num(ByVal Str,ByVal Base)
		Dim Ret,I
		Ret = 0
		For I=1 To Len(Str)
			Ret = Ret *base + Cint(Mid(Str,I,1))
		Next
		Str2Num=Ret
	End Function
	Private Function BinVal(ByVal Bin)
		Dim Ret,I
		Ret = 0
		For I = LenB(Bin) To 1 Step -1
			Ret = Ret *256 + AscB(MidB(Bin,I,1))
		Next
		BinVal=Ret
	End Function
	Private Function BinVal2(ByVal Bin)
		Dim Ret,I
		Ret = 0
		For I = 1 To LenB(Bin)
			Ret = Ret *256 + AscB(MidB(Bin,I,1))
		Next
		BinVal2=Ret
	End Function
	Private Function GetImageSize(ByVal filespec)
		Dim bFlag, Ret(3), o_steam
		Set o_steam = Server.CreateObject(s_steamName)
		With o_steam
			.Mode = 3
			.Type = 1 'Զģʽ(adTypeBinary)
			.Open
			.LoadFromFile filespec
		End With
		bFlag = o_steam.Read(3)
		Select Case Hex(binVal(bFlag))
			Case "4E5089":
				o_steam.Read(15)
				ret(0)="PNG"
				ret(1)=BinVal2(o_steam.Read(2))
				o_steam.Read(2)
				ret(2)=BinVal2(o_steam.Read(2))
			Case "464947":
				o_steam.read(3)
				ret(0)="GIF"
				ret(1)=BinVal(o_steam.Read(2))
				ret(2)=BinVal(o_steam.Read(2))
			Case "535746":
				o_steam.read(5)
				binData=o_steam.Read(1)
				sConv=Num2Str(ascb(binData),2,8)
				nBits=Str2Num(left(sConv,5),2)
				sConv=mid(sConv,6)
				While(len(sConv)<nBits*4)
					binData=o_steam.Read(1)
					sConv=sConv&Num2Str(AscB(binData),2,8)
				Wend
				ret(0)="SWF"
				ret(1)=Int(Abs(Str2Num(Mid(sConv,1*nBits+1,nBits),2)-Str2Num(Mid(sConv,0*nBits+1,nBits),2))/20)
				ret(2)=Int(Abs(Str2Num(Mid(sConv,3*nBits+1,nBits),2)-Str2Num(Mid(sConv,2*nBits+1,nBits),2))/20)
			Case "FFD8FF":
				Do
				Do: p1=binVal(o_steam.Read(1)): Loop While p1=255 And Not o_steam.EOS
				If p1>191 And p1<196 Then Exit Do Else o_steam.read(binval2(o_steam.Read(2))-2)
				Do:p1=binVal(o_steam.Read(1)):Loop While p1<255 And Not o_steam.EOS
				Loop While True
				o_steam.Read(3)
				ret(0)="JPG"
				ret(2)=binval2(o_steam.Read(2))
				ret(1)=binval2(o_steam.Read(2))
			Case Else:
				AB.Use "Char"
				If left(AB.Char.Bin2Str(bFlag),2)="BM" Then
					o_steam.Read(15)
					ret(0)="BMP"
					ret(1)=binval(o_steam.Read(4))
					ret(2)=binval(o_steam.Read(4))
				Else
					ret(0)=""
				End If
		End Select
		o_steam.Close
		Set o_steam = Nothing
		ret(3)="width=""" & ret(1) &""" height=""" & ret(2) &""""
		getimagesize=ret
	End Function
	''ȡͼƬȺ͸߶ȵ֧࣬JPGGIFPNGBMP
	Public Function imgWH(ByVal IMGPath)
		Dim fso,IMGFile,FileExt,Arr
		Dim imgW,imgH: imgW = 0: imgH = 0
		Set fso = Server.CreateObject(s_fsoName)
		If (fso.FileExists(IMGPath)) Then
			Set IMGFile = fso.GetFile(IMGPath)
			FileExt=fso.GetExtensionName(IMGPath)
			Select Case FileExt
			Case "gif","bmp","jpg","png":
			Arr=GetImageSize(IMGFile.Path)
			imgW = Arr(1)
			imgH = Arr(2)
			End Select
			Set IMGFile=Nothing
		Else
			imgW = 0
			imgH = 0
		End If
		Set fso=Nothing
		imgWH = Array(imgW, imgH)
	End Function
End Class
%>