<%
'######################################################################
'## ab.http.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox XMLHTTP Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2013/02/17 22:12
'## Description :   Request XMLHttp Data in AspBox
'## http://msdn.microsoft.com/en-us/library/ms535874(VS.85).aspx
'######################################################################

Class Cls_AB_Http
	Public Url, Method, CharSet, Async, User, Password, Html, Headers, Body, Text, SaveRandom
	Public ResolveTimeout, ConnectTimeout, SendTimeout, ReceiveTimeout
	Private s_data, s_url, s_ohtml, o_rh', a_rh()

	Private Sub Class_Initialize
		CharSet = AB.CharSet
		Async = False
		User = ""
		Password = ""
		s_data = ""
		s_url = ""
		Html = ""
		Headers = ""
		Body = Empty
		Text = Empty
		SaveRandom = True
		ResolveTimeout = 20000
		ConnectTimeout = 20000
		SendTimeout = 300000
		ReceiveTimeout = 60000
		AB.Error(46) = "Զ̷ûӦ"
		AB.Error(47) = "֧XMLHTTP"
		AB.Error(48) = "ҪȡҳַΪ"
		AB.Use "List"
		Set o_rh = AB.List.New
	End Sub

	Private Sub Class_Terminate
		Set o_rh = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Http.New 
	'# @syntax: Set http = AB.Http.New
	'# @return: Object (ASP)
	'# @dowhat: HttpĶ, һ AspBox_Http 
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# Dim http : Set http = AB.Http.New 	'HttpĶ
	'------------------------------------------------------------------------------------------

	Public Function [New]()
		Set [New] = New Cls_AB_Http
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Url 
	'# @syntax: AB.Http.Url[ = string]
	'# @return: String (ַ) ҪȡݵԶURLַ
	'# @dowhat: ҪȡԶļַԿɶд
	'#  ԿҪȡԶļַֻ AB.Http.Open ȡʱЧ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Http.Method 
	'# @syntax: AB.Http.Method[ = string]
	'# @return: String (ַ) ǰõʽ
	'# @dowhat: ûȡԶļʱݵķʽ˷ɶд
	'#  ͨԿûȡԶļʱķʽͨ "GET"  "POST" ʽĬΪ "GET"
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Http.CharSet 
	'# @syntax: AB.Http.CharSet = charset
	'# @return: String (ַ) õԶļı
	'# @dowhat: ָԶļı룬Կɶд
	'#  ָԶļı룬Ǳļʹõı룬òȷȡԶļпհס
	'#  ֵΪ"UTF-8""GB2312"ȡĬΪ AB.CharSet ֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param: charset String (ַ)
	'# ַַ磺
	'# "BIG5" - 
	'# "GB2312" - 
	'# "KOI8-R" - 
	'# "UTF-8" - ASCIIݵĶֽ8
	'# ĬΪ AB.CharSet ֵ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# AB.Http.CharSet = "UTF-8"
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Http.Data (ֻд)
	'# @syntax: AB.Http.Data = data
	'# @return: ޷ֵ
	'# @dowhat: ڻȡԶļʱҪͬʱύݣֻֻд
	'#  ʹGETPOSTʽȡԶʱͨͬʱύݡ
	'#  GETURLķʽЩݣPOSTƱһύЩݡ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim url : url = "http://so.zhulang.com/search.php"
	'# 'h.SetHeader "referer:www.zhulang.com"
	'# 'h.SetHeader "content-type:application/x-www-form-urlencoded"
	'# h.Method = "POST"
	'# 'h.Async = False
	'# Dim key : key = ""
	'# 'AB.Use "E" : key = AB.E.escape(key) 'ԶΪasp,һescape
	'# AB.Use "E" : key = AB.E.encodeURIComponent(key) 'ԶΪphp,һencodeURIComponent
	'# h.Data = "t=zh&k=" & key
	'# h.Charset = "UTF-8"
	'# Dim str : str = h.Post(url)
	'# Set h = Nothing
	'# AB.C.Print str
	'------------------------------------------------------------------------------------------

	Public Property Let Data(ByVal s)
		s_data = s
	End Property

	Public Sub SetHeader(ByVal a)
		Dim i,n,v
		If isArray(a) Then
			For i = 0 To Ubound(a)
				n = LCase(Replace(Trim(AB.C.Cleft(a(i),":")),"-","_"))
				v = AB.C.CRight(a(i),":")
				o_rh(n) = v
			Next
		Else
			n = LCase(Replace(Trim(AB.C.Cleft(a,":")),"-","_"))
			v = AB.C.CRight(a,":")
			o_rh(n) = v
		End If
	End Sub

	Public Property Let RequestHeader(ByVal n, ByVal v)
		n = Replace(n,"-","_")
		o_rh(n) = v
	End Property

	Public Property Get RequestHeader(ByVal n)
		If AB.C.Has(n) Then
			RequestHeader = o_rh(n)
		Else
			RequestHeader = Join(o_rh.Hash,vbCrLf)
		End If
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Http.Open 
	'# @syntax: AB.Http.Open
	'# @return: String (ַ) ĿԶ̵ַԴַ
	'# @dowhat: ÷ʽȡԶļ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.url = "http://www.baidu.com/index.php"
	'# 'h.method = "GET"
	'# 'h.async = False
	'# 'h.charset = AB.CharSet
	'# 'h.data = ""
	'# 'h.user = "" : h.password = ""
	'# Dim str : str = h.Open
	'# Set h = Nothing
	'# AB.C.Print str
	'------------------------------------------------------------------------------------------

	Public Function [Open]
		[Open] = GetData(Url, Method, Async, s_data, User, Password)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Get 
	'# @syntax: AB.Http.Get url
	'# @return: String (ַ) ĿԶ̵ַԴַ
	'# @dowhat: GETʽԶļ
	'--DESC------------------------------------------------------------------------------------
	'# @param url: [String] (ַ) ĿԶ̵ַ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim str : str = h.Get("http://www.baidu.com/index.php")
	'# Set h = Nothing
	'# AB.C.Print str
	'------------------------------------------------------------------------------------------

	Public Function [Get](ByVal uri)
		[Get] = GetData(uri, "GET", Async, s_data, User, Password)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Post 
	'# @syntax: AB.Http.Post url
	'# @return: String (ַ) ĿԶ̵ַԴַ
	'# @dowhat: POSTʽԶļ
	'--DESC------------------------------------------------------------------------------------
	'# @param url: [String] (ַ) ĿԶ̵ַ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim str : str = h.Post("https://passport.baidu.com/?login")
	'# Set h = Nothing
	'# AB.C.Print str
	'------------------------------------------------------------------------------------------

	Public Function Post(ByVal uri)
		Post = GetData(uri, "POST", Async, s_data, User, Password)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.GetData 
	'# @syntax: AB.Http.GetData url, method, async, data, user, password
	'# @return: String (ַ) ĿԶ̵ַԴַ
	'# @dowhat: òõķʽȡԶļ
	'--DESC------------------------------------------------------------------------------------
	'# @param url: [String] (ַ) ĿԶ̵ַ
	'# @param method: [String] (ַ) ʽGET  POSTĬΪGET
	'# @param async: [Boolean] (ֵ) ָǷΪ첽ʽTrue / FalseĬΪFalse
	'# @param data: [String] (ַ) POST͵, ĬΪ
	'# @param user: [String] (ַ)
	'#  Ҫ֤˴ָûδָҪ֤ʱᵯ֤, ĬΪ
	'# @param password: [String] (ַ) ֤Ϣе벿֣ûΪգֵ, ĬΪ
	'--DEMO------------------------------------------------------------------------------------
	'# '-------GETȡԴ---------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim url : url = "http://www.baidu.com/index.php"
	'# 'h.SetHeader "referer:www.baidu.com"
	'# 'h.SetHeader "content-type:application/x-www-form-urlencoded"
	'# Dim method : method = "GET"
	'# Dim async : async = False
	'# Dim data : data = ""
	'# Dim user : user = ""
	'# Dim password : password = ""
	'# Dim charset : charset = AB.CharSet : h.charset = charset
	'# Dim str : str = h.GetData(url, method, async, data, user, password)
	'# 'str = h.GetData(url, "", "", "", "", "")
	'# Set h = Nothing
	'# AB.C.Print str
	'# '-------aspģPOSTύ---------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim url : url = "http://www.ip138.com/ips1388.asp"
	'# h.SetHeader "content-type:application/x-www-form-urlencoded"
	'# h.SetHeader "referer:www.ip138.com"
	'# Dim method : method = "POST"
	'# Dim async : async = False
	'# Dim data : data = "ip=14.1.20.91&action=2"
	'# Dim user : user = ""
	'# Dim password : password = ""
	'# Dim charset : charset = AB.CharSet : h.charset = charset
	'# Dim str : str = h.GetData(url, method, async, data, user, password)
	'# Set h = Nothing
	'# AB.C.Print str
	'------------------------------------------------------------------------------------------

	Public Function GetData(ByVal uri, ByVal m, ByVal async, ByVal data, ByVal u, ByVal p)
		Dim o,chru
		'Set o = CreateHTTPPoster(1)
		If AB.C.isInstall("MSXML2.serverXMLHTTP") Then
			Set o = Server.CreateObject("MSXML2.serverXMLHTTP")
		ElseIf AB.C.isInstall("MSXML2.XMLHTTP") Then
			Set o = Server.CreateObject("MSXML2.XMLHTTP")
		ElseIf AB.C.isInstall("Microsoft.XMLHTTP") Then
			Set o = Server.CreateObject("Microsoft.XMLHTTP")
		Else
			AB.Error.Raise 47
			Exit Function
		End If
		o.SetTimeOuts ResolveTimeout, ConnectTimeout, SendTimeout, ReceiveTimeout
		If AB.C.IsNul(uri) Then AB.Error.Raise 48 : Exit Function
		If AB.C.Test(uri,"^[\w\d-]+>https?://") Then
			CharSet = AB.C.Cleft(uri,">")
			uri = AB.C.CRight(uri,">")
		End If
		s_url = uri
		m = AB.C.IIF(AB.C.Has(m),UCase(m),"GET")
		If AB.C.IsNul(async) Then async = False
		If m = "GET" And AB.C.Has(data) Then uri = uri & AB.C.IIF(Instr(uri,"?")>0, "&", "?") & Serialize__(data)
		If AB.C.Has(u) Then
			o.open m, uri, async, u, p
		Else
			o.open m, uri, async
		End If
		If m = "POST" Then
			If Not o_rh.HasIndex("content_type") Then
				o_rh("content_type") = "application/x-www-form-urlencoded"
			End If
			SetHeaderTo o
			o.send Serialize__(data)
		Else
			SetHeaderTo o
			o.send
		End If
		If o.readyState <> 4 Then
			GetData = "error:server is down"
			Set o = Nothing
			AB.Error.Raise 46
			Exit Function
		ElseIf o.Status = 200 Then
			Headers = o.getAllResponseHeaders()
			Body = o.responseBody
			Text = o.responseText
			If AB.C.IsNul(CharSet) Then
				If AB.C.Test(Headers,"charset=([\w-]+)") Then
					CharSet = AB.C.RegReplace(Headers,"([\s\S]+)charset=([\w-]+)([\s\S]+)","$2")
				ElseIf AB.C.Test(Headers,"Content-Type: ?text/xml") Then
					CharSet = AB.C.RegReplace(Text,"^<\?xml\s+[^>]+encoding\s*=\s*""([^""]+)""[^>]*\?>([\s\S]+)","$1")
				ElseIf AB.C.Test(Text,"<meta\s+http-equiv\s*=\s*[""']?content-type[""']?\s+content\s*=\s*[""']?[^>]+charset\s*=\s*([\w-]+)[^>]*>") Then
					CharSet = AB.C.RegReplace(Text,"([\s\S]+)<meta\s+http-equiv\s*=\s*[""']?content-type[""']?\s+content\s*=\s*[""']?[^>]+charset\s*=\s*([\w-]+)[^>]*>([\s\S]+)","$2")
				End If
				If AB.C.IsNul(CharSet) Then CharSet = AB.CharSet
			End If
			GetData = Bytes2Bstr__(Body, CharSet)
		Else
			GetData = "error:" & o.Status & " " & o.StatusText
		End If
		Set o = Nothing
		s_ohtml = GetData
		Html = s_ohtml
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.CreateHTTPPoster 
	'# @syntax: [Set obj =] AB.Http.CreateHTTPPoster(soc)
	'# @return: Object (ASP) ԭʼ XMLHTTP
	'# @dowhat: һܸ߰汾XMLHTTP
	'--DESC------------------------------------------------------------------------------------
	'# @param soc: [Integer] () ǷΪ ServerXMLHTTP  XMLHTTP Ķ
	'--DEMO------------------------------------------------------------------------------------
	'# Dim XmlHttp : Set XmlHttp = AB.Http.CreateHTTPPoster(0)
	'------------------------------------------------------------------------------------------

	Public Function CreateHTTPPoster(soc)
		Dim s
		If soc = 1 Then : s = "ServerXMLHTTP" : Else : s = "XMLHTTP" : End If
		On Error Resume Next
		Set CreateHTTPPoster = Server.CreateObject("MSXML2." & s & ".4.0")
		If Err.Number<>0 Then
			Err.Clear
			Set CreateHTTPPoster = Server.CreateObject("MSXML2." & s & ".3.0")
			If Err.Number<>0 Then
				Err.Clear
				Set CreateHTTPPoster = Server.CreateObject("MSXML2." & s)
				If Err.Number<>0 Then
					Set CreateHTTPPoster = Nothing
				Else
					Exit Function
				End If
			Else
				Exit Function
			End If
		Else
			Exit Function
		End If
		On Error GoTo 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Find 
	'# @syntax: AB.Http.Find regex
	'# @return: String (ַ) ƥʽַ
	'# @dowhat: ڽв׸ƥʽַ
	'#  ô˷ԷضȡԶļĽƥеʽַ
	'#  жƥ䣬򷵻ص1ƥĽ
	'--DESC------------------------------------------------------------------------------------
	'# @param regex: [String] (ַ) ʽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.Get("http://www.baidu.com/index.php")
	'# Dim str : str = h.Find("<img[\s]+src=""[^""]*""[^>]*>")
	'# Set h = Nothing
	'# AB.C.Print str
	'淵ؽ磺<img src="http://www.baidu.com/img/baidu_sylogo1.gif" width="270" height="129">
	'------------------------------------------------------------------------------------------

	Public Function Find(ByVal rule)
		Find = Find_(s_ohtml, rule)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Find_ 
	'# @syntax: AB.Http.Find_ string, regex
	'# @return: String (ַ) ڽַƥʽַ
	'# @dowhat: ڽַв׸ƥʽַ
	'#  ô˷ָĽַƥеʽַ
	'#  ַжƥ䣬򷵻ص1ƥĽ
	'--DESC------------------------------------------------------------------------------------
	'# @param string: [String] (ַ) ָĽַ
	'# @param regex: [String] (ַ) ʽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim s : s = h.Get("http://www.baidu.com/index.php")
	'# Dim str : str = h.Find_(s, "<img[\s]+src=""[^""]*""[^>]*>")
	'# Set h = Nothing
	'# AB.C.Print str
	'淵ؽ磺<img src="http://www.baidu.com/img/baidu_sylogo1.gif" width="270" height="129">
	'------------------------------------------------------------------------------------------

	Public Function Find_(ByVal s, ByVal rule)
		If AB.C.Test(s,rule) Then Find_ = AB.C.RegReplace(s,"([\s\S]*?)("&rule&")([\s\S]*)","$2")
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Select 
	'# @syntax: AB.Http.Select regex, result
	'# @return: String (ַ) ȡԶļĽоѡ滻ı
	'# @dowhat: ڶȡԶļĽаѡ滻ƥı
	'#  ô˷԰ regex еʽѡƥַ
	'#  ڲ result е$NƥĽؾѡַ
	'--DESC------------------------------------------------------------------------------------
	'# @param regex: [String] (ַ) ʽ
	'# @param result: [String] (ַ) $NƥĽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.Get("http://www.baidu.com/index.php")
	'# Dim str : str = h.Select("<img[\s]+src=""([^""]*)""[^>]*>", "$1")
	'# Set h = Nothing
	'# AB.C.Print str
	'淵ؽ磺http://www.baidu.com/img/baidu_sylogo1.gif
	'------------------------------------------------------------------------------------------

	Public Function [Select](ByVal rule, ByVal part)
		[Select] = Select_(s_ohtml, rule, part)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Select_ 
	'# @syntax: AB.Http.Select_ string, regex, result
	'# @return: String (ַ) ָĽַѡ滻ı
	'# @dowhat: ָĽַаѡ滻ƥı
	'#  ô˷԰ regex еʽѡƥַ
	'#  ڲ result е$NƥĽؾѡַ
	'--DESC------------------------------------------------------------------------------------
	'# @param string: [String] (ַ) ָĽַ
	'# @param regex: [String] (ַ) ʽ
	'# @param result: [String] (ַ) $NƥĽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim s : s = h.Get("http://www.baidu.com/index.php")
	'# Dim str : str = h.Select_(s, "<img[\s]+src=""([^""]*)""[^>]*>", "$1")
	'# Set h = Nothing
	'# AB.C.Print str
	'淵ؽ磺http://www.baidu.com/img/baidu_sylogo1.gif
	'------------------------------------------------------------------------------------------

	Public Function Select_(ByVal s, ByVal rule, ByVal part)
		If AB.C.Test(s,rule) Then
			part = Replace(part,"$0",Find_(s,rule))
			Select_ = AB.C.RegReplace(s,"(?:[\s\S]*?)(?:"&rule&")(?:[\s\S]*)",part)
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Search 
	'# @syntax: AB.Http.Search regex
	'# @return: Array () ذַ
	'# @dowhat: ڶȡԶļĽаʽȡѭַ
	'#  ô˷԰ѶȡԶļĽ밴ʽƥ䣬
	'#  ƥ䵽һŵв顣
	'--DESC------------------------------------------------------------------------------------
	'# @param regex: [String] (ַ) ʽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.Get("http://www.baidu.com/index.php")
	'# Dim arr : arr = h.Search("<img[\s]+src=""[^""]*""[^>]*>")
	'# Set h = Nothing
	'# AB.Trace arr
	'淵ؽ磺
	'arr(0) = "<img src=""http://www.baidu.com/img/baidu_sylogo1.gif"" width=""270"" height=""129"">"
	'arr(1) = "<img src=""http://www.baidu.com/cache/global/img/gs.gif"">"
	'------------------------------------------------------------------------------------------

	Public Function Search(ByVal rule)
		Search = Search_(s_ohtml, rule)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.Search_ 
	'# @syntax: AB.Http.Search_ string, regex
	'# @return: Array () ذַ
	'# @dowhat: ڽַаʽȡѭַ
	'#  ô˷ָĽַаʽƥ䣬
	'#  ƥ䵽һŵв顣
	'--DESC------------------------------------------------------------------------------------
	'# @param string: [String] (ַ) ָĽַ
	'# @param regex: [String] (ַ) ʽ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# Dim s : s = h.Get("http://www.baidu.com/index.php")
	'# Dim arr : arr = h.Search_(s, "<img[\s]+src=""[^""]*""[^>]*>")
	'# Set h = Nothing
	'# AB.Trace arr
	'淵ؽ磺
	'arr(0) = "<img src=""http://www.baidu.com/img/baidu_sylogo1.gif"" width=""270"" height=""129"">"
	'arr(1) = "<img src=""http://www.baidu.com/cache/global/img/gs.gif"">"
	'------------------------------------------------------------------------------------------

	Public Function Search_(ByVal s, ByVal rule)
		Dim matches,match,arr(),i : i = 0
		Set matches = AB.C.RegMatch(s,rule)
		ReDim arr(matches.Count-1)
		For Each match In matches
			arr(i) = match.Value
			i = i + 1
		Next
		Set matches = Nothing
		Search_ = arr
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.SubStr 
	'# @syntax: AB.Http.SubStr beginCode, endCode, type
	'# @return: String (ַ) ȡַ
	'# @dowhat: ڽаʼͽǩȡַ
	'#  ô˷԰ѶȡԶļԴ밴ʼͽнȡشӿʼ뵽ַ֮
	'--DESC------------------------------------------------------------------------------------
	'# @param beginCode: [String] (ַ) ʼ
	'# @param endCode:   [String] (ַ) 
	'# @param type:      [Integer] () ͣͲͬ򷵻ؽͬ
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.Get("http://www.baidu.com/index.php")
	'# Dim str : str = h.SubStr("<div id=""u"">", "</div>", type)
	'# Set h = Nothing
	'# AB.C.Print str
	'# ------------------
	'# === type = 1 ʱ
	'# <div id="u"><a href="http://www.baidu.com/gaoji/preferences.html" name="tj_setting"></a>|<a href="https://passport.baidu.com/v2/?login&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" name="tj_login">¼</a><a href="https://passport.baidu.com/v2/?reg&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" target="_blank" name="tj_reg" class="reg">ע</a></div>
	'# === type = 2 ʱ
	'# <div id="u"><a href="http://www.baidu.com/gaoji/preferences.html" name="tj_setting"></a>|<a href="https://passport.baidu.com/v2/?login&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" name="tj_login">¼</a><a href="https://passport.baidu.com/v2/?reg&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" target="_blank" name="tj_reg" class="reg">ע</a>
	'# === type = 3 ʱ
	'# <a href="http://www.baidu.com/gaoji/preferences.html" name="tj_setting"></a>|<a href="https://passport.baidu.com/v2/?login&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" name="tj_login">¼</a><a href="https://passport.baidu.com/v2/?reg&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" target="_blank" name="tj_reg" class="reg">ע</a></div>
	'# === type = 0   ʱ
	'# <a href="http://www.baidu.com/gaoji/preferences.html" name="tj_setting"></a>|<a href="https://passport.baidu.com/v2/?login&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" name="tj_login">¼</a><a href="https://passport.baidu.com/v2/?reg&tpl=mn&u=http%3A%2F%2Fwww.baidu.com%2F" target="_blank" name="tj_reg" class="reg">ע</a>
	'------------------------------------------------------------------------------------------

	Public Function SubStr(ByVal tagStart, ByVal tagEnd, ByVal tagSelf)
		SubStr = SubStr_(s_ohtml,tagStart,tagEnd,tagSelf)
	End Function

	Public Function SubStr_(ByVal s, ByVal tagStart, ByVal tagEnd, ByVal tagSelf)
		Dim posA, posB, first, between
		posA = instr(1,s,tagStart,1)
		If posA=0 Then SubStr_ = "Դв˿ʼǩ" : Exit Function
		posB = instr(PosA+Len(tagStart),s,tagEnd,1)
		If posB=0 Then SubStr_ = "Դв˽ǩ" : Exit Function
		Select Case tagSelf
			Case 1
				first = posA
				between = posB+len(tagEnd)-first
			Case 2
				first = posA
				between = posB-first
			Case 3
				first = posA+len(tagStart)
				between = posB+len(tagEnd)-first
			Case Else
				first = posA+len(tagStart)
				between = posB-first
		End Select
		SubStr_ = Mid(s,first,between)
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.SaveImgTo 
	'# @syntax: AB.Http.SaveImgTo p
	'# @return: String (ַ) ȡԶļкԶͼƬַز滻ΪͼƬַؽַ
	'# @dowhat: Զ̴еԶͼƬ滻ΪͼƬַ
	'#  ȡԶ̴кԶͼƬַز滻ΪͼƬַؽַ
	'--DESC------------------------------------------------------------------------------------
	'# @param p: [String] (ַ) ָĿ¼ΪΪǰĿ¼
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Http"
	'# Dim h : Set h = AB.Http.New
	'# h.Get("http://www.baidu.com/index.php")
	'# AB.C.Print h.SaveImgTo("img/")
	'# Set h = Nothing
	'------------------------------------------------------------------------------------------

	Public Function SaveImgTo(ByVal p)
		SaveImgTo = SaveImgTo_(s_ohtml,p)
	End Function

	Public Function SaveImgTo_(ByVal s, ByVal p)
		Dim a,b, i, img, ht, tmp, src
		a = AB.C.GetImg(s)
		b = AB.C.GetImgTag(s)
		If AB.C.Has(a) Then
			AB.Use "Fso"
			For i = 0 To Ubound(a)
				If SaveRandom Then
					img = AB.C.DateTime(Now,"ymmddhhiiss"&AB.C.RandStr("5:0123456789")) & Mid(a(i),InstrRev(a(i),"."))
				Else
					img = Mid(a(i),InstrRev(a(i),"/")+1)
				End If
				Set ht = AB.Http.New
				ht.Get TransPath(s_url, a(i))
				tmp = AB.Fso.SaveAs(p & img, ht.Body)
				Set ht = Nothing
				If tmp Then
					src = AB.C.RegReplace(b(i),"(<img\s[^>]*src\s*=\s*([""|']?))("&a(i)&")(\2[^>]*>)","$1"&p&img&"$4")
					s = Replace(s,b(i),src)
				End If
			Next
		End If
		SaveImgTo_ = s
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Http.AjaxAgent 
	'# @syntax: AB.Http.AjaxAgent()
	'# @return: String (ַ) ԶԴ
	'# @dowhat: ͨʹaburlĿַȡԶԴ
	'--DESC------------------------------------------------------------------------------------
	'# @param p: [String] (ַ) ָĿ¼ΪΪǰĿ¼
	'--DEMO------------------------------------------------------------------------------------
	'# 'url: /test.asp?aburl=http://www.baidu.com/index.php
	'# AB.Use "Http"
	'# AB.Http.AjaxAgent()
	'------------------------------------------------------------------------------------------

	Public Sub AjaxAgent()
		AB.C.NoCache()
		Dim u, qs, qskey, qf, qfkey, m
		u = AB.C.Get("aburl")
		If AB.C.IsNul(u) Then AB.C.Put "error:Invalid URL"
		If Instr(u,"?")>0 Then
			qs = "&" & AB.C.CRight(u,"?")
			u = AB.C.Cleft(u,"?")
		End If
		If Request.QueryString()<>"" Then
			For Each qskey In Request.QueryString
				If qskey<>"aburl" Then qs = qs & "&" & qskey & "=" & Request.QueryString(qskey)
			Next
		End If
		u = u & AB.C.IfThen(AB.C.Has(qs),"?" & Mid(qs,2))
		m = Request.ServerVariables("REQUEST_METHOD")
		If m = "POST" Then
			If Request.Form()<>"" Then
				For Each qfkey In Request.Form
					qf = qf & "&" & qfkey & "=" & Request.Form(qfkey)
				Next
				Data = Mid(qf,2)
			End If
			AB.C.Put Post(u)
		Else
			AB.C.Put [Get](u)
		End If
	End Sub

	Function TransPath(ByVal u, ByVal p)
		If Left(p,7)="http://" Or Left(p,8)="https://" Then TransPath = p : Exit Function
		Dim tmp,ser, fol
		tmp = AB.C.Cleft(u,"?")
		If Left(u,7)<>"http://" And Left(u,8)<>"https://" Then
			ser = ""
		Else
			ser = AB.C.RegReplace(tmp,"^(https?://[a-zA-Z0-9-.]+)/(.+)$","$1")
		End If
		fol = Mid(tmp,1,InstrRev(tmp,"/"))
		TransPath = AB.C.IIF(Left(p,1) = "/", ser, fol) & p
	End Function

	Private Sub SetHeaderTo(ByRef o)
		Dim maps,key
		Set maps = o_rh.Maps
		For Each key In maps
			If Not isNumeric(key) Then
				o.setRequestHeader Replace(key,"_","-"), o_rh(key)
			End If
		Next
		Set maps = Nothing
	End Sub

	Private Function Serialize__(ByVal a)
		Dim tmp, i, n, v : tmp = ""
		If AB.C.IsNul(a) Then Exit Function
		If isArray(a) Then
			For i = 0 To Ubound(a)
				n = AB.C.Cleft(a(i),":")
				v = AB.C.CRight(a(i),":")
				tmp = tmp & "&" & n & "=" & Server.URLEncode(v)
			Next
			If Len(tmp)>1 Then tmp = Mid(tmp,2)
			Serialize__ = tmp
		Else
			Serialize__ = a
		End If
	End Function

	Private Function Bytes2Bstr__(ByVal s, ByVal s_charset)
		Dim temp, oStrm : Set oStrm = Server.CreateObject(AB.steamName)
		With oStrm
			.Type = 1
			.Mode = 3
			.Open
			.Write s
			.Position = 0
			.Type = 2
			.Charset = s_charset
			temp = .ReadText
			.Close
		End With
		Bytes2Bstr__ = temp
		Set oStrm = nothing
	End Function

End Class
%>