<%
'######################################################################
'## ab.jslib.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox JSLib(Load JS Libarary) Extensive Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2012/09/08 18:45
'## Description :   AspBox JSLib(JSĿ)JSűòģ
'######################################################################

Class Cls_AB_jsLib

	Private s_path
	Private o_sc, o_jso, o_lib

	Private Sub Class_Initialize()
		On Error Resume Next
		s_path	= AB.BasePath & "jsLib/"
		AB.Use "Sc"
		Set o_sc = AB.Sc.New
		o_sc.Lang = "js"
		Set o_lib = Server.CreateObject(AB.dictName)
		On Error GoTo 0
	End Sub

	Private Sub Class_Terminate()
		Set o_jso = Nothing
		Set o_sc = Nothing
		Set o_lib = Nothing
	End Sub

	Public Function [New]()
		Set [New] = New Cls_AB_jsLib
	End Function

	Public Property Let BasePath(ByVal p)
		s_path = Abx_FixAbsPath(p)
	End Property

	Public Property Get BasePath()
		BasePath = s_path
	End Property

	'-------------------------------------------------------------------------------------------
	'# AB.jsLib.Object()
	'# @alias: AB.jsLib.Mc()
	'# @return: ȡеļصܶ
	'# @dowhat: ܶ(ͬ󣬿ɲеļз)
	'--DESC-------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.Use "jsLib"
	'# Dim jsLib : Set jsLib = AB.jsLib.New
	'# jsLib.Inc("a.js") 'ĬϵļĿ¼AspBox/jsLib/, Ϊ: function myfunc() { return 'a'; }
	'# Dim jso : Set jso = jsLib.Object
	'# Dim temp : temp = jso.myfunc()
	'# ab.c.print temp 'ֵa
	'-------------------------------------------------------------------------------------------

	Public Function [Object]()
		On Error Resume Next:Set [Object] = o_sc.object:On Error GoTo 0
	End Function
	Public Function MC()
		On Error Resume Next:Set MC = o_sc.object:On Error GoTo 0
	End Function

	'-------------------------------------------------------------------------------------------
	'# AB.jsLib.Get(js)
	'# @alias: AB.jsLib.Load(js)
	'# @alias: дΪAB.jsLib(js)
	'# @return: object
	'# @dowhat: jsLib(JSĿ)
	'--DESC-------------------------------------------------------------------------------------
	'# @param js [string] : jsļ, ļչ(׺.js)ɲд.
	'--DEMO-------------------------------------------------------------------------------------
	'# ab.use "sc"
	'# Dim sc : Set sc = ab.sc.new
	'# sc.Lang = "js"
	'# sc.Add "function foo(){ var person = {name: {a:""zhangsan""}, pass: ""123"", fn: function(){alert(this.pass);} }; return person; }"
	'# Dim x : set x = sc.eval("foo()")
	'# ab.use "jsLib"
	'# Dim jso
	'# Set jso = ab.jsLib("json2.js") 'jsļĬĿ¼AspBox/jsLib/ 
	'# Dim temp : temp = jso.JSON.stringify(x) 'JSON.stringify()JSתΪ JSON
	'# ab.c.print temp
	'# Dim jsontext : jsontext = "{""name"":""testid"",""pass"":""123""}"
	'# ab.trace(jso.JSON.parse(jsontext))
	'-------------------------------------------------------------------------------------------

	Public Default Function [Get](ByVal f)
		On Error Resume Next
		Include(f)
		Set o_jso = o_sc.object
		Set [Get] = o_jso
		On Error GoTo 0
	End Function
	Public Function [Load](ByVal f): Set [Load] = [Get](f): End Function

	'-------------------------------------------------------------------------------------------
	'# AB.jsLib.Include(js)
	'# @alias: AB.jsLib.Inc(js)
	'# @alias: AB.jsLib.Import(js)
	'# @return: void
	'# @dowhat: jsLib(JSĿ)
	'--DESC-------------------------------------------------------------------------------------
	'# @param js [string] : jsļ, ļչ(׺.js)ɲд.
	'# 						ĬϵļĿ¼ڣAspBox/jsLib/ ¡
	'# 						ͨ AB.jsLib.BasePath = "/yourJsFileDir/" ޸ΪָĿ¼
	'# 						: AB.jsLib.BasePath = AB.BasePath & "jsDir/" 'Ŀ¼ڣAspBox/jsDir/ ¡
	'--DEMO-------------------------------------------------------------------------------------
	'# '__ļ룺
	'# AB.Use "jsLib"
	'# Dim jsLib : Set jsLib = AB.jsLib.New
	'# jsLib.Inc("a.js") 'ļ1Ϊ: function a() { return 'a'; }
	'# jsLib.Inc("b.js") 'ļ2Ϊ: function b() { return 'b'; }
	'# jsLib.Inc("c.js") 'ļ3Ϊ: function c() { return a() + ':' + b(); }
	'# Dim jso : Set jso = jsLib.Object
	'# Dim temp : temp = jso.c()
	'# ab.c.print temp 'ֵֵa:b
	'-------------------------------------------------------------------------------------------

	Public Function Include(ByVal f)
		On Error Resume Next
		Dim path : path = s_path & FixName(f)
		If Not HasLoad(f) Then
			If AB.C.isFile(path) Then
				o_sc.Include(path)
				o_lib.add LCase(FixName(f)), path
			End If
		End If
		On Error GoTo 0
	End Function
	Public Function Inc(Byval f): Include(f): End Function
	Public Function Import(Byval f): Include(f): End Function

	'-------------------------------------------------------------------------------------------
	'# AB.jsLib.HasLoad(js)
	'# @alias: AB.jsLib.Has(js)
	'# @return: Boolean (True / False)
	'# @dowhat: ǷĳJS
	'--DESC-------------------------------------------------------------------------------------
	'# @param js [string] : jsļ, ļչ(׺.js)ɲд.
	'--DEMO-------------------------------------------------------------------------------------
	'# AB.Use "jsLib"
	'# Dim jsLib : Set jsLib = AB.jsLib.New
	'# If Not AB.jsLib.Has("a.js") Then
	'# 	jsLib.Inc("a.js")
	'# End If
	'-------------------------------------------------------------------------------------------

	Public Function HasLoad(ByVal f)
		On Error Resume Next
		HasLoad = False
		f = LCase(FixName(f))
		If o_lib.Exists(f) Then
			HasLoad = True
		End IF
		On Error GoTo 0
	End Function
	Public Function Has(Byval f): Has = HasLoad(f): End Function

	Public Function FixName(ByVal f)
		If IsNull(f) Or Trim(f)="" Then f=""
		If InStr(f,".")<=0 Then
			f = f & ".js"
		Else
			If LCase(Mid(f,InstrRev(f,"."))) <> ".js" Then
				f = f & ".js"
			End If
		End If
		FixName = f
	End Function

	' ============== ¸ ===================

		Private Function Abx_FixAbsPath(ByVal p)
			p = AB.C.IIF(Left(p,1)= "/", p, "/" & p)
			p = AB.C.IIF(Right(p,1)="/", p, p & "/")
			Abx_FixAbsPath = p
		End Function

End Class
%>