<%
'######################################################################
'## ab.list.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox List(Array) Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2012/06/08 1:01
'## Description :   A super Array class in AspBox
'##                 Support Array and Hash (like Dictionary Object)
'######################################################################

Class Cls_AB_List
	Public Size, OverError
	Private o_hash, o_map
	Private a_list
	Private i_count, i_comp

	Private Sub Class_Initialize
		Set o_hash = Server.CreateObject(AB.dictName)
		Set o_map  = Server.CreateObject(AB.dictName)
		a_list = Array()
		Size = 0
		OverError = True
		AB.Error(41) = "±Խ"
		AB.Error(42) = "±겻Ϊ"
		AB.Error(43) = "±ֻ֡ĸ»(_)(.)б(/)"
		AB.Error(44) = "List"
		i_comp = 1
	End Sub

	Private Sub Class_Terminate
		Set o_map  = Nothing
		Set o_hash = Nothing
	End Sub

	Public Function [New]()
		Set [New] = New Cls_AB_List
		[New].IgnoreCase = Me.IgnoreCase
	End Function

	Public Function NewArray(ByVal a)
		Set NewArray = New Cls_AB_List
		NewArray.IgnoreCase = Me.IgnoreCase
		NewArray.Data = a
	End Function

	Public Function NewHash(ByVal a)
		Set NewHash = New Cls_AB_List
		NewHash.IgnoreCase = Me.IgnoreCase
		NewHash.Hash = a
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.IgnoreCase[ = boolean] úͲѯʱǷֵĴСдԿɶд
	'@   :  ԴСд򷵻棨True򷵻ؼ٣False
	'@   :  һȥظȡֵ򡢱Ƚϵʱã粻ôԣĬΪԣTrue
	'==DESC=====================================================================================
	'@  boolean(ѡ) : Boolean (ֵ) ǷֵĴСд
	'==DEMO=====================================================================================
	'@ 
	'@ *****************************************************************************************

	Public Property Let IgnoreCase(ByVal b)
		i_comp = AB.C.IIF(b, 1, 0)
	End Property

	Public Property Get IgnoreCase
		IgnoreCase = (i_comp = 1)
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.At(index)[ = value]  AB.List(index)[ = value]
	'@   :  ָ±ֵ
	'@			[Array ()  Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ)]
	'@   :  ±ûȡĳһֵ AB.List.At(index)ԼдΪAB.List(index)
	'==DESC=====================================================================================
	'@  index : Integer ()  String (ַ) 
	'@ 				±ֻ꣬Ȼĸ»(_)(.)б(/)ɡ
	'@ 				ͨʱ±ȻHashʱ±˿Ȼ֮⣬Ƿǿַ 
	'@  value(ѡ) : Array ()  Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ) 
	'@ 				õֵ 
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = Array("", "Ҽ", "", "")
	'@ list.At(2) = "" '±Ϊ2ֵΪ
	'@ list(5) = "" '±Ϊ5ֵΪ顱
	'@ 'ʱѾɣArray("", "Ҽ", "", "", "", "")
	'@ AB.C.PrintCn list(3) '±Ϊ3ֵ,ҳ潫ʾ
	'@ Dim list2 : Set list2 = AB.List.New 
	'@ list2.Hash = "zero: one:Ҽ two: three:"
	'@ list2("ten") = "ʰ"
	'@ AB.C.PrintCn list2("ten") 'ҳ潫ʾʰ
	'@ AB.C.PrintCn list2(4) 'Կʹ±,ҳ潫ʾʰ
	'@ *****************************************************************************************

	Public Property Let At(ByVal n, ByVal v)
		If AB.C.IsNul(n) Then AB.Error.Raise 42 : Exit Property
		If AB.C.Test(n,"^\d+$") Then
			If n > [End] Then
				ReDim Preserve a_list(n)
				Size = n + 1
			End If
			a_list(n) = v
		ElseIf AB.C.Test(n,"^[\w\./]+$") Then
			If Not o_map.Exists(n) Then
				o_map(n) = Size
				o_map(Size) = n
				Push v
			Else
				a_list(o_map(n)) = v
			End If
		Else
			AB.Error.Raise 43
		End If
	End Property

	Public Default Property Get At(ByVal n)
		If AB.C.Test(n,"^\d+$") Then
			If n < Size Then
				At = a_list(n)
			Else
				At = Null
				If OverError Then
					AB.Error.Msg = "(ǰ± " & n & " ± " & [End] & " )"
					AB.Error.Raise 41
				End If
			End If
		ElseIf AB.C.Test(n,"^[\w-\./]+$") Then
			If o_map.Exists(n) Then
				At = a_list(o_map(n))
			Else
				At = Null
				If OverError Then
					AB.Error.Msg = "(ǰ " & n & " Hash)"
					AB.Error.Raise 41
				End If
			End If
		End If
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Data[ = content] ԴΪ鲢ֵԿɶд
	'@   :  Array () ȡΪͨ
	'@   :  һListͨ˷ֵöͨ顣
	'==DESC=====================================================================================
	'@  content(ѡ) : Array ()  String (ַ) 
	'@ 		飬ҲԿոַָ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ 'list.Data = Array("", "Ҽ", "", "")
	'@ list.Data = " Ҽ  " 'ͨԿոֵַָ
	'@ Dim i, arr : arr = list.Data 'ȡΪͨ
	'@ For i = 0 To Ubound(arr)
	'@  AB.C.PrintCn "arr("&i&") ֵǣ" & arr(i)
	'@ Next
	'@ *****************************************************************************************

	Public Property Let Data(ByVal a)
		Data__ a, 0
	End Property

	Public Property Get Data
		Data = a_list
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Hash[ = content] úͲѯʱǷֵĴСдԿɶд
	'@   :  Array () ȡΪͨ飬ÿԪصֵԴHashֵ
	'@   :  һListͨ˷ֵöHash顣
	'==DESC=====================================================================================
	'@  content(ѡ) : Array ()  String (ַ) 
	'@ 		飬ҲԿոַָ
	'@ 		ÿԪػַÿԱð(:)ָ
	'@ 		ðߵĲ־Hashַ±꣩
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ 'list.Hash = Array("zero:", "one:Ҽ", "two:", "three:") 'ͨ鸳ֵ
	'@ list.Hash = "zero: one:Ҽ two: three:" 'ͨԿոֵַָ
	'@ Dim i, arr : arr = list.Hash 'ȡΪͨ
	'@ For i = 0 To Ubound(arr)
	'@  AB.C.PrintCn "arr("&i&") ֵǣ" & arr(i)
	'@ Next
	'@ --нΪ:	
	'@ arr(0) ֵǣzero:
	'@ arr(1) ֵǣone:Ҽ
	'@ arr(2) ֵǣtwo:
	'@ arr(3) ֵǣthree:
	'@ *****************************************************************************************

	Public Property Let Hash(ByVal a)
		Data__ a, 1
	End Property

	Public Property Get Hash
		Dim arr, i
		arr = a_list
		For i = 0 To [End]
			If o_map.Exists(i) Then
				arr(i) = o_map(i) & ":" & arr(i)
			End If
		Next
		Hash = arr
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Maps [ = hash ] HashӳΪ Dictionary 󣬴Կɶд
	'@   :   Dictionary 
	'@   :  תΪ Dictionary 󣬿ɶʹ Dictionary еԺͷ
	'==DESC=====================================================================================
	'@  hash(ѡ) : Array ()
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Maps = AB.Dict
	'@ AB.Trace list.Maps
	'@ *****************************************************************************************

	Public Property Let Maps(ByVal d)
		If TypeName(d) = "Dictionary" Then CloneDic__ o_map, d
	End Property

	Public Property Get Maps
		Set Maps = o_map
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.List.Size (ֻ)
	'# @syntax: AB.List.Size
	'# @alias:  AB.List.Length
	'# @return: Integer () صǰĳȣԪظ
	'# @dowhat: صǰĳȣԪظֻ
	'#  ʹøԿԷصǰListԪظĳȡ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# 'List
	'# AB.Use "List"
	'# Dim list : Set list = AB.List.New
	'# 'List
	'# 'list.Data = Array("aa", "bb", "cc")
	'# list.Data = "aa bb cc"
	'# AB.C.PrintCn "Ϊ" & list.ToString 'ؽaa,bb,cc
	'# AB.C.PrintCn "ĳȣԪظǣ" & list.Size 'ؽĳȣԪظǣ3
	'------------------------------------------------------------------------------------------

	Public Property Get Length
		Length = Size
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Count Чȣǿֵֻ
	'@   :  ޲
	'@   :  зǿֵЧԪظ
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List"
	'@ Dim list : Set list = AB.List.New
	'@ AB.List.Data = "aa bb cc" 'List
	'@ AB.List(8) = "dd" '򳬹ǰ±Ԫظֵ൱Ԫ
	'@ AB.C.PrintCn "Ϊ" & AB.List.ToString
	'@ AB.C.PrintCn "ĳȣԪظǣ" & AB.List.Size
	'@ AB.C.PrintCn "Чȣǿֵǣ" & AB.List.Count
	'@ --нΪ
	'@ Ϊaa,bb,cc,,,,,,dd
	'@ ĳȣԪظǣ9
	'@ Чȣǿֵǣ4
	'@ *****************************************************************************************

	Public Property Get Count
		Dim i,j : j = 0
		For i = 0 To Size-1
			If AB.C.Has(At(i)) Then j = j + 1
		Next
		Count = j
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.End ±ֻ꣬
	'@   :  ޲
	'@   :  ±
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List"
	'@ Dim list : Set list = AB.List.New
	'@ list.Data = " Ҽ  "
	'@ AB.C.Print list.End 'ҳ潫ʾ3
	'@ *****************************************************************************************

	Public Property Get [End]
		[End] = Size - 1
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.First һԪصֵֻ
	'@   :  [ Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ) ]
	'@   :  һԪصֵ
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three:"
	'@ AB.C.Print list.First 'ҳ潫ʾ㣨עⲻǣzero:㣩
	'@ *****************************************************************************************

	Public Property Get First
		First = At(0)
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Last һԪصֵֻ
	'@   :  [ Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ) ]
	'@   :  һԪصֵ
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three:"
	'@ AB.C.Print list.Last 'ҳ潫ʾעⲻǣthree:
	'@ *****************************************************************************************

	Public Property Get Last
		Last = At([End])
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Max Ԫصֵֻ
	'@   :  Ԫصֵ [ Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ) ]
	'@   :  ԪصֵַͨStrCompġıȽϡȡСֵ
	'@			Ԫصͱ붼ϷֵͲ׼ȷȡֵᱨ
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = Array(0, -1, 3.6)
	'@ AB.C.PrintCn list.Max 'ҳ潫ʾ3.6
	'@ Dim list2 : Set list2 = AB.List.New
	'@ list2.Data = Array("", "С")
	'@ AB.C.PrintCn list2.Max 'ҳ潫ʾС
	'@ *****************************************************************************************

	Public Property Get Max
		Dim i, v
		v = At(0)
		If Size > 1 Then
			For i = 1 To [End]
				If Compare__("gt", At(i), v) Then v = At(i)
			Next
		End If
		Max = v
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.Min СԪصֵֻ
	'@   :  СԪصֵ [ Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ) ]
	'@   :  ԪصֵַͨStrCompġıȽϡȡСֵ
	'@			Ԫصͱ붼ϷֵͲ׼ȷȡСֵᱨ
	'==DESC=====================================================================================
	'@  
	'==DEMO=====================================================================================
	'@ AB.Use "List" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = Array(0, -1, 3.6)
	'@ AB.C.PrintCn list.Min 'ҳ潫ʾ-1
	'@ Dim list2 : Set list2 = AB.List.New
	'@ list2.Data = Array("", "С")
	'@ AB.C.PrintCn list2.Min 'ҳ潫ʾ
	'@ *****************************************************************************************

	Public Property Get Min
		Dim i, v
		v = At(0)
		If Size > 1 Then
			For i = 1 To [End]
				If Compare__("lt", At(i), v) Then v = At(i)
			Next
		End If
		Min = v
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.List.Serialize (ֻ)
	'# @syntax: AB.List.Serialize
	'# @return: String (ַ) 鱻лַ
	'# @dowhat: лHash飬ֻ
	'#  ʹGETPOSTʽȡԶʱͨͬʱύݡ
	'#  GETURLķʽЩݣPOSTƱһύЩݡ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "List" 'List
	'# Dim list : Set list = AB.List.New 'һList
	'# list.Hash = "id:1 name:wo_is"
	'# AB.C.Print list.Serialize
	'# 'ҳ潫ʾid=1&name=wo%5Fis%E7%A5%9E%E4%BB%99
	'------------------------------------------------------------------------------------------

	Public Property Get Serialize
		Dim tmp, i : tmp = ""
		For i = 0 To [End]
			If o_map.Exists(i) Then
				tmp = tmp & "&" & o_map(i) & "=" & Server.URLEncode(At(i))
			End If
		Next
		If Len(tmp)>1 Then tmp = Mid(tmp,2)
		Serialize = tmp
	End Property

	'@ *****************************************************************************************
	'@ :  AB.List.HasIndex index Ƿĳ±
	'@   :  ָ±Ԫط棨True򷵻ؼ٣False
	'@   :  Ƿĳ±
	'==DESC=====================================================================================
	'@  index : ʹ±⣬Ҳʹַ±⡣
	'==DEMO=====================================================================================
	'@ AB.Use "list"
	'@ Dim list : Set list = AB.List.New
	'@ list.Hash = "zero: one:Ҽ two: three:"
	'@ AB.C.Print "" & AB.C.IIF(list.HasIndex("one"), "", "") & "±Ϊ""one""Ԫ"
	'@ *****************************************************************************************

	Public Function HasIndex(ByVal i)
		HasIndex = Index(i) >= 0
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Index index Hashȡ±
	'@   :  HashָԪ򷵻±꣬򷵻-1
	'@   :  Hashȡ±꣬˷һHash顣
	'==DESC=====================================================================================
	'@  index : ǿַ
	'==DEMO=====================================================================================
	'@ AB.Use "list"
	'@ Dim list : Set list = AB.List.New
	'@ list.Hash = "zero: one:Ҽ two: three:"
	'@ AB.C.Print "HashΪ""one""Ԫص±ǣ" & list.Index("one")
	'@ *****************************************************************************************

	Public Function Index(ByVal i)
		If isNumeric(i) Then
			Index = AB.C.IIF(i >= 0 And i <= [End], i, -1)
		Else
			If o_map.Exists(i) Then
				Index = o_map(i)
			Else
				Index = -1
			End If
		End If
	End Function

	Public Function IndexHash(ByVal i)
		If isNumeric(i) Then
			IndexHash = AB.C.IfThen(o_map.Exists(i), o_map(i))
		Else
			IndexHash = AB.C.IfThen(o_map.Exists(i), i)
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.UnShift 
	'# @syntax: AB.List.UnShift content
	'# @return: ޷ֵ
	'# @dowhat: һԪصListĿͷ
	'# contentΪַʱһԪأcontentΪʱӶԪء
	'--DESC------------------------------------------------------------------------------------
	'# @param content : Array ()  String (ַ) 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "list" 'List
	'# Dim list : Set list = AB.List.New 'һList
	'# list.Hash = "zero: one:Ҽ two: three:"
	'# 'ʹͬʱԪ
	'# list.UnShift Array("a:aaa", "b:bbb")
	'# 'ȡΪͨ
	'# Dim i,arr : arr = list.Hash
	'# 'ѭ
	'# For i = 0 To Ubound(arr)
	'# 	AB.C.PrintCn("arr("& i &") => " & arr(i))
	'# Next
	'# ------ʾнΪ
	'# arr(0) => a:aaa
	'# arr(1) => b:bbb
	'# arr(2) => zero:
	'# arr(3) => one:Ҽ
	'# arr(4) => two:
	'# arr(5) => three:
	'------------------------------------------------------------------------------------------

	Public Sub UnShift(ByVal v)
		Insert 0, v
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.UnShift_ 
	'# @syntax: AB.List.UnShift_ content
	'# @return: Object (ASP) һµAspBoxListԭListӰ졣
	'# @dowhat: һԪصĿͷµList
	'#  contentΪַʱһԪأcontentΪʱӶԪء
	'#  ԭݼӵݣµ󣬲ıԭݡ
	'--DESC------------------------------------------------------------------------------------
	'# @param content : Array ()  String (ַ) 
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "list" 'List
	'# Dim list : Set list = AB.List.New 'һList
	'# list.Hash = "zero: one:Ҽ two: three:"
	'# 'ȡΪͨ
	'# Dim arr, arr2, i
	'# arr = list.Hash 'ԭ
	'# arr2 = list.UnShift_(Array("a:aaa", "b:bbb")).Hash '
	'# 'ѭ
	'# For i = 0 To Ubound(arr)
	'# 	AB.C.PrintCn("arr("& i &") => " & arr(i))
	'# Next
	'# AB.C.PrintCn "============"
	'# For i = 0 To Ubound(arr2)
	'# 	AB.C.PrintCn("arr2("& i &") => " & arr2(i))
	'# Next
	'# ------ʾнΪ
	'# arr(0) => zero: 
	'# arr(1) => one:Ҽ 
	'# arr(2) => two: 
	'# arr(3) => three: 
	'# ============ 
	'# arr2(0) => a:aaa 
	'# arr2(1) => b:bbb 
	'# arr2(2) => zero: 
	'# arr2(3) => one:Ҽ 
	'# arr2(4) => two: 
	'# arr2(5) => three:
	'------------------------------------------------------------------------------------------

	Public Function UnShift_(ByVal v)
		Set UnShift_ = Me.Clone
		UnShift_.UnShift v
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Shift 
	'# @syntax: AB.List.Shift
	'# @return: ޷ֵ
	'# @dowhat: ɾĵһԪ
	'# ʹø÷ɾĵһԪء
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "list" 'List
	'# Dim list : Set list = AB.List.New 'һList
	'# list.Data = "zero: one:Ҽ two: three:"
	'# 'ɾһԪ
	'# list.Shift
	'# '
	'# AB.C.Print list.ToString 'one:Ҽ,two:,three:
	'------------------------------------------------------------------------------------------

	Public Sub Shift
		[Delete] 0
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Shift_ 
	'# @syntax: AB.List.Shift_
	'# @return: Object (ASP) һµAspBoxListԭListӰ졣
	'# @dowhat: ɾĵһԪأµList
	'# ʹø÷ɾĵһԪأʣµԪµ󣬲ıԭݡ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "list" 'List
	'# Dim list : Set list = AB.List.New 'һList
	'# list.Data = "zero: one:Ҽ two: three:"
	'# '
	'# AB.C.PrintCn "飺" & list.Shift_.ToString '飺one:Ҽ,two:,three:
	'# AB.C.PrintCn "ԭ飺" & list.ToString 'ԭ飺zero:,one:Ҽ,two:,three:
	'------------------------------------------------------------------------------------------

	Public Function Shift_
		Set Shift_ = Me.Clone
		Shift_.Shift
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Push Str һԪصListĩβ
	'@   :  ޷ֵ
	'@   :  ʹø÷ͨListĩβһµԪء
	'==DESC=====================================================================================
	'@  Str : Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = " Ҽ  " 'Ϊͨ鲢ֵ
	'@ list.Push ""
	'@ AB.C.Put list.ToString 'ҳ潫ʾ,Ҽ,,,
	'@ *****************************************************************************************

	Public Sub Push(ByVal v)
		ReDim Preserve a_list(Size)
		a_list(Size) = v
		Size = Size + 1
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.List.Push_ Str һԪصListĩβµList
	'@   :  һµAspBoxListԭListӰ졣
	'@   :  ʹø÷ͨListĩβһµԪأ
	'@ 			ԪһһµListԭListݲı䡣
	'==DESC=====================================================================================
	'@  Str : Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = " Ҽ  " 'Ϊͨ鲢ֵ
	'@ Dim NewList : Set NewList = list.Push_("")
	'@ AB.C.Put NewList.ToString 'ҳ潫ʾ,Ҽ,,,
	'@ *****************************************************************************************

	Public Function Push_(ByVal v)
		Set Push_ = Me.Clone
		Push_.Push v
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Pop Str һԪصĩβ
	'@   :  ޷ֵ
	'@   :  ʹø÷ͨĩβһµԪء
	'==DESC=====================================================================================
	'@  Str : Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Set list = AB.List.New 'һList
	'@ list.Data = "zero: one:Ҽ two: three:" 'Ϊͨ鲢ֵ
	'@ list.Pop 'ɾһԪ
	'@ AB.C.Print list.ToString 'ҳ潫ʾzero:,one:Ҽ,two:
	'@ *****************************************************************************************

	Public Sub Pop
		RemoveMap__ [End]
		ReDim Preserve a_list([End]-1)
		Size = Size - 1
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.List.Pop_ Str һԪصĩβµList
	'@   :  һµAspBoxListԭListӰ졣
	'@   :  ʹø÷ͨĩβһµԪأ
	'@ 			ԪһһµListԭListݲı䡣
	'==DESC=====================================================================================
	'@  Str : Boolean (ֵ)  Datetime (ʱ)  Numeric (ֵ)  String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = "zero: one:Ҽ two: three:" 'Ϊͨ鲢ֵ
	'@ AB.C.PrintCn "飺" & list.Pop_.ToString 'ʾ飺zero:,one:Ҽ,two:
	'@ AB.C.PrintCn "ԭ飺" & list.ToString 'ʾԭ飺zero:,one:Ҽ,two:,three:
	'@ *****************************************************************************************

	Public Function Pop_
		Set Pop_ = Me.Clone
		Pop_.Pop
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Insert index, content ָ±괦һԪ
	'@   :  ޷ֵ
	'@   :  ָ±괦һԪ, index±ꣻ
	'@			contentΪַʱǲһԪأcontentΪʱǲԪء
	'==DESC=====================================================================================
	'@  index : Integer () ׼Ԫصλõ±꣬Դ鵱ǰ±ꡣ
	'@  content : Array ()  String (ַ) ׼Ԫصݡ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = " Ҽ  " 'Ϊͨ鲢ֵ
	'@ list.Insert 2, "AspBox"
	'@ AB.C.PrintCn "һβԪغ" & list.ToString & "鳤Ϊ" & list.Size
	'@ list.Insert 7, Array("", "", "")
	'@ AB.C.PrintCn "ڶβԪغ" & list.ToString & "鳤Ϊ" & list.Size
	'@ --нΪ
	'@ һβԪغ,Ҽ,AspBox,,鳤Ϊ5
	'@ ڶβԪغ,Ҽ,AspBox,,,,,,,鳤Ϊ10
	'@ *****************************************************************************************

	Public Sub Insert(ByVal n, ByVal v)
		Dim i,j
		If n > [End] Then
			If isArray(v) Then
				For i = 0 To UBound(v)
					At(n+i) = v(i)
				Next
			Else
				At(n) = v
			End If
		Else
			For i = Size To (n+1) Step -1
				If isArray(v) Then
					UpFrom__ i+UBound(v), i-1
				Else
					UpFrom__ i, i-1
				End If
			Next
			If isArray(v) Then
				For i = 0 To UBound(v)
					At(n+i) = v(i)
				Next
			Else
				At(n) = v
			End If
		End If
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.List.Insert_ index, content ָ±괦һԪأµList
	'@   :  ޷ֵ
	'@   :  һµAspBoxListԭListӰ졣index±ꣻ
	'@			contentΪַʱǲһԪأcontentΪʱǲԪء
	'@			ʹø÷صǲԪغ󣬲ıԭݡ
	'==DESC=====================================================================================
	'@  index : Integer () ׼Ԫصλõ±꣬Դ鵱ǰ±ꡣ
	'@  content : Array ()  String (ַ) ׼Ԫصݡ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Data = " Ҽ  " 'Ϊͨ鲢ֵ
	'@ AB.C.PrintCn "飺" & list.Insert_(7, Array("", "", "")).ToString
	'@ AB.C.PrintCn "飺" & list.ToString
	'@ --нΪ
	'@ 飺,Ҽ,,,,,,,,
	'@ 飺,Ҽ,,
	'@ *****************************************************************************************

	Public Function Insert_(ByVal n, ByVal v)
		Set Insert_ = Me.Clone
		Insert_.Insert n, v
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Has element ǷĳԪ
	'@   :  򷵻棨Trueؼ٣False
	'@   :  ʹø÷ԼǷĳԪأHashĻĿֵܼ
	'==DESC=====================================================================================
	'@  element : Anything (ֵ) Ķ
	'==DEMO=====================================================================================
	'@ AB.Use "list"
	'@ Dim list : Set list = AB.List.New
	'@ list.Hash = "zero: one:Ҽ two: three:"
	'@ AB.C.PrintCn "Ƿַ ""Ҽ"" " & list.Has("Ҽ")
	'@ AB.C.PrintCn "Ƿַ ""two"" " & list.Has("two")
	'@ --нΪ
	'@ Ƿַ "Ҽ" True
	'@ Ƿַ "two" False
	'@ *****************************************************************************************

	Public Function Has(ByVal v)
		Has = (indexOf__(a_list, v) > -1)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.IndexOf element Ԫе±
	'@   :  Integer () дelementͷ±꣬򷵻-1
	'@   :  ʹø÷ԼԪelementе±꣬жͬԪأصǵһγֵ±ꡣ
	'==DESC=====================================================================================
	'@  element : Anything (ֵ) Ķ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three:" 'ΪHash鲢ֵ
	'@ AB.C.PrintCn "ַ""""еһγֵ±ǣ" & list.IndexOf("")
	'@ AB.C.PrintCn " " & AB.C.IIF(list.IndexOf("") > -1, "", "") & " ֵΪ""""Ԫ"
	'@ --нΪ
	'@ ַ""еһγֵ±ǣ2
	'@   ֵΪ""Ԫ
	'@ *****************************************************************************************

	Public Function IndexOf(ByVal v)
		IndexOf = indexOf__(a_list, v)
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.IndexOfHash element ԪHashеַ±
	'@   :  ޷ֵ
	'@   :  Hashдelementͷַ±꣬򷵻ؿա
	'@			ʹø÷ԼԪelementHashеַ±꣬
	'@			жͬԪأصǵһγֵ±ꡣ
	'==DESC=====================================================================================
	'@  element : Anything (ֵ) Ķ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three:" 'ΪHash鲢ֵ
	'@ AB.C.PrintCn "ַ""""еһγֵ±ǣ" & list.IndexOfHash("")
	'@ AB.C.PrintCn " " & AB.C.IIF(AB.C.Has(list.IndexOfHash("")), "", "") & " ֵΪ""""Ԫ"
	'@ --нΪ
	'@ ַ""еһγֵ±ǣtwo
	'@   ֵΪ""Ԫ
	'@ *****************************************************************************************

	Public Function IndexOfHash(ByVal v)
		Dim i : i = indexOf__(a_list, v)
		If i = -1 Then IndexOfHash = Empty : Exit Function
		If o_map.Exists(i) Then
			IndexOfHash = o_map(i)
		Else
			IndexOfHash = Empty
		End If
	End Function

	'@ *****************************************************************************************
	'@ :  AB.List.Delete index ɾָ±Ԫ
	'@   :  ޷ֵ
	'@   :  ʹô˷ɾָ±ԪأֻɾһҲͬʱɾ
	'@			indexȻҲַ䡣
	'==DESC=====================================================================================
	'@  index : Integer () ɾԪص±ֻ֣꣬Hash
	'@ 				ͬʱɾԪʱָ±䣬 - ʾ䣬\s ʾͷ\e ʾβ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three: four: five: six:½ seven: eight: nine:" 'ΪHash鲢ֵ 
	'@ list.Delete 1 'ͨ±ɾһԪ
	'@ AB.C.PrintCn "ɾ±Ϊ1Ԫغ" & list.ToString
	'@ list.Delete "two,six" 'ַͨ±ɾԪ
	'@ AB.C.PrintCn "ɾַ±Ϊ""two""""six""Ԫغ" & list.ToString
	'@ AB.C.PrintCn "ʱĳΪ" & list.Size & "±ǣ" & list.End
	'@ 'ͨɾ±Ϊ02Լ±Ϊ5ĸԪأ - ʾ, \s ʾͷ, \e ʾβ
	'@ list.Delete "\s-2,5"
	'@ AB.C.PrintCn "ɾ±Ϊ""ͷ-2""""5""Ԫغ" & list.ToString
	'@ --нΪ
	'@ ɾ±Ϊ1Ԫغ,,,,,½,,,
	'@ ɾַ±Ϊ"two""six"Ԫغ,,,,,,
	'@ ʱĳΪ7±ǣ6
	'@ ɾ±Ϊ"ͷ-2""5"Ԫغ,,
	'@ *****************************************************************************************

	Public Sub [Delete](ByVal n)
		Dim tmp,a,x,y,i
		If Instr(n, ",")>0 Or Instr(n,"-")>0 Then
			n = Replace(n,"\s","0")
			n = Replace(n,"\e",[End])
			a = Split(n, ",")
			For i = 0 To Ubound(a)
				If i>0 Then tmp = tmp & ","
				If Instr(a(i),"-")>0 Then
					x = Trim(AB.C.CLeft(a(i),"-"))
					y = Trim(AB.C.CRight(a(i),"-"))
					If Not Isnumeric(x) And o_map.Exists(x) Then x = o_map(x)
					If Not Isnumeric(y) And o_map.Exists(y) Then y = o_map(y)
					tmp = tmp & x & "-" & y
				Else
					x = Trim(a(i))
					If Not Isnumeric(x) And o_map.Exists(x) Then x = o_map(x)
					tmp = tmp & x
				End If
			Next
			a = Split(tmp,",")
			a = SortArray(a,0,UBound(a))
			tmp = "0-"
			For i = 0 To Ubound(a)
				If Instr(a(i),"-")>0 Then
					x = AB.C.CLeft(a(i),"-")
					y = AB.C.CRight(a(i),"-")
					tmp = tmp & x-1 & ","
					tmp = tmp & y+1 & "-"
				Else
					tmp = tmp & a(i)-1 & "," & a(i)+1 & "-"
				End If
			Next
			tmp = tmp & [End]
			Slice tmp
		Else
			If Not isNumeric(n) And o_map.Exists(n) Then
				n = o_map(n)
				RemoveMap__ n
			End If
			For i = n+1 To [End]
				UpFrom__ i-1, i
			Next
			Pop
		End If
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.List.Delete_ index ɾָ±ԪأµList
	'@   :  һµAspBoxListԭListӰ
	'@   :  ʹô˷ɾָ±ԪأֻɾһҲͬʱɾ
	'@			indexȻҲַ䡣
	'@			ʹø÷صɾԪغ󣬲ıԭݡ
	'==DESC=====================================================================================
	'@  index : Integer () ɾԪص±ֻ֣꣬Hash
	'@ 				ͬʱɾԪʱָ±䣬 - ʾ䣬\s ʾͷ\e ʾβ
	'==DEMO=====================================================================================
	'@ AB.Use "list" 'List
	'@ Dim list : Set list = AB.List.New 'һList
	'@ list.Hash = "zero: one:Ҽ two: three: four: five: six:½ seven: eight: nine:" 'ΪHash鲢ֵ 
	'@ AB.C.PrintCn "ɾ±Ϊ1Ԫغ" & list.Delete_(1).ToString 'ͨ±ɾһԪ
	'@ AB.C.PrintCn "ɾַ±Ϊ""two""""six""Ԫغ" & list.Delete_("two,six").ToString 'ַͨ±ɾԪ
	'@ AB.C.PrintCn "ʱԭĳΪ" & list.Size & "±ǣ" & list.End
	'@ 'ͨɾ±Ϊ02Լ±Ϊ5ĸԪأ - ʾ, \s ʾͷ, \e ʾβ
	'@ AB.C.PrintCn "ɾ±Ϊ""ͷ-2""""5""Ԫغ" & list.Delete_("\s-2,5").ToString
	'@ --нΪ
	'@ ɾ±Ϊ1Ԫغ,,,,,½,,,
	'@ ɾַ±Ϊ"two""six"Ԫغ,Ҽ,,,,,,
	'@ ʱԭĳΪ10±ǣ9
	'@ ɾ±Ϊ"ͷ-2""5"Ԫغ,,½,,,
	'@ *****************************************************************************************

	Public Function Delete_(ByVal n)
		Set Delete_ = Me.Clone
		Delete_.Delete n
	End Function

	Public Sub Uniq()
		Dim arr(),i,j : j = 0
		ReDim arr(-1)
		If o_hash.Count>0 Then o_hash.RemoveAll
		For i = 0 To [End]
			If indexOf__(arr, At(i)) = -1 Then
				ReDim Preserve arr(j)
				arr(j) = At(i)
				If o_map.Exists(i) Then
					o_hash.Add j, o_map(i)
					o_hash.Add o_map(i), j
				End If
				j = j + 1
			End If
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Uniq_()
		Set Uniq_ = Me.Clone
		Uniq_.Uniq
	End Function

	Public Sub Rand
		Dim i, j, tmp, Ei, Ej, Ti, Tj
		For i = 0 To [End]
			j = AB.C.Rand(0,[End])
			Ei = o_map.Exists(i)
			Ej = o_map.Exists(j)
			If Ei Then Ti = o_map(i)
			If Ej Then Tj = o_map(j)
			tmp = At(j)
			At(j) = At(i)
			At(i) = tmp
			If Ei Then
				o_map(j) = Ti
				o_map(Ti) = j
			End If
			If Ej Then
				o_map(i) = Tj
				o_map(Tj) = i
			End If
			If Not (Ei And Ej) Then
				If Ei Then o_map.Remove i
				If Ej then o_map.Remove j
			End If
		Next
	End Sub

	Public Function Rand_()
		Set Rand_ = Me.Clone
		Rand_.Rand
	End Function

	Public Sub Reverse
		Dim arr(),i,j : j = 0
		ReDim arr([End])
		If o_hash.Count>0 Then o_hash.RemoveAll
		For i = [End] To 0 Step -1
			arr(j) = At(i)
			If o_map.Exists(i) Then
				o_hash.Add j, o_map(i)
				o_hash.Add o_map(i), j
			End If
			j = j + 1
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Reverse_()
		Set Reverse_ = Me.Clone
		Reverse_.Reverse
	End Function

	Public Sub Search(ByVal s)
		Search__ s, True
	End Sub

	Public Function Search_(ByVal s)
		Set Search_ = Me.Clone
		Search_.Search s
	End Function

	Public Sub SearchNot(ByVal s)
		Search__ s, False
	End Sub

	Public Function SearchNot_(ByVal s)
		Set SearchNot_ = Me.Clone
		SearchNot_.SearchNot s
	End Function

	Public Sub Compact
		Dim arr(), i, j : j = 0
		If o_hash.Count>0 Then o_hash.RemoveAll
		For i = 0 To [End]
			If AB.C.Has(At(i)) Then
				ReDim Preserve arr(j)
				arr(j) = At(i)
				If o_map.Exists(i) Then
					o_hash.Add j, o_map(i)
					o_hash.Add o_map(i), j
				End If
				j = j + 1
			End If
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Compact_()
		Set Compact_ = Me.Clone
		Compact_.Compact
	End Function

	Public Sub Clear
		a_list = Array()
		If o_map.Count>0 Then o_map.RemoveAll
		Size = 0
	End Sub

	Public Sub Sort
		Dim arr
		arr = a_list
		arr = SortArray(arr, 0, [End])
		If o_map.Count = 0 Then
			Data = arr
		Else
			AddHash__ arr
		End If
	End Sub

	Public Function Sort_()
		Set Sort_ = Me.Clone
		Sort_.Sort
	End Function

	Public Sub Slice(ByVal s)
		Dim a,i,j,k,x,y,arr
		If o_hash.Count>0 Then o_hash.RemoveAll
		s = Replace(s,"\s",0)
		s = Replace(s,"\e",[End])
		a = Split(s, ",")
		arr = Array() : k = 0
		For i = 0 To Ubound(a)
			If Instr(a(i),"-")>0 Then
				x = Trim(AB.C.CLeft(a(i),"-"))
				y = Trim(AB.C.CRight(a(i),"-"))
				If Not Isnumeric(x) And o_map.Exists(x) Then x = o_map(x)
				If Not Isnumeric(y) And o_map.Exists(y) Then y = o_map(y)
				x = Int(x) : y = Int(y)
				For j = x To y
					ReDim Preserve arr(k)
					arr(k) = At(j)
					If o_map.Exists(j) Then
						If Not o_hash.Exists(o_map(j)) Then
							o_hash.Add k, o_map(j)
							o_hash.Add o_map(j), k
						End If
					End If
					k = k + 1
				Next
			Else
				ReDim Preserve arr(k)
				x = Trim(a(i))
				If Not Isnumeric(x) And o_map.Exists(x) Then x = o_map(x)
				x = Int(x)
				If o_map.Exists(x) Then
					If Not o_hash.Exists(o_map(x)) Then
						o_hash.Add k, o_map(x)
						o_hash.Add o_map(x), k
					End If
				End If
				arr(k) = At(x)
				k = k + 1
			End If
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Slice_(ByVal s)
		Set Slice_ = Me.Clone
		Slice_.Slice s
	End Function

	Public Function [Get](ByVal s)
		Set [Get] = Slice_(s)
	End Function

	Public Function J(ByVal s)
		J = Join(a_list, s)
	End Function

	Public Function ToString()
		ToString = J(",")
	End Function

	Public Function ToArray
		ToArray = a_list
	End Function

	Public Function Clone
		Set Clone = Me.New
		Clone.Data = a_list
		If o_map.Count>0 Then Clone.Maps = o_map
	End Function

	Public Sub Map(ByVal f)
		Map__ f, 0
	End Sub

	Public Function Map_(ByVal f)
		Set Map_ = Me.Clone
		Map_.Map f
	End Function

	Public Sub [Each](ByVal f)
		Map__ f, 1
	End Sub

	Public Function Find(ByVal f)
		Dim i, k, tmp
		k = "i"
		If AB.C.Test(f,"[a-zA-Z]+:(.+)") Then
			k = AB.C.CLeft(f,":")
			f = AB.C.CRight(f,":")
		End If
		k = "%" & k
		For i = 0 To [End]
			tmp = Replace(Trim(f), k, Value__(At(i)))
			If Eval(tmp) Then
				Find = At(i) : Exit Function
			End If
		Next
		Find = Empty
	End Function

	Public Sub [Select](ByVal f)
		Select__ f, 0
	End Sub

	Public Function Select_(ByVal f)
		Set Select_ = Me.Clone
		Select_.Select f
	End Function

	Public Sub Reject(ByVal f)
		Select__ f, 1
	End Sub

	Public Function Reject_(ByVal f)
		Set Reject_ = Me.Clone
		Reject_.Reject f
	End Function

	Public Sub Grep(ByVal g)
		Dim i,j,arr
		arr = Array() : j = 0
		If o_hash.Count>0 Then o_hash.RemoveAll
		For i = 0 To [End]
			If AB.C.Test(At(i),g) Then
				ReDim Preserve arr(j)
				arr(j) = At(i)
				If o_map.Exists(i) Then
					o_hash.Add j, o_map(i)
					o_hash.Add o_map(i), j
				End If
				j = j + 1
			End If
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Grep_(ByVal g)
		Set Grep_ = Me.Clone
		Grep_.Grep g
	End Function

	Public Sub SortBy(ByVal f)
		Map f : Sort
	End Sub

	Public Function SortBy_(ByVal f)
		Set SortBy_ = Me.Clone
		SortBy_.SortBy f
	End Function

	Public Sub Times(ByVal t)
		Dim i, arr
		arr = a_list
		For i = 1 To t
			Insert Size, arr
		Next
	End Sub

	Public Function Times_(ByVal t)
		Set Times_ = Me.Clone
		Times_.Times t
	End Function

	Public Sub Splice(ByVal o)
		If Not isArray(o) And Not isList(o) Then AB.Error.Raise 44 : Exit Sub
		Dim omap,dic,i
		If isArray(o) Then
			Insert Size, o
		ElseIf IsList(o) Then
				Set omap = o.Maps
				If omap.Count > 0 Then
					For i = 0 To o.End
						If omap.Exists(i) And (Not o_map.Exists(omap(i))) Then
							o_map.Add Size + i, omap(i)
							o_map.Add omap(i), Size + i
						End If
					Next
				End If
				Insert Size, o.Data
		End If
	End Sub

	Public Function Splice_(ByVal o)
		Set Splice_ = Me.Clone
		Splice_.Splice o
	End Function

	Public Sub Merge(ByVal o)
		Splice o
		Uniq
	End Sub

	Public Function Merge_(ByVal o)
		Set Merge_ = Me.Clone
		Merge_.Merge o
	End Function

	Public Sub Inter(ByVal o)
		If Not isArray(o) And Not isList(o) Then AB.Error.Raise 44 : Exit Sub
		Dim i,j,k,omap,arr
		arr = Array() : j = 0
		If o_hash.Count>0 Then o_hash.RemoveAll
		If isArray(o) Then
			For i = 0 To Ubound(o)
				If Has(o(i)) Then
					ReDim Preserve arr(j)
					arr(j) = o(i)
					k = IndexOf(o(i))
					If o_map.Exists(k) Then
						o_hash.Add j, o_map(k)
						o_hash.Add o_map(k), j
					End If
					j = j + 1
				End If
			Next
		ElseIf IsList(o) Then
			Set omap = o.Maps
			For i = 0 To o.End
				If Has(o(i)) Then
					ReDim Preserve arr(j)
					arr(j) = o(i)
					k = IndexOf(o(i))
					If o_map.Exists(k) Then
						o_hash.Add j, o_map(k)
						o_hash.Add o_map(k), j
					ElseIf omap.Exists(i) Then
						o_hash.Add j, omap(i)
						o_hash.Add omap(i), j
					End If
					j = j + 1
				End If
			Next
		End If
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Inter_(ByVal o)
		Set Inter_ = Me.Clone
		Inter_.Inter o
	End Function

	Public Sub Diff(ByVal o)
		If Not isArray(o) And Not isList(o) Then AB.Error.Raise 44 : Exit Sub
		Dim i,j,arr,a
		arr = Array() : j = 0
		If o_hash.Count>0 Then o_hash.RemoveAll
		If isArray(o) Then
			a = o
			Set o = Me.New
			o.Data = a
		End If
		For i = 0 To [End]
			If Not o.Has(At(i)) Then
				ReDim Preserve arr(j)
				arr(j) = At(i)
				If o_map.Exists(i) Then
					o_hash.Add j, o_map(i)
					o_hash.Add o_map(i), j
				End If
				j = j + 1
			End If
		Next
		Data = arr
		CloneDic__ o_map, o_hash
		o_hash.RemoveAll
	End Sub

	Public Function Diff_(ByVal o)
		Set Diff_ = Me.Clone
		Diff_.Diff o
	End Function

	Public Function Eq(ByVal o)
		If Not isArray(o) And Not isList(o) Then AB.Error.Raise 44 : Exit Function
		Dim a, e, m, i, j
		If isArray(o) Then
			a = o
			e = Ubound(a)
		ElseIf isList(o) Then
			a = o.Data
			e = o.End
		End If
		m = AB.C.IIF([End] < e, [End], e)
		For i = 0 To m
			If Compare__("gt", At(i), a(i)) Then
				Eq = 1 : Exit Function
			ElseIf Compare__("lt", At(i), a(i)) Then
				Eq = -1 : Exit Function
			End If
		Next
		If [End] > e Then
			Eq = 1
		ElseIf [End] < e Then
			Eq = -1
		Else
			Eq = 0
		End If
	End Function

	Public Function Son(ByVal o)
		If Not isArray(o) And Not isList(o) Then AB.Error.Raise 44 : Exit Function
		Son = True
		Dim i
		If isList(o) Then o = o.Data
		For i = 0 To Ubound(o)
			If Not Has(o(i)) Then Son = False : Exit Function
		Next
	End Function

	'===¸===

		Private Sub CloneDic__(ByRef map, ByRef hash)
			Dim key
			If map.Count > 0 Then map.RemoveAll
			For Each key In hash
				map(key) = hash(key)
			Next
		End Sub

		Private Sub Map__(ByVal f, ByVal t)
			Dim i, tmp
			For i = 0 To [End]
				tmp = Value__(At(i))
				If t = 0 Then
					At(i) = Eval(f & "("& tmp &")")
				ElseIf t = 1 Then
					ExecuteGlobal f & "("& tmp &")"
				End If
			Next
		End Sub

		Private Function Value__(ByVal s)
			Dim tmp
			Select Case VarType(s)
				Case 7,8 tmp = """" & s & """"
				Case Else tmp = s
			End Select
			Value__ = tmp
		End Function

		Private Sub RemoveMap__(ByVal i)
			If o_map.Exists(i) Then
				o_map.Remove o_map(i)
				o_map.Remove i
			End If
		End Sub

		Private Function indexOf__(ByVal arr, ByVal v)
			Dim i
			indexOf__ = -1
			For i = 0 To UBound(arr)
				If Compare__("eq", arr(i),v) Then
					indexOf__ = i
					Exit For
				End If
			Next
		End Function

		Private Sub Data__(ByVal a, ByVal t)
			Dim arr, i, j
			If isArray(a) Then
				a_list = a
				Size = Ubound(a_list) + 1
				If t = 0 Then Exit Sub
				For i = 0 To Ubound(a)
					If Instr(a(i),":")>0 Then
						j = AB.C.CLeft(a(i),":")
						If Not o_map.Exists(j) Then
							o_map.Add i, j
							o_map.Add j, i
						End If
						a(i) = AB.C.CRight(a(i),":")
					End If
				Next
				a_list = a
			Else
				arr = Split(a, " ")
				a_list = arr
				Size = Ubound(a_list) + 1
				If t = 0 Then Exit Sub
				If Instr(a, ":")>0 Then
					For i = 0 To Ubound(arr)
						If Instr(arr(i),":")>0 Then
							j = AB.C.CLeft(arr(i),":")
							If Not o_map.Exists(j) Then
								o_map.Add i, j
								o_map.Add j, i
							End If
							arr(i) = AB.C.CRight(arr(i),":")
						End If
					Next
				End If
				a_list = arr
			End If
		End Sub

		Private Function Compare__(ByVal t, ByVal a, ByVal b)
			Dim isStr : isStr = False
			If VarType(a) = 8 Or VarType(b) = 8 Then
				isStr = True
				If IsNumeric(a) And IsNumeric(b) Then isStr = False
				If IsDate(a) And IsDate(b) Then isStr = False
			End If
			If isStr Then
				Select Case LCase(t)
					Case "lt" Compare__ = (StrComp(a,b,i_comp) = -1)
					Case "gt" Compare__ = (StrComp(a,b,i_comp) = 1)
					Case "eq" Compare__ = (StrComp(a,b,i_comp) = 0)
					Case "lte" Compare__ = (StrComp(a,b,i_comp) = -1 Or StrComp(a,b,i_comp) = 0)
					Case "gte" Compare__ = (StrComp(a,b,i_comp) = 1 Or StrComp(a,b,i_comp) = 0)
				End Select
			Else
				Select Case LCase(t)
					Case "lt" Compare__ = (a < b)
					Case "gt" Compare__ = (a > b)
					Case "eq" Compare__ = (a = b)
					Case "lte" Compare__ = (a <= b)
					Case "gte" Compare__ = (a >= b)
				End Select
			End If
		End Function

		Private Sub Search__(ByVal s, ByVal keep)
			Dim arr,i,tmp
			arr = Filter(a_list, s, keep, i_comp)
			If o_map.Count = 0 Then
				Data = arr
			Else
				AddHash__ arr
			End If
		End Sub

		Private Function SortArray(ByRef arr, ByRef low, ByRef high)
			If Not IsArray(arr) Then Exit Function
			If AB.C.IsNul(arr) Then Exit Function
			Dim l, h, m, v, x
			l = low : h = high
			m = (low + high) \ 2 : v = arr(m)
			Do While (l <= h)
				Do While (Compare__("lt",arr(l),v) And l < high)
					l = l + 1
				Loop
				Do While (Compare__("lt",v,arr(h)) And h > low)
					h = h - 1
				Loop
				If l <= h Then
					x = arr(l) : arr(l) = arr(h) : arr(h) = x
					l = l + 1 : h = h - 1
				End If
			Loop
			If (low < h) Then arr = SortArray(arr, low, h)
			If (l < high) Then arr = SortArray(arr,l, high)
			SortArray = arr
		End Function

		Private Sub AddHash__(ByVal arr)
			Dim tmp
			If o_hash.Count > 0 Then o_hash.RemoveAll
			For i = 0 To Ubound(arr)
				If IndexOfHash(arr(i))>"" Then
					tmp = IndexOfHash(arr(i))
					If Not o_hash.Exists(tmp) Then
						o_hash.Add i, tmp
						o_hash.Add tmp, i
					End If
				End If
			Next
			Data = arr
			CloneDic__ o_map, o_hash
			o_hash.RemoveAll
		End Sub

		Private Sub UpFrom__(ByVal n, ByVal i)
			If n = i Then Exit Sub
			If o_map.Exists(i) Then
				o_map(o_map(i)) = n
				o_map(n) = o_map(i)
				o_map.Remove i
			End If
			At(n) = At(i)
		End Sub

		Private Sub Select__(ByVal f, ByVal t)
			Dim i, j, k, tmp, arr
			arr = Array() : j = 0
			If o_hash.Count>0 Then o_hash.RemoveAll
			k = "i"
			If AB.C.Test(f,"[a-zA-Z]+:(.+)") Then
				k = AB.C.CLeft(f,":")
				f = AB.C.CRight(f,":")
			End If
			k = "%" & k
			For i = 0 To [End]
				tmp = Replace(Trim(f), k, Value__(At(i)))
				If t = 0 Then
					tmp = Eval(tmp)
				ElseIf t = 1 Then
					tmp = (Not Eval(tmp))
				End If
				If tmp Then
					ReDim Preserve arr(j)
					arr(j) = At(i)
					If o_map.Exists(i) Then
						o_hash.Add j, o_map(i)
						o_hash.Add o_map(i), j
					End If
					j = j + 1
				End If
			Next
			Data = arr
			CloneDic__ o_map, o_hash
			o_hash.RemoveAll
		End Sub

		Private Function IsList(ByVal o)
			IsList = (Lcase(TypeName(o)) = "cls_ab_list")
		End Function

End Class
%>