<%
'######################################################################
'## ab.session.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox Session Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2011/12/28 0:45
'## Description :   AspBox Sessionģ
'######################################################################

Class Cls_AB_Session

	Private	s_mark

	Private Sub Class_Initialize()
		s_mark = ""
	End Sub

	Private Sub Class_Terminate()

	End Sub

	'@ *****************************************************************************************
	'@ ֵ:  AB.Session.Mark [= s]
	'@   :  --
	'@   :  /ȡ Sessionֵǰ׺
	'==DESC=====================================================================================
	'@  s(ѡ): String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Session.Mark = "abxss_"
	'@ AB.C.PrintCn "sessonֵǰ׺:" & AB.Session.Mark
	'@ AB.Session.Set "temp", "abcd"
	'@ AB.C.PrintCn AB.Session("temp")
	'@ AB.C.PrintCn "⽫ͬ:" & Session(AB.Session.Mark & "temp")
	'@ *****************************************************************************************

	Public Property Let Mark(Byval s)
		s_mark = s
	End Property

	Public Property Get Mark()
		Mark = s_mark
	End Property

	'@ *****************************************************************************************
	'@ :  AB.Session.Timeout = value
	'@   :  --
	'@   :   SessionTimeoutֵ
	'==DESC=====================================================================================
	'@  value: Integer ()
	'==DEMO=====================================================================================
	'@ AB.Session.Timeout = 500
	'@ *****************************************************************************************

    Public Property Let Timeout(Byval value)
		If IsNumeric(value) Then Session.Timeout = value
    End Property

	'@ *****************************************************************************************
	'@ :  AB.Session.Find(key) дʽ AB.Session(key)
	'@   :  Anything (ֵ)
	'@   :  ȡSessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ ab.c.print AB.Session("s_admin")
	'@ *****************************************************************************************

    Public Default Property Get Find(Byval key)
        Find = [Get](key)
    End Property

	'@ *****************************************************************************************
	'@ :  AB.Session.Get(key)
	'@   :  Anything (ֵ)
	'@   :  ȡSessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ ab.c.print AB.Session.Get("s_admin")
	'@ *****************************************************************************************

	Function [Get](Byval key)
		If IsObject(Session(Me.Mark & key)) Then
			Set [Get] = Session(Me.Mark & key)
		Else
			[Get] = Session(Me.Mark & key)
		End If
    End Function

	'@ *****************************************************************************************
	'@ :  AB.Session.Set key, value
	'@   :  ޷ֵ
	'@   :  Sessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'@  value: Anything (ֵ)
	'==DEMO=====================================================================================
	'@ AB.Session.Set "s_admin", "admin"
	'@ *****************************************************************************************

	Sub [Set](Byval key, Byval value)
		If IsObject(key) Then
			Set Session(Me.Mark & key) = value
		Else
			Session(Me.Mark & key) = value
		End If
    End Sub

	'@ *****************************************************************************************
	'@ :  AB.Session.Remove key
	'@   :  ޷ֵ
	'@   :  ɾĳSessionֵ
	'==DESC=====================================================================================
	'@  key: String (ַ)
	'==DEMO=====================================================================================
	'@ AB.Session.Remove "s_admin"
	'@ *****************************************************************************************

	Sub Remove(Byval key)
		If IsObject(Session(Me.Mark & key)) Then
			Set Session(Me.Mark & key) = Nothing
		End If
        Session.Contents.Remove(Me.Mark & key)
    End Sub

	'@ *****************************************************************************************
	'@ :  AB.Session.RemoveAll
	'@   :  ޷ֵ
	'@   :  ɾSessionֵ
	'==DESC=====================================================================================
	'@ : 
	'==DEMO=====================================================================================
	'@ AB.Session.RemoveAll()
	'@ *****************************************************************************************

	Sub RemoveAll()
        Dim item
        For Each item In Session.Contents
			'Me.Remove(Right(item,Len(item)-Len(Me.Mark&"")))
			Session.Contents.Remove(item)
        Next
		Session.Abandon()
	End Sub

	'@ *****************************************************************************************
	'@ :  AB.Session.Compare(key1, key2)
	'@   :  True/False ֵ
	'@   :  ȽSessionֵǷ
	'==DESC=====================================================================================
	'@  key1: String (ַ) Session 1 ļֵ
	'@  key2: String (ַ) Session 2 ļֵ
	'==DEMO=====================================================================================
	'@ AB.C.Print AB.Session.Compare("s_v1", "s_v2")
	'@ *****************************************************************************************

	Function [Compare](Byval key1, Byval key2)
        Dim Cache1
        Cache1 = Me.[Get](key1)
        Dim Cache2
        Cache2 = Me.[Get](key2)
        If TypeName(Cache1) <> TypeName(Cache2) Then
            Compare = False
        Else
            If TypeName(Cache1) = "Object" Then
                Compare = (Cache1 Is Cache2)
            Else
                If TypeName(Cache1) = "Variant()" Then
                    Compare = (Join(Cache1, "^") = Join(Cache2, "^"))
                Else
                    Compare = (Cache1 = Cache2)
                End If
            End If
        End If
    End Function

End Class
%>