<%
'######################################################################
'## ab.xml.asp
'## -------------------------------------------------------------------
'## Feature     :   AspBox XML Document Class
'## Version     :   v1.0
'## Author      :   Lajox(lajox@19www.com)
'## Update Date :   2013/03/14 2:21
'## Description :   Read and write the XML documents
'######################################################################

Class Cls_AB_Xml
	Public Dom, Doc, IsOpen
	Private s_filePath, s_xsltPath, s_charset
	Private Sub Class_Initialize()
		s_filePath = ""
		s_xsltPath = ""
		s_charset = AB.CharSet
		IsOpen = False
		AB.Error(96) = "XMLļ"
		AB.Error(97) = "ִ֧Ի򷽷"
		AB.Error(98) = "δҵĿ"
		AB.Error(99) = "XMLĵ"
	End Sub

	Private Sub Class_Terminate()
		If IsObject(Doc) Then Set Doc = Nothing
		If IsObject(Dom) Then Set Dom = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.IsOpen (ֻ)
	'# @syntax: AB.Xml.IsOpen
	'# @return: Boolean (ֵ) (True)ʾļѳɹ򿪣(False)δ
	'# @dowhat: ѯǷѾ򿪴ڵxmlļֻ
	'# 			ԿԲѯǷѾ򿪴ڵxmlļ(True)ʾļѳɹ򿪣(False)δ򿪡
	'# 			ֻе AB.Xml.Open ɹ򿪴ڵxmlļʱŻΪ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Xml"
	'# Dim str:str = "<?xml version=""1.0"" encoding=""gbk""?><x><y>y.text</y><y>y2.text</y></x>"
	'# AB.Xml.Load str
	'# AB.C.Print AB.Xml.Doc.Name  'ڵ x
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Doc (ֻ)
	'# @syntax: [Set object =]AB.Xml.Doc
	'# @return: Object (ASP) AspBox Node
	'# @dowhat: ȡAspBox XMLڵԭʼelementֻ
	'# 			ͨԻȡǰAspBox XMLĸڵ㣬ǰXmlļеĵһڵ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Xml"
	'# Dim str:str = "<?xml version=""1.0"" encoding=""gbk""?><x><y>y.text</y><y>y2.text</y></x>"
	'# AB.Xml.Load str
	'# AB.C.Print AB.Xml.Doc.Name  'ڵ x
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Dom (ֻ)
	'# @syntax: [Set object =]AB.Xml.Dom
	'# @return: Object (ASP) ԭʼXML element
	'# @dowhat: ȡAspBox XMLڵԭʼelementֻ
	'# 			ͨôԿԻȡAspBox XMLڵԭʼXML elementnodeڵ㣩
	'# 			ڴ˶ʹеXML elementXML nodeӦԭʼԡ
	'# 			ͨ AB.Xml.FindAB.Xml.Select  AB.Xml.Sel ȡAspBox XMLҲʹô
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Xml"
	'# AB.Xml.Load "<?xml version=""1.0"" encoding=""gbk""?><x><y>y.text</y><y>y2.text</y></x>"
	'# AB.C.PrintCn AB.Xml.Dom.GetElementsByTagName("y")(0).NodeName 'ԭʼȡһyڵ y
	'# AB.C.PrintCn AB.Xml.Dom.GetElementsByTagName("y")(0).NodeValue 'ԭʼȡһyڵֵ
	'# AB.C.PrintCn AB.Xml.Dom.GetElementsByTagName("y")(0).NodeType 'ԭʼȡһyڵ
	'------------------------------------------------------------------------------------------

	'------------------------------------------------------------------------------------------
	'# AB.Xml.NewDom 
	'# @syntax: [Set obj =] AB.Xml.NewDom()
	'# @return: Object (ASP) ԭʼ XMLDOM
	'# @dowhat: XMLDOM
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# Dim XmlDom : Set XmlDom = AB.Xml.NewDom()
	'------------------------------------------------------------------------------------------

	Private Function NewDom()
		Dim o
		'Set o = CreateXMLParser()
		If AB.C.IsInstall("MSXML2.DOMDocument") Then
			Set o = Server.CreateObject("MSXML2.DOMDocument")
		ElseIf AB.C.IsInstall("Microsoft.XMLDOM") Then
			Set o = Server.CreateObject("Microsoft.XMLDOM")
		End If
		o.PreserveWhiteSpace = True
		o.Async = False
		o.SetProperty "SelectionLanguage", "XPath"
		Set NewDom = o
		Set o = Nothing
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.CreateXMLParser 
	'# @syntax: [Set obj =] AB.Xml.CreateXMLParser()
	'# @return: Object (ASP) ԭʼ XMLDOM
	'# @dowhat: һܸ߰汾XMLDOM
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# Dim XmlDom : Set XmlDom = AB.Xml.CreateXMLParser()
	'------------------------------------------------------------------------------------------

	Public Function CreateXMLParser()
		On Error Resume Next
		Set CreateXMLParser = Server.CreateObject("MSXML2.DOMDocument.4.0")
		If Err.Number<>0 Then
			Err.Clear
			Set CreateXMLParser = Server.CreateObject("MSXML2.DOMDocument.3.0")
			If Err.Number<>0 Then
				Err.Clear
				Set CreateXMLParser = Server.CreateObject("MSXML2.DOMDocument.2.6")
				If Err.Number<>0 Then
					Err.Clear
					Set CreateXMLParser = Server.CreateObject("MSXML2.DOMDocument")
					If Err.Number<>0 Then
						Err.Clear
						Set CreateXMLParser = Server.CreateObject("Microsoft.XMLDOM")
						If Err.Number<>0 Then
							Err.Clear
							Set CreateXMLParser = Nothing
						Else
							Exit Function
						End If
					Else
						Exit Function
					End If
				Else
					Exit Function
				End If
			Else
				Exit Function
			End If
		Else
			Exit Function
		End If
		On Error GoTo 0
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Open 
	'# @syntax: AB.Xml.Open filePath
	'# @return: Boolean (ֵ) 򿪳ɹ(True)ʧܷؼ(False)
	'# @dowhat: 򿪱طڵxmlļ
	'# ô˷Դһڱطϵxmlļɹ򿪺 AB.Xml.IsOpen ԽΪ(True)
	'--DESC------------------------------------------------------------------------------------
	'# @param: filePath String (ַ)
	'#  Ҫļ··վ·(/ͷ)Ӳ̾·("̷:\"ͷ)
	'--DEMO------------------------------------------------------------------------------------
	'# 'Xml
	'# AB.Use "Xml"
	'# 'xmlļ
	'# AB.Xml.Open "xmldata/micrblog_catalog.xml"
	'# 'ļ·ҲǾ·
	'# Dim result
	'# result = AB.Xml.Open("D:\web\xmldata\micrblog_catalog.xml")
	'# '򿪳ɹTrueʧܣFalse
	'# AB.C.Print result
	'------------------------------------------------------------------------------------------

	Public Function Open(byVal f)
		Open = False
		If AB.C.IsNul(f) Then Exit Function
		Set Dom = NewDom()
		f = absPath(f)
		Dom.load f
		s_filePath = f
		If Not IsErr Then
			Set Doc = NewNode(Dom.documentElement)
			Open = True
			IsOpen = True
		Else
			Set Dom = Nothing
		End If
	End Function

	Private Function absPath(ByVal p)
		If AB.C.IsNul(p) Then absPath = "" : Exit Function
		If Mid(p,2,1)<>":" Then p = Server.MapPath(p)
		absPath = p
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Load 
	'# @syntax: AB.Xml.Load string|[encoding>]url
	'# @return: ޷ֵ
	'# @dowhat: ıԶַXML
	'# ô˷ԴıԶַXMLݣ
	'# ǴԶַҪ "http://"  "https://" ͷAspBoxԶжĿxmlļı롣
	'# ҪָԶļı룬ַǰϱ룬 "gbk>http://..."
	'# Ҫ뱾ļı룬·ϱ룬 "/files/a.xml>gbk"
	'--DESC------------------------------------------------------------------------------------
	'# @param: string String (ַ) XMLṹַ
	'# @param: encoding(ѡ) String (ַ)
	'#  ҪԶxmlļı룬AspBoxԶжĿļı룬Դ˲ʡԡ
	'#  Ŀxmlļûָencoding²Ҫô˲ָļı
	'# @param: url String (ַ)  http://  https:// ͷxmlļĵַ
	'--DEMO------------------------------------------------------------------------------------
	'# 'xml
	'# AB.Use "Xml"
	'# Dim str
	'# str = "<?xml version=""1.0"" encoding=""gbk""?><x><y>y.text</y><y>y2.text</y></x>"
	'# 'ıXml
	'# AB.Xml.Load str
	'# 'ڵ
	'# AB.C.PrintCn AB.Xml.Doc.Name  ' x
	'# 'ַ
	'# AB.Xml.Load "http://cf.qq.com/web200905/inc/cf_wallpapers.xml"
	'# AB.C.PrintCn AB.Xml.Doc.Name  ' wallpaper
	'------------------------------------------------------------------------------------------

	Public Sub [Load](ByVal s)
		If AB.C.IsNul(s) Then Exit Sub
		On Error Resume Next
		Dim str
		If AB.C.Test(s,"^(file:///?)?([A-Za-z]\:[\/\\]{1,2})?[\s]*[^\<>]+") Then
			AB.Use "Fso"
			Dim f : Set f = AB.Fso
			s = Replace(s, "file:///", "")
			s = Replace(s, "file://", "")
			str = f.Read(s)
			Set f = Nothing
			If AB.C.IsFile(s) Then IsOpen = True
		ElseIf AB.C.Test(s,"^([\w\d-]+>)?https?://") Then
			AB.Use "Http"
			Dim h : Set h = AB.Http.New
			str = h.Get(s)
			Set h = Nothing
		Else
			str = s
		End If
		Set Dom = NewDom()
		Dom.loadXML(str)
		If Not IsErr Then
			Set Doc = NewNode(Dom.documentElement)
		Else
			Set Dom = Nothing
		End If
		On Error Goto 0
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Close 
	'# @syntax: AB.Xml.Close
	'# @return: ޷ֵ
	'# @dowhat: رմ򿪵Xmlļ
	'# ô˷Թر AB.Xml.Open 򿪵xmlļͷĵͬʱ AB.Xml.IsOpen ֵҲΪ(False)
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Sub Close()
		Set Doc = Nothing
		Set Dom = Nothing
		s_filePath = ""
		IsOpen = False
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Save 
	'# @syntax: AB.Xml.Save
	'# @return: ޷ֵ
	'# @dowhat: Ѵ򿪵޸ĺxmlļ
	'# ô˷Ա AB.Xml.Open ֮޸Ĺıطϵxmlļ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Sub [Save]()
		If IsOpen Then
			Dom.Save(s_filePath)
		Else
			AB.Error.Msg = "ĵδڴ״̬"
			AB.Error.Raise 99
		End If
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.SaveAs 
	'# @syntax: AB.Xml.SaveAs filePath[>encoding]
	'# @return: ޷ֵ
	'# @dowhat: ѵǰXMLݱΪһxmlļ
	'# ô˷԰ѵǰڴXMLݱΪһļ
	'# ڱļ ">gbk" ָı룬
	'# ָбĲı䣬ޱĲ Ĭֵ AB.Charset 롣
	'#  AB.Xml.Load Xmlֻô˷ļ
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# AB.XML.Load("<?xml version=""1.0"" encoding=""gbk""?><root><x><y>y.text</y></x></root>")
	'# AB.Xml.SaveAs("E:/ASPWeb/wwwroot/mytest.xml")
	'------------------------------------------------------------------------------------------

	Public Sub SaveAs(ByVal p)
		Dim ch,cha,pi
		If Instr(p,">")>0 Then
			ch = AB.C.CRight(p,">")
			p = AB.C.CLeft(p,">")
		End If
		cha = AB.C.IfHas(ch, s_charset)
		p = absPath(p)
		Set pi = Dom.CreateProcessingInstruction("xml", "version=""1.0"" encoding=""" & cha & """")
		If Dom.FirstChild.BaseName<>"xml" Then
			Dom.InsertBefore pi, Dom.FirstChild
		Else
			If AB.C.Has(ch) Then Dom.ReplaceChild pi, Dom.FirstChild
		End If
		Dom.Save(p)
		Set pi = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.SaveAsXHTML 
	'# @syntax: AB.Xml.SaveAsXHTML filePath, xslPath
	'# @return: ޷ֵ
	'# @dowhat: XSLTǰXMLݱΪXHTMLĵ
	'# ô˷XSLTĵǰXMLתΪXHTMLĵ
	'--DESC------------------------------------------------------------------------------------
	'# @param filePath: XHTMLĵļ·
	'# @param xslPath: XSLTĵַXSLTһת XML ĵԣ
	'# xslο http://www.w3.org/TR/WD-xsl http://www.w3.org/TR/xsl11/ http://www.w3.org/1999/XSL/Transform
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Sub SaveAsXHTML(ByVal p, ByVal xsl)
		Dim x,f : Set x = [New]
		If AB.C.Test(xsl,"^([\w\d-]+>)?https?://") Then
			x.Load xsl
		Else
			x.Open xsl
		End If
		f = Dom.TransformNode(x.Dom)
		AB.Use "Fso"
		AB.Fso.CreateFile p, f
		Set x = Nothing
	End Sub

	'------------------------------------------------------------------------------------------
	'# AB.Xml.NewNode 
	'# @syntax: Set object = AB.Xml.NewNode(element)
	'# @return: Object (ASP) AspBox Node
	'# @dowhat: ԭʼelementAspBox Node
	'# ô˷ԭʼXML elementXML selectionAspBox Node֮ͿڸöӦAspBox NodeԺͷ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Function NewNode(ByVal o)
		Set NewNode = New Cls_AB_Xml_Node
		NewNode.Dom = o
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Root (ֻ)
	'# @syntax: [Set object =]AB.Xml.Root
	'# @alias:  [Set object =]abNode.Root
	'# @return: Object (ASP) AspBox Node 
	'# @dowhat: ͨԻȡǰXMLݵĸĵ(#document)
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Property Get Root
		Set Root = NewNode(Dom)
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml.New 
	'# @syntax: Set object = AB.Xml.New
	'# @return: Object (ASP) AspBox XML
	'# @dowhat: µAspBox XML
	'# Եô˷µAspBox XML֮ͿڸöʹAspBox XMLз
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# 'Xml
	'# AB.Use "Xml"
	'# Dim xml
	'# 'AspBox XML
	'# Set xml = AB.Xml.New
	'# xml.Open "xmldata/miroblog_catalog.xml"
	'# '......
	'# Set xml = Nothing
	'------------------------------------------------------------------------------------------

	Public Function [New]()
		Set [New] = New Cls_AB_Xml
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Find 
	'# @syntax: [Set object = ]AB.Xml.Find(selector)
	'# @alias:  [Set object = ]AB.Xml(selector)
	'# @return: Object (ASP) AspBox Node
	'# @dowhat: ѡXmlڵ
	'# 			˷AspBox XMLĬϷַͨʽѡxmlеĽڵ㣬
	'# 			ʹ÷jQueryеѡְ֧ǩԡ㼶XPath
	'# 			⣬еAspBox NodeҲô˷ڲѡӽڵ㡣
	'# 			˷AspBox XMLпʡFindֱ AB.Xml(selector) ѡ
	'# 			AspBox Nodeʹô˷ѡӽڵʱʡFind
	'--DESC------------------------------------------------------------------------------------
	'# @param object(ѡ): Variable () Ѷδʼı
	'# @param selector: String (ַ) ѡڵַͨǱǩҲ·ţ
	'#  "a,b" - ʾͬʱѡabڵ
	'#  "a>b" - ʾaӽڵвb
	'#  "a b" - ʾaĺڵвb
	'#  "a[b]"  "a[@b]" - ʾҴbaڵ
	'#  "a[b='c']"  "a[@b='c']" - ʾҴbֵΪcaڵ
	'#  "a[b!='c']"  "a[@b!='c']" - ʾҴbֵΪcaڵ
	'#  ͬʱöԶλڵ㣬[]ֱɣ "a[b='c'][d='e'][f!='g']"
	'--DEMO------------------------------------------------------------------------------------
	'# 'Xml
	'# AB.Use "Xml"
	'# 'XmlݣɵӲ鿴ݽṹ
	'# AB.Xml.Load "example/xml/microblog_catalog.xml"
	'# 'ѡбǩΪnameĽڵ㣬ҵĽڵ
	'# AB.C.PrintCn AB.Xml("name").Length
	'# AB.C.PrintCn "--------"
	'# 'ѡаaliasıǩΪnameĽڵ㣬ҵĽڵ
	'# AB.C.PrintCn AB.Xml("name[alias]").Length
	'# AB.C.PrintCn "--------"
	'# 'ѡformenickԲemailıǩΪaccountĽڵ㣬Xml
	'# AB.C.PrintCn AB.Xml("account[for='me'][nick!='email']").Xml
	'# AB.C.PrintCn "--------"
	'# 'ѡsiteڵӽڵбǩΪnameĽڵ㣬Xml
	'# AB.C.PrintCn AB.Xml("site>name").Xml
	'# AB.C.PrintCn "--------"
	'# 'ѡaccountڵĺڵбǩΪnameĽڵ㣬Xml
	'# AB.C.PrintCn AB.Xml("account name").Xml
	'# AB.C.PrintCn "--------"
	'# 'ѡеurllastڵ㣬Xml
	'# AB.C.PrintCn AB.Xml("url,last").Xml
	'# AB.C.PrintCn "--------"
	'------------------------------------------------------------------------------------------

	Public Default Function Find(ByVal t)
		Dim o,s
		If AB.C.Test(t,"^<[\s\S]+>$") Then
		Else
			If AB.C.Test(t, "[, >\[@:]") Then
				Set o = Dom.selectNodes(AB_Xml_TransToXpath(t))
			Else
				Set o = Dom.GetElementsByTagName(t)
			End If
		End If
		' If o.Length = 0 Then
			' AB.Error.Msg = "("&t&")"
			' AB.Error.Raise 98
		' End If
		If o.Length = 1 Then
			Set Find = NewNode(o(0))
		Else
			Set Find = NewNode(o)
		End If
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Length 
	'# @syntax: [number = ]AB.Xml.Length(selector)
	'# @alias:  [number = ]AB.Xml(selector).Length  [number = ]AB.Xml.Count(selector)
	'# @return: Integer () ڵ
	'# @dowhat: ȡڵ
	'--DESC------------------------------------------------------------------------------------
	'# @param number(ѡ): Variable () Ѷδʼı
	'# @param selector: String (ַ) ѡڵַͨǱǩҲ·ţ
	'#  "a,b" - ʾͬʱѡabڵ
	'#  "a>b" - ʾaӽڵвb
	'#  "a b" - ʾaĺڵвb
	'#  "a[b]"  "a[@b]" - ʾҴbaڵ
	'#  "a[b='c']"  "a[@b='c']" - ʾҴbֵΪcaڵ
	'#  "a[b!='c']"  "a[@b!='c']" - ʾҴbֵΪcaڵ
	'#  ͬʱöԶλڵ㣬[]ֱɣ "a[b='c'][d='e'][f!='g']"
	'--DEMO------------------------------------------------------------------------------------
	'# AB.XML.Load("<?xml version=""1.0"" encoding=""gbk""?><root><x><y>y.text</y></x></root>")
	'# If AB.Xml("y").Length>0 Then
	'# 	AB.Trace AB.Xml("y")(0).Xml '<y>y.text</y>
	'# 	AB.Trace AB.Xml("y")(0).Name 'y
	'# 	AB.Trace AB.Xml("y")(0).Value 'y.text
	'# End If
	'------------------------------------------------------------------------------------------

	Public Function Length(ByVal t)
		Length = Find(t).Length
	End Function
	Public Function Count(ByVal t) : Count = Find(t).Length : End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Select 
	'# @syntax: [Set object = ]AB.Xml.Select(xPath)
	'# @alias:  [Set object = ]AB.Xml.Sel(xPath)
	'# @return: Object (ASP) AspBox Node 
	'# @dowhat: XPathʽѡڵ
	'# ô˷XPathʽѡڵ㣬൱ԭʼXML selectNodes ͬǷص AspBox Node 
	'--DESC------------------------------------------------------------------------------------
	'# @param xPath: String(ַ) XPathʽ(һ XML ĵе)
	'# Բοhttp://www.w3school.com.cn/xpath/index.asp
	'--DEMO------------------------------------------------------------------------------------
	'# AB.XML.Load("<?xml version=""1.0"" encoding=""gbk""?><root><x><y>y.text</y></x></root>")
	'# AB.Trace AB.Xml.Select("/root/x/y")(0).Value
	'------------------------------------------------------------------------------------------

	Public Function [Select](ByVal p)
		Set [Select] = NewNode(Dom.selectNodes(p))
	End Function

	Public Function Sel(ByVal p)
		Set Sel = NewNode(Dom.selectSingleNode(p))
	End Function

	'------------------------------------------------------------------------------------------
	'# AB.Xml.Create 
	'# @syntax: Set object = AB.Xml.Create(name[tagType], value)
	'# @return: Object (ASP) AspBox Node 
	'# @dowhat: ½һAspBox Node ڵ
	'# ô˷½һ AspBox Node ڵ㣬ͨͬ tagType ͨڵ㡢CDATAڵCommentڵ㡣
	'--DESC------------------------------------------------------------------------------------
	'# @param: none
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Function Create(ByVal n, ByVal v)
		Dim o,p,cd
		If Instr(n," ")>0 Then
			cd = LCase(AB.C.CRight(n," "))
			n = AB.C.CLeft(n," ")
		End If
		If cd="comment" Then
			Set o = Dom.createComment(v)
		Else
			Set o = Dom.CreateElement(n)
			If cd = "cdata" Then
				Set p = Dom.CreateCDATASection(v)
			Else
				Set p = Dom.CreateTextNode(v)
			End If
			o.AppendChild(p)
		End If
		Set Create = NewNode(o)
		Set o = Nothing
		Set p = Nothing
	End Function

	Private Function IsErr()
		Dim s
		IsErr = False
		If Dom.ParseError.Errorcode<>0 Then
			With Dom.ParseError
				s = s & "	<ul class=""dev"">" & vbCrLf
				s = s & "		<li class=""info"">ϢԿߣ</li>" & vbCrLf
				s = s & "		<li>룺0x" & Hex(.Errorcode) & "</li>" & vbCrLf
				If AB.C.Has(.Reason) Then s = s & "		<li>ԭ" & .Reason & "</li>" & vbCrLf
				If AB.C.Has(.Url) Then s = s & "		<li>Դ" & .Url & "</li>" & vbCrLf
				If AB.C.Has(.Line) And .Line<>0 Then s = s & "		<li>кţ" & .Line & "</li>" & vbCrLf
				If AB.C.Has(.Filepos) And .Filepos<>0 Then s = s & "		<li>λã" & .Filepos & "</li>" & vbCrLf
				If AB.C.Has(.SrcText) Then s = s & "		<li>Դ  " & .SrcText & "</li>" & vbCrLf
				s = s & "	</ul>" & vbCrLf
			End With
			IsErr = True
			AB.Error.Msg = s
			AB.Error.Raise 96
		End If
	End Function

End Class

Class Cls_AB_Xml_Node
	Private o_node

	Private Sub Class_Initialize()

	End Sub

	Private Sub Class_Terminate()
		Set o_node = Nothing
	End Sub

	Private Function [New](ByVal o)
		Set [New] = New Cls_AB_Xml_Node
		[New].Dom = o
	End Function

	Public Property Let Dom(ByVal o)
		If Not o Is Nothing Then
			Set o_node = o
		Else
			AB.Error.Msg = "(ЧXML)"
			AB.Error.Raise 97
		End If
	End Property

	Public Property Get Dom
		Set Dom = o_node
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml(selector).Item (ֻ)
	'# @syntax: [Set object = ]abNode.Item(index)
	'# @alias:  [Set object = ]abNode.Item(index)
	'# @return: Object (ASP) AspBox Node 
	'# @dowhat: ѡAspBox Node󼯺еĳһAspBox Node
	'# 			ЩԻȡ AspBox Node 󼯺еĳһ AspBox Node 
	'# 			һAspBox NodeһϣΪ 0  index 
	'--DESC------------------------------------------------------------------------------------
	'# @param: ###
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Default Property Get Item(ByVal n)
		If IsNodes Then
			Set Item = [New](o_node(n))
		ElseIf IsNode And n = 0 Then
			Set Item = [New](o_node)
		Else
			AB.Error.Msg = "(ЧXMLԪؼ϶&lt;"&TypeName(o_node)&"&gt;)"
			AB.Error.Raise 97
		End If
	End Property

	'-------------------------------------------------------------------------
	' @ AB.Xml(selector).IsNode ѯǰAspBox NodeǷԪؽڵ㣬ֻ
	'-------------------------------------------------------------------------
	' Desc:  ôԲѯǰAspBox NodeǷԪؽڵ(element)
	'-------------------------------------------------------------------------

	Public Property Get IsNode
		IsNode = TypeName(o_node) = "IXMLDOMElement"
	End Property

	'-------------------------------------------------------------------------
	' @ AB.Xml(selector).IsNodes ѯǰAspBox NodeǷԪؽڵ㼯
	'-------------------------------------------------------------------------
	' Desc:  ôԵǰAspBox NodeǷԪؽڵ㼯(selection)
	'-------------------------------------------------------------------------

	Public Property Get IsNodes
		IsNodes = TypeName(o_node) = "IXMLDOMSelection"
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml(selector).Item 
	'# @syntax: abNode.Attr(name)[ = value]
	'# @return: String (ַ) ֵ
	'# @dowhat: ȡõǰAspBox NodeԪؽڵԣȫֲд
	'# 			ôԶȡXMLԪؽڵֵ
	'# 			abNodeһ϶ֵʱѼڵнڵԶΪֵͬ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ###
	'--DEMO------------------------------------------------------------------------------------
	'# AB.Use "Xml"
	'# AB.Xml.Load "<?xml version=""1.0"" encoding=""gbk""?><x><y>y.text</y><y>y2.text</y></x>"
	'# dim abDoc : Set abDoc = AB.Xml.Doc
	'# abDoc.Attr("abcd") = "123"
	'# ab.c.print abDoc.name & "<br>" ': x<br>
	'# ab.c.print abDoc.Attr("abcd") ': 123
	'------------------------------------------------------------------------------------------

	Public Property Let Attr(ByVal s, ByVal v)
		If IsNull(v) Then RemoveAttr s : Exit Property
		If IsNode Then
			o_node.setAttribute s, v
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).setAttribute s, v
			Next
		End If
	End Property

	Public Property Get Attr(ByVal s)
		If Not IsNode Then Exit Property
		Attr = o_node.getAttribute(s)
	End Property

	Public Property Let Text(ByVal v)
		If IsNode Then
			If AB.C.Has(v) Then o_node.Text = v
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				If AB.C.Has(v) Then o_node(i).Text = v
			Next
		End If
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml(selector).Text 
	'# @syntax: abNode.Text [ = value]
	'# @return: String (ַ) ڵԪڵı
	'# @dowhat: ȡõǰAspBox NodeԪؽڵıԿɶд
	'# ʹôԿúͻȡAspBox NodeıNodeϣ򷵻ػнڵı
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Property Get Text
		If IsNode Then
			Text = o_node.Text
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				Text = Text & o_node(i).Text
			Next
		End If
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml(selector).Value 
	'# @syntax: abNode.Value[ = string]
	'# @return: String (ַ) ڵԪڵֵ
	'# @dowhat: úͻȡǰAspBox NodeԪؽڵֵԿɶд
	'# ʹôԿúͻȡAspBox NodeֵNodeϣнڵֵ޷ȡֵ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Property Let Value(ByVal v)
		If IsNode Then
			o_node.ChildNodes(0).NodeValue = v
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).ChildNodes(0).NodeValue = v
			Next
		End If
	End Property

	Public Property Get Value
		If Not IsNode Then Exit Property
		Value = o_node.ChildNodes(0).NodeValue
	End Property

	'------------------------------------------------------------------------------------------
	'# AB.Xml(selector).Xml 
	'# @syntax: abNode.Xml
	'# @return: String (ַ) XMLƬ
	'# @dowhat: ȡǰAspBox NodeXml룬ֻ
	'# 			ôԿԷصǰAspBox NodeԪؽڵXMLƬ
	'--DESC------------------------------------------------------------------------------------
	'# @param: ޲
	'--DEMO------------------------------------------------------------------------------------
	'# none
	'------------------------------------------------------------------------------------------

	Public Property Get Xml
		If IsNode Then
			Xml = o_node.Xml
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				If i>0 Then Xml = Xml & vbCrLf
				Xml = Xml & o_node(i).Xml
			Next
		End If
	End Property

	Public Property Get Name
		If Not IsNode Then Exit Property
		Name = o_node.BaseName
	End Property

	Public Property Get [Type]
		If IsNodes Then
			[Type] = 0
		Else
			[Type] = o_node.NodeType
		End If
	End Property

	Public Property Get TypeString
	If IsNodes Then
			TypeString = "selection"
		Else
			TypeString = o_node.NodeTypeString
		End If
	End Property

	Public Property Get Length
		If IsNode Then
			Length = o_node.ChildNodes.Length
		Else
			Length = o_node.Length
		End If
	End Property

	Public Property Get Root
		If Not IsNode Then Exit Property
		Set Root = [New](o_node.OwnerDocument)
	End Property

	Public Property Get Parent
		If Not IsNode Then Exit Property
		Set Parent = [New](o_node.parentNode)
	End Property

	Public Property Get ChildNodes
		If Not IsNode Then Exit Property
		Set ChildNodes = [New](o_node.ChildNodes)
	End Property

	Public Property Get Child(ByVal n)
		If Not IsNode Then Exit Property
		Set Child = [New](o_node.ChildNodes(n))
	End Property

	Public Property Get Prev
		If Not IsNode Then Exit Property
		Dim o
		Set o = o_node.PreviousSibling
		Do While True
			If TypeName(o) = "Nothing" Or TypeName(o) = "IXMLDOMElement" Then Exit Do
			Set o = o.PreviousSibling
		Loop
		If TypeName(o) = "IXMLDOMElement" Then
			Set [Prev] = [New](o)
			Set o = Nothing
		Else
			AB.Error.Msg = "(ûһͬԪ)"
			AB.Error.Raise 96
		End If
	End Property

	Public Property Get [Next]
		If Not IsNode Then Exit Property
		Dim o
		Set o = o_node.NextSibling
		Do While True
			If TypeName(o) = "Nothing" Or TypeName(o) = "IXMLDOMElement" Then Exit Do
			Set o = o.NextSibling
		Loop
		If TypeName(o) = "IXMLDOMElement" Then
			Set [Next] = [New](o)
			Set o = Nothing
		Else
			AB.Error.Msg = "(ûһͬԪ)"
			AB.Error.Raise 96
		End If
	End Property

	Public Property Get First
		If Not IsNode Then Exit Property
		Set First = [New](o_node.FirstChild)
	End Property

	Public Property Get Last
		If Not IsNode Then Exit Property
		Set Last = [New](o_node.LastChild)
	End Property

	Public Function HasAttr(ByVal s)
		If Not IsNode Then Exit Function
		Dim oattr
		Set oattr = o_node.Attributes.GetNamedItem(s)
		HasAttr = Not oattr Is Nothing
		Set oattr = Nothing
	End Function

	Public Function HasChild()
		If Not IsNode Then Exit Function
		HasChild = o_node.hasChildNodes()
	End Function

	Public Function Find(ByVal t)
		If Not IsNode Then Exit Function
		Dim o
		If AB.C.Test(t, "[, >\[@:]") Then
			Set o = o_node.selectNodes(AB_Xml_TransToXpath(t))
		Else
			Set o = o_node.GetElementsByTagName(t)
		End If
		If o.Length = 0 Then
			'AB.Error.Msg = "("&t&")"
			'AB.Error.Raise 98
			Set Find = [New](o)
		ElseIf o.Length = 1 Then
			Set Find = [New](o(0))
		Else
			Set Find = [New](o)
		End If
	End Function

	Public Function [Select](ByVal p)
		If Not IsNode Then Exit Function
		Set [Select] = [New](o_node.selectNodes(p))
	End Function

	Public Function Sel(ByVal p)
		If Not IsNode Then Exit Function
		Set Sel = [New](o_node.selectSingleNode(p))
	End Function

	Public Function Clone(ByVal b)
		If Not IsNode Then Exit Function
		If AB.C.IsNul(b) Then b = True
		Set Clone = [New](o_node.CloneNode(b))
	End Function

	Private Function GetNodeDom(ByVal o)
		Select Case TypeName(o)
			Case "IXMLDOMElement" Set GetNodeDom = o
			Case "Cls_AB_Xml_Node" Set GetNodeDom = o.Dom
		End Select
	End Function

	Public Function Append(ByVal o)
		If Not IsNode Then Exit Function
		o_node.AppendChild(GetNodeDom(o))
		Set Append = [New](o_node)
	End Function

	Public Function ReplaceWith(ByVal o)
		If IsNode Then
			Call o_node.ParentNode.replaceChild(GetNodeDom(o), o_node)
		ElseIf IsNodes Then
			Dim i,n
			For i = 0 To Length - 1
				Set n = GetNodeDom(o).CloneNode(True)
				Call o_node(i).ParentNode.replaceChild(n, o_node(i))
			Next
		End If
		Set ReplaceWith = [New](o_node)
	End Function

	Public Function Before(ByVal o)
		If IsNode Then
			Call o_node.ParentNode.InsertBefore(GetNodeDom(o), o_node)
		ElseIf IsNodes Then
			Dim i,n
			For i = 0 To Length - 1
				Set n = GetNodeDom(o).CloneNode(True)
				Call o_node(i).ParentNode.InsertBefore(n, o_node(i))
			Next
		End If
		Set Before = [New](o_node)
	End Function

	Public Function After(ByVal o)
		If IsNode Then
			Call InsertAfter(GetNodeDom(o), o_node)
		ElseIf IsNodes Then
			Dim i,n
			For i = 0 To Length - 1
				Set n = GetNodeDom(o).CloneNode(True)
				Call InsertAfter(n, o_node(i))
			Next
		End If
		Set After = [New](o_node)
	End Function

	Private Sub InsertAfter(ByVal n, Byval o)
		Dim p
		Set p = o.ParentNode
		If p.LastChild Is o Then
			p.AppendChild(n)
		Else
			Call p.InsertBefore(n, o.nextSibling)
		End If
	End Sub

	Public Function RemoveAttr(ByVal s)
		If IsNode Then
			o_node.removeAttribute(s)
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).removeAttribute(s)
			Next
		End If
		Set RemoveAttr = [New](o_node)
	End Function

	Public Function [Empty]
		If IsNode Then
			o_node.Text = ""
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).Text = ""
			Next
		End If
		Set [Empty] = [New](o_node)
	End Function

	Public Function Clear
		If IsNode Then
			o_node.Text = ""
			o_node.removeChild(o_node.FirstChild)
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).Text = ""
				o_node(i).removeChild(o_node(i).FirstChild)
			Next
		End If
		Set Clear = [New](o_node)
	End Function

	Public Function Normalize
		If IsNode Then
			o_node.normalize()
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).normalize()
			Next
		End If
		Set Normalize = [New](o_node)
	End Function

	Public Sub Remove
		If IsNode Then
			o_node.ParentNode.RemoveChild(o_node)
		ElseIf IsNodes Then
			Dim i
			For i = 0 To Length - 1
				o_node(i).ParentNode.RemoveChild(o_node(i))
			Next
		End If
	End Sub

End Class
Function AB_Xml_TransToXpath(ByVal s)
	s = AB.C.RegReplace(s, "\s*,\s*", "|//")
	s = AB.C.RegReplace(s, "\s*>\s*", "/")
	s = AB.C.RegReplace(s, "\s+", "//")
	s = AB.C.RegReplace(s, "(\[)([a-zA-Z]+\])", "$1@$2")
	s = AB.C.RegReplace(s, "(\[)([a-zA-Z]+[!]?=[^\]]+\])", "$1@$2")
	s = AB.C.RegReplace(s, "(?!\[\d)\]\[", " and ")
	s = Replace(s, "|", " | ")
	AB_Xml_TransToXpath = "//" & s
End Function
%>