package com.syj.wutui;

import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.List;

import com.example.webdatashow.R;

import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.app.Activity;
import android.content.Intent;
import android.text.Editable;
import android.text.TextWatcher;
import android.view.View;
import android.view.WindowManager;
import android.widget.LinearLayout;
import android.widget.Toast;

public class H_MainActivity extends Activity {

	private H_AutoCompleteTextView search_et;
	MyHandler mHandler = null;
	private static final int UPDATE_VIEW = 1001;
	private static final int CHANGE_INPUT = 1002;
	private ArrayList<String> data;
	private H_DBManager mgr;
	private List<H_SearchHistoryVo> list;
	private LinearLayout ll_search;

	@Override
	protected void onCreate(Bundle savedInstanceState) {
		super.onCreate(savedInstanceState);
		setContentView(R.layout.h_activity_main);
		showStatusBar();

		search_et = (H_AutoCompleteTextView) findViewById(R.id.btn);
		ll_search = (LinearLayout) findViewById(R.id.ll_search);
		mgr = new H_DBManager(this);
		mHandler = new MyHandler();
		data = new ArrayList<String>();
		data = getData();
		if (list.size() > 0) {
			for (int i = 0; i < list.size(); i++) {
				data.add(list.get(i).getContent());
			}
		}
		search_et.setFatherLinearLayout(ll_search);
		mHandler.sendEmptyMessage(CHANGE_INPUT);

		search_et.addTextChangedListener(new TextWatcher() {

			@Override
			public void afterTextChanged(Editable s) {
				mHandler.sendEmptyMessage(CHANGE_INPUT);
			}

			@Override
			public void beforeTextChanged(CharSequence s, int start, int count,
					int after) {
				mHandler.sendEmptyMessage(CHANGE_INPUT);
			}

			@Override
			public void onTextChanged(CharSequence s, int start, int before,
					int count) {
				mHandler.sendEmptyMessage(CHANGE_INPUT);
			}
		});

	}

	class MyHandler extends Handler {

		@Override
		public void handleMessage(Message msg) {
			switch (msg.what) {
			case UPDATE_VIEW:
				break;
			case CHANGE_INPUT:
				initData();
				break;
			}
		}
	}

	public void onClick(View v) {
		switch (v.getId()) {
		case R.id.bt_sousuo:
			if ((search_et.getText().toString()).equals("")) {
				Toast.makeText(H_MainActivity.this, "Ҫʲôţ",
						Toast.LENGTH_SHORT).show();
			}
			 else {
			 btn_search();
			 Intent intent=new
			 Intent(H_MainActivity.this,MainActivity2.class);
			 Bundle bundle=new Bundle();
			
			 bundle.putString("str", search_et.getText().toString());
			 intent.putExtras(bundle);
			 startActivity(intent);
			 search_et.setText("");
			 }

			break;
		case R.id.jilu:
			Intent intent2 = new Intent(H_MainActivity.this, H_Jilu.class);
			startActivity(intent2);
			break;
		}
	}

	private void btn_search() {
		if (!search_et.getText().toString().trim().equals("")) {
			SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
			H_SearchHistoryVo item = new H_SearchHistoryVo();
			item.content = search_et.getText().toString();
			item.searchtime = sdf.format(new Date());
			mgr.addSearchResult(item);
			mHandler.sendEmptyMessage(CHANGE_INPUT);
		}
	}

	private ArrayList<String> getData() {
		data.clear();
		list = mgr.querySearchHistory();
		Collections.reverse(list);
		for (int i = 0; i < list.size(); i++) {
			data.add(list.get(i).content);
		}
		return data;
	}

	private void initData() {
		data = getData();
		search_et.setMemoryData(data);
	}
	
	private void showStatusBar() {
		 WindowManager.LayoutParams attrs = getWindow().getAttributes();
		 attrs.flags &= ~WindowManager.LayoutParams.FLAG_FULLSCREEN;
		 getWindow().setAttributes(attrs);
		 }

}
