/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.map;

import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Bundle;
import android.os.Parcelable;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.HeatMap;
import com.baidu.mapapi.map.InfoWindow;
import com.baidu.mapapi.map.MapPoi;
import com.baidu.mapapi.map.MapStatus;
import com.baidu.mapapi.map.MapStatusUpdate;
import com.baidu.mapapi.map.MapStatusUpdateFactory;
import com.baidu.mapapi.map.MapView;
import com.baidu.mapapi.map.MapViewLayoutParams;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.MyLocationConfiguration;
import com.baidu.mapapi.map.MyLocationData;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.Projection;
import com.baidu.mapapi.map.UiSettings;
import com.baidu.mapapi.map.a;
import com.baidu.mapapi.map.b;
import com.baidu.mapapi.map.c;
import com.baidu.mapapi.model.LatLng;
import com.baidu.platform.comapi.map.e;
import com.baidu.platform.comapi.map.f;
import com.baidu.platform.comapi.map.z;
import com.baidu.platform.comjni.tools.ParcelItem;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.microedition.khronos.opengles.GL10;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BaiduMap {
    public static final int MAP_TYPE_NORMAL = 1;
    public static final int MAP_TYPE_SATELLITE = 2;
    private static final String b = BaiduMap.class.getSimpleName();
    private Projection c;
    private UiSettings d;
    private f e;
    private List<Overlay> f;
    private List<Marker> g;
    private Overlay.a h;
    private OnMapStatusChangeListener i;
    private OnMapTouchListener j;
    private OnMapClickListener k;
    private OnMapLoadedCallback l;
    private OnMapDoubleClickListener m;
    private OnMapLongClickListener n;
    private ArrayList<OnMarkerClickListener> o = new ArrayList();
    private ArrayList<OnPolylineClickListener> p = new ArrayList();
    private OnMarkerDragListener q;
    private OnMyLocationClickListener r;
    private SnapshotReadyCallback s;
    private OnMapDrawFrameCallback t;
    private HeatMap u;
    private Lock v = new ReentrantLock();
    private InfoWindow w;
    private Marker x;
    private View y;
    private Marker z;
    private MyLocationData A;
    private MyLocationConfiguration B;
    MapView a;
    private boolean C;

    BaiduMap(f f2) {
        this.e = f2;
        this.d = new UiSettings(this.e);
        this.f = new LinkedList<Overlay>();
        this.g = new LinkedList<Marker>();
        this.h = new a(this);
        b b2 = new b(this);
        this.e.a(b2);
        c c2 = new c(this);
        this.e.a(c2);
    }

    public final Overlay addOverlay(OverlayOptions overlayOptions) {
        Marker marker;
        Overlay overlay = overlayOptions.a();
        overlay.listener = this.h;
        if (overlay instanceof Marker) {
            marker = (Marker)overlay;
            if (marker.l != null && marker.l.size() != 0) {
                this.g.add(marker);
                this.e.a(true);
            }
        }
        marker = new Bundle();
        overlay.a((Bundle)marker);
        this.e.a((Bundle)marker);
        this.f.add(overlay);
        return overlay;
    }

    public final void clear() {
        this.f.clear();
        this.g.clear();
        this.e.a(false);
        this.e.s();
        this.hideInfoWindow();
    }

    public final void setMapStatus(MapStatusUpdate mapStatusUpdate) {
        if (mapStatusUpdate == null) {
            return;
        }
        z z2 = this.a(mapStatusUpdate);
        this.e.a(z2);
        if (this.i != null) {
            this.i.onMapStatusChange(this.getMapStatus());
        }
    }

    public final MapStatus getMapStatus() {
        z z2 = this.e.p();
        return MapStatus.a(z2);
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate, int n2) {
        if (mapStatusUpdate == null || n2 <= 0) {
            return;
        }
        z z2 = this.a(mapStatusUpdate);
        if (!this.C) {
            this.e.a(z2);
        } else {
            this.e.a(z2, n2);
        }
    }

    public final void animateMapStatus(MapStatusUpdate mapStatusUpdate) {
        this.animateMapStatus(mapStatusUpdate, 300);
    }

    private z a(MapStatusUpdate mapStatusUpdate) {
        z z2 = this.e.p();
        MapStatus mapStatus = mapStatusUpdate.a(this.e, this.getMapStatus());
        z z3 = mapStatus.b(z2);
        return z3;
    }

    public final void setMapType(int n2) {
        if (n2 == 1) {
            this.e.d(false);
        } else if (n2 == 2) {
            this.e.d(true);
        }
    }

    public final int getMapType() {
        return this.e.f() ? 2 : 1;
    }

    public final float getMaxZoomLevel() {
        return this.e.a;
    }

    public final void setMaxAndMinZoomLevel(float f2, float f3) {
        if (f2 > 20.0f) {
            return;
        }
        if (f3 < 3.0f) {
            return;
        }
        if (f2 < f3) {
            return;
        }
        this.e.a = f2;
        this.e.b = f3;
    }

    public final float getMinZoomLevel() {
        return this.e.b;
    }

    public final Projection getProjection() {
        return this.c;
    }

    public final UiSettings getUiSettings() {
        return this.d;
    }

    public final void setBuildingsEnabled(boolean bl) {
        this.e.e(bl);
    }

    public final boolean isBuildingsEnabled() {
        return this.e.g();
    }

    public final void setMyLocationEnabled(boolean bl) {
        this.e.g(bl);
    }

    public final boolean isMyLocationEnabled() {
        return this.e.i();
    }

    public final void setMyLocationData(MyLocationData myLocationData) {
        this.A = myLocationData;
        if (this.B == null) {
            this.B = new MyLocationConfiguration(MyLocationConfiguration.LocationMode.NORMAL, false, null);
        }
        this.a(myLocationData, this.B);
    }

    public final MyLocationData getLocationData() {
        return this.A;
    }

    public final void setMyLocationConfigeration(MyLocationConfiguration myLocationConfiguration) {
        this.B = myLocationConfiguration;
        this.a(this.A, this.B);
    }

    public final MyLocationConfiguration getLocationConfigeration() {
        return this.B;
    }

    private final void a(MyLocationData myLocationData, MyLocationConfiguration myLocationConfiguration) {
        Object object;
        Bundle bundle;
        if (myLocationData == null || myLocationConfiguration == null || !this.isMyLocationEnabled()) {
            return;
        }
        JSONObject jSONObject = new JSONObject();
        JSONArray jSONArray = new JSONArray();
        JSONObject jSONObject2 = new JSONObject();
        JSONObject jSONObject3 = new JSONObject();
        LatLng latLng = new LatLng(myLocationData.latitude, myLocationData.longitude);
        com.baidu.platform.comapi.a.b b2 = com.baidu.mapapi.model.a.a(latLng);
        try {
            jSONObject.put("type", 0);
            jSONObject2.put("ptx", b2.b());
            jSONObject2.put("pty", b2.a());
            float f2 = com.baidu.mapapi.model.a.a(latLng, (int)myLocationData.accuracy);
            jSONObject2.put("radius", (double)f2);
            float f3 = myLocationData.direction;
            if (myLocationConfiguration.enableDirection) {
                f3 = myLocationData.direction % 360.0f;
                if (f3 > 180.0f) {
                    f3 -= 360.0f;
                } else if (f3 < -180.0f) {
                    f3 += 360.0f;
                }
            } else {
                f3 = -1.0f;
            }
            jSONObject2.put("direction", (double)f3);
            jSONObject2.put("iconarrownor", (Object)"NormalLocArrow");
            jSONObject2.put("iconarrownorid", 28);
            jSONObject2.put("iconarrowfoc", (Object)"FocusLocArrow");
            jSONObject2.put("iconarrowfocid", 29);
            jSONArray.put((Object)jSONObject2);
            jSONObject.put("data", (Object)jSONArray);
            if (myLocationConfiguration.locationMode == MyLocationConfiguration.LocationMode.COMPASS) {
                jSONObject3.put("ptx", b2.b());
                jSONObject3.put("pty", b2.a());
                jSONObject3.put("radius", 0);
                jSONObject3.put("direction", 0);
                jSONObject3.put("iconarrownor", (Object)"direction_wheel");
                jSONObject3.put("iconarrownorid", 54);
                jSONObject3.put("iconarrowfoc", (Object)"direction_wheel");
                jSONObject3.put("iconarrowfocid", 54);
                jSONArray.put((Object)jSONObject3);
            }
        }
        catch (JSONException jSONException) {
            jSONException.printStackTrace();
        }
        if (myLocationConfiguration.customMarker == null) {
            bundle = null;
        } else {
            ArrayList<BitmapDescriptor> arrayList = new ArrayList<BitmapDescriptor>();
            arrayList.add(myLocationConfiguration.customMarker);
            bundle = new Bundle();
            object = new ArrayList();
            for (BitmapDescriptor bitmapDescriptor : arrayList) {
                ParcelItem parcelItem = new ParcelItem();
                Bundle bundle2 = new Bundle();
                Bitmap bitmap = bitmapDescriptor.a;
                ByteBuffer byteBuffer = ByteBuffer.allocate(bitmap.getWidth() * bitmap.getHeight() * 4);
                bitmap.copyPixelsToBuffer((Buffer)byteBuffer);
                byte[] byArray = byteBuffer.array();
                bundle2.putByteArray("imgdata", byArray);
                bundle2.putInt("imgindex", bitmapDescriptor.hashCode());
                bundle2.putInt("imgH", bitmap.getHeight());
                bundle2.putInt("imgW", bitmap.getWidth());
                parcelItem.setBundle(bundle2);
                ((ArrayList)object).add(parcelItem);
            }
            if (((ArrayList)object).size() > 0) {
                Parcelable[] parcelableArray = new ParcelItem[((ArrayList)object).size()];
                for (int i2 = 0; i2 < ((ArrayList)object).size(); ++i2) {
                    parcelableArray[i2] = (ParcelItem)((ArrayList)object).get(i2);
                }
                bundle.putParcelableArray("icondata", parcelableArray);
            }
        }
        this.e.a(jSONObject.toString(), bundle);
        switch (myLocationConfiguration.locationMode) {
            case COMPASS: {
                MapStatus mapStatus = new MapStatus.Builder().rotate(myLocationData.direction).overlook(-45.0f).target(new LatLng(myLocationData.latitude, myLocationData.longitude)).targetScreen(this.getMapStatus().targetScreen).zoom(this.getMapStatus().zoom).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case FOLLOWING: {
                MapStatus mapStatus = new MapStatus.Builder().target(new LatLng(myLocationData.latitude, myLocationData.longitude)).zoom(this.getMapStatus().zoom).rotate(this.getMapStatus().rotate).overlook(this.getMapStatus().overlook).targetScreen(this.getMapStatus().targetScreen).build();
                object = MapStatusUpdateFactory.newMapStatus(mapStatus);
                this.animateMapStatus((MapStatusUpdate)object);
                break;
            }
            case NORMAL: {
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHeatMap(HeatMap heatMap) {
        if (heatMap == null) {
            return;
        }
        this.v.lock();
        try {
            if (heatMap == this.u) {
                return;
            }
            if (this.u != null) {
                this.u.b();
                this.u.c();
                this.u.a = null;
                this.e.t();
            }
            this.u = heatMap;
            this.u.a = this;
            this.e.h(true);
        }
        finally {
            this.v.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void a(HeatMap heatMap) {
        this.v.lock();
        try {
            if (this.u != null && heatMap == this.u) {
                this.u.b();
                this.u.c();
                this.u.a = null;
                this.e.t();
                this.u = null;
                this.e.h(false);
            }
        }
        finally {
            this.v.unlock();
        }
    }

    void a() {
        this.e.j();
    }

    public final void setBaiduHeatMapEnabled(boolean bl) {
        this.e.b(bl);
    }

    public final boolean isBaiduHeatMapEnabled() {
        return this.e.d();
    }

    public final boolean isSupportBaiduHeatMap() {
        return this.e.e();
    }

    public final void setTrafficEnabled(boolean bl) {
        this.e.c(bl);
    }

    public final boolean isTrafficEnabled() {
        return this.e.c();
    }

    public final void snapshot(SnapshotReadyCallback snapshotReadyCallback) {
        this.s = snapshotReadyCallback;
        this.e.a("anything", (Rect)null);
    }

    public final void snapshotScope(Rect rect, SnapshotReadyCallback snapshotReadyCallback) {
        this.s = snapshotReadyCallback;
        this.e.a("anything", rect);
    }

    public void showInfoWindow(InfoWindow infoWindow) {
        if (infoWindow != null) {
            Object object;
            Object object2;
            this.hideInfoWindow();
            if (infoWindow.b != null) {
                this.y = infoWindow.b;
                this.y.destroyDrawingCache();
                object2 = new MapViewLayoutParams.Builder();
                object = ((MapViewLayoutParams.Builder)object2).layoutMode(MapViewLayoutParams.ELayoutMode.mapMode).position(infoWindow.c).yOffset(infoWindow.e).build();
                this.a.addView(this.y, (ViewGroup.LayoutParams)object);
            }
            this.w = infoWindow;
            object2 = infoWindow.b != null ? BitmapDescriptorFactory.fromView(infoWindow.b) : infoWindow.a;
            object = new MarkerOptions().perspective(false).icon((BitmapDescriptor)object2).position(infoWindow.c).zIndex(Integer.MAX_VALUE).a(infoWindow.e);
            Overlay overlay = ((MarkerOptions)object).a();
            overlay.listener = this.h;
            overlay.o = com.baidu.platform.comapi.map.e.b;
            Bundle bundle = new Bundle();
            overlay.a(bundle);
            this.e.a(bundle);
            this.f.add(overlay);
            this.x = (Marker)overlay;
        }
    }

    public void hideInfoWindow() {
        if (this.w != null) {
            if (this.w.b != null) {
                this.a.removeView(this.y);
                this.y = null;
            }
            this.w = null;
            this.x.remove();
            this.x = null;
        }
    }

    public final void setOnMapStatusChangeListener(OnMapStatusChangeListener onMapStatusChangeListener) {
        this.i = onMapStatusChangeListener;
    }

    public final void setOnMapTouchListener(OnMapTouchListener onMapTouchListener) {
        this.j = onMapTouchListener;
    }

    public final void setOnMapClickListener(OnMapClickListener onMapClickListener) {
        this.k = onMapClickListener;
    }

    public void setOnMapLoadedCallback(OnMapLoadedCallback onMapLoadedCallback) {
        this.l = onMapLoadedCallback;
    }

    public final void setOnMapDoubleClickListener(OnMapDoubleClickListener onMapDoubleClickListener) {
        this.m = onMapDoubleClickListener;
    }

    public final void setOnMapLongClickListener(OnMapLongClickListener onMapLongClickListener) {
        this.n = onMapLongClickListener;
    }

    public final void setOnPolylineClickListener(OnPolylineClickListener onPolylineClickListener) {
        if (onPolylineClickListener != null) {
            this.p.add(onPolylineClickListener);
        }
    }

    public final void setOnMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (onMarkerClickListener != null && !this.o.contains(onMarkerClickListener)) {
            this.o.add(onMarkerClickListener);
        }
    }

    public final void setOnMarkerDragListener(OnMarkerDragListener onMarkerDragListener) {
        this.q = onMarkerDragListener;
    }

    public final void setOnMyLocationClickListener(OnMyLocationClickListener onMyLocationClickListener) {
        this.r = onMyLocationClickListener;
    }

    public final void setOnMapDrawFrameCallback(OnMapDrawFrameCallback onMapDrawFrameCallback) {
        this.t = onMapDrawFrameCallback;
    }

    public final void removeMarkerClickListener(OnMarkerClickListener onMarkerClickListener) {
        if (this.o.contains(onMarkerClickListener)) {
            this.o.remove(onMarkerClickListener);
        }
    }

    static /* synthetic */ List a(BaiduMap baiduMap) {
        return baiduMap.f;
    }

    static /* synthetic */ f b(BaiduMap baiduMap) {
        return baiduMap.e;
    }

    static /* synthetic */ List c(BaiduMap baiduMap) {
        return baiduMap.g;
    }

    static /* synthetic */ View d(BaiduMap baiduMap) {
        return baiduMap.y;
    }

    static /* synthetic */ OnMapStatusChangeListener e(BaiduMap baiduMap) {
        return baiduMap.i;
    }

    static /* synthetic */ OnMapTouchListener f(BaiduMap baiduMap) {
        return baiduMap.j;
    }

    static /* synthetic */ OnMapClickListener g(BaiduMap baiduMap) {
        return baiduMap.k;
    }

    static /* synthetic */ OnMapDoubleClickListener h(BaiduMap baiduMap) {
        return baiduMap.m;
    }

    static /* synthetic */ OnMapLongClickListener i(BaiduMap baiduMap) {
        return baiduMap.n;
    }

    static /* synthetic */ Projection a(BaiduMap baiduMap, Projection projection) {
        baiduMap.c = projection;
        return baiduMap.c;
    }

    static /* synthetic */ boolean a(BaiduMap baiduMap, boolean bl) {
        baiduMap.C = bl;
        return baiduMap.C;
    }

    static /* synthetic */ OnMapLoadedCallback j(BaiduMap baiduMap) {
        return baiduMap.l;
    }

    static /* synthetic */ SnapshotReadyCallback k(BaiduMap baiduMap) {
        return baiduMap.s;
    }

    static /* synthetic */ OnMyLocationClickListener l(BaiduMap baiduMap) {
        return baiduMap.r;
    }

    static /* synthetic */ InfoWindow m(BaiduMap baiduMap) {
        return baiduMap.w;
    }

    static /* synthetic */ Marker n(BaiduMap baiduMap) {
        return baiduMap.x;
    }

    static /* synthetic */ ArrayList o(BaiduMap baiduMap) {
        return baiduMap.o;
    }

    static /* synthetic */ ArrayList p(BaiduMap baiduMap) {
        return baiduMap.p;
    }

    static /* synthetic */ Marker q(BaiduMap baiduMap) {
        return baiduMap.z;
    }

    static /* synthetic */ Projection r(BaiduMap baiduMap) {
        return baiduMap.c;
    }

    static /* synthetic */ OnMarkerDragListener s(BaiduMap baiduMap) {
        return baiduMap.q;
    }

    static /* synthetic */ Marker a(BaiduMap baiduMap, Marker marker) {
        baiduMap.z = marker;
        return baiduMap.z;
    }

    static /* synthetic */ Lock t(BaiduMap baiduMap) {
        return baiduMap.v;
    }

    static /* synthetic */ HeatMap u(BaiduMap baiduMap) {
        return baiduMap.u;
    }

    static /* synthetic */ OnMapDrawFrameCallback v(BaiduMap baiduMap) {
        return baiduMap.t;
    }

    public static interface OnMapDrawFrameCallback {
        public void onMapDrawFrame(GL10 var1, MapStatus var2);
    }

    public static interface SnapshotReadyCallback {
        public void onSnapshotReady(Bitmap var1);
    }

    public static interface OnMyLocationClickListener {
        public boolean onMyLocationClick();
    }

    public static interface OnMarkerDragListener {
        public void onMarkerDrag(Marker var1);

        public void onMarkerDragEnd(Marker var1);

        public void onMarkerDragStart(Marker var1);
    }

    public static interface OnPolylineClickListener {
        public boolean onPolylineClick(Polyline var1);
    }

    public static interface OnMarkerClickListener {
        public boolean onMarkerClick(Marker var1);
    }

    public static interface OnMapLongClickListener {
        public void onMapLongClick(LatLng var1);
    }

    public static interface OnMapDoubleClickListener {
        public void onMapDoubleClick(LatLng var1);
    }

    public static interface OnMapLoadedCallback {
        public void onMapLoaded();
    }

    public static interface OnMapClickListener {
        public void onMapClick(LatLng var1);

        public boolean onMapPoiClick(MapPoi var1);
    }

    public static interface OnMapTouchListener {
        public void onTouch(MotionEvent var1);
    }

    public static interface OnMapStatusChangeListener {
        public void onMapStatusChangeStart(MapStatus var1);

        public void onMapStatusChange(MapStatus var1);

        public void onMapStatusChangeFinish(MapStatus var1);
    }
}

