/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.route.TransitRouteLine;
import java.util.ArrayList;
import java.util.List;

public class TransitRouteOverlay
extends OverlayManager {
    private TransitRouteLine a = null;

    public TransitRouteOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        if (this.a == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList = new ArrayList<OverlayOptions>();
        if (this.a.getAllStep() != null && this.a.getAllStep().size() > 0) {
            for (TransitRouteLine.TransitStep transitStep : this.a.getAllStep()) {
                Bundle bundle = new Bundle();
                bundle.putInt("index", this.a.getAllStep().indexOf(transitStep));
                if (transitStep.getEntrance() != null) {
                    arrayList.add(new MarkerOptions().position(transitStep.getEntrance().getLocation()).anchor(0.5f, 0.5f).zIndex(10).extraInfo(bundle).icon(this.a(transitStep)));
                }
                if (this.a.getAllStep().indexOf(transitStep) != this.a.getAllStep().size() - 1 || transitStep.getExit() == null) continue;
                arrayList.add(new MarkerOptions().position(transitStep.getExit().getLocation()).anchor(0.5f, 0.5f).zIndex(10).icon(this.a(transitStep)));
            }
        }
        if (this.a.getStarting() != null) {
            arrayList.add(new MarkerOptions().position(this.a.getStarting().getLocation()).icon(this.getStartMarker() != null ? this.getStartMarker() : BitmapDescriptorFactory.fromAssetWithDpi("Icon_start.png")).zIndex(10));
        }
        if (this.a.getTerminal() != null) {
            arrayList.add(new MarkerOptions().position(this.a.getTerminal().getLocation()).icon(this.getTerminalMarker() != null ? this.getTerminalMarker() : BitmapDescriptorFactory.fromAssetWithDpi("Icon_end.png")).zIndex(10));
        }
        if (this.a.getAllStep() != null && this.a.getAllStep().size() > 0) {
            for (TransitRouteLine.TransitStep transitStep : this.a.getAllStep()) {
                if (transitStep.getWayPoints() == null) continue;
                int n2 = 0;
                n2 = transitStep.getStepType() != TransitRouteLine.TransitStep.TransitRouteStepType.WAKLING ? (this.getLineColor() != 0 ? this.getLineColor() : Color.argb((int)178, (int)0, (int)78, (int)255)) : (this.getLineColor() != 0 ? this.getLineColor() : Color.argb((int)178, (int)88, (int)208, (int)0));
                arrayList.add(new PolylineOptions().points(transitStep.getWayPoints()).width(10).color(n2).zIndex(0));
            }
        }
        return arrayList;
    }

    private BitmapDescriptor a(TransitRouteLine.TransitStep transitStep) {
        switch (transitStep.getStepType()) {
            case BUSLINE: {
                return BitmapDescriptorFactory.fromAssetWithDpi("Icon_bus_station.png");
            }
            case SUBWAY: {
                return BitmapDescriptorFactory.fromAssetWithDpi("Icon_subway_station.png");
            }
            case WAKLING: {
                return BitmapDescriptorFactory.fromAssetWithDpi("Icon_walk_route.png");
            }
        }
        return null;
    }

    public void setData(TransitRouteLine transitRouteLine) {
        this.a = transitRouteLine;
    }

    public BitmapDescriptor getStartMarker() {
        return null;
    }

    public BitmapDescriptor getTerminalMarker() {
        return null;
    }

    public int getLineColor() {
        return 0;
    }

    public boolean onRouteNodeClick(int n2) {
        if (this.a.getAllStep() != null && this.a.getAllStep().get(n2) != null) {
            Toast.makeText((Context)com.baidu.mapapi.a.a().e(), (CharSequence)((TransitRouteLine.TransitStep)this.a.getAllStep().get(n2)).getInstructions(), (int)1).show();
        }
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        for (Overlay overlay : this.c) {
            if (!(overlay instanceof Marker) || !overlay.equals(marker) || marker.getExtraInfo() == null) continue;
            this.onRouteNodeClick(marker.getExtraInfo().getInt("index"));
        }
        return true;
    }

    @Override
    public boolean onPolylineClick(Polyline polyline) {
        return false;
    }
}

