/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.mapapi.overlayutil;

import android.content.Context;
import android.graphics.Color;
import android.os.Bundle;
import android.widget.Toast;
import com.baidu.mapapi.a;
import com.baidu.mapapi.map.BaiduMap;
import com.baidu.mapapi.map.BitmapDescriptor;
import com.baidu.mapapi.map.BitmapDescriptorFactory;
import com.baidu.mapapi.map.Marker;
import com.baidu.mapapi.map.MarkerOptions;
import com.baidu.mapapi.map.Overlay;
import com.baidu.mapapi.map.OverlayOptions;
import com.baidu.mapapi.map.Polyline;
import com.baidu.mapapi.map.PolylineOptions;
import com.baidu.mapapi.model.LatLng;
import com.baidu.mapapi.overlayutil.OverlayManager;
import com.baidu.mapapi.search.route.WalkingRouteLine;
import java.util.ArrayList;
import java.util.List;

public class WalkingRouteOverlay
extends OverlayManager {
    private WalkingRouteLine a = null;

    public WalkingRouteOverlay(BaiduMap baiduMap) {
        super(baiduMap);
    }

    public void setData(WalkingRouteLine walkingRouteLine) {
        this.a = walkingRouteLine;
    }

    @Override
    public final List<OverlayOptions> getOverlayOptions() {
        if (this.a == null) {
            return null;
        }
        ArrayList<OverlayOptions> arrayList = new ArrayList<OverlayOptions>();
        if (this.a.getAllStep() != null && this.a.getAllStep().size() > 0) {
            for (WalkingRouteLine.WalkingStep object : this.a.getAllStep()) {
                Bundle bundle = new Bundle();
                bundle.putInt("index", this.a.getAllStep().indexOf(object));
                if (object.getEntrance() != null) {
                    arrayList.add(new MarkerOptions().position(object.getEntrance().getLocation()).rotate(360 - object.getDirection()).zIndex(10).anchor(0.5f, 0.5f).extraInfo(bundle).icon(BitmapDescriptorFactory.fromAssetWithDpi("Icon_line_node.png")));
                }
                if (this.a.getAllStep().indexOf(object) != this.a.getAllStep().size() - 1 || object.getExit() == null) continue;
                arrayList.add(new MarkerOptions().position(object.getExit().getLocation()).anchor(0.5f, 0.5f).zIndex(10).icon(BitmapDescriptorFactory.fromAssetWithDpi("Icon_line_node.png")));
            }
        }
        if (this.a.getStarting() != null) {
            arrayList.add(new MarkerOptions().position(this.a.getStarting().getLocation()).icon(this.getStartMarker() != null ? this.getStartMarker() : BitmapDescriptorFactory.fromAssetWithDpi("Icon_start.png")).zIndex(10));
        }
        if (this.a.getTerminal() != null) {
            arrayList.add(new MarkerOptions().position(this.a.getTerminal().getLocation()).icon(this.getTerminalMarker() != null ? this.getTerminalMarker() : BitmapDescriptorFactory.fromAssetWithDpi("Icon_end.png")).zIndex(10));
        }
        if (this.a.getAllStep() != null && this.a.getAllStep().size() > 0) {
            Object object = null;
            for (WalkingRouteLine.WalkingStep walkingStep : this.a.getAllStep()) {
                List<LatLng> list = walkingStep.getWayPoints();
                if (list == null) continue;
                ArrayList<LatLng> arrayList2 = new ArrayList<LatLng>();
                if (object != null) {
                    arrayList2.add((LatLng)object);
                }
                arrayList2.addAll(list);
                arrayList.add(new PolylineOptions().points(arrayList2).width(10).color(this.getLineColor() != 0 ? this.getLineColor() : Color.argb((int)178, (int)0, (int)78, (int)255)).zIndex(0));
                object = list.get(list.size() - 1);
            }
        }
        return arrayList;
    }

    public BitmapDescriptor getStartMarker() {
        return null;
    }

    public int getLineColor() {
        return 0;
    }

    public BitmapDescriptor getTerminalMarker() {
        return null;
    }

    public boolean onRouteNodeClick(int n2) {
        if (this.a.getAllStep() != null && this.a.getAllStep().get(n2) != null) {
            Toast.makeText((Context)com.baidu.mapapi.a.a().e(), (CharSequence)this.a.getAllStep().get(n2).getInstructions(), (int)1).show();
        }
        return false;
    }

    @Override
    public final boolean onMarkerClick(Marker marker) {
        for (Overlay overlay : this.c) {
            if (!(overlay instanceof Marker) || !overlay.equals(marker) || marker.getExtraInfo() == null) continue;
            this.onRouteNodeClick(marker.getExtraInfo().getInt("index"));
        }
        return true;
    }

    @Override
    public boolean onPolylineClick(Polyline polyline) {
        return false;
    }
}

