/*
 * Decompiled with CFR 0.152.
 */
package com.baidu.location;

import android.os.Build;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import com.baidu.location.Address;
import com.baidu.location.Jni;
import com.baidu.location.Poi;
import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.json.JSONObject;

public final class BDLocation
implements Parcelable {
    public static final int TypeNone = 0;
    public static final int TypeGpsLocation = 61;
    public static final int TypeCriteriaException = 62;
    public static final int TypeNetWorkException = 63;
    public static final int TypeOffLineLocation = 66;
    public static final int TypeOffLineLocationFail = 67;
    public static final int TypeOffLineLocationNetworkFail = 68;
    public static final int TypeNetWorkLocation = 161;
    public static final int TypeCacheLocation = 65;
    public static final int TypeServerError = 167;
    public static final int LOCATION_WHERE_UNKNOW = 2;
    public static final int LOCATION_WHERE_IN_CN = 1;
    public static final int LOCATION_WHERE_OUT_CN = 0;
    public static final int OPERATORS_TYPE_UNKONW = 0;
    public static final int OPERATORS_TYPE_MOBILE = 1;
    public static final int OPERATORS_TYPE_UNICOM = 2;
    public static final int OPERATORS_TYPE_TELECOMU = 3;
    public static final String BDLOCATION_GCJ02_TO_BD09 = "bd09";
    public static final String BDLOCATION_GCJ02_TO_BD09LL = "bd09ll";
    public static final String BDLOCATION_BD09_TO_GCJ02 = "bd092gcj";
    public static final String BDLOCATION_BD09LL_TO_GCJ02 = "bd09ll2gcj";
    private int mLocType;
    private String mTime;
    private double mLatitude;
    private double mLongitude;
    private boolean mHasAltitude;
    private double mAltitude;
    private boolean mHasSpeed;
    private float mSpeed;
    private boolean mHasRadius;
    private float mRadius;
    private boolean mHasSateNumber;
    private int mSatelliteNumber;
    private float mDerect;
    private String mCoorType;
    private boolean mHasAddr;
    private String mAddrStr;
    private String mSemaAptag;
    private String mSemaPoiRegion;
    private String mSemaRegular;
    private boolean isCellChangeFlag;
    private Address mAddr;
    private String floor;
    private String buildingid;
    private String mBuildingName;
    private boolean indoorLocMode;
    private int mParkState;
    private int mLocationWhere;
    private String netWorkLocationType;
    private int mOperators;
    private String mCu;
    private List<Poi> mPoiList;
    public static final Parcelable.Creator<BDLocation> CREATOR = new Parcelable.Creator<BDLocation>(){

        public BDLocation createFromParcel(Parcel parcel) {
            return new BDLocation(parcel);
        }

        public BDLocation[] newArray(int n) {
            return new BDLocation[n];
        }
    };

    public BDLocation() {
        this.mLocType = 0;
        this.mTime = null;
        this.mLatitude = Double.MIN_VALUE;
        this.mLongitude = Double.MIN_VALUE;
        this.mHasAltitude = false;
        this.mAltitude = Double.MIN_VALUE;
        this.mHasSpeed = false;
        this.mSpeed = 0.0f;
        this.mHasRadius = false;
        this.mRadius = 0.0f;
        this.mHasSateNumber = false;
        this.mSatelliteNumber = -1;
        this.mDerect = -1.0f;
        this.mCoorType = null;
        this.mHasAddr = false;
        this.mAddrStr = null;
        this.mSemaAptag = null;
        this.mSemaPoiRegion = null;
        this.mSemaRegular = null;
        this.isCellChangeFlag = false;
        this.mAddr = new Address.Builder().build();
        this.floor = null;
        this.buildingid = null;
        this.mBuildingName = null;
        this.indoorLocMode = false;
        this.mParkState = 0;
        this.mLocationWhere = 1;
        this.netWorkLocationType = null;
        this.mCu = "";
        this.mPoiList = null;
    }

    public BDLocation(BDLocation bDLocation) {
        this.mLocType = 0;
        this.mTime = null;
        this.mLatitude = Double.MIN_VALUE;
        this.mLongitude = Double.MIN_VALUE;
        this.mHasAltitude = false;
        this.mAltitude = Double.MIN_VALUE;
        this.mHasSpeed = false;
        this.mSpeed = 0.0f;
        this.mHasRadius = false;
        this.mRadius = 0.0f;
        this.mHasSateNumber = false;
        this.mSatelliteNumber = -1;
        this.mDerect = -1.0f;
        this.mCoorType = null;
        this.mHasAddr = false;
        this.mAddrStr = null;
        this.mSemaAptag = null;
        this.mSemaPoiRegion = null;
        this.mSemaRegular = null;
        this.isCellChangeFlag = false;
        this.mAddr = new Address.Builder().build();
        this.floor = null;
        this.buildingid = null;
        this.mBuildingName = null;
        this.indoorLocMode = false;
        this.mParkState = 0;
        this.mLocationWhere = 1;
        this.netWorkLocationType = null;
        this.mCu = "";
        this.mPoiList = null;
        this.mLocType = bDLocation.mLocType;
        this.mTime = bDLocation.mTime;
        this.mLatitude = bDLocation.mLatitude;
        this.mLongitude = bDLocation.mLongitude;
        this.mHasAltitude = bDLocation.mHasAltitude;
        this.mAltitude = bDLocation.mAltitude;
        this.mHasSpeed = bDLocation.mHasSpeed;
        this.mSpeed = bDLocation.mSpeed;
        this.mHasRadius = bDLocation.mHasRadius;
        this.mRadius = bDLocation.mRadius;
        this.mHasSateNumber = bDLocation.mHasSateNumber;
        this.mSatelliteNumber = bDLocation.mSatelliteNumber;
        this.mDerect = bDLocation.mDerect;
        this.mCoorType = bDLocation.mCoorType;
        this.mHasAddr = bDLocation.mHasAddr;
        this.mAddrStr = bDLocation.mAddrStr;
        this.isCellChangeFlag = bDLocation.isCellChangeFlag;
        this.mAddr = new Address.Builder().country(bDLocation.mAddr.country).countryCode(bDLocation.mAddr.countryCode).province(bDLocation.mAddr.province).city(bDLocation.mAddr.city).cityCode(bDLocation.mAddr.cityCode).district(bDLocation.mAddr.district).street(bDLocation.mAddr.street).streetNumber(bDLocation.mAddr.streetNumber).build();
        this.floor = bDLocation.floor;
        this.buildingid = bDLocation.buildingid;
        this.mBuildingName = bDLocation.mBuildingName;
        this.mLocationWhere = bDLocation.mLocationWhere;
        this.mParkState = bDLocation.mParkState;
        this.indoorLocMode = bDLocation.indoorLocMode;
        this.netWorkLocationType = bDLocation.netWorkLocationType;
        this.mOperators = bDLocation.mOperators;
        this.mCu = bDLocation.mCu;
        this.mSemaAptag = bDLocation.mSemaAptag;
        this.mSemaPoiRegion = bDLocation.mSemaPoiRegion;
        this.mSemaRegular = bDLocation.mSemaRegular;
        if (bDLocation.mPoiList == null) {
            this.mPoiList = null;
        } else {
            ArrayList<Poi> arrayList = new ArrayList<Poi>();
            for (int i2 = 0; i2 < bDLocation.mPoiList.size(); ++i2) {
                Poi poi = bDLocation.mPoiList.get(i2);
                arrayList.add(new Poi(poi.getId(), poi.getName(), poi.getRank()));
            }
            this.mPoiList = arrayList;
        }
    }

    public BDLocation(String string) {
        block48: {
            this.mLocType = 0;
            this.mTime = null;
            this.mLatitude = Double.MIN_VALUE;
            this.mLongitude = Double.MIN_VALUE;
            this.mHasAltitude = false;
            this.mAltitude = Double.MIN_VALUE;
            this.mHasSpeed = false;
            this.mSpeed = 0.0f;
            this.mHasRadius = false;
            this.mRadius = 0.0f;
            this.mHasSateNumber = false;
            this.mSatelliteNumber = -1;
            this.mDerect = -1.0f;
            this.mCoorType = null;
            this.mHasAddr = false;
            this.mAddrStr = null;
            this.mSemaAptag = null;
            this.mSemaPoiRegion = null;
            this.mSemaRegular = null;
            this.isCellChangeFlag = false;
            this.mAddr = new Address.Builder().build();
            this.floor = null;
            this.buildingid = null;
            this.mBuildingName = null;
            this.indoorLocMode = false;
            this.mParkState = 0;
            this.mLocationWhere = 1;
            this.netWorkLocationType = null;
            this.mCu = "";
            this.mPoiList = null;
            if (string == null || string.equals("")) {
                return;
            }
            try {
                JSONObject jSONObject = new JSONObject(string);
                JSONObject jSONObject2 = jSONObject.getJSONObject("result");
                int n = Integer.parseInt(jSONObject2.getString("error"));
                this.setLocType(n);
                this.setTime(jSONObject2.getString("time"));
                if (n == 61) {
                    JSONObject jSONObject3 = jSONObject.getJSONObject("content");
                    JSONObject jSONObject4 = jSONObject3.getJSONObject("point");
                    this.setLatitude(Double.parseDouble(jSONObject4.getString("y")));
                    this.setLongitude(Double.parseDouble(jSONObject4.getString("x")));
                    this.setRadius(Float.parseFloat(jSONObject3.getString("radius")));
                    this.setSpeed(Float.parseFloat(jSONObject3.getString("s")));
                    this.setDirection(Float.parseFloat(jSONObject3.getString("d")));
                    this.setSatelliteNumber(Integer.parseInt(jSONObject3.getString("n")));
                    if (jSONObject3.has("h")) {
                        try {
                            this.setAltitude(jSONObject3.getDouble("h"));
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    try {
                        if (jSONObject3.has("in_cn")) {
                            int n2 = Integer.parseInt(jSONObject3.getString("in_cn"));
                            this.setLocationWhere(n2);
                        } else {
                            this.setLocationWhere(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mLocationWhere == 0) {
                        this.setCoorType("wgs84");
                    } else {
                        this.setCoorType("gcj02");
                    }
                    break block48;
                }
                if (n == 161) {
                    Object object;
                    String string2;
                    String string3;
                    JSONObject jSONObject5;
                    Object object2;
                    Object object3;
                    JSONObject jSONObject6 = jSONObject.getJSONObject("content");
                    JSONObject jSONObject7 = jSONObject6.getJSONObject("point");
                    this.setLatitude(Double.parseDouble(jSONObject7.getString("y")));
                    this.setLongitude(Double.parseDouble(jSONObject7.getString("x")));
                    this.setRadius(Float.parseFloat(jSONObject6.getString("radius")));
                    if (jSONObject6.has("sema")) {
                        object3 = jSONObject6.getJSONObject("sema");
                        if (object3.has("aptag")) {
                            object2 = object3.getString("aptag");
                            this.mSemaAptag = !TextUtils.isEmpty((CharSequence)object2) ? object2 : "";
                        }
                        if (object3.has("aptagd")) {
                            object2 = object3.getJSONObject("aptagd").getJSONArray("pois");
                            ArrayList<Poi> arrayList = new ArrayList<Poi>();
                            for (int i2 = 0; i2 < object2.length(); ++i2) {
                                jSONObject5 = object2.getJSONObject(i2);
                                string3 = jSONObject5.getString("pname");
                                string2 = jSONObject5.getString("pid");
                                double d2 = jSONObject5.getDouble("pr");
                                object = new Poi(string2, string3, d2);
                                arrayList.add((Poi)object);
                            }
                            this.mPoiList = arrayList;
                        }
                        if (object3.has("poiregion") && !TextUtils.isEmpty((CharSequence)(object2 = object3.getString("poiregion")))) {
                            this.mSemaPoiRegion = object2;
                        }
                        if (object3.has("regular") && !TextUtils.isEmpty((CharSequence)(object2 = object3.getString("regular")))) {
                            this.mSemaRegular = object2;
                        }
                    }
                    if (jSONObject6.has("addr")) {
                        object3 = jSONObject6.getString("addr");
                        object2 = ((String)object3).split(",");
                        int n3 = ((String[])object2).length;
                        JSONArray jSONArray = null;
                        jSONObject5 = null;
                        string3 = null;
                        string2 = null;
                        JSONArray jSONArray2 = null;
                        JSONArray jSONArray3 = null;
                        object = null;
                        JSONArray jSONArray4 = null;
                        if (n3 > 0) {
                            string3 = object2[0];
                        }
                        if (n3 > 1) {
                            string2 = object2[1];
                        }
                        if (n3 > 2) {
                            jSONArray3 = object2[2];
                        }
                        if (n3 > 3) {
                            object = object2[3];
                        }
                        if (n3 > 4) {
                            jSONArray4 = object2[4];
                        }
                        if (n3 > 5) {
                            jSONArray2 = object2[5];
                        }
                        if (n3 > 6) {
                            jSONArray = object2[6];
                        }
                        if (n3 > 7) {
                            jSONObject5 = object2[7];
                        }
                        this.mAddr = new Address.Builder().country((String)jSONArray).countryCode((String)jSONObject5).province(string3).city(string2).cityCode((String)jSONArray2).district((String)jSONArray3).street((String)object).streetNumber((String)jSONArray4).build();
                        this.mHasAddr = true;
                    } else {
                        this.mHasAddr = false;
                        this.setAddrStr(null);
                    }
                    if (jSONObject6.has("floor")) {
                        this.floor = jSONObject6.getString("floor");
                        if (TextUtils.isEmpty((CharSequence)this.floor)) {
                            this.floor = null;
                        }
                    }
                    if (jSONObject6.has("loctp")) {
                        this.netWorkLocationType = jSONObject6.getString("loctp");
                        if (TextUtils.isEmpty((CharSequence)this.netWorkLocationType)) {
                            this.netWorkLocationType = null;
                        }
                    }
                    if (jSONObject6.has("bldgid")) {
                        this.buildingid = jSONObject6.getString("bldgid");
                        if (TextUtils.isEmpty((CharSequence)this.buildingid)) {
                            this.buildingid = null;
                        }
                    }
                    if (jSONObject6.has("bldg")) {
                        this.mBuildingName = jSONObject6.getString("bldg");
                        if (TextUtils.isEmpty((CharSequence)this.mBuildingName)) {
                            this.mBuildingName = null;
                        }
                    }
                    if (jSONObject6.has("ibav")) {
                        object3 = jSONObject6.getString("ibav");
                        this.mParkState = TextUtils.isEmpty((CharSequence)object3) ? 0 : (((String)object3).equals("0") ? 0 : Integer.valueOf((String)object3));
                    }
                    try {
                        if (jSONObject6.has("in_cn")) {
                            int n4 = Integer.parseInt(jSONObject6.getString("in_cn"));
                            this.setLocationWhere(n4);
                        } else {
                            this.setLocationWhere(1);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (this.mLocationWhere == 0) {
                        this.setCoorType("wgs84");
                    } else {
                        this.setCoorType("gcj02");
                    }
                    break block48;
                }
                if (n == 66 || n == 68) {
                    JSONObject jSONObject8 = jSONObject.getJSONObject("content");
                    JSONObject jSONObject9 = jSONObject8.getJSONObject("point");
                    this.setLatitude(Double.parseDouble(jSONObject9.getString("y")));
                    this.setLongitude(Double.parseDouble(jSONObject9.getString("x")));
                    this.setRadius(Float.parseFloat(jSONObject8.getString("radius")));
                    this.setCellChangeFlag(Boolean.parseBoolean(jSONObject8.getString("isCellChanged")));
                    this.setCoorType("gcj02");
                } else if (n == 167) {
                    this.setLocationWhere(2);
                }
            }
            catch (Exception exception) {
                exception.printStackTrace();
                this.mLocType = 0;
                this.mHasAddr = false;
            }
        }
    }

    public List<Poi> getPoiList() {
        return this.mPoiList;
    }

    public void setPoiList(List<Poi> list) {
        this.mPoiList = list;
    }

    private void setCellChangeFlag(Boolean bl) {
        this.isCellChangeFlag = bl;
    }

    public boolean isCellChangeFlag() {
        return this.isCellChangeFlag;
    }

    public String getTime() {
        return this.mTime;
    }

    public void setTime(String string) {
        this.mTime = string;
    }

    public double getLatitude() {
        return this.mLatitude;
    }

    public void setLatitude(double d2) {
        this.mLatitude = d2;
    }

    public double getLongitude() {
        return this.mLongitude;
    }

    public void setLongitude(double d2) {
        this.mLongitude = d2;
    }

    public double getAltitude() {
        return this.mAltitude;
    }

    public void setAltitude(double d2) {
        this.mAltitude = d2;
        this.mHasAltitude = true;
    }

    public float getSpeed() {
        return this.mSpeed;
    }

    public void setSpeed(float f2) {
        this.mSpeed = f2;
        this.mHasSpeed = true;
    }

    public float getRadius() {
        return this.mRadius;
    }

    public void setRadius(float f2) {
        this.mRadius = f2;
        this.mHasRadius = true;
    }

    public String getCoorType() {
        return this.mCoorType;
    }

    public void setCoorType(String string) {
        this.mCoorType = string;
    }

    public void setAddrStr(String string) {
        this.mAddrStr = string;
        this.mHasAddr = string != null;
    }

    public boolean hasAltitude() {
        return this.mHasAltitude;
    }

    public boolean hasSpeed() {
        return this.mHasSpeed;
    }

    public boolean hasRadius() {
        return this.mHasRadius;
    }

    public void setLocType(int n) {
        this.mLocType = n;
    }

    public int getLocType() {
        return this.mLocType;
    }

    public void setSatelliteNumber(int n) {
        this.mSatelliteNumber = n;
    }

    public int getSatelliteNumber() {
        this.mHasSateNumber = true;
        return this.mSatelliteNumber;
    }

    public float getDerect() {
        return this.mDerect;
    }

    public float getDirection() {
        return this.mDerect;
    }

    public void setDirection(float f2) {
        this.mDerect = f2;
    }

    public boolean hasSateNumber() {
        return this.mHasSateNumber;
    }

    public boolean hasAddr() {
        return this.mHasAddr;
    }

    public Address getAddress() {
        return this.mAddr;
    }

    public void setAddr(Address address) {
        if (address != null) {
            this.mAddr = address;
            this.mHasAddr = true;
        }
    }

    public String getAddrStr() {
        return this.mAddr.address;
    }

    public String getProvince() {
        return this.mAddr.province;
    }

    public String getCity() {
        return this.mAddr.city;
    }

    public String getCityCode() {
        return this.mAddr.cityCode;
    }

    public String getCountry() {
        return this.mAddr.country;
    }

    public String getCountryCode() {
        return this.mAddr.countryCode;
    }

    public String getDistrict() {
        return this.mAddr.district;
    }

    public String getStreet() {
        return this.mAddr.street;
    }

    public String getStreetNumber() {
        return this.mAddr.streetNumber;
    }

    public String getLocationDescribe() {
        return this.mSemaAptag;
    }

    public void setLocationDescribe(String string) {
        this.mSemaAptag = string;
    }

    public String getFloor() {
        return this.floor;
    }

    public void setFloor(String string) {
        this.floor = string;
    }

    public String getBuildingID() {
        return this.buildingid;
    }

    public void setBuildingID(String string) {
        this.buildingid = string;
    }

    public String getBuildingName() {
        return this.mBuildingName;
    }

    public void setBuildingName(String string) {
        this.mBuildingName = string;
    }

    public int isParkAvailable() {
        return this.mParkState;
    }

    public void setParkAvailable(int n) {
        this.mParkState = n;
    }

    public boolean isIndoorLocMode() {
        return this.indoorLocMode;
    }

    public void setIndoorLocMode(boolean bl) {
        this.indoorLocMode = bl;
    }

    public int getLocationWhere() {
        return this.mLocationWhere;
    }

    public void setLocationWhere(int n) {
        this.mLocationWhere = n;
    }

    public String getSemaAptag() {
        return this.mSemaAptag;
    }

    private String getSemaPoiRegion() {
        return this.mSemaPoiRegion;
    }

    private String getSemaRegular() {
        return this.mSemaRegular;
    }

    public String getNetworkLocationType() {
        return this.netWorkLocationType;
    }

    public void setNetworkLocationType(String string) {
        this.netWorkLocationType = string;
    }

    public int getOperators() {
        return this.mOperators;
    }

    public void setOperators(int n) {
        this.mOperators = n;
    }

    public int describeContents() {
        return 0;
    }

    private BDLocation(Parcel parcel) {
        this.mLocType = 0;
        this.mTime = null;
        this.mLatitude = Double.MIN_VALUE;
        this.mLongitude = Double.MIN_VALUE;
        this.mHasAltitude = false;
        this.mAltitude = Double.MIN_VALUE;
        this.mHasSpeed = false;
        this.mSpeed = 0.0f;
        this.mHasRadius = false;
        this.mRadius = 0.0f;
        this.mHasSateNumber = false;
        this.mSatelliteNumber = -1;
        this.mDerect = -1.0f;
        this.mCoorType = null;
        this.mHasAddr = false;
        this.mAddrStr = null;
        this.mSemaAptag = null;
        this.mSemaPoiRegion = null;
        this.mSemaRegular = null;
        this.isCellChangeFlag = false;
        this.mAddr = new Address.Builder().build();
        this.floor = null;
        this.buildingid = null;
        this.mBuildingName = null;
        this.indoorLocMode = false;
        this.mParkState = 0;
        this.mLocationWhere = 1;
        this.netWorkLocationType = null;
        this.mCu = "";
        this.mPoiList = null;
        this.mLocType = parcel.readInt();
        this.mTime = parcel.readString();
        this.mLatitude = parcel.readDouble();
        this.mLongitude = parcel.readDouble();
        this.mAltitude = parcel.readDouble();
        this.mSpeed = parcel.readFloat();
        this.mRadius = parcel.readFloat();
        this.mSatelliteNumber = parcel.readInt();
        this.mDerect = parcel.readFloat();
        this.floor = parcel.readString();
        this.mParkState = parcel.readInt();
        this.buildingid = parcel.readString();
        this.mBuildingName = parcel.readString();
        this.netWorkLocationType = parcel.readString();
        String string = parcel.readString();
        String string2 = parcel.readString();
        String string3 = parcel.readString();
        String string4 = parcel.readString();
        String string5 = parcel.readString();
        String string6 = parcel.readString();
        String string7 = parcel.readString();
        String string8 = parcel.readString();
        String string9 = parcel.readString();
        this.mAddr = new Address.Builder().country(string8).countryCode(string9).province(string).city(string2).cityCode(string6).district(string3).street(string4).streetNumber(string5).build();
        boolean[] blArray = new boolean[7];
        this.mOperators = parcel.readInt();
        this.mCu = parcel.readString();
        this.mSemaAptag = parcel.readString();
        this.mSemaPoiRegion = parcel.readString();
        this.mSemaRegular = parcel.readString();
        this.mLocationWhere = parcel.readInt();
        try {
            parcel.readBooleanArray(blArray);
            this.mHasAltitude = blArray[0];
            this.mHasSpeed = blArray[1];
            this.mHasRadius = blArray[2];
            this.mHasSateNumber = blArray[3];
            this.mHasAddr = blArray[4];
            this.isCellChangeFlag = blArray[5];
            this.indoorLocMode = blArray[6];
        }
        catch (Exception exception) {
            // empty catch block
        }
        ArrayList<Poi> arrayList = new ArrayList<Poi>();
        parcel.readList(arrayList, Poi.class.getClassLoader());
        this.mPoiList = arrayList.size() == 0 ? null : arrayList;
    }

    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mLocType);
        parcel.writeString(this.mTime);
        parcel.writeDouble(this.mLatitude);
        parcel.writeDouble(this.mLongitude);
        parcel.writeDouble(this.mAltitude);
        parcel.writeFloat(this.mSpeed);
        parcel.writeFloat(this.mRadius);
        parcel.writeInt(this.mSatelliteNumber);
        parcel.writeFloat(this.mDerect);
        parcel.writeString(this.floor);
        parcel.writeInt(this.mParkState);
        parcel.writeString(this.buildingid);
        parcel.writeString(this.mBuildingName);
        parcel.writeString(this.netWorkLocationType);
        parcel.writeString(this.mAddr.province);
        parcel.writeString(this.mAddr.city);
        parcel.writeString(this.mAddr.district);
        parcel.writeString(this.mAddr.street);
        parcel.writeString(this.mAddr.streetNumber);
        parcel.writeString(this.mAddr.cityCode);
        parcel.writeString(this.mAddr.address);
        parcel.writeString(this.mAddr.country);
        parcel.writeString(this.mAddr.countryCode);
        parcel.writeInt(this.mOperators);
        parcel.writeString(this.mCu);
        parcel.writeString(this.mSemaAptag);
        parcel.writeString(this.mSemaPoiRegion);
        parcel.writeString(this.mSemaRegular);
        parcel.writeInt(this.mLocationWhere);
        boolean[] blArray = new boolean[]{this.mHasAltitude, this.mHasSpeed, this.mHasRadius, this.mHasSateNumber, this.mHasAddr, this.isCellChangeFlag, this.indoorLocMode};
        parcel.writeBooleanArray(blArray);
        parcel.writeList(this.mPoiList);
    }

    private String getCuid() {
        return this.mCu;
    }

    public String getAdUrl(String string) {
        String string2 = null;
        string2 = "http://lba.baidu.com/";
        String string3 = String.valueOf(this.mLatitude);
        String string4 = String.valueOf(this.mLongitude);
        String string5 = string;
        String string6 = this.getCuid();
        String string7 = BDLocation.getModel();
        String string8 = Jni.Encrypt("ak=" + string5 + "&" + "lat=" + string3 + "&" + "lng=" + string4 + "&" + "cu=" + string6 + "&" + "mb=" + string7);
        return string2 + "?a=" + string8;
    }

    private static String getModel() {
        return Build.MODEL;
    }

    public void internalSet(int n, String string) {
        if (string == null) {
            return;
        }
        if (n == 0) {
            this.mCu = string;
        }
    }
}

