package com.xml.parsertex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;

import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

import com.xml.category.River;

public class DomReader {
	public static List<River> ReadRiverXml(InputStream in){
		List<River> rivers=new ArrayList<River>();
		DocumentBuilderFactory factory=null;
		DocumentBuilder builder=null;
		Document document=null;

		
		//首先找到xml文件
		factory=DocumentBuilderFactory.newInstance();
		
		try {
			//找到xml,并加载文档
			builder=factory.newDocumentBuilder();
			document=builder.parse(in);
			
			//找到根element
			Element root=document.getDocumentElement();
			NodeList nodes=root.getElementsByTagName("river");
			//遍历根结点所有子节点，rivers下所有river
			River river=null;
			for(int i=0;i<nodes.getLength();i++){
				river=new River();
				//获取river元素结点
				Element riverElement=(Element) nodes.item(i);
				//获取river中的name属性
				river.setName(new String(riverElement.getAttribute("name")));
				river.setLength(new Integer(riverElement.getAttribute("length")));				
				//获取river结点下的所有子节点
				NodeList childNodes=riverElement.getChildNodes();
				for(int j=0;j<childNodes.getLength();j++){
					Node node=childNodes.item(j);
					if(node.getNodeType()==Node.ELEMENT_NODE){
						if("introduction".equals(node.getNodeName())){
							river.setIntroduction(node.getFirstChild().getNodeValue());
						}else if("imageurl".equals(node.getNodeName())){
							river.setImageurl(node.getFirstChild().getNodeValue());
						}
					}
				}
				rivers.add(river);
			}
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return rivers;
		
	}

}

