package com.xml.parsertex;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;

import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

import android.util.Xml;

import com.xml.category.River;

public class PullReader {
	public static List<River> readRiverXml(InputStream in){
		List<River> rivers=null;
		River river=null;
		XmlPullParser parser=Xml.newPullParser();
		
		try {
			parser.setInput(in, "UTF-8");
			int eventType=parser.getEventType();//获取标签类型
			while(eventType!=XmlPullParser.END_DOCUMENT){
				switch(eventType){
				case XmlPullParser.START_DOCUMENT://开始文档
					rivers=new ArrayList<River>();
					break;
				case XmlPullParser.START_TAG://开始元素
					String name=parser.getName();//获取标签名称
					if(name.equalsIgnoreCase("river")){
						river=new River();
						river.setName(parser.getAttributeValue(null, "name"));
						river.setLength(new Integer(parser.getAttributeValue(null, "length")));//new相当于强制类型转换
					}
					if(river!=null){
						if(name.equalsIgnoreCase("introduction")){
							river.setIntroduction(parser.nextText());// 如果后面是Text节点,即返回它的值
						}else if(name.equalsIgnoreCase("imageurl")){
							river.setImageurl(parser.nextText());
						}
					}
					break;
				case XmlPullParser.END_TAG://结束元素
					if(parser.getName().equalsIgnoreCase("river")&&river!=null){
						rivers.add(river);
						river=null;
					}
					break;
				
				}
				eventType=parser.next();//标签下移并返回标签类型
			}
			in.close();
			return rivers;
			
			
		} catch (XmlPullParserException e) {
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
		
	}

}
