package com.xml.parsertex;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;

import javax.xml.XMLConstants;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;

import org.xml.sax.SAXException;

import com.xml.category.River;
import com.xml.handler.ContentHandlerXml;

public class SAXReader {
	public static List<River> ReadRiverXml(InputStream in){
		SAXParserFactory factory=SAXParserFactory.newInstance();
		try {
			SAXParser parser=factory.newSAXParser();//创建一个解析器
			ContentHandlerXml handler=new ContentHandlerXml();//设置处理器
			parser.parse(in, handler);//文档解析
			in.close();//关闭输入流
			return handler.getRivers();
			
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		} catch (SAXException e) {
			e.printStackTrace();
		} catch (IOException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
		
	}

}
