/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.adapter;

import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.ListView;
import android.widget.TextView;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.image.ImageDownloader;
import com.android.pc.ioc.image.Utils;
import com.android.pc.ioc.inject.InjectBinder;
import com.android.pc.ioc.inject.InjectView;
import com.android.pc.ioc.view.listener.OnListener;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Map;

public class LazyAdapter<T1, T2>
extends BaseAdapter {
    private ArrayList<T1> dataList;
    private int layout_id = -1;
    private LayoutInflater layoutInflater;
    private Constructor<?> constructor;
    private Class<?> clazz;
    private String packageName;
    private Context context;
    ImageDownloader imageDownloader = null;

    public LazyAdapter(ListView listView, ArrayList<T1> dataList, int layout_id) {
        this.dataList = dataList;
        this.layout_id = layout_id;
        this.context = listView.getContext();
        this.layoutInflater = LayoutInflater.from((Context)this.context);
        this.packageName = Ioc.getIoc().getApplication().getPackageName();
        this.imageDownloader = new ImageDownloader(this.context, 0);
        listView.setOnScrollListener(new AbsListView.OnScrollListener(){

            public void onScrollStateChanged(AbsListView absListView, int scrollState) {
                if (scrollState == 2) {
                    if (!Utils.hasHoneycomb()) {
                        LazyAdapter.this.imageDownloader.setPauseWork(true);
                    }
                } else {
                    LazyAdapter.this.imageDownloader.setPauseWork(false);
                }
            }

            public void onScroll(AbsListView absListView, int firstVisibleItem, int visibleItemCount, int totalItemCount) {
            }
        });
        ParameterizedType parameterizedType = (ParameterizedType)((Object)((Object)this)).getClass().getGenericSuperclass();
        Type[] types = parameterizedType.getActualTypeArguments();
        try {
            Constructor<?>[] constructors = ((Class)types[1]).getConstructors();
            if (constructors.length > 0) {
                this.constructor = constructors[0];
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public ImageDownloader getImageDownloader() {
        return this.imageDownloader;
    }

    public void setImageDownloader(ImageDownloader imageDownloader) {
        this.imageDownloader = imageDownloader;
    }

    public int getCount() {
        this.clazz = this.dataList.size() > 0 ? this.dataList.get(0).getClass() : null;
        return this.dataList.size();
    }

    public Object getItem(int arg0) {
        return this.dataList.get(arg0);
    }

    public long getItemId(int arg0) {
        return 0L;
    }

    public View getView(int position, View convertView, ViewGroup arg2) {
        try {
            Object viewHold = null;
            if (convertView == null) {
                convertView = this.layoutInflater.inflate(this.layout_id, null);
                try {
                    viewHold = this.constructor.newInstance(new Object[]{this});
                }
                catch (Exception e) {
                    viewHold = this.constructor.newInstance(this.context);
                }
                this.setView(viewHold, convertView, position);
                convertView.setTag(viewHold);
            } else {
                viewHold = convertView.getTag();
            }
            this.deal(this.dataList.get(position), viewHold, position);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return convertView;
    }

    public void deal(T1 data, T2 viewHold, int position) {
        this.injectAdapter(viewHold, position);
    }

    public void injectAdapter(Object view, int position) {
        Field[] fields = view.getClass().getDeclaredFields();
        if (fields != null && fields.length > 0) {
            Field[] fieldArray = fields;
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                String data;
                Field field = fieldArray[n2];
                InjectView v = field.getAnnotation(InjectView.class);
                if (v != null && (data = this.getString(position, field.getName())) != null) {
                    try {
                        field.setAccessible(true);
                        Object object = field.get(view);
                        if (object != null && View.class.isAssignableFrom(object.getClass())) {
                            ((View)object).setTag((Object)position);
                            if (TextView.class.isAssignableFrom(object.getClass())) {
                                ((TextView)object).setText((CharSequence)data);
                            }
                            if (ImageView.class.isAssignableFrom(object.getClass())) {
                                this.download((ImageView)object, data);
                            }
                        }
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
                ++n2;
            }
        }
    }

    private void setView(Object viewHold, View view, int postion) {
        block14: {
            try {
                Field[] fields = viewHold.getClass().getDeclaredFields();
                if (fields == null || fields.length <= 0) break block14;
                Field[] fieldArray = fields;
                int n = fields.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    field.setAccessible(true);
                    InjectView vs = field.getAnnotation(InjectView.class);
                    if (vs != null) {
                        View v = vs.value() != -1 ? view.findViewById(vs.value()) : view.findViewById(Ioc.getIoc().getApplication().getResources().getIdentifier(field.getName(), "id", this.packageName));
                        if (v == null) {
                            Ioc.getIoc().getLogger().e("\u53d8\u91cf  " + field + "  \u65e0\u6cd5\u8d4b\u503c\uff0c\u8bf7\u68c0\u67e5ID\u548cNAME");
                        } else {
                            InjectBinder[] binders;
                            try {
                                if (View.class.isAssignableFrom(v.getClass())) {
                                    field.set(viewHold, v);
                                }
                            }
                            catch (Exception e) {
                                e.printStackTrace();
                            }
                            if ((binders = vs.binders()) != null) {
                                int i = 0;
                                while (i < binders.length) {
                                    Class<? extends OnListener>[] clazzes;
                                    InjectBinder injectBinder = binders[i];
                                    Class<? extends OnListener>[] classArray = clazzes = injectBinder.listeners();
                                    int n3 = clazzes.length;
                                    int n4 = 0;
                                    while (n4 < n3) {
                                        Class<? extends OnListener> clazz = classArray[n4];
                                        try {
                                            OnListener listener = clazz.newInstance();
                                            listener.listener(v, viewHold, injectBinder.method());
                                        }
                                        catch (Exception e) {
                                            e.printStackTrace();
                                        }
                                        ++n4;
                                    }
                                    ++i;
                                }
                            }
                        }
                    }
                    ++n2;
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void download(ImageView view, String url) {
        this.imageDownloader.loadImage(url, view);
    }

    private String getString(int postion, String name) {
        T1 object = this.dataList.get(postion);
        if (Map.class.isAssignableFrom(this.clazz)) {
            return ((Map)object).containsKey(name) ? ((Map)object).get(name).toString() : "";
        }
        try {
            Method readName = this.clazz.getDeclaredMethod("get" + Character.toUpperCase(name.charAt(0)) + name.substring(1), new Class[0]);
            return readName.invoke(object, new Object[0]).toString();
        }
        catch (Exception e) {
            return null;
        }
    }
}

