/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelObject;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class KernelArray {
    public static <T> T get(T[] array, int index) {
        if (array != null && index >= 0 && index < array.length) {
            return array[index];
        }
        return null;
    }

    public static <T> void set(T[] array, T element) {
        KernelArray.set(array, element, array.length);
    }

    public static <T> void set(T[] array, T element, int length) {
        KernelArray.set(array, element, 0, length);
    }

    public static <T> void set(T[] array, T element, int beginIndex, int endIndex) {
        int i = beginIndex;
        while (i < endIndex) {
            array[i] = element;
            ++i;
        }
    }

    public static <T> T[] repeat(T element, int length) {
        Object[] array = (Object[])KernelArray.forComponentType(element.getClass()).newInstance(length);
        KernelArray.set(array, element, length);
        return array;
    }

    public static <T> T[] repeat(T element, int length, Class<T> componentType) {
        Object[] array = (Object[])Array.newInstance(componentType, length);
        KernelArray.set(array, element, length);
        return array;
    }

    public static <T> boolean contain(T[] array, T element) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            if (value.equals(element)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static <T> boolean contains(T[] array, T ... elements) {
        T[] TArray = elements;
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            T element = TArray[n2];
            if (!KernelArray.contain(array, element)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    public static boolean equal(Object[] array, Object[] other) {
        int length = array.length;
        if (length != other.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (array[i] != other[i]) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean equals(Object[] array, Object[] other) {
        int length = array.length;
        if (length != other.length) {
            return false;
        }
        int i = 0;
        while (i < length) {
            if (!KernelObject.equals(array[i], other[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static <T> T[] concat(T[] array, T[] other) {
        Object[] concatArray = (Object[])Array.newInstance(array.getClass().getComponentType(), array.length + other.length);
        System.arraycopy(array, 0, concatArray, 0, array.length);
        try {
            System.arraycopy(other, 0, concatArray, array.length, other.length);
        }
        catch (ArrayStoreException ase) {
            return array;
        }
        return concatArray;
    }

    public static <T> void copy(T[] array, T[] to) {
        int length = array.length;
        int i = 0;
        while (i < length) {
            to[i] = array[i];
            ++i;
        }
    }

    public static <T> void copy(T[] array, Collection<T> collection) {
        T[] TArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            T value = TArray[n2];
            collection.add(value);
            ++n2;
        }
    }

    public static <T> List<T> toList(T[] array) {
        ArrayList list = new ArrayList(array.length);
        KernelArray.copy(array, list);
        return list;
    }

    public static <T> Set<T> toSet(T[] array) {
        HashSet set = new HashSet(array.length);
        KernelArray.copy(array, set);
        return set;
    }

    public static ArrayAccessor forClass(Class cls) {
        if (cls.isArray()) {
            return KernelArray.forComponentType(cls.getComponentType());
        }
        return null;
    }

    public static ArrayAccessor forComponentType(Class componentType) {
        if (componentType == Byte.TYPE) {
            return EnumArrayAccessor.Byte;
        }
        if (componentType == Short.TYPE) {
            return EnumArrayAccessor.Short;
        }
        if (componentType == Integer.TYPE) {
            return EnumArrayAccessor.Integer;
        }
        if (componentType == Long.TYPE) {
            return EnumArrayAccessor.Long;
        }
        if (componentType == Float.TYPE) {
            return EnumArrayAccessor.Float;
        }
        if (componentType == Double.TYPE) {
            return EnumArrayAccessor.Double;
        }
        if (componentType == Boolean.TYPE) {
            return EnumArrayAccessor.Boolean;
        }
        if (componentType == Character.TYPE) {
            return EnumArrayAccessor.Character;
        }
        if (componentType == Object.class) {
            return EnumArrayAccessor.Object;
        }
        return new ComponentArrayAsscessor(componentType);
    }

    public static <T> void copy(Object array, Object to) {
        if (array.getClass().isArray() && to.getClass().isArray() && array.getClass().getComponentType().isAssignableFrom(to.getClass().getComponentType())) {
            ArrayAccessor interfaceArray = KernelArray.forClass(array.getClass());
            int length = Array.getLength(array);
            int i = 0;
            while (i < length) {
                interfaceArray.set(to, i, interfaceArray.get(array, i));
                ++i;
            }
        }
    }

    public static <T> T clone(T array) {
        ArrayAccessor interfaceArray = KernelArray.forClass(array.getClass());
        if (interfaceArray == null) {
            return null;
        }
        int length = Array.getLength(array);
        Object clone = interfaceArray.newInstance(length);
        int i = 0;
        while (i < length) {
            interfaceArray.set(clone, i, interfaceArray.get(array, i));
            ++i;
        }
        return (T)clone;
    }

    public static interface ArrayAccessor {
        public Object newInstance(int var1);

        public Object get(Object var1, int var2) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;

        public void set(Object var1, int var2, Object var3) throws IllegalArgumentException, ArrayIndexOutOfBoundsException;
    }

    public static class ComponentArrayAsscessor
    implements ArrayAccessor {
        private Class componentType;

        public ComponentArrayAsscessor(Class componentType) {
            this.componentType = componentType;
        }

        @Override
        public Object newInstance(int length) {
            return Array.newInstance(this.componentType, length);
        }

        @Override
        public Object get(Object array, int index) {
            return Array.get(array, index);
        }

        @Override
        public void set(Object array, int index, Object value) {
            Array.set(array, index, value);
        }
    }

    public static enum EnumArrayAccessor implements ArrayAccessor
    {
        Byte{

            @Override
            public Object newInstance(int length) {
                return new byte[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getByte(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setByte(array, index, (Byte)value);
            }
        }
        ,
        Short{

            @Override
            public Object newInstance(int length) {
                return new short[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getShort(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setShort(array, index, (Short)value);
            }
        }
        ,
        Integer{

            @Override
            public Object newInstance(int length) {
                return new int[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getByte(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setInt(array, index, (Integer)value);
            }
        }
        ,
        Long{

            @Override
            public Object newInstance(int length) {
                return new long[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getLong(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setLong(array, index, (Long)value);
            }
        }
        ,
        Float{

            @Override
            public Object newInstance(int length) {
                return new float[length];
            }

            @Override
            public Object get(Object array, int index) {
                return java.lang.Float.valueOf(Array.getFloat(array, index));
            }

            @Override
            public void set(Object array, int index, Object object) {
                Array.setFloat(array, index, ((Float)object).floatValue());
            }
        }
        ,
        Double{

            @Override
            public Object newInstance(int length) {
                return new double[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getDouble(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setDouble(array, index, (Double)value);
            }
        }
        ,
        Boolean{

            @Override
            public Object newInstance(int length) {
                return new boolean[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.getBoolean(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setBoolean(array, index, (Boolean)value);
            }
        }
        ,
        Character{

            @Override
            public Object newInstance(int length) {
                return new char[length];
            }

            @Override
            public Object get(Object array, int index) {
                return java.lang.Character.valueOf(Array.getChar(array, index));
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.setChar(array, index, ((Character)value).charValue());
            }
        }
        ,
        Object{

            @Override
            public Object newInstance(int length) {
                return new Object[length];
            }

            @Override
            public Object get(Object array, int index) {
                return Array.get(array, index);
            }

            @Override
            public void set(Object array, int index, Object value) {
                Array.set(array, index, value);
            }
        };

    }
}

