/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelLang;
import com.android.pc.ioc.core.kernel.KernelReflect;
import com.android.pc.ioc.core.kernel.KernelString;
import java.lang.annotation.Annotation;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.GenericArrayType;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.HashMap;
import java.util.Map;

public abstract class KernelClass {
    static final Map<Class, Object> Class_Map_Instance = new HashMap<Class, Object>();

    public static String parentName(Class cls) {
        return KernelString.rightSubString(cls.getName(), cls.getSimpleName().length() + 1);
    }

    public static boolean isAssignableFrom(Class cls, Class[] types) {
        Class[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            if (cls.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAssignableFrom(Class[] classes, Class type) {
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class cls = classArray[n2];
            if (cls.isAssignableFrom(type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isAssignableFrom(Class[] classes, Class[] types) {
        int length = classes.length;
        if (length == types.length) {
            int i = 0;
            while (i < length) {
                if (!classes[i].isAssignableFrom(types[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static <T> Class<? extends T> classAssignable(Class cls, Class T) {
        return KernelClass.classAssignable(cls, null, T);
    }

    public static <T> Class<? extends T> classAssignable(Class cls, Class<? extends T> defaultValue, Class T) {
        if (cls == null || !T.isAssignableFrom(cls)) {
            return defaultValue;
        }
        return cls;
    }

    public static boolean isMatchableFrom(Class cls, Class type) {
        if (cls.isAssignableFrom(type)) {
            return true;
        }
        if (cls == Object.class) {
            return true;
        }
        if (cls == Byte.TYPE) {
            return type == Byte.class;
        }
        if (cls == Byte.class) {
            return type == Byte.TYPE;
        }
        if (cls == Short.TYPE) {
            return type == Short.class;
        }
        if (cls == Short.class) {
            return type == Short.TYPE;
        }
        if (cls == Integer.TYPE) {
            return type == Integer.class;
        }
        if (cls == Integer.class) {
            return type == Integer.TYPE;
        }
        if (cls == Float.TYPE) {
            return type == Float.class;
        }
        if (cls == Float.class) {
            return type == Float.TYPE;
        }
        if (cls == Double.TYPE) {
            return type == Double.class;
        }
        if (cls == Double.class) {
            return type == Double.TYPE;
        }
        if (cls == Boolean.TYPE) {
            return type == Boolean.class;
        }
        if (cls == Boolean.class) {
            return type == Boolean.TYPE;
        }
        if (cls == Character.TYPE) {
            return type == Character.class;
        }
        if (cls == Character.class) {
            return type == Character.TYPE;
        }
        if (cls == Long.TYPE) {
            return type == Long.class;
        }
        if (cls == Long.class) {
            return type == Long.TYPE;
        }
        if (cls.isArray() && type.isArray()) {
            cls.getComponentType().isAssignableFrom(type.getComponentType());
        }
        return false;
    }

    public static boolean isMatchableFrom(Class cls, Class[] types) {
        Class[] classArray = types;
        int n = types.length;
        int n2 = 0;
        while (n2 < n) {
            Class type = classArray[n2];
            if (KernelClass.isMatchableFrom(cls, type)) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static boolean isMatchableFrom(Class[] classes, Class[] types) {
        int length = classes.length;
        if (length == types.length) {
            int i = 0;
            while (i < length) {
                if (!KernelClass.isMatchableFrom(classes[i], types[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public static Class[] parameterTypes(Object ... args) {
        int length = args.length;
        Class[] parameterTypes = new Class[length];
        int i = 0;
        while (i < length) {
            parameterTypes[i] = args[i].getClass();
            ++i;
        }
        return parameterTypes;
    }

    public static Class rawClass(Type type) {
        if (type instanceof ParameterizedType) {
            return (Class)((ParameterizedType)type).getRawType();
        }
        if (type instanceof GenericArrayType) {
            try {
                return Array.newInstance(KernelClass.rawClass(((GenericArrayType)type).getGenericComponentType()), 0).getClass();
            }
            catch (Exception exception) {
            }
        } else if (type instanceof Class) {
            return (Class)type;
        }
        return Object.class;
    }

    public static Type[] typeArguments(Type type) {
        if (type instanceof ParameterizedType) {
            return ((ParameterizedType)type).getActualTypeArguments();
        }
        return null;
    }

    public static Class[] rawClasses(Type[] types) {
        int length = types.length;
        Class[] classes = new Class[length];
        int i = 0;
        while (i < length) {
            classes[i] = KernelClass.rawClass(types[i]);
            ++i;
        }
        return classes;
    }

    public static Class componentClass(Class<?> cls) {
        if (cls.isArray()) {
            return cls.getComponentType();
        }
        Class superClass = KernelClass.componentClass(cls.getGenericSuperclass());
        return superClass == cls.getSuperclass() ? cls : superClass;
    }

    public static Class[] componentClasses(Class<?> cls) {
        if (cls.isArray()) {
            return new Class[]{cls.getComponentType()};
        }
        Class[] superClasses = KernelClass.componentClasses(cls.getGenericSuperclass());
        if (superClasses.length == 1 && superClasses[0] == cls.getSuperclass()) {
            superClasses[0] = cls;
        }
        return superClasses;
    }

    public static Class componentClass(Type type) {
        Type componentType = type;
        while (type != null) {
            Type[] types = KernelClass.typeArguments(type);
            if (types == null || types.length <= 0) {
                Class cls = KernelClass.rawClass(type);
                if (cls.isArray()) {
                    return cls.getComponentType();
                }
                type = cls.getGenericSuperclass();
                continue;
            }
            return KernelClass.rawClass(types[0]);
        }
        return KernelClass.rawClass(componentType);
    }

    public static Class[] componentClasses(Type type) {
        Type componentType = type;
        while (type != null) {
            Type[] types = KernelClass.typeArguments(type);
            if (types == null || types.length <= 0) {
                Class cls = KernelClass.rawClass(type);
                if (cls.isArray()) {
                    return new Class[]{cls.getComponentType()};
                }
                type = cls.getGenericSuperclass();
                continue;
            }
            return KernelClass.rawClasses(types);
        }
        return new Class[]{KernelClass.rawClass(componentType)};
    }

    public static int similar(Class cls, Class type) {
        int similar = -1;
        while (cls != null) {
            if (similar < 0) {
                if (cls == type) {
                    similar = 0;
                } else {
                    Class<?>[] classArray = cls.getInterfaces();
                    int n = classArray.length;
                    int n2 = 0;
                    while (n2 < n) {
                        Class<?> iCls = classArray[n2];
                        if (iCls == type) {
                            similar = 0;
                            break;
                        }
                        ++n2;
                    }
                }
            } else {
                ++similar;
            }
            cls = cls.getSuperclass();
        }
        return similar;
    }

    public static int similar(Class[] classes, Class[] types) {
        int similar = -1;
        int length = classes.length;
        if (length == types.length) {
            int i = 0;
            while (i < length) {
                similar += KernelClass.similar(classes[i], types[i]);
                ++i;
            }
        }
        return similar;
    }

    public static Class forName(String className) {
        return KernelClass.forName(className, null);
    }

    public static Class forName(String className, Class defaultValue) {
        try {
            return Class.forName(className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            return defaultValue;
        }
    }

    public static <T extends Annotation> T getAnnotation(Class<?> cls, Class<T> annotationType) {
        Annotation[] annotations;
        T annotation = cls.getAnnotation(annotationType);
        if (annotation == null && !Annotation.class.isAssignableFrom(cls) && (annotations = cls.getAnnotations()) != null) {
            Annotation[] annotationArray = annotations;
            int n = annotations.length;
            int n2 = 0;
            while (n2 < n) {
                Annotation obj = annotationArray[n2];
                annotation = KernelClass.getAnnotation(obj.annotationType(), annotationType);
                if (annotation != null) break;
                ++n2;
            }
        }
        return annotation;
    }

    public static <T> T newInstance(Class<T> cls) {
        return KernelClass.newInstance(null, cls);
    }

    public static <T> T newInstance(T defaultValue, Class<T> cls) {
        try {
            return cls.newInstance();
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        return defaultValue;
    }

    public static <T> T newInstance(Class<T> cls, Object ... initargs) {
        return KernelClass.newInstance(cls, null, initargs);
    }

    public static <T> T newInstance(Class<T> cls, T defaultValue, Object ... initargs) {
        if (initargs.length == 0) {
            return KernelClass.newInstance(defaultValue, cls);
        }
        return KernelClass.newInstance(cls, defaultValue, KernelClass.parameterTypes(initargs), true, initargs);
    }

    public static <T> T newInstance(Class<T> cls, T defaultValue, Class[] parameterTypes, Object ... initargs) {
        return KernelClass.newInstance(cls, defaultValue, parameterTypes, false, initargs);
    }

    public static <T> T newInstance(Class<T> cls, T defaultValue, Class[] parameterTypes, boolean assignable, Object ... initargs) {
        return KernelClass.declaredNew(cls, defaultValue, false, assignable, parameterTypes, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, Object ... initargs) {
        return KernelClass.declaredNew(cls, null, KernelClass.parameterTypes(initargs), true, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, T defaultValue, Object ... initargs) {
        return KernelClass.declaredNew(cls, defaultValue, KernelClass.parameterTypes(initargs), true, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, Class[] parameterTypes, Object ... initargs) {
        return KernelClass.declaredNew(cls, null, parameterTypes, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, T defaultValue, Class[] parameterTypes, Object ... initargs) {
        return KernelClass.declaredNew(cls, defaultValue, parameterTypes, false, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, T defaultValue, Class[] parameterTypes, boolean assignable, Object ... initargs) {
        return KernelClass.declaredNew(cls, defaultValue, true, assignable, parameterTypes, initargs);
    }

    public static <T> T declaredNew(Class<T> cls, T defaultValue, boolean declared, boolean assignable, Class[] parameterTypes, Object ... initargs) {
        Constructor<T> constructor = KernelReflect.assignableConstructor(cls, declared, assignable, parameterTypes);
        return KernelReflect.newInstance(constructor, initargs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(Class<T> cls) {
        Object instance = Class_Map_Instance.get(cls);
        if (instance == null) {
            Class<T> clazz = cls;
            synchronized (clazz) {
                instance = Class_Map_Instance.get(cls);
                if (instance == null) {
                    instance = KernelClass.newInstance(cls);
                    Class_Map_Instance.put(cls, instance);
                }
            }
        }
        return (T)instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <T> T getInstance(Class<T> cls, Object ... initargs) {
        Object instance = Class_Map_Instance.get(cls);
        if (instance == null) {
            Class<T> clazz = cls;
            synchronized (clazz) {
                instance = Class_Map_Instance.get(cls);
                if (instance == null) {
                    instance = KernelClass.newInstance(cls, initargs);
                    Class_Map_Instance.put(cls, instance);
                }
            }
        }
        return (T)instance;
    }

    public static Object declaredGet(Class cls, String name) {
        Field field = KernelReflect.declaredField(cls.getClass(), name);
        return KernelReflect.get(cls, field);
    }

    public static boolean declaredSet(Class cls, String name, Object value) {
        Field field = KernelReflect.declaredField(cls.getClass(), name);
        return KernelReflect.set(cls, field, value);
    }

    public static Object declaredSend(Class cls, String name, Object ... args) {
        Method method = KernelReflect.assignableMethod(cls, name, 0, true, KernelClass.parameterTypes(args));
        if (method != null) {
            return KernelReflect.invoke((Object)cls, method, args);
        }
        return null;
    }

    public static Method setter(Field field) {
        return KernelClass.setter(field.getDeclaringClass(), field);
    }

    public static Method setter(Class cls, Field field) {
        return KernelClass.setter(cls, field.getName(), field.getType());
    }

    public static Method setter(Class cls, String field, Class fieldType) {
        return KernelReflect.method(cls, "set" + KernelString.uncapitalize(field), fieldType);
    }

    public static Method getter(Field field) {
        return KernelClass.getter(field.getDeclaringClass(), field);
    }

    public static Method getter(Class cls, Field field) {
        return KernelClass.getter(cls, field.getName(), field.getType());
    }

    public static Method getter(Class cls, String field) {
        Method method = KernelReflect.method(cls, "get" + (field = KernelString.uncapitalize(field)), new Class[0]);
        if (method == null) {
            method = KernelReflect.method(cls, "is" + field, new Class[0]);
        }
        return method;
    }

    public static Method getter(Class cls, String field, Class fieldType) {
        Method method = KernelReflect.method(cls, "get" + (field = KernelString.uncapitalize(field)), new Class[0]);
        if (method == null || !fieldType.isAssignableFrom(method.getReturnType())) {
            if (fieldType == Boolean.TYPE || fieldType == Boolean.class) {
                method = KernelReflect.method(cls, "is" + field, new Class[0]);
            }
            if (method != null && !fieldType.isAssignableFrom(method.getReturnType())) {
                method = null;
            }
        }
        return method;
    }

    public static <T> T instanceOf(Class<T> cls, Object obj) {
        return KernelClass.instanceOf(cls, null, obj);
    }

    public static <T> T instanceOf(Class<T> cls, T defaultValue, Object obj) {
        T value = KernelClass.newInstance(cls, obj);
        if (value == null) {
            value = KernelClass.valueOf(cls, obj);
        }
        if (value == null) {
            return defaultValue;
        }
        return value;
    }

    public static <T> T valueOf(Class<T> cls, Object obj) {
        return KernelClass.valueOf(cls, null, obj);
    }

    public static <T> T valueOf(Class<T> cls, T defaultValue, Object obj) {
        Method method = KernelReflect.assignableMethod(cls, "valueOf", obj.getClass());
        if (method != null && cls.isAssignableFrom(method.getReturnType())) {
            return (T)KernelReflect.invoke(cls, method, obj);
        }
        return defaultValue;
    }

    public static <T> Class<? extends T> cast(Class cls, Class<T> toClass) {
        return KernelClass.cast(cls, null, toClass);
    }

    public static <T> Class<? extends T> cast(Class cls, Class<? extends T> defaultValue, Class<T> toClass) {
        if (cls != null && toClass.isAssignableFrom(cls)) {
            return cls;
        }
        return defaultValue;
    }

    public static void doWithSuperClass(Class cls, KernelLang.CallbackBreak<Class<?>> callback) {
        try {
            while (cls != null && cls != Object.class) {
                callback.doWith(cls);
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }

    public static void doWithAncestClass(Class cls, KernelLang.CallbackBreak<Class<?>> callback) {
        try {
            while (cls != null && cls != Object.class) {
                callback.doWith(cls);
                Class<?>[] classArray = cls.getInterfaces();
                int n = classArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Class<?> c = classArray[n2];
                    callback.doWith(c);
                    ++n2;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }
}

