/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelString;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;

public abstract class KernelDyna {
    public static final Byte BYTE_ZERO = 0;
    public static final Short SHORT_ZERO = 0;
    public static final Integer INTEGER_ZERO = 0;
    public static final Long LONG_ZERO = 0L;
    public static final Float FLOAT_ZERO = Float.valueOf(0.0f);
    public static final Double DOUBLE_ZERO = 0.0;
    public static final Boolean BOOLEAN_ZERO = false;
    public static final Character CHARACTER_ZERO = Character.valueOf('\u0000');
    public static final Date DATE_ZERO = new Date(0L);
    public static final DateFormat DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
    public static final DateFormat DATE_FORMAT_DAY = new SimpleDateFormat("yyyy-MM-dd");
    public static final DateFormat DATE_FORMAT_TIME = new SimpleDateFormat("HH:mm:ss");
    public static final DateFormat[] DATE_FORMAT_ARRAY = new DateFormat[]{DATE_FORMAT, DATE_FORMAT_DAY, DATE_FORMAT_TIME, DateFormat.getDateTimeInstance(), DateFormat.getDateTimeInstance(1, 1), DateFormat.getDateTimeInstance(2, 2), new SimpleDateFormat("EEE MMM d hh:mm:ss a z yyyy"), new SimpleDateFormat("EEE MMM d HH:mm:ss z yyyy"), new SimpleDateFormat("MM/dd/yy hh:mm:ss a"), new SimpleDateFormat("MM/dd/yy")};

    public static <T> T to(Object obj, Class<T> toClass) {
        if (obj == null) {
            return KernelDyna.nullTo(toClass);
        }
        if (toClass.isAssignableFrom(obj.getClass())) {
            return (T)obj;
        }
        if (obj instanceof Number) {
            return KernelDyna.numberTo((Number)obj, toClass);
        }
        if (obj instanceof Date) {
            return KernelDyna.dateTo((Date)obj, toClass);
        }
        if (obj instanceof String) {
            return KernelDyna.stringTo((String)obj, toClass);
        }
        return KernelDyna.nullTo(toClass);
    }

    public static <T> T nullTo(Class<T> toClass) {
        if (toClass == Byte.TYPE) {
            return (T)BYTE_ZERO;
        }
        if (toClass == Short.TYPE) {
            return (T)SHORT_ZERO;
        }
        if (toClass == Integer.TYPE) {
            return (T)INTEGER_ZERO;
        }
        if (toClass == Long.TYPE) {
            return (T)LONG_ZERO;
        }
        if (toClass == Float.TYPE) {
            return (T)FLOAT_ZERO;
        }
        if (toClass == Double.TYPE) {
            return (T)DOUBLE_ZERO;
        }
        if (toClass == Boolean.TYPE) {
            return (T)BOOLEAN_ZERO;
        }
        if (toClass == Character.TYPE) {
            return (T)CHARACTER_ZERO;
        }
        return null;
    }

    public static <T> T numberTo(Number num, Class<T> toClass) {
        if (toClass == Byte.class || toClass == Byte.TYPE) {
            return (T)Byte.valueOf(num.byteValue());
        }
        if (toClass == Short.class || toClass == Short.TYPE) {
            return (T)Short.valueOf(num.shortValue());
        }
        if (toClass == Integer.class || toClass == Integer.TYPE) {
            return (T)Integer.valueOf(num.intValue());
        }
        if (toClass == Long.class || toClass == Long.TYPE) {
            return (T)Long.valueOf(num.longValue());
        }
        if (toClass == Float.class || toClass == Float.TYPE) {
            return (T)Float.valueOf(num.floatValue());
        }
        if (toClass == Double.class || toClass == Double.TYPE) {
            return (T)Double.valueOf(num.doubleValue());
        }
        if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            return (T)Boolean.valueOf(num.byteValue() != 0);
        }
        if (toClass == Character.class || toClass == Character.TYPE) {
            return (T)Character.valueOf((char)num.byteValue());
        }
        if (toClass == Date.class) {
            return (T)new Date(num.longValue());
        }
        if (toClass.isAssignableFrom(String.class)) {
            return (T)num.toString();
        }
        return null;
    }

    public static <T> T dateTo(Date date, Class<T> toClass) {
        if (toClass == Byte.class || toClass == Byte.TYPE) {
            return (T)Byte.valueOf(Long.valueOf(date.getTime()).byteValue());
        }
        if (toClass == Short.class || toClass == Short.TYPE) {
            return (T)Short.valueOf(Long.valueOf(date.getTime()).shortValue());
        }
        if (toClass == Integer.class || toClass == Integer.TYPE) {
            return (T)Integer.valueOf(Long.valueOf(date.getTime()).intValue());
        }
        if (toClass == Long.class || toClass == Long.TYPE) {
            return (T)Long.valueOf(date.getTime());
        }
        if (toClass == Float.class || toClass == Float.TYPE) {
            return (T)Float.valueOf(Long.valueOf(date.getTime()).floatValue());
        }
        if (toClass == Double.class || toClass == Double.TYPE) {
            return (T)Double.valueOf(Long.valueOf(date.getTime()).doubleValue());
        }
        if (toClass == Boolean.class || toClass == Boolean.TYPE) {
            return (T)Boolean.valueOf(Long.valueOf(date.getTime()).byteValue() != 0);
        }
        if (toClass == Character.class || toClass == Character.TYPE) {
            return (T)Character.valueOf((char)Long.valueOf(date.getTime()).byteValue());
        }
        if (toClass.isAssignableFrom(String.class)) {
            return (T)KernelDyna.toString(date);
        }
        return null;
    }

    public static String toString(Date date) {
        return KernelDyna.toString(date, 0);
    }

    public static String toString(Date date, int type) {
        try {
            return DATE_FORMAT_ARRAY[type].format(date);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static <T> T stringTo(String str, Class<T> toClass) {
        if (KernelString.empty(str)) {
            return KernelDyna.nullTo(toClass);
        }
        return KernelDyna.stringTo(str, toClass, null);
    }

    public static <T> T stringTo(String str, Class<T> toClass, boolean[] dynas) {
        if (toClass == Byte.TYPE) {
            return (T)KernelDyna.toByte(str);
        }
        if (toClass == Byte.class) {
            return (T)KernelDyna.toByte(str, null);
        }
        if (toClass == Short.TYPE) {
            return (T)KernelDyna.toShort(str);
        }
        if (toClass == Short.class) {
            return (T)KernelDyna.toShort(str, null);
        }
        if (toClass == Integer.TYPE) {
            return (T)KernelDyna.toInteger(str);
        }
        if (toClass == Integer.class) {
            return (T)KernelDyna.toInteger(str, null);
        }
        if (toClass == Long.TYPE) {
            return (T)KernelDyna.toLong(str);
        }
        if (toClass == Long.class) {
            return (T)KernelDyna.toLong(str, null);
        }
        if (toClass == Float.TYPE) {
            return (T)KernelDyna.toFloat(str);
        }
        if (toClass == Float.class) {
            return (T)KernelDyna.toFloat(str, null);
        }
        if (toClass == Double.TYPE) {
            return (T)KernelDyna.toDouble(str);
        }
        if (toClass == Double.class) {
            return (T)KernelDyna.toDouble(str, null);
        }
        if (toClass == Boolean.TYPE) {
            return (T)KernelDyna.toBoolean(str);
        }
        if (toClass == Boolean.class) {
            return (T)KernelDyna.toBoolean(str, null);
        }
        if (toClass == Character.TYPE) {
            return (T)KernelDyna.toCharacter(str);
        }
        if (toClass == Character.class) {
            return (T)KernelDyna.toBoolean(str, null);
        }
        if (toClass == Date.class) {
            return (T)KernelDyna.toDate(str, DATE_ZERO);
        }
        if (toClass == Enum.class) {
            return Enum.valueOf(toClass, str);
        }
        if (dynas != null && dynas.length > 0) {
            dynas[0] = !dynas[0];
        }
        return null;
    }

    public static Byte toByte(String str) {
        return KernelDyna.toByte(str, BYTE_ZERO);
    }

    public static Byte toByte(String str, Byte defaultValue) {
        try {
            return Byte.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Short toShort(String str) {
        return KernelDyna.toShort(str, SHORT_ZERO);
    }

    public static Short toShort(String str, Short defaultValue) {
        try {
            return Short.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Integer toInteger(String str) {
        return KernelDyna.toInteger(str, INTEGER_ZERO);
    }

    public static Integer toInteger(String str, Integer defaultValue) {
        try {
            return Integer.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Long toLong(String str) {
        return KernelDyna.toLong(str, LONG_ZERO);
    }

    public static Long toLong(String str, Long defaultValue) {
        try {
            return Long.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Float toFloat(String str) {
        return KernelDyna.toFloat(str, FLOAT_ZERO);
    }

    public static Float toFloat(String str, Float defaultValue) {
        try {
            return Float.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Double toDouble(String str) {
        return KernelDyna.toDouble(str, DOUBLE_ZERO);
    }

    public static Double toDouble(String str, Double defaultValue) {
        try {
            return Double.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Boolean toBoolean(String str) {
        return KernelDyna.toBoolean(str, BOOLEAN_ZERO);
    }

    public static Boolean toBoolean(String str, Boolean defaultValue) {
        try {
            return Boolean.valueOf(str);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Character toCharacter(String str) {
        return KernelDyna.toCharacter(str, CHARACTER_ZERO);
    }

    public static Character toCharacter(String str, Character defaultValue) {
        try {
            return Character.valueOf(str.charAt(0));
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static Date toDate(Object obj) {
        return KernelDyna.to(obj, Date.class);
    }

    public static Date toDate(String str) {
        return KernelDyna.toDate(str, DATE_ZERO);
    }

    public static Date toDate(String str, Date defaultValue) {
        DateFormat[] dateFormatArray = DATE_FORMAT_ARRAY;
        int n = DATE_FORMAT_ARRAY.length;
        int n2 = 0;
        while (n2 < n) {
            DateFormat dateFormat = dateFormatArray[n2];
            try {
                return dateFormat.parse(str);
            }
            catch (Exception exception) {
                ++n2;
            }
        }
        return defaultValue;
    }
}

