/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelArray;
import com.android.pc.ioc.core.kernel.KernelString;
import java.util.HashSet;
import java.util.Set;

public class KernelLang {
    public static final Object NULL_OBJECT = new Object();
    public static final Object[] NULL_OBJECTS = new Object[0];
    public static final String[] NULL_STRINGS = new String[0];

    public static int min(int one, int two, int three) {
        one = one < two ? one : two;
        return one < three ? one : three;
    }

    public static class BreakException
    extends Exception {
    }

    public static interface CallbackBreak<T> {
        public void doWith(T var1) throws BreakException;
    }

    public static interface CallbackTemplate<T> {
        public void doWith(T var1);
    }

    public static class CauseRuntimeException
    extends RuntimeException {
        public CauseRuntimeException(Throwable cause) {
            super(cause);
        }

        @Override
        public Throwable getCause() {
            Throwable cause = super.getCause();
            while (cause != null && cause != this) {
                if (!(cause instanceof CauseRuntimeException)) continue;
                cause = cause.getCause();
            }
            return cause;
        }

        @Override
        public void printStackTrace() {
            Throwable cause = this.getCause();
            if (cause != null) {
                cause.printStackTrace();
            }
            super.printStackTrace();
        }

        @Override
        public String getMessage() {
            Throwable cause = this.getCause();
            return cause == null ? super.getMessage() : cause.getMessage();
        }
    }

    public static interface CloneTemplate<T>
    extends Cloneable {
        public T clone();
    }

    public static interface FilterTemplate<T> {
        public boolean doWith(T var1) throws BreakException;
    }

    public static class ObjectTemplate<T> {
        public T object;

        public ObjectTemplate() {
        }

        public ObjectTemplate(T object) {
            this.object = object;
        }
    }

    public static class PropertyFilter {
        private Set<String> includes;
        private Set<String> excludes;
        private String propertyPath = "";

        public PropertyFilter newly() {
            PropertyFilter filter = new PropertyFilter();
            filter.includes = this.includes;
            filter.excludes = this.excludes;
            return filter;
        }

        public void begin() {
            this.propertyPath = "";
        }

        public PropertyFilter inlcude(String ... properties) {
            if (this.includes == null) {
                this.includes = new HashSet<String>();
            }
            KernelArray.copy(properties, this.includes);
            return this;
        }

        public PropertyFilter exlcude(String ... properties) {
            if (this.excludes == null) {
                this.excludes = new HashSet<String>();
            }
            KernelArray.copy(properties, this.excludes);
            return this;
        }

        public boolean isNonePath() {
            return this.includes == null && this.excludes == null;
        }

        public boolean isMatch() {
            return true;
        }

        public boolean isMatch(String propertyName) {
            if (!KernelString.isEmpty(propertyName)) {
                this.propertyPath = KernelString.isEmpty(this.propertyPath) ? propertyName : String.valueOf(this.propertyPath) + "." + propertyName;
            }
            return this.isMatch();
        }

        public boolean isMatchPath(String propertyPath) {
            this.propertyPath = propertyPath;
            return this.isMatch();
        }

        public boolean isMatchPath(String propertyPath, String propertyName) {
            this.setPropertyPath(propertyPath);
            return this.isMatch(propertyName);
        }

        public String getPropertyPath() {
            return this.propertyPath;
        }

        public void setPropertyPath(String propertyPath) {
            this.propertyPath = propertyPath;
        }
    }
}

