/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelArray;
import com.android.pc.ioc.core.kernel.KernelClass;
import com.android.pc.ioc.core.kernel.KernelLang;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class KernelReflect {
    protected static final Map<String, Method> Class_Method_Map_Method = new HashMap<String, Method>();

    public static <T extends Member> T memberStatic(T member) {
        return KernelReflect.memberStatic(member, null);
    }

    public static <T extends Member> T memberStatic(T member, T defaultValue) {
        if (member == null || !Modifier.isStatic(member.getModifiers())) {
            return defaultValue;
        }
        return member;
    }

    public static <T extends Member> T memberAccessor(T member) {
        return KernelReflect.memberAccessor(member, null);
    }

    public static <T extends Member> T memberAccessor(T member, T defaultValue) {
        if (member == null || Modifier.isFinal(member.getModifiers()) || Modifier.isStatic(member.getModifiers())) {
            return defaultValue;
        }
        return member;
    }

    public static <T> Constructor<T> constructor(Class<T> cls, Class ... parameterTypes) {
        return KernelReflect.declaredConstructor(cls, false, parameterTypes);
    }

    public static <T> Constructor<T> declaredConstructor(Class<T> cls, Class ... parameterTypes) {
        return KernelReflect.declaredConstructor(cls, true, parameterTypes);
    }

    public static <T> Constructor<T> declaredConstructor(Class<T> cls, boolean declared, Class ... parameterTypes) {
        try {
            Constructor<T> constructor;
            Constructor<T> constructor2 = constructor = declared ? cls.getDeclaredConstructor(parameterTypes) : cls.getConstructor(parameterTypes);
            if (constructor != null) {
                if (declared && !constructor.isAccessible()) {
                    constructor.setAccessible(true);
                }
                return constructor;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
        return null;
    }

    public static <T> Constructor<T> assignableConstructor(Class<T> cls, Class ... parameterTypes) {
        return KernelReflect.assignableConstructor(cls, false, parameterTypes);
    }

    public static <T> Constructor<T> assignableConstructor(Class<T> cls, boolean declared, Class ... parameterTypes) {
        Constructor<?>[] constructors = declared ? cls.getDeclaredConstructors() : cls.getConstructors();
        int similar = -2;
        Constructor<?> constructor = null;
        Constructor<?>[] constructorArray = constructors;
        int n = constructors.length;
        int n2 = 0;
        while (n2 < n) {
            block5: {
                int sim;
                Constructor<?> structor;
                block6: {
                    structor = constructorArray[n2];
                    if (!KernelClass.isMatchableFrom(structor.getParameterTypes(), parameterTypes)) break block5;
                    if (structor.isAccessible()) break block6;
                    if (!declared) break block5;
                    structor.setAccessible(true);
                }
                if (similar < (sim = KernelClass.similar(parameterTypes, structor.getParameterTypes()))) {
                    similar = sim;
                    constructor = structor;
                }
            }
            ++n2;
        }
        return constructor;
    }

    public static <T> Constructor<T> assignableConstructor(Class<T> cls, boolean declared, boolean assignable, Class ... parameterTypes) {
        return assignable ? KernelReflect.assignableConstructor(cls, declared, parameterTypes) : KernelReflect.declaredConstructor(cls, declared, parameterTypes);
    }

    public static <T> T newInstance(Constructor<T> constructor, Object ... initargs) {
        return KernelReflect.newInstance(constructor, null, initargs);
    }

    public static <T> T newInstance(Constructor<T> constructor, T defaultValue, Object ... initargs) {
        if (constructor != null) {
            try {
                return constructor.newInstance(initargs);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (InstantiationException instantiationException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Field field(Class cls, String name) {
        return KernelReflect.field(cls, name, 0);
    }

    public static Field field(Class cls, String name, int ancest) {
        return KernelReflect.declaredField(cls, name, ancest, false);
    }

    public static Field declaredField(Class cls, String name) {
        return KernelReflect.declaredField(cls, name, 0);
    }

    public static Field declaredField(Class cls, String name, int ancest) {
        return KernelReflect.declaredField(cls, name, ancest, true);
    }

    public static Field declaredField(Class cls, String name, int ancest, boolean declared) {
        AccessibleObject field = null;
        while (cls != null) {
            try {
                field = declared ? cls.getDeclaredField(name) : cls.getField(name);
                break;
            }
            catch (SecurityException e) {
                break;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                cls = ancest < 1 || ancest-- != 1 ? cls.getSuperclass() : null;
            }
        }
        if (field != null && declared && !field.isAccessible()) {
            ((Field)field).setAccessible(true);
        }
        return field;
    }

    public static List<Field> fields(Class cls) {
        return KernelReflect.fields(cls, 0);
    }

    public static List<Field> fields(Class cls, int ancest) {
        return KernelReflect.declaredFields(cls, ancest, false);
    }

    public static List<Field> declaredFields(Class cls) {
        return KernelReflect.declaredFields(cls, 0);
    }

    public static List<Field> declaredFields(Class cls, int ancest) {
        return KernelReflect.declaredFields(cls, ancest, true);
    }

    public static List<Field> declaredFields(Class cls, int ancest, boolean declared) {
        ArrayList<Field> declaredFields = new ArrayList<Field>();
        while (cls != null) {
            Field[] fields;
            Field[] fieldArray = fields = declared ? cls.getDeclaredFields() : cls.getFields();
            int n = fields.length;
            int n2 = 0;
            while (n2 < n) {
                Field field = fieldArray[n2];
                if (declared && !field.isAccessible()) {
                    field.setAccessible(true);
                }
                declaredFields.add(field);
                ++n2;
            }
            cls = ancest < 1 || ancest-- != 1 ? cls.getSuperclass() : null;
        }
        return declaredFields;
    }

    public static boolean set(Object obj, Field field, Object value) {
        if (field != null) {
            try {
                field.setAccessible(true);
                field.set(obj, value);
                return true;
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return false;
    }

    public static Object get(Object obj, Field field) {
        return KernelReflect.get(obj, null, field);
    }

    public static Object get(Object obj, Object defaultValue, Field field) {
        if (field != null) {
            try {
                return field.get(obj);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static Method method(Class cls, String name, Class ... parameterTypes) {
        return KernelReflect.method(cls, name, 0, parameterTypes);
    }

    public static Method method(Class cls, String name, int ancest, Class ... parameterTypes) {
        return KernelReflect.declaredMethod(cls, name, ancest, false, parameterTypes);
    }

    public static Method declaredMethod(Class cls, String name, Class ... parameterTypes) {
        return KernelReflect.declaredMethod(cls, name, 0, parameterTypes);
    }

    public static Method declaredMethod(Class cls, String name, int ancest, Class ... parameterTypes) {
        return KernelReflect.declaredMethod(cls, name, ancest, true, parameterTypes);
    }

    public static Method declaredMethod(Class cls, String name, int ancest, boolean declared, Class ... parameterTypes) {
        return KernelReflect.assignableMethod(cls, name, ancest, declared, false, false, parameterTypes);
    }

    public static Method assignableMethod(Class cls, String name, Class ... parameterTypes) {
        return KernelReflect.assignableMethod(cls, name, 0, parameterTypes);
    }

    public static Method assignableMethod(Class cls, String name, int ancest, Class ... parameterTypes) {
        return KernelReflect.assignableMethod(cls, name, ancest, false, parameterTypes);
    }

    public static Method assignableMethod(Class cls, String name, int ancest, boolean declared, Class ... parameterTypes) {
        return KernelReflect.assignableMethod(cls, name, ancest, declared, true, true, parameterTypes);
    }

    public static Method assignableMethod(Class cls, final String name, int ancest, boolean declared, boolean assignable, boolean cacheable, final Class ... parameterTypes) {
        AccessibleObject method;
        String class_method_key = null;
        if (cacheable && (method = Class_Method_Map_Method.get(class_method_key = String.valueOf(cls.getName()) + ":" + name + ":" + parameterTypes.length)) != null && KernelClass.isMatchableFrom(((Method)method).getParameterTypes(), parameterTypes)) {
            return method;
        }
        method = null;
        while (cls != null) {
            if (assignable && parameterTypes.length > 0) {
                final ArrayList matchMethods = new ArrayList();
                KernelLang.CallbackBreak<Method> callback = new KernelLang.CallbackBreak<Method>(){

                    @Override
                    public void doWith(Method template) throws KernelLang.BreakException {
                        if (template.getName().equals(name) && KernelClass.isMatchableFrom(template.getParameterTypes(), parameterTypes)) {
                            for (Method method : matchMethods) {
                                if (!KernelArray.equal(method.getParameterTypes(), template.getParameterTypes())) continue;
                                return;
                            }
                            matchMethods.add(template);
                        }
                    }
                };
                if (declared) {
                    KernelReflect.doWithDeclaredMethods(cls, callback);
                } else {
                    KernelReflect.doWithMethods(cls, callback);
                }
                if (matchMethods.size() > 0) {
                    if (matchMethods.size() == 1) {
                        method = (Method)matchMethods.get(0);
                    } else {
                        cacheable = false;
                        int similar = -2;
                        for (Method match : matchMethods) {
                            int sim = KernelClass.similar(parameterTypes, match.getParameterTypes());
                            if (similar >= sim) continue;
                            similar = sim;
                            method = match;
                        }
                    }
                }
            } else {
                try {
                    method = declared ? cls.getDeclaredMethod(name, parameterTypes) : cls.getMethod(name, parameterTypes);
                    break;
                }
                catch (SecurityException e) {
                    break;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
            }
            cls = ancest < 1 || ancest-- != 1 ? cls.getSuperclass() : null;
        }
        if (method != null) {
            if (declared && !method.isAccessible()) {
                ((Method)method).setAccessible(true);
            }
            if (cacheable) {
                Class_Method_Map_Method.put(class_method_key, (Method)method);
            }
        }
        return method;
    }

    public static Object invoke(Object obj, Method method, Object ... args) {
        return KernelReflect.invoke(obj, null, method, args);
    }

    public static Object invoke(Object obj, Object defaultValue, Method method, Object ... args) {
        if (method != null) {
            try {
                return method.invoke(obj, args);
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    public static void doWithClasses(Class cls, KernelLang.CallbackBreak<Class<?>> callback) {
        KernelReflect.doWithClasses(cls, callback, null);
    }

    public static void doWithClasses(Class cls, KernelLang.CallbackBreak<Class<?>> callback, Class superClass) {
        try {
            while (cls != null && cls != Object.class && cls != superClass) {
                callback.doWith(cls);
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }

    public static void doWithFields(Class cls, KernelLang.CallbackBreak<Field> callback) {
        KernelReflect.doWithFields(cls, callback, null);
    }

    public static void doWithFields(Class cls, KernelLang.CallbackBreak<Field> callback, Class superClass) {
        try {
            while (cls != null && cls != Object.class && cls != superClass) {
                Field[] fieldArray = cls.getFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    callback.doWith(field);
                    ++n2;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }

    public static void doWithDeclaredFields(Class cls, KernelLang.CallbackBreak<Field> callback) {
        KernelReflect.doWithDeclaredFields(cls, callback, null);
    }

    public static void doWithDeclaredFields(Class cls, KernelLang.CallbackBreak<Field> callback, Class superClass) {
        try {
            while (cls != null && cls != Object.class && cls != superClass) {
                Field[] fieldArray = cls.getDeclaredFields();
                int n = fieldArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Field field = fieldArray[n2];
                    callback.doWith(field);
                    ++n2;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }

    public static void doWithMethods(Class cls, KernelLang.CallbackBreak<Method> callback) {
        KernelReflect.doWithMethods(cls, callback, null);
    }

    public static void doWithMethods(Class cls, KernelLang.CallbackBreak<Method> callback, Class superClass) {
        try {
            while (cls != null && cls != Object.class && cls != superClass) {
                Method[] methodArray = cls.getMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    callback.doWith(method);
                    ++n2;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }

    public static void doWithDeclaredMethods(Class cls, KernelLang.CallbackBreak<Method> callback) {
        KernelReflect.doWithDeclaredMethods(cls, callback, null);
    }

    public static void doWithDeclaredMethods(Class cls, KernelLang.CallbackBreak<Method> callback, Class superClass) {
        try {
            while (cls != null && cls != Object.class && cls != superClass) {
                Method[] methodArray = cls.getDeclaredMethods();
                int n = methodArray.length;
                int n2 = 0;
                while (n2 < n) {
                    Method method = methodArray[n2];
                    callback.doWith(method);
                    ++n2;
                }
                cls = cls.getSuperclass();
            }
        }
        catch (KernelLang.BreakException breakException) {
            // empty catch block
        }
    }
}

