/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.core.kernel;

import com.android.pc.ioc.core.kernel.KernelLang;
import java.util.Collection;
import java.util.Map;

public abstract class KernelString {
    public static final int SEQUENCE_SIZE = 26;

    public static String valueOf(Object object) {
        if (object == null) {
            return null;
        }
        return String.valueOf(object);
    }

    public static boolean empty(String string) {
        return "".equals(string);
    }

    public static boolean isEmpty(String string) {
        return string == null || KernelString.empty(string);
    }

    public static String capitalize(String string) {
        char[] data = string.toCharArray();
        data[0] = Character.toLowerCase(data[0]);
        return String.valueOf(data);
    }

    public static String uncapitalize(String string) {
        char[] data = string.toCharArray();
        if (data.length < 2 || data[1] > 'Z' || data[1] < 'A') {
            data[0] = Character.toUpperCase(data[0]);
        }
        return String.valueOf(data);
    }

    public static String lastString(String str, char ch) {
        int index = str.lastIndexOf(ch);
        if (index >= 0) {
            str = str.substring(index + 1);
        }
        return str;
    }

    public static String lastSubString(String str, char ch) {
        int index = str.lastIndexOf(ch);
        if (index >= 0) {
            str = str.substring(0, index - 1);
        }
        return str;
    }

    public static String leftString(String string, int length) {
        return string.substring(0, length);
    }

    public static String leftSubString(String string, int length) {
        return string.substring(length);
    }

    public static String rightString(String string, int length) {
        return string.substring(string.length() - length);
    }

    public static String rightSubString(String string, int length) {
        return string.substring(0, string.length() - length);
    }

    public static boolean matchStrings(String str, String[] strs) {
        if (strs == null) {
            return false;
        }
        String[] stringArray = strs;
        int n = strs.length;
        int n2 = 0;
        while (n2 < n) {
            String string = stringArray[n2];
            if (str.indexOf(string) >= 0) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    public static String replaceLast(String string, String target, String replacement) {
        if (KernelString.isEmpty(string) || KernelString.isEmpty(target)) {
            return string;
        }
        int index = string.lastIndexOf(target);
        return String.valueOf(string.substring(0, index)) + replacement + string.substring(index + target.length());
    }

    public static String getSequenceString(int sequence) {
        StringBuilder stringBuilder = new StringBuilder();
        while ((sequence -= 26) > 26) {
            stringBuilder.append('z');
        }
        if (sequence >= 0) {
            stringBuilder.append((char)sequence);
        }
        return stringBuilder.toString();
    }

    public static String nextSequenceString(String sequence) {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(KernelString.rightSubString(sequence, 1));
        char chr = (char)(sequence.charAt(sequence.length() - 1) + '\u0001');
        if (chr <= 'z') {
            stringBuilder.append(chr);
        } else {
            stringBuilder.append("za");
        }
        return stringBuilder.toString();
    }

    public static int compare(String str, String to) {
        return KernelString.compare(str, to, str.length(), to.length());
    }

    public static int compare(String str, String to, int m, int n) {
        if (m == 0) {
            return n;
        }
        if (n == 0) {
            return m;
        }
        int[][] matrix = new int[m + 1][n + 1];
        int i = 0;
        while (i <= m) {
            matrix[i][0] = i;
            ++i;
        }
        int j = 0;
        while (j <= n) {
            matrix[0][j] = j;
            ++j;
        }
        i = 0;
        while (i < m) {
            char chr = str.charAt(i);
            int j2 = 0;
            while (j2 < n) {
                matrix[i + 1][j2 + 1] = KernelLang.min(matrix[i][j2 + 1] + 1, matrix[i + 1][j2] + 1, matrix[i][j2] + (chr == to.charAt(j2) ? 0 : 1));
                ++j2;
            }
            ++i;
        }
        return matrix[m][n];
    }

    public static float similar(String str, String to) {
        if (str == to) {
            return 1.0f;
        }
        if (str == null) {
            return 0.0f;
        }
        int m = str.length();
        int n = to.length();
        if (m == 0 && n == 0) {
            return 1.0f;
        }
        return 1.0f - (float)KernelString.compare(str, to, m, n) / (float)Math.max(str.length(), to.length());
    }

    public static String implode(Object[] array, String ... glues) {
        return KernelString.implode(array, null, null, glues);
    }

    public static String implode(Object[] array, ImplodeBuilder imploder, Object target, String ... glues) {
        StringBuilder builder = new StringBuilder();
        String glue = null;
        int index = 0;
        int length = glues.length;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object value = objectArray[n2];
            if (imploder == null) {
                if (glue != null) {
                    builder.append(glue);
                }
                builder.append(value);
            } else {
                KernelString.implode(builder, imploder, glue, index, value, target);
            }
            if (++index >= length) {
                index = 0;
            }
            glue = glues[index];
            ++n2;
        }
        return builder.toString();
    }

    public static String implode(Collection collection, String ... glues) {
        return KernelString.implode(collection, null, null, glues);
    }

    public static String implode(Collection collection, ImplodeBuilder imploder, Object target, String ... glues) {
        StringBuilder builder = new StringBuilder();
        String glue = null;
        int index = 0;
        int length = glues.length;
        for (Object value : collection) {
            if (imploder == null) {
                if (glue != null) {
                    builder.append(glue);
                }
                builder.append(value);
            } else {
                KernelString.implode(builder, imploder, glue, index, value, target);
            }
            if (++index >= length) {
                index = 0;
            }
            glue = glues[index];
        }
        return builder.toString();
    }

    public static String implode(Map map, String ... glues) {
        return KernelString.implode(map, null, null, glues);
    }

    public static String implode(Map<?, ?> map, ImplodeBuilder imploder, Object target, String ... glues) {
        StringBuilder builder = new StringBuilder();
        String glue = null;
        int index = 0;
        int length = glues.length;
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            if (imploder == null) {
                if (glue != null) {
                    builder.append(glue);
                }
                builder.append(entry.getKey());
            } else {
                KernelString.implode(builder, imploder, glue, index, entry.getKey(), target);
            }
            if (++index >= length) {
                index = 0;
            }
            glue = glues[index];
            if (imploder == null) {
                if (glue != null) {
                    builder.append(glue);
                }
                builder.append(entry.getValue());
            } else {
                KernelString.implode(builder, imploder, (Object)glue, index, entry.getValue(), target);
            }
            if (++index >= length) {
                index = 0;
            }
            glue = glues[index];
        }
        return builder.toString();
    }

    protected static void implode(StringBuilder builder, ImplodeBuilder imploder, Object glue, int index, Object value, Object target) {
        Object result = imploder.glue((String)glue, index, value, target);
        if (result instanceof Object[]) {
            Object[] res = (Object[])result;
            if (res.length > 1) {
                glue = res[0];
                value = res[1];
            }
            result = null;
        }
        if (result == null) {
            if (glue != null) {
                builder.append(glue);
            }
            if (value != null) {
                builder.append(value);
            }
        } else {
            builder.append(result);
        }
    }

    public static interface ImplodeBuilder {
        public Object glue(String var1, int var2, Object var3, Object var4);
    }
}

