/*
 * Decompiled with CFR 0.152.
 */
package com.android.pc.ioc.db.sqlite;

import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.text.TextUtils;
import com.android.pc.ioc.app.Ioc;
import com.android.pc.ioc.db.sqlite.CursorUtils;
import com.android.pc.ioc.db.sqlite.DbModelSelector;
import com.android.pc.ioc.db.sqlite.IOUtils;
import com.android.pc.ioc.db.sqlite.Selector;
import com.android.pc.ioc.db.sqlite.SqlInfo;
import com.android.pc.ioc.db.sqlite.SqlInfoBuilder;
import com.android.pc.ioc.db.sqlite.WhereBuilder;
import com.android.pc.ioc.db.table.DbModel;
import com.android.pc.ioc.db.table.Id;
import com.android.pc.ioc.db.table.KeyValue;
import com.android.pc.ioc.db.table.Table;
import com.android.pc.ioc.db.table.TableUtils;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;

public class DbUtils {
    private static HashMap<String, DbUtils> daoMap = new HashMap();
    private SQLiteDatabase database;
    private DaoConfig config;
    private boolean debug = false;
    private boolean allowTransaction = false;
    private final FindTempCache findTempCache = new FindTempCache();

    private DbUtils(DaoConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("daoConfig may not be null");
        }
        if (config.getContext() == null) {
            throw new IllegalArgumentException("context mey not be null");
        }
        String sdCardPath = config.getSdCardPath();
        this.database = TextUtils.isEmpty((CharSequence)sdCardPath) ? new SQLiteDbHelper(config).getWritableDatabase() : this.createDbFileOnSDCard(config);
        this.config = config;
    }

    private static synchronized DbUtils getInstance(DaoConfig daoConfig) {
        DbUtils dao = daoMap.get(daoConfig.getDbName());
        if (dao == null) {
            dao = new DbUtils(daoConfig);
            daoMap.put(daoConfig.getDbName(), dao);
        } else {
            dao.config = daoConfig;
        }
        return dao;
    }

    public static DbUtils create(Context context) {
        DaoConfig config = new DaoConfig(context);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbName) {
        DaoConfig config = new DaoConfig(context);
        config.setDbName(dbName);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String sdCardPath, String dbName) {
        DaoConfig config = new DaoConfig(context);
        config.setSdCardPath(sdCardPath);
        config.setDbName(dbName);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String dbName, int dbVersion, DbUpgradeListener dbUpgradeListener) {
        DaoConfig config = new DaoConfig(context);
        config.setDbName(dbName);
        config.setDbVersion(dbVersion);
        config.setDbUpgradeListener(dbUpgradeListener);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(Context context, String sdCardPath, String dbName, int dbVersion, DbUpgradeListener dbUpgradeListener) {
        DaoConfig config = new DaoConfig(context);
        config.setSdCardPath(sdCardPath);
        config.setDbName(dbName);
        config.setDbVersion(dbVersion);
        config.setDbUpgradeListener(dbUpgradeListener);
        return DbUtils.getInstance(config);
    }

    public static DbUtils create(DaoConfig daoConfig) {
        return DbUtils.getInstance(daoConfig);
    }

    public DbUtils configDebug(boolean debug) {
        this.debug = debug;
        return this;
    }

    public DbUtils configAllowTransaction(boolean allowTransaction) {
        this.allowTransaction = allowTransaction;
        return this;
    }

    public SQLiteDatabase getDatabase() {
        return this.database;
    }

    public String getSdCardPath() {
        return this.config.getSdCardPath();
    }

    public void saveOrUpdate(Object entity) {
        try {
            this.beginTransaction();
            this.saveOrUpdateWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void saveOrUpdateAll(List<?> entities) {
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.saveOrUpdateWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void replace(Object entity) {
        try {
            this.beginTransaction();
            this.replaceWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void replaceAll(List<?> entities) {
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.replaceWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void save(Object entity) {
        try {
            this.beginTransaction();
            this.saveWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void saveAll(List<?> entities) {
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.saveWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public boolean saveBindingId(Object entity) {
        boolean result = false;
        try {
            this.beginTransaction();
            result = this.saveBindingIdWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
        return result;
    }

    public void saveBindingIdAll(List<?> entities) {
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                if (this.saveBindingIdWithoutTransaction(entity)) continue;
                Ioc.getIoc().getLogger().e("saveBindingId error, transaction will not commit!");
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void delete(Object entity) {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.deleteWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteAll(List<?> entities) {
        if (entities == null || entities.size() < 1 || !this.tableIsExist(entities.get(0).getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.deleteWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void deleteById(Class<?> entityType, Object idValue) {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        try {
            try {
                this.beginTransaction();
                this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entityType, idValue));
                this.setTransactionSuccessful();
            }
            catch (Exception e) {
                Ioc.getIoc().getLogger().e(e);
                this.endTransaction();
            }
        }
        finally {
            this.endTransaction();
        }
    }

    public void delete(Class<?> entityType, WhereBuilder whereBuilder) {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        try {
            this.beginTransaction();
            SqlInfo sql = SqlInfoBuilder.buildDeleteSqlInfo(entityType, whereBuilder);
            this.execNonQuery(sql);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void update(Object entity) {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.updateWithoutTransaction(entity);
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void updateAll(List<?> entities) {
        if (entities == null || entities.size() < 1 || !this.tableIsExist(entities.get(0).getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            for (Object entity : entities) {
                this.updateWithoutTransaction(entity);
            }
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public void update(Object entity, WhereBuilder whereBuilder) {
        if (!this.tableIsExist(entity.getClass())) {
            return;
        }
        try {
            this.beginTransaction();
            this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity, whereBuilder));
            this.setTransactionSuccessful();
        }
        finally {
            this.endTransaction();
        }
    }

    public <T> T findById(Class<T> entityType, Object idValue) {
        if (!this.tableIsExist(entityType)) {
            return null;
        }
        Id id = Table.get(entityType).getId();
        Selector selector = Selector.from(entityType).where(id.getColumnName(), "=", idValue);
        String sql = selector.limit(1).toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (T)obj;
        }
        Cursor cursor = this.execQuery(sql);
        try {
            if (cursor.moveToNext()) {
                T entity = CursorUtils.getEntity(this, cursor, entityType, seq);
                this.findTempCache.put(sql, entity);
                T t = entity;
                return t;
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return null;
    }

    public <T> T findFirst(Selector selector) {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        String sql = selector.limit(1).toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (T)obj;
        }
        Cursor cursor = this.execQuery(sql);
        try {
            if (cursor.moveToNext()) {
                Object entity = CursorUtils.getEntity(this, cursor, selector.getEntityType(), seq);
                this.findTempCache.put(sql, entity);
                Object obj2 = entity;
                return (T)obj2;
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return null;
    }

    public <T> T findFirst(Object entity) {
        if (!this.tableIsExist(entity.getClass())) {
            return null;
        }
        Selector selector = Selector.from(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null) {
            WhereBuilder wb = WhereBuilder.b();
            for (KeyValue keyValue : entityKvList) {
                wb.append(keyValue.getKey(), "=", keyValue.getValue());
            }
            selector.where(wb);
        }
        return this.findFirst(selector);
    }

    public <T> List<T> findAll(Selector selector) {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        String sql = selector.toString();
        long seq = CursorUtils.FindCacheSequence.getSeq();
        this.findTempCache.setSeq(seq);
        Object obj = this.findTempCache.get(sql);
        if (obj != null) {
            return (List)obj;
        }
        Cursor cursor = this.execQuery(sql);
        ArrayList result = new ArrayList();
        try {
            while (cursor.moveToNext()) {
                Object entity = CursorUtils.getEntity(this, cursor, selector.getEntityType(), seq);
                result.add(entity);
            }
            this.findTempCache.put(sql, result);
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return result;
    }

    public <T> List<T> findAll(Object entity) {
        if (!this.tableIsExist(entity.getClass())) {
            return null;
        }
        Selector selector = Selector.from(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null) {
            WhereBuilder wb = WhereBuilder.b();
            for (KeyValue keyValue : entityKvList) {
                wb.append(keyValue.getKey(), "=", keyValue.getValue());
            }
            selector.where(wb);
        }
        return this.findAll(selector);
    }

    public DbModel findDbModelFirst(SqlInfo sqlInfo) {
        Cursor cursor = this.execQuery(sqlInfo);
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return null;
    }

    public DbModel findDbModelFirst(DbModelSelector selector) {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        Cursor cursor = this.execQuery(selector.limit(1).toString());
        try {
            if (cursor.moveToNext()) {
                DbModel dbModel = CursorUtils.getDbModel(cursor);
                return dbModel;
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return null;
    }

    public List<DbModel> findDbModelAll(SqlInfo sqlInfo) {
        Cursor cursor = this.execQuery(sqlInfo);
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        try {
            while (cursor.moveToNext()) {
                dbModelList.add(CursorUtils.getDbModel(cursor));
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return dbModelList;
    }

    public List<DbModel> findDbModelAll(DbModelSelector selector) {
        if (!this.tableIsExist(selector.getEntityType())) {
            return null;
        }
        Cursor cursor = this.execQuery(selector.toString());
        ArrayList<DbModel> dbModelList = new ArrayList<DbModel>();
        try {
            while (cursor.moveToNext()) {
                dbModelList.add(CursorUtils.getDbModel(cursor));
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
        return dbModelList;
    }

    private SQLiteDatabase createDbFileOnSDCard(DaoConfig config) {
        int newVersion;
        int oldVersion;
        SQLiteDatabase result = null;
        File dbFile = new File(config.getSdCardPath(), config.getDbName());
        boolean dbFileExists = dbFile.exists();
        result = SQLiteDatabase.openOrCreateDatabase((File)dbFile, null);
        if (result != null && (oldVersion = result.getVersion()) != (newVersion = config.getDbVersion())) {
            if (dbFileExists && config.getDbUpgradeListener() != null) {
                config.getDbUpgradeListener().onUpgrade(result, oldVersion, newVersion);
            }
            result.setVersion(newVersion);
        }
        return result;
    }

    private void saveOrUpdateWithoutTransaction(Object entity) {
        if (TableUtils.getIdValue(entity) != null) {
            this.updateWithoutTransaction(entity);
        } else {
            this.saveBindingIdWithoutTransaction(entity);
        }
    }

    private void replaceWithoutTransaction(Object entity) {
        this.createTableIfNotExist(entity.getClass());
        this.execNonQuery(SqlInfoBuilder.buildReplaceSqlInfo(this, entity));
    }

    private void saveWithoutTransaction(Object entity) {
        this.createTableIfNotExist(entity.getClass());
        this.execNonQuery(SqlInfoBuilder.buildInsertSqlInfo(this, entity));
    }

    private boolean saveBindingIdWithoutTransaction(Object entity) {
        this.createTableIfNotExist(entity.getClass());
        List<KeyValue> entityKvList = SqlInfoBuilder.entity2KeyValueList(this, entity);
        if (entityKvList != null && entityKvList.size() > 0) {
            Table table = Table.get(entity.getClass());
            ContentValues cv = new ContentValues();
            DbUtils.fillContentValues(cv, entityKvList);
            Long id = this.database.insert(table.getTableName(), null, cv);
            if (id == -1L) {
                return false;
            }
            table.getId().setValue2Entity(entity, id.toString());
            return true;
        }
        return false;
    }

    private void deleteWithoutTransaction(Object entity) {
        try {
            this.execNonQuery(SqlInfoBuilder.buildDeleteSqlInfo(entity));
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    private void updateWithoutTransaction(Object entity) {
        try {
            this.execNonQuery(SqlInfoBuilder.buildUpdateSqlInfo(this, entity));
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    private static void fillContentValues(ContentValues contentValues, List<KeyValue> list) {
        if (list != null && contentValues != null) {
            for (KeyValue kv : list) {
                contentValues.put(kv.getKey(), kv.getValue().toString());
            }
        } else {
            Ioc.getIoc().getLogger().w("List<KeyValue> is empty or ContentValues is empty!");
        }
    }

    private void createTableIfNotExist(Class<?> entityType) {
        if (!this.tableIsExist(entityType)) {
            SqlInfo sqlInfo = SqlInfoBuilder.buildCreateTableSqlInfo(entityType);
            this.execNonQuery(sqlInfo);
        }
    }

    public boolean tableIsExist(Class<?> entityType) {
        Cursor cursor;
        block3: {
            Table table = Table.get(entityType);
            if (table.isCheckDatabase()) {
                return true;
            }
            cursor = null;
            try {
                int count;
                cursor = this.execQuery("SELECT COUNT(*) AS c FROM sqlite_master WHERE type ='table' AND name ='" + table.getTableName() + "'");
                if (cursor == null || !cursor.moveToNext() || (count = cursor.getInt(0)) <= 0) break block3;
                table.setCheckDatabase(true);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(cursor);
                throw throwable;
            }
            IOUtils.closeQuietly(cursor);
            return true;
        }
        IOUtils.closeQuietly(cursor);
        return false;
    }

    public void dropDb() {
        Cursor cursor = null;
        try {
            cursor = this.execQuery("SELECT name FROM sqlite_master WHERE type ='table'");
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    try {
                        this.execNonQuery("DROP TABLE " + cursor.getString(0));
                    }
                    catch (Exception e) {
                        Ioc.getIoc().getLogger().e(e);
                    }
                }
            }
        }
        finally {
            IOUtils.closeQuietly(cursor);
        }
    }

    public void dropTable(Class<?> entityType) {
        if (!this.tableIsExist(entityType)) {
            return;
        }
        Table table = Table.get(entityType);
        this.execNonQuery("DROP TABLE " + table.getTableName());
    }

    private void debugSql(String sql) {
        if (this.config != null && this.debug) {
            Ioc.getIoc().getLogger().d(sql);
        }
    }

    private void beginTransaction() {
        if (this.allowTransaction) {
            this.database.beginTransaction();
        }
    }

    private void setTransactionSuccessful() {
        if (this.allowTransaction) {
            this.database.setTransactionSuccessful();
        }
    }

    private void endTransaction() {
        if (this.allowTransaction) {
            this.database.endTransaction();
        }
    }

    public void execNonQuery(SqlInfo sqlInfo) {
        this.debugSql(sqlInfo.getSql());
        try {
            if (sqlInfo.getBindArgs() != null) {
                this.database.execSQL(sqlInfo.getSql(), sqlInfo.getBindArgsAsArray());
            } else {
                this.database.execSQL(sqlInfo.getSql());
            }
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    public void execNonQuery(String sql) {
        this.debugSql(sql);
        try {
            this.database.execSQL(sql);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    public void deleteAll(Class clazz) {
        try {
            Table table = Table.get(clazz);
            this.database.delete(table.getTableName(), null, null);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
        }
    }

    public Cursor execQuery(SqlInfo sqlInfo) {
        this.debugSql(sqlInfo.getSql());
        try {
            return this.database.rawQuery(sqlInfo.getSql(), sqlInfo.getBindArgsAsStrArray());
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            return null;
        }
    }

    public Cursor execQuery(String sql) {
        this.debugSql(sql);
        try {
            return this.database.rawQuery(sql, null);
        }
        catch (Exception e) {
            Ioc.getIoc().getLogger().e(e);
            return null;
        }
    }

    public static class DaoConfig {
        private Context context;
        private String dbName = "xUtils.db";
        private int dbVersion = 1;
        private DbUpgradeListener dbUpgradeListener;
        private String sdCardPath;

        public DaoConfig(Context context) {
            this.context = context;
        }

        public Context getContext() {
            return this.context;
        }

        public String getDbName() {
            return this.dbName;
        }

        public void setDbName(String dbName) {
            this.dbName = dbName;
        }

        public int getDbVersion() {
            return this.dbVersion;
        }

        public void setDbVersion(int dbVersion) {
            this.dbVersion = dbVersion;
        }

        public DbUpgradeListener getDbUpgradeListener() {
            return this.dbUpgradeListener;
        }

        public void setDbUpgradeListener(DbUpgradeListener dbUpgradeListener) {
            this.dbUpgradeListener = dbUpgradeListener;
        }

        public String getSdCardPath() {
            return this.sdCardPath;
        }

        public void setSdCardPath(String sdCardPath) {
            this.sdCardPath = sdCardPath;
        }
    }

    public static interface DbUpgradeListener {
        public void onUpgrade(SQLiteDatabase var1, int var2, int var3);
    }

    private class FindTempCache {
        private final ConcurrentHashMap<String, Object> cache = new ConcurrentHashMap();
        private long seq = 0L;

        private FindTempCache() {
        }

        public void put(String sql, Object result) {
            this.cache.put(sql, result);
        }

        public Object get(String sql) {
            return this.cache.get(sql);
        }

        public void setSeq(long seq) {
            if (this.seq != seq) {
                this.cache.clear();
                this.seq = seq;
            }
        }
    }

    private class SQLiteDbHelper
    extends SQLiteOpenHelper {
        private DbUpgradeListener mDbUpgradeListener;

        public SQLiteDbHelper(DaoConfig config) {
            super(config.getContext(), config.getDbName(), null, config.getDbVersion());
            this.mDbUpgradeListener = config.getDbUpgradeListener();
        }

        public void onCreate(SQLiteDatabase db) {
        }

        public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
            if (this.mDbUpgradeListener != null) {
                this.mDbUpgradeListener.onUpgrade(db, oldVersion, newVersion);
            } else {
                try {
                    DbUtils.this.dropDb();
                }
                catch (Exception e) {
                    Ioc.getIoc().getLogger().e(e);
                }
            }
        }
    }
}

